/*
* Copyright (C) 2009 Mamadou Diop.
*
* Contact: Mamadou Diop <diopmamadou(at)doubango.org>
*	
* This file is part of Open Source Doubango Framework.
*
* DOUBANGO is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*	
* DOUBANGO is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU Lesser General Public License for more details.
*	
* You should have received a copy of the GNU General Public License
* along with DOUBANGO.
*
*/
#ifndef _TEST_PARSER_H_
#define _TEST_PARSER_H_

char packet_0[] = {
0x80, 0x88, 0x00, 0x01, 0x00, 0x00, 0x00, 0xa0, 
0xd2, 0xbd, 0x4e, 0x3e, 0xdc, 0xde, 0xc4, 0xc5, 
0xdc, 0xd0, 0xd5, 0x51, 0x53, 0x5d, 0x5f, 0x5b, 
0x46, 0x46, 0x46, 0x5b, 0x44, 0x41, 0x42, 0x4f, 
0x42, 0x47, 0x42, 0x43, 0x59, 0x58, 0x59, 0x5f, 
0x5f, 0x52, 0x59, 0x44, 0x44, 0x5f, 0x51, 0x54, 
0x55, 0x55, 0x51, 0x56, 0x50, 0x52, 0x5e, 0x58, 
0x5d, 0x52, 0x52, 0x50, 0x57, 0x54, 0xd4, 0xd6, 
0xd5, 0x51, 0x53, 0x57, 0xd6, 0xd6, 0xd0, 0xd7, 
0x57, 0x56, 0x57, 0xd0, 0xd3, 0xd6, 0xd5, 0x55, 
0x51, 0x50, 0xd6, 0xdf, 0xd2, 0xd1, 0xd4, 0xd6, 
0xdc, 0xdb, 0xda, 0xdd, 0xd6, 0x55, 0xdc, 0xd0, 
0xd4, 0x5d, 0x44, 0x5c, 0x56, 0xd6, 0xd5, 0xd4, 
0xd5, 0xd7, 0x50, 0xd4, 0x51, 0xd0, 0x61, 0x6f, 
0x76, 0xfe, 0xef, 0xf7, 0x77, 0x66, 0x50, 0xff, 
0xe5, 0xd7, 0x74, 0x4a, 0xc9, 0xf9, 0xf7, 0x5c, 
0x76, 0x5f, 0xf5, 0xf3, 0xdd, 0x4e, 0x42, 0xd8, 
0xf7, 0xc9, 0x50, 0x44, 0x50, 0xcd, 0xc9, 0xd4, 
0x4d, 0x41, 0x57, 0xd1, 0x51, 0x58, 0x44, 0x52, 
0xd3, 0xd1, 0x50, 0x58, 0x5b, 0x55, 0xd4, 0x53, 
0x59, 0x43, 0x47, 0x5f, 0x51, 0x5d, 0x56, 0xd2, 
0xde, 0xd7, 0x52, 0xd5 };
char packet_1[] = {
0x80, 0x08, 0x00, 0x02, 0x00, 0x00, 0x01, 0x40, 
0xd2, 0xbd, 0x4e, 0x3e, 0xd2, 0xc7, 0xc5, 0xd3, 
0xd1, 0xd6, 0xd5, 0x55, 0xd2, 0xd2, 0xd3, 0xdf, 
0xc4, 0xd9, 0xdb, 0xc6, 0xc6, 0xc9, 0xc1, 0xf5, 
0xcf, 0xf0, 0xcb, 0xe4, 0x7d, 0x14, 0x7a, 0xfd, 
0xfd, 0x62, 0x63, 0x41, 0xee, 0xe7, 0x40, 0x6c, 
0x46, 0xf8, 0xf3, 0x74, 0x7b, 0x58, 0xf3, 0xf1, 
0xd6, 0x5d, 0xc7, 0xfd, 0xff, 0xf5, 0x55, 0xd9, 
0xcb, 0xcb, 0xde, 0xd1, 0xda, 0xca, 0xcd, 0xc5, 
0xc4, 0x41, 0x72, 0x41, 0x55, 0xda, 0x54, 0x5c, 
0x40, 0x59, 0xd1, 0x5f, 0x4b, 0x40, 0x51, 0x52, 
0x45, 0x4b, 0x77, 0x49, 0x4e, 0x4e, 0x48, 0x4a, 
0x75, 0x47, 0x75, 0x7b, 0x72, 0x42, 0x58, 0x4c, 
0x46, 0xd5, 0xc2, 0xd1, 0x5d, 0x44, 0x50, 0xd0, 
0x53, 0x43, 0x41, 0x52, 0x53, 0x5a, 0x44, 0x50, 
0xdd, 0x45, 0x65, 0x7d, 0x74, 0x4c, 0x70, 0x43, 
0x53, 0xc4, 0xc5, 0x5b, 0x5a, 0x5c, 0x51, 0x4f, 
0x70, 0x4a, 0x58, 0x5e, 0x75, 0x76, 0x40, 0x57, 
0x51, 0x46, 0x5e, 0x5c, 0xd5, 0x5c, 0x5c, 0x5e, 
0x5e, 0x4d, 0x41, 0x44, 0xd4, 0xd6, 0xd5, 0x52, 
0x54, 0xdd, 0xd7, 0xd3, 0x56, 0x51, 0x55, 0xdf, 
0x54, 0xd1, 0xd2, 0xda };
char packet_2[] = {
0x80, 0x08, 0x00, 0x03, 0x00, 0x00, 0x01, 0xe0, 
0xd2, 0xbd, 0x4e, 0x3e, 0xdb, 0xd1, 0xd5, 0xd0, 
0xd2, 0xd3, 0x57, 0xd5, 0xd6, 0xd6, 0xd1, 0xd5, 
0xd1, 0xdd, 0xd5, 0xd1, 0xd1, 0xd4, 0x5f, 0x56, 
0x5f, 0x5a, 0x53, 0x59, 0x5c, 0x5f, 0x5d, 0x5d, 
0xd6, 0xd0, 0xd8, 0x54, 0xc4, 0xd9, 0xc6, 0xdc, 
0x57, 0x56, 0x56, 0x57, 0x51, 0x54, 0x53, 0x57, 
0x59, 0x44, 0x44, 0x5e, 0x45, 0x45, 0x5a, 0x5e, 
0x53, 0x58, 0x4c, 0x45, 0x59, 0x45, 0x5b, 0x57, 
0x52, 0x5e, 0x5e, 0x59, 0x5c, 0x51, 0xd7, 0xd0, 
0xc5, 0xc1, 0xd8, 0xc1, 0xcd, 0xcd, 0xc2, 0xcd, 
0xc6, 0xcc, 0xc0, 0xc6, 0xc1, 0xc9, 0xcb, 0xdb, 
0xd0, 0xdd, 0xc6, 0xd8, 0xd5, 0x5f, 0x41, 0x46, 
0x4f, 0x74, 0x76, 0x70, 0x72, 0x7f, 0x72, 0x77, 
0x49, 0x4a, 0x76, 0x4a, 0x44, 0x45, 0x44, 0x59, 
0x50, 0x55, 0xd3, 0xd9, 0xcc, 0xf7, 0xf1, 0xca, 
0xc2, 0xf7, 0xf8, 0xe7, 0xe7, 0xe2, 0xee, 0xe9, 
0xed, 0xe4, 0xc2, 0xcb, 0xf7, 0xd2, 0x48, 0x76, 
0x45, 0x77, 0x64, 0x64, 0x4a, 0x51, 0x46, 0x41, 
0xdd, 0xc2, 0xd4, 0x51, 0x50, 0x4a, 0x74, 0x71, 
0x7e, 0x61, 0x67, 0x7e, 0x67, 0x60, 0x67, 0x77, 
0x45, 0x43, 0x5f, 0xc8 };
char packet_3[] = {
0x80, 0x08, 0x2c, 0x43, 0x11, 0x47, 0x31, 0xa2, 
0x58, 0xf3, 0x3d, 0xea, 0x53, 0x45, 0x56, 0x47, 
0x5f, 0xd4, 0xd4, 0x55, 0x56, 0x58, 0x40, 0x53, 
0x54, 0xd5, 0xc7, 0xc4, 0x57, 0xd5, 0xdd, 0xd9, 
0xde, 0xdd, 0xdc, 0xd4, 0x55, 0x54, 0xdc, 0xcf, 
0xc7, 0x5e, 0x43, 0x5a, 0x5a, 0x43, 0x5b, 0x51, 
0x54, 0x51, 0xd6, 0xd4, 0x5b, 0x53, 0xd3, 0x57, 
0xd5, 0xc0, 0xc7, 0x53, 0x5d, 0xd1, 0xc5, 0xc1, 
0xd9, 0x5d, 0x57, 0xdc, 0xd0, 0xd0, 0x54, 0x45, 
0x44, 0x42, 0x45, 0xd0, 0xd4, 0xd5, 0xd9, 0xc7, 
0x57, 0x5e, 0x5f, 0x47, 0x56, 0xc5, 0xca, 0xc5, 
0xd3, 0xdf, 0x57, 0x43, 0x4b, 0x5a, 0x5c, 0x5f, 
0x45, 0x52, 0xd0, 0xc7, 0xcb, 0xc9, 0xc5, 0x5f, 
0x47, 0x57, 0x55, 0xdc, 0xc7, 0x5d, 0x4b, 0x5a, 
0xdb, 0xcf, 0xc5, 0x52, 0x43, 0x5a, 0x56, 0xde, 
0xdf, 0xd6, 0xd5, 0x45, 0x5b, 0xdc, 0xdb, 0x55, 
0x52, 0x54, 0x51, 0xd5, 0xc4, 0xdf, 0xd1, 0x56, 
0x51, 0xd5, 0xd3, 0xde, 0x54, 0x44, 0x46, 0x52, 
0x56, 0x5b, 0x5a, 0xd3, 0xc3, 0xdf, 0x57, 0xd1, 
0xd9, 0xd6, 0x5f, 0x5f, 0xd4, 0xd6, 0xd5, 0xd1, 
0x53, 0xd4, 0xc1, 0xdb, 0xdd, 0xd8, 0xd7, 0x47, 
0x4b, 0x75, 0x4c, 0x5c };
char packet_4[] = {
0x80, 0x08, 0x00, 0x04, 0x00, 0x00, 0x02, 0x80, 
0xd2, 0xbd, 0x4e, 0x3e, 0xff, 0xf3, 0xff, 0xe1, 
0xe7, 0xe4, 0xe5, 0xe2, 0xec, 0xef, 0xeb, 0xe9, 
0x95, 0x97, 0xf8, 0xcc, 0xe4, 0xf9, 0x58, 0x6d, 
0x72, 0x46, 0x7c, 0x62, 0x60, 0x42, 0x40, 0x70, 
0x4e, 0xd3, 0xcb, 0xda, 0xd9, 0x54, 0x57, 0xd6, 
0x4a, 0x62, 0x6e, 0x64, 0x60, 0x15, 0x15, 0x63, 
0x67, 0x62, 0x60, 0x7f, 0x46, 0x46, 0x40, 0xd5, 
0xcf, 0xf6, 0xc9, 0xcb, 0xf0, 0xfd, 0xf8, 0xe6, 
0xec, 0xe9, 0x94, 0x91, 0x96, 0xf7, 0xd0, 0xe7, 
0xf3, 0x7d, 0x6b, 0x7d, 0x5d, 0x65, 0x68, 0x61, 
0x5d, 0x5c, 0x72, 0x43, 0xcd, 0xf6, 0xdf, 0xd2, 
0xd2, 0x51, 0xdf, 0x49, 0x62, 0x14, 0x68, 0x6e, 
0x10, 0x11, 0x69, 0x64, 0x61, 0x6d, 0x64, 0x75, 
0x44, 0x74, 0x5e, 0xcf, 0xff, 0xf1, 0xc1, 0xf7, 
0xf6, 0xe5, 0xe4, 0xe6, 0xe9, 0x91, 0x93, 0x90, 
0x95, 0xce, 0xe5, 0xe0, 0xc7, 0x66, 0x62, 0x45, 
0x75, 0x63, 0x6e, 0x79, 0x55, 0x49, 0x71, 0x53, 
0xca, 0xcb, 0xd0, 0xdb, 0xd3, 0xd5, 0x5b, 0x67, 
0x6b, 0x15, 0x61, 0x69, 0x17, 0x14, 0x6c, 0x66, 
0x6f, 0x62, 0x7f, 0x48, 0x74, 0x75, 0x59, 0xd0, 
0xdb, 0x54, 0xd7, 0xc3 };
char packet_5[] = {
0x80, 0x08, 0x2c, 0x44, 0x11, 0x47, 0x32, 0x42, 
0x58, 0xf3, 0x3d, 0xea, 0x54, 0xd5, 0xde, 0xc4, 
0xc0, 0xce, 0xd8, 0xd5, 0xdc, 0xde, 0xd4, 0xd9, 
0x54, 0x4d, 0x74, 0x47, 0x44, 0x58, 0xc7, 0xc3, 
0xc4, 0xd4, 0x55, 0x50, 0x43, 0x45, 0xd4, 0xc7, 
0xcf, 0xc0, 0x55, 0x42, 0x48, 0x76, 0x4f, 0xd7, 
0xc7, 0xcf, 0xc6, 0xc6, 0xf5, 0xc6, 0x53, 0x5a, 
0x42, 0x5e, 0x51, 0xd6, 0xc4, 0xde, 0x56, 0x42, 
0x42, 0x5e, 0xd7, 0xd4, 0xdb, 0xcb, 0xda, 0xd6, 
0xd7, 0x53, 0x47, 0x4d, 0xd4, 0xdf, 0xdc, 0xd5, 
0x5a, 0x59, 0x5a, 0x5a, 0xd5, 0xc4, 0xd7, 0x55, 
0xc3, 0xce, 0xde, 0xd2, 0xd6, 0x46, 0x71, 0x7c, 
0x4c, 0xd8, 0xf5, 0xf7, 0xcf, 0x54, 0x56, 0xd5, 
0xdc, 0xda, 0xd7, 0xd7, 0x57, 0x5a, 0x5c, 0x52, 
0x47, 0x5c, 0xd4, 0xd3, 0xd4, 0x47, 0x42, 0x4d, 
0x54, 0xcf, 0xf3, 0xf0, 0xc0, 0xdb, 0xd1, 0x50, 
0x47, 0x5e, 0x58, 0x49, 0x43, 0x5a, 0x54, 0xdc, 
0x56, 0x56, 0xd9, 0xc8, 0xc2, 0xd2, 0x5d, 0x5a, 
0x5a, 0x49, 0x40, 0x57, 0xda, 0xdb, 0xd6, 0x55, 
0xdd, 0xcf, 0xdb, 0x5c, 0x51, 0xd0, 0xd5, 0x5f, 
0x53, 0xd8, 0xc3, 0xc3, 0xd0, 0x5c, 0x5b, 0x44, 
0x4e, 0x74, 0x4f, 0x56 };
char packet_6[] = {
0x80, 0x08, 0x00, 0x05, 0x00, 0x00, 0x03, 0x20, 
0xd2, 0xbd, 0x4e, 0x3e, 0xca, 0xf0, 0xfd, 0xe2, 
0xea, 0x96, 0x91, 0x91, 0xe7, 0xd9, 0xf9, 0xf9, 
0x48, 0x6b, 0x61, 0x74, 0x66, 0x15, 0x69, 0x74, 
0x42, 0x7d, 0x75, 0xd2, 0xf7, 0xc8, 0xc3, 0xd1, 
0x5f, 0x5f, 0x7d, 0x6f, 0x15, 0x6d, 0x6e, 0x16, 
0x16, 0x68, 0x61, 0x62, 0x6c, 0x66, 0x79, 0x7d, 
0x7f, 0x77, 0x5c, 0xd9, 0xdb, 0x5e, 0x55, 0xcf, 
0xf1, 0xf0, 0xe5, 0xef, 0x95, 0x96, 0x93, 0x97, 
0xcd, 0xc3, 0xe4, 0xf7, 0x64, 0x15, 0x7a, 0x73, 
0x60, 0x68, 0x64, 0xd1, 0x53, 0x4e, 0x5d, 0xf7, 
0xf9, 0xf3, 0xf5, 0xd5, 0xd4, 0x58, 0x67, 0x6e, 
0x6c, 0x61, 0x68, 0x14, 0x68, 0x61, 0x64, 0x63, 
0x61, 0x79, 0x75, 0x4b, 0x4f, 0x44, 0xd7, 0xcb, 
0xc0, 0xd8, 0xf6, 0xe4, 0xe1, 0xe7, 0xed, 0x97, 
0x91, 0x93, 0x9d, 0x96, 0xff, 0xfd, 0xe5, 0xc7, 
0x66, 0x67, 0x4d, 0x4e, 0x64, 0x62, 0x71, 0x54, 
0xd5, 0x5f, 0xd0, 0xce, 0xce, 0xdf, 0x5d, 0x73, 
0x72, 0x73, 0x6c, 0x15, 0x6d, 0x6d, 0x15, 0x14, 
0x69, 0x63, 0x62, 0x62, 0x66, 0x78, 0x72, 0x76, 
0x43, 0x5b, 0xd5, 0xc0, 0xd9, 0xdd, 0xca, 0xf8, 
0xe4, 0xe7, 0xef, 0x96 };
char packet_7[] = {
0x80, 0x08, 0x2c, 0x45, 0x11, 0x47, 0x32, 0xe2, 
0x58, 0xf3, 0x3d, 0xea, 0xdd, 0xd9, 0xd2, 0xd6, 
0xd0, 0xd6, 0xdf, 0xd7, 0xd7, 0x54, 0xd5, 0x57, 
0x57, 0xd0, 0xd4, 0x55, 0xd5, 0xd8, 0xdb, 0xc0, 
0xc2, 0x53, 0x58, 0x5d, 0x57, 0x5e, 0x47, 0x41, 
0x4a, 0x5f, 0xde, 0xd9, 0x55, 0xd0, 0xc5, 0xdd, 
0xd3, 0xdd, 0xc6, 0xc1, 0xd1, 0x52, 0x5b, 0xd1, 
0xcc, 0xd9, 0x43, 0x7a, 0x78, 0x4e, 0x55, 0xd2, 
0xc5, 0xc3, 0xda, 0xc5, 0xd4, 0xd3, 0xc7, 0xd2, 
0xd9, 0xdb, 0x55, 0x45, 0x59, 0x51, 0x59, 0xd4, 
0xc2, 0xc6, 0xd0, 0xd1, 0x59, 0x48, 0x40, 0x47, 
0x5a, 0x55, 0xd2, 0xdc, 0xd9, 0xc9, 0xf6, 0xd9, 
0x42, 0x72, 0x40, 0xd1, 0x50, 0xd7, 0xc4, 0xc9, 
0xc5, 0xc1, 0xc3, 0x54, 0x5b, 0x48, 0x43, 0x57, 
0xd3, 0xd1, 0x5c, 0x47, 0x47, 0x49, 0x47, 0x59, 
0xd1, 0xf5, 0xd8, 0xd6, 0xdd, 0xd8, 0x5c, 0x53, 
0xc7, 0xc9, 0xc9, 0xc0, 0xd4, 0x4d, 0x4f, 0x47, 
0x50, 0xdf, 0xce, 0xd8, 0x5d, 0x43, 0x40, 0x5f, 
0xd1, 0x56, 0x58, 0xd0, 0xd0, 0xd0, 0xdb, 0x55, 
0x5b, 0x5b, 0xd4, 0xda, 0xc0, 0xc6, 0xd4, 0x58, 
0x5a, 0xd8, 0xc7, 0xdf, 0x54, 0x4a, 0x71, 0x43, 
0xd0, 0xc3, 0xc9, 0xde };
char packet_8[] = {
0x80, 0x08, 0x00, 0x06, 0x00, 0x00, 0x03, 0xc0, 
0xd2, 0xbd, 0x4e, 0x3e, 0x90, 0x93, 0x92, 0x92, 
0xe0, 0xf1, 0xff, 0xf6, 0x73, 0x60, 0x73, 0x75, 
0x7f, 0x66, 0x7e, 0x5b, 0xd7, 0x56, 0xd5, 0xd2, 
0xdf, 0xd2, 0xd0, 0x48, 0x78, 0x65, 0x66, 0x6f, 
0x6b, 0x6c, 0x6f, 0x68, 0x6b, 0x6e, 0x6c, 0x62, 
0x65, 0x78, 0x7d, 0x48, 0x4b, 0x4a, 0x42, 0xda, 
0xf4, 0xc0, 0xcf, 0xfd, 0xe6, 0xe0, 0xe3, 0xe9, 
0x91, 0x92, 0x9c, 0x9f, 0x90, 0xe2, 0xe7, 0xfa, 
0xc3, 0x46, 0x75, 0x5f, 0x47, 0x42, 0x48, 0x44, 
0xd3, 0xd0, 0xc5, 0xdf, 0xd2, 0xd8, 0xd8, 0x58, 
0x7c, 0x72, 0x73, 0x7e, 0x60, 0x61, 0x65, 0x67, 
0x60, 0x6d, 0x66, 0x7c, 0x71, 0x7d, 0x7d, 0x4a, 
0xd4, 0xd8, 0xd2, 0xc1, 0xf5, 0xce, 0xdb, 0xf0, 
0xe6, 0xe6, 0xe6, 0xed, 0xea, 0x97, 0x91, 0x92, 
0x9c, 0x97, 0xe4, 0xfb, 0xe4, 0xc1, 0x74, 0x40, 
0x54, 0x50, 0x4e, 0x75, 0x45, 0x54, 0x50, 0x44, 
0x5f, 0x5d, 0x5b, 0x46, 0x73, 0x64, 0x7a, 0x7e, 
0x67, 0x63, 0x66, 0x60, 0x6c, 0x69, 0x6c, 0x60, 
0x64, 0x7a, 0x7b, 0x7c, 0x48, 0x45, 0x5b, 0x59, 
0xd8, 0xca, 0xcc, 0xc3, 0xf0, 0xfa, 0xe5, 0xe1, 
0xed, 0xea, 0x96, 0x91 };
char packet_9[] = {
0x80, 0x08, 0x2c, 0x46, 0x11, 0x47, 0x33, 0x82, 
0x58, 0xf3, 0x3d, 0xea, 0x5b, 0x47, 0x55, 0xdf, 
0xd1, 0xd5, 0x54, 0xd3, 0xc4, 0x55, 0x5e, 0x56, 
0xd1, 0xd2, 0xde, 0xdd, 0x54, 0x5c, 0x45, 0x5d, 
0x55, 0x5d, 0x59, 0xd6, 0x55, 0x5a, 0xd3, 0xd9, 
0xd0, 0xdc, 0xd8, 0xd8, 0xc6, 0xca, 0xc6, 0xd1, 
0x5a, 0x7f, 0x7e, 0x4f, 0xdd, 0xd9, 0x57, 0x45, 
0x59, 0xd7, 0xdd, 0xc3, 0xc6, 0x54, 0x5c, 0xd4, 
0xdd, 0xdd, 0x5d, 0x43, 0x55, 0xdf, 0xda, 0xcc, 
0xc9, 0x54, 0x4f, 0x5c, 0x55, 0xd2, 0xd0, 0xd1, 
0x52, 0x5f, 0xdd, 0x53, 0x58, 0x53, 0xd6, 0xdd, 
0xd9, 0xdc, 0xc1, 0xd7, 0x4a, 0x4e, 0x47, 0x51, 
0xdf, 0xf5, 0xc6, 0x57, 0x5b, 0x75, 0x74, 0x55, 
0xf6, 0xdb, 0x5e, 0x50, 0xd4, 0xd3, 0x56, 0x58, 
0x5f, 0xd7, 0xdd, 0xde, 0xd2, 0xd5, 0x4d, 0x71, 
0x5f, 0xf4, 0xf2, 0xc0, 0x50, 0x41, 0x5c, 0xd0, 
0xd7, 0xdc, 0xd1, 0x45, 0x4e, 0x5c, 0x54, 0x5e, 
0x77, 0x72, 0x5a, 0xcf, 0xf2, 0xf4, 0xda, 0xd2, 
0xd6, 0x58, 0x5e, 0xdf, 0xc1, 0xc2, 0x57, 0x40, 
0x56, 0xd7, 0xd7, 0xd5, 0x56, 0x45, 0x43, 0x50, 
0xd9, 0xd2, 0x52, 0x5e, 0x5d, 0xd2, 0xd8, 0xd2, 
0x54, 0x58, 0x41, 0x43 };
char packet_10[] = {
0x80, 0x08, 0x2c, 0x47, 0x11, 0x47, 0x34, 0x22, 
0x58, 0xf3, 0x3d, 0xea, 0x56, 0xd4, 0xd6, 0x58, 
0x42, 0x53, 0xc4, 0xf7, 0xcb, 0xf5, 0xf4, 0xc1, 
0xd0, 0x4d, 0x45, 0xd6, 0x57, 0xd0, 0xd9, 0xdb, 
0x50, 0x44, 0x59, 0x4b, 0x4f, 0xd6, 0xd8, 0x57, 
0x5e, 0xd6, 0x57, 0xd0, 0xc5, 0xdf, 0xc6, 0xcd, 
0xc5, 0x51, 0x50, 0xd0, 0xd6, 0xd2, 0xdb, 0x5d, 
0x75, 0x75, 0x73, 0x75, 0xc0, 0xf7, 0xf0, 0xf6, 
0xc9, 0xd8, 0xd5, 0x57, 0x56, 0x48, 0x70, 0x75, 
0x42, 0x42, 0x5f, 0xd0, 0x5d, 0x5b, 0x5c, 0x55, 
0xd6, 0xc1, 0xcf, 0xd8, 0xd3, 0xd0, 0x45, 0x4f, 
0x54, 0xc6, 0xd0, 0x59, 0x55, 0xc4, 0xd1, 0x5a, 
0x73, 0x7f, 0x47, 0x54, 0xd1, 0xdf, 0xdc, 0xd7, 
0xc7, 0xc8, 0xdb, 0xc7, 0xca, 0xc9, 0xc0, 0xc7, 
0xc1, 0x51, 0x40, 0x5f, 0x52, 0xd7, 0xda, 0xdf, 
0x41, 0x4c, 0x56, 0x54, 0x5f, 0x4a, 0x4a, 0x4e, 
0x5d, 0xc4, 0xc6, 0xcd, 0xc7, 0xd6, 0x52, 0xd4, 
0xc4, 0xc4, 0xc6, 0xd5, 0x5b, 0x41, 0x4e, 0x56, 
0xc4, 0xd8, 0x54, 0x5e, 0x4d, 0x48, 0x76, 0x73, 
0x4d, 0x5b, 0x59, 0xd8, 0xf0, 0xf7, 0xde, 0x52, 
0xd0, 0xc3, 0xfd, 0xfa, 0xfd, 0xc1, 0x40, 0x4a, 
0x5a, 0x45, 0x5d, 0xd0 };

#define MAKE_TEST(n) \
	/* deserialize the packet*/ \
	if((packet = trtp_rtp_packet_deserialize(packet_##n, sizeof(packet_##n)))){ \
		/* serialize the packet */ \
		if((buffer = trtp_rtp_packet_serialize(packet))){ \
			/* compare data */ \
			if(sizeof(packet_##n) != buffer->size){ \
				TSK_DEBUG_ERROR("Test-%d: Sizes are different", n); \
			} \
			else{ \
				for(i=0; i<buffer->size; i++){ \
					if(packet_##n[i] != ((char*)buffer->data)[i]){ \
						TSK_DEBUG_ERROR("Test-%d: Data is different", n); \
						break; \
					} \
				} \
				if(i==buffer->size){ \
					TSK_DEBUG_INFO("Test-%d: OK", n); \
				} \
			} \
		} \
		else{ \
			TSK_DEBUG_ERROR("Failed to serialize packet-%d", n); \
		} \
		\
		TSK_OBJECT_SAFE_FREE(buffer); \
		TSK_OBJECT_SAFE_FREE(packet); \
	} \
	else{ \
		TSK_DEBUG_ERROR("Failed to deserialize packet-%d", n); \
	}

void test_parser()
{
	trtp_rtp_packet_t* packet;
	tsk_buffer_t* buffer;
	tsk_size_t i;

	MAKE_TEST(0);
	MAKE_TEST(1);
	MAKE_TEST(2);
	MAKE_TEST(3);
	MAKE_TEST(4);
	MAKE_TEST(5);
	MAKE_TEST(6);
	MAKE_TEST(7);
	MAKE_TEST(8);
	MAKE_TEST(9);
	MAKE_TEST(10);	
}


#endif /* _TEST_PARSER_H_ */
