/*
* Copyright (C) 2009 Mamadou Diop.
* Copyright (C) 2012 Doubango Telecom <http://doubango.org>.
*	
* This file is part of Open Source Doubango Framework.
*
* DOUBANGO is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*	
* DOUBANGO is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*	
* You should have received a copy of the GNU General Public License
* along with DOUBANGO.
*
*/
#ifndef _RFC4465_TORTURE_TESTS_H_
#define _RFC4465_TORTURE_TESTS_H_

typedef struct rfc4465_struct_torture_test
{
	const char* section_name;
	const char* bytecode;
	size_t bytecode_size;
	struct{ tsk_size_t size; const char* ptr; } xoutput; // Excepted output
	signed xcycles; // Excepted cycles
	int stream;
	int xfail;
	const char* comp_id;
}
struct_torture_test, *lpstruct_torture_test;

/*************************************************************
*** A.1.1.  Bit Manipulation
*/
#define RFC4465_A_1_1__Bit_Manipulation \
		"\xf8\x0a\x71\x16\xa0\x7f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\xc0\x00\xff\x80\x55\x55\x02\x20\x2a\x03\x21\x04\x20\x03\x05\x21\xff\x22\x86\x04\x01\x20\xc0\xff\x02\x20\x60\x03\x20\x04\x21\x60\x05\x20\x61\x22\x86\x04\x23"


/*************************************************************
*** A.1.2.  Arithmetic
*/
#define RFC4465_A_1_2__Arithmetic_1 \
	   "\xf8\x0a\xa1\x1c\x01\xa0\x45\x0b\x07\x22\x01\x16\xa0\x77\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x06\xc0\x00\xff\x99\x41\x07\x20\x01\x08\x20\xa3\xe9\x09\x20\xa0\x65\x0a\x20\x0b\x22\x86\x04\x06\x21\xc0\xff\x07\x21\x62\x08\x21\x61\x09\x20\x61\x0a\x21\x62\x22\x86\x04\x23" \
	   "\x00"
#define RFC4465_A_1_2__Arithmetic_2 \
	   "\xf8\x0a\xa1\x1c\x01\xa0\x45\x0b\x07\x22\x01\x16\xa0\x77\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x06\xc0\x00\xff\x99\x41\x07\x20\x01\x08\x20\xa3\xe9\x09\x20\xa0\x65\x0a\x20\x0b\x22\x86\x04\x06\x21\xc0\xff\x07\x21\x62\x08\x21\x61\x09\x20\x61\x0a\x21\x62\x22\x86\x04\x23" \
	   "\x01"
#define RFC4465_A_1_2__Arithmetic_3 \
	   "\xf8\x0a\xa1\x1c\x01\xa0\x45\x0b\x07\x22\x01\x16\xa0\x77\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x06\xc0\x00\xff\x99\x41\x07\x20\x01\x08\x20\xa3\xe9\x09\x20\xa0\x65\x0a\x20\x0b\x22\x86\x04\x06\x21\xc0\xff\x07\x21\x62\x08\x21\x61\x09\x20\x61\x0a\x21\x62\x22\x86\x04\x23" \
	   "\x02"

/*************************************************************
*** A.1.3.  Sorting
*/
#define RFC4465_A_1_3__Sorting \
	   "\xf8\x0d\xc1\x0c\x88\x02\x17\x0b\x88\x02\x17\x22\xa1\x2e\x2d\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0a\x00\x0a\x00\x11\x00\x07\x00\x16\x00\x03\x00\x03\x00\x03\x00\x13\x00\x01\x00\x10\x00\x0e\x00\x08\x00\x02\x00\x0d\x00\x14\x00\x12\x00\x17\x00\x0f\x00\x15\x00\x0c\x00\x06\x00\x09\x6e\x67\x20\x69\x75\x69\x20\x74\x69\x74\x2c\x20\x79\x6f\x75\x27\x20\x53\x46\x6f\x6e\x67\x61\x20\x75\x72\x72\x64\x6f\x20\x74\x6f\x6e\x2e\x2e\x00\x70\x65\x70\x20\x6e\x74\x72\x65\x6e\x69"


/*************************************************************
*** A.1.4.  SHA-1
*/
#define RFC4465_A_1_4__SHA1 \
	   "\xf8\x08\x71\x0d\xa0\xc3\x03\xa0\x44\x22\xa0\x44\x14\x0d\xa0\xc6\x38\xa0\x44\x22\xa0\x44\x14\x0e\x86\xa0\xfe\x0e\xa0\x42\xa0\xff\x0d\xa0\xfe\x8e\xa0\x44\x22\xa0\x44\x14\x0e\x86\xa0\xff\x0e\xa0\x42\xa1\x07\x0d\xa0\xff\xa2\x80\xa0\xff\x22\xa0\xff\x14\x23\x00\x00\x00\x00\x00\x00\x00\x61\x62\x63\x61\x62\x63\x64\x62\x63\x64\x65\x63\x64\x65\x66\x64\x65\x66\x67\x65\x66\x67\x68\x66\x67\x68\x69\x67\x68\x69\x6a\x68\x69\x6a\x6b\x69\x6a\x6b\x6c\x6a\x6b\x6c\x6d\x6b\x6c\x6d\x6e\x6c\x6d\x6e\x6f\x6d\x6e\x6f\x70\x6e\x6f\x70\x71\x61\x30\x31\x32\x33\x34\x35\x36\x37"
	

/*************************************************************
*** A.1.5.  LOAD and MULTILOAD
*/
#define RFC4465_A_1_5__LOAD_and_MULTILOAD_1 \
	   "\xf8\x03\x61\x0e\x87\xa0\x84\x0e\xa0\x82\xc0\x80\x0e\xc0\x80\xa0\x86\x0e\xc0\x84\xc0\x84\x22\x87\x08\x1c\x01\xa0\x41\x27\x08\x20\x02\x06\x20\x3c\x0f\x60\x03\xa0\xa2\xa0\xb1\x87\x0f\x60\x04\x2a\x87\xc0\x80\xc0\x84\x22\x87\x08\x23" \
	   "\x00"
#define RFC4465_A_1_5__LOAD_and_MULTILOAD_2 \
	   "\xf8\x03\x61\x0e\x87\xa0\x84\x0e\xa0\x82\xc0\x80\x0e\xc0\x80\xa0\x86\x0e\xc0\x84\xc0\x84\x22\x87\x08\x1c\x01\xa0\x41\x27\x08\x20\x02\x06\x20\x3c\x0f\x60\x03\xa0\xa2\xa0\xb1\x87\x0f\x60\x04\x2a\x87\xc0\x80\xc0\x84\x22\x87\x08\x23" \
	   "\x01"
#define RFC4465_A_1_5__LOAD_and_MULTILOAD_3 \
	   "\xf8\x03\x61\x0e\x87\xa0\x84\x0e\xa0\x82\xc0\x80\x0e\xc0\x80\xa0\x86\x0e\xc0\x84\xc0\x84\x22\x87\x08\x1c\x01\xa0\x41\x27\x08\x20\x02\x06\x20\x3c\x0f\x60\x03\xa0\xa2\xa0\xb1\x87\x0f\x60\x04\x2a\x87\xc0\x80\xc0\x84\x22\x87\x08\x23" \
	   "\x02"

/*************************************************************
*** A.1.6.  COPY
*/
#define RFC4465_A_1_6__COPY \
	   "\xf8\x03\x91\x0e\x20\x8e\x0e\x86\x86\x0e\xa0\x42\x87\x12\x20\x87\x21\x0e\x86\x80\x41\x00\x12\x86\xa0\x55\xa0\x41\x22\x20\xa0\x77\x0e\x86\x20\x0e\xa0\x42\x30\x15\x20\x04\xa0\x41\x01\x12\x20\x04\x30\x22\x30\x04\x12\x30\x04\x2e\x22\x20\x02\x23"
	

/*************************************************************
*** A.1.7.  COPY-LITERAL and COPY-OFFSET
*/
#define RFC4465_A_1_7__COPY_LITERAL_and_COPY_OFFSET \
	   "\xf8\x06\x11\x0e\x20\x80\x41\x00\x0e\x86\x86\x0e\xa0\x42\x87\x0e\xa0\x44\x21\x13\x20\x87\x22\x22\x86\x08\x0e\xa0\x44\xa0\x9c\x13\x20\x02\x22\x22\xa0\x9c\x02\x0e\x86\xa0\x48\x0e\xa0\x42\xa0\x52\x0e\xa0\x44\xa0\x52\x15\xa0\x48\x0a\xa0\x41\x01\x14\x02\x06\x22\x0e\xa0\x46\x06\x14\x63\x04\x22\x22\x61\x0a\x0e\xa0\x44\xa0\x50\x14\x04\x04\x22\x22\xa0\x44\x02\x14\x05\x04\x22\x22\xa0\x44\x02\x22\x60\x0a\x23"
	

/*************************************************************
*** A.1.8.  MEMSET
*/
#define RFC4465_A_1_8__MEMSET \
	   "\xf8\x01\x81\x0e\x86\x87\x0e\xa0\x42\xa0\x81\x15\x86\xa0\x81\x00\x01\x15\xa0\x81\x0f\x86\x0f\x22\x87\x10\x23"
	

/*************************************************************
*** A.1.9.  CRC
*/
#define RFC4465_A_1_9__CRC_1 \
	   "\xf8\x01\x81\x15\xa0\x46\x18\x01\x01\x15\xa0\x5e\x14\x87\x01\x1c\x02\xa0\x44\x13\x1b\x62\xa0\x46\x2c\x0e\x23"\
	   "\x62\xcb"
#define RFC4465_A_1_9__CRC_2 \
	   "\xf8\x01\x81\x15\xa0\x46\x18\x01\x01\x15\xa0\x5e\x14\x87\x01\x1c\x02\xa0\x44\x13\x1b\x62\xa0\x46\x2c\x0e\x23"\
	   "\xab\xcb"
	

/*************************************************************
*** A.1.10.  INPUT-BITS
*/
#define RFC4465_A_1_10__INPUT_BITS \
	   "\xf8\x01\x51\x1d\x62\xa0\x46\x14\x22\xa0\x46\x02\x06\x22\x01\x0a\x22\x07\x06\x22\x01\x16\xee\x23"\
	   "\x93\x2e\xac\x71"
	

/*************************************************************
*** A.1.11.  INPUT-HUFFMAN
*/
#define RFC4465_A_1_11__INPUT_HUFFMAN \
	   "\xf8\x01\xd1\x1e\xa0\x46\x1c\x02\x62\x00\x62\x62\x62\x00\xff\x00\x22\xa0\x46\x02\x06\x22\x01\x0a\x22\x07\x06\x22\x01\x16\xe6\x23"\
	   "\x93\x2e\xac\x71\x66\xd8\x6f"
	


/*************************************************************
*** A.1.12.  INPUT-BYTES
*/
#define RFC4465_A_1_12__INPUT_BYTES \
	   "\xf8\x02\x71\x0e\x86\xa0\x48\x0e\xa0\x42\xa0\x4c\x1d\x62\xa0\x46\x1d\x22\xa0\x46\x02\x06\x22\x02\x0a\x22\x07\x1c\x62\xa0\x48\x0e\x22\xa0\x48\x62\x06\x22\x01\x16\xe5\x23"\
	   "\x93\x2e\xac\x71\x66\xd8\x6f\xb1\x59\x2b\xdc\x9a\x97\x34\xd8\x47\xa7\x33\x87\x4e\x1b\xcb\xcd\x51\xb5\xdc\x96\x59\x9d\x6a"
	

/*************************************************************
*** A.1.13.  Stack Manipulation
*/
#define RFC4465_A_1_13__Stack_Manipulation \
	   "\xf8\x14\x11\x0e\xa0\x46\x86\x10\x02\x10\x60\x10\xa0\x42\x22\x86\x08\x11\x86\x11\x63\x11\xa0\x46\x22\x86\x08\x16\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0e\xa0\x46\x20\x0e\xa0\x48\xa1\x40\x07\x24\x88\x18\x34\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x64\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0e\xa0\x46\xa1\x7f\x0e\xa1\x7f\x1a\x0f\xa1\xb0\x03\x01\x80\xc0\x01\x8f\x19\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23"
	

/*************************************************************
*** A.1.14.  Program Flow
*/
#define RFC4465_A_1_14__Program_Flow \
	   "\xf8\x03\xf1\x0e\xa0\x44\x04\x0e\x86\xa0\x92\x07\x20\xa0\x90\x22\xa0\x43\x01\x16\x60\x06\x21\x01\x0e\x86\xa0\x84\x07\x20\xa0\xa1\x22\xa0\x43\x01\x17\x61\x06\x60\xf1\x06\x07\x22\x01\x0e\x86\xa0\x84\x07\x20\xa0\xb6\x22\xa0\x43\x01\x1a\x04\x62\x08\x60\x9f\xdc\xf1\x23"
	

/*************************************************************
*** A.1.15.  State Creation_1
*/
#define RFC4465_A_1_15__State_Creation_1 \
	   "\xf8\x09\x41\x1c\x01\xa0\x45\xff\x04\x22\x0b\x17\x62\x8f\x0d\x06\x06\x20\x0a\xa1\x0a\x00\x14\x00\x04\x22\x01\x17\x62\x8f\x0c\x06\x06\x20\x0a\x88\x00\x14\x00\x04\x22\x01\x17\x62\x8f\x16\x06\x06\x1c\x01\xa0\x47\x9f\xd2\x21\xa0\x48\x63\x12\xa0\xe3\x63\xa0\x48\x04\x22\x01\x17\x62\x8f\x0a\x06\x06\x21\xa0\xe3\x06\x04\x22\x01\x17\x62\x8f\x0e\x06\x06\x23\x00\x00\x0a\x88\x00\x14\x00\x23\x00\x00\x00\x00\x00\x00\x00\x43\x7a\xe8\x0a\x0f\xdc\x1e\x6a\x87\xc1\xb6\x2a\x76\x76\xb9\x73\x31\x8c\x0e\xf5\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\xcc\x3f\xee\x79\xbc\xfc\x8f\xd1\x08\x65\xe8\x03\x52\xee\x29\x77\x17\xdf\x57"\
	   "\x01"
	

/*************************************************************
*** A.1.15.  State Creation_2
*/
#define RFC4465_A_1_15__State_Creation_2 \
	   "\xf8\x09\x41\x1c\x01\xa0\x45\xff\x04\x22\x0b\x17\x62\x8f\x0d\x06\x06\x20\x0a\xa1\x0a\x00\x14\x00\x04\x22\x01\x17\x62\x8f\x0c\x06\x06\x20\x0a\x88\x00\x14\x00\x04\x22\x01\x17\x62\x8f\x16\x06\x06\x1c\x01\xa0\x47\x9f\xd2\x21\xa0\x48\x63\x12\xa0\xe3\x63\xa0\x48\x04\x22\x01\x17\x62\x8f\x0a\x06\x06\x21\xa0\xe3\x06\x04\x22\x01\x17\x62\x8f\x0e\x06\x06\x23\x00\x00\x0a\x88\x00\x14\x00\x23\x00\x00\x00\x00\x00\x00\x00\x43\x7a\xe8\x0a\x0f\xdc\x1e\x6a\x87\xc1\xb6\x2a\x76\x76\xb9\x73\x31\x8c\x0e\xf5\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\xcc\x3f\xee\x79\xbc\xfc\x8f\xd1\x08\x65\xe8\x03\x52\xee\x29\x77\x17\xdf\x57"\
	   "\x02"
	

/*************************************************************
*** A.1.15.  State Creation_3
*/
#define RFC4465_A_1_15__State_Creation_3 \
	   "\xf8\x09\x41\x1c\x01\xa0\x45\xff\x04\x22\x0b\x17\x62\x8f\x0d\x06\x06\x20\x0a\xa1\x0a\x00\x14\x00\x04\x22\x01\x17\x62\x8f\x0c\x06\x06\x20\x0a\x88\x00\x14\x00\x04\x22\x01\x17\x62\x8f\x16\x06\x06\x1c\x01\xa0\x47\x9f\xd2\x21\xa0\x48\x63\x12\xa0\xe3\x63\xa0\x48\x04\x22\x01\x17\x62\x8f\x0a\x06\x06\x21\xa0\xe3\x06\x04\x22\x01\x17\x62\x8f\x0e\x06\x06\x23\x00\x00\x0a\x88\x00\x14\x00\x23\x00\x00\x00\x00\x00\x00\x00\x43\x7a\xe8\x0a\x0f\xdc\x1e\x6a\x87\xc1\xb6\x2a\x76\x76\xb9\x73\x31\x8c\x0e\xf5\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\xcc\x3f\xee\x79\xbc\xfc\x8f\xd1\x08\x65\xe8\x03\x52\xee\x29\x77\x17\xdf\x57"\
	   "\x03"
	

/*************************************************************
*** A.1.15.  State Creation_4
*/
#define RFC4465_A_1_15__State_Creation_4 \
	   "\xf8\x09\x41\x1c\x01\xa0\x45\xff\x04\x22\x0b\x17\x62\x8f\x0d\x06\x06\x20\x0a\xa1\x0a\x00\x14\x00\x04\x22\x01\x17\x62\x8f\x0c\x06\x06\x20\x0a\x88\x00\x14\x00\x04\x22\x01\x17\x62\x8f\x16\x06\x06\x1c\x01\xa0\x47\x9f\xd2\x21\xa0\x48\x63\x12\xa0\xe3\x63\xa0\x48\x04\x22\x01\x17\x62\x8f\x0a\x06\x06\x21\xa0\xe3\x06\x04\x22\x01\x17\x62\x8f\x0e\x06\x06\x23\x00\x00\x0a\x88\x00\x14\x00\x23\x00\x00\x00\x00\x00\x00\x00\x43\x7a\xe8\x0a\x0f\xdc\x1e\x6a\x87\xc1\xb6\x2a\x76\x76\xb9\x73\x31\x8c\x0e\xf5\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\xcc\x3f\xee\x79\xbc\xfc\x8f\xd1\x08\x65\xe8\x03\x52\xee\x29\x77\x17\xdf\x57"\
	   "\x04\x05"
	

/*************************************************************
*** A.1.15.  State Creation_5
*/
#define RFC4465_A_1_15__State_Creation_5 \
	   "\xf8\x09\x41\x1c\x01\xa0\x45\xff\x04\x22\x0b\x17\x62\x8f\x0d\x06\x06\x20\x0a\xa1\x0a\x00\x14\x00\x04\x22\x01\x17\x62\x8f\x0c\x06\x06\x20\x0a\x88\x00\x14\x00\x04\x22\x01\x17\x62\x8f\x16\x06\x06\x1c\x01\xa0\x47\x9f\xd2\x21\xa0\x48\x63\x12\xa0\xe3\x63\xa0\x48\x04\x22\x01\x17\x62\x8f\x0a\x06\x06\x21\xa0\xe3\x06\x04\x22\x01\x17\x62\x8f\x0e\x06\x06\x23\x00\x00\x0a\x88\x00\x14\x00\x23\x00\x00\x00\x00\x00\x00\x00\x43\x7a\xe8\x0a\x0f\xdc\x1e\x6a\x87\xc1\xb6\x2a\x76\x76\xb9\x73\x31\x8c\x0e\xf5\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\xcc\x3f\xee\x79\xbc\xfc\x8f\xd1\x08\x65\xe8\x03\x52\xee\x29\x77\x17\xdf\x57"\
	   "\x04\x15"
	

/*************************************************************
*** A.1.15.  State Creation_6
*/
#define RFC4465_A_1_15__State_Creation_6 \
	   "\xf8\x09\x41\x1c\x01\xa0\x45\xff\x04\x22\x0b\x17\x62\x8f\x0d\x06\x06\x20\x0a\xa1\x0a\x00\x14\x00\x04\x22\x01\x17\x62\x8f\x0c\x06\x06\x20\x0a\x88\x00\x14\x00\x04\x22\x01\x17\x62\x8f\x16\x06\x06\x1c\x01\xa0\x47\x9f\xd2\x21\xa0\x48\x63\x12\xa0\xe3\x63\xa0\x48\x04\x22\x01\x17\x62\x8f\x0a\x06\x06\x21\xa0\xe3\x06\x04\x22\x01\x17\x62\x8f\x0e\x06\x06\x23\x00\x00\x0a\x88\x00\x14\x00\x23\x00\x00\x00\x00\x00\x00\x00\x43\x7a\xe8\x0a\x0f\xdc\x1e\x6a\x87\xc1\xb6\x2a\x76\x76\xb9\x73\x31\x8c\x0e\xf5\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\xcc\x3f\xee\x79\xbc\xfc\x8f\xd1\x08\x65\xe8\x03\x52\xee\x29\x77\x17\xdf\x57"\
	   "\x04\x06"
	

/*************************************************************
*** A.1.15.  State Creation_7
*/
#define RFC4465_A_1_15__State_Creation_7 \
	   "\xf8\x09\x41\x1c\x01\xa0\x45\xff\x04\x22\x0b\x17\x62\x8f\x0d\x06\x06\x20\x0a\xa1\x0a\x00\x14\x00\x04\x22\x01\x17\x62\x8f\x0c\x06\x06\x20\x0a\x88\x00\x14\x00\x04\x22\x01\x17\x62\x8f\x16\x06\x06\x1c\x01\xa0\x47\x9f\xd2\x21\xa0\x48\x63\x12\xa0\xe3\x63\xa0\x48\x04\x22\x01\x17\x62\x8f\x0a\x06\x06\x21\xa0\xe3\x06\x04\x22\x01\x17\x62\x8f\x0e\x06\x06\x23\x00\x00\x0a\x88\x00\x14\x00\x23\x00\x00\x00\x00\x00\x00\x00\x43\x7a\xe8\x0a\x0f\xdc\x1e\x6a\x87\xc1\xb6\x2a\x76\x76\xb9\x73\x31\x8c\x0e\xf5\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\xcc\x3f\xee\x79\xbc\xfc\x8f\xd1\x08\x65\xe8\x03\x52\xee\x29\x77\x17\xdf\x57"\
	   "\x09"
	

/*************************************************************
*** A.1.15.  State Creation_8
*/
#define RFC4465_A_1_15__State_Creation_8 \
	   "\xf8\x09\x41\x1c\x01\xa0\x45\xff\x04\x22\x0b\x17\x62\x8f\x0d\x06\x06\x20\x0a\xa1\x0a\x00\x14\x00\x04\x22\x01\x17\x62\x8f\x0c\x06\x06\x20\x0a\x88\x00\x14\x00\x04\x22\x01\x17\x62\x8f\x16\x06\x06\x1c\x01\xa0\x47\x9f\xd2\x21\xa0\x48\x63\x12\xa0\xe3\x63\xa0\x48\x04\x22\x01\x17\x62\x8f\x0a\x06\x06\x21\xa0\xe3\x06\x04\x22\x01\x17\x62\x8f\x0e\x06\x06\x23\x00\x00\x0a\x88\x00\x14\x00\x23\x00\x00\x00\x00\x00\x00\x00\x43\x7a\xe8\x0a\x0f\xdc\x1e\x6a\x87\xc1\xb6\x2a\x76\x76\xb9\x73\x31\x8c\x0e\xf5\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\xcc\x3f\xee\x79\xbc\xfc\x8f\xd1\x08\x65\xe8\x03\x52\xee\x29\x77\x17\xdf\x57"\
	   "\x1e\x06"
	

/*************************************************************
*** A.1.15.  State Creation_9
*/
#define RFC4465_A_1_15__State_Creation_9 \
	   "\xf8\x09\x41\x1c\x01\xa0\x45\xff\x04\x22\x0b\x17\x62\x8f\x0d\x06\x06\x20\x0a\xa1\x0a\x00\x14\x00\x04\x22\x01\x17\x62\x8f\x0c\x06\x06\x20\x0a\x88\x00\x14\x00\x04\x22\x01\x17\x62\x8f\x16\x06\x06\x1c\x01\xa0\x47\x9f\xd2\x21\xa0\x48\x63\x12\xa0\xe3\x63\xa0\x48\x04\x22\x01\x17\x62\x8f\x0a\x06\x06\x21\xa0\xe3\x06\x04\x22\x01\x17\x62\x8f\x0e\x06\x06\x23\x00\x00\x0a\x88\x00\x14\x00\x23\x00\x00\x00\x00\x00\x00\x00\x43\x7a\xe8\x0a\x0f\xdc\x1e\x6a\x87\xc1\xb6\x2a\x76\x76\xb9\x73\x31\x8c\x0e\xf5\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\xcc\x3f\xee\x79\xbc\xfc\x8f\xd1\x08\x65\xe8\x03\x52\xee\x29\x77\x17\xdf\x57"\
	   "\x1e\x07"
	

/*************************************************************
*** A.1.15.  State Creation_10
*/
#define RFC4465_A_1_15__State_Creation_10 \
	   "\xf8\x09\x41\x1c\x01\xa0\x45\xff\x04\x22\x0b\x17\x62\x8f\x0d\x06\x06\x20\x0a\xa1\x0a\x00\x14\x00\x04\x22\x01\x17\x62\x8f\x0c\x06\x06\x20\x0a\x88\x00\x14\x00\x04\x22\x01\x17\x62\x8f\x16\x06\x06\x1c\x01\xa0\x47\x9f\xd2\x21\xa0\x48\x63\x12\xa0\xe3\x63\xa0\x48\x04\x22\x01\x17\x62\x8f\x0a\x06\x06\x21\xa0\xe3\x06\x04\x22\x01\x17\x62\x8f\x0e\x06\x06\x23\x00\x00\x0a\x88\x00\x14\x00\x23\x00\x00\x00\x00\x00\x00\x00\x43\x7a\xe8\x0a\x0f\xdc\x1e\x6a\x87\xc1\xb6\x2a\x76\x76\xb9\x73\x31\x8c\x0e\xf5\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\xcc\x3f\xee\x79\xbc\xfc\x8f\xd1\x08\x65\xe8\x03\x52\xee\x29\x77\x17\xdf\x57"\
	   "\x1e\14"
	

/*************************************************************
*** A.1.16.  STATE-ACCESS Set up bytecode}
*/
#define RFC4465_A_1_16__STATE_ACCESS__SETUP \
	   "\xf8\x19\x01\x23\x00\x00\x10\x89\x00\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x22\xa2\x0c\x04\x23\x00\x00\x00\x00\x00\x00\x00\x74\x65\x73\x74"\
	   ""
	

/*************************************************************
*** A.1.16.  STATE-ACCESS_1
*/
#define RFC4465_A_1_16__STATE_ACCESS_1 \
	   "\xf8\x19\x41\x1c\x01\xa0\x45\xff\x17\x62\x01\x06\x0d\x1c\x1f\x89\x14\x00\x00\x00\x89\x1f\x89\x14\x0c\x04\xa0\x46\x00\x22\xa0\x46\x04\x16\xa1\x46\x17\x62\x03\x06\x10\x1b\x1f\x87\x14\x00\x00\x00\x00\x16\xa1\x36\x1f\x89\x13\x06\x04\xa0\x46\x00\x16\xa1\x2b\x1f\x89\x14\x0c\x05\xa0\x46\x00\x16\xa1\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\xf8\xbc\x3e\x20\x93\xb5\xab\xe1\xf1\x70\x13\x42\x4c\xe7\xfe\x05\xe0\x69\x39"\
	   "\x00"
	

/*************************************************************
*** A.1.16.  STATE-ACCESS_2
*/
#define RFC4465_A_1_16__STATE_ACCESS_2 \
	   "\xf8\x19\x41\x1c\x01\xa0\x45\xff\x17\x62\x01\x06\x0d\x1c\x1f\x89\x14\x00\x00\x00\x89\x1f\x89\x14\x0c\x04\xa0\x46\x00\x22\xa0\x46\x04\x16\xa1\x46\x17\x62\x03\x06\x10\x1b\x1f\x87\x14\x00\x00\x00\x00\x16\xa1\x36\x1f\x89\x13\x06\x04\xa0\x46\x00\x16\xa1\x2b\x1f\x89\x14\x0c\x05\xa0\x46\x00\x16\xa1\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\xf8\xbc\x3e\x20\x93\xb5\xab\xe1\xf1\x70\x13\x42\x4c\xe7\xfe\x05\xe0\x69\x39"\
	   "\x01"
	

/*************************************************************
*** A.1.16.  STATE-ACCESS_3
*/
#define RFC4465_A_1_16__STATE_ACCESS_3 \
	   "\xf8\x19\x41\x1c\x01\xa0\x45\xff\x17\x62\x01\x06\x0d\x1c\x1f\x89\x14\x00\x00\x00\x89\x1f\x89\x14\x0c\x04\xa0\x46\x00\x22\xa0\x46\x04\x16\xa1\x46\x17\x62\x03\x06\x10\x1b\x1f\x87\x14\x00\x00\x00\x00\x16\xa1\x36\x1f\x89\x13\x06\x04\xa0\x46\x00\x16\xa1\x2b\x1f\x89\x14\x0c\x05\xa0\x46\x00\x16\xa1\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\xf8\xbc\x3e\x20\x93\xb5\xab\xe1\xf1\x70\x13\x42\x4c\xe7\xfe\x05\xe0\x69\x39"\
	   "\x02"
	

/*************************************************************
*** A.1.16.  STATE-ACCESS_4
*/
#define RFC4465_A_1_16__STATE_ACCESS_4 \
	   "\xf8\x19\x41\x1c\x01\xa0\x45\xff\x17\x62\x01\x06\x0d\x1c\x1f\x89\x14\x00\x00\x00\x89\x1f\x89\x14\x0c\x04\xa0\x46\x00\x22\xa0\x46\x04\x16\xa1\x46\x17\x62\x03\x06\x10\x1b\x1f\x87\x14\x00\x00\x00\x00\x16\xa1\x36\x1f\x89\x13\x06\x04\xa0\x46\x00\x16\xa1\x2b\x1f\x89\x14\x0c\x05\xa0\x46\x00\x16\xa1\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\xf8\xbc\x3e\x20\x93\xb5\xab\xe1\xf1\x70\x13\x42\x4c\xe7\xfe\x05\xe0\x69\x39"\
	   "\x03"
	

/*************************************************************
*** A.1.16.  STATE-ACCESS_5
*/
#define RFC4465_A_1_16__STATE_ACCESS_5 \
	   "\xf8\x19\x41\x1c\x01\xa0\x45\xff\x17\x62\x01\x06\x0d\x1c\x1f\x89\x14\x00\x00\x00\x89\x1f\x89\x14\x0c\x04\xa0\x46\x00\x22\xa0\x46\x04\x16\xa1\x46\x17\x62\x03\x06\x10\x1b\x1f\x87\x14\x00\x00\x00\x00\x16\xa1\x36\x1f\x89\x13\x06\x04\xa0\x46\x00\x16\xa1\x2b\x1f\x89\x14\x0c\x05\xa0\x46\x00\x16\xa1\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\xf8\xbc\x3e\x20\x93\xb5\xab\xe1\xf1\x70\x13\x42\x4c\xe7\xfe\x05\xe0\x69\x39"\
	   "\x04"
	

/*************************************************************
*** A.2.1.  Useful Values_1 (NOT from rfc4465)
*/	
#define RFC4465_A_2_1__Useful_Values_1 \
   "\xf8\x05\xa1\x0e\x86\x20\x0e\xa0\x42\x21\x17\x42\x02\xf8\x06\xf8\x17\x43\x00\xf2\x06\x0c\x17\x44\x00\xec"\
   "\x3f\xec\x17\x44\xa3\xc0\xe6\x07\xe6\x1c\x01\xa0\x47\x9f\xdf\x06\x23\x40\x07\x23\x01\x12\x20\x01\x63\x1c"\
   "\x01\xa0\x49\x9f\xcf\x0e\xa0\x44\x43\x06\x22\x03\x08\x22\x08\x06\x22\xa3\xe8\x08\x22\x41\x06\x22\x64\x07"\
   "\x22\xa3\xd6\x12\x20\x62\x20\x23\x00\x00\xa3\xc0\x86\x87\x06"

/*************************************************************
*** A.2.1.  Useful Values_2 (NOT from rfc4465)
*/
#define RFC4465_A_2_1__Useful_Values_2 \
	   "\xf9\x46\x84\x75\x55\xd9\x2d"\
		"\x00\x00"
	

/*************************************************************
*** A.2.1.  Useful Values_3 (NOT from rfc4465)
*/
#define RFC4465_A_2_1__Useful_Values_3 \
	   "\xf9\x46\x84\x75\x55\xd9\x2d"\
	   "\x00\x01"
	

/*************************************************************
*** A.2.1.  Useful Values_4
*/
#define RFC4465_A_2_1__Useful_Values_4 \
	   "\xf9\x46\x84\x75\x55\xd9\x2d"\
	   "x01\x00"
	

/*************************************************************
*** A.2.2.  Cycles Checking
*/
#define RFC4465_A_2_2__Cycles_Checking \
	   "\xf8\x01\xa1\x0f\x86\x04\x20\x29\x00\x22\x12\xa0\x44\x02\x60\x14\x02\xa0\x64\x23\x22\xa0\x44\x02\x06\x22\x01\x16\xef"\
	   ""
	

/*************************************************************
*** A.2.3.  Message-based Transport
*/
#define RFC4465_A_2_3_Message_based_Transport_1 \
	   "\xf8"\
	   ""
	

/*************************************************************
*** A.2.3.  Message-based Transport
*/
#define RFC4465_A_2_3_Message_based_Transport_2 \
	   "\xf8\x00"\
	   ""
	

/*************************************************************
*** A.2.3.  Message-based Transport
*/
#define RFC4465_A_2_3_Message_based_Transport_3 \
	   "\xf8\x00\xe1\x06\x00\x11\x22\x00\x02\x23\x00\x00\x00\x00\x00\x00\x01"\
	   ""
	

/*************************************************************
*** A.2.3.  Message-based Transport
*/
#define RFC4465_A_2_3_Message_based_Transport_4 \
	   "\xf8\x00\xf1\x06\x00\x11\x22\x00\x02\x23\x00\x00\x00\x00\x00\x00\x01"\
	   ""
	

/*************************************************************
*** A.2.3.  Message-based Transport
*/
#define RFC4465_A_2_3_Message_based_Transport_5 \
	   "\xf8\x00\xe0\x06\x00\x11\x22\x00\x02\x23\x00\x00\x00\x00\x00\x00\x01"\
	   ""
	

/*************************************************************
*** A.2.3.  Message-based Transport
*/
#define RFC4465_A_2_3_Message_based_Transport_6 \
	   "\xf8\x00\xee\x06\x00\x11\x22\x00\x02\x23\x00\x00\x00\x00\x00\x00\x01"\
	   ""
	

/*************************************************************
*** A.2.4.  Stream-based Transport_1 (Outputs 2 messages. This why "RFC4465_A_2_4_Stream_based_Transport_2" is missing)
*/
#define RFC4465_A_2_4_Stream_based_Transport_1\
	   "\xff\xff\xf8\x01\x71\x08\x00\x02\x22\x00\x02\x22\xa0\x92\x05\x23\x00\x00\x00\x00\x00\x00\x00\xff\x00\xff\x03\xff\xff\xff\xff\xff\xff\xff\xf8\x01\x7e\x08\x00\x02\x22\x00\x02\x22\xa3\xd2\x05\x23\x00\x00\x00\x00\x00\x00\x00\xff\x04\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"\
	   ""
	

/*************************************************************
*** A.2.4.  Stream-based Transport_3
*/
#define RFC4465_A_2_4_Stream_based_Transport_3\
	   "\xf8\xff\xff"\
	   ""
	

/*************************************************************
*** A.2.4.  Stream-based Transport_4
*/
#define RFC4465_A_2_4_Stream_based_Transport_4\
	   "\xf8\x00\xff\xff"\
	   ""
	

/*************************************************************
*** A.2.4.  Stream-based Transport_5
*/
#define RFC4465_A_2_4_Stream_based_Transport_5\
	   "\xf8\x01\x81\x08\x00\x02\x22\x00\x02\x22\xa0\x92\x05\x23\xff\xff\x00\x00\x00\x00\x00\x00\x00\xff\x00\xff\x03\xff\xff\xff"\
	   ""
	

/*************************************************************
*** A.2.4.  Stream-based Transport_6
*/
#define RFC4465_A_2_4_Stream_based_Transport_6\
	   "\xf8\x01\x70\x08\x00\x02\x22\x00\x02\x22\xa0\x92\x05\x23\xff\xff\x00\x00\x00\x00\x00\x00\x00\xff\x04\xff\xff\xff\xff"\
	   ""
	


/*************************************************************
*** A.2.5.  Input Past the End of a Message_1
*/
#define RFC4465_A_2_5__Input_Past_the_End_of_a_Message_1\
	   "\xf8\x03\x21\x0e\x86\xa0\x46\x0e\xa0\x42\xa0\x4d\x1d\x09\xa0\x46\x0a\x1c\x07\xa0\x46\x06\x00\x1d\x07\xa0\x46\xff\x1c\x02\xa0\x46\xfa\x22\xa0\x46\x02\x1d\x10\xa0\x46\x06\x00\x1d\x08\xa0\x46\xff\x22\xa0\x47\x01\x23"\
	   "\xff\xfa\x00\x68\x69\x21"
	

/*************************************************************
*** A.2.5.  Input Past the End of a Message_2
*/
#define RFC4465_A_2_5__Input_Past_the_End_of_a_Message_2\
	   "\xf8\x03\x21\x0e\x86\xa0\x46\x0e\xa0\x42\xa0\x4d\x1d\x09\xa0\x46\x0a\x1c\x07\xa0\x46\x06\x00\x1d\x07\xa0\x46\xff\x1c\x02\xa0\x46\xfa\x22\xa0\x46\x02\x1d\x10\xa0\x46\x06\x00\x1d\x08\xa0\x46\xff\x22\xa0\x47\x01\x23"\
	   "\xff\xfa\x00\x68\x69"
	


/*************************************************************
*** A.3.1.  SigComp Feedback Mechanism_1
*/
#define RFC4465_A_3_1__SigComp_Feedback_Mechanism_1\
	   "\xf8\x05\x03\x1c\x01\xa0\x41\xa0\x55\x17\x60\x01\x07\x0e\xa0\x4f\x0e\xa0\x42\xa4\x7f\x16\x0e\x0e\xa0\x42\xa4\xff\x15\xa0\x44\xa0\x7f\x01\x01\x0e\xa0\xc3\xa8\x01\x0e\xa0\xc5\xa6\x00\x0e\xa0\xcc\xac\x00\x0e\xa0\xd9\xb4\x00\x0e\xa0\xee\xb5\x00\x15\xa0\xc6\x06\x00\x01\x15\xa0\xcd\x0c\x00\x01\x15\xa0\xda\x14\x00\x01\x23\xa0\x42\xa0\xc3"\
	   "\x00"
	

/*************************************************************
*** A.3.1.  SigComp Feedback Mechanism_2
*/
#define RFC4465_A_3_1__SigComp_Feedback_Mechanism_2\
	   "\xf8\x05\x03\x1c\x01\xa0\x41\xa0\x55\x17\x60\x01\x07\x0e\xa0\x4f\x0e\xa0\x42\xa4\x7f\x16\x0e\x0e\xa0\x42\xa4\xff\x15\xa0\x44\xa0\x7f\x01\x01\x0e\xa0\xc3\xa8\x01\x0e\xa0\xc5\xa6\x00\x0e\xa0\xcc\xac\x00\x0e\xa0\xd9\xb4\x00\x0e\xa0\xee\xb5\x00\x15\xa0\xc6\x06\x00\x01\x15\xa0\xcd\x0c\x00\x01\x15\xa0\xda\x14\x00\x01\x23\xa0\x42\xa0\xc3"\
	   "\x01"
	

/*************************************************************
*** A.3.2.  State Memory Management_1
*/
#define RFC4465_A_3_2__State_Memory_Management_1\
	   "\xf8\x1b\xa1\x0f\x86\x02\x89\xa2\x04\x1c\x01\xa0\x47\xf9\x17\x63\x05\x08\xa0\x68\xa0\x70\x17\x63\x03\x07\x34\xa0\x56\x08\x23\x06\x06\x23\xa2\x04\x0e\xa0\x44\x63\x06\x23\x06\x12\x62\x02\xa0\x4a\x17\x62\x63\x08\xa0\x58\x9f\xd2\x0e\xa0\x48\x65\x08\x24\x88\x20\x64\x89\x00\x06\x65\x06\x22\x02\x16\xe3\x1f\xa2\x16\x06\x00\x00\x00\x00\x1f\xa2\x1c\x06\x00\x00\x00\x00\x1f\xa2\x22\x06\x00\x00\x00\x00\x1f\xa2\x2e\x06\x00\x00\x00\x00\x16\x1e\x1f\xa2\x28\x06\x00\x00\x00\x00\x16\x14\x20\x8b\x89\x00\x06\x00\x16\x0c\x1f\xa2\x34\x06\x00\x00\x00\x00\x16\x02\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x74\x65\x73\x74\x00\x00\x00\x01\x00\x02\x00\x03\x00\x04\x00\x03\x00\x02\x00\x01\x00\x00\x8e\xea\x4b\x43\xa7\x87\xf9\x01\x0e\xef\x56\x7b\x23\x9a\x34\x6b\x15\xa6\xb4\x0f\xc0\xe4\x4d\x2c\xd4\xa2\x21\x47\xe6\x0a\xef\xf2\xbc\x0f\xb6\xaf"\
	   "\x00"
	

/*************************************************************
*** A.3.2.  State Memory Management_2
*/
#define RFC4465_A_3_2__State_Memory_Management_2\
	   "\xf8\x1b\xa1\x0f\x86\x02\x89\xa2\x04\x1c\x01\xa0\x47\xf9\x17\x63\x05\x08\xa0\x68\xa0\x70\x17\x63\x03\x07\x34\xa0\x56\x08\x23\x06\x06\x23\xa2\x04\x0e\xa0\x44\x63\x06\x23\x06\x12\x62\x02\xa0\x4a\x17\x62\x63\x08\xa0\x58\x9f\xd2\x0e\xa0\x48\x65\x08\x24\x88\x20\x64\x89\x00\x06\x65\x06\x22\x02\x16\xe3\x1f\xa2\x16\x06\x00\x00\x00\x00\x1f\xa2\x1c\x06\x00\x00\x00\x00\x1f\xa2\x22\x06\x00\x00\x00\x00\x1f\xa2\x2e\x06\x00\x00\x00\x00\x16\x1e\x1f\xa2\x28\x06\x00\x00\x00\x00\x16\x14\x20\x8b\x89\x00\x06\x00\x16\x0c\x1f\xa2\x34\x06\x00\x00\x00\x00\x16\x02\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x74\x65\x73\x74\x00\x00\x00\x01\x00\x02\x00\x03\x00\x04\x00\x03\x00\x02\x00\x01\x00\x00\x8e\xea\x4b\x43\xa7\x87\xf9\x01\x0e\xef\x56\x7b\x23\x9a\x34\x6b\x15\xa6\xb4\x0f\xc0\xe4\x4d\x2c\xd4\xa2\x21\x47\xe6\x0a\xef\xf2\xbc\x0f\xb6\xaf"\
	   "\x01"
	

/*************************************************************
*** A.3.2.  State Memory Management_3
*/
#define RFC4465_A_3_2__State_Memory_Management_3\
	   "\xf8\x1b\xa1\x0f\x86\x02\x89\xa2\x04\x1c\x01\xa0\x47\xf9\x17\x63\x05\x08\xa0\x68\xa0\x70\x17\x63\x03\x07\x34\xa0\x56\x08\x23\x06\x06\x23\xa2\x04\x0e\xa0\x44\x63\x06\x23\x06\x12\x62\x02\xa0\x4a\x17\x62\x63\x08\xa0\x58\x9f\xd2\x0e\xa0\x48\x65\x08\x24\x88\x20\x64\x89\x00\x06\x65\x06\x22\x02\x16\xe3\x1f\xa2\x16\x06\x00\x00\x00\x00\x1f\xa2\x1c\x06\x00\x00\x00\x00\x1f\xa2\x22\x06\x00\x00\x00\x00\x1f\xa2\x2e\x06\x00\x00\x00\x00\x16\x1e\x1f\xa2\x28\x06\x00\x00\x00\x00\x16\x14\x20\x8b\x89\x00\x06\x00\x16\x0c\x1f\xa2\x34\x06\x00\x00\x00\x00\x16\x02\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x74\x65\x73\x74\x00\x00\x00\x01\x00\x02\x00\x03\x00\x04\x00\x03\x00\x02\x00\x01\x00\x00\x8e\xea\x4b\x43\xa7\x87\xf9\x01\x0e\xef\x56\x7b\x23\x9a\x34\x6b\x15\xa6\xb4\x0f\xc0\xe4\x4d\x2c\xd4\xa2\x21\x47\xe6\x0a\xef\xf2\xbc\x0f\xb6\xaf"\
	   "\x02"
	

/*************************************************************
*** A.3.2.  State Memory Management_4
*/
#define RFC4465_A_3_2__State_Memory_Management_4\
	   "\xf8\x1b\xa1\x0f\x86\x02\x89\xa2\x04\x1c\x01\xa0\x47\xf9\x17\x63\x05\x08\xa0\x68\xa0\x70\x17\x63\x03\x07\x34\xa0\x56\x08\x23\x06\x06\x23\xa2\x04\x0e\xa0\x44\x63\x06\x23\x06\x12\x62\x02\xa0\x4a\x17\x62\x63\x08\xa0\x58\x9f\xd2\x0e\xa0\x48\x65\x08\x24\x88\x20\x64\x89\x00\x06\x65\x06\x22\x02\x16\xe3\x1f\xa2\x16\x06\x00\x00\x00\x00\x1f\xa2\x1c\x06\x00\x00\x00\x00\x1f\xa2\x22\x06\x00\x00\x00\x00\x1f\xa2\x2e\x06\x00\x00\x00\x00\x16\x1e\x1f\xa2\x28\x06\x00\x00\x00\x00\x16\x14\x20\x8b\x89\x00\x06\x00\x16\x0c\x1f\xa2\x34\x06\x00\x00\x00\x00\x16\x02\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x74\x65\x73\x74\x00\x00\x00\x01\x00\x02\x00\x03\x00\x04\x00\x03\x00\x02\x00\x01\x00\x00\x8e\xea\x4b\x43\xa7\x87\xf9\x01\x0e\xef\x56\x7b\x23\x9a\x34\x6b\x15\xa6\xb4\x0f\xc0\xe4\x4d\x2c\xd4\xa2\x21\x47\xe6\x0a\xef\xf2\xbc\x0f\xb6\xaf"\
	   "\x03"
	

/*************************************************************
*** A.3.2.  State Memory Management_5
*/
#define RFC4465_A_3_2__State_Memory_Management_5\
	   "\xf8\x1b\xa1\x0f\x86\x02\x89\xa2\x04\x1c\x01\xa0\x47\xf9\x17\x63\x05\x08\xa0\x68\xa0\x70\x17\x63\x03\x07\x34\xa0\x56\x08\x23\x06\x06\x23\xa2\x04\x0e\xa0\x44\x63\x06\x23\x06\x12\x62\x02\xa0\x4a\x17\x62\x63\x08\xa0\x58\x9f\xd2\x0e\xa0\x48\x65\x08\x24\x88\x20\x64\x89\x00\x06\x65\x06\x22\x02\x16\xe3\x1f\xa2\x16\x06\x00\x00\x00\x00\x1f\xa2\x1c\x06\x00\x00\x00\x00\x1f\xa2\x22\x06\x00\x00\x00\x00\x1f\xa2\x2e\x06\x00\x00\x00\x00\x16\x1e\x1f\xa2\x28\x06\x00\x00\x00\x00\x16\x14\x20\x8b\x89\x00\x06\x00\x16\x0c\x1f\xa2\x34\x06\x00\x00\x00\x00\x16\x02\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x74\x65\x73\x74\x00\x00\x00\x01\x00\x02\x00\x03\x00\x04\x00\x03\x00\x02\x00\x01\x00\x00\x8e\xea\x4b\x43\xa7\x87\xf9\x01\x0e\xef\x56\x7b\x23\x9a\x34\x6b\x15\xa6\xb4\x0f\xc0\xe4\x4d\x2c\xd4\xa2\x21\x47\xe6\x0a\xef\xf2\xbc\x0f\xb6\xaf"\
	   "\x04"
	

/*************************************************************
*** A.3.2.  State Memory Management_6
*/
#define RFC4465_A_3_2__State_Memory_Management_6\
	   "\xf8\x1b\xa1\x0f\x86\x02\x89\xa2\x04\x1c\x01\xa0\x47\xf9\x17\x63\x05\x08\xa0\x68\xa0\x70\x17\x63\x03\x07\x34\xa0\x56\x08\x23\x06\x06\x23\xa2\x04\x0e\xa0\x44\x63\x06\x23\x06\x12\x62\x02\xa0\x4a\x17\x62\x63\x08\xa0\x58\x9f\xd2\x0e\xa0\x48\x65\x08\x24\x88\x20\x64\x89\x00\x06\x65\x06\x22\x02\x16\xe3\x1f\xa2\x16\x06\x00\x00\x00\x00\x1f\xa2\x1c\x06\x00\x00\x00\x00\x1f\xa2\x22\x06\x00\x00\x00\x00\x1f\xa2\x2e\x06\x00\x00\x00\x00\x16\x1e\x1f\xa2\x28\x06\x00\x00\x00\x00\x16\x14\x20\x8b\x89\x00\x06\x00\x16\x0c\x1f\xa2\x34\x06\x00\x00\x00\x00\x16\x02\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x74\x65\x73\x74\x00\x00\x00\x01\x00\x02\x00\x03\x00\x04\x00\x03\x00\x02\x00\x01\x00\x00\x8e\xea\x4b\x43\xa7\x87\xf9\x01\x0e\xef\x56\x7b\x23\x9a\x34\x6b\x15\xa6\xb4\x0f\xc0\xe4\x4d\x2c\xd4\xa2\x21\x47\xe6\x0a\xef\xf2\xbc\x0f\xb6\xaf"\
	   "\x05"
	

/*************************************************************
*** A.3.2.  State Memory Management_7
*/
#define RFC4465_A_3_2__State_Memory_Management_7\
	   "\xf8\x1b\xa1\x0f\x86\x02\x89\xa2\x04\x1c\x01\xa0\x47\xf9\x17\x63\x05\x08\xa0\x68\xa0\x70\x17\x63\x03\x07\x34\xa0\x56\x08\x23\x06\x06\x23\xa2\x04\x0e\xa0\x44\x63\x06\x23\x06\x12\x62\x02\xa0\x4a\x17\x62\x63\x08\xa0\x58\x9f\xd2\x0e\xa0\x48\x65\x08\x24\x88\x20\x64\x89\x00\x06\x65\x06\x22\x02\x16\xe3\x1f\xa2\x16\x06\x00\x00\x00\x00\x1f\xa2\x1c\x06\x00\x00\x00\x00\x1f\xa2\x22\x06\x00\x00\x00\x00\x1f\xa2\x2e\x06\x00\x00\x00\x00\x16\x1e\x1f\xa2\x28\x06\x00\x00\x00\x00\x16\x14\x20\x8b\x89\x00\x06\x00\x16\x0c\x1f\xa2\x34\x06\x00\x00\x00\x00\x16\x02\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x74\x65\x73\x74\x00\x00\x00\x01\x00\x02\x00\x03\x00\x04\x00\x03\x00\x02\x00\x01\x00\x00\x8e\xea\x4b\x43\xa7\x87\xf9\x01\x0e\xef\x56\x7b\x23\x9a\x34\x6b\x15\xa6\xb4\x0f\xc0\xe4\x4d\x2c\xd4\xa2\x21\x47\xe6\x0a\xef\xf2\xbc\x0f\xb6\xaf"\
	   "\x06"
	

/*************************************************************
*** A.3.3.  Multiple Compartments_1
*/
#define RFC4465_A_3_3__Multiple_Compartments_1\
	   "\xf8\x1b\x11\x0f\x86\x02\x89\xa2\x07\x1c\x01\xa0\x45\xf9\x17\x62\x03\x0d\x3d\x06\x17\x62\x05\x37\x86\xa0\x68\x06\x22\x89\x20\xa1\xc0\x62\x00\x06\x00\x06\x22\x03\x20\xa1\xc0\x62\x00\x06\x00\x07\x22\xa2\x02\x0a\x22\x03\x06\x22\xa2\x03\x20\xa1\xc0\x62\x00\x06\x00\x20\xa1\xc0\xa2\x06\x00\x06\x62\x16\x2b\x20\xa7\xc0\x20\x00\x06\x00\x16\x22\x1f\xa2\x13\x06\x00\x00\x00\x00\x1f\xa2\x19\x06\x00\x00\x00\x00\x1f\xa2\x25\x06\x00\x00\x00\x00\x1f\xa2\x2b\x06\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x17\x62\x07\x06\x10\x1a\x1f\xa2\x07\x06\x00\x00\x00\x00\x16\xea\x1f\xa2\x0d\x06\x00\x00\x00\x00\x16\xe0\x1f\xa2\x1f\x06\x00\x00\x00\x00\x16\x9f\xd6\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x02\x03\x04\x05\x06\xac\xa6\x0b\x8e\xb2\x83\x9d\xbf\xaf\xc6\x3d\xd2\x34\xc5\xd9\x1d\x53\x61\xbd\xd6\xba\x2a\xc6\x5a\x47\xc2\x18\x14\xee\x07\xc2\x75\x94\x1d\xd7\xa1\x48\x87\x9c\x8d\xe9\x0e"\
	   "\x00"
	

/*************************************************************
*** A.3.3.  Multiple Compartments_2
*/
#define RFC4465_A_3_3__Multiple_Compartments_2\
	   "\xf8\x1b\x11\x0f\x86\x02\x89\xa2\x07\x1c\x01\xa0\x45\xf9\x17\x62\x03\x0d\x3d\x06\x17\x62\x05\x37\x86\xa0\x68\x06\x22\x89\x20\xa1\xc0\x62\x00\x06\x00\x06\x22\x03\x20\xa1\xc0\x62\x00\x06\x00\x07\x22\xa2\x02\x0a\x22\x03\x06\x22\xa2\x03\x20\xa1\xc0\x62\x00\x06\x00\x20\xa1\xc0\xa2\x06\x00\x06\x62\x16\x2b\x20\xa7\xc0\x20\x00\x06\x00\x16\x22\x1f\xa2\x13\x06\x00\x00\x00\x00\x1f\xa2\x19\x06\x00\x00\x00\x00\x1f\xa2\x25\x06\x00\x00\x00\x00\x1f\xa2\x2b\x06\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x17\x62\x07\x06\x10\x1a\x1f\xa2\x07\x06\x00\x00\x00\x00\x16\xea\x1f\xa2\x0d\x06\x00\x00\x00\x00\x16\xe0\x1f\xa2\x1f\x06\x00\x00\x00\x00\x16\x9f\xd6\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x02\x03\x04\x05\x06\xac\xa6\x0b\x8e\xb2\x83\x9d\xbf\xaf\xc6\x3d\xd2\x34\xc5\xd9\x1d\x53\x61\xbd\xd6\xba\x2a\xc6\x5a\x47\xc2\x18\x14\xee\x07\xc2\x75\x94\x1d\xd7\xa1\x48\x87\x9c\x8d\xe9\x0e"\
	   "\x01"
	

/*************************************************************
*** A.3.3.  Multiple Compartments_3
*/
#define RFC4465_A_3_3__Multiple_Compartments_3\
	   "\xf8\x1b\x11\x0f\x86\x02\x89\xa2\x07\x1c\x01\xa0\x45\xf9\x17\x62\x03\x0d\x3d\x06\x17\x62\x05\x37\x86\xa0\x68\x06\x22\x89\x20\xa1\xc0\x62\x00\x06\x00\x06\x22\x03\x20\xa1\xc0\x62\x00\x06\x00\x07\x22\xa2\x02\x0a\x22\x03\x06\x22\xa2\x03\x20\xa1\xc0\x62\x00\x06\x00\x20\xa1\xc0\xa2\x06\x00\x06\x62\x16\x2b\x20\xa7\xc0\x20\x00\x06\x00\x16\x22\x1f\xa2\x13\x06\x00\x00\x00\x00\x1f\xa2\x19\x06\x00\x00\x00\x00\x1f\xa2\x25\x06\x00\x00\x00\x00\x1f\xa2\x2b\x06\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x17\x62\x07\x06\x10\x1a\x1f\xa2\x07\x06\x00\x00\x00\x00\x16\xea\x1f\xa2\x0d\x06\x00\x00\x00\x00\x16\xe0\x1f\xa2\x1f\x06\x00\x00\x00\x00\x16\x9f\xd6\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x02\x03\x04\x05\x06\xac\xa6\x0b\x8e\xb2\x83\x9d\xbf\xaf\xc6\x3d\xd2\x34\xc5\xd9\x1d\x53\x61\xbd\xd6\xba\x2a\xc6\x5a\x47\xc2\x18\x14\xee\x07\xc2\x75\x94\x1d\xd7\xa1\x48\x87\x9c\x8d\xe9\x0e"\
	   "\x02"
	

/*************************************************************
*** A.3.3.  Multiple Compartments_4
*/
#define RFC4465_A_3_3__Multiple_Compartments_4\
	   "\xf8\x1b\x11\x0f\x86\x02\x89\xa2\x07\x1c\x01\xa0\x45\xf9\x17\x62\x03\x0d\x3d\x06\x17\x62\x05\x37\x86\xa0\x68\x06\x22\x89\x20\xa1\xc0\x62\x00\x06\x00\x06\x22\x03\x20\xa1\xc0\x62\x00\x06\x00\x07\x22\xa2\x02\x0a\x22\x03\x06\x22\xa2\x03\x20\xa1\xc0\x62\x00\x06\x00\x20\xa1\xc0\xa2\x06\x00\x06\x62\x16\x2b\x20\xa7\xc0\x20\x00\x06\x00\x16\x22\x1f\xa2\x13\x06\x00\x00\x00\x00\x1f\xa2\x19\x06\x00\x00\x00\x00\x1f\xa2\x25\x06\x00\x00\x00\x00\x1f\xa2\x2b\x06\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x17\x62\x07\x06\x10\x1a\x1f\xa2\x07\x06\x00\x00\x00\x00\x16\xea\x1f\xa2\x0d\x06\x00\x00\x00\x00\x16\xe0\x1f\xa2\x1f\x06\x00\x00\x00\x00\x16\x9f\xd6\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x02\x03\x04\x05\x06\xac\xa6\x0b\x8e\xb2\x83\x9d\xbf\xaf\xc6\x3d\xd2\x34\xc5\xd9\x1d\x53\x61\xbd\xd6\xba\x2a\xc6\x5a\x47\xc2\x18\x14\xee\x07\xc2\x75\x94\x1d\xd7\xa1\x48\x87\x9c\x8d\xe9\x0e"\
	   "\x03"
	

/*************************************************************
*** A.3.3.  Multiple Compartments_5
*/
#define RFC4465_A_3_3__Multiple_Compartments_5\
	   "\xf8\x1b\x11\x0f\x86\x02\x89\xa2\x07\x1c\x01\xa0\x45\xf9\x17\x62\x03\x0d\x3d\x06\x17\x62\x05\x37\x86\xa0\x68\x06\x22\x89\x20\xa1\xc0\x62\x00\x06\x00\x06\x22\x03\x20\xa1\xc0\x62\x00\x06\x00\x07\x22\xa2\x02\x0a\x22\x03\x06\x22\xa2\x03\x20\xa1\xc0\x62\x00\x06\x00\x20\xa1\xc0\xa2\x06\x00\x06\x62\x16\x2b\x20\xa7\xc0\x20\x00\x06\x00\x16\x22\x1f\xa2\x13\x06\x00\x00\x00\x00\x1f\xa2\x19\x06\x00\x00\x00\x00\x1f\xa2\x25\x06\x00\x00\x00\x00\x1f\xa2\x2b\x06\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x17\x62\x07\x06\x10\x1a\x1f\xa2\x07\x06\x00\x00\x00\x00\x16\xea\x1f\xa2\x0d\x06\x00\x00\x00\x00\x16\xe0\x1f\xa2\x1f\x06\x00\x00\x00\x00\x16\x9f\xd6\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x02\x03\x04\x05\x06\xac\xa6\x0b\x8e\xb2\x83\x9d\xbf\xaf\xc6\x3d\xd2\x34\xc5\xd9\x1d\x53\x61\xbd\xd6\xba\x2a\xc6\x5a\x47\xc2\x18\x14\xee\x07\xc2\x75\x94\x1d\xd7\xa1\x48\x87\x9c\x8d\xe9\x0e"\
	   "\x04"
	

/*************************************************************
*** A.3.3.  Multiple Compartments_6
*/
#define RFC4465_A_3_3__Multiple_Compartments_6\
	   "\xf8\x1b\x11\x0f\x86\x02\x89\xa2\x07\x1c\x01\xa0\x45\xf9\x17\x62\x03\x0d\x3d\x06\x17\x62\x05\x37\x86\xa0\x68\x06\x22\x89\x20\xa1\xc0\x62\x00\x06\x00\x06\x22\x03\x20\xa1\xc0\x62\x00\x06\x00\x07\x22\xa2\x02\x0a\x22\x03\x06\x22\xa2\x03\x20\xa1\xc0\x62\x00\x06\x00\x20\xa1\xc0\xa2\x06\x00\x06\x62\x16\x2b\x20\xa7\xc0\x20\x00\x06\x00\x16\x22\x1f\xa2\x13\x06\x00\x00\x00\x00\x1f\xa2\x19\x06\x00\x00\x00\x00\x1f\xa2\x25\x06\x00\x00\x00\x00\x1f\xa2\x2b\x06\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x17\x62\x07\x06\x10\x1a\x1f\xa2\x07\x06\x00\x00\x00\x00\x16\xea\x1f\xa2\x0d\x06\x00\x00\x00\x00\x16\xe0\x1f\xa2\x1f\x06\x00\x00\x00\x00\x16\x9f\xd6\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x02\x03\x04\x05\x06\xac\xa6\x0b\x8e\xb2\x83\x9d\xbf\xaf\xc6\x3d\xd2\x34\xc5\xd9\x1d\x53\x61\xbd\xd6\xba\x2a\xc6\x5a\x47\xc2\x18\x14\xee\x07\xc2\x75\x94\x1d\xd7\xa1\x48\x87\x9c\x8d\xe9\x0e"\
	   "\x05"
	

/*************************************************************
*** A.3.3.  Multiple Compartments_7
*/
#define RFC4465_A_3_3__Multiple_Compartments_7\
	   "\xf8\x1b\x11\x0f\x86\x02\x89\xa2\x07\x1c\x01\xa0\x45\xf9\x17\x62\x03\x0d\x3d\x06\x17\x62\x05\x37\x86\xa0\x68\x06\x22\x89\x20\xa1\xc0\x62\x00\x06\x00\x06\x22\x03\x20\xa1\xc0\x62\x00\x06\x00\x07\x22\xa2\x02\x0a\x22\x03\x06\x22\xa2\x03\x20\xa1\xc0\x62\x00\x06\x00\x20\xa1\xc0\xa2\x06\x00\x06\x62\x16\x2b\x20\xa7\xc0\x20\x00\x06\x00\x16\x22\x1f\xa2\x13\x06\x00\x00\x00\x00\x1f\xa2\x19\x06\x00\x00\x00\x00\x1f\xa2\x25\x06\x00\x00\x00\x00\x1f\xa2\x2b\x06\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x17\x62\x07\x06\x10\x1a\x1f\xa2\x07\x06\x00\x00\x00\x00\x16\xea\x1f\xa2\x0d\x06\x00\x00\x00\x00\x16\xe0\x1f\xa2\x1f\x06\x00\x00\x00\x00\x16\x9f\xd6\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x02\x03\x04\x05\x06\xac\xa6\x0b\x8e\xb2\x83\x9d\xbf\xaf\xc6\x3d\xd2\x34\xc5\xd9\x1d\x53\x61\xbd\xd6\xba\x2a\xc6\x5a\x47\xc2\x18\x14\xee\x07\xc2\x75\x94\x1d\xd7\xa1\x48\x87\x9c\x8d\xe9\x0e"\
	   "\x06"
	

/*************************************************************
*** A.3.3.  Multiple Compartments_8
*/
#define RFC4465_A_3_3__Multiple_Compartments_8\
	   "\xf8\x1b\x11\x0f\x86\x02\x89\xa2\x07\x1c\x01\xa0\x45\xf9\x17\x62\x03\x0d\x3d\x06\x17\x62\x05\x37\x86\xa0\x68\x06\x22\x89\x20\xa1\xc0\x62\x00\x06\x00\x06\x22\x03\x20\xa1\xc0\x62\x00\x06\x00\x07\x22\xa2\x02\x0a\x22\x03\x06\x22\xa2\x03\x20\xa1\xc0\x62\x00\x06\x00\x20\xa1\xc0\xa2\x06\x00\x06\x62\x16\x2b\x20\xa7\xc0\x20\x00\x06\x00\x16\x22\x1f\xa2\x13\x06\x00\x00\x00\x00\x1f\xa2\x19\x06\x00\x00\x00\x00\x1f\xa2\x25\x06\x00\x00\x00\x00\x1f\xa2\x2b\x06\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x17\x62\x07\x06\x10\x1a\x1f\xa2\x07\x06\x00\x00\x00\x00\x16\xea\x1f\xa2\x0d\x06\x00\x00\x00\x00\x16\xe0\x1f\xa2\x1f\x06\x00\x00\x00\x00\x16\x9f\xd6\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x02\x03\x04\x05\x06\xac\xa6\x0b\x8e\xb2\x83\x9d\xbf\xaf\xc6\x3d\xd2\x34\xc5\xd9\x1d\x53\x61\xbd\xd6\xba\x2a\xc6\x5a\x47\xc2\x18\x14\xee\x07\xc2\x75\x94\x1d\xd7\xa1\x48\x87\x9c\x8d\xe9\x0e"\
	   "\x07"
	

/*************************************************************
*** A.3.3.  Multiple Compartments_9
*/
#define RFC4465_A_3_3__Multiple_Compartments_9\
	   "\xf8\x1b\x11\x0f\x86\x02\x89\xa2\x07\x1c\x01\xa0\x45\xf9\x17\x62\x03\x0d\x3d\x06\x17\x62\x05\x37\x86\xa0\x68\x06\x22\x89\x20\xa1\xc0\x62\x00\x06\x00\x06\x22\x03\x20\xa1\xc0\x62\x00\x06\x00\x07\x22\xa2\x02\x0a\x22\x03\x06\x22\xa2\x03\x20\xa1\xc0\x62\x00\x06\x00\x20\xa1\xc0\xa2\x06\x00\x06\x62\x16\x2b\x20\xa7\xc0\x20\x00\x06\x00\x16\x22\x1f\xa2\x13\x06\x00\x00\x00\x00\x1f\xa2\x19\x06\x00\x00\x00\x00\x1f\xa2\x25\x06\x00\x00\x00\x00\x1f\xa2\x2b\x06\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x17\x62\x07\x06\x10\x1a\x1f\xa2\x07\x06\x00\x00\x00\x00\x16\xea\x1f\xa2\x0d\x06\x00\x00\x00\x00\x16\xe0\x1f\xa2\x1f\x06\x00\x00\x00\x00\x16\x9f\xd6\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x02\x03\x04\x05\x06\xac\xa6\x0b\x8e\xb2\x83\x9d\xbf\xaf\xc6\x3d\xd2\x34\xc5\xd9\x1d\x53\x61\xbd\xd6\xba\x2a\xc6\x5a\x47\xc2\x18\x14\xee\x07\xc2\x75\x94\x1d\xd7\xa1\x48\x87\x9c\x8d\xe9\x0e"\
	   "\x08"
	

/*************************************************************
*** A.3.4.  Accessing RFC 3485 State
*/
#define RFC4465_A_3_4__Accessing_RFC_3485_State\
	   "\xf8\x03\xa1\x1f\xa0\xa6\x14\xac\xfe\x01\x20\x00\x1f\xa0\xa6\x06\xac\xff\x01\x21\x00\x1f\xa0\xa6\x0c\xad\x00\x01\x22\x00\x22\x20\x03\x23\x00\x00\x00\x00\x00\x00\x00\xfb\xe5\x07\xdf\xe5\xe6\xaa\x5a\xf2\xab\xb9\x14\xce\xaa\x05\xf9\x9c\xe6\x1b\xa5"\
	   ""
	

/*************************************************************
*** A.3.5.  Bytecode State Creation_1
*/
#define RFC4465_A_3_5__Bytecode_State_Creation_1\
	   "\xf8\x04\x61\x12\xa0\xbe\x08\x1e\x20\x08\x1e\x21\x06\x0a\x0e\x23\xbe\x03\x12\xa0\xbe\x08\xa0\x50\x20\x08\xa0\x50\xa0\x53\x14\x0a\x20\x08\xa0\x50\xa0\x53\x0c\x0a\x16\x06\x00\x4f\x4b\x31\x1c\x01\xa0\xb3\xfc\x22\xa0\xa8\x03\x23\x00\x00\x0d\xa0\xa8\xa0\xab\x06\x0a\x4f\x4b\x32\x22\xa0\x50\x03\x23\x02"\
	   ""
	

/*************************************************************
*** A.3.5.  Bytecode State Creation_2
*/
#define RFC4465_A_3_5__Bytecode_State_Creation_2\
	   "\xf9\x05\xb8\x8c\xe7\x2c\x91\x03"\
	   ""
	

/*************************************************************
*** A.3.5.  Bytecode State Creation_3
*/
#define RFC4465_A_3_5__Bytecode_State_Creation_3\
	   "\xfb\x24\x63\xcd\xff\x5c\xf8\xc7\x6d\xf6\xa2\x89\xff"\
	   ""
	

/*************************************************************
*** A.3.5.  Bytecode State Creation_4
*/
#define RFC4465_A_3_5__Bytecode_State_Creation_4\
	   "\xf9\x5b\x4b\x43\xd5\x67\x83"\
	   ""
	

/*************************************************************
*** A.3.5.  Bytecode State Creation_5
*/
#define RFC4465_A_3_5__Bytecode_State_Creation_5\
	   "\xf9\xde\x81\x26\x11\x99\x1f"\
	   ""

#endif /* _RFC4465_TORTURE_TESTS_H_ */