/*
 * Decompiled with CFR 0.152.
 */
package com.expway.msp.rpc;

import com.expway.msp.IMspStreamingManager;
import com.expway.msp.MspException;
import com.expway.msp.event.service.IServiceStreamingListener;
import com.expway.msp.event.service.ServiceStreamingEvent;
import com.expway.msp.event.service.ServiceStreamingOpenedEvent;
import com.expway.msp.rpc.MspAbstractModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

abstract class MspModuleStreamingManager
extends MspAbstractModule
implements IMspStreamingManager {
    private ArrayList<IServiceStreamingListener> all_service_Streaming_listeners = new ArrayList();
    private Set<String> hs_services = Collections.synchronizedSet(new HashSet());

    MspModuleStreamingManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServiceStreamingListener(IServiceStreamingListener listener) {
        ArrayList<IServiceStreamingListener> arrayList = this.all_service_Streaming_listeners;
        synchronized (arrayList) {
            if (!this.all_service_Streaming_listeners.contains(listener)) {
                this.all_service_Streaming_listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServiceStreamingListener(IServiceStreamingListener listener) {
        ArrayList<IServiceStreamingListener> arrayList = this.all_service_Streaming_listeners;
        synchronized (arrayList) {
            this.all_service_Streaming_listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireStreamingOpenedEvent(ServiceStreamingOpenedEvent event) {
        this.hs_services.add(event.getServiceId());
        ArrayList<IServiceStreamingListener> arrayList = this.all_service_Streaming_listeners;
        synchronized (arrayList) {
            for (IServiceStreamingListener l : this.all_service_Streaming_listeners) {
                try {
                    l.streamingOpened(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireStreamingAlreadyOpenedEvent(ServiceStreamingOpenedEvent event) {
        this.hs_services.add(event.getServiceId());
        ArrayList<IServiceStreamingListener> arrayList = this.all_service_Streaming_listeners;
        synchronized (arrayList) {
            for (IServiceStreamingListener l : this.all_service_Streaming_listeners) {
                try {
                    l.streamingAlreadyOpened(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireStreamingClosedEvent(ServiceStreamingEvent event) {
        this.hs_services.remove(event.getServiceId());
        ArrayList<IServiceStreamingListener> arrayList = this.all_service_Streaming_listeners;
        synchronized (arrayList) {
            for (IServiceStreamingListener l : this.all_service_Streaming_listeners) {
                try {
                    l.streamingClosed(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireStreamingAlreadyClosedEvent(ServiceStreamingEvent event) {
        this.hs_services.remove(event.getServiceId());
        ArrayList<IServiceStreamingListener> arrayList = this.all_service_Streaming_listeners;
        synchronized (arrayList) {
            for (IServiceStreamingListener l : this.all_service_Streaming_listeners) {
                try {
                    l.streamingAlreadyClosed(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    @Override
    public abstract void openStreamingService(String var1, String var2) throws MspException;

    @Override
    public abstract void openStreamingService(String var1, String var2, String var3) throws MspException;

    @Override
    public abstract void closeStreamingService(String var1) throws MspException;
}

