/*
 * Decompiled with CFR 0.152.
 */
package com.expway.msp.rpc;

import java.io.IOException;
import java.io.InputStream;

class LimitedInputStream
extends InputStream {
    private InputStream in;
    private long remaining;

    public LimitedInputStream(InputStream in, long size) {
        this.in = size <= 0L ? null : in;
        this.remaining = size;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            while (this.remaining > 0L) {
                try {
                    long r = this.in.skip(this.remaining);
                    if (r > 0L) {
                        this.remaining -= r;
                        continue;
                    }
                    this.in.close();
                    break;
                }
                catch (IOException ioex) {
                    this.in.close();
                    throw ioex;
                }
            }
            this.in = null;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.in == null || this.remaining <= 0L) {
            return -1;
        }
        int r = this.in.read();
        if (r >= 0) {
            --this.remaining;
            if (this.remaining == 0L) {
                this.close();
            }
        } else {
            this.in.close();
            this.in = null;
            throw new IOException("Truncated data");
        }
        return r;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if ((long)len > this.remaining) {
            len = (int)this.remaining;
        }
        if (len == 0) {
            return 0;
        }
        if (this.in == null || this.remaining <= 0L) {
            return -1;
        }
        int r = this.in.read(b, off, len);
        if (r >= 0) {
            this.remaining -= (long)r;
            if (this.remaining == 0L) {
                this.close();
            }
        } else {
            this.in.close();
            this.in = null;
            throw new IOException("Truncated data");
        }
        return r;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n > this.remaining) {
            n = this.remaining;
        }
        if (n == 0L) {
            return 0L;
        }
        if (this.in == null || this.remaining <= 0L) {
            return 0L;
        }
        long r = this.in.skip(n);
        if (r >= 0L) {
            this.remaining -= r;
            if (this.remaining == 0L) {
                this.close();
            }
        } else {
            this.in.close();
            this.in = null;
            throw new IOException("Truncated data");
        }
        return r;
    }
}

