/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.10
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIGJAVA
#define SWIG_DIRECTORS


#ifdef __cplusplus
/* SwigValueWrapper is described in swig.swg */
template<typename T> class SwigValueWrapper {
  struct SwigMovePointer {
    T *ptr;
    SwigMovePointer(T *p) : ptr(p) { }
    ~SwigMovePointer() { delete ptr; }
    SwigMovePointer& operator=(SwigMovePointer& rhs) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = rhs.ptr; rhs.ptr = 0; return *this; }
  } pointer;
  SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
  SwigValueWrapper(const SwigValueWrapper<T>& rhs);
public:
  SwigValueWrapper() : pointer(0) { }
  SwigValueWrapper& operator=(const T& t) { SwigMovePointer tmp(new T(t)); pointer = tmp; return *this; }
  operator T&() const { return *pointer.ptr; }
  T *operator&() { return pointer.ptr; }
};

template <typename T> T SwigValueInit() {
  return T();
}
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__)) 
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__)) 
# else
#   define SWIGUNUSED 
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif 
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#  ifndef GCC_HASCLASSVISIBILITY
#    define GCC_HASCLASSVISIBILITY
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif



/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTEL_COMPILER)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" }
  };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else

/* -----------------------------------------------------------------------------
 * director.swg
 *
 * This file contains support for director classes that proxy
 * method calls from C++ to Java extensions.
 * ----------------------------------------------------------------------------- */

#ifdef __cplusplus

#if defined(DEBUG_DIRECTOR_OWNED)
#include <iostream>
#endif

namespace Swig {
  /* Java object wrapper */
  class JObjectWrapper {
  public:
    JObjectWrapper() : jthis_(NULL), weak_global_(true) {
    }

    ~JObjectWrapper() {
      jthis_ = NULL;
      weak_global_ = true;
    }

    bool set(JNIEnv *jenv, jobject jobj, bool mem_own, bool weak_global) {
      if (!jthis_) {
        weak_global_ = weak_global || !mem_own; // hold as weak global if explicitly requested or not owned
        if (jobj)
          jthis_ = weak_global_ ? jenv->NewWeakGlobalRef(jobj) : jenv->NewGlobalRef(jobj);
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> " << jthis_ << std::endl;
#endif
        return true;
      } else {
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> already set" << std::endl;
#endif
        return false;
      }
    }

    jobject get(JNIEnv *jenv) const {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::get(";
      if (jthis_)
        std::cout << jthis_;
      else
        std::cout << "null";
      std::cout << ") -> return new local ref" << std::endl;
#endif
      return (jthis_ ? jenv->NewLocalRef(jthis_) : jthis_);
    }

    void release(JNIEnv *jenv) {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::release(" << jthis_ << "): " << (weak_global_ ? "weak global ref" : "global ref") << std::endl;
#endif
      if (jthis_) {
        if (weak_global_) {
          if (jenv->IsSameObject(jthis_, NULL) == JNI_FALSE)
            jenv->DeleteWeakGlobalRef((jweak)jthis_);
        } else
          jenv->DeleteGlobalRef(jthis_);
      }

      jthis_ = NULL;
      weak_global_ = true;
    }

    /* Only call peek if you know what you are doing wrt to weak/global references */
    jobject peek() {
      return jthis_;
    }

    /* Java proxy releases ownership of C++ object, C++ object is now
       responsible for destruction (creates NewGlobalRef to pin Java
       proxy) */
    void java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      if (take_or_release) {  /* Java takes ownership of C++ object's lifetime. */
        if (!weak_global_) {
          jenv->DeleteGlobalRef(jthis_);
          jthis_ = jenv->NewWeakGlobalRef(jself);
          weak_global_ = true;
        }
      } else { /* Java releases ownership of C++ object's lifetime */
        if (weak_global_) {
          jenv->DeleteWeakGlobalRef((jweak)jthis_);
          jthis_ = jenv->NewGlobalRef(jself);
          weak_global_ = false;
        }
      }
    }

  private:
    /* pointer to Java object */
    jobject jthis_;
    /* Local or global reference flag */
    bool weak_global_;
  };

  /* director base class */
  class Director {
    /* pointer to Java virtual machine */
    JavaVM *swig_jvm_;

  protected:
#if defined (_MSC_VER) && (_MSC_VER<1300)
    class JNIEnvWrapper;
    friend class JNIEnvWrapper;
#endif
    /* Utility class for managing the JNI environment */
    class JNIEnvWrapper {
      const Director *director_;
      JNIEnv *jenv_;
      int env_status;
    public:
      JNIEnvWrapper(const Director *director) : director_(director), jenv_(0), env_status(0) {
#if defined(__ANDROID__)
        JNIEnv **jenv = &jenv_;
#else
        void **jenv = (void **)&jenv_;
#endif
        env_status = director_->swig_jvm_->GetEnv((void **)&jenv_, JNI_VERSION_1_2);
#if defined(SWIG_JAVA_ATTACH_CURRENT_THREAD_AS_DAEMON)
        // Attach a daemon thread to the JVM. Useful when the JVM should not wait for 
        // the thread to exit upon shutdown. Only for jdk-1.4 and later.
        director_->swig_jvm_->AttachCurrentThreadAsDaemon(jenv, NULL);
#else
        director_->swig_jvm_->AttachCurrentThread(jenv, NULL);
#endif
      }
      ~JNIEnvWrapper() {
#if !defined(SWIG_JAVA_NO_DETACH_CURRENT_THREAD)
        // Some JVMs, eg jdk-1.4.2 and lower on Solaris have a bug and crash with the DetachCurrentThread call.
        // However, without this call, the JVM hangs on exit when the thread was not created by the JVM and creates a memory leak.
        if (env_status == JNI_EDETACHED)
          director_->swig_jvm_->DetachCurrentThread();
#endif
      }
      JNIEnv *getJNIEnv() const {
        return jenv_;
      }
    };

    /* Java object wrapper */
    JObjectWrapper swig_self_;

    /* Disconnect director from Java object */
    void swig_disconnect_director_self(const char *disconn_method) {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      jobject jobj = swig_self_.get(jenv);
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "Swig::Director::disconnect_director_self(" << jobj << ")" << std::endl;
#endif
      if (jobj && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
        jmethodID disconn_meth = jenv->GetMethodID(jenv->GetObjectClass(jobj), disconn_method, "()V");
        if (disconn_meth) {
#if defined(DEBUG_DIRECTOR_OWNED)
          std::cout << "Swig::Director::disconnect_director_self upcall to " << disconn_method << std::endl;
#endif
          jenv->CallVoidMethod(jobj, disconn_meth);
        }
      }
      jenv->DeleteLocalRef(jobj);
    }

  public:
    Director(JNIEnv *jenv) : swig_jvm_((JavaVM *) NULL), swig_self_() {
      /* Acquire the Java VM pointer */
      jenv->GetJavaVM(&swig_jvm_);
    }

    virtual ~Director() {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      swig_self_.release(jenv);
    }

    bool swig_set_self(JNIEnv *jenv, jobject jself, bool mem_own, bool weak_global) {
      return swig_self_.set(jenv, jself, mem_own, weak_global);
    }

    jobject swig_get_self(JNIEnv *jenv) const {
      return swig_self_.get(jenv);
    }

    // Change C++ object's ownership, relative to Java
    void swig_java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      swig_self_.java_change_ownership(jenv, jself, take_or_release);
    }
  };
}

#endif /* __cplusplus */


namespace Swig {
  namespace {
    jclass jclass_tinyWRAPJNI = NULL;
    jmethodID director_methids[50];
  }
}

#include <stdint.h>		// Use the C99 official header


#include "tinyWRAP_config.h"
#include "DDebug.h"
#include "DRegisterCallback.h"
#include "AudioResampler.h"


#include "ActionConfig.h"
#include "MediaSessionMgr.h"
#include "MediaContent.h"
#include "SipUri.h"
#include "SipMessage.h"
#include "SipEvent.h"
#include "SipSession.h"

#include "ProxyPluginMgr.h"
#include "ProxyConsumer.h"
#include "ProxyProducer.h"

#include "SipCallback.h"
#include "SafeObject.h"
#include "SipStack.h"


#include "Xcap.h"


#include "SMSEncoder.h"


#include "Msrp.h"


#include "Mcptt.h"



/* ---------------------------------------------------
 * C++ director class methods
 * --------------------------------------------------- */

#include "tinyWRAP_wrap.h"

SwigDirector_DDebugCallback::SwigDirector_DDebugCallback(JNIEnv *jenv) : DDebugCallback(), Swig::Director(jenv) {
}

SwigDirector_DDebugCallback::~SwigDirector_DDebugCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


int SwigDirector_DDebugCallback::OnDebugTest(char const *message) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jmessage = 0 ;
  
  if (!swig_override[0]) {
    return DDebugCallback::OnDebugTest(message);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jmessage = 0;
    if (message) {
      jmessage = jenv->NewStringUTF((const char *)message);
      if (!jmessage) return c_result;
    }
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[0], swigjobj, jmessage);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_DDebugCallback::OnDebugInfo(char const *message) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jmessage = 0 ;
  
  if (!swig_override[1]) {
    return DDebugCallback::OnDebugInfo(message);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jmessage = 0;
    if (message) {
      jmessage = jenv->NewStringUTF((const char *)message);
      if (!jmessage) return c_result;
    }
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[1], swigjobj, jmessage);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_DDebugCallback::OnDebugWarn(char const *message) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jmessage = 0 ;
  
  if (!swig_override[2]) {
    return DDebugCallback::OnDebugWarn(message);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jmessage = 0;
    if (message) {
      jmessage = jenv->NewStringUTF((const char *)message);
      if (!jmessage) return c_result;
    }
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[2], swigjobj, jmessage);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_DDebugCallback::OnDebugError(char const *message) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jmessage = 0 ;
  
  if (!swig_override[3]) {
    return DDebugCallback::OnDebugError(message);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jmessage = 0;
    if (message) {
      jmessage = jenv->NewStringUTF((const char *)message);
      if (!jmessage) return c_result;
    }
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[3], swigjobj, jmessage);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_DDebugCallback::OnDebugFatal(char const *message) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jmessage = 0 ;
  
  if (!swig_override[4]) {
    return DDebugCallback::OnDebugFatal(message);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jmessage = 0;
    if (message) {
      jmessage = jenv->NewStringUTF((const char *)message);
      if (!jmessage) return c_result;
    }
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[4], swigjobj, jmessage);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_DDebugCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "OnDebugTest", "(Ljava/lang/String;)I", NULL 
    },
    {
      "OnDebugInfo", "(Ljava/lang/String;)I", NULL 
    },
    {
      "OnDebugWarn", "(Ljava/lang/String;)I", NULL 
    },
    {
      "OnDebugError", "(Ljava/lang/String;)I", NULL 
    },
    {
      "OnDebugFatal", "(Ljava/lang/String;)I", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/doubango/tinyWRAP/DDebugCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 5; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_DRegisterCallback::SwigDirector_DRegisterCallback(JNIEnv *jenv) : DRegisterCallback(), Swig::Director(jenv) {
}

SwigDirector_DRegisterCallback::~SwigDirector_DRegisterCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


int SwigDirector_DRegisterCallback::onAuthRegister(char const *message) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jmessage = 0 ;
  
  if (!swig_override[0]) {
    return DRegisterCallback::onAuthRegister(message);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jmessage = 0;
    if (message) {
      jmessage = jenv->NewStringUTF((const char *)message);
      if (!jmessage) return c_result;
    }
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[5], swigjobj, jmessage);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_DRegisterCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "onAuthRegister", "(Ljava/lang/String;)I", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/doubango/tinyWRAP/DRegisterCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_T140Callback::SwigDirector_T140Callback(JNIEnv *jenv) : T140Callback(), Swig::Director(jenv) {
}

SwigDirector_T140Callback::~SwigDirector_T140Callback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


int SwigDirector_T140Callback::ondata(T140CallbackData const *pData) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jpData = 0 ;
  
  if (!swig_override[0]) {
    return T140Callback::ondata(pData);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((T140CallbackData **)&jpData) = (T140CallbackData *) pData; 
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[6], swigjobj, jpData);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_T140Callback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "ondata", "(Lorg/doubango/tinyWRAP/T140CallbackData;)I", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/doubango/tinyWRAP/T140Callback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_ProxyPluginMgrCallback::SwigDirector_ProxyPluginMgrCallback(JNIEnv *jenv) : ProxyPluginMgrCallback(), Swig::Director(jenv) {
}

SwigDirector_ProxyPluginMgrCallback::~SwigDirector_ProxyPluginMgrCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


int SwigDirector_ProxyPluginMgrCallback::OnPluginCreated(uint64_t id, enum twrap_proxy_plugin_type_e type) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jid  ;
  jint jtype  ;
  
  if (!swig_override[0]) {
    return ProxyPluginMgrCallback::OnPluginCreated(id,type);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    {
      jbyteArray ba = jenv->NewByteArray(9);
      jbyte* bae = jenv->GetByteArrayElements(ba, 0);
      jclass clazz = jenv->FindClass("java/math/BigInteger");
      jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
      jobject bigint;
      int swig_i;
      
      bae[0] = 0;
      for(swig_i=1; swig_i<9; swig_i++ ) {
        bae[swig_i] = (jbyte)(id>>8*(8-swig_i));
      }
      
      jenv->ReleaseByteArrayElements(ba, bae, 0);
      bigint = jenv->NewObject(clazz, mid, ba);
      jid = bigint;
    }
    jtype = (jint) type;
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[7], swigjobj, jid, jtype);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_ProxyPluginMgrCallback::OnPluginDestroyed(uint64_t id, enum twrap_proxy_plugin_type_e type) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jid  ;
  jint jtype  ;
  
  if (!swig_override[1]) {
    return ProxyPluginMgrCallback::OnPluginDestroyed(id,type);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    {
      jbyteArray ba = jenv->NewByteArray(9);
      jbyte* bae = jenv->GetByteArrayElements(ba, 0);
      jclass clazz = jenv->FindClass("java/math/BigInteger");
      jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
      jobject bigint;
      int swig_i;
      
      bae[0] = 0;
      for(swig_i=1; swig_i<9; swig_i++ ) {
        bae[swig_i] = (jbyte)(id>>8*(8-swig_i));
      }
      
      jenv->ReleaseByteArrayElements(ba, bae, 0);
      bigint = jenv->NewObject(clazz, mid, ba);
      jid = bigint;
    }
    jtype = (jint) type;
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[8], swigjobj, jid, jtype);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_ProxyPluginMgrCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "OnPluginCreated", "(Ljava/math/BigInteger;Lorg/doubango/tinyWRAP/twrap_proxy_plugin_type_t;)I", NULL 
    },
    {
      "OnPluginDestroyed", "(Ljava/math/BigInteger;Lorg/doubango/tinyWRAP/twrap_proxy_plugin_type_t;)I", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/doubango/tinyWRAP/ProxyPluginMgrCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_ProxyAudioConsumerCallback::SwigDirector_ProxyAudioConsumerCallback(JNIEnv *jenv) : ProxyAudioConsumerCallback(), Swig::Director(jenv) {
}

SwigDirector_ProxyAudioConsumerCallback::~SwigDirector_ProxyAudioConsumerCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


int SwigDirector_ProxyAudioConsumerCallback::prepare(int ptime, int rate, int channels) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint jptime  ;
  jint jrate  ;
  jint jchannels  ;
  
  if (!swig_override[0]) {
    return ProxyAudioConsumerCallback::prepare(ptime,rate,channels);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jptime = (jint) ptime;
    jrate = (jint) rate;
    jchannels = (jint) channels;
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[9], swigjobj, jptime, jrate, jchannels);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_ProxyAudioConsumerCallback::start() {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[1]) {
    return ProxyAudioConsumerCallback::start();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[10], swigjobj);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_ProxyAudioConsumerCallback::pause() {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[2]) {
    return ProxyAudioConsumerCallback::pause();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[11], swigjobj);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_ProxyAudioConsumerCallback::stop() {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[3]) {
    return ProxyAudioConsumerCallback::stop();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[12], swigjobj);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_ProxyAudioConsumerCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "prepare", "(III)I", NULL 
    },
    {
      "start", "()I", NULL 
    },
    {
      "pause", "()I", NULL 
    },
    {
      "stop", "()I", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/doubango/tinyWRAP/ProxyAudioConsumerCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 4; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_ProxyVideoConsumerCallback::SwigDirector_ProxyVideoConsumerCallback(JNIEnv *jenv) : ProxyVideoConsumerCallback(), Swig::Director(jenv) {
}

SwigDirector_ProxyVideoConsumerCallback::~SwigDirector_ProxyVideoConsumerCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


int SwigDirector_ProxyVideoConsumerCallback::prepare(int nWidth, int nHeight, int nFps) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint jnWidth  ;
  jint jnHeight  ;
  jint jnFps  ;
  
  if (!swig_override[0]) {
    return ProxyVideoConsumerCallback::prepare(nWidth,nHeight,nFps);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jnWidth = (jint) nWidth;
    jnHeight = (jint) nHeight;
    jnFps = (jint) nFps;
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[13], swigjobj, jnWidth, jnHeight, jnFps);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_ProxyVideoConsumerCallback::consume(ProxyVideoFrame const *frame) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jframe = 0 ;
  
  if (!swig_override[1]) {
    return ProxyVideoConsumerCallback::consume(frame);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((ProxyVideoFrame **)&jframe) = (ProxyVideoFrame *) frame; 
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[14], swigjobj, jframe);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_ProxyVideoConsumerCallback::bufferCopied(unsigned int nCopiedSize, unsigned int nAvailableSize) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jnCopiedSize  ;
  jlong jnAvailableSize  ;
  
  if (!swig_override[2]) {
    return ProxyVideoConsumerCallback::bufferCopied(nCopiedSize,nAvailableSize);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jnCopiedSize = (jlong) nCopiedSize;
    jnAvailableSize = (jlong) nAvailableSize;
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[15], swigjobj, jnCopiedSize, jnAvailableSize);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_ProxyVideoConsumerCallback::start() {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[3]) {
    return ProxyVideoConsumerCallback::start();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[16], swigjobj);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_ProxyVideoConsumerCallback::pause() {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[4]) {
    return ProxyVideoConsumerCallback::pause();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[17], swigjobj);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_ProxyVideoConsumerCallback::stop() {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[5]) {
    return ProxyVideoConsumerCallback::stop();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[18], swigjobj);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_ProxyVideoConsumerCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "prepare", "(III)I", NULL 
    },
    {
      "consume", "(Lorg/doubango/tinyWRAP/ProxyVideoFrame;)I", NULL 
    },
    {
      "bufferCopied", "(JJ)I", NULL 
    },
    {
      "start", "()I", NULL 
    },
    {
      "pause", "()I", NULL 
    },
    {
      "stop", "()I", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/doubango/tinyWRAP/ProxyVideoConsumerCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 6; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_ProxyAudioProducerCallback::SwigDirector_ProxyAudioProducerCallback(JNIEnv *jenv) : ProxyAudioProducerCallback(), Swig::Director(jenv) {
}

SwigDirector_ProxyAudioProducerCallback::~SwigDirector_ProxyAudioProducerCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


int SwigDirector_ProxyAudioProducerCallback::prepare(int ptime, int rate, int channels) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint jptime  ;
  jint jrate  ;
  jint jchannels  ;
  
  if (!swig_override[0]) {
    return ProxyAudioProducerCallback::prepare(ptime,rate,channels);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jptime = (jint) ptime;
    jrate = (jint) rate;
    jchannels = (jint) channels;
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[19], swigjobj, jptime, jrate, jchannels);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_ProxyAudioProducerCallback::start() {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[1]) {
    return ProxyAudioProducerCallback::start();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[20], swigjobj);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_ProxyAudioProducerCallback::pause() {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[2]) {
    return ProxyAudioProducerCallback::pause();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[21], swigjobj);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_ProxyAudioProducerCallback::stop() {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[3]) {
    return ProxyAudioProducerCallback::stop();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[22], swigjobj);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_ProxyAudioProducerCallback::fillPushBuffer() {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[4]) {
    return ProxyAudioProducerCallback::fillPushBuffer();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[23], swigjobj);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_ProxyAudioProducerCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "prepare", "(III)I", NULL 
    },
    {
      "start", "()I", NULL 
    },
    {
      "pause", "()I", NULL 
    },
    {
      "stop", "()I", NULL 
    },
    {
      "fillPushBuffer", "()I", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/doubango/tinyWRAP/ProxyAudioProducerCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 5; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_ProxyVideoProducerCallback::SwigDirector_ProxyVideoProducerCallback(JNIEnv *jenv) : ProxyVideoProducerCallback(), Swig::Director(jenv) {
}

SwigDirector_ProxyVideoProducerCallback::~SwigDirector_ProxyVideoProducerCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


int SwigDirector_ProxyVideoProducerCallback::prepare(int width, int height, int fps) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint jwidth  ;
  jint jheight  ;
  jint jfps  ;
  
  if (!swig_override[0]) {
    return ProxyVideoProducerCallback::prepare(width,height,fps);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jwidth = (jint) width;
    jheight = (jint) height;
    jfps = (jint) fps;
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[24], swigjobj, jwidth, jheight, jfps);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_ProxyVideoProducerCallback::start() {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[1]) {
    return ProxyVideoProducerCallback::start();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[25], swigjobj);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_ProxyVideoProducerCallback::pause() {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[2]) {
    return ProxyVideoProducerCallback::pause();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[26], swigjobj);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_ProxyVideoProducerCallback::stop() {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[3]) {
    return ProxyVideoProducerCallback::stop();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[27], swigjobj);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_ProxyVideoProducerCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "prepare", "(III)I", NULL 
    },
    {
      "start", "()I", NULL 
    },
    {
      "pause", "()I", NULL 
    },
    {
      "stop", "()I", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/doubango/tinyWRAP/ProxyVideoProducerCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 4; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_SipCallback::SwigDirector_SipCallback(JNIEnv *jenv) : SipCallback(), Swig::Director(jenv) {
}

SwigDirector_SipCallback::~SwigDirector_SipCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


int SwigDirector_SipCallback::OnDialogEvent(DialogEvent const *e) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong je = 0 ;
  
  if (!swig_override[0]) {
    return SipCallback::OnDialogEvent(e);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((DialogEvent **)&je) = (DialogEvent *) e; 
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[28], swigjobj, je);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_SipCallback::OnStackEvent(StackEvent const *e) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong je = 0 ;
  
  if (!swig_override[1]) {
    return SipCallback::OnStackEvent(e);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((StackEvent **)&je) = (StackEvent *) e; 
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[29], swigjobj, je);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_SipCallback::OnInviteEvent(InviteEvent const *e) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong je = 0 ;
  
  if (!swig_override[2]) {
    return SipCallback::OnInviteEvent(e);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((InviteEvent **)&je) = (InviteEvent *) e; 
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[30], swigjobj, je);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_SipCallback::OnMessagingEvent(MessagingEvent const *e) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong je = 0 ;
  
  if (!swig_override[3]) {
    return SipCallback::OnMessagingEvent(e);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((MessagingEvent **)&je) = (MessagingEvent *) e; 
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[31], swigjobj, je);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_SipCallback::OnMessagingAffiliationEvent(MessagingAffiliationEvent const *e) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong je = 0 ;
  
  if (!swig_override[4]) {
    return SipCallback::OnMessagingAffiliationEvent(e);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((MessagingAffiliationEvent **)&je) = (MessagingAffiliationEvent *) e; 
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[32], swigjobj, je);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_SipCallback::OnMessagingMbmsEvent(MessagingMbmsEvent const *e) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong je = 0 ;
  
  if (!swig_override[5]) {
    return SipCallback::OnMessagingMbmsEvent(e);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((MessagingMbmsEvent **)&je) = (MessagingMbmsEvent *) e; 
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[33], swigjobj, je);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_SipCallback::OnMessagingLocationEvent(MessagingLocationEvent const *e) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong je = 0 ;
  
  if (!swig_override[6]) {
    return SipCallback::OnMessagingLocationEvent(e);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((MessagingLocationEvent **)&je) = (MessagingLocationEvent *) e; 
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[34], swigjobj, je);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_SipCallback::OnInfoEvent(InfoEvent const *e) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong je = 0 ;
  
  if (!swig_override[7]) {
    return SipCallback::OnInfoEvent(e);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((InfoEvent **)&je) = (InfoEvent *) e; 
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[35], swigjobj, je);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_SipCallback::OnOptionsEvent(OptionsEvent const *e) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong je = 0 ;
  
  if (!swig_override[8]) {
    return SipCallback::OnOptionsEvent(e);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((OptionsEvent **)&je) = (OptionsEvent *) e; 
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[36], swigjobj, je);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_SipCallback::OnPublicationEvent(PublicationEvent const *e) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong je = 0 ;
  
  if (!swig_override[9]) {
    return SipCallback::OnPublicationEvent(e);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((PublicationEvent **)&je) = (PublicationEvent *) e; 
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[37], swigjobj, je);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_SipCallback::OnPublicationAffiliationEvent(PublicationAffiliationEvent const *e) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong je = 0 ;
  
  if (!swig_override[10]) {
    return SipCallback::OnPublicationAffiliationEvent(e);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((PublicationAffiliationEvent **)&je) = (PublicationAffiliationEvent *) e; 
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[38], swigjobj, je);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_SipCallback::OnPublicationAuthenticationEvent(PublicationAuthenticationEvent const *e) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong je = 0 ;
  
  if (!swig_override[11]) {
    return SipCallback::OnPublicationAuthenticationEvent(e);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((PublicationAuthenticationEvent **)&je) = (PublicationAuthenticationEvent *) e; 
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[39], swigjobj, je);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_SipCallback::OnRegistrationAuthenticationEvent(RegistrationAuthenticationEvent const *e) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong je = 0 ;
  
  if (!swig_override[12]) {
    return SipCallback::OnRegistrationAuthenticationEvent(e);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((RegistrationAuthenticationEvent **)&je) = (RegistrationAuthenticationEvent *) e; 
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[40], swigjobj, je);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_SipCallback::OnRegistrationEvent(RegistrationEvent const *e) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong je = 0 ;
  
  if (!swig_override[13]) {
    return SipCallback::OnRegistrationEvent(e);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((RegistrationEvent **)&je) = (RegistrationEvent *) e; 
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[41], swigjobj, je);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_SipCallback::OnSubscriptionEvent(SubscriptionEvent const *e) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong je = 0 ;
  
  if (!swig_override[14]) {
    return SipCallback::OnSubscriptionEvent(e);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((SubscriptionEvent **)&je) = (SubscriptionEvent *) e; 
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[42], swigjobj, je);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_SipCallback::OnSubscriptionAffiliationEvent(SubscriptionAffiliationEvent const *e) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong je = 0 ;
  
  if (!swig_override[15]) {
    return SipCallback::OnSubscriptionAffiliationEvent(e);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((SubscriptionAffiliationEvent **)&je) = (SubscriptionAffiliationEvent *) e; 
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[43], swigjobj, je);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_SipCallback::OnSubscriptionCMSEvent(SubscriptionCMSEvent const *e) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong je = 0 ;
  
  if (!swig_override[16]) {
    return SipCallback::OnSubscriptionCMSEvent(e);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((SubscriptionCMSEvent **)&je) = (SubscriptionCMSEvent *) e; 
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[44], swigjobj, je);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_SipCallback::OnSubscriptionGMSEvent(SubscriptionGMSEvent const *e) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong je = 0 ;
  
  if (!swig_override[17]) {
    return SipCallback::OnSubscriptionGMSEvent(e);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((SubscriptionGMSEvent **)&je) = (SubscriptionGMSEvent *) e; 
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[45], swigjobj, je);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_SipCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "OnDialogEvent", "(Lorg/doubango/tinyWRAP/DialogEvent;)I", NULL 
    },
    {
      "OnStackEvent", "(Lorg/doubango/tinyWRAP/StackEvent;)I", NULL 
    },
    {
      "OnInviteEvent", "(Lorg/doubango/tinyWRAP/InviteEvent;)I", NULL 
    },
    {
      "OnMessagingEvent", "(Lorg/doubango/tinyWRAP/MessagingEvent;)I", NULL 
    },
    {
      "OnMessagingAffiliationEvent", "(Lorg/doubango/tinyWRAP/MessagingAffiliationEvent;)I", NULL 
    },
    {
      "OnMessagingMbmsEvent", "(Lorg/doubango/tinyWRAP/MessagingMbmsEvent;)I", NULL 
    },
    {
      "OnMessagingLocationEvent", "(Lorg/doubango/tinyWRAP/MessagingLocationEvent;)I", NULL 
    },
    {
      "OnInfoEvent", "(Lorg/doubango/tinyWRAP/InfoEvent;)I", NULL 
    },
    {
      "OnOptionsEvent", "(Lorg/doubango/tinyWRAP/OptionsEvent;)I", NULL 
    },
    {
      "OnPublicationEvent", "(Lorg/doubango/tinyWRAP/PublicationEvent;)I", NULL 
    },
    {
      "OnPublicationAffiliationEvent", "(Lorg/doubango/tinyWRAP/PublicationAffiliationEvent;)I", NULL 
    },
    {
      "OnPublicationAuthenticationEvent", "(Lorg/doubango/tinyWRAP/PublicationAuthenticationEvent;)I", NULL 
    },
    {
      "OnRegistrationAuthenticationEvent", "(Lorg/doubango/tinyWRAP/RegistrationAuthenticationEvent;)I", NULL 
    },
    {
      "OnRegistrationEvent", "(Lorg/doubango/tinyWRAP/RegistrationEvent;)I", NULL 
    },
    {
      "OnSubscriptionEvent", "(Lorg/doubango/tinyWRAP/SubscriptionEvent;)I", NULL 
    },
    {
      "OnSubscriptionAffiliationEvent", "(Lorg/doubango/tinyWRAP/SubscriptionAffiliationEvent;)I", NULL 
    },
    {
      "OnSubscriptionCMSEvent", "(Lorg/doubango/tinyWRAP/SubscriptionCMSEvent;)I", NULL 
    },
    {
      "OnSubscriptionGMSEvent", "(Lorg/doubango/tinyWRAP/SubscriptionGMSEvent;)I", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/doubango/tinyWRAP/SipCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 18; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_XcapCallback::SwigDirector_XcapCallback(JNIEnv *jenv) : XcapCallback(), Swig::Director(jenv) {
}

SwigDirector_XcapCallback::~SwigDirector_XcapCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


int SwigDirector_XcapCallback::onEvent(XcapEvent const *e) const {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong je = 0 ;
  
  if (!swig_override[0]) {
    return XcapCallback::onEvent(e);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((XcapEvent **)&je) = (XcapEvent *) e; 
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[46], swigjobj, je);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_XcapCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "onEvent", "(Lorg/doubango/tinyWRAP/XcapEvent;)I", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/doubango/tinyWRAP/XcapCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_MsrpCallback::SwigDirector_MsrpCallback(JNIEnv *jenv) : MsrpCallback(), Swig::Director(jenv) {
}

SwigDirector_MsrpCallback::~SwigDirector_MsrpCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


int SwigDirector_MsrpCallback::OnEvent(MsrpEvent const *e) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong je = 0 ;
  
  if (!swig_override[0]) {
    return MsrpCallback::OnEvent(e);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((MsrpEvent **)&je) = (MsrpEvent *) e; 
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[47], swigjobj, je);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_MsrpCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "OnEvent", "(Lorg/doubango/tinyWRAP/MsrpEvent;)I", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/doubango/tinyWRAP/MsrpCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_McpttCallback::SwigDirector_McpttCallback(JNIEnv *jenv) : McpttCallback(), Swig::Director(jenv) {
}

SwigDirector_McpttCallback::~SwigDirector_McpttCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


int SwigDirector_McpttCallback::OnEvent(McpttEvent const *e) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong je = 0 ;
  
  if (!swig_override[0]) {
    return McpttCallback::OnEvent(e);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((McpttEvent **)&je) = (McpttEvent *) e; 
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[48], swigjobj, je);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_McpttCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "OnEvent", "(Lorg/doubango/tinyWRAP/McpttEvent;)I", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/doubango/tinyWRAP/McpttCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_McpttMbmsCallback::SwigDirector_McpttMbmsCallback(JNIEnv *jenv) : McpttMbmsCallback(), Swig::Director(jenv) {
}

SwigDirector_McpttMbmsCallback::~SwigDirector_McpttMbmsCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


int SwigDirector_McpttMbmsCallback::OnEvent(McpttMbmsEvent const *e) {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong je = 0 ;
  
  if (!swig_override[0]) {
    return McpttMbmsCallback::OnEvent(e);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((McpttMbmsEvent **)&je) = (McpttMbmsEvent *) e; 
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_tinyWRAPJNI, Swig::director_methids[49], swigjobj, je);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_McpttMbmsCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "OnEvent", "(Lorg/doubango/tinyWRAP/McpttMbmsEvent;)I", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/doubango/tinyWRAP/McpttMbmsCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}



#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1DDebugCallback(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  DDebugCallback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (DDebugCallback *)new SwigDirector_DDebugCallback(jenv);
  *(DDebugCallback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1DDebugCallback(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  DDebugCallback *arg1 = (DDebugCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(DDebugCallback **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_DDebugCallback_1OnDebugTest(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  DDebugCallback *arg1 = (DDebugCallback *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(DDebugCallback **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)(arg1)->OnDebugTest((char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_DDebugCallback_1OnDebugTestSwigExplicitDDebugCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  DDebugCallback *arg1 = (DDebugCallback *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(DDebugCallback **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)(arg1)->DDebugCallback::OnDebugTest((char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_DDebugCallback_1OnDebugInfo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  DDebugCallback *arg1 = (DDebugCallback *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(DDebugCallback **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)(arg1)->OnDebugInfo((char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_DDebugCallback_1OnDebugInfoSwigExplicitDDebugCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  DDebugCallback *arg1 = (DDebugCallback *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(DDebugCallback **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)(arg1)->DDebugCallback::OnDebugInfo((char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_DDebugCallback_1OnDebugWarn(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  DDebugCallback *arg1 = (DDebugCallback *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(DDebugCallback **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)(arg1)->OnDebugWarn((char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_DDebugCallback_1OnDebugWarnSwigExplicitDDebugCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  DDebugCallback *arg1 = (DDebugCallback *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(DDebugCallback **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)(arg1)->DDebugCallback::OnDebugWarn((char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_DDebugCallback_1OnDebugError(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  DDebugCallback *arg1 = (DDebugCallback *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(DDebugCallback **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)(arg1)->OnDebugError((char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_DDebugCallback_1OnDebugErrorSwigExplicitDDebugCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  DDebugCallback *arg1 = (DDebugCallback *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(DDebugCallback **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)(arg1)->DDebugCallback::OnDebugError((char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_DDebugCallback_1OnDebugFatal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  DDebugCallback *arg1 = (DDebugCallback *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(DDebugCallback **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)(arg1)->OnDebugFatal((char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_DDebugCallback_1OnDebugFatalSwigExplicitDDebugCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  DDebugCallback *arg1 = (DDebugCallback *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(DDebugCallback **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)(arg1)->DDebugCallback::OnDebugFatal((char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_DDebugCallback_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  DDebugCallback *obj = *((DDebugCallback **)&objarg);
  (void)jcls;
  SwigDirector_DDebugCallback *director = static_cast<SwigDirector_DDebugCallback *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_DDebugCallback_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  DDebugCallback *obj = *((DDebugCallback **)&objarg);
  SwigDirector_DDebugCallback *director = static_cast<SwigDirector_DDebugCallback *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1DRegisterCallback(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  DRegisterCallback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (DRegisterCallback *)new SwigDirector_DRegisterCallback(jenv);
  *(DRegisterCallback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1DRegisterCallback(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  DRegisterCallback *arg1 = (DRegisterCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(DRegisterCallback **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_DRegisterCallback_1onAuthRegister(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  DRegisterCallback *arg1 = (DRegisterCallback *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(DRegisterCallback **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)(arg1)->onAuthRegister((char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_DRegisterCallback_1onAuthRegisterSwigExplicitDRegisterCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  DRegisterCallback *arg1 = (DRegisterCallback *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(DRegisterCallback **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)(arg1)->DRegisterCallback::onAuthRegister((char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_DRegisterCallback_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  DRegisterCallback *obj = *((DRegisterCallback **)&objarg);
  (void)jcls;
  SwigDirector_DRegisterCallback *director = static_cast<SwigDirector_DRegisterCallback *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_DRegisterCallback_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  DRegisterCallback *obj = *((DRegisterCallback **)&objarg);
  SwigDirector_DRegisterCallback *director = static_cast<SwigDirector_DRegisterCallback *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1AudioResampler(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5) {
  jlong jresult = 0 ;
  uint32_t arg1 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  uint32_t arg4 ;
  uint32_t arg5 ;
  AudioResampler *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32_t)jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  arg4 = (uint32_t)jarg4; 
  arg5 = (uint32_t)jarg5; 
  result = (AudioResampler *)new AudioResampler(arg1,arg2,arg3,arg4,arg5);
  *(AudioResampler **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1AudioResampler(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AudioResampler *arg1 = (AudioResampler *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(AudioResampler **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_AudioResampler_1isValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  AudioResampler *arg1 = (AudioResampler *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(AudioResampler **)&jarg1; 
  result = (bool)(arg1)->isValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_AudioResampler_1getOutputRequiredSizeInShort(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AudioResampler *arg1 = (AudioResampler *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(AudioResampler **)&jarg1; 
  result = (uint32_t)(arg1)->getOutputRequiredSizeInShort();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_AudioResampler_1getInputRequiredSizeInShort(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  AudioResampler *arg1 = (AudioResampler *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(AudioResampler **)&jarg1; 
  result = (uint32_t)(arg1)->getInputRequiredSizeInShort();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_AudioResampler_1process(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3, jbyteArray jarg4, jlong jarg5) {
  jlong jresult = 0 ;
  AudioResampler *arg1 = (AudioResampler *) 0 ;
  void *arg2 = (void *) 0 ;
  uint32_t arg3 ;
  void *arg4 = (void *) 0 ;
  uint32_t arg5 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(AudioResampler **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (uint32_t)jarg3; 
  
  arg4 = jenv->GetDirectBufferAddress(jarg4); 
  
  arg5 = (uint32_t)jarg5; 
  result = (uint32_t)(arg1)->process((void const *)arg2,arg3,arg4,arg5);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1ActionConfig(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  ActionConfig *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (ActionConfig *)new ActionConfig();
  *(ActionConfig **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1ActionConfig(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ActionConfig *arg1 = (ActionConfig *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ActionConfig **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ActionConfig_1addHeader(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jboolean jresult = 0 ;
  ActionConfig *arg1 = (ActionConfig *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ActionConfig **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (bool)(arg1)->addHeader((char const *)arg2,(char const *)arg3);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ActionConfig_1addPayload(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  ActionConfig *arg1 = (ActionConfig *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ActionConfig **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  result = (bool)(arg1)->addPayload((void const *)arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ActionConfig_1setActiveMedia(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  ActionConfig *arg1 = (ActionConfig *) 0 ;
  twrap_media_type_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ActionConfig **)&jarg1; 
  arg2 = (twrap_media_type_t)jarg2; 
  result = (bool)(arg1)->setActiveMedia(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ActionConfig_1setResponseLine(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  ActionConfig *arg1 = (ActionConfig *) 0 ;
  short arg2 ;
  char *arg3 = (char *) 0 ;
  ActionConfig *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ActionConfig **)&jarg1; 
  arg2 = (short)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (ActionConfig *)(arg1)->setResponseLine(arg2,(char const *)arg3);
  *(ActionConfig **)&jresult = result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ActionConfig_1setMediaString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3, jstring jarg4) {
  jlong jresult = 0 ;
  ActionConfig *arg1 = (ActionConfig *) 0 ;
  twrap_media_type_t arg2 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  ActionConfig *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ActionConfig **)&jarg1; 
  arg2 = (twrap_media_type_t)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  result = (ActionConfig *)(arg1)->setMediaString(arg2,(char const *)arg3,(char const *)arg4);
  *(ActionConfig **)&jresult = result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ActionConfig_1setMediaInt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3, jint jarg4) {
  jlong jresult = 0 ;
  ActionConfig *arg1 = (ActionConfig *) 0 ;
  twrap_media_type_t arg2 ;
  char *arg3 = (char *) 0 ;
  int arg4 ;
  ActionConfig *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ActionConfig **)&jarg1; 
  arg2 = (twrap_media_type_t)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (int)jarg4; 
  result = (ActionConfig *)(arg1)->setMediaInt(arg2,(char const *)arg3,arg4);
  *(ActionConfig **)&jresult = result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1Codec(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Codec *arg1 = (Codec *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Codec **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_Codec_1getMediaType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Codec *arg1 = (Codec *) 0 ;
  twrap_media_type_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Codec **)&jarg1; 
  result = (twrap_media_type_t)(arg1)->getMediaType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_Codec_1getName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Codec *arg1 = (Codec *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Codec **)&jarg1; 
  result = (char *)(arg1)->getName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_Codec_1getDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Codec *arg1 = (Codec *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Codec **)&jarg1; 
  result = (char *)(arg1)->getDescription();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_Codec_1getNegFormat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Codec *arg1 = (Codec *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Codec **)&jarg1; 
  result = (char *)(arg1)->getNegFormat();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_Codec_1getAudioSamplingRate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Codec *arg1 = (Codec *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Codec **)&jarg1; 
  result = (int)(arg1)->getAudioSamplingRate();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_Codec_1getAudioChannels(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Codec *arg1 = (Codec *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Codec **)&jarg1; 
  result = (int)(arg1)->getAudioChannels();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_Codec_1getAudioPTime(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Codec *arg1 = (Codec *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Codec **)&jarg1; 
  result = (int)(arg1)->getAudioPTime();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1MediaSessionMgr(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  MediaSessionMgr *arg1 = (MediaSessionMgr *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MediaSessionMgr **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1sessionSetInt32(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3, jint jarg4) {
  jboolean jresult = 0 ;
  MediaSessionMgr *arg1 = (MediaSessionMgr *) 0 ;
  twrap_media_type_t arg2 ;
  char *arg3 = (char *) 0 ;
  int32_t arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MediaSessionMgr **)&jarg1; 
  arg2 = (twrap_media_type_t)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (int32_t)jarg4; 
  result = (bool)(arg1)->sessionSetInt32(arg2,(char const *)arg3,arg4);
  jresult = (jboolean)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1sessionGetInt32(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3) {
  jint jresult = 0 ;
  MediaSessionMgr *arg1 = (MediaSessionMgr *) 0 ;
  twrap_media_type_t arg2 ;
  char *arg3 = (char *) 0 ;
  int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MediaSessionMgr **)&jarg1; 
  arg2 = (twrap_media_type_t)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (int32_t)(arg1)->sessionGetInt32(arg2,(char const *)arg3);
  jresult = (jint)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1consumerSetInt32(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3, jint jarg4) {
  jboolean jresult = 0 ;
  MediaSessionMgr *arg1 = (MediaSessionMgr *) 0 ;
  twrap_media_type_t arg2 ;
  char *arg3 = (char *) 0 ;
  int32_t arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MediaSessionMgr **)&jarg1; 
  arg2 = (twrap_media_type_t)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (int32_t)jarg4; 
  result = (bool)(arg1)->consumerSetInt32(arg2,(char const *)arg3,arg4);
  jresult = (jboolean)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1consumerSetInt64(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3, jlong jarg4) {
  jboolean jresult = 0 ;
  MediaSessionMgr *arg1 = (MediaSessionMgr *) 0 ;
  twrap_media_type_t arg2 ;
  char *arg3 = (char *) 0 ;
  int64_t arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MediaSessionMgr **)&jarg1; 
  arg2 = (twrap_media_type_t)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (int64_t)jarg4; 
  result = (bool)(arg1)->consumerSetInt64(arg2,(char const *)arg3,arg4);
  jresult = (jboolean)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1producerSetInt32(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3, jint jarg4) {
  jboolean jresult = 0 ;
  MediaSessionMgr *arg1 = (MediaSessionMgr *) 0 ;
  twrap_media_type_t arg2 ;
  char *arg3 = (char *) 0 ;
  int32_t arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MediaSessionMgr **)&jarg1; 
  arg2 = (twrap_media_type_t)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (int32_t)jarg4; 
  result = (bool)(arg1)->producerSetInt32(arg2,(char const *)arg3,arg4);
  jresult = (jboolean)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1producerSetInt64(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3, jlong jarg4) {
  jboolean jresult = 0 ;
  MediaSessionMgr *arg1 = (MediaSessionMgr *) 0 ;
  twrap_media_type_t arg2 ;
  char *arg3 = (char *) 0 ;
  int64_t arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MediaSessionMgr **)&jarg1; 
  arg2 = (twrap_media_type_t)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (int64_t)jarg4; 
  result = (bool)(arg1)->producerSetInt64(arg2,(char const *)arg3,arg4);
  jresult = (jboolean)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1producerGetCodec(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  MediaSessionMgr *arg1 = (MediaSessionMgr *) 0 ;
  twrap_media_type_t arg2 ;
  Codec *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MediaSessionMgr **)&jarg1; 
  arg2 = (twrap_media_type_t)jarg2; 
  result = (Codec *)(arg1)->producerGetCodec(arg2);
  *(Codec **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1sessionHold(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  MediaSessionMgr *arg1 = (MediaSessionMgr *) 0 ;
  twrap_media_type_t arg2 ;
  int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MediaSessionMgr **)&jarg1; 
  arg2 = (twrap_media_type_t)jarg2; 
  result = (int32_t)(arg1)->sessionHold(arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1sessionResume(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  MediaSessionMgr *arg1 = (MediaSessionMgr *) 0 ;
  twrap_media_type_t arg2 ;
  int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MediaSessionMgr **)&jarg1; 
  arg2 = (twrap_media_type_t)jarg2; 
  result = (int32_t)(arg1)->sessionResume(arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1findProxyPluginConsumer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  MediaSessionMgr *arg1 = (MediaSessionMgr *) 0 ;
  twrap_media_type_t arg2 ;
  ProxyPlugin *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MediaSessionMgr **)&jarg1; 
  arg2 = (twrap_media_type_t)jarg2; 
  result = (ProxyPlugin *)((MediaSessionMgr const *)arg1)->findProxyPluginConsumer(arg2);
  *(ProxyPlugin **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1findProxyPluginProducer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  MediaSessionMgr *arg1 = (MediaSessionMgr *) 0 ;
  twrap_media_type_t arg2 ;
  ProxyPlugin *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MediaSessionMgr **)&jarg1; 
  arg2 = (twrap_media_type_t)jarg2; 
  result = (ProxyPlugin *)((MediaSessionMgr const *)arg1)->findProxyPluginProducer(arg2);
  *(ProxyPlugin **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1registerAudioPluginFromFile(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (unsigned int)MediaSessionMgr::registerAudioPluginFromFile((char const *)arg1);
  jresult = (jlong)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1registerAudioPluginOpenSLES(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)MediaSessionMgr::registerAudioPluginOpenSLES();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1getSessionId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jobject jresult = 0 ;
  MediaSessionMgr *arg1 = (MediaSessionMgr *) 0 ;
  twrap_media_type_t arg2 ;
  uint64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MediaSessionMgr **)&jarg1; 
  arg2 = (twrap_media_type_t)jarg2; 
  result = (uint64_t)((MediaSessionMgr const *)arg1)->getSessionId(arg2);
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetProfile(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  tmedia_profile_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (tmedia_profile_t)jarg1; 
  result = (bool)MediaSessionMgr::defaultsSetProfile(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsGetProfile(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  tmedia_profile_t result;
  
  (void)jenv;
  (void)jcls;
  result = (tmedia_profile_t)MediaSessionMgr::defaultsGetProfile();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetBandwidthLevel(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  tmedia_bandwidth_level_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (tmedia_bandwidth_level_t)jarg1; 
  result = (bool)MediaSessionMgr::defaultsSetBandwidthLevel(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsGetBandwidthLevel(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  tmedia_bandwidth_level_t result;
  
  (void)jenv;
  (void)jcls;
  result = (tmedia_bandwidth_level_t)MediaSessionMgr::defaultsGetBandwidthLevel();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetCongestionCtrlEnabled(JNIEnv *jenv, jclass jcls, jboolean jarg1) {
  jboolean jresult = 0 ;
  bool arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1 ? true : false; 
  result = (bool)MediaSessionMgr::defaultsSetCongestionCtrlEnabled(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetVideoMotionRank(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  int32_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int32_t)jarg1; 
  result = (bool)MediaSessionMgr::defaultsSetVideoMotionRank(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetVideoFps(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  int32_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int32_t)jarg1; 
  result = (bool)MediaSessionMgr::defaultsSetVideoFps(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetBandwidthVideoUploadMax(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  int32_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int32_t)jarg1; 
  result = (bool)MediaSessionMgr::defaultsSetBandwidthVideoUploadMax(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetBandwidthVideoDownloadMax(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  int32_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int32_t)jarg1; 
  result = (bool)MediaSessionMgr::defaultsSetBandwidthVideoDownloadMax(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetPrefVideoSize(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  tmedia_pref_video_size_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (tmedia_pref_video_size_t)jarg1; 
  result = (bool)MediaSessionMgr::defaultsSetPrefVideoSize(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetJbMargin(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  uint32_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32_t)jarg1; 
  result = (bool)MediaSessionMgr::defaultsSetJbMargin(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetJbMaxLateRate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  uint32_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32_t)jarg1; 
  result = (bool)MediaSessionMgr::defaultsSetJbMaxLateRate(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetEchoTail(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  uint32_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32_t)jarg1; 
  result = (bool)MediaSessionMgr::defaultsSetEchoTail(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsGetEchoTail(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint32_t)MediaSessionMgr::defaultsGetEchoTail();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetEchoSkew(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  uint32_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32_t)jarg1; 
  result = (bool)MediaSessionMgr::defaultsSetEchoSkew(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetEchoSuppEnabled(JNIEnv *jenv, jclass jcls, jboolean jarg1) {
  jboolean jresult = 0 ;
  bool arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1 ? true : false; 
  result = (bool)MediaSessionMgr::defaultsSetEchoSuppEnabled(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsGetEchoSuppEnabled(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)MediaSessionMgr::defaultsGetEchoSuppEnabled();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetAgcEnabled(JNIEnv *jenv, jclass jcls, jboolean jarg1) {
  jboolean jresult = 0 ;
  bool arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1 ? true : false; 
  result = (bool)MediaSessionMgr::defaultsSetAgcEnabled(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsGetAgcEnabled(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)MediaSessionMgr::defaultsGetAgcEnabled();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetAgcLevel(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jboolean jresult = 0 ;
  float arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (float)jarg1; 
  result = (bool)MediaSessionMgr::defaultsSetAgcLevel(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsGetAgcLevel(JNIEnv *jenv, jclass jcls) {
  jfloat jresult = 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  result = (float)MediaSessionMgr::defaultsGetAgcLevel();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetVadEnabled(JNIEnv *jenv, jclass jcls, jboolean jarg1) {
  jboolean jresult = 0 ;
  bool arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1 ? true : false; 
  result = (bool)MediaSessionMgr::defaultsSetVadEnabled(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsGetGetVadEnabled(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)MediaSessionMgr::defaultsGetGetVadEnabled();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetNoiseSuppEnabled(JNIEnv *jenv, jclass jcls, jboolean jarg1) {
  jboolean jresult = 0 ;
  bool arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1 ? true : false; 
  result = (bool)MediaSessionMgr::defaultsSetNoiseSuppEnabled(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsGetNoiseSuppEnabled(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)MediaSessionMgr::defaultsGetNoiseSuppEnabled();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetNoiseSuppLevel(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  int32_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int32_t)jarg1; 
  result = (bool)MediaSessionMgr::defaultsSetNoiseSuppLevel(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsGetNoiseSuppLevel(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int32_t result;
  
  (void)jenv;
  (void)jcls;
  result = (int32_t)MediaSessionMgr::defaultsGetNoiseSuppLevel();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSet100relEnabled(JNIEnv *jenv, jclass jcls, jboolean jarg1) {
  jboolean jresult = 0 ;
  bool arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1 ? true : false; 
  result = (bool)MediaSessionMgr::defaultsSet100relEnabled(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsGet100relEnabled(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)MediaSessionMgr::defaultsGet100relEnabled();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetScreenSize(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  int32_t arg1 ;
  int32_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int32_t)jarg1; 
  arg2 = (int32_t)jarg2; 
  result = (bool)MediaSessionMgr::defaultsSetScreenSize(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetAudioGain(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  int32_t arg1 ;
  int32_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int32_t)jarg1; 
  arg2 = (int32_t)jarg2; 
  result = (bool)MediaSessionMgr::defaultsSetAudioGain(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetAudioPtime(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  int32_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int32_t)jarg1; 
  result = (bool)MediaSessionMgr::defaultsSetAudioPtime(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetAudioChannels(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  int32_t arg1 ;
  int32_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int32_t)jarg1; 
  arg2 = (int32_t)jarg2; 
  result = (bool)MediaSessionMgr::defaultsSetAudioChannels(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetRtpPortRange(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  uint16_t arg1 ;
  uint16_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint16_t)jarg1; 
  arg2 = (uint16_t)jarg2; 
  result = (bool)MediaSessionMgr::defaultsSetRtpPortRange(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetRtpSymetricEnabled(JNIEnv *jenv, jclass jcls, jboolean jarg1) {
  jboolean jresult = 0 ;
  bool arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1 ? true : false; 
  result = (bool)MediaSessionMgr::defaultsSetRtpSymetricEnabled(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetMediaType(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  twrap_media_type_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (twrap_media_type_t)jarg1; 
  result = (bool)MediaSessionMgr::defaultsSetMediaType(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetVolume(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  int32_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int32_t)jarg1; 
  result = (bool)MediaSessionMgr::defaultsSetVolume(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsGetVolume(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int32_t result;
  
  (void)jenv;
  (void)jcls;
  result = (int32_t)MediaSessionMgr::defaultsGetVolume();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetInviteSessionTimers(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2) {
  jboolean jresult = 0 ;
  int32_t arg1 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int32_t)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)MediaSessionMgr::defaultsSetInviteSessionTimers(arg1,(char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetSRtpMode(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  tmedia_srtp_mode_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (tmedia_srtp_mode_t)jarg1; 
  result = (bool)MediaSessionMgr::defaultsSetSRtpMode(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsGetSRtpMode(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  tmedia_srtp_mode_t result;
  
  (void)jenv;
  (void)jcls;
  result = (tmedia_srtp_mode_t)MediaSessionMgr::defaultsGetSRtpMode();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetSRtpType(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  tmedia_srtp_type_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (tmedia_srtp_type_t)jarg1; 
  result = (bool)MediaSessionMgr::defaultsSetSRtpType(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsGetSRtpType(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  tmedia_srtp_type_t result;
  
  (void)jenv;
  (void)jcls;
  result = (tmedia_srtp_type_t)MediaSessionMgr::defaultsGetSRtpType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetRtcpEnabled(JNIEnv *jenv, jclass jcls, jboolean jarg1) {
  jboolean jresult = 0 ;
  bool arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1 ? true : false; 
  result = (bool)MediaSessionMgr::defaultsSetRtcpEnabled(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsGetRtcpEnabled(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)MediaSessionMgr::defaultsGetRtcpEnabled();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetRtcpMuxEnabled(JNIEnv *jenv, jclass jcls, jboolean jarg1) {
  jboolean jresult = 0 ;
  bool arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1 ? true : false; 
  result = (bool)MediaSessionMgr::defaultsSetRtcpMuxEnabled(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsGetRtcpMuxEnabled(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)MediaSessionMgr::defaultsGetRtcpMuxEnabled();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetStunEnabled(JNIEnv *jenv, jclass jcls, jboolean jarg1) {
  jboolean jresult = 0 ;
  bool arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1 ? true : false; 
  result = (bool)MediaSessionMgr::defaultsSetStunEnabled(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetIceStunEnabled(JNIEnv *jenv, jclass jcls, jboolean jarg1) {
  jboolean jresult = 0 ;
  bool arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1 ? true : false; 
  result = (bool)MediaSessionMgr::defaultsSetIceStunEnabled(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetIceTurnEnabled(JNIEnv *jenv, jclass jcls, jboolean jarg1) {
  jboolean jresult = 0 ;
  bool arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1 ? true : false; 
  result = (bool)MediaSessionMgr::defaultsSetIceTurnEnabled(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetStunServer(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  uint16_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (uint16_t)jarg2; 
  result = (bool)MediaSessionMgr::defaultsSetStunServer((char const *)arg1,arg2);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetStunCred(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)MediaSessionMgr::defaultsSetStunCred((char const *)arg1,(char const *)arg2);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetIceEnabled(JNIEnv *jenv, jclass jcls, jboolean jarg1) {
  jboolean jresult = 0 ;
  bool arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1 ? true : false; 
  result = (bool)MediaSessionMgr::defaultsSetIceEnabled(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetByPassEncoding(JNIEnv *jenv, jclass jcls, jboolean jarg1) {
  jboolean jresult = 0 ;
  bool arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1 ? true : false; 
  result = (bool)MediaSessionMgr::defaultsSetByPassEncoding(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsGetByPassEncoding(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)MediaSessionMgr::defaultsGetByPassEncoding();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetByPassDecoding(JNIEnv *jenv, jclass jcls, jboolean jarg1) {
  jboolean jresult = 0 ;
  bool arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1 ? true : false; 
  result = (bool)MediaSessionMgr::defaultsSetByPassDecoding(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsGetByPassDecoding(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)MediaSessionMgr::defaultsGetByPassDecoding();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetVideoJbEnabled(JNIEnv *jenv, jclass jcls, jboolean jarg1) {
  jboolean jresult = 0 ;
  bool arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1 ? true : false; 
  result = (bool)MediaSessionMgr::defaultsSetVideoJbEnabled(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsGetVideoJbEnabled(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)MediaSessionMgr::defaultsGetVideoJbEnabled();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetVideoZeroArtifactsEnabled(JNIEnv *jenv, jclass jcls, jboolean jarg1) {
  jboolean jresult = 0 ;
  bool arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1 ? true : false; 
  result = (bool)MediaSessionMgr::defaultsSetVideoZeroArtifactsEnabled(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsGetVideoZeroArtifactsEnabled(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)MediaSessionMgr::defaultsGetVideoZeroArtifactsEnabled();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetRtpBuffSize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  unsigned int arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (unsigned int)jarg1; 
  result = (bool)MediaSessionMgr::defaultsSetRtpBuffSize(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsGetRtpBuffSize(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)MediaSessionMgr::defaultsGetRtpBuffSize();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetAvpfTail(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  unsigned int arg1 ;
  unsigned int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (unsigned int)jarg1; 
  arg2 = (unsigned int)jarg2; 
  result = (bool)MediaSessionMgr::defaultsSetAvpfTail(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetAvpfMode(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  enum tmedia_mode_e arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (enum tmedia_mode_e)jarg1; 
  result = (bool)MediaSessionMgr::defaultsSetAvpfMode(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetOpusMaxCaptureRate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  uint32_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32_t)jarg1; 
  result = (bool)MediaSessionMgr::defaultsSetOpusMaxCaptureRate(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetOpusMaxPlaybackRate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  uint32_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32_t)jarg1; 
  result = (bool)MediaSessionMgr::defaultsSetOpusMaxPlaybackRate(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetMaxFds(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  int32_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int32_t)jarg1; 
  result = (bool)MediaSessionMgr::defaultsSetMaxFds(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaSessionMgr_1defaultsSetPoCQoE(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  tmedia_poc_qoe_profile_t arg1 ;
  tmedia_poc_qoe_profile_strength_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (tmedia_poc_qoe_profile_t)jarg1; 
  arg2 = (tmedia_poc_qoe_profile_strength_t)jarg2; 
  result = (bool)MediaSessionMgr::defaultsSetPoCQoE(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1MediaContent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  MediaContent *arg1 = (MediaContent *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MediaContent **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaContent_1getType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  MediaContent *arg1 = (MediaContent *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MediaContent **)&jarg1; 
  result = (char *)(arg1)->getType();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaContent_1getDataLength(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  MediaContent *arg1 = (MediaContent *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MediaContent **)&jarg1; 
  result = (unsigned int)(arg1)->getDataLength();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaContent_1getData(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  MediaContent *arg1 = (MediaContent *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MediaContent **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  result = (unsigned int)(arg1)->getData(arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaContent_1parse_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jbyteArray jarg1, jlong jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  void *arg1 = (void *) 0 ;
  unsigned int arg2 ;
  char *arg3 = (char *) 0 ;
  MediaContent *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  arg1 = jenv->GetDirectBufferAddress(jarg1); 
  
  arg2 = (unsigned int)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (MediaContent *)MediaContent::parse((void const *)arg1,arg2,(char const *)arg3);
  *(MediaContent **)&jresult = result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaContent_1parse_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jbyteArray jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  void *arg1 = (void *) 0 ;
  unsigned int arg2 ;
  MediaContentCPIM *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  arg1 = jenv->GetDirectBufferAddress(jarg1); 
  
  arg2 = (unsigned int)jarg2; 
  result = (MediaContentCPIM *)MediaContent::parse((void const *)arg1,arg2);
  *(MediaContentCPIM **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaContent_1getPayloadLength(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  MediaContent *arg1 = (MediaContent *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MediaContent **)&jarg1; 
  result = (unsigned int)(arg1)->getPayloadLength();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaContent_1getPayload(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  MediaContent *arg1 = (MediaContent *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MediaContent **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  result = (unsigned int)(arg1)->getPayload(arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1MediaContentCPIM(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  MediaContentCPIM *arg1 = (MediaContentCPIM *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MediaContentCPIM **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaContentCPIM_1getPayloadLength(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  MediaContentCPIM *arg1 = (MediaContentCPIM *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MediaContentCPIM **)&jarg1; 
  result = (unsigned int)(arg1)->getPayloadLength();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaContentCPIM_1getPayload(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  MediaContentCPIM *arg1 = (MediaContentCPIM *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MediaContentCPIM **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  result = (unsigned int)(arg1)->getPayload(arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaContentCPIM_1getHeaderValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jstring jresult = 0 ;
  MediaContentCPIM *arg1 = (MediaContentCPIM *) 0 ;
  char *arg2 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MediaContentCPIM **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (char *)(arg1)->getHeaderValue((char const *)arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1SipUri_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  SipUri *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (SipUri *)new SipUri((char const *)arg1,(char const *)arg2);
  *(SipUri **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1SipUri_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  SipUri *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (SipUri *)new SipUri((char const *)arg1);
  *(SipUri **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1SipUri(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SipUri *arg1 = (SipUri *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SipUri **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipUri_1isValid_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (bool)SipUri::isValid((char const *)arg1);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipUri_1isValid_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  SipUri *arg1 = (SipUri *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipUri **)&jarg1; 
  result = (bool)(arg1)->isValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipUri_1getScheme(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  SipUri *arg1 = (SipUri *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipUri **)&jarg1; 
  result = (char *)(arg1)->getScheme();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipUri_1getHost(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  SipUri *arg1 = (SipUri *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipUri **)&jarg1; 
  result = (char *)(arg1)->getHost();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipUri_1getPort(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SipUri *arg1 = (SipUri *) 0 ;
  unsigned short result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipUri **)&jarg1; 
  result = (unsigned short)(arg1)->getPort();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipUri_1getUserName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  SipUri *arg1 = (SipUri *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipUri **)&jarg1; 
  result = (char *)(arg1)->getUserName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipUri_1getPassword(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  SipUri *arg1 = (SipUri *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipUri **)&jarg1; 
  result = (char *)(arg1)->getPassword();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipUri_1getDisplayName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  SipUri *arg1 = (SipUri *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipUri **)&jarg1; 
  result = (char *)(arg1)->getDisplayName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipUri_1getParamValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jstring jresult = 0 ;
  SipUri *arg1 = (SipUri *) 0 ;
  char *arg2 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipUri **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (char *)(arg1)->getParamValue((char const *)arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipUri_1setDisplayName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  SipUri *arg1 = (SipUri *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipUri **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->setDisplayName((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1SdpMessage(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  SdpMessage *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (SdpMessage *)new SdpMessage();
  *(SdpMessage **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1SdpMessage(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SdpMessage *arg1 = (SdpMessage *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SdpMessage **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SdpMessage_1getSdpHeaderValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jchar jarg3, jlong jarg4) {
  jstring jresult = 0 ;
  SdpMessage *arg1 = (SdpMessage *) 0 ;
  char *arg2 = (char *) 0 ;
  char arg3 ;
  unsigned int arg4 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SdpMessage **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (char)jarg3; 
  arg4 = (unsigned int)jarg4; 
  result = (char *)(arg1)->getSdpHeaderValue((char const *)arg2,arg3,arg4);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  delete [] result;
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SdpMessage_1getSdpHeaderValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jchar jarg3) {
  jstring jresult = 0 ;
  SdpMessage *arg1 = (SdpMessage *) 0 ;
  char *arg2 = (char *) 0 ;
  char arg3 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SdpMessage **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (char)jarg3; 
  result = (char *)(arg1)->getSdpHeaderValue((char const *)arg2,arg3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  delete [] result;
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SdpMessage_1getSdpHeaderAValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jstring jresult = 0 ;
  SdpMessage *arg1 = (SdpMessage *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SdpMessage **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (char *)(arg1)->getSdpHeaderAValue((char const *)arg2,(char const *)arg3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  delete [] result;
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SdpMessage_1getSdpHeaderMPort_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jint jresult = 0 ;
  SdpMessage *arg1 = (SdpMessage *) 0 ;
  char *arg2 = (char *) 0 ;
  unsigned int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SdpMessage **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (unsigned int)jarg3; 
  result = (int)(arg1)->getSdpHeaderMPort((char const *)arg2,arg3);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SdpMessage_1getSdpHeaderMPort_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  SdpMessage *arg1 = (SdpMessage *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SdpMessage **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)(arg1)->getSdpHeaderMPort((char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SdpMessage_1getSdpHeaderCAddr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jstring jresult = 0 ;
  SdpMessage *arg1 = (SdpMessage *) 0 ;
  char *arg2 = (char *) 0 ;
  unsigned int arg3 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SdpMessage **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (unsigned int)jarg3; 
  result = (char *)(arg1)->getSdpHeaderCAddr((char const *)arg2,arg3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  delete [] result;
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SdpMessage_1getSdpHeaderCAddrType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jstring jresult = 0 ;
  SdpMessage *arg1 = (SdpMessage *) 0 ;
  char *arg2 = (char *) 0 ;
  unsigned int arg3 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SdpMessage **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (unsigned int)jarg3; 
  result = (char *)(arg1)->getSdpHeaderCAddrType((char const *)arg2,arg3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  delete [] result;
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1SipMessage(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  SipMessage *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (SipMessage *)new SipMessage();
  *(SipMessage **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1SipMessage(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SipMessage *arg1 = (SipMessage *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SipMessage **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipMessage_1isResponse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  SipMessage *arg1 = (SipMessage *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipMessage **)&jarg1; 
  result = (bool)(arg1)->isResponse();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipMessage_1getRequestType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SipMessage *arg1 = (SipMessage *) 0 ;
  tsip_request_type_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipMessage **)&jarg1; 
  result = (tsip_request_type_t)(arg1)->getRequestType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipMessage_1getResponseCode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  SipMessage *arg1 = (SipMessage *) 0 ;
  short result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipMessage **)&jarg1; 
  result = (short)(arg1)->getResponseCode();
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipMessage_1getResponsePhrase(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  SipMessage *arg1 = (SipMessage *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipMessage **)&jarg1; 
  result = (char *)(arg1)->getResponsePhrase();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipMessage_1getSipHeaderValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jstring jresult = 0 ;
  SipMessage *arg1 = (SipMessage *) 0 ;
  char *arg2 = (char *) 0 ;
  unsigned int arg3 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipMessage **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (unsigned int)jarg3; 
  result = (char *)(arg1)->getSipHeaderValue((char const *)arg2,arg3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  delete [] result;
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipMessage_1getSipHeaderValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jstring jresult = 0 ;
  SipMessage *arg1 = (SipMessage *) 0 ;
  char *arg2 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipMessage **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (char *)(arg1)->getSipHeaderValue((char const *)arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  delete [] result;
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipMessage_1getSipHeaderParamValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jlong jarg4) {
  jstring jresult = 0 ;
  SipMessage *arg1 = (SipMessage *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  unsigned int arg4 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipMessage **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (unsigned int)jarg4; 
  result = (char *)(arg1)->getSipHeaderParamValue((char const *)arg2,(char const *)arg3,arg4);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  delete [] result;
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipMessage_1getSipHeaderParamValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jstring jresult = 0 ;
  SipMessage *arg1 = (SipMessage *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipMessage **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (char *)(arg1)->getSipHeaderParamValue((char const *)arg2,(char const *)arg3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  delete [] result;
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipMessage_1getSipContentLength(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SipMessage *arg1 = (SipMessage *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipMessage **)&jarg1; 
  result = (unsigned int)(arg1)->getSipContentLength();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipMessage_1getSipContentSdp(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  SipMessage *arg1 = (SipMessage *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipMessage **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  result = (unsigned int)(arg1)->getSipContentSdp(arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipMessage_1getSipContentMbms(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  SipMessage *arg1 = (SipMessage *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipMessage **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  result = (unsigned int)(arg1)->getSipContentMbms(arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipMessage_1getSipContentContetType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3, jstring jarg4) {
  jlong jresult = 0 ;
  SipMessage *arg1 = (SipMessage *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  char *arg4 = (char *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipMessage **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  result = (unsigned int)(arg1)->getSipContentContetType(arg2,arg3,arg4);
  jresult = (jlong)result; 
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipMessage_1getSipContent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  SipMessage *arg1 = (SipMessage *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipMessage **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  result = (unsigned int)(arg1)->getSipContent(arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipMessage_1getSdpMessage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SipMessage *arg1 = (SipMessage *) 0 ;
  SdpMessage *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipMessage **)&jarg1; 
  result = (SdpMessage *)(arg1)->getSdpMessage();
  *(SdpMessage **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1SipEvent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SipEvent *arg1 = (SipEvent *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SipEvent **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jshort JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipEvent_1getCode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  SipEvent *arg1 = (SipEvent *) 0 ;
  short result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipEvent **)&jarg1; 
  result = (short)((SipEvent const *)arg1)->getCode();
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipEvent_1getPhrase(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  SipEvent *arg1 = (SipEvent *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipEvent **)&jarg1; 
  result = (char *)((SipEvent const *)arg1)->getPhrase();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipEvent_1getBaseSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SipEvent *arg1 = (SipEvent *) 0 ;
  SipSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipEvent **)&jarg1; 
  result = (SipSession *)((SipEvent const *)arg1)->getBaseSession();
  *(SipSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipEvent_1getSipMessage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SipEvent *arg1 = (SipEvent *) 0 ;
  SipMessage *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipEvent **)&jarg1; 
  result = (SipMessage *)((SipEvent const *)arg1)->getSipMessage();
  *(SipMessage **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1DialogEvent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  DialogEvent *arg1 = (DialogEvent *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(DialogEvent **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1StackEvent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  StackEvent *arg1 = (StackEvent *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(StackEvent **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1InviteEvent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  InviteEvent *arg1 = (InviteEvent *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(InviteEvent **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_InviteEvent_1getType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  InviteEvent *arg1 = (InviteEvent *) 0 ;
  tsip_invite_event_type_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InviteEvent **)&jarg1; 
  result = (tsip_invite_event_type_t)((InviteEvent const *)arg1)->getType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_InviteEvent_1getMediaType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  InviteEvent *arg1 = (InviteEvent *) 0 ;
  twrap_media_type_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InviteEvent **)&jarg1; 
  result = (twrap_media_type_t)((InviteEvent const *)arg1)->getMediaType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_InviteEvent_1getSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  InviteEvent *arg1 = (InviteEvent *) 0 ;
  InviteSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InviteEvent **)&jarg1; 
  result = (InviteSession *)((InviteEvent const *)arg1)->getSession();
  *(InviteSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_InviteEvent_1takeCallSessionOwnership(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  InviteEvent *arg1 = (InviteEvent *) 0 ;
  CallSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InviteEvent **)&jarg1; 
  result = (CallSession *)((InviteEvent const *)arg1)->takeCallSessionOwnership();
  *(CallSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_InviteEvent_1takeMsrpSessionOwnership(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  InviteEvent *arg1 = (InviteEvent *) 0 ;
  MsrpSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InviteEvent **)&jarg1; 
  result = (MsrpSession *)((InviteEvent const *)arg1)->takeMsrpSessionOwnership();
  *(MsrpSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1MessagingEvent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  MessagingEvent *arg1 = (MessagingEvent *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MessagingEvent **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingEvent_1getType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  MessagingEvent *arg1 = (MessagingEvent *) 0 ;
  tsip_message_event_type_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MessagingEvent **)&jarg1; 
  result = (tsip_message_event_type_t)((MessagingEvent const *)arg1)->getType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingEvent_1getSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  MessagingEvent *arg1 = (MessagingEvent *) 0 ;
  MessagingSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MessagingEvent **)&jarg1; 
  result = (MessagingSession *)((MessagingEvent const *)arg1)->getSession();
  *(MessagingSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingEvent_1takeSessionOwnership(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  MessagingEvent *arg1 = (MessagingEvent *) 0 ;
  MessagingSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MessagingEvent **)&jarg1; 
  result = (MessagingSession *)((MessagingEvent const *)arg1)->takeSessionOwnership();
  *(MessagingSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1MessagingLocationEvent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  MessagingLocationEvent *arg1 = (MessagingLocationEvent *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MessagingLocationEvent **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingLocationEvent_1getType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  MessagingLocationEvent *arg1 = (MessagingLocationEvent *) 0 ;
  tsip_message_event_type_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MessagingLocationEvent **)&jarg1; 
  result = (tsip_message_event_type_t)((MessagingLocationEvent const *)arg1)->getType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingLocationEvent_1getSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  MessagingLocationEvent *arg1 = (MessagingLocationEvent *) 0 ;
  MessagingLocationSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MessagingLocationEvent **)&jarg1; 
  result = (MessagingLocationSession *)((MessagingLocationEvent const *)arg1)->getSession();
  *(MessagingLocationSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingLocationEvent_1takeSessionOwnership(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  MessagingLocationEvent *arg1 = (MessagingLocationEvent *) 0 ;
  MessagingLocationSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MessagingLocationEvent **)&jarg1; 
  result = (MessagingLocationSession *)((MessagingLocationEvent const *)arg1)->takeSessionOwnership();
  *(MessagingLocationSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1MessagingAffiliationEvent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  MessagingAffiliationEvent *arg1 = (MessagingAffiliationEvent *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MessagingAffiliationEvent **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingAffiliationEvent_1getType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  MessagingAffiliationEvent *arg1 = (MessagingAffiliationEvent *) 0 ;
  tsip_message_event_type_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MessagingAffiliationEvent **)&jarg1; 
  result = (tsip_message_event_type_t)((MessagingAffiliationEvent const *)arg1)->getType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingAffiliationEvent_1getSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  MessagingAffiliationEvent *arg1 = (MessagingAffiliationEvent *) 0 ;
  MessagingAffiliationSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MessagingAffiliationEvent **)&jarg1; 
  result = (MessagingAffiliationSession *)((MessagingAffiliationEvent const *)arg1)->getSession();
  *(MessagingAffiliationSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingAffiliationEvent_1takeSessionOwnership(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  MessagingAffiliationEvent *arg1 = (MessagingAffiliationEvent *) 0 ;
  MessagingAffiliationSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MessagingAffiliationEvent **)&jarg1; 
  result = (MessagingAffiliationSession *)((MessagingAffiliationEvent const *)arg1)->takeSessionOwnership();
  *(MessagingAffiliationSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1MessagingMbmsEvent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  MessagingMbmsEvent *arg1 = (MessagingMbmsEvent *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MessagingMbmsEvent **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingMbmsEvent_1getType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  MessagingMbmsEvent *arg1 = (MessagingMbmsEvent *) 0 ;
  tsip_message_event_type_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MessagingMbmsEvent **)&jarg1; 
  result = (tsip_message_event_type_t)((MessagingMbmsEvent const *)arg1)->getType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingMbmsEvent_1getSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  MessagingMbmsEvent *arg1 = (MessagingMbmsEvent *) 0 ;
  MessagingMbmsSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MessagingMbmsEvent **)&jarg1; 
  result = (MessagingMbmsSession *)((MessagingMbmsEvent const *)arg1)->getSession();
  *(MessagingMbmsSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingMbmsEvent_1takeSessionOwnership(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  MessagingMbmsEvent *arg1 = (MessagingMbmsEvent *) 0 ;
  MessagingMbmsSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MessagingMbmsEvent **)&jarg1; 
  result = (MessagingMbmsSession *)((MessagingMbmsEvent const *)arg1)->takeSessionOwnership();
  *(MessagingMbmsSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1InfoEvent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  InfoEvent *arg1 = (InfoEvent *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(InfoEvent **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_InfoEvent_1getType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  InfoEvent *arg1 = (InfoEvent *) 0 ;
  tsip_info_event_type_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InfoEvent **)&jarg1; 
  result = (tsip_info_event_type_t)((InfoEvent const *)arg1)->getType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_InfoEvent_1getSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  InfoEvent *arg1 = (InfoEvent *) 0 ;
  InfoSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InfoEvent **)&jarg1; 
  result = (InfoSession *)((InfoEvent const *)arg1)->getSession();
  *(InfoSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_InfoEvent_1takeSessionOwnership(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  InfoEvent *arg1 = (InfoEvent *) 0 ;
  InfoSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InfoEvent **)&jarg1; 
  result = (InfoSession *)((InfoEvent const *)arg1)->takeSessionOwnership();
  *(InfoSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1OptionsEvent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  OptionsEvent *arg1 = (OptionsEvent *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(OptionsEvent **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_OptionsEvent_1getType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  OptionsEvent *arg1 = (OptionsEvent *) 0 ;
  tsip_options_event_type_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(OptionsEvent **)&jarg1; 
  result = (tsip_options_event_type_t)((OptionsEvent const *)arg1)->getType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_OptionsEvent_1getSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  OptionsEvent *arg1 = (OptionsEvent *) 0 ;
  OptionsSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(OptionsEvent **)&jarg1; 
  result = (OptionsSession *)((OptionsEvent const *)arg1)->getSession();
  *(OptionsSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_OptionsEvent_1takeSessionOwnership(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  OptionsEvent *arg1 = (OptionsEvent *) 0 ;
  OptionsSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(OptionsEvent **)&jarg1; 
  result = (OptionsSession *)((OptionsEvent const *)arg1)->takeSessionOwnership();
  *(OptionsSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1PublicationEvent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  PublicationEvent *arg1 = (PublicationEvent *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(PublicationEvent **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_PublicationEvent_1getType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  PublicationEvent *arg1 = (PublicationEvent *) 0 ;
  tsip_publish_event_type_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(PublicationEvent **)&jarg1; 
  result = (tsip_publish_event_type_t)((PublicationEvent const *)arg1)->getType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_PublicationEvent_1getSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  PublicationEvent *arg1 = (PublicationEvent *) 0 ;
  PublicationSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(PublicationEvent **)&jarg1; 
  result = (PublicationSession *)((PublicationEvent const *)arg1)->getSession();
  *(PublicationSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_PublicationEvent_1takeSessionOwnership(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  PublicationEvent *arg1 = (PublicationEvent *) 0 ;
  PublicationSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(PublicationEvent **)&jarg1; 
  result = (PublicationSession *)((PublicationEvent const *)arg1)->takeSessionOwnership();
  *(PublicationSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1PublicationAffiliationEvent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  PublicationAffiliationEvent *arg1 = (PublicationAffiliationEvent *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(PublicationAffiliationEvent **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_PublicationAffiliationEvent_1getType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  PublicationAffiliationEvent *arg1 = (PublicationAffiliationEvent *) 0 ;
  tsip_publish_event_type_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(PublicationAffiliationEvent **)&jarg1; 
  result = (tsip_publish_event_type_t)((PublicationAffiliationEvent const *)arg1)->getType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_PublicationAffiliationEvent_1getSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  PublicationAffiliationEvent *arg1 = (PublicationAffiliationEvent *) 0 ;
  PublicationAffiliationSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(PublicationAffiliationEvent **)&jarg1; 
  result = (PublicationAffiliationSession *)((PublicationAffiliationEvent const *)arg1)->getSession();
  *(PublicationAffiliationSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_PublicationAffiliationEvent_1takeSessionOwnership(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  PublicationAffiliationEvent *arg1 = (PublicationAffiliationEvent *) 0 ;
  PublicationAffiliationSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(PublicationAffiliationEvent **)&jarg1; 
  result = (PublicationAffiliationSession *)((PublicationAffiliationEvent const *)arg1)->takeSessionOwnership();
  *(PublicationAffiliationSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1PublicationAuthenticationEvent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  PublicationAuthenticationEvent *arg1 = (PublicationAuthenticationEvent *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(PublicationAuthenticationEvent **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_PublicationAuthenticationEvent_1getType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  PublicationAuthenticationEvent *arg1 = (PublicationAuthenticationEvent *) 0 ;
  tsip_publish_event_type_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(PublicationAuthenticationEvent **)&jarg1; 
  result = (tsip_publish_event_type_t)((PublicationAuthenticationEvent const *)arg1)->getType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_PublicationAuthenticationEvent_1getSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  PublicationAuthenticationEvent *arg1 = (PublicationAuthenticationEvent *) 0 ;
  PublicationAuthenticationSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(PublicationAuthenticationEvent **)&jarg1; 
  result = (PublicationAuthenticationSession *)((PublicationAuthenticationEvent const *)arg1)->getSession();
  *(PublicationAuthenticationSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_PublicationAuthenticationEvent_1takeSessionOwnership(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  PublicationAuthenticationEvent *arg1 = (PublicationAuthenticationEvent *) 0 ;
  PublicationAuthenticationSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(PublicationAuthenticationEvent **)&jarg1; 
  result = (PublicationAuthenticationSession *)((PublicationAuthenticationEvent const *)arg1)->takeSessionOwnership();
  *(PublicationAuthenticationSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1RegistrationAuthenticationEvent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  RegistrationAuthenticationEvent *arg1 = (RegistrationAuthenticationEvent *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(RegistrationAuthenticationEvent **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_RegistrationAuthenticationEvent_1getType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  RegistrationAuthenticationEvent *arg1 = (RegistrationAuthenticationEvent *) 0 ;
  tsip_register_authentication_event_type_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RegistrationAuthenticationEvent **)&jarg1; 
  result = (tsip_register_authentication_event_type_t)((RegistrationAuthenticationEvent const *)arg1)->getType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1RegistrationEvent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  RegistrationEvent *arg1 = (RegistrationEvent *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(RegistrationEvent **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_RegistrationEvent_1getType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  RegistrationEvent *arg1 = (RegistrationEvent *) 0 ;
  tsip_register_event_type_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RegistrationEvent **)&jarg1; 
  result = (tsip_register_event_type_t)((RegistrationEvent const *)arg1)->getType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_RegistrationEvent_1getSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  RegistrationEvent *arg1 = (RegistrationEvent *) 0 ;
  RegistrationSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RegistrationEvent **)&jarg1; 
  result = (RegistrationSession *)((RegistrationEvent const *)arg1)->getSession();
  *(RegistrationSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_RegistrationEvent_1takeSessionOwnership(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  RegistrationEvent *arg1 = (RegistrationEvent *) 0 ;
  RegistrationSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RegistrationEvent **)&jarg1; 
  result = (RegistrationSession *)((RegistrationEvent const *)arg1)->takeSessionOwnership();
  *(RegistrationSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1SubscriptionEvent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SubscriptionEvent *arg1 = (SubscriptionEvent *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SubscriptionEvent **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SubscriptionEvent_1getType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SubscriptionEvent *arg1 = (SubscriptionEvent *) 0 ;
  tsip_subscribe_event_type_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SubscriptionEvent **)&jarg1; 
  result = (tsip_subscribe_event_type_t)((SubscriptionEvent const *)arg1)->getType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SubscriptionEvent_1getSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SubscriptionEvent *arg1 = (SubscriptionEvent *) 0 ;
  SubscriptionSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SubscriptionEvent **)&jarg1; 
  result = (SubscriptionSession *)((SubscriptionEvent const *)arg1)->getSession();
  *(SubscriptionSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SubscriptionEvent_1takeSessionOwnership(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SubscriptionEvent *arg1 = (SubscriptionEvent *) 0 ;
  SubscriptionSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SubscriptionEvent **)&jarg1; 
  result = (SubscriptionSession *)((SubscriptionEvent const *)arg1)->takeSessionOwnership();
  *(SubscriptionSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1SubscriptionAffiliationEvent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SubscriptionAffiliationEvent *arg1 = (SubscriptionAffiliationEvent *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SubscriptionAffiliationEvent **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SubscriptionAffiliationEvent_1getType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SubscriptionAffiliationEvent *arg1 = (SubscriptionAffiliationEvent *) 0 ;
  tsip_subscribe_event_type_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SubscriptionAffiliationEvent **)&jarg1; 
  result = (tsip_subscribe_event_type_t)((SubscriptionAffiliationEvent const *)arg1)->getType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SubscriptionAffiliationEvent_1getSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SubscriptionAffiliationEvent *arg1 = (SubscriptionAffiliationEvent *) 0 ;
  SubscriptionAffiliationSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SubscriptionAffiliationEvent **)&jarg1; 
  result = (SubscriptionAffiliationSession *)((SubscriptionAffiliationEvent const *)arg1)->getSession();
  *(SubscriptionAffiliationSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SubscriptionAffiliationEvent_1takeSessionOwnership(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SubscriptionAffiliationEvent *arg1 = (SubscriptionAffiliationEvent *) 0 ;
  SubscriptionAffiliationSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SubscriptionAffiliationEvent **)&jarg1; 
  result = (SubscriptionAffiliationSession *)((SubscriptionAffiliationEvent const *)arg1)->takeSessionOwnership();
  *(SubscriptionAffiliationSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1SubscriptionCMSEvent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SubscriptionCMSEvent *arg1 = (SubscriptionCMSEvent *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SubscriptionCMSEvent **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SubscriptionCMSEvent_1getType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SubscriptionCMSEvent *arg1 = (SubscriptionCMSEvent *) 0 ;
  tsip_subscribe_event_type_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SubscriptionCMSEvent **)&jarg1; 
  result = (tsip_subscribe_event_type_t)((SubscriptionCMSEvent const *)arg1)->getType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SubscriptionCMSEvent_1getSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SubscriptionCMSEvent *arg1 = (SubscriptionCMSEvent *) 0 ;
  SubscriptionCMSSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SubscriptionCMSEvent **)&jarg1; 
  result = (SubscriptionCMSSession *)((SubscriptionCMSEvent const *)arg1)->getSession();
  *(SubscriptionCMSSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SubscriptionCMSEvent_1takeSessionOwnership(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SubscriptionCMSEvent *arg1 = (SubscriptionCMSEvent *) 0 ;
  SubscriptionCMSSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SubscriptionCMSEvent **)&jarg1; 
  result = (SubscriptionCMSSession *)((SubscriptionCMSEvent const *)arg1)->takeSessionOwnership();
  *(SubscriptionCMSSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1SubscriptionGMSEvent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SubscriptionGMSEvent *arg1 = (SubscriptionGMSEvent *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SubscriptionGMSEvent **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SubscriptionGMSEvent_1getType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SubscriptionGMSEvent *arg1 = (SubscriptionGMSEvent *) 0 ;
  tsip_subscribe_event_type_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SubscriptionGMSEvent **)&jarg1; 
  result = (tsip_subscribe_event_type_t)((SubscriptionGMSEvent const *)arg1)->getType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SubscriptionGMSEvent_1getSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SubscriptionGMSEvent *arg1 = (SubscriptionGMSEvent *) 0 ;
  SubscriptionGMSSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SubscriptionGMSEvent **)&jarg1; 
  result = (SubscriptionGMSSession *)((SubscriptionGMSEvent const *)arg1)->getSession();
  *(SubscriptionGMSSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SubscriptionGMSEvent_1takeSessionOwnership(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SubscriptionGMSEvent *arg1 = (SubscriptionGMSEvent *) 0 ;
  SubscriptionGMSSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SubscriptionGMSEvent **)&jarg1; 
  result = (SubscriptionGMSSession *)((SubscriptionGMSEvent const *)arg1)->takeSessionOwnership();
  *(SubscriptionGMSSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1T140CallbackData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  T140CallbackData *arg1 = (T140CallbackData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(T140CallbackData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_T140CallbackData_1getType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  T140CallbackData *arg1 = (T140CallbackData *) 0 ;
  enum tmedia_t140_data_type_e result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(T140CallbackData **)&jarg1; 
  result = (enum tmedia_t140_data_type_e)((T140CallbackData const *)arg1)->getType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_T140CallbackData_1getSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  T140CallbackData *arg1 = (T140CallbackData *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(T140CallbackData **)&jarg1; 
  result = (unsigned int)((T140CallbackData const *)arg1)->getSize();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_T140CallbackData_1getData(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  T140CallbackData *arg1 = (T140CallbackData *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(T140CallbackData **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  result = (unsigned int)((T140CallbackData const *)arg1)->getData(arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1T140Callback(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  T140Callback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (T140Callback *)new SwigDirector_T140Callback(jenv);
  *(T140Callback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1T140Callback(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  T140Callback *arg1 = (T140Callback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(T140Callback **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_T140Callback_1ondata(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  T140Callback *arg1 = (T140Callback *) 0 ;
  T140CallbackData *arg2 = (T140CallbackData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(T140Callback **)&jarg1; 
  arg2 = *(T140CallbackData **)&jarg2; 
  result = (int)(arg1)->ondata((T140CallbackData const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_T140Callback_1ondataSwigExplicitT140Callback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  T140Callback *arg1 = (T140Callback *) 0 ;
  T140CallbackData *arg2 = (T140CallbackData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(T140Callback **)&jarg1; 
  arg2 = *(T140CallbackData **)&jarg2; 
  result = (int)(arg1)->T140Callback::ondata((T140CallbackData const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_T140Callback_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  T140Callback *obj = *((T140Callback **)&objarg);
  (void)jcls;
  SwigDirector_T140Callback *director = static_cast<SwigDirector_T140Callback *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_T140Callback_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  T140Callback *obj = *((T140Callback **)&objarg);
  SwigDirector_T140Callback *director = static_cast<SwigDirector_T140Callback *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1SipSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  SipSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  result = (SipSession *)new SipSession(arg1);
  *(SipSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1SipSession(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SipSession *arg1 = (SipSession *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SipSession **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipSession_1haveOwnership(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  SipSession *arg1 = (SipSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipSession **)&jarg1; 
  result = (bool)(arg1)->haveOwnership();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipSession_1startMBMSManager(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jboolean jresult = 0 ;
  SipSession *arg1 = (SipSession *) 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipSession **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (bool)(arg1)->startMBMSManager(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipSession_1addHeader(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jboolean jresult = 0 ;
  SipSession *arg1 = (SipSession *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipSession **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (bool)(arg1)->addHeader((char const *)arg2,(char const *)arg3);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipSession_1removeHeader(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  SipSession *arg1 = (SipSession *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipSession **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->removeHeader((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipSession_1addCaps_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jboolean jresult = 0 ;
  SipSession *arg1 = (SipSession *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipSession **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (bool)(arg1)->addCaps((char const *)arg2,(char const *)arg3);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipSession_1addCaps_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  SipSession *arg1 = (SipSession *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipSession **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->addCaps((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipSession_1removeCaps(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  SipSession *arg1 = (SipSession *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipSession **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->removeCaps((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipSession_1setExpires(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  SipSession *arg1 = (SipSession *) 0 ;
  unsigned int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipSession **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  result = (bool)(arg1)->setExpires(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipSession_1setFromUri_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  SipSession *arg1 = (SipSession *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipSession **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->setFromUri((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipSession_1setFromUri_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  SipSession *arg1 = (SipSession *) 0 ;
  SipUri *arg2 = (SipUri *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipSession **)&jarg1; 
  arg2 = *(SipUri **)&jarg2; 
  result = (bool)(arg1)->setFromUri((SipUri const *)arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipSession_1setToUri_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  SipSession *arg1 = (SipSession *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipSession **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->setToUri((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipSession_1setToUri_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  SipSession *arg1 = (SipSession *) 0 ;
  SipUri *arg2 = (SipUri *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipSession **)&jarg1; 
  arg2 = *(SipUri **)&jarg2; 
  result = (bool)(arg1)->setToUri((SipUri const *)arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipSession_1setSilentHangup(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jboolean jresult = 0 ;
  SipSession *arg1 = (SipSession *) 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipSession **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (bool)(arg1)->setSilentHangup(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipSession_1addSigCompCompartment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  SipSession *arg1 = (SipSession *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipSession **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->addSigCompCompartment((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipSession_1removeSigCompCompartment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  SipSession *arg1 = (SipSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipSession **)&jarg1; 
  result = (bool)(arg1)->removeSigCompCompartment();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipSession_1getId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SipSession *arg1 = (SipSession *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipSession **)&jarg1; 
  result = (unsigned int)((SipSession const *)arg1)->getId();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1InviteSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  InviteSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  result = (InviteSession *)new InviteSession(arg1);
  *(InviteSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1InviteSession(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  InviteSession *arg1 = (InviteSession *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(InviteSession **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_InviteSession_1accept_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  InviteSession *arg1 = (InviteSession *) 0 ;
  ActionConfig *arg2 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(InviteSession **)&jarg1; 
  arg2 = *(ActionConfig **)&jarg2; 
  result = (bool)(arg1)->accept(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_InviteSession_1accept_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  InviteSession *arg1 = (InviteSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InviteSession **)&jarg1; 
  result = (bool)(arg1)->accept();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_InviteSession_1hangup_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  InviteSession *arg1 = (InviteSession *) 0 ;
  ActionConfig *arg2 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(InviteSession **)&jarg1; 
  arg2 = *(ActionConfig **)&jarg2; 
  result = (bool)(arg1)->hangup(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_InviteSession_1hangup_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  InviteSession *arg1 = (InviteSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InviteSession **)&jarg1; 
  result = (bool)(arg1)->hangup();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_InviteSession_1reject_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  InviteSession *arg1 = (InviteSession *) 0 ;
  ActionConfig *arg2 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(InviteSession **)&jarg1; 
  arg2 = *(ActionConfig **)&jarg2; 
  result = (bool)(arg1)->reject(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_InviteSession_1reject_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  InviteSession *arg1 = (InviteSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InviteSession **)&jarg1; 
  result = (bool)(arg1)->reject();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_InviteSession_1sendInfo_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jboolean jresult = 0 ;
  InviteSession *arg1 = (InviteSession *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  ActionConfig *arg4 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(InviteSession **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  arg4 = *(ActionConfig **)&jarg4; 
  result = (bool)(arg1)->sendInfo((void const *)arg2,arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_InviteSession_1sendInfo_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  InviteSession *arg1 = (InviteSession *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InviteSession **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  result = (bool)(arg1)->sendInfo((void const *)arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_InviteSession_1getMediaMgr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  InviteSession *arg1 = (InviteSession *) 0 ;
  MediaSessionMgr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InviteSession **)&jarg1; 
  result = (MediaSessionMgr *)(arg1)->getMediaMgr();
  *(MediaSessionMgr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1CallSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  CallSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  result = (CallSession *)new CallSession(arg1);
  *(CallSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1CallSession(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CallSession *arg1 = (CallSession *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CallSession **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1callAudio_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  char *arg2 = (char *) 0 ;
  ActionConfig *arg3 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(ActionConfig **)&jarg3; 
  result = (bool)(arg1)->callAudio((char const *)arg2,arg3);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1callAudio_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->callAudio((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1callAudio_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  SipUri *arg2 = (SipUri *) 0 ;
  ActionConfig *arg3 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = *(SipUri **)&jarg2; 
  arg3 = *(ActionConfig **)&jarg3; 
  result = (bool)(arg1)->callAudio((SipUri const *)arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1callAudio_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  SipUri *arg2 = (SipUri *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = *(SipUri **)&jarg2; 
  result = (bool)(arg1)->callAudio((SipUri const *)arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1callAudioVideo_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  char *arg2 = (char *) 0 ;
  ActionConfig *arg3 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(ActionConfig **)&jarg3; 
  result = (bool)(arg1)->callAudioVideo((char const *)arg2,arg3);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1callAudioVideo_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->callAudioVideo((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1callAudioVideo_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  SipUri *arg2 = (SipUri *) 0 ;
  ActionConfig *arg3 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = *(SipUri **)&jarg2; 
  arg3 = *(ActionConfig **)&jarg3; 
  result = (bool)(arg1)->callAudioVideo((SipUri const *)arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1callAudioVideo_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  SipUri *arg2 = (SipUri *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = *(SipUri **)&jarg2; 
  result = (bool)(arg1)->callAudioVideo((SipUri const *)arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1callVideo_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  char *arg2 = (char *) 0 ;
  ActionConfig *arg3 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(ActionConfig **)&jarg3; 
  result = (bool)(arg1)->callVideo((char const *)arg2,arg3);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1callVideo_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->callVideo((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1callVideo_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  SipUri *arg2 = (SipUri *) 0 ;
  ActionConfig *arg3 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = *(SipUri **)&jarg2; 
  arg3 = *(ActionConfig **)&jarg3; 
  result = (bool)(arg1)->callVideo((SipUri const *)arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1callVideo_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  SipUri *arg2 = (SipUri *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = *(SipUri **)&jarg2; 
  result = (bool)(arg1)->callVideo((SipUri const *)arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1call_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3, jboolean jarg4, jlong jarg5, jobject jarg5_) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  char *arg2 = (char *) 0 ;
  twrap_media_type_t arg3 ;
  bool arg4 ;
  ActionConfig *arg5 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (twrap_media_type_t)jarg3; 
  arg4 = jarg4 ? true : false; 
  arg5 = *(ActionConfig **)&jarg5; 
  result = (bool)(arg1)->call((char const *)arg2,arg3,arg4,arg5);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1call_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3, jboolean jarg4) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  char *arg2 = (char *) 0 ;
  twrap_media_type_t arg3 ;
  bool arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (twrap_media_type_t)jarg3; 
  arg4 = jarg4 ? true : false; 
  result = (bool)(arg1)->call((char const *)arg2,arg3,arg4);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1call_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jboolean jarg4, jlong jarg5, jobject jarg5_) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  SipUri *arg2 = (SipUri *) 0 ;
  twrap_media_type_t arg3 ;
  bool arg4 ;
  ActionConfig *arg5 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg5_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = *(SipUri **)&jarg2; 
  arg3 = (twrap_media_type_t)jarg3; 
  arg4 = jarg4 ? true : false; 
  arg5 = *(ActionConfig **)&jarg5; 
  result = (bool)(arg1)->call((SipUri const *)arg2,arg3,arg4,arg5);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1call_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jboolean jarg4) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  SipUri *arg2 = (SipUri *) 0 ;
  twrap_media_type_t arg3 ;
  bool arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = *(SipUri **)&jarg2; 
  arg3 = (twrap_media_type_t)jarg3; 
  arg4 = jarg4 ? true : false; 
  result = (bool)(arg1)->call((SipUri const *)arg2,arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1callEmergency_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3, jboolean jarg4, jstring jarg5, jint jarg6, jlong jarg7, jobject jarg7_) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  char *arg2 = (char *) 0 ;
  twrap_media_type_t arg3 ;
  bool arg4 ;
  char *arg5 = (char *) 0 ;
  int arg6 ;
  ActionConfig *arg7 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg7_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (twrap_media_type_t)jarg3; 
  arg4 = jarg4 ? true : false; 
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)jenv->GetStringUTFChars(jarg5, 0);
    if (!arg5) return 0;
  }
  arg6 = (int)jarg6; 
  arg7 = *(ActionConfig **)&jarg7; 
  result = (bool)(arg1)->callEmergency((char const *)arg2,arg3,arg4,(char const *)arg5,arg6,arg7);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg5) jenv->ReleaseStringUTFChars(jarg5, (const char *)arg5);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1callEmergency_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3, jboolean jarg4, jstring jarg5, jint jarg6) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  char *arg2 = (char *) 0 ;
  twrap_media_type_t arg3 ;
  bool arg4 ;
  char *arg5 = (char *) 0 ;
  int arg6 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (twrap_media_type_t)jarg3; 
  arg4 = jarg4 ? true : false; 
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)jenv->GetStringUTFChars(jarg5, 0);
    if (!arg5) return 0;
  }
  arg6 = (int)jarg6; 
  result = (bool)(arg1)->callEmergency((char const *)arg2,arg3,arg4,(char const *)arg5,arg6);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg5) jenv->ReleaseStringUTFChars(jarg5, (const char *)arg5);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1callEmergency_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jboolean jarg4, jstring jarg5, jint jarg6, jlong jarg7, jobject jarg7_) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  SipUri *arg2 = (SipUri *) 0 ;
  twrap_media_type_t arg3 ;
  bool arg4 ;
  char *arg5 = (char *) 0 ;
  int arg6 ;
  ActionConfig *arg7 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg7_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = *(SipUri **)&jarg2; 
  arg3 = (twrap_media_type_t)jarg3; 
  arg4 = jarg4 ? true : false; 
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)jenv->GetStringUTFChars(jarg5, 0);
    if (!arg5) return 0;
  }
  arg6 = (int)jarg6; 
  arg7 = *(ActionConfig **)&jarg7; 
  result = (bool)(arg1)->callEmergency((SipUri const *)arg2,arg3,arg4,(char const *)arg5,arg6,arg7);
  jresult = (jboolean)result; 
  if (arg5) jenv->ReleaseStringUTFChars(jarg5, (const char *)arg5);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1callEmergency_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jboolean jarg4, jstring jarg5, jint jarg6) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  SipUri *arg2 = (SipUri *) 0 ;
  twrap_media_type_t arg3 ;
  bool arg4 ;
  char *arg5 = (char *) 0 ;
  int arg6 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = *(SipUri **)&jarg2; 
  arg3 = (twrap_media_type_t)jarg3; 
  arg4 = jarg4 ? true : false; 
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)jenv->GetStringUTFChars(jarg5, 0);
    if (!arg5) return 0;
  }
  arg6 = (int)jarg6; 
  result = (bool)(arg1)->callEmergency((SipUri const *)arg2,arg3,arg4,(char const *)arg5,arg6);
  jresult = (jboolean)result; 
  if (arg5) jenv->ReleaseStringUTFChars(jarg5, (const char *)arg5);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1callGroup(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jint jarg4, jlong jarg5, jobject jarg5_) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  char **arg2 = (char **) 0 ;
  int arg3 ;
  twrap_media_type_t arg4 ;
  ActionConfig *arg5 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = *(char ***)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (twrap_media_type_t)jarg4; 
  arg5 = *(ActionConfig **)&jarg5; 
  result = (bool)(arg1)->callGroup(arg2,arg3,arg4,arg5);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1setSessionTimer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jstring jarg3) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  unsigned int arg2 ;
  char *arg3 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (bool)(arg1)->setSessionTimer(arg2,(char const *)arg3);
  jresult = (jboolean)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1set100rel(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (bool)(arg1)->set100rel(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1setRtcp(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (bool)(arg1)->setRtcp(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1setRtcpMux(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (bool)(arg1)->setRtcpMux(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1setSRtpMode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  enum tmedia_srtp_mode_e arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = (enum tmedia_srtp_mode_e)jarg2; 
  result = (bool)(arg1)->setSRtpMode(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1setAvpfMode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  enum tmedia_mode_e arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = (enum tmedia_mode_e)jarg2; 
  result = (bool)(arg1)->setAvpfMode(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1setICE(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (bool)(arg1)->setICE(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1setICEStun(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (bool)(arg1)->setICEStun(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1setICETurn(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (bool)(arg1)->setICETurn(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1setSTUNServer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  char *arg2 = (char *) 0 ;
  uint16_t arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (uint16_t)jarg3; 
  result = (bool)(arg1)->setSTUNServer((char const *)arg2,arg3);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1setSTUNCred(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (bool)(arg1)->setSTUNCred((char const *)arg2,(char const *)arg3);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1setVideoFps(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  int32_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = (int32_t)jarg2; 
  result = (bool)(arg1)->setVideoFps(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1setVideoBandwidthUploadMax(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  int32_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = (int32_t)jarg2; 
  result = (bool)(arg1)->setVideoBandwidthUploadMax(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1setVideoBandwidthDownloadMax(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  int32_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = (int32_t)jarg2; 
  result = (bool)(arg1)->setVideoBandwidthDownloadMax(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1setVideoPrefSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  tmedia_pref_video_size_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = (tmedia_pref_video_size_t)jarg2; 
  result = (bool)(arg1)->setVideoPrefSize(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1setQoS(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  tmedia_qos_stype_t arg2 ;
  tmedia_qos_strength_t arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = (tmedia_qos_stype_t)jarg2; 
  arg3 = (tmedia_qos_strength_t)jarg3; 
  result = (bool)(arg1)->setQoS(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1setPoCQoE(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  tmedia_poc_qoe_profile_t arg2 ;
  tmedia_poc_qoe_profile_strength_t arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = (tmedia_poc_qoe_profile_t)jarg2; 
  arg3 = (tmedia_poc_qoe_profile_strength_t)jarg3; 
  result = (bool)(arg1)->setPoCQoE(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1hold_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  ActionConfig *arg2 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = *(ActionConfig **)&jarg2; 
  result = (bool)(arg1)->hold(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1hold_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  result = (bool)(arg1)->hold();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1resume_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  ActionConfig *arg2 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = *(ActionConfig **)&jarg2; 
  result = (bool)(arg1)->resume(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1resume_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  result = (bool)(arg1)->resume();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1transfer_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  char *arg2 = (char *) 0 ;
  ActionConfig *arg3 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(ActionConfig **)&jarg3; 
  result = (bool)(arg1)->transfer((char const *)arg2,arg3);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1transfer_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->transfer((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1acceptTransfer_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  ActionConfig *arg2 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = *(ActionConfig **)&jarg2; 
  result = (bool)(arg1)->acceptTransfer(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1acceptTransfer_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  result = (bool)(arg1)->acceptTransfer();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1rejectTransfer_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  ActionConfig *arg2 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = *(ActionConfig **)&jarg2; 
  result = (bool)(arg1)->rejectTransfer(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1rejectTransfer_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  result = (bool)(arg1)->rejectTransfer();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1sendDTMF(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)(arg1)->sendDTMF(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1getSessionTransferId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  result = (unsigned int)(arg1)->getSessionTransferId();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1sendT140Data_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jbyteArray jarg3, jlong jarg4) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  enum tmedia_t140_data_type_e arg2 ;
  void *arg3 = (void *) 0 ;
  unsigned int arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = (enum tmedia_t140_data_type_e)jarg2; 
  
  arg3 = jenv->GetDirectBufferAddress(jarg3); 
  
  arg4 = (unsigned int)jarg4; 
  result = (bool)(arg1)->sendT140Data(arg2,(void const *)arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1sendT140Data_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jbyteArray jarg3) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  enum tmedia_t140_data_type_e arg2 ;
  void *arg3 = (void *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = (enum tmedia_t140_data_type_e)jarg2; 
  
  arg3 = jenv->GetDirectBufferAddress(jarg3); 
  
  result = (bool)(arg1)->sendT140Data(arg2,(void const *)arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1sendT140Data_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  enum tmedia_t140_data_type_e arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = (enum tmedia_t140_data_type_e)jarg2; 
  result = (bool)(arg1)->sendT140Data(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1setT140Callback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  T140Callback *arg2 = (T140Callback *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = *(T140Callback **)&jarg2; 
  result = (bool)(arg1)->setT140Callback((T140Callback const *)arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1setMcpttCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  McpttCallback *arg2 = (McpttCallback *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = *(McpttCallback **)&jarg2; 
  result = (bool)(arg1)->setMcpttCallback((McpttCallback const *)arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1setMcpttMbmsCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  McpttMbmsCallback *arg2 = (McpttMbmsCallback *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = *(McpttMbmsCallback **)&jarg2; 
  result = (bool)(arg1)->setMcpttMbmsCallback((McpttMbmsCallback const *)arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1requestMcpttToken_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  ActionConfig *arg2 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = *(ActionConfig **)&jarg2; 
  result = (bool)(arg1)->requestMcpttToken(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1requestMcpttToken_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  result = (bool)(arg1)->requestMcpttToken();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1releaseMcpttToken_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  ActionConfig *arg2 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = *(ActionConfig **)&jarg2; 
  result = (bool)(arg1)->releaseMcpttToken(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1releaseMcpttToken_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  result = (bool)(arg1)->releaseMcpttToken();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1startMbmsManager(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jint jarg4, jstring jarg5, jint jarg6) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  ActionConfig *arg2 = (ActionConfig *) 0 ;
  char *arg3 = (char *) 0 ;
  int arg4 ;
  char *arg5 = (char *) 0 ;
  int arg6 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = *(ActionConfig **)&jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (int)jarg4; 
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)jenv->GetStringUTFChars(jarg5, 0);
    if (!arg5) return 0;
  }
  arg6 = (int)jarg6; 
  result = (bool)(arg1)->startMbmsManager(arg2,(char const *)arg3,arg4,(char const *)arg5,arg6);
  jresult = (jboolean)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg5) jenv->ReleaseStringUTFChars(jarg5, (const char *)arg5);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1stopMbmsManager(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  ActionConfig *arg2 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = *(ActionConfig **)&jarg2; 
  result = (bool)(arg1)->stopMbmsManager(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1startMbmsMedia(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jint jarg4, jint jarg5) {
  jboolean jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  ActionConfig *arg2 = (ActionConfig *) 0 ;
  char *arg3 = (char *) 0 ;
  int arg4 ;
  int arg5 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = *(ActionConfig **)&jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  result = (bool)(arg1)->startMbmsMedia(arg2,(char const *)arg3,arg4,arg5);
  jresult = (jboolean)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1getPTTMcpttGroupIdentity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  result = (char *)(arg1)->getPTTMcpttGroupIdentity();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1getPTTMcpttGroupMembers(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  result = (int)(arg1)->getPTTMcpttGroupMembers();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1getPTTMcpttGroupMemberAtPosition(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  int arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (char *)(arg1)->getPTTMcpttGroupMemberAtPosition(arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1getPttMcpttEmergencyResourcePriorityString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  result = (char *)(arg1)->getPttMcpttEmergencyResourcePriorityString();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1getPttMcpttEmergencyResourcePriority(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  result = (int)(arg1)->getPttMcpttEmergencyResourcePriority();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1getSipPartyUri(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  CallSession *arg1 = (CallSession *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CallSession **)&jarg1; 
  result = (char *)(arg1)->getSipPartyUri();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1MsrpSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  MsrpCallback *arg2 = (MsrpCallback *) 0 ;
  MsrpSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = *(MsrpCallback **)&jarg2; 
  result = (MsrpSession *)new MsrpSession(arg1,arg2);
  *(MsrpSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1MsrpSession(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  MsrpSession *arg1 = (MsrpSession *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MsrpSession **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MsrpSession_1setCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  MsrpSession *arg1 = (MsrpSession *) 0 ;
  MsrpCallback *arg2 = (MsrpCallback *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(MsrpSession **)&jarg1; 
  arg2 = *(MsrpCallback **)&jarg2; 
  result = (bool)(arg1)->setCallback(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MsrpSession_1callMsrp_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  MsrpSession *arg1 = (MsrpSession *) 0 ;
  char *arg2 = (char *) 0 ;
  ActionConfig *arg3 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(MsrpSession **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(ActionConfig **)&jarg3; 
  result = (bool)(arg1)->callMsrp((char const *)arg2,arg3);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MsrpSession_1callMsrp_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  MsrpSession *arg1 = (MsrpSession *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MsrpSession **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->callMsrp((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MsrpSession_1callMsrp_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  MsrpSession *arg1 = (MsrpSession *) 0 ;
  SipUri *arg2 = (SipUri *) 0 ;
  ActionConfig *arg3 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(MsrpSession **)&jarg1; 
  arg2 = *(SipUri **)&jarg2; 
  arg3 = *(ActionConfig **)&jarg3; 
  result = (bool)(arg1)->callMsrp((SipUri const *)arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MsrpSession_1callMsrp_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  MsrpSession *arg1 = (MsrpSession *) 0 ;
  SipUri *arg2 = (SipUri *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(MsrpSession **)&jarg1; 
  arg2 = *(SipUri **)&jarg2; 
  result = (bool)(arg1)->callMsrp((SipUri const *)arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MsrpSession_1sendMessage_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jboolean jresult = 0 ;
  MsrpSession *arg1 = (MsrpSession *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  ActionConfig *arg4 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(MsrpSession **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  arg4 = *(ActionConfig **)&jarg4; 
  result = (bool)(arg1)->sendMessage((void const *)arg2,arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MsrpSession_1sendMessage_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  MsrpSession *arg1 = (MsrpSession *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MsrpSession **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  result = (bool)(arg1)->sendMessage((void const *)arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MsrpSession_1sendFile_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  MsrpSession *arg1 = (MsrpSession *) 0 ;
  ActionConfig *arg2 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(MsrpSession **)&jarg1; 
  arg2 = *(ActionConfig **)&jarg2; 
  result = (bool)(arg1)->sendFile(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MsrpSession_1sendFile_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  MsrpSession *arg1 = (MsrpSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MsrpSession **)&jarg1; 
  result = (bool)(arg1)->sendFile();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1McpttSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  McpttCallback *arg2 = (McpttCallback *) 0 ;
  McpttSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = *(McpttCallback **)&jarg2; 
  result = (McpttSession *)new McpttSession(arg1,arg2);
  *(McpttSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1McpttSession(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  McpttSession *arg1 = (McpttSession *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(McpttSession **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_McpttSession_1setCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  McpttSession *arg1 = (McpttSession *) 0 ;
  McpttCallback *arg2 = (McpttCallback *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(McpttSession **)&jarg1; 
  arg2 = *(McpttCallback **)&jarg2; 
  result = (bool)(arg1)->setCallback(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_McpttSession_1requestToken_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  McpttSession *arg1 = (McpttSession *) 0 ;
  ActionConfig *arg2 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(McpttSession **)&jarg1; 
  arg2 = *(ActionConfig **)&jarg2; 
  result = (bool)(arg1)->requestToken(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_McpttSession_1requestToken_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  McpttSession *arg1 = (McpttSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(McpttSession **)&jarg1; 
  result = (bool)(arg1)->requestToken();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1MessagingSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  MessagingSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  result = (MessagingSession *)new MessagingSession(arg1);
  *(MessagingSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1MessagingSession(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  MessagingSession *arg1 = (MessagingSession *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MessagingSession **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingSession_1send_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jboolean jresult = 0 ;
  MessagingSession *arg1 = (MessagingSession *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  ActionConfig *arg4 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(MessagingSession **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  arg4 = *(ActionConfig **)&jarg4; 
  result = (bool)(arg1)->send((void const *)arg2,arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingSession_1send_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  MessagingSession *arg1 = (MessagingSession *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MessagingSession **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  result = (bool)(arg1)->send((void const *)arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingSession_1accept_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  MessagingSession *arg1 = (MessagingSession *) 0 ;
  ActionConfig *arg2 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(MessagingSession **)&jarg1; 
  arg2 = *(ActionConfig **)&jarg2; 
  result = (bool)(arg1)->accept(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingSession_1accept_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  MessagingSession *arg1 = (MessagingSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MessagingSession **)&jarg1; 
  result = (bool)(arg1)->accept();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingSession_1reject_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  MessagingSession *arg1 = (MessagingSession *) 0 ;
  ActionConfig *arg2 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(MessagingSession **)&jarg1; 
  arg2 = *(ActionConfig **)&jarg2; 
  result = (bool)(arg1)->reject(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingSession_1reject_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  MessagingSession *arg1 = (MessagingSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MessagingSession **)&jarg1; 
  result = (bool)(arg1)->reject();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1MessagingLocationSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  MessagingLocationSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  result = (MessagingLocationSession *)new MessagingLocationSession(arg1);
  *(MessagingLocationSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1MessagingLocationSession(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  MessagingLocationSession *arg1 = (MessagingLocationSession *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MessagingLocationSession **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingLocationSession_1send_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jboolean jresult = 0 ;
  MessagingLocationSession *arg1 = (MessagingLocationSession *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  ActionConfig *arg4 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(MessagingLocationSession **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  arg4 = *(ActionConfig **)&jarg4; 
  result = (bool)(arg1)->send((void const *)arg2,arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingLocationSession_1send_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  MessagingLocationSession *arg1 = (MessagingLocationSession *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MessagingLocationSession **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  result = (bool)(arg1)->send((void const *)arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingLocationSession_1accept_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  MessagingLocationSession *arg1 = (MessagingLocationSession *) 0 ;
  ActionConfig *arg2 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(MessagingLocationSession **)&jarg1; 
  arg2 = *(ActionConfig **)&jarg2; 
  result = (bool)(arg1)->accept(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingLocationSession_1accept_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  MessagingLocationSession *arg1 = (MessagingLocationSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MessagingLocationSession **)&jarg1; 
  result = (bool)(arg1)->accept();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingLocationSession_1reject_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  MessagingLocationSession *arg1 = (MessagingLocationSession *) 0 ;
  ActionConfig *arg2 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(MessagingLocationSession **)&jarg1; 
  arg2 = *(ActionConfig **)&jarg2; 
  result = (bool)(arg1)->reject(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingLocationSession_1reject_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  MessagingLocationSession *arg1 = (MessagingLocationSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MessagingLocationSession **)&jarg1; 
  result = (bool)(arg1)->reject();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1MessagingAffiliationSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  MessagingAffiliationSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  result = (MessagingAffiliationSession *)new MessagingAffiliationSession(arg1);
  *(MessagingAffiliationSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1MessagingAffiliationSession(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  MessagingAffiliationSession *arg1 = (MessagingAffiliationSession *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MessagingAffiliationSession **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingAffiliationSession_1send_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jboolean jresult = 0 ;
  MessagingAffiliationSession *arg1 = (MessagingAffiliationSession *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  ActionConfig *arg4 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(MessagingAffiliationSession **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  arg4 = *(ActionConfig **)&jarg4; 
  result = (bool)(arg1)->send((void const *)arg2,arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingAffiliationSession_1send_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  MessagingAffiliationSession *arg1 = (MessagingAffiliationSession *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MessagingAffiliationSession **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  result = (bool)(arg1)->send((void const *)arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingAffiliationSession_1accept_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  MessagingAffiliationSession *arg1 = (MessagingAffiliationSession *) 0 ;
  ActionConfig *arg2 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(MessagingAffiliationSession **)&jarg1; 
  arg2 = *(ActionConfig **)&jarg2; 
  result = (bool)(arg1)->accept(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingAffiliationSession_1accept_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  MessagingAffiliationSession *arg1 = (MessagingAffiliationSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MessagingAffiliationSession **)&jarg1; 
  result = (bool)(arg1)->accept();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingAffiliationSession_1reject_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  MessagingAffiliationSession *arg1 = (MessagingAffiliationSession *) 0 ;
  ActionConfig *arg2 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(MessagingAffiliationSession **)&jarg1; 
  arg2 = *(ActionConfig **)&jarg2; 
  result = (bool)(arg1)->reject(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingAffiliationSession_1reject_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  MessagingAffiliationSession *arg1 = (MessagingAffiliationSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MessagingAffiliationSession **)&jarg1; 
  result = (bool)(arg1)->reject();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1MessagingMbmsSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  MessagingMbmsSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  result = (MessagingMbmsSession *)new MessagingMbmsSession(arg1);
  *(MessagingMbmsSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1MessagingMbmsSession(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  MessagingMbmsSession *arg1 = (MessagingMbmsSession *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MessagingMbmsSession **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingMbmsSession_1send_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jboolean jresult = 0 ;
  MessagingMbmsSession *arg1 = (MessagingMbmsSession *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  ActionConfig *arg4 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(MessagingMbmsSession **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  arg4 = *(ActionConfig **)&jarg4; 
  result = (bool)(arg1)->send((void const *)arg2,arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingMbmsSession_1send_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  MessagingMbmsSession *arg1 = (MessagingMbmsSession *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MessagingMbmsSession **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  result = (bool)(arg1)->send((void const *)arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingMbmsSession_1accept_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  MessagingMbmsSession *arg1 = (MessagingMbmsSession *) 0 ;
  ActionConfig *arg2 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(MessagingMbmsSession **)&jarg1; 
  arg2 = *(ActionConfig **)&jarg2; 
  result = (bool)(arg1)->accept(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingMbmsSession_1accept_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  MessagingMbmsSession *arg1 = (MessagingMbmsSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MessagingMbmsSession **)&jarg1; 
  result = (bool)(arg1)->accept();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingMbmsSession_1reject_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  MessagingMbmsSession *arg1 = (MessagingMbmsSession *) 0 ;
  ActionConfig *arg2 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(MessagingMbmsSession **)&jarg1; 
  arg2 = *(ActionConfig **)&jarg2; 
  result = (bool)(arg1)->reject(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingMbmsSession_1reject_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  MessagingMbmsSession *arg1 = (MessagingMbmsSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MessagingMbmsSession **)&jarg1; 
  result = (bool)(arg1)->reject();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1InfoSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  InfoSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  result = (InfoSession *)new InfoSession(arg1);
  *(InfoSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1InfoSession(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  InfoSession *arg1 = (InfoSession *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(InfoSession **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_InfoSession_1send_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jboolean jresult = 0 ;
  InfoSession *arg1 = (InfoSession *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  ActionConfig *arg4 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(InfoSession **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  arg4 = *(ActionConfig **)&jarg4; 
  result = (bool)(arg1)->send((void const *)arg2,arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_InfoSession_1send_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  InfoSession *arg1 = (InfoSession *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InfoSession **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  result = (bool)(arg1)->send((void const *)arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_InfoSession_1accept_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  InfoSession *arg1 = (InfoSession *) 0 ;
  ActionConfig *arg2 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(InfoSession **)&jarg1; 
  arg2 = *(ActionConfig **)&jarg2; 
  result = (bool)(arg1)->accept(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_InfoSession_1accept_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  InfoSession *arg1 = (InfoSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InfoSession **)&jarg1; 
  result = (bool)(arg1)->accept();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_InfoSession_1reject_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  InfoSession *arg1 = (InfoSession *) 0 ;
  ActionConfig *arg2 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(InfoSession **)&jarg1; 
  arg2 = *(ActionConfig **)&jarg2; 
  result = (bool)(arg1)->reject(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_InfoSession_1reject_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  InfoSession *arg1 = (InfoSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InfoSession **)&jarg1; 
  result = (bool)(arg1)->reject();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1OptionsSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  OptionsSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  result = (OptionsSession *)new OptionsSession(arg1);
  *(OptionsSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1OptionsSession(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  OptionsSession *arg1 = (OptionsSession *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(OptionsSession **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_OptionsSession_1send_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  OptionsSession *arg1 = (OptionsSession *) 0 ;
  ActionConfig *arg2 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(OptionsSession **)&jarg1; 
  arg2 = *(ActionConfig **)&jarg2; 
  result = (bool)(arg1)->send(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_OptionsSession_1send_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  OptionsSession *arg1 = (OptionsSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(OptionsSession **)&jarg1; 
  result = (bool)(arg1)->send();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_OptionsSession_1accept_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  OptionsSession *arg1 = (OptionsSession *) 0 ;
  ActionConfig *arg2 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(OptionsSession **)&jarg1; 
  arg2 = *(ActionConfig **)&jarg2; 
  result = (bool)(arg1)->accept(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_OptionsSession_1accept_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  OptionsSession *arg1 = (OptionsSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(OptionsSession **)&jarg1; 
  result = (bool)(arg1)->accept();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_OptionsSession_1reject_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  OptionsSession *arg1 = (OptionsSession *) 0 ;
  ActionConfig *arg2 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(OptionsSession **)&jarg1; 
  arg2 = *(ActionConfig **)&jarg2; 
  result = (bool)(arg1)->reject(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_OptionsSession_1reject_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  OptionsSession *arg1 = (OptionsSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(OptionsSession **)&jarg1; 
  result = (bool)(arg1)->reject();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1PublicationSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  PublicationSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  result = (PublicationSession *)new PublicationSession(arg1);
  *(PublicationSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1PublicationSession(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  PublicationSession *arg1 = (PublicationSession *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(PublicationSession **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_PublicationSession_1publish_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jboolean jresult = 0 ;
  PublicationSession *arg1 = (PublicationSession *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  ActionConfig *arg4 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(PublicationSession **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  arg4 = *(ActionConfig **)&jarg4; 
  result = (bool)(arg1)->publish((void const *)arg2,arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_PublicationSession_1publish_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  PublicationSession *arg1 = (PublicationSession *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(PublicationSession **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  result = (bool)(arg1)->publish((void const *)arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_PublicationSession_1unPublish_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  PublicationSession *arg1 = (PublicationSession *) 0 ;
  ActionConfig *arg2 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(PublicationSession **)&jarg1; 
  arg2 = *(ActionConfig **)&jarg2; 
  result = (bool)(arg1)->unPublish(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_PublicationSession_1unPublish_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  PublicationSession *arg1 = (PublicationSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(PublicationSession **)&jarg1; 
  result = (bool)(arg1)->unPublish();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1PublicationAffiliationSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  PublicationAffiliationSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  result = (PublicationAffiliationSession *)new PublicationAffiliationSession(arg1);
  *(PublicationAffiliationSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1PublicationAffiliationSession(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  PublicationAffiliationSession *arg1 = (PublicationAffiliationSession *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(PublicationAffiliationSession **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_PublicationAffiliationSession_1publish_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jboolean jresult = 0 ;
  PublicationAffiliationSession *arg1 = (PublicationAffiliationSession *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  ActionConfig *arg4 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(PublicationAffiliationSession **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  arg4 = *(ActionConfig **)&jarg4; 
  result = (bool)(arg1)->publish((void const *)arg2,arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_PublicationAffiliationSession_1publish_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  PublicationAffiliationSession *arg1 = (PublicationAffiliationSession *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(PublicationAffiliationSession **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  result = (bool)(arg1)->publish((void const *)arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_PublicationAffiliationSession_1unPublish_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jboolean jresult = 0 ;
  PublicationAffiliationSession *arg1 = (PublicationAffiliationSession *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  ActionConfig *arg4 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(PublicationAffiliationSession **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  arg4 = *(ActionConfig **)&jarg4; 
  result = (bool)(arg1)->unPublish((void const *)arg2,arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_PublicationAffiliationSession_1unPublish_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  PublicationAffiliationSession *arg1 = (PublicationAffiliationSession *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(PublicationAffiliationSession **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  result = (bool)(arg1)->unPublish((void const *)arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1PublicationAuthenticationSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  PublicationAuthenticationSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  result = (PublicationAuthenticationSession *)new PublicationAuthenticationSession(arg1);
  *(PublicationAuthenticationSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1PublicationAuthenticationSession(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  PublicationAuthenticationSession *arg1 = (PublicationAuthenticationSession *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(PublicationAuthenticationSession **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_PublicationAuthenticationSession_1publish_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jbyteArray jarg4, jlong jarg5, jlong jarg6, jobject jarg6_) {
  jboolean jresult = 0 ;
  PublicationAuthenticationSession *arg1 = (PublicationAuthenticationSession *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  void *arg4 = (void *) 0 ;
  unsigned int arg5 ;
  ActionConfig *arg6 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg6_;
  arg1 = *(PublicationAuthenticationSession **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  
  arg4 = jenv->GetDirectBufferAddress(jarg4); 
  
  arg5 = (unsigned int)jarg5; 
  arg6 = *(ActionConfig **)&jarg6; 
  result = (bool)(arg1)->publish((char const *)arg2,(char const *)arg3,(void const *)arg4,arg5,arg6);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_PublicationAuthenticationSession_1publish_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jbyteArray jarg4, jlong jarg5) {
  jboolean jresult = 0 ;
  PublicationAuthenticationSession *arg1 = (PublicationAuthenticationSession *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  void *arg4 = (void *) 0 ;
  unsigned int arg5 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(PublicationAuthenticationSession **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  
  arg4 = jenv->GetDirectBufferAddress(jarg4); 
  
  arg5 = (unsigned int)jarg5; 
  result = (bool)(arg1)->publish((char const *)arg2,(char const *)arg3,(void const *)arg4,arg5);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_PublicationAuthenticationSession_1unPublish_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jboolean jresult = 0 ;
  PublicationAuthenticationSession *arg1 = (PublicationAuthenticationSession *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  ActionConfig *arg4 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(PublicationAuthenticationSession **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  arg4 = *(ActionConfig **)&jarg4; 
  result = (bool)(arg1)->unPublish((void const *)arg2,arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_PublicationAuthenticationSession_1unPublish_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  PublicationAuthenticationSession *arg1 = (PublicationAuthenticationSession *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(PublicationAuthenticationSession **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  result = (bool)(arg1)->unPublish((void const *)arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1RegistrationSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  RegistrationSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  result = (RegistrationSession *)new RegistrationSession(arg1);
  *(RegistrationSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1RegistrationSession(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  RegistrationSession *arg1 = (RegistrationSession *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(RegistrationSession **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_RegistrationSession_1register_1_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  RegistrationSession *arg1 = (RegistrationSession *) 0 ;
  ActionConfig *arg2 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(RegistrationSession **)&jarg1; 
  arg2 = *(ActionConfig **)&jarg2; 
  result = (bool)(arg1)->register_(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_RegistrationSession_1register_1_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  RegistrationSession *arg1 = (RegistrationSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RegistrationSession **)&jarg1; 
  result = (bool)(arg1)->register_();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_RegistrationSession_1registerWithMcpttInfo_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jboolean jresult = 0 ;
  RegistrationSession *arg1 = (RegistrationSession *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  ActionConfig *arg4 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(RegistrationSession **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  arg4 = *(ActionConfig **)&jarg4; 
  result = (bool)(arg1)->registerWithMcpttInfo((void const *)arg2,arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_RegistrationSession_1registerWithMcpttInfo_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  RegistrationSession *arg1 = (RegistrationSession *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RegistrationSession **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  result = (bool)(arg1)->registerWithMcpttInfo((void const *)arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_RegistrationSession_1unRegister_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  RegistrationSession *arg1 = (RegistrationSession *) 0 ;
  ActionConfig *arg2 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(RegistrationSession **)&jarg1; 
  arg2 = *(ActionConfig **)&jarg2; 
  result = (bool)(arg1)->unRegister(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_RegistrationSession_1unRegister_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  RegistrationSession *arg1 = (RegistrationSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RegistrationSession **)&jarg1; 
  result = (bool)(arg1)->unRegister();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_RegistrationSession_1accept_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  RegistrationSession *arg1 = (RegistrationSession *) 0 ;
  ActionConfig *arg2 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(RegistrationSession **)&jarg1; 
  arg2 = *(ActionConfig **)&jarg2; 
  result = (bool)(arg1)->accept(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_RegistrationSession_1accept_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  RegistrationSession *arg1 = (RegistrationSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RegistrationSession **)&jarg1; 
  result = (bool)(arg1)->accept();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_RegistrationSession_1reject_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  RegistrationSession *arg1 = (RegistrationSession *) 0 ;
  ActionConfig *arg2 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(RegistrationSession **)&jarg1; 
  arg2 = *(ActionConfig **)&jarg2; 
  result = (bool)(arg1)->reject(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_RegistrationSession_1reject_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  RegistrationSession *arg1 = (RegistrationSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RegistrationSession **)&jarg1; 
  result = (bool)(arg1)->reject();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1SubscriptionSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  SubscriptionSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  result = (SubscriptionSession *)new SubscriptionSession(arg1);
  *(SubscriptionSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1SubscriptionSession(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SubscriptionSession *arg1 = (SubscriptionSession *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SubscriptionSession **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SubscriptionSession_1subscribe(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  SubscriptionSession *arg1 = (SubscriptionSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SubscriptionSession **)&jarg1; 
  result = (bool)(arg1)->subscribe();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SubscriptionSession_1unSubscribe(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  SubscriptionSession *arg1 = (SubscriptionSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SubscriptionSession **)&jarg1; 
  result = (bool)(arg1)->unSubscribe();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1SubscriptionAffiliationSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  SubscriptionAffiliationSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  result = (SubscriptionAffiliationSession *)new SubscriptionAffiliationSession(arg1);
  *(SubscriptionAffiliationSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1SubscriptionAffiliationSession(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SubscriptionAffiliationSession *arg1 = (SubscriptionAffiliationSession *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SubscriptionAffiliationSession **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SubscriptionAffiliationSession_1subscribeAffiliation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  SubscriptionAffiliationSession *arg1 = (SubscriptionAffiliationSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SubscriptionAffiliationSession **)&jarg1; 
  result = (bool)(arg1)->subscribeAffiliation();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SubscriptionAffiliationSession_1unSubscribeAffiliation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  SubscriptionAffiliationSession *arg1 = (SubscriptionAffiliationSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SubscriptionAffiliationSession **)&jarg1; 
  result = (bool)(arg1)->unSubscribeAffiliation();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1SubscriptionCMSSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  SubscriptionCMSSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  result = (SubscriptionCMSSession *)new SubscriptionCMSSession(arg1);
  *(SubscriptionCMSSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1SubscriptionCMSSession(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SubscriptionCMSSession *arg1 = (SubscriptionCMSSession *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SubscriptionCMSSession **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SubscriptionCMSSession_1subscribeCMS_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3, jbyteArray jarg4, jlong jarg5, jlong jarg6, jobject jarg6_) {
  jboolean jresult = 0 ;
  SubscriptionCMSSession *arg1 = (SubscriptionCMSSession *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  void *arg4 = (void *) 0 ;
  unsigned int arg5 ;
  ActionConfig *arg6 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg6_;
  arg1 = *(SubscriptionCMSSession **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  
  arg4 = jenv->GetDirectBufferAddress(jarg4); 
  
  arg5 = (unsigned int)jarg5; 
  arg6 = *(ActionConfig **)&jarg6; 
  result = (bool)(arg1)->subscribeCMS((void const *)arg2,arg3,(void const *)arg4,arg5,arg6);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SubscriptionCMSSession_1subscribeCMS_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3, jbyteArray jarg4, jlong jarg5) {
  jboolean jresult = 0 ;
  SubscriptionCMSSession *arg1 = (SubscriptionCMSSession *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  void *arg4 = (void *) 0 ;
  unsigned int arg5 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SubscriptionCMSSession **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  
  arg4 = jenv->GetDirectBufferAddress(jarg4); 
  
  arg5 = (unsigned int)jarg5; 
  result = (bool)(arg1)->subscribeCMS((void const *)arg2,arg3,(void const *)arg4,arg5);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SubscriptionCMSSession_1unSubscribeCMS(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  SubscriptionCMSSession *arg1 = (SubscriptionCMSSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SubscriptionCMSSession **)&jarg1; 
  result = (bool)(arg1)->unSubscribeCMS();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1SubscriptionGMSSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  SubscriptionGMSSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  result = (SubscriptionGMSSession *)new SubscriptionGMSSession(arg1);
  *(SubscriptionGMSSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1SubscriptionGMSSession(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SubscriptionGMSSession *arg1 = (SubscriptionGMSSession *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SubscriptionGMSSession **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SubscriptionGMSSession_1subscribeGMS_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3, jbyteArray jarg4, jlong jarg5, jlong jarg6, jobject jarg6_) {
  jboolean jresult = 0 ;
  SubscriptionGMSSession *arg1 = (SubscriptionGMSSession *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  void *arg4 = (void *) 0 ;
  unsigned int arg5 ;
  ActionConfig *arg6 = (ActionConfig *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg6_;
  arg1 = *(SubscriptionGMSSession **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  
  arg4 = jenv->GetDirectBufferAddress(jarg4); 
  
  arg5 = (unsigned int)jarg5; 
  arg6 = *(ActionConfig **)&jarg6; 
  result = (bool)(arg1)->subscribeGMS((void const *)arg2,arg3,(void const *)arg4,arg5,arg6);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SubscriptionGMSSession_1subscribeGMS_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3, jbyteArray jarg4, jlong jarg5) {
  jboolean jresult = 0 ;
  SubscriptionGMSSession *arg1 = (SubscriptionGMSSession *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  void *arg4 = (void *) 0 ;
  unsigned int arg5 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SubscriptionGMSSession **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  
  arg4 = jenv->GetDirectBufferAddress(jarg4); 
  
  arg5 = (unsigned int)jarg5; 
  result = (bool)(arg1)->subscribeGMS((void const *)arg2,arg3,(void const *)arg4,arg5);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SubscriptionGMSSession_1unSubscribeGMS(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  SubscriptionGMSSession *arg1 = (SubscriptionGMSSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SubscriptionGMSSession **)&jarg1; 
  result = (bool)(arg1)->unSubscribeGMS();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1ProxyPluginMgr(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ProxyPluginMgr *arg1 = (ProxyPluginMgr *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ProxyPluginMgr **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyPluginMgr_1createInstance(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  ProxyPluginMgrCallback *arg1 = (ProxyPluginMgrCallback *) 0 ;
  ProxyPluginMgr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyPluginMgrCallback **)&jarg1; 
  result = (ProxyPluginMgr *)ProxyPluginMgr::createInstance(arg1);
  *(ProxyPluginMgr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyPluginMgr_1getInstance(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  ProxyPluginMgr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (ProxyPluginMgr *)ProxyPluginMgr::getInstance();
  *(ProxyPluginMgr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyPluginMgr_1findPlugin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jlong jresult = 0 ;
  ProxyPluginMgr *arg1 = (ProxyPluginMgr *) 0 ;
  uint64_t arg2 ;
  ProxyPlugin *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyPluginMgr **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    for(i=0; i<sz; i++) {
      arg2 = (arg2 << 8) | (uint64_t)(unsigned char)bae[i];
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (ProxyPlugin *)(arg1)->findPlugin(arg2);
  *(ProxyPlugin **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyPluginMgr_1findAudioConsumer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jlong jresult = 0 ;
  ProxyPluginMgr *arg1 = (ProxyPluginMgr *) 0 ;
  uint64_t arg2 ;
  ProxyAudioConsumer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyPluginMgr **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    for(i=0; i<sz; i++) {
      arg2 = (arg2 << 8) | (uint64_t)(unsigned char)bae[i];
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (ProxyAudioConsumer *)(arg1)->findAudioConsumer(arg2);
  *(ProxyAudioConsumer **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyPluginMgr_1findVideoConsumer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jlong jresult = 0 ;
  ProxyPluginMgr *arg1 = (ProxyPluginMgr *) 0 ;
  uint64_t arg2 ;
  ProxyVideoConsumer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyPluginMgr **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    for(i=0; i<sz; i++) {
      arg2 = (arg2 << 8) | (uint64_t)(unsigned char)bae[i];
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (ProxyVideoConsumer *)(arg1)->findVideoConsumer(arg2);
  *(ProxyVideoConsumer **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyPluginMgr_1findAudioProducer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jlong jresult = 0 ;
  ProxyPluginMgr *arg1 = (ProxyPluginMgr *) 0 ;
  uint64_t arg2 ;
  ProxyAudioProducer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyPluginMgr **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    for(i=0; i<sz; i++) {
      arg2 = (arg2 << 8) | (uint64_t)(unsigned char)bae[i];
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (ProxyAudioProducer *)(arg1)->findAudioProducer(arg2);
  *(ProxyAudioProducer **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyPluginMgr_1findVideoProducer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jlong jresult = 0 ;
  ProxyPluginMgr *arg1 = (ProxyPluginMgr *) 0 ;
  uint64_t arg2 ;
  ProxyVideoProducer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyPluginMgr **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    for(i=0; i<sz; i++) {
      arg2 = (arg2 << 8) | (uint64_t)(unsigned char)bae[i];
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (ProxyVideoProducer *)(arg1)->findVideoProducer(arg2);
  *(ProxyVideoProducer **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1ProxyPluginMgrCallback(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  ProxyPluginMgrCallback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (ProxyPluginMgrCallback *)new SwigDirector_ProxyPluginMgrCallback(jenv);
  *(ProxyPluginMgrCallback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1ProxyPluginMgrCallback(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ProxyPluginMgrCallback *arg1 = (ProxyPluginMgrCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ProxyPluginMgrCallback **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyPluginMgrCallback_1OnPluginCreated(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jint jarg3) {
  jint jresult = 0 ;
  ProxyPluginMgrCallback *arg1 = (ProxyPluginMgrCallback *) 0 ;
  uint64_t arg2 ;
  enum twrap_proxy_plugin_type_e arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyPluginMgrCallback **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    for(i=0; i<sz; i++) {
      arg2 = (arg2 << 8) | (uint64_t)(unsigned char)bae[i];
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  arg3 = (enum twrap_proxy_plugin_type_e)jarg3; 
  result = (int)(arg1)->OnPluginCreated(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyPluginMgrCallback_1OnPluginCreatedSwigExplicitProxyPluginMgrCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jint jarg3) {
  jint jresult = 0 ;
  ProxyPluginMgrCallback *arg1 = (ProxyPluginMgrCallback *) 0 ;
  uint64_t arg2 ;
  enum twrap_proxy_plugin_type_e arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyPluginMgrCallback **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    for(i=0; i<sz; i++) {
      arg2 = (arg2 << 8) | (uint64_t)(unsigned char)bae[i];
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  arg3 = (enum twrap_proxy_plugin_type_e)jarg3; 
  result = (int)(arg1)->ProxyPluginMgrCallback::OnPluginCreated(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyPluginMgrCallback_1OnPluginDestroyed(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jint jarg3) {
  jint jresult = 0 ;
  ProxyPluginMgrCallback *arg1 = (ProxyPluginMgrCallback *) 0 ;
  uint64_t arg2 ;
  enum twrap_proxy_plugin_type_e arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyPluginMgrCallback **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    for(i=0; i<sz; i++) {
      arg2 = (arg2 << 8) | (uint64_t)(unsigned char)bae[i];
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  arg3 = (enum twrap_proxy_plugin_type_e)jarg3; 
  result = (int)(arg1)->OnPluginDestroyed(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyPluginMgrCallback_1OnPluginDestroyedSwigExplicitProxyPluginMgrCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jint jarg3) {
  jint jresult = 0 ;
  ProxyPluginMgrCallback *arg1 = (ProxyPluginMgrCallback *) 0 ;
  uint64_t arg2 ;
  enum twrap_proxy_plugin_type_e arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyPluginMgrCallback **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    for(i=0; i<sz; i++) {
      arg2 = (arg2 << 8) | (uint64_t)(unsigned char)bae[i];
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  arg3 = (enum twrap_proxy_plugin_type_e)jarg3; 
  result = (int)(arg1)->ProxyPluginMgrCallback::OnPluginDestroyed(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyPluginMgrCallback_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  ProxyPluginMgrCallback *obj = *((ProxyPluginMgrCallback **)&objarg);
  (void)jcls;
  SwigDirector_ProxyPluginMgrCallback *director = static_cast<SwigDirector_ProxyPluginMgrCallback *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyPluginMgrCallback_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  ProxyPluginMgrCallback *obj = *((ProxyPluginMgrCallback **)&objarg);
  SwigDirector_ProxyPluginMgrCallback *director = static_cast<SwigDirector_ProxyPluginMgrCallback *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1ProxyPlugin(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ProxyPlugin *arg1 = (ProxyPlugin *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ProxyPlugin **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyPlugin_1getType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  ProxyPlugin *arg1 = (ProxyPlugin *) 0 ;
  twrap_proxy_plugin_type_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyPlugin **)&jarg1; 
  result = (twrap_proxy_plugin_type_t)((ProxyPlugin const *)arg1)->getType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyPlugin_1getId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  ProxyPlugin *arg1 = (ProxyPlugin *) 0 ;
  uint64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyPlugin **)&jarg1; 
  result = (uint64_t)((ProxyPlugin const *)arg1)->getId();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1ProxyAudioConsumerCallback(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  ProxyAudioConsumerCallback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (ProxyAudioConsumerCallback *)new SwigDirector_ProxyAudioConsumerCallback(jenv);
  *(ProxyAudioConsumerCallback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1ProxyAudioConsumerCallback(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ProxyAudioConsumerCallback *arg1 = (ProxyAudioConsumerCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ProxyAudioConsumerCallback **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioConsumerCallback_1prepare(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jint jarg4) {
  jint jresult = 0 ;
  ProxyAudioConsumerCallback *arg1 = (ProxyAudioConsumerCallback *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioConsumerCallback **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  result = (int)(arg1)->prepare(arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioConsumerCallback_1prepareSwigExplicitProxyAudioConsumerCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jint jarg4) {
  jint jresult = 0 ;
  ProxyAudioConsumerCallback *arg1 = (ProxyAudioConsumerCallback *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioConsumerCallback **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  result = (int)(arg1)->ProxyAudioConsumerCallback::prepare(arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioConsumerCallback_1start(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  ProxyAudioConsumerCallback *arg1 = (ProxyAudioConsumerCallback *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioConsumerCallback **)&jarg1; 
  result = (int)(arg1)->start();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioConsumerCallback_1startSwigExplicitProxyAudioConsumerCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  ProxyAudioConsumerCallback *arg1 = (ProxyAudioConsumerCallback *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioConsumerCallback **)&jarg1; 
  result = (int)(arg1)->ProxyAudioConsumerCallback::start();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioConsumerCallback_1pause(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  ProxyAudioConsumerCallback *arg1 = (ProxyAudioConsumerCallback *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioConsumerCallback **)&jarg1; 
  result = (int)(arg1)->pause();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioConsumerCallback_1pauseSwigExplicitProxyAudioConsumerCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  ProxyAudioConsumerCallback *arg1 = (ProxyAudioConsumerCallback *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioConsumerCallback **)&jarg1; 
  result = (int)(arg1)->ProxyAudioConsumerCallback::pause();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioConsumerCallback_1stop(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  ProxyAudioConsumerCallback *arg1 = (ProxyAudioConsumerCallback *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioConsumerCallback **)&jarg1; 
  result = (int)(arg1)->stop();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioConsumerCallback_1stopSwigExplicitProxyAudioConsumerCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  ProxyAudioConsumerCallback *arg1 = (ProxyAudioConsumerCallback *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioConsumerCallback **)&jarg1; 
  result = (int)(arg1)->ProxyAudioConsumerCallback::stop();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioConsumerCallback_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  ProxyAudioConsumerCallback *obj = *((ProxyAudioConsumerCallback **)&objarg);
  (void)jcls;
  SwigDirector_ProxyAudioConsumerCallback *director = static_cast<SwigDirector_ProxyAudioConsumerCallback *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioConsumerCallback_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  ProxyAudioConsumerCallback *obj = *((ProxyAudioConsumerCallback **)&objarg);
  SwigDirector_ProxyAudioConsumerCallback *director = static_cast<SwigDirector_ProxyAudioConsumerCallback *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1ProxyAudioConsumer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ProxyAudioConsumer *arg1 = (ProxyAudioConsumer *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ProxyAudioConsumer **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioConsumer_1setActualSndCardPlaybackParams(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jint jarg4) {
  jboolean jresult = 0 ;
  ProxyAudioConsumer *arg1 = (ProxyAudioConsumer *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioConsumer **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  result = (bool)(arg1)->setActualSndCardPlaybackParams(arg2,arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioConsumer_1queryForResampler(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jint jarg4, jint jarg5, jint jarg6) {
  jboolean jresult = 0 ;
  ProxyAudioConsumer *arg1 = (ProxyAudioConsumer *) 0 ;
  uint16_t arg2 ;
  uint16_t arg3 ;
  uint16_t arg4 ;
  uint16_t arg5 ;
  uint16_t arg6 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioConsumer **)&jarg1; 
  arg2 = (uint16_t)jarg2; 
  arg3 = (uint16_t)jarg3; 
  arg4 = (uint16_t)jarg4; 
  arg5 = (uint16_t)jarg5; 
  arg6 = (uint16_t)jarg6; 
  result = (bool)(arg1)->queryForResampler(arg2,arg3,arg4,arg5,arg6);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioConsumer_1setPullBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  ProxyAudioConsumer *arg1 = (ProxyAudioConsumer *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioConsumer **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  result = (bool)(arg1)->setPullBuffer((void const *)arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioConsumer_1pull_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  ProxyAudioConsumer *arg1 = (ProxyAudioConsumer *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioConsumer **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  result = (unsigned int)(arg1)->pull(arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioConsumer_1pull_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2) {
  jlong jresult = 0 ;
  ProxyAudioConsumer *arg1 = (ProxyAudioConsumer *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioConsumer **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  result = (unsigned int)(arg1)->pull(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioConsumer_1pull_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  ProxyAudioConsumer *arg1 = (ProxyAudioConsumer *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioConsumer **)&jarg1; 
  result = (unsigned int)(arg1)->pull();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioConsumer_1setGain(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  ProxyAudioConsumer *arg1 = (ProxyAudioConsumer *) 0 ;
  unsigned int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioConsumer **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  result = (bool)(arg1)->setGain(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioConsumer_1getGain(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  ProxyAudioConsumer *arg1 = (ProxyAudioConsumer *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioConsumer **)&jarg1; 
  result = (unsigned int)(arg1)->getGain();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioConsumer_1reset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  ProxyAudioConsumer *arg1 = (ProxyAudioConsumer *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioConsumer **)&jarg1; 
  result = (bool)(arg1)->reset();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioConsumer_1setCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  ProxyAudioConsumer *arg1 = (ProxyAudioConsumer *) 0 ;
  ProxyAudioConsumerCallback *arg2 = (ProxyAudioConsumerCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(ProxyAudioConsumer **)&jarg1; 
  arg2 = *(ProxyAudioConsumerCallback **)&jarg2; 
  (arg1)->setCallback(arg2);
}


SWIGEXPORT jobject JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioConsumer_1getMediaSessionId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  ProxyAudioConsumer *arg1 = (ProxyAudioConsumer *) 0 ;
  uint64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioConsumer **)&jarg1; 
  result = (uint64_t)(arg1)->getMediaSessionId();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioConsumer_1registerPlugin(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)ProxyAudioConsumer::registerPlugin();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1ProxyVideoConsumerCallback(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  ProxyVideoConsumerCallback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (ProxyVideoConsumerCallback *)new SwigDirector_ProxyVideoConsumerCallback(jenv);
  *(ProxyVideoConsumerCallback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1ProxyVideoConsumerCallback(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ProxyVideoConsumerCallback *arg1 = (ProxyVideoConsumerCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ProxyVideoConsumerCallback **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoConsumerCallback_1prepare(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jint jarg4) {
  jint jresult = 0 ;
  ProxyVideoConsumerCallback *arg1 = (ProxyVideoConsumerCallback *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoConsumerCallback **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  result = (int)(arg1)->prepare(arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoConsumerCallback_1prepareSwigExplicitProxyVideoConsumerCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jint jarg4) {
  jint jresult = 0 ;
  ProxyVideoConsumerCallback *arg1 = (ProxyVideoConsumerCallback *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoConsumerCallback **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  result = (int)(arg1)->ProxyVideoConsumerCallback::prepare(arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoConsumerCallback_1consume(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  ProxyVideoConsumerCallback *arg1 = (ProxyVideoConsumerCallback *) 0 ;
  ProxyVideoFrame *arg2 = (ProxyVideoFrame *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(ProxyVideoConsumerCallback **)&jarg1; 
  arg2 = *(ProxyVideoFrame **)&jarg2; 
  result = (int)(arg1)->consume((ProxyVideoFrame const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoConsumerCallback_1consumeSwigExplicitProxyVideoConsumerCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  ProxyVideoConsumerCallback *arg1 = (ProxyVideoConsumerCallback *) 0 ;
  ProxyVideoFrame *arg2 = (ProxyVideoFrame *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(ProxyVideoConsumerCallback **)&jarg1; 
  arg2 = *(ProxyVideoFrame **)&jarg2; 
  result = (int)(arg1)->ProxyVideoConsumerCallback::consume((ProxyVideoFrame const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoConsumerCallback_1bufferCopied(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  ProxyVideoConsumerCallback *arg1 = (ProxyVideoConsumerCallback *) 0 ;
  unsigned int arg2 ;
  unsigned int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoConsumerCallback **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  arg3 = (unsigned int)jarg3; 
  result = (int)(arg1)->bufferCopied(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoConsumerCallback_1bufferCopiedSwigExplicitProxyVideoConsumerCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  ProxyVideoConsumerCallback *arg1 = (ProxyVideoConsumerCallback *) 0 ;
  unsigned int arg2 ;
  unsigned int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoConsumerCallback **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  arg3 = (unsigned int)jarg3; 
  result = (int)(arg1)->ProxyVideoConsumerCallback::bufferCopied(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoConsumerCallback_1start(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  ProxyVideoConsumerCallback *arg1 = (ProxyVideoConsumerCallback *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoConsumerCallback **)&jarg1; 
  result = (int)(arg1)->start();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoConsumerCallback_1startSwigExplicitProxyVideoConsumerCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  ProxyVideoConsumerCallback *arg1 = (ProxyVideoConsumerCallback *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoConsumerCallback **)&jarg1; 
  result = (int)(arg1)->ProxyVideoConsumerCallback::start();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoConsumerCallback_1pause(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  ProxyVideoConsumerCallback *arg1 = (ProxyVideoConsumerCallback *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoConsumerCallback **)&jarg1; 
  result = (int)(arg1)->pause();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoConsumerCallback_1pauseSwigExplicitProxyVideoConsumerCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  ProxyVideoConsumerCallback *arg1 = (ProxyVideoConsumerCallback *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoConsumerCallback **)&jarg1; 
  result = (int)(arg1)->ProxyVideoConsumerCallback::pause();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoConsumerCallback_1stop(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  ProxyVideoConsumerCallback *arg1 = (ProxyVideoConsumerCallback *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoConsumerCallback **)&jarg1; 
  result = (int)(arg1)->stop();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoConsumerCallback_1stopSwigExplicitProxyVideoConsumerCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  ProxyVideoConsumerCallback *arg1 = (ProxyVideoConsumerCallback *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoConsumerCallback **)&jarg1; 
  result = (int)(arg1)->ProxyVideoConsumerCallback::stop();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoConsumerCallback_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  ProxyVideoConsumerCallback *obj = *((ProxyVideoConsumerCallback **)&objarg);
  (void)jcls;
  SwigDirector_ProxyVideoConsumerCallback *director = static_cast<SwigDirector_ProxyVideoConsumerCallback *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoConsumerCallback_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  ProxyVideoConsumerCallback *obj = *((ProxyVideoConsumerCallback **)&objarg);
  SwigDirector_ProxyVideoConsumerCallback *director = static_cast<SwigDirector_ProxyVideoConsumerCallback *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1ProxyVideoConsumer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ProxyVideoConsumer *arg1 = (ProxyVideoConsumer *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ProxyVideoConsumer **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoConsumer_1setDisplaySize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  ProxyVideoConsumer *arg1 = (ProxyVideoConsumer *) 0 ;
  unsigned int arg2 ;
  unsigned int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoConsumer **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  arg3 = (unsigned int)jarg3; 
  result = (bool)(arg1)->setDisplaySize(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoConsumer_1getDisplayWidth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  ProxyVideoConsumer *arg1 = (ProxyVideoConsumer *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoConsumer **)&jarg1; 
  result = (unsigned int)(arg1)->getDisplayWidth();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoConsumer_1getDisplayHeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  ProxyVideoConsumer *arg1 = (ProxyVideoConsumer *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoConsumer **)&jarg1; 
  result = (unsigned int)(arg1)->getDisplayHeight();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoConsumer_1getDecodedWidth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  ProxyVideoConsumer *arg1 = (ProxyVideoConsumer *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoConsumer **)&jarg1; 
  result = (unsigned int)(arg1)->getDecodedWidth();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoConsumer_1getDecodedHeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  ProxyVideoConsumer *arg1 = (ProxyVideoConsumer *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoConsumer **)&jarg1; 
  result = (unsigned int)(arg1)->getDecodedHeight();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoConsumer_1setCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  ProxyVideoConsumer *arg1 = (ProxyVideoConsumer *) 0 ;
  ProxyVideoConsumerCallback *arg2 = (ProxyVideoConsumerCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(ProxyVideoConsumer **)&jarg1; 
  arg2 = *(ProxyVideoConsumerCallback **)&jarg2; 
  (arg1)->setCallback(arg2);
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoConsumer_1setAutoResizeDisplay(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jboolean jresult = 0 ;
  ProxyVideoConsumer *arg1 = (ProxyVideoConsumer *) 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoConsumer **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (bool)(arg1)->setAutoResizeDisplay(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoConsumer_1getAutoResizeDisplay(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  ProxyVideoConsumer *arg1 = (ProxyVideoConsumer *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoConsumer **)&jarg1; 
  result = (bool)((ProxyVideoConsumer const *)arg1)->getAutoResizeDisplay();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoConsumer_1setConsumeBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  ProxyVideoConsumer *arg1 = (ProxyVideoConsumer *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoConsumer **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  result = (bool)(arg1)->setConsumeBuffer((void const *)arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoConsumer_1pull(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  ProxyVideoConsumer *arg1 = (ProxyVideoConsumer *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoConsumer **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  result = (unsigned int)(arg1)->pull(arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoConsumer_1reset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  ProxyVideoConsumer *arg1 = (ProxyVideoConsumer *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoConsumer **)&jarg1; 
  result = (bool)(arg1)->reset();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoConsumer_1getMediaSessionId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  ProxyVideoConsumer *arg1 = (ProxyVideoConsumer *) 0 ;
  uint64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoConsumer **)&jarg1; 
  result = (uint64_t)(arg1)->getMediaSessionId();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoConsumer_1registerPlugin(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)ProxyVideoConsumer::registerPlugin();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoConsumer_1setDefaultChroma(JNIEnv *jenv, jclass jcls, jint jarg1) {
  tmedia_chroma_t arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (tmedia_chroma_t)jarg1; 
  ProxyVideoConsumer::setDefaultChroma(arg1);
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoConsumer_1setDefaultAutoResizeDisplay(JNIEnv *jenv, jclass jcls, jboolean jarg1) {
  bool arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1 ? true : false; 
  ProxyVideoConsumer::setDefaultAutoResizeDisplay(arg1);
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1ProxyVideoFrame(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ProxyVideoFrame *arg1 = (ProxyVideoFrame *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ProxyVideoFrame **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoFrame_1getSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  ProxyVideoFrame *arg1 = (ProxyVideoFrame *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoFrame **)&jarg1; 
  result = (unsigned int)(arg1)->getSize();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoFrame_1getContent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  ProxyVideoFrame *arg1 = (ProxyVideoFrame *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoFrame **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  result = (unsigned int)(arg1)->getContent(arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoFrame_1getFrameWidth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  ProxyVideoFrame *arg1 = (ProxyVideoFrame *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoFrame **)&jarg1; 
  result = (unsigned int)((ProxyVideoFrame const *)arg1)->getFrameWidth();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoFrame_1getFrameHeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  ProxyVideoFrame *arg1 = (ProxyVideoFrame *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoFrame **)&jarg1; 
  result = (unsigned int)((ProxyVideoFrame const *)arg1)->getFrameHeight();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1ProxyAudioProducerCallback(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  ProxyAudioProducerCallback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (ProxyAudioProducerCallback *)new SwigDirector_ProxyAudioProducerCallback(jenv);
  *(ProxyAudioProducerCallback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1ProxyAudioProducerCallback(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ProxyAudioProducerCallback *arg1 = (ProxyAudioProducerCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ProxyAudioProducerCallback **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioProducerCallback_1prepare(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jint jarg4) {
  jint jresult = 0 ;
  ProxyAudioProducerCallback *arg1 = (ProxyAudioProducerCallback *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioProducerCallback **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  result = (int)(arg1)->prepare(arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioProducerCallback_1prepareSwigExplicitProxyAudioProducerCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jint jarg4) {
  jint jresult = 0 ;
  ProxyAudioProducerCallback *arg1 = (ProxyAudioProducerCallback *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioProducerCallback **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  result = (int)(arg1)->ProxyAudioProducerCallback::prepare(arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioProducerCallback_1start(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  ProxyAudioProducerCallback *arg1 = (ProxyAudioProducerCallback *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioProducerCallback **)&jarg1; 
  result = (int)(arg1)->start();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioProducerCallback_1startSwigExplicitProxyAudioProducerCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  ProxyAudioProducerCallback *arg1 = (ProxyAudioProducerCallback *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioProducerCallback **)&jarg1; 
  result = (int)(arg1)->ProxyAudioProducerCallback::start();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioProducerCallback_1pause(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  ProxyAudioProducerCallback *arg1 = (ProxyAudioProducerCallback *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioProducerCallback **)&jarg1; 
  result = (int)(arg1)->pause();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioProducerCallback_1pauseSwigExplicitProxyAudioProducerCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  ProxyAudioProducerCallback *arg1 = (ProxyAudioProducerCallback *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioProducerCallback **)&jarg1; 
  result = (int)(arg1)->ProxyAudioProducerCallback::pause();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioProducerCallback_1stop(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  ProxyAudioProducerCallback *arg1 = (ProxyAudioProducerCallback *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioProducerCallback **)&jarg1; 
  result = (int)(arg1)->stop();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioProducerCallback_1stopSwigExplicitProxyAudioProducerCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  ProxyAudioProducerCallback *arg1 = (ProxyAudioProducerCallback *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioProducerCallback **)&jarg1; 
  result = (int)(arg1)->ProxyAudioProducerCallback::stop();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioProducerCallback_1fillPushBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  ProxyAudioProducerCallback *arg1 = (ProxyAudioProducerCallback *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioProducerCallback **)&jarg1; 
  result = (int)(arg1)->fillPushBuffer();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioProducerCallback_1fillPushBufferSwigExplicitProxyAudioProducerCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  ProxyAudioProducerCallback *arg1 = (ProxyAudioProducerCallback *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioProducerCallback **)&jarg1; 
  result = (int)(arg1)->ProxyAudioProducerCallback::fillPushBuffer();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioProducerCallback_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  ProxyAudioProducerCallback *obj = *((ProxyAudioProducerCallback **)&objarg);
  (void)jcls;
  SwigDirector_ProxyAudioProducerCallback *director = static_cast<SwigDirector_ProxyAudioProducerCallback *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioProducerCallback_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  ProxyAudioProducerCallback *obj = *((ProxyAudioProducerCallback **)&objarg);
  SwigDirector_ProxyAudioProducerCallback *director = static_cast<SwigDirector_ProxyAudioProducerCallback *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1ProxyAudioProducer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ProxyAudioProducer *arg1 = (ProxyAudioProducer *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ProxyAudioProducer **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioProducer_1setActualSndCardRecordParams(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jint jarg4) {
  jboolean jresult = 0 ;
  ProxyAudioProducer *arg1 = (ProxyAudioProducer *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioProducer **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  result = (bool)(arg1)->setActualSndCardRecordParams(arg2,arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioProducer_1setPushBuffer_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3, jboolean jarg4) {
  jboolean jresult = 0 ;
  ProxyAudioProducer *arg1 = (ProxyAudioProducer *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  bool arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioProducer **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  arg4 = jarg4 ? true : false; 
  result = (bool)(arg1)->setPushBuffer((void const *)arg2,arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioProducer_1setPushBuffer_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  ProxyAudioProducer *arg1 = (ProxyAudioProducer *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioProducer **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  result = (bool)(arg1)->setPushBuffer((void const *)arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioProducer_1push_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3) {
  jint jresult = 0 ;
  ProxyAudioProducer *arg1 = (ProxyAudioProducer *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioProducer **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  result = (int)(arg1)->push((void const *)arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioProducer_1push_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2) {
  jint jresult = 0 ;
  ProxyAudioProducer *arg1 = (ProxyAudioProducer *) 0 ;
  void *arg2 = (void *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioProducer **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  result = (int)(arg1)->push((void const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioProducer_1push_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  ProxyAudioProducer *arg1 = (ProxyAudioProducer *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioProducer **)&jarg1; 
  result = (int)(arg1)->push();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioProducer_1setGain(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  ProxyAudioProducer *arg1 = (ProxyAudioProducer *) 0 ;
  unsigned int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioProducer **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  result = (bool)(arg1)->setGain(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioProducer_1getGain(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  ProxyAudioProducer *arg1 = (ProxyAudioProducer *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioProducer **)&jarg1; 
  result = (unsigned int)(arg1)->getGain();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioProducer_1setCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  ProxyAudioProducer *arg1 = (ProxyAudioProducer *) 0 ;
  ProxyAudioProducerCallback *arg2 = (ProxyAudioProducerCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(ProxyAudioProducer **)&jarg1; 
  arg2 = *(ProxyAudioProducerCallback **)&jarg2; 
  (arg1)->setCallback(arg2);
}


SWIGEXPORT jobject JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioProducer_1getMediaSessionId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  ProxyAudioProducer *arg1 = (ProxyAudioProducer *) 0 ;
  uint64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyAudioProducer **)&jarg1; 
  result = (uint64_t)(arg1)->getMediaSessionId();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioProducer_1registerPlugin(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)ProxyAudioProducer::registerPlugin();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1ProxyVideoProducerCallback(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  ProxyVideoProducerCallback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (ProxyVideoProducerCallback *)new SwigDirector_ProxyVideoProducerCallback(jenv);
  *(ProxyVideoProducerCallback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1ProxyVideoProducerCallback(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ProxyVideoProducerCallback *arg1 = (ProxyVideoProducerCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ProxyVideoProducerCallback **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoProducerCallback_1prepare(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jint jarg4) {
  jint jresult = 0 ;
  ProxyVideoProducerCallback *arg1 = (ProxyVideoProducerCallback *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoProducerCallback **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  result = (int)(arg1)->prepare(arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoProducerCallback_1prepareSwigExplicitProxyVideoProducerCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jint jarg4) {
  jint jresult = 0 ;
  ProxyVideoProducerCallback *arg1 = (ProxyVideoProducerCallback *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoProducerCallback **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  result = (int)(arg1)->ProxyVideoProducerCallback::prepare(arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoProducerCallback_1start(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  ProxyVideoProducerCallback *arg1 = (ProxyVideoProducerCallback *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoProducerCallback **)&jarg1; 
  result = (int)(arg1)->start();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoProducerCallback_1startSwigExplicitProxyVideoProducerCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  ProxyVideoProducerCallback *arg1 = (ProxyVideoProducerCallback *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoProducerCallback **)&jarg1; 
  result = (int)(arg1)->ProxyVideoProducerCallback::start();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoProducerCallback_1pause(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  ProxyVideoProducerCallback *arg1 = (ProxyVideoProducerCallback *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoProducerCallback **)&jarg1; 
  result = (int)(arg1)->pause();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoProducerCallback_1pauseSwigExplicitProxyVideoProducerCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  ProxyVideoProducerCallback *arg1 = (ProxyVideoProducerCallback *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoProducerCallback **)&jarg1; 
  result = (int)(arg1)->ProxyVideoProducerCallback::pause();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoProducerCallback_1stop(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  ProxyVideoProducerCallback *arg1 = (ProxyVideoProducerCallback *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoProducerCallback **)&jarg1; 
  result = (int)(arg1)->stop();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoProducerCallback_1stopSwigExplicitProxyVideoProducerCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  ProxyVideoProducerCallback *arg1 = (ProxyVideoProducerCallback *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoProducerCallback **)&jarg1; 
  result = (int)(arg1)->ProxyVideoProducerCallback::stop();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoProducerCallback_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  ProxyVideoProducerCallback *obj = *((ProxyVideoProducerCallback **)&objarg);
  (void)jcls;
  SwigDirector_ProxyVideoProducerCallback *director = static_cast<SwigDirector_ProxyVideoProducerCallback *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoProducerCallback_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  ProxyVideoProducerCallback *obj = *((ProxyVideoProducerCallback **)&objarg);
  SwigDirector_ProxyVideoProducerCallback *director = static_cast<SwigDirector_ProxyVideoProducerCallback *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1ProxyVideoProducer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ProxyVideoProducer *arg1 = (ProxyVideoProducer *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ProxyVideoProducer **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoProducer_1getRotation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  ProxyVideoProducer *arg1 = (ProxyVideoProducer *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoProducer **)&jarg1; 
  result = (int)((ProxyVideoProducer const *)arg1)->getRotation();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoProducer_1setRotation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  ProxyVideoProducer *arg1 = (ProxyVideoProducer *) 0 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoProducer **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)(arg1)->setRotation(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoProducer_1getMirror(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  ProxyVideoProducer *arg1 = (ProxyVideoProducer *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoProducer **)&jarg1; 
  result = (bool)((ProxyVideoProducer const *)arg1)->getMirror();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoProducer_1setMirror(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jboolean jresult = 0 ;
  ProxyVideoProducer *arg1 = (ProxyVideoProducer *) 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoProducer **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (bool)(arg1)->setMirror(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoProducer_1setActualCameraOutputSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  ProxyVideoProducer *arg1 = (ProxyVideoProducer *) 0 ;
  unsigned int arg2 ;
  unsigned int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoProducer **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  arg3 = (unsigned int)jarg3; 
  result = (bool)(arg1)->setActualCameraOutputSize(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoProducer_1push(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3) {
  jint jresult = 0 ;
  ProxyVideoProducer *arg1 = (ProxyVideoProducer *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoProducer **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  result = (int)(arg1)->push((void const *)arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoProducer_1setCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  ProxyVideoProducer *arg1 = (ProxyVideoProducer *) 0 ;
  ProxyVideoProducerCallback *arg2 = (ProxyVideoProducerCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(ProxyVideoProducer **)&jarg1; 
  arg2 = *(ProxyVideoProducerCallback **)&jarg2; 
  (arg1)->setCallback(arg2);
}


SWIGEXPORT jobject JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoProducer_1getMediaSessionId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  ProxyVideoProducer *arg1 = (ProxyVideoProducer *) 0 ;
  uint64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ProxyVideoProducer **)&jarg1; 
  result = (uint64_t)(arg1)->getMediaSessionId();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoProducer_1registerPlugin(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)ProxyVideoProducer::registerPlugin();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoProducer_1setDefaultChroma(JNIEnv *jenv, jclass jcls, jint jarg1) {
  tmedia_chroma_t arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (tmedia_chroma_t)jarg1; 
  ProxyVideoProducer::setDefaultChroma(arg1);
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1SipCallback(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  SipCallback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (SipCallback *)new SwigDirector_SipCallback(jenv);
  *(SipCallback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1SipCallback(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SipCallback *arg1 = (SipCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SipCallback **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnDialogEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  DialogEvent *arg2 = (DialogEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(DialogEvent **)&jarg2; 
  result = (int)(arg1)->OnDialogEvent((DialogEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnDialogEventSwigExplicitSipCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  DialogEvent *arg2 = (DialogEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(DialogEvent **)&jarg2; 
  result = (int)(arg1)->SipCallback::OnDialogEvent((DialogEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnStackEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  StackEvent *arg2 = (StackEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(StackEvent **)&jarg2; 
  result = (int)(arg1)->OnStackEvent((StackEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnStackEventSwigExplicitSipCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  StackEvent *arg2 = (StackEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(StackEvent **)&jarg2; 
  result = (int)(arg1)->SipCallback::OnStackEvent((StackEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnInviteEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  InviteEvent *arg2 = (InviteEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(InviteEvent **)&jarg2; 
  result = (int)(arg1)->OnInviteEvent((InviteEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnInviteEventSwigExplicitSipCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  InviteEvent *arg2 = (InviteEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(InviteEvent **)&jarg2; 
  result = (int)(arg1)->SipCallback::OnInviteEvent((InviteEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnMessagingEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  MessagingEvent *arg2 = (MessagingEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(MessagingEvent **)&jarg2; 
  result = (int)(arg1)->OnMessagingEvent((MessagingEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnMessagingEventSwigExplicitSipCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  MessagingEvent *arg2 = (MessagingEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(MessagingEvent **)&jarg2; 
  result = (int)(arg1)->SipCallback::OnMessagingEvent((MessagingEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnMessagingAffiliationEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  MessagingAffiliationEvent *arg2 = (MessagingAffiliationEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(MessagingAffiliationEvent **)&jarg2; 
  result = (int)(arg1)->OnMessagingAffiliationEvent((MessagingAffiliationEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnMessagingAffiliationEventSwigExplicitSipCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  MessagingAffiliationEvent *arg2 = (MessagingAffiliationEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(MessagingAffiliationEvent **)&jarg2; 
  result = (int)(arg1)->SipCallback::OnMessagingAffiliationEvent((MessagingAffiliationEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnMessagingMbmsEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  MessagingMbmsEvent *arg2 = (MessagingMbmsEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(MessagingMbmsEvent **)&jarg2; 
  result = (int)(arg1)->OnMessagingMbmsEvent((MessagingMbmsEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnMessagingMbmsEventSwigExplicitSipCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  MessagingMbmsEvent *arg2 = (MessagingMbmsEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(MessagingMbmsEvent **)&jarg2; 
  result = (int)(arg1)->SipCallback::OnMessagingMbmsEvent((MessagingMbmsEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnMessagingLocationEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  MessagingLocationEvent *arg2 = (MessagingLocationEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(MessagingLocationEvent **)&jarg2; 
  result = (int)(arg1)->OnMessagingLocationEvent((MessagingLocationEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnMessagingLocationEventSwigExplicitSipCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  MessagingLocationEvent *arg2 = (MessagingLocationEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(MessagingLocationEvent **)&jarg2; 
  result = (int)(arg1)->SipCallback::OnMessagingLocationEvent((MessagingLocationEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnInfoEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  InfoEvent *arg2 = (InfoEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(InfoEvent **)&jarg2; 
  result = (int)(arg1)->OnInfoEvent((InfoEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnInfoEventSwigExplicitSipCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  InfoEvent *arg2 = (InfoEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(InfoEvent **)&jarg2; 
  result = (int)(arg1)->SipCallback::OnInfoEvent((InfoEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnOptionsEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  OptionsEvent *arg2 = (OptionsEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(OptionsEvent **)&jarg2; 
  result = (int)(arg1)->OnOptionsEvent((OptionsEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnOptionsEventSwigExplicitSipCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  OptionsEvent *arg2 = (OptionsEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(OptionsEvent **)&jarg2; 
  result = (int)(arg1)->SipCallback::OnOptionsEvent((OptionsEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnPublicationEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  PublicationEvent *arg2 = (PublicationEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(PublicationEvent **)&jarg2; 
  result = (int)(arg1)->OnPublicationEvent((PublicationEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnPublicationEventSwigExplicitSipCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  PublicationEvent *arg2 = (PublicationEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(PublicationEvent **)&jarg2; 
  result = (int)(arg1)->SipCallback::OnPublicationEvent((PublicationEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnPublicationAffiliationEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  PublicationAffiliationEvent *arg2 = (PublicationAffiliationEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(PublicationAffiliationEvent **)&jarg2; 
  result = (int)(arg1)->OnPublicationAffiliationEvent((PublicationAffiliationEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnPublicationAffiliationEventSwigExplicitSipCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  PublicationAffiliationEvent *arg2 = (PublicationAffiliationEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(PublicationAffiliationEvent **)&jarg2; 
  result = (int)(arg1)->SipCallback::OnPublicationAffiliationEvent((PublicationAffiliationEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnPublicationAuthenticationEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  PublicationAuthenticationEvent *arg2 = (PublicationAuthenticationEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(PublicationAuthenticationEvent **)&jarg2; 
  result = (int)(arg1)->OnPublicationAuthenticationEvent((PublicationAuthenticationEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnPublicationAuthenticationEventSwigExplicitSipCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  PublicationAuthenticationEvent *arg2 = (PublicationAuthenticationEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(PublicationAuthenticationEvent **)&jarg2; 
  result = (int)(arg1)->SipCallback::OnPublicationAuthenticationEvent((PublicationAuthenticationEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnRegistrationAuthenticationEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  RegistrationAuthenticationEvent *arg2 = (RegistrationAuthenticationEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(RegistrationAuthenticationEvent **)&jarg2; 
  result = (int)(arg1)->OnRegistrationAuthenticationEvent((RegistrationAuthenticationEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnRegistrationAuthenticationEventSwigExplicitSipCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  RegistrationAuthenticationEvent *arg2 = (RegistrationAuthenticationEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(RegistrationAuthenticationEvent **)&jarg2; 
  result = (int)(arg1)->SipCallback::OnRegistrationAuthenticationEvent((RegistrationAuthenticationEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnRegistrationEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  RegistrationEvent *arg2 = (RegistrationEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(RegistrationEvent **)&jarg2; 
  result = (int)(arg1)->OnRegistrationEvent((RegistrationEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnRegistrationEventSwigExplicitSipCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  RegistrationEvent *arg2 = (RegistrationEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(RegistrationEvent **)&jarg2; 
  result = (int)(arg1)->SipCallback::OnRegistrationEvent((RegistrationEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnSubscriptionEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  SubscriptionEvent *arg2 = (SubscriptionEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(SubscriptionEvent **)&jarg2; 
  result = (int)(arg1)->OnSubscriptionEvent((SubscriptionEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnSubscriptionEventSwigExplicitSipCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  SubscriptionEvent *arg2 = (SubscriptionEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(SubscriptionEvent **)&jarg2; 
  result = (int)(arg1)->SipCallback::OnSubscriptionEvent((SubscriptionEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnSubscriptionAffiliationEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  SubscriptionAffiliationEvent *arg2 = (SubscriptionAffiliationEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(SubscriptionAffiliationEvent **)&jarg2; 
  result = (int)(arg1)->OnSubscriptionAffiliationEvent((SubscriptionAffiliationEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnSubscriptionAffiliationEventSwigExplicitSipCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  SubscriptionAffiliationEvent *arg2 = (SubscriptionAffiliationEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(SubscriptionAffiliationEvent **)&jarg2; 
  result = (int)(arg1)->SipCallback::OnSubscriptionAffiliationEvent((SubscriptionAffiliationEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnSubscriptionCMSEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  SubscriptionCMSEvent *arg2 = (SubscriptionCMSEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(SubscriptionCMSEvent **)&jarg2; 
  result = (int)(arg1)->OnSubscriptionCMSEvent((SubscriptionCMSEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnSubscriptionCMSEventSwigExplicitSipCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  SubscriptionCMSEvent *arg2 = (SubscriptionCMSEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(SubscriptionCMSEvent **)&jarg2; 
  result = (int)(arg1)->SipCallback::OnSubscriptionCMSEvent((SubscriptionCMSEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnSubscriptionGMSEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  SubscriptionGMSEvent *arg2 = (SubscriptionGMSEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(SubscriptionGMSEvent **)&jarg2; 
  result = (int)(arg1)->OnSubscriptionGMSEvent((SubscriptionGMSEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1OnSubscriptionGMSEventSwigExplicitSipCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  SubscriptionGMSEvent *arg2 = (SubscriptionGMSEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = *(SubscriptionGMSEvent **)&jarg2; 
  result = (int)(arg1)->SipCallback::OnSubscriptionGMSEvent((SubscriptionGMSEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  SipCallback *obj = *((SipCallback **)&objarg);
  (void)jcls;
  SwigDirector_SipCallback *director = static_cast<SwigDirector_SipCallback *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipCallback_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  SipCallback *obj = *((SipCallback **)&objarg);
  SwigDirector_SipCallback *director = static_cast<SwigDirector_SipCallback *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1SafeObject(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  SafeObject *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (SafeObject *)new SafeObject();
  *(SafeObject **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1SafeObject(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SafeObject *arg1 = (SafeObject *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SafeObject **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SafeObject_1Lock(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SafeObject *arg1 = (SafeObject *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SafeObject **)&jarg1; 
  result = (int)((SafeObject const *)arg1)->Lock();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SafeObject_1UnLock(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SafeObject *arg1 = (SafeObject *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SafeObject **)&jarg1; 
  result = (int)((SafeObject const *)arg1)->UnLock();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1SipStack(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4) {
  jlong jresult = 0 ;
  SipCallback *arg1 = (SipCallback *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  SipStack *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipCallback **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  result = (SipStack *)new SipStack(arg1,(char const *)arg2,(char const *)arg3,(char const *)arg4);
  *(SipStack **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1SipStack(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SipStack *arg1 = (SipStack *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SipStack **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1start(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  result = (bool)(arg1)->start();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setDebugCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  DDebugCallback *arg2 = (DDebugCallback *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = *(DDebugCallback **)&jarg2; 
  result = (bool)(arg1)->setDebugCallback(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setRegisterCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jbyteArray jarg3, jint jarg4) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  DRegisterCallback *arg2 = (DRegisterCallback *) 0 ;
  void *arg3 = (void *) 0 ;
  int arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = *(DRegisterCallback **)&jarg2; 
  
  arg3 = jenv->GetDirectBufferAddress(jarg3); 
  
  arg4 = (int)jarg4; 
  result = (bool)(arg1)->setRegisterCallback(arg2,arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setDisplayName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->setDisplayName((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setRealm(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->setRealm((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setIMPI(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->setIMPI((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setIMPU(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->setIMPU((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setIMPUIP(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->setIMPUIP((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setPassword(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->setPassword((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setAMF(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->setAMF((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setOperatorId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->setOperatorId((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setProxyCSCF(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3, jstring jarg4, jstring jarg5) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  unsigned short arg3 ;
  char *arg4 = (char *) 0 ;
  char *arg5 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (unsigned short)jarg3; 
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)jenv->GetStringUTFChars(jarg5, 0);
    if (!arg5) return 0;
  }
  result = (bool)(arg1)->setProxyCSCF((char const *)arg2,arg3,(char const *)arg4,(char const *)arg5);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  if (arg5) jenv->ReleaseStringUTFChars(jarg5, (const char *)arg5);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setLocalIP_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (bool)(arg1)->setLocalIP((char const *)arg2,(char const *)arg3);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setLocalIP_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->setLocalIP((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setLocalPort_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  unsigned short arg2 ;
  char *arg3 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = (unsigned short)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (bool)(arg1)->setLocalPort(arg2,(char const *)arg3);
  jresult = (jboolean)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setLocalPort_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  unsigned short arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = (unsigned short)jarg2; 
  result = (bool)(arg1)->setLocalPort(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setEarlyIMS(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (bool)(arg1)->setEarlyIMS(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1addHeader(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (bool)(arg1)->addHeader((char const *)arg2,(char const *)arg3);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1removeHeader(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->removeHeader((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1addDnsServer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->addDnsServer((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setDnsDiscovery(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (bool)(arg1)->setDnsDiscovery(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setAoR(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (int)jarg3; 
  result = (bool)(arg1)->setAoR((char const *)arg2,arg3);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setSigCompParams(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jboolean jarg5) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  unsigned int arg2 ;
  unsigned int arg3 ;
  unsigned int arg4 ;
  bool arg5 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  arg3 = (unsigned int)jarg3; 
  arg4 = (unsigned int)jarg4; 
  arg5 = jarg5 ? true : false; 
  result = (bool)(arg1)->setSigCompParams(arg2,arg3,arg4,arg5);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1addSigCompCompartment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->addSigCompCompartment((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1removeSigCompCompartment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->removeSigCompCompartment((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setSTUNEnabledForICE(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (bool)(arg1)->setSTUNEnabledForICE(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setSTUNServer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  unsigned short arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (unsigned short)jarg3; 
  result = (bool)(arg1)->setSTUNServer((char const *)arg2,arg3);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setSTUNCred(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (bool)(arg1)->setSTUNCred((char const *)arg2,(char const *)arg3);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setSTUNEnabled(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (bool)(arg1)->setSTUNEnabled(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setTLSSecAgree(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (bool)(arg1)->setTLSSecAgree(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setSSLCertificates_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4, jboolean jarg5) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  bool arg5 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = jarg5 ? true : false; 
  result = (bool)(arg1)->setSSLCertificates((char const *)arg2,(char const *)arg3,(char const *)arg4,arg5);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setSSLCertificates_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  result = (bool)(arg1)->setSSLCertificates((char const *)arg2,(char const *)arg3,(char const *)arg4);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setSSLCretificates_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4, jboolean jarg5) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  bool arg5 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = jarg5 ? true : false; 
  result = (bool)(arg1)->setSSLCretificates((char const *)arg2,(char const *)arg3,(char const *)arg4,arg5);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setSSLCretificates_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  result = (bool)(arg1)->setSSLCretificates((char const *)arg2,(char const *)arg3,(char const *)arg4);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setIPSecSecAgree(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (bool)(arg1)->setIPSecSecAgree(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setIPSecParameters(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4, jstring jarg5) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  char *arg5 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)jenv->GetStringUTFChars(jarg5, 0);
    if (!arg5) return 0;
  }
  result = (bool)(arg1)->setIPSecParameters((char const *)arg2,(char const *)arg3,(char const *)arg4,(char const *)arg5);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  if (arg5) jenv->ReleaseStringUTFChars(jarg5, (const char *)arg5);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setMCPTTPSIPrivate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->setMCPTTPSIPrivate((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setMCPTTPSIGroup(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->setMCPTTPSIGroup((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setMCPTTPSIPreestablished(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->setMCPTTPSIPreestablished((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setMCPTTPSICMS(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->setMCPTTPSICMS((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setMCPTTPSIGMS(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->setMCPTTPSIGMS((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setMCPTTID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->setMCPTTID((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setMCPTTClientID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->setMCPTTClientID((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setMCPTTPriority(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)(arg1)->setMCPTTPriority(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setMCPTTImplicit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (bool)(arg1)->setMCPTTImplicit(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setMCPTTGranted(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (bool)(arg1)->setMCPTTGranted(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setMCPTTAnswerMode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (bool)(arg1)->setMCPTTAnswerMode(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setMCPTTPrivAnswerMode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (bool)(arg1)->setMCPTTPrivAnswerMode(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setMCPTTNameSpace(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (bool)(arg1)->setMCPTTNameSpace(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setMCPTTInsertXFramedIP(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (bool)(arg1)->setMCPTTInsertXFramedIP(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setMCPTTTimerT100(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)(arg1)->setMCPTTTimerT100(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setMCPTTTimerT101(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)(arg1)->setMCPTTTimerT101(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setMCPTTTimerT103(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)(arg1)->setMCPTTTimerT103(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setMCPTTTimerT104(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)(arg1)->setMCPTTTimerT104(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setMCPTTTimerT132(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)(arg1)->setMCPTTTimerT132(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setLocationPAssertedIdentityServer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->setLocationPAssertedIdentityServer((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setMbmsPAssertedIdentityServer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->setMbmsPAssertedIdentityServer((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setMbmsPortManager(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  unsigned int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  result = (bool)(arg1)->setMbmsPortManager(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setMbmsAddrManager(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->setMbmsAddrManager((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setMbmsIsRTCPMux(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (bool)(arg1)->setMbmsIsRTCPMux(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setMCPTTPSIAffiliation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->setMCPTTPSIAffiliation((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setMCPTTAffiliationIsEnable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (bool)(arg1)->setMCPTTAffiliationIsEnable(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setMCPTTAffiliationGroupsDefualt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->setMCPTTAffiliationGroupsDefualt((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setMCPTTPSIAuthentication(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->setMCPTTPSIAuthentication((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1dnsENUM(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4) {
  jstring jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  result = (char *)(arg1)->dnsENUM((char const *)arg2,(char const *)arg3,(char const *)arg4);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  delete [] result;
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1dnsNaptrSrv(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jintArray jarg4) {
  jstring jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  unsigned short *arg4 = (unsigned short *) 0 ;
  unsigned short temp4 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  {
    if (!jarg4) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return 0;
    }
    if (jenv->GetArrayLength(jarg4) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return 0;
    }
    temp4 = (unsigned short)0;
    arg4 = &temp4; 
  }
  result = (char *)(arg1)->dnsNaptrSrv((char const *)arg2,(char const *)arg3,arg4);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  {
    jint jvalue = (jint)temp4;
    jenv->SetIntArrayRegion(jarg4, 0, 1, &jvalue);
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  
  delete [] result;
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1dnsSrv(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jintArray jarg3) {
  jstring jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  unsigned short *arg3 = (unsigned short *) 0 ;
  unsigned short temp3 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  {
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return 0;
    }
    if (jenv->GetArrayLength(jarg3) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return 0;
    }
    temp3 = (unsigned short)0;
    arg3 = &temp3; 
  }
  result = (char *)(arg1)->dnsSrv((char const *)arg2,arg3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  {
    jint jvalue = (jint)temp3;
    jenv->SetIntArrayRegion(jarg3, 0, 1, &jvalue);
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  
  delete [] result;
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setMaxFDs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  unsigned int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  result = (bool)(arg1)->setMaxFDs(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1getLocalIPnPort(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jintArray jarg3) {
  jstring jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *arg2 = (char *) 0 ;
  unsigned short *arg3 = (unsigned short *) 0 ;
  unsigned short temp3 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  {
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return 0;
    }
    if (jenv->GetArrayLength(jarg3) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return 0;
    }
    temp3 = (unsigned short)0;
    arg3 = &temp3; 
  }
  result = (char *)(arg1)->getLocalIPnPort((char const *)arg2,arg3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  {
    jint jvalue = (jint)temp3;
    jenv->SetIntArrayRegion(jarg3, 0, 1, &jvalue);
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  
  delete [] result;
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1getPreferredIdentity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  result = (char *)(arg1)->getPreferredIdentity();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  delete [] result;
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1isValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  result = (bool)(arg1)->isValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1stop(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  SipStack *arg1 = (SipStack *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SipStack **)&jarg1; 
  result = (bool)(arg1)->stop();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1initialize(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)SipStack::initialize();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1deInitialize(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)SipStack::deInitialize();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setCodecs(JNIEnv *jenv, jclass jcls, jint jarg1) {
  tdav_codec_id_t arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (tdav_codec_id_t)jarg1; 
  SipStack::setCodecs(arg1);
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setCodecs_12(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  int64_t arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int64_t)jarg1; 
  SipStack::setCodecs_2(arg1);
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setCodecPriority(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  tdav_codec_id_t arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (tdav_codec_id_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)SipStack::setCodecPriority(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1setCodecPriority_12(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  int arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)SipStack::setCodecPriority_2(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1isCodecSupported(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  tdav_codec_id_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (tdav_codec_id_t)jarg1; 
  result = (bool)SipStack::isCodecSupported(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1isIPSecSupported(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)SipStack::isIPSecSupported();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1XcapSelector(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  XcapStack *arg1 = (XcapStack *) 0 ;
  XcapSelector *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapStack **)&jarg1; 
  result = (XcapSelector *)new XcapSelector(arg1);
  *(XcapSelector **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1XcapSelector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XcapSelector *arg1 = (XcapSelector *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XcapSelector **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapSelector_1setAUID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  XcapSelector *arg1 = (XcapSelector *) 0 ;
  char *arg2 = (char *) 0 ;
  XcapSelector *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapSelector **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (XcapSelector *)(arg1)->setAUID((char const *)arg2);
  *(XcapSelector **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapSelector_1setName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  XcapSelector *arg1 = (XcapSelector *) 0 ;
  char *arg2 = (char *) 0 ;
  XcapSelector *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapSelector **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (XcapSelector *)(arg1)->setName((char const *)arg2);
  *(XcapSelector **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapSelector_1setAttribute(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4) {
  jlong jresult = 0 ;
  XcapSelector *arg1 = (XcapSelector *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  XcapSelector *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapSelector **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  result = (XcapSelector *)(arg1)->setAttribute((char const *)arg2,(char const *)arg3,(char const *)arg4);
  *(XcapSelector **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapSelector_1setPos(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  XcapSelector *arg1 = (XcapSelector *) 0 ;
  char *arg2 = (char *) 0 ;
  unsigned int arg3 ;
  XcapSelector *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapSelector **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (unsigned int)jarg3; 
  result = (XcapSelector *)(arg1)->setPos((char const *)arg2,arg3);
  *(XcapSelector **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapSelector_1setPosAttribute(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jstring jarg4, jstring jarg5) {
  jlong jresult = 0 ;
  XcapSelector *arg1 = (XcapSelector *) 0 ;
  char *arg2 = (char *) 0 ;
  unsigned int arg3 ;
  char *arg4 = (char *) 0 ;
  char *arg5 = (char *) 0 ;
  XcapSelector *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapSelector **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (unsigned int)jarg3; 
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)jenv->GetStringUTFChars(jarg5, 0);
    if (!arg5) return 0;
  }
  result = (XcapSelector *)(arg1)->setPosAttribute((char const *)arg2,arg3,(char const *)arg4,(char const *)arg5);
  *(XcapSelector **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  if (arg5) jenv->ReleaseStringUTFChars(jarg5, (const char *)arg5);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapSelector_1setNamespace(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  XcapSelector *arg1 = (XcapSelector *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  XcapSelector *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapSelector **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (XcapSelector *)(arg1)->setNamespace((char const *)arg2,(char const *)arg3);
  *(XcapSelector **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapSelector_1getString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  XcapSelector *arg1 = (XcapSelector *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapSelector **)&jarg1; 
  result = (char *)(arg1)->getString();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  delete [] result;
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapSelector_1reset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  XcapSelector *arg1 = (XcapSelector *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapSelector **)&jarg1; 
  (arg1)->reset();
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1XcapMessage(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  XcapMessage *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (XcapMessage *)new XcapMessage();
  *(XcapMessage **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1XcapMessage(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XcapMessage *arg1 = (XcapMessage *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XcapMessage **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jshort JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapMessage_1getCode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  XcapMessage *arg1 = (XcapMessage *) 0 ;
  short result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapMessage **)&jarg1; 
  result = (short)((XcapMessage const *)arg1)->getCode();
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapMessage_1getPhrase(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  XcapMessage *arg1 = (XcapMessage *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapMessage **)&jarg1; 
  result = (char *)((XcapMessage const *)arg1)->getPhrase();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapMessage_1getXcapHeaderValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jstring jresult = 0 ;
  XcapMessage *arg1 = (XcapMessage *) 0 ;
  char *arg2 = (char *) 0 ;
  unsigned int arg3 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapMessage **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (unsigned int)jarg3; 
  result = (char *)(arg1)->getXcapHeaderValue((char const *)arg2,arg3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  delete [] result;
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapMessage_1getXcapHeaderValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jstring jresult = 0 ;
  XcapMessage *arg1 = (XcapMessage *) 0 ;
  char *arg2 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapMessage **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (char *)(arg1)->getXcapHeaderValue((char const *)arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  delete [] result;
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapMessage_1getXcapHeaderParamValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jlong jarg4) {
  jstring jresult = 0 ;
  XcapMessage *arg1 = (XcapMessage *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  unsigned int arg4 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapMessage **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (unsigned int)jarg4; 
  result = (char *)(arg1)->getXcapHeaderParamValue((char const *)arg2,(char const *)arg3,arg4);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  delete [] result;
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapMessage_1getXcapHeaderParamValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jstring jresult = 0 ;
  XcapMessage *arg1 = (XcapMessage *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapMessage **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (char *)(arg1)->getXcapHeaderParamValue((char const *)arg2,(char const *)arg3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  delete [] result;
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapMessage_1getXcapContentLength(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  XcapMessage *arg1 = (XcapMessage *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapMessage **)&jarg1; 
  result = (unsigned int)(arg1)->getXcapContentLength();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapMessage_1getXcapContent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  XcapMessage *arg1 = (XcapMessage *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapMessage **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  result = (unsigned int)(arg1)->getXcapContent(arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1XcapEvent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XcapEvent *arg1 = (XcapEvent *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XcapEvent **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapEvent_1getType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  XcapEvent *arg1 = (XcapEvent *) 0 ;
  thttp_event_type_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapEvent **)&jarg1; 
  result = (thttp_event_type_t)(arg1)->getType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapEvent_1getXcapMessage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  XcapEvent *arg1 = (XcapEvent *) 0 ;
  XcapMessage *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapEvent **)&jarg1; 
  result = (XcapMessage *)((XcapEvent const *)arg1)->getXcapMessage();
  *(XcapMessage **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1XcapCallback(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  XcapCallback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (XcapCallback *)new SwigDirector_XcapCallback(jenv);
  *(XcapCallback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1XcapCallback(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XcapCallback *arg1 = (XcapCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XcapCallback **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapCallback_1onEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  XcapCallback *arg1 = (XcapCallback *) 0 ;
  XcapEvent *arg2 = (XcapEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XcapCallback **)&jarg1; 
  arg2 = *(XcapEvent **)&jarg2; 
  result = (int)((XcapCallback const *)arg1)->onEvent((XcapEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapCallback_1onEventSwigExplicitXcapCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  XcapCallback *arg1 = (XcapCallback *) 0 ;
  XcapEvent *arg2 = (XcapEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XcapCallback **)&jarg1; 
  arg2 = *(XcapEvent **)&jarg2; 
  result = (int)((XcapCallback const *)arg1)->XcapCallback::onEvent((XcapEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapCallback_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  XcapCallback *obj = *((XcapCallback **)&objarg);
  (void)jcls;
  SwigDirector_XcapCallback *director = static_cast<SwigDirector_XcapCallback *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapCallback_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  XcapCallback *obj = *((XcapCallback **)&objarg);
  SwigDirector_XcapCallback *director = static_cast<SwigDirector_XcapCallback *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1XcapStack(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4) {
  jlong jresult = 0 ;
  XcapCallback *arg1 = (XcapCallback *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  XcapStack *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapCallback **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  result = (XcapStack *)new XcapStack(arg1,(char const *)arg2,(char const *)arg3,(char const *)arg4);
  *(XcapStack **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1XcapStack(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XcapStack *arg1 = (XcapStack *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XcapStack **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapStack_1registerAUID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4, jstring jarg5, jboolean jarg6) {
  jboolean jresult = 0 ;
  XcapStack *arg1 = (XcapStack *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  char *arg5 = (char *) 0 ;
  bool arg6 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)jenv->GetStringUTFChars(jarg5, 0);
    if (!arg5) return 0;
  }
  arg6 = jarg6 ? true : false; 
  result = (bool)(arg1)->registerAUID((char const *)arg2,(char const *)arg3,(char const *)arg4,(char const *)arg5,arg6);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  if (arg5) jenv->ReleaseStringUTFChars(jarg5, (const char *)arg5);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapStack_1start(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  XcapStack *arg1 = (XcapStack *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapStack **)&jarg1; 
  result = (bool)(arg1)->start();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapStack_1setCredentials(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jboolean jresult = 0 ;
  XcapStack *arg1 = (XcapStack *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (bool)(arg1)->setCredentials((char const *)arg2,(char const *)arg3);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapStack_1setXcapRoot(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  XcapStack *arg1 = (XcapStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->setXcapRoot((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapStack_1setLocalIP(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  XcapStack *arg1 = (XcapStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->setLocalIP((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapStack_1setLocalPort(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  XcapStack *arg1 = (XcapStack *) 0 ;
  unsigned int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapStack **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  result = (bool)(arg1)->setLocalPort(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapStack_1addHeader(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jboolean jresult = 0 ;
  XcapStack *arg1 = (XcapStack *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (bool)(arg1)->addHeader((char const *)arg2,(char const *)arg3);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapStack_1removeHeader(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  XcapStack *arg1 = (XcapStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->removeHeader((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapStack_1setTimeout(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  XcapStack *arg1 = (XcapStack *) 0 ;
  unsigned int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapStack **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  result = (bool)(arg1)->setTimeout(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapStack_1getDocument(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  XcapStack *arg1 = (XcapStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->getDocument((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapStack_1getElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  XcapStack *arg1 = (XcapStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->getElement((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapStack_1getAttribute(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  XcapStack *arg1 = (XcapStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->getAttribute((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapStack_1deleteDocument(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  XcapStack *arg1 = (XcapStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->deleteDocument((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapStack_1deleteElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  XcapStack *arg1 = (XcapStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->deleteElement((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapStack_1deleteAttribute(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  XcapStack *arg1 = (XcapStack *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->deleteAttribute((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapStack_1putDocument(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jbyteArray jarg3, jlong jarg4, jstring jarg5) {
  jboolean jresult = 0 ;
  XcapStack *arg1 = (XcapStack *) 0 ;
  char *arg2 = (char *) 0 ;
  void *arg3 = (void *) 0 ;
  unsigned int arg4 ;
  char *arg5 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  
  arg3 = jenv->GetDirectBufferAddress(jarg3); 
  
  arg4 = (unsigned int)jarg4; 
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)jenv->GetStringUTFChars(jarg5, 0);
    if (!arg5) return 0;
  }
  result = (bool)(arg1)->putDocument((char const *)arg2,(void const *)arg3,arg4,(char const *)arg5);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg5) jenv->ReleaseStringUTFChars(jarg5, (const char *)arg5);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapStack_1putElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jbyteArray jarg3, jlong jarg4) {
  jboolean jresult = 0 ;
  XcapStack *arg1 = (XcapStack *) 0 ;
  char *arg2 = (char *) 0 ;
  void *arg3 = (void *) 0 ;
  unsigned int arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  
  arg3 = jenv->GetDirectBufferAddress(jarg3); 
  
  arg4 = (unsigned int)jarg4; 
  result = (bool)(arg1)->putElement((char const *)arg2,(void const *)arg3,arg4);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapStack_1putAttribute(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jbyteArray jarg3, jlong jarg4) {
  jboolean jresult = 0 ;
  XcapStack *arg1 = (XcapStack *) 0 ;
  char *arg2 = (char *) 0 ;
  void *arg3 = (void *) 0 ;
  unsigned int arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapStack **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  
  arg3 = jenv->GetDirectBufferAddress(jarg3); 
  
  arg4 = (unsigned int)jarg4; 
  result = (bool)(arg1)->putAttribute((char const *)arg2,(void const *)arg3,arg4);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_XcapStack_1stop(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  XcapStack *arg1 = (XcapStack *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XcapStack **)&jarg1; 
  result = (bool)(arg1)->stop();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1RPMessage(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  RPMessage *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (RPMessage *)new RPMessage();
  *(RPMessage **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1RPMessage(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  RPMessage *arg1 = (RPMessage *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(RPMessage **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_RPMessage_1getType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  RPMessage *arg1 = (RPMessage *) 0 ;
  twrap_rpmessage_type_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RPMessage **)&jarg1; 
  result = (twrap_rpmessage_type_t)(arg1)->getType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_RPMessage_1getPayloadLength(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  RPMessage *arg1 = (RPMessage *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RPMessage **)&jarg1; 
  result = (unsigned int)(arg1)->getPayloadLength();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_RPMessage_1getPayload(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  RPMessage *arg1 = (RPMessage *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RPMessage **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  result = (unsigned int)(arg1)->getPayload(arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1SMSData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  SMSData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (SMSData *)new SMSData();
  *(SMSData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1SMSData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SMSData *arg1 = (SMSData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SMSData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SMSData_1getType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SMSData *arg1 = (SMSData *) 0 ;
  twrap_sms_type_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SMSData **)&jarg1; 
  result = (twrap_sms_type_t)(arg1)->getType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SMSData_1getMR(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SMSData *arg1 = (SMSData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SMSData **)&jarg1; 
  result = (int)(arg1)->getMR();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SMSData_1getPayloadLength(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SMSData *arg1 = (SMSData *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SMSData **)&jarg1; 
  result = (unsigned int)(arg1)->getPayloadLength();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SMSData_1getPayload(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  SMSData *arg1 = (SMSData *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SMSData **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  result = (unsigned int)(arg1)->getPayload(arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SMSData_1getOA(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  SMSData *arg1 = (SMSData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SMSData **)&jarg1; 
  result = (char *)(arg1)->getOA();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SMSData_1getDA(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  SMSData *arg1 = (SMSData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SMSData **)&jarg1; 
  result = (char *)(arg1)->getDA();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SMSEncoder_1encodeSubmit(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jstring jarg3, jstring jarg4) {
  jlong jresult = 0 ;
  int arg1 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  RPMessage *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  result = (RPMessage *)SMSEncoder::encodeSubmit(arg1,(char const *)arg2,(char const *)arg3,(char const *)arg4);
  *(RPMessage **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SMSEncoder_1encodeDeliver(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jstring jarg3, jstring jarg4) {
  jlong jresult = 0 ;
  int arg1 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  RPMessage *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  result = (RPMessage *)SMSEncoder::encodeDeliver(arg1,(char const *)arg2,(char const *)arg3,(char const *)arg4);
  *(RPMessage **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SMSEncoder_1encodeACK(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jstring jarg3, jboolean jarg4) {
  jlong jresult = 0 ;
  int arg1 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  bool arg4 ;
  RPMessage *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = jarg4 ? true : false; 
  result = (RPMessage *)SMSEncoder::encodeACK(arg1,(char const *)arg2,(char const *)arg3,arg4);
  *(RPMessage **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SMSEncoder_1encodeError(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jstring jarg3, jboolean jarg4) {
  jlong jresult = 0 ;
  int arg1 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  bool arg4 ;
  RPMessage *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = jarg4 ? true : false; 
  result = (RPMessage *)SMSEncoder::encodeError(arg1,(char const *)arg2,(char const *)arg3,arg4);
  *(RPMessage **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SMSEncoder_1decode(JNIEnv *jenv, jclass jcls, jbyteArray jarg1, jlong jarg2, jboolean jarg3) {
  jlong jresult = 0 ;
  void *arg1 = (void *) 0 ;
  unsigned int arg2 ;
  bool arg3 ;
  SMSData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  arg1 = jenv->GetDirectBufferAddress(jarg1); 
  
  arg2 = (unsigned int)jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (SMSData *)SMSEncoder::decode((void const *)arg1,arg2,arg3);
  *(SMSData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1SMSEncoder(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SMSEncoder *arg1 = (SMSEncoder *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SMSEncoder **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1MsrpMessage(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  MsrpMessage *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (MsrpMessage *)new MsrpMessage();
  *(MsrpMessage **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1MsrpMessage(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  MsrpMessage *arg1 = (MsrpMessage *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MsrpMessage **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MsrpMessage_1isRequest(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  MsrpMessage *arg1 = (MsrpMessage *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MsrpMessage **)&jarg1; 
  result = (bool)(arg1)->isRequest();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MsrpMessage_1getCode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  MsrpMessage *arg1 = (MsrpMessage *) 0 ;
  short result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MsrpMessage **)&jarg1; 
  result = (short)(arg1)->getCode();
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MsrpMessage_1getPhrase(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  MsrpMessage *arg1 = (MsrpMessage *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MsrpMessage **)&jarg1; 
  result = (char *)(arg1)->getPhrase();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MsrpMessage_1getRequestType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  MsrpMessage *arg1 = (MsrpMessage *) 0 ;
  tmsrp_request_type_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MsrpMessage **)&jarg1; 
  result = (tmsrp_request_type_t)(arg1)->getRequestType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MsrpMessage_1getByteRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlongArray jarg2, jlongArray jarg3, jlongArray jarg4) {
  MsrpMessage *arg1 = (MsrpMessage *) 0 ;
  int64_t *arg2 = (int64_t *) 0 ;
  int64_t *arg3 = (int64_t *) 0 ;
  int64_t *arg4 = (int64_t *) 0 ;
  int64_t temp2 ;
  int64_t temp3 ;
  int64_t temp4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MsrpMessage **)&jarg1; 
  {
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return ;
    }
    if (jenv->GetArrayLength(jarg2) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return ;
    }
    temp2 = (int64_t)0;
    arg2 = &temp2; 
  }
  {
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return ;
    }
    if (jenv->GetArrayLength(jarg3) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return ;
    }
    temp3 = (int64_t)0;
    arg3 = &temp3; 
  }
  {
    if (!jarg4) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return ;
    }
    if (jenv->GetArrayLength(jarg4) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return ;
    }
    temp4 = (int64_t)0;
    arg4 = &temp4; 
  }
  (arg1)->getByteRange(arg2,arg3,arg4);
  {
    jlong jvalue = (jlong)temp2;
    jenv->SetLongArrayRegion(jarg2, 0, 1, &jvalue);
  }
  {
    jlong jvalue = (jlong)temp3;
    jenv->SetLongArrayRegion(jarg3, 0, 1, &jvalue);
  }
  {
    jlong jvalue = (jlong)temp4;
    jenv->SetLongArrayRegion(jarg4, 0, 1, &jvalue);
  }
  
  
  
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MsrpMessage_1isLastChunck(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  MsrpMessage *arg1 = (MsrpMessage *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MsrpMessage **)&jarg1; 
  result = (bool)(arg1)->isLastChunck();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MsrpMessage_1isFirstChunck(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  MsrpMessage *arg1 = (MsrpMessage *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MsrpMessage **)&jarg1; 
  result = (bool)(arg1)->isFirstChunck();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MsrpMessage_1isSuccessReport(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  MsrpMessage *arg1 = (MsrpMessage *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MsrpMessage **)&jarg1; 
  result = (bool)(arg1)->isSuccessReport();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MsrpMessage_1getMsrpHeaderValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jstring jresult = 0 ;
  MsrpMessage *arg1 = (MsrpMessage *) 0 ;
  char *arg2 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MsrpMessage **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (char *)(arg1)->getMsrpHeaderValue((char const *)arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  delete [] result;
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MsrpMessage_1getMsrpHeaderParamValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jstring jresult = 0 ;
  MsrpMessage *arg1 = (MsrpMessage *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MsrpMessage **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (char *)(arg1)->getMsrpHeaderParamValue((char const *)arg2,(char const *)arg3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  delete [] result;
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MsrpMessage_1getMsrpContentLength(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  MsrpMessage *arg1 = (MsrpMessage *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MsrpMessage **)&jarg1; 
  result = (unsigned int)(arg1)->getMsrpContentLength();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MsrpMessage_1getMsrpContent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  MsrpMessage *arg1 = (MsrpMessage *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MsrpMessage **)&jarg1; 
  
  arg2 = jenv->GetDirectBufferAddress(jarg2); 
  
  arg3 = (unsigned int)jarg3; 
  result = (unsigned int)(arg1)->getMsrpContent(arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1MsrpEvent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  MsrpEvent *arg1 = (MsrpEvent *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MsrpEvent **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MsrpEvent_1getType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  MsrpEvent *arg1 = (MsrpEvent *) 0 ;
  tmsrp_event_type_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MsrpEvent **)&jarg1; 
  result = (tmsrp_event_type_t)(arg1)->getType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MsrpEvent_1getSipSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  MsrpEvent *arg1 = (MsrpEvent *) 0 ;
  MsrpSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MsrpEvent **)&jarg1; 
  result = (MsrpSession *)(arg1)->getSipSession();
  *(MsrpSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MsrpEvent_1getMessage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  MsrpEvent *arg1 = (MsrpEvent *) 0 ;
  MsrpMessage *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MsrpEvent **)&jarg1; 
  result = (MsrpMessage *)((MsrpEvent const *)arg1)->getMessage();
  *(MsrpMessage **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1MsrpCallback(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  MsrpCallback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (MsrpCallback *)new SwigDirector_MsrpCallback(jenv);
  *(MsrpCallback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1MsrpCallback(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  MsrpCallback *arg1 = (MsrpCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MsrpCallback **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MsrpCallback_1OnEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  MsrpCallback *arg1 = (MsrpCallback *) 0 ;
  MsrpEvent *arg2 = (MsrpEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(MsrpCallback **)&jarg1; 
  arg2 = *(MsrpEvent **)&jarg2; 
  result = (int)(arg1)->OnEvent((MsrpEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MsrpCallback_1OnEventSwigExplicitMsrpCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  MsrpCallback *arg1 = (MsrpCallback *) 0 ;
  MsrpEvent *arg2 = (MsrpEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(MsrpCallback **)&jarg1; 
  arg2 = *(MsrpEvent **)&jarg2; 
  result = (int)(arg1)->MsrpCallback::OnEvent((MsrpEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MsrpCallback_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  MsrpCallback *obj = *((MsrpCallback **)&objarg);
  (void)jcls;
  SwigDirector_MsrpCallback *director = static_cast<SwigDirector_MsrpCallback *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MsrpCallback_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  MsrpCallback *obj = *((MsrpCallback **)&objarg);
  SwigDirector_MsrpCallback *director = static_cast<SwigDirector_MsrpCallback *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1McpttMessage(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  McpttMessage *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (McpttMessage *)new McpttMessage();
  *(McpttMessage **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1McpttMessage(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  McpttMessage *arg1 = (McpttMessage *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(McpttMessage **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jshort JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_McpttMessage_1getRCode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  McpttMessage *arg1 = (McpttMessage *) 0 ;
  short result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(McpttMessage **)&jarg1; 
  result = (short)(arg1)->getRCode();
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_McpttMessage_1getPhrase(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  McpttMessage *arg1 = (McpttMessage *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(McpttMessage **)&jarg1; 
  result = (char *)(arg1)->getPhrase();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_McpttMessage_1getUser(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  McpttMessage *arg1 = (McpttMessage *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(McpttMessage **)&jarg1; 
  result = (char *)(arg1)->getUser();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_McpttMessage_1getParticipants(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  McpttMessage *arg1 = (McpttMessage *) 0 ;
  short result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(McpttMessage **)&jarg1; 
  result = (short)(arg1)->getParticipants();
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_McpttMessage_1getTime(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  McpttMessage *arg1 = (McpttMessage *) 0 ;
  short result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(McpttMessage **)&jarg1; 
  result = (short)(arg1)->getTime();
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1McpttEvent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  McpttEvent *arg1 = (McpttEvent *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(McpttEvent **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_McpttEvent_1getType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  McpttEvent *arg1 = (McpttEvent *) 0 ;
  tmcptt_event_type_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(McpttEvent **)&jarg1; 
  result = (tmcptt_event_type_t)(arg1)->getType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_McpttEvent_1getSipSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  McpttEvent *arg1 = (McpttEvent *) 0 ;
  CallSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(McpttEvent **)&jarg1; 
  result = (CallSession *)(arg1)->getSipSession();
  *(CallSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_McpttEvent_1getMessage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  McpttEvent *arg1 = (McpttEvent *) 0 ;
  McpttMessage *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(McpttEvent **)&jarg1; 
  result = (McpttMessage *)((McpttEvent const *)arg1)->getMessage();
  *(McpttMessage **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1McpttCallback(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  McpttCallback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (McpttCallback *)new SwigDirector_McpttCallback(jenv);
  *(McpttCallback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1McpttCallback(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  McpttCallback *arg1 = (McpttCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(McpttCallback **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_McpttCallback_1OnEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  McpttCallback *arg1 = (McpttCallback *) 0 ;
  McpttEvent *arg2 = (McpttEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(McpttCallback **)&jarg1; 
  arg2 = *(McpttEvent **)&jarg2; 
  result = (int)(arg1)->OnEvent((McpttEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_McpttCallback_1OnEventSwigExplicitMcpttCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  McpttCallback *arg1 = (McpttCallback *) 0 ;
  McpttEvent *arg2 = (McpttEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(McpttCallback **)&jarg1; 
  arg2 = *(McpttEvent **)&jarg2; 
  result = (int)(arg1)->McpttCallback::OnEvent((McpttEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_McpttCallback_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  McpttCallback *obj = *((McpttCallback **)&objarg);
  (void)jcls;
  SwigDirector_McpttCallback *director = static_cast<SwigDirector_McpttCallback *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_McpttCallback_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  McpttCallback *obj = *((McpttCallback **)&objarg);
  SwigDirector_McpttCallback *director = static_cast<SwigDirector_McpttCallback *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1McpttMbmsMessage(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  McpttMbmsMessage *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (McpttMbmsMessage *)new McpttMbmsMessage();
  *(McpttMbmsMessage **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1McpttMbmsMessage(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  McpttMbmsMessage *arg1 = (McpttMbmsMessage *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(McpttMbmsMessage **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_McpttMbmsMessage_1getGroupId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  McpttMbmsMessage *arg1 = (McpttMbmsMessage *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(McpttMbmsMessage **)&jarg1; 
  result = (char *)(arg1)->getGroupId();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_McpttMbmsMessage_1getTMGI(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  McpttMbmsMessage *arg1 = (McpttMbmsMessage *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(McpttMbmsMessage **)&jarg1; 
  result = (char *)(arg1)->getTMGI();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_McpttMbmsMessage_1getMediaIP(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  McpttMbmsMessage *arg1 = (McpttMbmsMessage *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(McpttMbmsMessage **)&jarg1; 
  result = (char *)(arg1)->getMediaIP();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_McpttMbmsMessage_1getMediaPort(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  McpttMbmsMessage *arg1 = (McpttMbmsMessage *) 0 ;
  short result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(McpttMbmsMessage **)&jarg1; 
  result = (short)(arg1)->getMediaPort();
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_McpttMbmsMessage_1getMediaControlPort(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  McpttMbmsMessage *arg1 = (McpttMbmsMessage *) 0 ;
  short result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(McpttMbmsMessage **)&jarg1; 
  result = (short)(arg1)->getMediaControlPort();
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1McpttMbmsEvent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  McpttMbmsEvent *arg1 = (McpttMbmsEvent *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(McpttMbmsEvent **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_McpttMbmsEvent_1getType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  McpttMbmsEvent *arg1 = (McpttMbmsEvent *) 0 ;
  tmcptt_mbms_event_type_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(McpttMbmsEvent **)&jarg1; 
  result = (tmcptt_mbms_event_type_t)(arg1)->getType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_McpttMbmsEvent_1getSipSession(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  McpttMbmsEvent *arg1 = (McpttMbmsEvent *) 0 ;
  CallSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(McpttMbmsEvent **)&jarg1; 
  result = (CallSession *)(arg1)->getSipSession();
  *(CallSession **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_McpttMbmsEvent_1getMessage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  McpttMbmsEvent *arg1 = (McpttMbmsEvent *) 0 ;
  McpttMbmsMessage *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(McpttMbmsEvent **)&jarg1; 
  result = (McpttMbmsMessage *)((McpttMbmsEvent const *)arg1)->getMessage();
  *(McpttMbmsMessage **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_new_1McpttMbmsCallback(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  McpttMbmsCallback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (McpttMbmsCallback *)new SwigDirector_McpttMbmsCallback(jenv);
  *(McpttMbmsCallback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_delete_1McpttMbmsCallback(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  McpttMbmsCallback *arg1 = (McpttMbmsCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(McpttMbmsCallback **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_McpttMbmsCallback_1OnEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  McpttMbmsCallback *arg1 = (McpttMbmsCallback *) 0 ;
  McpttMbmsEvent *arg2 = (McpttMbmsEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(McpttMbmsCallback **)&jarg1; 
  arg2 = *(McpttMbmsEvent **)&jarg2; 
  result = (int)(arg1)->OnEvent((McpttMbmsEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_McpttMbmsCallback_1OnEventSwigExplicitMcpttMbmsCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  McpttMbmsCallback *arg1 = (McpttMbmsCallback *) 0 ;
  McpttMbmsEvent *arg2 = (McpttMbmsEvent *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(McpttMbmsCallback **)&jarg1; 
  arg2 = *(McpttMbmsEvent **)&jarg2; 
  result = (int)(arg1)->McpttMbmsCallback::OnEvent((McpttMbmsEvent const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_McpttMbmsCallback_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  McpttMbmsCallback *obj = *((McpttMbmsCallback **)&objarg);
  (void)jcls;
  SwigDirector_McpttMbmsCallback *director = static_cast<SwigDirector_McpttMbmsCallback *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_McpttMbmsCallback_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  McpttMbmsCallback *obj = *((McpttMbmsCallback **)&objarg);
  SwigDirector_McpttMbmsCallback *director = static_cast<SwigDirector_McpttMbmsCallback *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MediaContentCPIM_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(MediaContent **)&baseptr = *(MediaContentCPIM **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_DialogEvent_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(SipEvent **)&baseptr = *(DialogEvent **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_StackEvent_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(SipEvent **)&baseptr = *(StackEvent **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_InviteEvent_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(SipEvent **)&baseptr = *(InviteEvent **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingEvent_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(SipEvent **)&baseptr = *(MessagingEvent **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingLocationEvent_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(SipEvent **)&baseptr = *(MessagingLocationEvent **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingAffiliationEvent_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(SipEvent **)&baseptr = *(MessagingAffiliationEvent **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingMbmsEvent_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(SipEvent **)&baseptr = *(MessagingMbmsEvent **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_InfoEvent_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(SipEvent **)&baseptr = *(InfoEvent **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_OptionsEvent_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(SipEvent **)&baseptr = *(OptionsEvent **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_PublicationEvent_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(SipEvent **)&baseptr = *(PublicationEvent **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_PublicationAffiliationEvent_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(SipEvent **)&baseptr = *(PublicationAffiliationEvent **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_PublicationAuthenticationEvent_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(SipEvent **)&baseptr = *(PublicationAuthenticationEvent **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_RegistrationAuthenticationEvent_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(SipEvent **)&baseptr = *(RegistrationAuthenticationEvent **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_RegistrationEvent_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(SipEvent **)&baseptr = *(RegistrationEvent **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SubscriptionEvent_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(SipEvent **)&baseptr = *(SubscriptionEvent **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SubscriptionAffiliationEvent_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(SipEvent **)&baseptr = *(SubscriptionAffiliationEvent **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SubscriptionCMSEvent_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(SipEvent **)&baseptr = *(SubscriptionCMSEvent **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SubscriptionGMSEvent_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(SipEvent **)&baseptr = *(SubscriptionGMSEvent **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_InviteSession_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(SipSession **)&baseptr = *(InviteSession **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_CallSession_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(InviteSession **)&baseptr = *(CallSession **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MsrpSession_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(InviteSession **)&baseptr = *(MsrpSession **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_McpttSession_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(InviteSession **)&baseptr = *(McpttSession **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingSession_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(SipSession **)&baseptr = *(MessagingSession **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingLocationSession_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(SipSession **)&baseptr = *(MessagingLocationSession **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingAffiliationSession_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(SipSession **)&baseptr = *(MessagingAffiliationSession **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_MessagingMbmsSession_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(SipSession **)&baseptr = *(MessagingMbmsSession **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_InfoSession_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(SipSession **)&baseptr = *(InfoSession **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_OptionsSession_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(SipSession **)&baseptr = *(OptionsSession **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_PublicationSession_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(SipSession **)&baseptr = *(PublicationSession **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_PublicationAffiliationSession_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(SipSession **)&baseptr = *(PublicationAffiliationSession **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_PublicationAuthenticationSession_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(SipSession **)&baseptr = *(PublicationAuthenticationSession **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_RegistrationSession_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(SipSession **)&baseptr = *(RegistrationSession **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SubscriptionSession_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(SipSession **)&baseptr = *(SubscriptionSession **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SubscriptionAffiliationSession_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(SipSession **)&baseptr = *(SubscriptionAffiliationSession **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SubscriptionCMSSession_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(SipSession **)&baseptr = *(SubscriptionCMSSession **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SubscriptionGMSSession_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(SipSession **)&baseptr = *(SubscriptionGMSSession **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioConsumer_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(ProxyPlugin **)&baseptr = *(ProxyAudioConsumer **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoConsumer_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(ProxyPlugin **)&baseptr = *(ProxyVideoConsumer **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyAudioProducer_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(ProxyPlugin **)&baseptr = *(ProxyAudioProducer **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_ProxyVideoProducer_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(ProxyPlugin **)&baseptr = *(ProxyVideoProducer **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_SipStack_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(SafeObject **)&baseptr = *(SipStack **)&jarg1;
    return baseptr;
}

SWIGEXPORT void JNICALL Java_org_doubango_tinyWRAP_tinyWRAPJNI_swig_1module_1init(JNIEnv *jenv, jclass jcls) {
  int i;
  
  static struct {
    const char *method;
    const char *signature;
  } methods[50] = {
    {
      "SwigDirector_DDebugCallback_OnDebugTest", "(Lorg/doubango/tinyWRAP/DDebugCallback;Ljava/lang/String;)I" 
    },
    {
      "SwigDirector_DDebugCallback_OnDebugInfo", "(Lorg/doubango/tinyWRAP/DDebugCallback;Ljava/lang/String;)I" 
    },
    {
      "SwigDirector_DDebugCallback_OnDebugWarn", "(Lorg/doubango/tinyWRAP/DDebugCallback;Ljava/lang/String;)I" 
    },
    {
      "SwigDirector_DDebugCallback_OnDebugError", "(Lorg/doubango/tinyWRAP/DDebugCallback;Ljava/lang/String;)I" 
    },
    {
      "SwigDirector_DDebugCallback_OnDebugFatal", "(Lorg/doubango/tinyWRAP/DDebugCallback;Ljava/lang/String;)I" 
    },
    {
      "SwigDirector_DRegisterCallback_onAuthRegister", "(Lorg/doubango/tinyWRAP/DRegisterCallback;Ljava/lang/String;)I" 
    },
    {
      "SwigDirector_T140Callback_ondata", "(Lorg/doubango/tinyWRAP/T140Callback;J)I" 
    },
    {
      "SwigDirector_ProxyPluginMgrCallback_OnPluginCreated", "(Lorg/doubango/tinyWRAP/ProxyPluginMgrCallback;Ljava/math/BigInteger;I)I" 
    },
    {
      "SwigDirector_ProxyPluginMgrCallback_OnPluginDestroyed", "(Lorg/doubango/tinyWRAP/ProxyPluginMgrCallback;Ljava/math/BigInteger;I)I" 
    },
    {
      "SwigDirector_ProxyAudioConsumerCallback_prepare", "(Lorg/doubango/tinyWRAP/ProxyAudioConsumerCallback;III)I" 
    },
    {
      "SwigDirector_ProxyAudioConsumerCallback_start", "(Lorg/doubango/tinyWRAP/ProxyAudioConsumerCallback;)I" 
    },
    {
      "SwigDirector_ProxyAudioConsumerCallback_pause", "(Lorg/doubango/tinyWRAP/ProxyAudioConsumerCallback;)I" 
    },
    {
      "SwigDirector_ProxyAudioConsumerCallback_stop", "(Lorg/doubango/tinyWRAP/ProxyAudioConsumerCallback;)I" 
    },
    {
      "SwigDirector_ProxyVideoConsumerCallback_prepare", "(Lorg/doubango/tinyWRAP/ProxyVideoConsumerCallback;III)I" 
    },
    {
      "SwigDirector_ProxyVideoConsumerCallback_consume", "(Lorg/doubango/tinyWRAP/ProxyVideoConsumerCallback;J)I" 
    },
    {
      "SwigDirector_ProxyVideoConsumerCallback_bufferCopied", "(Lorg/doubango/tinyWRAP/ProxyVideoConsumerCallback;JJ)I" 
    },
    {
      "SwigDirector_ProxyVideoConsumerCallback_start", "(Lorg/doubango/tinyWRAP/ProxyVideoConsumerCallback;)I" 
    },
    {
      "SwigDirector_ProxyVideoConsumerCallback_pause", "(Lorg/doubango/tinyWRAP/ProxyVideoConsumerCallback;)I" 
    },
    {
      "SwigDirector_ProxyVideoConsumerCallback_stop", "(Lorg/doubango/tinyWRAP/ProxyVideoConsumerCallback;)I" 
    },
    {
      "SwigDirector_ProxyAudioProducerCallback_prepare", "(Lorg/doubango/tinyWRAP/ProxyAudioProducerCallback;III)I" 
    },
    {
      "SwigDirector_ProxyAudioProducerCallback_start", "(Lorg/doubango/tinyWRAP/ProxyAudioProducerCallback;)I" 
    },
    {
      "SwigDirector_ProxyAudioProducerCallback_pause", "(Lorg/doubango/tinyWRAP/ProxyAudioProducerCallback;)I" 
    },
    {
      "SwigDirector_ProxyAudioProducerCallback_stop", "(Lorg/doubango/tinyWRAP/ProxyAudioProducerCallback;)I" 
    },
    {
      "SwigDirector_ProxyAudioProducerCallback_fillPushBuffer", "(Lorg/doubango/tinyWRAP/ProxyAudioProducerCallback;)I" 
    },
    {
      "SwigDirector_ProxyVideoProducerCallback_prepare", "(Lorg/doubango/tinyWRAP/ProxyVideoProducerCallback;III)I" 
    },
    {
      "SwigDirector_ProxyVideoProducerCallback_start", "(Lorg/doubango/tinyWRAP/ProxyVideoProducerCallback;)I" 
    },
    {
      "SwigDirector_ProxyVideoProducerCallback_pause", "(Lorg/doubango/tinyWRAP/ProxyVideoProducerCallback;)I" 
    },
    {
      "SwigDirector_ProxyVideoProducerCallback_stop", "(Lorg/doubango/tinyWRAP/ProxyVideoProducerCallback;)I" 
    },
    {
      "SwigDirector_SipCallback_OnDialogEvent", "(Lorg/doubango/tinyWRAP/SipCallback;J)I" 
    },
    {
      "SwigDirector_SipCallback_OnStackEvent", "(Lorg/doubango/tinyWRAP/SipCallback;J)I" 
    },
    {
      "SwigDirector_SipCallback_OnInviteEvent", "(Lorg/doubango/tinyWRAP/SipCallback;J)I" 
    },
    {
      "SwigDirector_SipCallback_OnMessagingEvent", "(Lorg/doubango/tinyWRAP/SipCallback;J)I" 
    },
    {
      "SwigDirector_SipCallback_OnMessagingAffiliationEvent", "(Lorg/doubango/tinyWRAP/SipCallback;J)I" 
    },
    {
      "SwigDirector_SipCallback_OnMessagingMbmsEvent", "(Lorg/doubango/tinyWRAP/SipCallback;J)I" 
    },
    {
      "SwigDirector_SipCallback_OnMessagingLocationEvent", "(Lorg/doubango/tinyWRAP/SipCallback;J)I" 
    },
    {
      "SwigDirector_SipCallback_OnInfoEvent", "(Lorg/doubango/tinyWRAP/SipCallback;J)I" 
    },
    {
      "SwigDirector_SipCallback_OnOptionsEvent", "(Lorg/doubango/tinyWRAP/SipCallback;J)I" 
    },
    {
      "SwigDirector_SipCallback_OnPublicationEvent", "(Lorg/doubango/tinyWRAP/SipCallback;J)I" 
    },
    {
      "SwigDirector_SipCallback_OnPublicationAffiliationEvent", "(Lorg/doubango/tinyWRAP/SipCallback;J)I" 
    },
    {
      "SwigDirector_SipCallback_OnPublicationAuthenticationEvent", "(Lorg/doubango/tinyWRAP/SipCallback;J)I" 
    },
    {
      "SwigDirector_SipCallback_OnRegistrationAuthenticationEvent", "(Lorg/doubango/tinyWRAP/SipCallback;J)I" 
    },
    {
      "SwigDirector_SipCallback_OnRegistrationEvent", "(Lorg/doubango/tinyWRAP/SipCallback;J)I" 
    },
    {
      "SwigDirector_SipCallback_OnSubscriptionEvent", "(Lorg/doubango/tinyWRAP/SipCallback;J)I" 
    },
    {
      "SwigDirector_SipCallback_OnSubscriptionAffiliationEvent", "(Lorg/doubango/tinyWRAP/SipCallback;J)I" 
    },
    {
      "SwigDirector_SipCallback_OnSubscriptionCMSEvent", "(Lorg/doubango/tinyWRAP/SipCallback;J)I" 
    },
    {
      "SwigDirector_SipCallback_OnSubscriptionGMSEvent", "(Lorg/doubango/tinyWRAP/SipCallback;J)I" 
    },
    {
      "SwigDirector_XcapCallback_onEvent", "(Lorg/doubango/tinyWRAP/XcapCallback;J)I" 
    },
    {
      "SwigDirector_MsrpCallback_OnEvent", "(Lorg/doubango/tinyWRAP/MsrpCallback;J)I" 
    },
    {
      "SwigDirector_McpttCallback_OnEvent", "(Lorg/doubango/tinyWRAP/McpttCallback;J)I" 
    },
    {
      "SwigDirector_McpttMbmsCallback_OnEvent", "(Lorg/doubango/tinyWRAP/McpttMbmsCallback;J)I" 
    }
  };
  Swig::jclass_tinyWRAPJNI = (jclass) jenv->NewGlobalRef(jcls);
  if (!Swig::jclass_tinyWRAPJNI) return;
  for (i = 0; i < (int) (sizeof(methods)/sizeof(methods[0])); ++i) {
    Swig::director_methids[i] = jenv->GetStaticMethodID(jcls, methods[i].method, methods[i].signature);
    if (!Swig::director_methids[i]) return;
  }
}


#ifdef __cplusplus
}
#endif

