/*
 * Decompiled with CFR 0.152.
 */
package com.expway.msp.rpc;

import com.expway.msp.ECacheControlDirective;
import com.expway.msp.EServiceType;
import com.expway.msp.IContentFile;
import com.expway.msp.IMsp3gppStreamingManager;
import com.expway.msp.IMspAcquisition;
import com.expway.msp.IMspEngine;
import com.expway.msp.IMspEsgManager;
import com.expway.msp.IMspFileCastingManager;
import com.expway.msp.IMspLiveManager;
import com.expway.msp.IMspStreamingManager;
import com.expway.msp.MspConnectionException;
import com.expway.msp.MspControl;
import com.expway.msp.MspException;
import com.expway.msp.MspInvalidConfigurationException;
import com.expway.msp.MspRegistrationParameters;
import com.expway.msp.MspServerErrorException;
import com.expway.msp.MspServiceErrorException;
import com.expway.msp.MspServiceWarningException;
import com.expway.msp.MspUserRegistrationMissingException;
import com.expway.msp.Schedule;
import com.expway.msp.ScheduleFile;
import com.expway.msp.ScheduleSession;
import com.expway.msp.Service;
import com.expway.msp.TimeRange;
import com.expway.msp.event.acquisition.AcquisitionErrorEvent;
import com.expway.msp.event.acquisition.AcquisitionEvent;
import com.expway.msp.event.acquisition.AcquisitionProgressEvent;
import com.expway.msp.event.acquisition.EAcquisitionErrorCause;
import com.expway.msp.event.acquisition.EAcquisitionEventType;
import com.expway.msp.event.acquisition.EMetadataEventType;
import com.expway.msp.event.acquisition.MetadataEvent;
import com.expway.msp.event.bootstrap.BootstrapEvent;
import com.expway.msp.event.bootstrap.BootstrapFailureEvent;
import com.expway.msp.event.bootstrap.EBootstrapEventType;
import com.expway.msp.event.bootstrap.EBootstrapFailureCause;
import com.expway.msp.event.connection.ConnectionEvent;
import com.expway.msp.event.connection.DisconnectionEvent;
import com.expway.msp.event.connection.EDisconnectionCause;
import com.expway.msp.event.connection.ProtocolErrorEvent;
import com.expway.msp.event.engine.EngineSoftwareUpdateEvent;
import com.expway.msp.event.modem.EModemEventType;
import com.expway.msp.event.modem.ModemEvent;
import com.expway.msp.event.modem.ModemTypeEvent;
import com.expway.msp.event.registration.ERegistrationEventType;
import com.expway.msp.event.registration.RegistrationErrorEvent;
import com.expway.msp.event.registration.RegistrationEvent;
import com.expway.msp.event.service.EFileCastingFailCause;
import com.expway.msp.event.service.EServiceFileCastEventType;
import com.expway.msp.event.service.EServiceLiveEventType;
import com.expway.msp.event.service.EServiceStreamingEventType;
import com.expway.msp.event.service.EServiceTransmissionMode;
import com.expway.msp.event.service.ESessionStopCause;
import com.expway.msp.event.service.Service3gppStreamingEvent;
import com.expway.msp.event.service.Service3gppStreamingOpenedEvent;
import com.expway.msp.event.service.ServiceAvailabilityChangeEvent;
import com.expway.msp.event.service.ServiceFileCastEvent;
import com.expway.msp.event.service.ServiceFileDownloadFailEvent;
import com.expway.msp.event.service.ServiceFileDownloadProgressEvent;
import com.expway.msp.event.service.ServiceFileDownloadStopEvent;
import com.expway.msp.event.service.ServiceLiveBadPresentationEvent;
import com.expway.msp.event.service.ServiceLiveCloseEvent;
import com.expway.msp.event.service.ServiceLiveEvent;
import com.expway.msp.event.service.ServiceLiveMpdReadyEvent;
import com.expway.msp.event.service.ServiceLiveServiceQualityIndicationEvent;
import com.expway.msp.event.service.ServiceLiveTransmissionModeEvent;
import com.expway.msp.event.service.ServiceStreamingEvent;
import com.expway.msp.event.service.ServiceStreamingOpenedEvent;
import com.expway.msp.event.signal.BLERInformation;
import com.expway.msp.event.signal.BSSIInformation;
import com.expway.msp.event.signal.CellInfoEvent;
import com.expway.msp.event.signal.ESignalCoverageState;
import com.expway.msp.event.signal.ESignalInformationType;
import com.expway.msp.event.signal.RSRPInformation;
import com.expway.msp.event.signal.RSRQInformation;
import com.expway.msp.event.signal.RSSIInformation;
import com.expway.msp.event.signal.SAIListEvent;
import com.expway.msp.event.signal.SNRInformation;
import com.expway.msp.event.signal.SignalCoverageEvent;
import com.expway.msp.event.signal.SignalInformation;
import com.expway.msp.event.signal.SignalInformationEvent;
import com.expway.msp.event.signal.SignalStrengthEvent;
import com.expway.msp.rpc.ContentFile;
import com.expway.msp.rpc.ERegistrationNeed;
import com.expway.msp.rpc.ERpcCallErrorType;
import com.expway.msp.rpc.IConnectionStatusNotify;
import com.expway.msp.rpc.IRpcDataTranslator;
import com.expway.msp.rpc.MspModule3gppStreamingManager;
import com.expway.msp.rpc.MspModuleAcquisition;
import com.expway.msp.rpc.MspModuleEngine;
import com.expway.msp.rpc.MspModuleEsgManager;
import com.expway.msp.rpc.MspModuleFileCastingManager;
import com.expway.msp.rpc.MspModuleLiveManager;
import com.expway.msp.rpc.MspModuleStreamingManager;
import com.expway.msp.rpc.RpcCallException;
import com.expway.msp.rpc.RpcHttpJson;
import com.expway.msp.rpc.RpcRemoteException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MspControlRpc
extends MspControl
implements IConnectionStatusNotify {
    private final RpcHttpJson msp_connection = new RpcHttpJson();
    private Exception reg_ex;
    private boolean reg_done;
    private final Object lock_registration = this.msp_connection;
    private static final int REGISTRATION_NONE = 0;
    private static final int REGISTRATION_IN_PROGRESS = 1;
    private static final int REGISTRATION_SUCCESS = 2;
    private static final int RTP_STREAMING_FLAG = 0;
    private static final int MISSION_CRITICAL_FLAG = 1;
    private int registration_state = 0;
    private boolean connected = false;
    private ERegistrationReason registration_reason = ERegistrationReason.FIRST_CONNECTION;
    public IImplicitRegistrationListener implicit_registration_listener;
    private int call_loop_count = 3;
    private URL request_url;
    private static final int MSP_RPC_PROTOCOL_VERSION_NUMBER = 20;
    private static final String MSP_RPC_PROTOCOL_VERSION_TYPE = "";
    private static final int EWMSP_EM_VERSION_MAJOR = 1;
    private static final int EWMSP_EM_VERSION_MINOR = 8;
    private static final int EWMSP_EM_VERSION_REVISION = 1;
    private static final String EWMSP_EM_VERSION_LETTER = "f";
    private static final String MSP_RPC_PROTOCOL_VERSION_STRING = "Expway:MSP:20:";
    private static final String EWMSP_EM_SOFTWARE_VERSION_STRING = "1.8.1f";
    private static boolean compatible_mode = false;
    private MspRegistrationParameters reg_parameters = null;
    protected volatile int poll_event_period = 500;
    protected volatile boolean poll_event_enabled = false;
    protected Object lock = new Object();
    private Thread th_event_notifier;
    private MspModuleEngine msp_module_engine = new MspModuleEngineRpc();
    private MspModuleLiveManager msp_module_live = new MspModuleLiveManagerRpc();
    private MspModuleFileCastingManager msp_module_file_cast = new MspModuleFileCastingManagerRpc();
    private MspModuleAcquisition msp_module_acquisition = new MspModuleAcquisitionRpc();
    private MspModuleEsgManager msp_module_esg_manager = new MspModuleEsgManagerRpc();
    private MspModuleStreamingManager msp_module_Streaming = new MspModuleStreamingManagerRPC();
    private MspModule3gppStreamingManager msp_module_3gppStreaming = new MspModule3gppStreamingManagerRpc();
    public static final String PROPERTY_EVENT_POLL_PERIOD = "com.expway.msp.rpc.event_poll_period";
    public static final String PROPERTY_SERVER_URL = "com.expway.msp.rpc.server_url";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setServer(URL url) {
        RpcHttpJson rpcHttpJson = this.msp_connection;
        synchronized (rpcHttpJson) {
            return this.msp_connection.setServer(url);
        }
    }

    private static long getLong(Object o) {
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        return (Long)o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitRegistrationResult() throws RpcCallException, RpcRemoteException {
        Exception ex;
        try {
            RpcHttpJson.internalMessage("LOCKREG [Registration wait...]");
            Object object = this.lock_registration;
            synchronized (object) {
                RpcHttpJson.internalMessage("REG-done = " + this.reg_done);
                if (!this.reg_done) {
                    this.lock_registration.wait();
                }
                ex = this.reg_ex;
                RpcHttpJson.internalMessage("REG-ex = " + this.reg_ex);
            }
            RpcHttpJson.internalMessage("UNLOCKREG [Registration wait...]");
        }
        catch (InterruptedException e) {
            ex = new InterruptedIOException(e.getMessage());
        }
        if (ex instanceof IOException) {
            throw new RpcCallException(ERpcCallErrorType.CONNECTION_ERROR, "Server connection error", ex);
        }
        if (ex instanceof RpcCallException) {
            throw (RpcCallException)ex;
        }
        if (ex instanceof RpcRemoteException) {
            throw (RpcRemoteException)ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRegistrationResult(Exception ex) {
        RpcHttpJson.internalMessage("LOCKREG [Registration result = " + ex + "]");
        Object object = this.lock_registration;
        synchronized (object) {
            this.reg_ex = ex;
            this.reg_done = true;
            this.registration_state = ex == null ? 2 : 0;
            this.lock_registration.notifyAll();
        }
        RpcHttpJson.internalMessage("UNLOCKREG [Registration result = " + ex + "]");
    }

    public String toString() {
        URL url = this.msp_connection.getServerUrl();
        return url == null ? "non-connected-client" : url.toString();
    }

    private void setDisconnected(URL server_url, EDisconnectionCause cause) {
        boolean now_connected;
        boolean bl = now_connected = cause == null;
        if (now_connected != this.connected) {
            this.connected = now_connected;
            if (cause == null) {
                this.msp_module_engine.fireMspConnectedEvent(new ConnectionEvent(this, server_url));
            } else {
                this.msp_module_engine.fireMspDisconnectedEvent(new DisconnectionEvent((Object)this, server_url, cause));
            }
        }
    }

    @Override
    public void connectionError(URL server_url) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        RpcHttpJson rpcHttpJson = this.msp_connection;
        synchronized (rpcHttpJson) {
            this.close(this.request_url, EDisconnectionCause.CONNECTION_CLOSED_BY_APPLICATION);
        }
    }

    private void close(URL origin_url, EDisconnectionCause cause) {
        this.registration_state = 0;
        this.msp_connection.closeConnection();
        this.setDisconnected(origin_url, cause);
    }

    private void registrationCall() {
        if (this.implicit_registration_listener != null) {
            this.implicit_registration_listener.registrationCallStarting(this.registration_reason == null ? ERegistrationReason.CONNECTION_LOST : this.registration_reason);
        }
        this.registration_reason = null;
    }

    private Object call(String op_name, String name, Object ... arguments) throws MspException {
        return this.call_internal(ERegistrationNeed.ACCEPTED, null, op_name, name, arguments);
    }

    private Object call(IRpcDataTranslator response_translator, String op_name, String name, Object ... arguments) throws MspException {
        return this.call_internal(ERegistrationNeed.ACCEPTED, response_translator, op_name, name, arguments);
    }

    private Object call(ERegistrationNeed registration_need, String op_name, String name, Object ... arguments) throws MspException {
        return this.call_internal(registration_need, null, op_name, name, arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object call_internal(ERegistrationNeed registration_need, IRpcDataTranslator response_translator, String op_name, String name, Object ... arguments) throws MspException {
        int loop_count = this.call_loop_count;
        String error_message = "Connection error";
        RpcHttpJson rpcHttpJson = this.msp_connection;
        synchronized (rpcHttpJson) {
            while (loop_count-- > 0) {
                RpcHttpJson.internalMessage("Call " + name + ", loop " + (this.call_loop_count - loop_count) + "/" + this.call_loop_count + "...");
                this.setPollEventEnabled(true);
                if (this.registration_state == 0) {
                    if (registration_need == ERegistrationNeed.NO_REGISTRATION) {
                        this.checkVersion();
                    } else {
                        this.registerCall();
                    }
                }
                if (op_name == null || name == null) {
                    return null;
                }
                try {
                    Object res = this.simpleCall(registration_need.waitRegistrationEnd(), response_translator, op_name, name, arguments);
                    return res;
                }
                catch (MspUserRegistrationMissingException ex) {
                    if (this.registration_reason == null) {
                        this.registration_reason = ERegistrationReason.CONNECTION_LOST;
                    }
                    error_message = ex.getMessage();
                    if (registration_need == ERegistrationNeed.OPTIONNAL) {
                        return null;
                    }
                    this.registration_state = 0;
                }
            }
        }
        throw new MspConnectionException(error_message, this.request_url);
    }

    private void registerCall() throws MspException {
        if (this.reg_parameters == null) {
            this.setPollEventEnabled(false);
            throw new MspUserRegistrationMissingException("User registration needed but no registration information provided", this.request_url);
        }
        this.registration_state = 1;
        URL asp_url = this.reg_parameters.getAspServerUrl();
        try {
            this.registrationCall();
            this.simpleCall(false, null, "User registration", "register_user", this.reg_parameters.getUserIdentifier(), this.reg_parameters.getPackageName(), this.reg_parameters.getSignatureHash(), asp_url == null ? null : asp_url.toString(), this.reg_parameters.getServiceClassTypes());
            if (this.registration_state == 0) {
                this.setPollEventEnabled(false);
                throw new MspConnectionException("Server connection problem", this.request_url);
            }
        }
        catch (MspException ex) {
            this.registration_state = 0;
            throw ex;
        }
    }

    public static void useCompatibleMode() {
        compatible_mode = true;
    }

    private void checkProtocolVersion(String version) throws MspException {
        System.out.println("Protocol version (client Expway:MSP:20: / server " + version + ")");
        if (!version.startsWith("Expway:MSP:")) {
            this.setPollEventEnabled(false);
            throw new MspServerErrorException("Invalid protocol: not an Expway eMBMS server", this.request_url);
        }
        if (!MSP_RPC_PROTOCOL_VERSION_STRING.equals(version)) {
            if (compatible_mode) {
                System.out.println("WARNING: Invalid protocol version");
            } else {
                this.setPollEventEnabled(false);
                System.err.println("ERROR: Invalid protocol version (client Expway:MSP:20: / server " + version + ")");
                throw new MspServerErrorException("Invalid protocol version (client Expway:MSP:20: / server " + version + ")", this.request_url);
            }
        }
    }

    private void checkSoftwareVersion(String version) throws MspException {
        System.out.println("Software version (client 1.8.1f / server " + version + ")");
        if (!EWMSP_EM_SOFTWARE_VERSION_STRING.equals(version)) {
            System.err.println("WARNING: Software version is not the same (client 1.8.1f / server " + version + ")");
        }
    }

    private void checkVersion() throws MspException {
        Object res = this.simpleCall(false, null, "Get version", "get_version", new Object[0]);
        if (compatible_mode && res instanceof String) {
            this.checkProtocolVersion((String)res);
        } else if (res instanceof Object[]) {
            Object[] fields;
            for (Object field : fields = (Object[])res) {
                Map m_field = (Map)field;
                String name = (String)m_field.get("name");
                Object[] parameters = (Object[])m_field.get("params");
                if (name.equals("protocol_version")) {
                    this.checkProtocolVersion((String)parameters[0]);
                    continue;
                }
                if (name.equals("software_version")) {
                    this.checkSoftwareVersion((String)parameters[0]);
                    continue;
                }
                if (!compatible_mode) {
                    this.setPollEventEnabled(false);
                    throw new MspServerErrorException("Invalid protocol: not an Expway eMBMS server", this.request_url);
                }
                System.out.println("WARNING: unknown version field name: " + name);
            }
        } else {
            this.setPollEventEnabled(false);
            System.err.println("ERROR: Invalid protocol: unrecognized version type");
            throw new MspServerErrorException("Invalid protocol: unrecognized version type", this.request_url);
        }
    }

    private static boolean isUserNeeded(int rpc_error_code) {
        return rpc_error_code == -20002 || rpc_error_code == -20003;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object simpleCall(boolean wait_registered_user, IRpcDataTranslator response_translator, String op_name, String name, Object ... arguments) throws MspException {
        URL origin_url = null;
        try {
            RpcHttpJson.internalMessage("Method " + name + ", wait_reg = " + wait_registered_user + "...");
            if (wait_registered_user) {
                this.waitRegistrationResult();
            }
            RpcHttpJson rpcHttpJson = this.msp_connection;
            synchronized (rpcHttpJson) {
                this.request_url = origin_url = this.msp_connection.getServerUrl();
                RpcHttpJson.internalMessage("Method-Call-Now " + name + "...");
                Object response = this.msp_connection.call(name, arguments);
                this.setDisconnected(origin_url, null);
                if (response_translator != null) {
                    response = response_translator.translate(response);
                }
                if (this.msp_connection.isClosed()) {
                    this.close(origin_url, EDisconnectionCause.CONNECTION_CLOSED_BY_SERVER);
                }
                return response;
            }
        }
        catch (RpcCallException e) {
            switch (e.getErrorType()) {
                case CONFIGURATION_ERROR: {
                    throw new MspInvalidConfigurationException(e.getMessage());
                }
                case CONNECTION_ERROR: {
                    this.close(origin_url, EDisconnectionCause.CONNECTION_CLOSED_BY_SERVER);
                    throw new MspConnectionException(e.getMessage(), origin_url);
                }
                case PROTOCOL_ERROR: {
                    this.close(origin_url, EDisconnectionCause.PROTOCOL_ERROR);
                    throw new MspServerErrorException(e.getMessage(), origin_url);
                }
            }
            throw new RuntimeException("RPC error");
        }
        catch (RpcRemoteException e) {
            int code = e.getErrorCode();
            if (MspControlRpc.isUserNeeded(code)) {
                throw new MspUserRegistrationMissingException(e.getMessage(), origin_url);
            }
            if (code >= 0) {
                throw new MspServiceWarningException(code, e.getMessage(), origin_url);
            }
            throw new MspServiceErrorException(code, e.getMessage(), origin_url);
        }
        catch (IOException e) {
            this.close(origin_url, EDisconnectionCause.PROTOCOL_ERROR);
            throw new MspServerErrorException("Invalid response", origin_url);
        }
        catch (ClassCastException e) {
            this.close(origin_url, EDisconnectionCause.PROTOCOL_ERROR);
            throw new MspServerErrorException("Invalid response", origin_url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MspRegistrationParameters unregisterServiceClassesInternal(String ... service_classes) throws MspException {
        RpcHttpJson.internalMessage("LOCK [unregister]");
        RpcHttpJson rpcHttpJson = this.msp_connection;
        synchronized (rpcHttpJson) {
            if (this.registration_state == 0) {
                if (this.reg_parameters == null) {
                    this.reg_parameters = null;
                    throw new MspUserRegistrationMissingException("Registration has not been achieved", this.request_url);
                }
                this.reg_parameters = this.unregister(this.reg_parameters, service_classes);
            } else {
                MspRegistrationParameters reg_params = this.reg_parameters;
                this.reg_parameters = this.unregister(this.reg_parameters, service_classes);
                try {
                    this.call(ERegistrationNeed.OPTIONNAL, "Unregister service-class", "unregister_service_classes", new Object[]{service_classes});
                }
                catch (MspException ex) {
                    this.reg_parameters = reg_params;
                    throw ex;
                }
            }
        }
        RpcHttpJson.internalMessage("UNLOCK [unregister]");
        return this.reg_parameters;
    }

    protected void notifyError(URL server_url, String type, String message) {
        ProtocolErrorEvent event = new ProtocolErrorEvent(this, server_url, type, message);
        System.out.println("  NOTIFY ERROR type=" + type + " message=" + message);
        this.msp_module_engine.fireMspProtocolErrorEvent(event);
    }

    protected static MspRegistrationParameters getApplicationIdentityForEvent(Object[] parameters) {
        String uid = (String)parameters[0];
        String app_package_name = (String)parameters[1];
        return new MspRegistrationParameters(uid, app_package_name, (String[])null);
    }

    protected void notifyEvent(URL server_url, String name, Object ... parameters) throws MalformedURLException, SocketException {
        if (name.equals("registration_started")) {
            RegistrationEvent event = new RegistrationEvent(this, server_url, ERegistrationEventType.START, MspControlRpc.getApplicationIdentityForEvent(parameters));
            System.out.println("  NOTIFY EVENT: " + name + " [ user_id: " + event.getApplicationIdentity().getUserIdentifier() + ", asp_server_url: " + event.getApplicationIdentity().getAspServerUrl() + ", app_package_name: " + event.getApplicationIdentity().getPackageName() + ", signature: " + event.getApplicationIdentity().getSignature() + ", service_class_types: " + event.getApplicationIdentity().getServiceClassTypes() + " ]");
            this.msp_module_engine.fireRegistrationStartedEvent(event);
        } else if (name.equals("registration_success")) {
            this.setRegistrationResult(null);
            this.setPollEventEnabled(true);
            RegistrationEvent event = new RegistrationEvent(this, server_url, ERegistrationEventType.SUCCESS, MspControlRpc.getApplicationIdentityForEvent(parameters));
            System.out.println("  NOTIFY EVENT: " + name + " [ user_id: " + event.getApplicationIdentity().getUserIdentifier() + ", asp_server_url: " + event.getApplicationIdentity().getAspServerUrl() + ", app_package_name: " + event.getApplicationIdentity().getPackageName() + ", signature: " + event.getApplicationIdentity().getSignature() + ", service_class_types: " + event.getApplicationIdentity().getServiceClassTypes() + " ]");
            this.msp_module_engine.fireRegistrationSucceedEvent(event);
        } else if (name.equals("registration_not_allowed")) {
            this.setPollEventEnabled(false);
            this.msp_connection.closeConnection();
            this.setRegistrationResult(new RpcRemoteException("Registration not allowed"));
            RegistrationEvent event = new RegistrationEvent(this, server_url, ERegistrationEventType.NOT_ALLOWED, MspControlRpc.getApplicationIdentityForEvent(parameters));
            System.out.println("  NOTIFY EVENT: " + name + " [ user_id: " + event.getApplicationIdentity().getUserIdentifier() + ", asp_server_url: " + event.getApplicationIdentity().getAspServerUrl() + ", app_package_name: " + event.getApplicationIdentity().getPackageName() + ", signature: " + event.getApplicationIdentity().getSignature() + ", service_class_types: " + event.getApplicationIdentity().getServiceClassTypes() + " ]");
            this.msp_module_engine.fireRegistrationNotAllowedEvent(event);
        } else if (name.equals("registration_error")) {
            int cause = (Integer)parameters[2];
            this.setPollEventEnabled(false);
            this.msp_connection.closeConnection();
            this.setRegistrationResult(new RpcRemoteException("Registration error"));
            RegistrationErrorEvent event = new RegistrationErrorEvent((Object)this, server_url, MspControlRpc.getApplicationIdentityForEvent(parameters), ERegistrationEventType.values()[cause]);
            System.out.println("  NOTIFY EVENT: " + name + "(cause: " + event.getCause().toString() + ", " + event.getCause().getMessage() + ") [ user_id: " + event.getApplicationIdentity().getUserIdentifier() + ", asp_server_url: " + event.getApplicationIdentity().getAspServerUrl() + ", app_package_name: " + event.getApplicationIdentity().getPackageName() + ", signature: " + event.getApplicationIdentity().getSignature() + ", service_class_types: " + event.getApplicationIdentity().getServiceClassTypes() + " ]");
            this.msp_module_engine.fireRegistrationErrorEvent(event);
        } else if (name.equals("software_update_available")) {
            String soft_package = (String)parameters[0];
            String soft_version = (String)parameters[1];
            EngineSoftwareUpdateEvent event = new EngineSoftwareUpdateEvent(this, server_url, soft_package, soft_version);
            System.out.println("  NOTIFY EVENT: " + name + " [ soft_package: " + event.getSoftwareName() + ", soft_version: " + event.getSoftwareVersion() + " ]");
            this.msp_module_engine.fireSoftwareUpdateEvent(event);
        } else if (name.equals("streaming_opened")) {
            String serviceid = (String)parameters[0];
            int flag = (Integer)parameters[1];
            String interface_name = (String)parameters[2];
            int interface_index = (Integer)parameters[3];
            String SDP = (String)parameters[4];
            NetworkInterface net_interface = null;
            try {
                if (interface_name != null) {
                    net_interface = NetworkInterface.getByName(interface_name);
                } else if (interface_index != 0) {
                    net_interface = NetworkInterface.getByIndex(interface_index);
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            if (flag == 1) {
                ServiceStreamingOpenedEvent event = new ServiceStreamingOpenedEvent(this, server_url, EServiceStreamingEventType.OPENED, serviceid, net_interface);
                System.out.println("  NOTIFY EVENT: " + name + "[ serviceID: " + event.getServiceId() + ", network_interface: " + event.getNetworkInterface().getName() + " ]");
                this.msp_module_Streaming.fireStreamingOpenedEvent(event);
            } else if (flag == 0) {
                Service3gppStreamingOpenedEvent event = new Service3gppStreamingOpenedEvent(this, server_url, EServiceStreamingEventType.OPENED, serviceid, net_interface, SDP);
                System.out.println("  NOTIFY EVENT: " + name + "[ serviceID: " + event.getServiceId() + " ]");
                this.msp_module_3gppStreaming.fireStreaming3gppServiceOpened(event);
            }
        } else if (name.equals("streaming_already_opened")) {
            String serviceid = (String)parameters[0];
            int flag = (Integer)parameters[1];
            String interface_name = (String)parameters[2];
            int interface_index = (Integer)parameters[3];
            String SDP = (String)parameters[4];
            NetworkInterface net_interface = null;
            try {
                if (interface_name != null) {
                    net_interface = NetworkInterface.getByName(interface_name);
                } else if (interface_index != 0) {
                    net_interface = NetworkInterface.getByIndex(interface_index);
                }
            }
            catch (SocketException event) {
                // empty catch block
            }
            if (flag == 1) {
                ServiceStreamingOpenedEvent event = new ServiceStreamingOpenedEvent(this, server_url, EServiceStreamingEventType.ALREADY_OPENED, serviceid, net_interface);
                System.out.println("  NOTIFY EVENT: " + name + "[ serviceID: " + event.getServiceId() + ", network_interface: " + event.getNetworkInterface().getName() + " ]");
                this.msp_module_Streaming.fireStreamingAlreadyOpenedEvent(event);
            } else if (flag == 0) {
                Service3gppStreamingOpenedEvent event = new Service3gppStreamingOpenedEvent(this, server_url, EServiceStreamingEventType.ALREADY_OPENED, serviceid, net_interface, SDP);
                System.out.println("  NOTIFY EVENT: " + name + "[ serviceID: " + event.getServiceId() + " ]");
                this.msp_module_3gppStreaming.fireStreaming3gppServiceAlreadyOpened(event);
            }
        } else {
            boolean b = name.equals("streaming_closed");
            if (b) {
                String serviceid = (String)parameters[0];
                int flag = (Integer)parameters[1];
                if (flag == 1) {
                    ServiceStreamingEvent event = new ServiceStreamingEvent(this, server_url, EServiceStreamingEventType.CLOSED, serviceid);
                    System.out.println("  NOTIFY EVENT: " + name + "[ serviceID: " + event.getServiceId() + " ]");
                    this.msp_module_Streaming.fireStreamingClosedEvent(event);
                } else if (flag == 0) {
                    Service3gppStreamingEvent event = new Service3gppStreamingEvent(this, server_url, EServiceStreamingEventType.CLOSED, serviceid);
                    System.out.println("  NOTIFY EVENT: " + name + "[ serviceID: " + event.getServiceId() + " ]");
                    this.msp_module_3gppStreaming.fireStreaming3gppServiceClosed(event);
                }
            } else if (name.equals("streaming_already_closed")) {
                String serviceid = (String)parameters[0];
                int flag = (Integer)parameters[1];
                if (flag == 1) {
                    ServiceStreamingEvent event = new ServiceStreamingEvent(this, server_url, EServiceStreamingEventType.ALREADY_CLOSED, serviceid);
                    System.out.println("  NOTIFY EVENT: " + name + "[ serviceID: " + event.getServiceId() + " ]");
                    this.msp_module_Streaming.fireStreamingAlreadyClosedEvent(event);
                } else if (flag == 0) {
                    Service3gppStreamingEvent event = new Service3gppStreamingEvent(this, server_url, EServiceStreamingEventType.ALREADY_CLOSED, serviceid);
                    System.out.println("  NOTIFY EVENT: " + name + "[ serviceID: " + event.getServiceId() + " ]");
                    this.msp_module_3gppStreaming.fireStreaming3gppServiceAlreadyClosed(event);
                }
            } else if (name.equals("service_availability")) {
                String service_id = (String)parameters[0];
                boolean b_available = (Integer)parameters[1] != 0;
                ServiceAvailabilityChangeEvent event = new ServiceAvailabilityChangeEvent(this, server_url, service_id, b_available);
                System.out.println("  NOTIFY EVENT: " + name + "[ service_id: " + event.getServiceId() + ", availability: " + (event.isAvailable() ? "available" : "unavailable") + " ]");
                this.msp_module_live.fireServiceAvailabilityChangeEvent(event);
                this.msp_module_file_cast.fireServiceAvailabilityChangeEvent(event);
            } else if (name.equals("live_opened")) {
                String service_id = (String)parameters[0];
                ServiceLiveEvent event = new ServiceLiveEvent(this, server_url, EServiceLiveEventType.OPEN, service_id);
                System.out.println("  NOTIFY EVENT: " + name + "[ service_id: " + event.getServiceId() + " ]");
                this.msp_module_live.fireLiveOpenedEvent(event);
            } else if (name.equals("live_closed")) {
                String service_id = (String)parameters[0];
                int cause = (Integer)parameters[1];
                ServiceLiveCloseEvent event = new ServiceLiveCloseEvent((Object)this, server_url, service_id, ESessionStopCause.values()[cause]);
                System.out.println("  NOTIFY EVENT: " + name + "(cause: " + event.getCause().toString() + ", " + event.getCause().getMessage() + ")[ service_id: " + event.getServiceId() + " ]");
                this.msp_module_live.fireLiveClosedEvent(event);
            } else if (name.equals("live_quality_indication")) {
                String service_id = (String)parameters[0];
                boolean b_success = (Integer)parameters[1] != 0;
                ServiceLiveServiceQualityIndicationEvent event = new ServiceLiveServiceQualityIndicationEvent((Object)this, server_url, service_id, b_success);
                System.out.println("  NOTIFY EVENT: " + name + "[ service_id: " + event.getServiceId() + ",quality_indication : " + (event.isSuccess() ? "success" : "failure") + " ]");
                this.msp_module_live.fireLiveServiceQualityIndicationEvent(event);
            } else if (name.equals("live_bad_presentation")) {
                String service_id = (String)parameters[0];
                boolean b_bad = (Integer)parameters[1] != 0;
                ServiceLiveBadPresentationEvent event = new ServiceLiveBadPresentationEvent((Object)this, server_url, service_id, b_bad);
                System.out.println("  NOTIFY EVENT: " + name + "[ service_id: " + event.getServiceId() + ", bad_presentation: " + (event.isBadPresentation() ? "true" : "false") + " ]");
                this.msp_module_live.fireLiveServiceBadPresentationEvent(event);
            } else if (name.equals("live_mpd_ready")) {
                String service_id = (String)parameters[0];
                URL url = new URL((String)parameters[1]);
                ServiceLiveMpdReadyEvent event = new ServiceLiveMpdReadyEvent((Object)this, server_url, service_id, url);
                System.out.println("  NOTIFY EVENT: " + name + "[ service_id: " + event.getServiceId() + ", mpd_url: " + event.getMpdUrl() + " ]");
                this.msp_module_live.fireLiveMpdReadyEvent(event);
            } else if (name.equals("live_transmission_mode")) {
                String service_id = (String)parameters[0];
                int mode = (Integer)parameters[1];
                ServiceLiveTransmissionModeEvent event = new ServiceLiveTransmissionModeEvent((Object)this, server_url, service_id, EServiceTransmissionMode.values()[mode]);
                System.out.println("  NOTIFY EVENT: " + name + "[ service_id: " + event.getServiceId() + ", mode: " + event.getMode().getMessage() + " ]");
                this.msp_module_live.fireLiveServiceTransmissionModeEvent(event);
            } else if (name.equals("file_download_started")) {
                String service_id = (String)parameters[0];
                String file_uri = (String)parameters[1];
                ServiceFileCastEvent event = new ServiceFileCastEvent(this, server_url, EServiceFileCastEventType.DOWNLOAD_START, service_id, file_uri);
                System.out.println("  NOTIFY EVENT: " + name + "[ service_id: " + event.getServiceId() + ", file_uri: " + event.getFileUri() + " ]");
                this.msp_module_file_cast.fireFileDownloadStartedEvent(event);
            } else if (name.equals("file_download_cancelled")) {
                String service_id = (String)parameters[0];
                String file_uri = (String)parameters[1];
                ServiceFileCastEvent event = new ServiceFileCastEvent(this, server_url, EServiceFileCastEventType.DOWNLOAD_CANCEL, service_id, file_uri);
                System.out.println("  NOTIFY EVENT: " + name + "[ service_id: " + event.getServiceId() + ", file_uri: " + event.getFileUri() + " ]");
                this.msp_module_file_cast.fireFileDownloadCancelledEvent(event);
            } else if (name.equals("file_download_failed")) {
                String service_id = (String)parameters[0];
                String file_uri = (String)parameters[1];
                int cause = (Integer)parameters[2];
                ServiceFileDownloadFailEvent event = new ServiceFileDownloadFailEvent((Object)this, server_url, service_id, file_uri, EFileCastingFailCause.values()[cause]);
                System.out.println("  NOTIFY EVENT: " + name + "(cause: " + event.getCause().toString() + ", " + event.getCause().getMessage() + ")[ service_id: " + event.getServiceId() + ", file_uri: " + event.getFileUri() + " ]");
                this.msp_module_file_cast.fireFileDownloadFailedEvent(event);
            } else if (name.equals("file_download_stopped")) {
                String service_id = (String)parameters[0];
                String file_uri = (String)parameters[1];
                int cause = (Integer)parameters[2];
                ServiceFileDownloadStopEvent event = new ServiceFileDownloadStopEvent((Object)this, server_url, service_id, file_uri, ESessionStopCause.values()[cause]);
                System.out.println("  NOTIFY EVENT: " + name + "(cause: " + event.getCause().toString() + ", " + event.getCause().getMessage() + ")[ service_id: " + event.getServiceId() + ", file_uri: " + event.getFileUri() + " ]");
                this.msp_module_file_cast.fireFileDownloadStoppedEvent(event);
            } else if (name.equals("file_download_progress")) {
                String service_id = (String)parameters[0];
                String file_uri = (String)parameters[1];
                long current_size = MspControlRpc.getLong(parameters[3]);
                long total_size = MspControlRpc.getLong(parameters[2]);
                ServiceFileDownloadProgressEvent event = new ServiceFileDownloadProgressEvent(this, server_url, service_id, file_uri, current_size, total_size);
                System.out.println("  NOTIFY EVENT: " + name + "[ service_id: " + event.getServiceId() + ", file_uri: " + event.getFileUri() + ", progress: " + event.getProgress() + "% ]");
                this.msp_module_file_cast.fireFileDownloadProgressEvent(event);
            } else if (name.equals("file_download_completed")) {
                String service_id = (String)parameters[0];
                String file_uri = (String)parameters[1];
                ServiceFileCastEvent event = new ServiceFileCastEvent(this, server_url, EServiceFileCastEventType.DOWNLOAD_COMPLETE, service_id, file_uri);
                System.out.println("  NOTIFY EVENT: " + name + "[ service_id: " + event.getServiceId() + ", file_uri: " + event.getFileUri() + " ]");
                this.msp_module_file_cast.fireFileDownloadCompletedEvent(event);
            } else if (name.equals("fec_decoding_started")) {
                String service_id = (String)parameters[0];
                String file_uri = (String)parameters[1];
                ServiceFileCastEvent event = new ServiceFileCastEvent(this, server_url, EServiceFileCastEventType.FEC_DECODING_START, service_id, file_uri);
                System.out.println("  NOTIFY EVENT: " + name + "[ service_id: " + event.getServiceId() + ", file_uri: " + event.getFileUri() + " ]");
                this.msp_module_file_cast.fireFileFecDecodingStartedEvent(event);
            } else if (name.equals("fec_decoding_ended")) {
                String service_id = (String)parameters[0];
                String file_uri = (String)parameters[1];
                ServiceFileCastEvent event = new ServiceFileCastEvent(this, server_url, EServiceFileCastEventType.FEC_DECODING_END, service_id, file_uri);
                System.out.println("  NOTIFY EVENT: " + name + "[ service_id: " + event.getServiceId() + ", file_uri: " + event.getFileUri() + " ]");
                this.msp_module_file_cast.fireFileFecDecodingEndedEvent(event);
            } else if (name.equals("file_repair_by_application")) {
                String service_id = (String)parameters[0];
                String file_uri = (String)parameters[1];
                ServiceFileCastEvent event = new ServiceFileCastEvent(this, server_url, EServiceFileCastEventType.FILE_REPAIR_BY_APPLICATION, service_id, file_uri);
                System.out.println("  NOTIFY EVENT: " + name + "[ service_id: " + event.getServiceId() + ", file_uri: " + event.getFileUri() + " ]");
                this.msp_module_file_cast.fireFileRepairByApplicationEvent(event);
            } else if (name.equals("file_repair_expected")) {
                String service_id = (String)parameters[0];
                String file_uri = (String)parameters[1];
                ServiceFileCastEvent event = new ServiceFileCastEvent(this, server_url, EServiceFileCastEventType.FILE_REPAIR_EXPECTED, service_id, file_uri);
                System.out.println("  NOTIFY EVENT: " + name + "[ service_id: " + event.getServiceId() + ", file_uri: " + event.getFileUri() + " ]");
                this.msp_module_file_cast.fireFileRepairExpectedEvent(event);
            } else if (name.equals("file_repair_started")) {
                String service_id = (String)parameters[0];
                String file_uri = (String)parameters[1];
                ServiceFileCastEvent event = new ServiceFileCastEvent(this, server_url, EServiceFileCastEventType.FILE_REPAIR_START, service_id, file_uri);
                System.out.println("  NOTIFY EVENT: " + name + "[ service_id: " + event.getServiceId() + ", file_uri: " + event.getFileUri() + " ]");
                this.msp_module_file_cast.fireFileRepairStartedEvent(event);
            } else if (name.equals("file_repair_cancelled")) {
                String service_id = (String)parameters[0];
                String file_uri = (String)parameters[1];
                ServiceFileCastEvent event = new ServiceFileCastEvent(this, server_url, EServiceFileCastEventType.FILE_REPAIR_CANCELLED, service_id, file_uri);
                System.out.println("  NOTIFY EVENT: " + name + "[ service_id: " + event.getServiceId() + ", file_uri: " + event.getFileUri() + " ]");
                this.msp_module_file_cast.fireFileRepairCancelledEvent(event);
            } else if (name.equals("acquisition_started")) {
                AcquisitionEvent event = new AcquisitionEvent(this, server_url, EAcquisitionEventType.STARTED);
                System.out.println("  NOTIFY EVENT: " + name);
                this.msp_module_acquisition.fireAcquisitionStartedEvent(event);
            } else if (name.equals("acquisition_ended")) {
                AcquisitionEvent event = new AcquisitionEvent(this, server_url, EAcquisitionEventType.ENDED);
                System.out.println("  NOTIFY EVENT: " + name);
                this.msp_module_acquisition.fireAcquisitionEndedEvent(event);
            } else if (name.equals("acquisition_progress")) {
                int progress = (Integer)parameters[0];
                AcquisitionProgressEvent event = new AcquisitionProgressEvent((Object)this, server_url, progress);
                System.out.println("  NOTIFY EVENT: " + name + "[ progress: " + event.getProgress() + " ]");
                this.msp_module_acquisition.fireAcquisitionProgressEvent(event);
            } else if (name.equals("acquisition_error")) {
                int cause = (Integer)parameters[0];
                AcquisitionErrorEvent event = new AcquisitionErrorEvent((Object)this, server_url, EAcquisitionErrorCause.values()[cause]);
                System.out.println("  NOTIFY EVENT: " + name + "(cause: " + event.getCause().toString() + ")");
                this.msp_module_acquisition.fireAcquisitionErrorEvent(event);
            } else if (name.equals("metadata_changed")) {
                MetadataEvent event = new MetadataEvent(this, server_url, EMetadataEventType.CHANGED);
                System.out.println("  NOTIFY EVENT: " + name);
                this.msp_module_acquisition.fireMetadataChangedEvent(event);
            } else if (name.equals("bootstrap_started")) {
                BootstrapEvent event = new BootstrapEvent(this, server_url, EBootstrapEventType.STARTED);
                System.out.println("  NOTIFY EVENT: " + name);
                this.msp_module_acquisition.fireBootstrapLoadStartedEvent(event);
            } else if (name.equals("bootstrap_success")) {
                BootstrapEvent event = new BootstrapEvent(this, server_url, EBootstrapEventType.SUCCESS);
                System.out.println("  NOTIFY EVENT: " + name);
                this.msp_module_acquisition.fireBootstrapLoadSuccessEvent(event);
            } else if (name.equals("bootstrap_failed")) {
                int cause = (Integer)parameters[0];
                BootstrapFailureEvent event = new BootstrapFailureEvent((Object)this, server_url, EBootstrapFailureCause.values()[cause]);
                System.out.println("  NOTIFY EVENT: " + name + "(cause: " + event.getCause().toString() + ", " + event.getCause().getMessage() + ")");
                this.msp_module_acquisition.fireBootstrapLoadFailedEvent(event);
            } else if (name.equals("signal_coverage")) {
                int coverage = (Integer)parameters[0];
                SignalCoverageEvent event = new SignalCoverageEvent((Object)this, server_url, ESignalCoverageState.values()[coverage]);
                System.out.println("  NOTIFY EVENT: " + name + "[ state: " + event.getState().toString() + " ]");
                this.msp_module_engine.fireSignalCoverageEvent(event);
            } else if (name.equals("signal_strength")) {
                int strength = (Integer)parameters[0];
                SignalStrengthEvent event = new SignalStrengthEvent((Object)this, server_url, strength);
                System.out.println("  NOTIFY EVENT: " + name + "[ power: " + event.getPower_dBm() + "dBm ]");
                this.msp_module_engine.fireSignalStrengthEvent(event);
            } else if (name.equals("signal_information")) {
                Object[] signals = parameters;
                SignalInformation[] signal_info = new SignalInformation[signals.length];
                StringBuilder signal_info_str = new StringBuilder(MSP_RPC_PROTOCOL_VERSION_TYPE);
                int i = 0;
                for (Object signal : signals) {
                    Map m_signal = (Map)signal;
                    ESignalInformationType type = ESignalInformationType.values()[(Integer)m_signal.get("type")];
                    if (i != 0) {
                        signal_info_str.append(", ");
                    }
                    switch (type) {
                        case BSSI: {
                            int value_int = (Integer)m_signal.get("value");
                            signal_info[i] = new BSSIInformation(value_int);
                            signal_info_str.append("BSSI =" + value_int + "dBm");
                            break;
                        }
                        case RSSI: {
                            int value_int = (Integer)m_signal.get("value");
                            signal_info[i] = new RSSIInformation(value_int);
                            signal_info_str.append("RSSI =" + value_int + "dBm");
                            break;
                        }
                        case SNR: {
                            int value_int = (Integer)m_signal.get("value");
                            signal_info[i] = new SNRInformation(value_int);
                            signal_info_str.append("SNR =" + value_int + "dB");
                            break;
                        }
                        case RSRP: {
                            int value_int = (Integer)m_signal.get("value");
                            signal_info[i] = new RSRPInformation(value_int);
                            signal_info_str.append("RSRP =" + value_int + "dBm");
                            break;
                        }
                        case RSRQ: {
                            int value_int = (Integer)m_signal.get("value");
                            signal_info[i] = new RSRQInformation(value_int);
                            signal_info_str.append("RSRQ =" + value_int + "dB");
                            break;
                        }
                        case BLER: {
                            double value_double = (Double)m_signal.get("value");
                            signal_info[i] = new BLERInformation(value_double);
                            signal_info_str.append("BLER =" + value_double + "%");
                            break;
                        }
                    }
                    ++i;
                }
                SignalInformationEvent event = new SignalInformationEvent((Object)this, server_url, signal_info);
                if (signal_info_str.length() > 0) {
                    System.out.println("  NOTIFY EVENT: " + name + "[ " + signal_info_str + " ]");
                } else {
                    System.out.println("  NOTIFY EVENT: " + name + "[ none ]");
                }
                this.msp_module_engine.fireSignalInformationEvent(event);
            } else if (name.equals("sai_update")) {
                Object[] sai_list = parameters;
                int[] sai_info = new int[sai_list.length];
                StringBuilder sai_info_str = new StringBuilder(MSP_RPC_PROTOCOL_VERSION_TYPE);
                int i = 0;
                for (Object sai : sai_list) {
                    if (i != 0) {
                        sai_info_str.append(", ");
                    }
                    sai_info[i] = (Integer)sai;
                    sai_info_str.append(MSP_RPC_PROTOCOL_VERSION_TYPE + sai + MSP_RPC_PROTOCOL_VERSION_TYPE);
                    ++i;
                }
                SAIListEvent event = new SAIListEvent((Object)this, server_url, sai_info);
                if (sai_info_str.length() > 0) {
                    System.out.println("  NOTIFY EVENT: " + name + "[ sai_list: " + sai_info_str + " ]");
                } else {
                    System.out.println("  NOTIFY EVENT: " + name + "[ sai_list: null ]");
                }
                this.msp_module_engine.fireSAIListEvent(event);
            } else if (name.equals("cell_info")) {
                Object cellInfo = parameters[0];
                Map m_cellInfo = (Map)cellInfo;
                CellInfoEvent event = new CellInfoEvent(this, server_url, (Integer)m_cellInfo.get("mcc"), (Integer)m_cellInfo.get("mnc"), (Integer)m_cellInfo.get("cellid"));
                System.out.println("  NOTIFY EVENT: " + name + "[ mcc: " + event.getMcc() + ", mnc: " + event.getMnc() + ", cellid: " + event.getCellId() + " ]");
                this.msp_module_engine.fireCellInfoEvent(event);
            } else if (name.equals("modem_disabled")) {
                ModemEvent event = new ModemEvent(this, server_url, EModemEventType.MODEM_DISABLED);
                System.out.println("  NOTIFY EVENT: " + name);
                this.msp_module_engine.fireModemDisabledEvent(event);
            } else if (name.equals("modem_enabled")) {
                ModemEvent event = new ModemEvent(this, server_url, EModemEventType.MODEM_ENABLED);
                System.out.println("  NOTIFY EVENT: " + name);
                this.msp_module_engine.fireModemEnabledEvent(event);
            } else if (name.equals("modem_no_device")) {
                ModemEvent event = new ModemEvent(this, server_url, EModemEventType.MODEM_NO_DEVICE);
                System.out.println("  NOTIFY EVENT: " + name);
                this.msp_module_engine.fireModemNoDeviceEvent(event);
            } else if (name.equals("modem_device_off")) {
                ModemEvent event = new ModemEvent(this, server_url, EModemEventType.MODEM_DEVICE_OFF);
                System.out.println("  NOTIFY EVENT: " + name);
                this.msp_module_engine.fireModemDeviceOffEvent(event);
            } else if (name.equals("modem_max_ue_reached")) {
                ModemEvent event = new ModemEvent(this, server_url, EModemEventType.MODEM_MAX_UE_REACHED);
                System.out.println("  NOTIFY EVENT: " + name);
                this.msp_module_engine.fireModemMaxUEReachedEvent(event);
            } else if (name.equals("modem_type")) {
                String modem_type = (String)parameters[0];
                ModemTypeEvent event = new ModemTypeEvent(this, server_url, modem_type);
                System.out.println("  NOTIFY EVENT: " + name + "[ type: " + event.getType() + " ]");
                this.msp_module_engine.fireModemTypeEvent(event);
            } else if (!compatible_mode) {
                this.notifyError(server_url, "server", "unknown event: " + name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPollEventEnabled(boolean enabled) {
        Object object = this.lock;
        synchronized (object) {
            this.poll_event_enabled = enabled;
            if (this.poll_event_enabled && this.poll_event_period > 0) {
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPollEventPeriod(int period_ms) {
        Object object = this.lock;
        synchronized (object) {
            this.poll_event_period = period_ms;
            if (this.poll_event_enabled && this.poll_event_period > 0) {
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pollEvents() {
        URL server_url = null;
        try {
            Object o;
            RpcHttpJson.internalMessage("LOCK [pollevent call]");
            RpcHttpJson rpcHttpJson = this.msp_connection;
            synchronized (rpcHttpJson) {
                server_url = this.msp_connection.getServerUrl();
                o = this.call(ERegistrationNeed.PROGRESSING, "Get events", "get_events", new Object[0]);
            }
            RpcHttpJson.internalMessage("UNLOCK [pollevent call]");
            try {
                Object[] events;
                for (Object event : events = (Object[])o) {
                    Map m_event = (Map)event;
                    String name = (String)m_event.get("name");
                    Object[] params = (Object[])m_event.get("params");
                    this.notifyEvent(server_url, name, params);
                }
            }
            catch (ClassCastException ex) {
                if (!compatible_mode) {
                    this.notifyError(server_url, "msp", "Invalid server response (bad value type)");
                }
            }
            catch (MalformedURLException ex) {
                if (!compatible_mode) {
                    this.notifyError(server_url, "msp", "Invalid server response (bad URL)");
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                if (!compatible_mode) {
                    this.notifyError(server_url, "msp", "Invalid server response (argument count)");
                }
            }
            catch (NullPointerException ex) {
                if (!compatible_mode) {
                    this.notifyError(server_url, "msp", "Invalid server response (null argument)");
                }
            }
            catch (SocketException e) {
                if (!compatible_mode) {
                    this.notifyError(server_url, "msp", "Socket exeption caught");
                }
            }
        }
        catch (MspConnectionException ex) {
            this.setDisconnected(server_url, EDisconnectionCause.CONNECTION_CLOSED_BY_SERVER);
        }
        catch (MspException ex) {
            this.notifyError(server_url, "msp", ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollEventsPeriodically() {
        try {
            while (true) {
                if (!this.poll_event_enabled || this.poll_event_period < 0) {
                    Object object = this.lock;
                    synchronized (object) {
                        if (!this.poll_event_enabled || this.poll_event_period < 0) {
                            this.lock.wait();
                        }
                    }
                }
                this.pollEvents();
                Thread.sleep(this.poll_event_period);
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    @Override
    public IMspEngine getEngineInterface() {
        return this.msp_module_engine;
    }

    @Override
    public IMspLiveManager getLiveManagerInterface() {
        return this.msp_module_live;
    }

    @Override
    public IMspFileCastingManager getFileCastingManagerInterface() {
        return this.msp_module_file_cast;
    }

    @Override
    public IMspAcquisition getAcquisitionInterface() {
        return this.msp_module_acquisition;
    }

    @Override
    public IMspEsgManager getEsgManagerInterface() {
        return this.msp_module_esg_manager;
    }

    @Override
    public IMspStreamingManager getStreamingManagerInterface() {
        return this.msp_module_Streaming;
    }

    @Override
    public IMsp3gppStreamingManager get3gppStreamingManagerInterface() {
        return this.msp_module_3gppStreaming;
    }

    public MspControlRpc() {
        this.msp_connection.setConnectionStatusNotify(this);
        String s = System.getProperty(PROPERTY_EVENT_POLL_PERIOD);
        if (s != null) {
            try {
                int period = Integer.parseInt(s);
                if (period > 0) {
                    this.setPollEventPeriod(period);
                }
            }
            catch (Exception period) {
                // empty catch block
            }
        }
        if ((s = System.getProperty(PROPERTY_SERVER_URL)) != null) {
            try {
                URL url = new URL(s);
                this.msp_connection.setServer(url);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.th_event_notifier = new Thread("EwMspEventPoll"){

            @Override
            public void run() {
                MspControlRpc.this.pollEventsPeriodically();
            }
        };
        this.th_event_notifier.setDaemon(true);
        this.th_event_notifier.start();
    }

    class MspModuleEsgManagerRpc
    extends MspModuleEsgManager
    implements IRpcDataTranslator {
        MspModuleEsgManagerRpc() {
        }

        @Override
        public Object translate(Object result) throws RpcCallException, IOException {
            if (!(result instanceof Object[])) {
                throw new RpcCallException(ERpcCallErrorType.PROTOCOL_ERROR, "Invalid response");
            }
            Object[] items = (Object[])result;
            Service[] services = new Service[items.length];
            for (int i = 0; i < items.length; ++i) {
                URI mpd_uri;
                Object item = items[i];
                Map map = (Map)item;
                String identifier = (String)map.get("id");
                if (identifier == null) {
                    throw new RpcCallException(ERpcCallErrorType.PROTOCOL_ERROR, "Invalid response");
                }
                String service_class = (String)map.get("service_class");
                EServiceType service_type = map.containsKey("service_type") ? EServiceType.values()[(Integer)map.get("service_type")] : EServiceType.SERVICE_TYPE_NONE;
                String s = (String)map.get("mpd_uri");
                try {
                    mpd_uri = s == null ? null : new URI(s.trim());
                }
                catch (URISyntaxException e) {
                    throw new RpcCallException(ERpcCallErrorType.PROTOCOL_ERROR, "Invalid response");
                }
                HashMap<String, String> map_names = new HashMap<String, String>();
                Map json_names = (Map)map.get("names");
                Set entries = json_names.entrySet();
                for (Map.Entry entry : entries) {
                    map_names.put(((String)entry.getKey()).toLowerCase(), (String)entry.getValue());
                }
                int[] sai_list = null;
                Object[] service_area_list = (Object[])map.get("service_area");
                StringBuilder sai_info_str = new StringBuilder(MspControlRpc.MSP_RPC_PROTOCOL_VERSION_TYPE);
                if (service_area_list != null) {
                    int j = 0;
                    sai_list = new int[service_area_list.length];
                    for (Object sai : service_area_list) {
                        if (j != 0) {
                            sai_info_str.append(", ");
                        }
                        sai_list[j] = (Integer)sai;
                        sai_info_str.append(MspControlRpc.MSP_RPC_PROTOCOL_VERSION_TYPE + sai + MspControlRpc.MSP_RPC_PROTOCOL_VERSION_TYPE);
                        ++j;
                    }
                }
                System.out.println("  SERVICE: [ID= " + identifier + "] [SAI:" + sai_info_str + "]");
                Object[] json_schedules = (Object[])map.get("schedules");
                Schedule[] schedules = new Schedule[json_schedules.length];
                for (int j = 0; j < schedules.length; ++j) {
                    Map json_schedule = (Map)json_schedules[j];
                    String type = (String)json_schedule.get("type");
                    Object[] json_times = (Object[])json_schedule.get("times");
                    TimeRange[] trs = new TimeRange[json_times.length];
                    for (int k = 0; k < trs.length; ++k) {
                        Object[] json_tr = (Object[])json_times[k];
                        long time_start = MspControlRpc.getLong(json_tr[0]);
                        long time_end = MspControlRpc.getLong(json_tr[1]);
                        trs[k] = new TimeRange(time_start, time_end);
                    }
                    try {
                        if (type.equalsIgnoreCase("file")) {
                            schedules[j] = new ScheduleFile(trs, new URI((String)json_schedule.get("file_uri")));
                            continue;
                        }
                        if (type.equalsIgnoreCase("session")) {
                            schedules[j] = new ScheduleSession(trs);
                            continue;
                        }
                        throw new RpcCallException(ERpcCallErrorType.PROTOCOL_ERROR, "Invalid response: invalid schedule type: " + type);
                    }
                    catch (URISyntaxException ex) {
                        throw new RpcCallException(ERpcCallErrorType.PROTOCOL_ERROR, "Invalid response: invalid file URI");
                    }
                }
                services[i] = new Service(identifier, map_names, service_class, mpd_uri, schedules, sai_list, service_type);
            }
            return services;
        }

        @Override
        public Service[] getServices() throws MspException {
            return (Service[])MspControlRpc.this.call(this, "Get services", "get_services", new Object[0]);
        }

        @Override
        public Service[] getServices(EServiceType type) throws MspException {
            Service[] services = (Service[])MspControlRpc.this.call(this, "Get services", "get_services", new Object[0]);
            ArrayList<Service> list = new ArrayList<Service>();
            for (int i = 0; i < services.length; ++i) {
                Service s = services[i];
                if (s.getType() != type) continue;
                list.add(s);
            }
            Service[] servicesSorted = new Service[list.size()];
            for (int j = 0; j < list.size(); ++j) {
                servicesSorted[j] = (Service)list.get(j);
            }
            return servicesSorted;
        }
    }

    class MspModuleAcquisitionRpc
    extends MspModuleAcquisition {
        MspModuleAcquisitionRpc() {
        }

        @Override
        public void acquisitionStart() throws MspException {
            MspControlRpc.this.call("Start acquisition", "acquisition_start", new Object[0]);
        }

        @Override
        public void acquisitionStop() throws MspException {
            MspControlRpc.this.call("Stop acquisition", "acquisition_stop", new Object[0]);
        }

        @Override
        public void acquisitionLoadBootstrap() throws MspException {
            MspControlRpc.this.call("Acquisition load bootstrap", "acquisition_load", new Object[0]);
        }
    }

    class MspModuleFileCastingManagerRpc
    extends MspModuleFileCastingManager
    implements IRpcDataTranslator {
        MspModuleFileCastingManagerRpc() {
        }

        @Override
        public Object translate(Object result) throws RpcCallException, IOException {
            if (!(result instanceof Object[])) {
                throw new RpcCallException(ERpcCallErrorType.PROTOCOL_ERROR, "Invalid response");
            }
            Object[] items = (Object[])result;
            Service[] services = new Service[items.length];
            for (int i = 0; i < items.length; ++i) {
                Object servitem = items[i];
                Map map = (Map)servitem;
                String service_id = (String)map.get("id");
                if (service_id == null) {
                    throw new RpcCallException(ERpcCallErrorType.PROTOCOL_ERROR, "Invalid response");
                }
                String service_class = (String)map.get("class");
                HashMap<String, String> map_names = new HashMap<String, String>();
                Map json_names = (Map)map.get("names");
                Set entries = json_names.entrySet();
                for (Map.Entry entry : entries) {
                    map_names.put(((String)entry.getKey()).toLowerCase(), (String)entry.getValue());
                }
                Object[] json_files = (Object[])map.get("files");
                IContentFile[] files = new IContentFile[json_files.length];
                for (int j = 0; j < files.length; ++j) {
                    ECacheControlDirective cache_control_directive;
                    URL file_url;
                    URI file_uri;
                    Object item = json_files[j];
                    Map fmap = (Map)item;
                    String sfile_uri = (String)fmap.get("uri");
                    if (sfile_uri == null) {
                        throw new RpcCallException(ERpcCallErrorType.PROTOCOL_ERROR, "Invalid response");
                    }
                    String sfile_url = (String)fmap.get("url");
                    Object vsize = fmap.get("size");
                    long file_size = 0L;
                    if (vsize != null) {
                        if (!(vsize instanceof Number)) {
                            throw new RpcCallException(ERpcCallErrorType.PROTOCOL_ERROR, "Invalid response");
                        }
                        file_size = ((Number)vsize).longValue();
                    }
                    try {
                        file_uri = new URI(sfile_uri.trim());
                    }
                    catch (URISyntaxException e) {
                        throw new RpcCallException(ERpcCallErrorType.PROTOCOL_ERROR, "Invalid response");
                    }
                    try {
                        file_url = sfile_url == null ? null : new URL(sfile_url.trim());
                    }
                    catch (MalformedURLException e) {
                        throw new RpcCallException(ERpcCallErrorType.PROTOCOL_ERROR, "Invalid response");
                    }
                    Object vccdirective = fmap.get("cache_control_directive");
                    if (vccdirective != null) {
                        if (!(vccdirective instanceof Number)) {
                            throw new RpcCallException(ERpcCallErrorType.PROTOCOL_ERROR, "Invalid response");
                        }
                        try {
                            cache_control_directive = ECacheControlDirective.values()[((Number)vccdirective).intValue()];
                        }
                        catch (ArrayIndexOutOfBoundsException aioobx) {
                            throw new RpcCallException(ERpcCallErrorType.PROTOCOL_ERROR, "Invalid response");
                        }
                    } else {
                        throw new RpcCallException(ERpcCallErrorType.PROTOCOL_ERROR, "Invalid response: missing cache control directive");
                    }
                    Object vccexpiration = fmap.get("cache_control_expiration");
                    long cache_control_expiration_ms = 0L;
                    if (vccexpiration != null) {
                        if (!(vccexpiration instanceof Number)) {
                            throw new RpcCallException(ERpcCallErrorType.PROTOCOL_ERROR, "Invalid response");
                        }
                        cache_control_expiration_ms = ((Number)vccexpiration).longValue() * 1000L;
                    }
                    files[j] = new ContentFile(file_uri, file_url, file_size, cache_control_directive, cache_control_expiration_ms);
                }
                services[i] = new Service(service_id, map_names, service_class, files, EServiceType.SERVICE_TYPE_FILE);
            }
            return services;
        }

        @Override
        public Service[] getDownloadedFiles(String service_id, URI file_uri) throws MspException {
            return (Service[])MspControlRpc.this.call(this, "Get downloaded files", "get_downloaded_files", new Object[]{service_id, file_uri == null ? null : file_uri.toString()});
        }

        @Override
        public void startDownload(String service_id, URI file_uri) throws MspException {
            MspControlRpc.this.call("Start download", "download_start", new Object[]{service_id, file_uri == null ? null : file_uri.toString()});
        }

        @Override
        public void cancelDownload(String service_id, URI file_uri) throws MspException {
            MspControlRpc.this.call("Cancel download", "download_cancel", new Object[]{service_id, file_uri == null ? null : file_uri.toString()});
        }

        @Override
        public void suspendDownload(String service_id, URI file_uri) throws MspException {
            MspControlRpc.this.call("Suspend download", "download_suspend", new Object[]{service_id, file_uri == null ? null : file_uri.toString()});
        }
    }

    class MspModule3gppStreamingManagerRpc
    extends MspModule3gppStreamingManager {
        MspModule3gppStreamingManagerRpc() {
        }

        @Override
        public void open3gppStreamingService(String serviceID) throws MspException {
            MspControlRpc.this.call("Open 3gpp streaming service", "streaming_open", new Object[]{serviceID, 0, null, null});
        }

        @Override
        public void close3gppStreamingService(String serviceID) throws MspException {
            MspControlRpc.this.call("Close 3gpp streaming service", "streaming_close", new Object[]{serviceID, 0});
        }
    }

    class MspModuleLiveManagerRpc
    extends MspModuleLiveManager {
        MspModuleLiveManagerRpc() {
        }

        @Override
        public void openLiveService(String service_id) throws MspException {
            MspControlRpc.this.call("Open live service", "live_open", new Object[]{service_id});
        }

        @Override
        public void closeLiveService(String service_id) throws MspException {
            MspControlRpc.this.call("Close live service", "live_close", new Object[]{service_id});
        }

        @Override
        public void startBufferingLiveService(String service_id) throws MspException {
            MspControlRpc.this.call("Start buffering live service", "live_buffer_start", new Object[]{service_id});
        }

        @Override
        public void stopBufferingLiveService(String service_id) throws MspException {
            MspControlRpc.this.call("Stop buffering live service", "live_buffer_stop", new Object[]{service_id});
        }
    }

    class MspModuleStreamingManagerRPC
    extends MspModuleStreamingManager {
        MspModuleStreamingManagerRPC() {
        }

        @Override
        public void openStreamingService(String serviceId, String SDP) throws MspException {
            MspControlRpc.this.call("Open streaming service", "streaming_open", new Object[]{serviceId, 1, SDP, null});
        }

        @Override
        public void openStreamingService(String serviceID, String SDP, String tmgi) throws MspException {
            MspControlRpc.this.call("Open streaming service", "streaming_open", new Object[]{serviceID, 1, SDP, tmgi});
        }

        @Override
        public void closeStreamingService(String serviceID) throws MspException {
            MspControlRpc.this.call("Close streaming service", "streaming_close", new Object[]{serviceID, 1});
        }
    }

    class MspModuleEngineRpc
    extends MspModuleEngine
    implements IMspEngine {
        MspModuleEngineRpc() {
        }

        @Override
        public void start() throws MspException {
            MspControlRpc.this.call("Start eMBMS", "start", new Object[0]);
        }

        @Override
        public void stop() throws MspException {
            MspControlRpc.this.call("Stop eMBMS", "stop", new Object[0]);
        }

        @Override
        protected boolean setServer(URL server) {
            return MspControlRpc.this.setServer(server);
        }

        @Override
        public void connect(URL server, MspRegistrationParameters app_id) throws MspException {
            this.setConnectionInformation(server, app_id);
            MspControlRpc.this.call(ERegistrationNeed.NO_REGISTRATION, null, null, new Object[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void disconnect() throws MspException {
            RpcHttpJson rpcHttpJson = MspControlRpc.this.msp_connection;
            synchronized (rpcHttpJson) {
                if (!MspControlRpc.this.msp_connection.isClosed()) {
                    MspControlRpc.this.setPollEventEnabled(false);
                    MspControlRpc.this.reg_parameters = null;
                    MspControlRpc.this.close(MspControlRpc.this.msp_connection.getServerUrl(), EDisconnectionCause.CONNECTION_CLOSED_BY_CLIENT);
                }
            }
        }

        @Override
        public MspRegistrationParameters unregisterServiceClasses(String[] service_classes) throws MspException {
            return MspControlRpc.this.unregisterServiceClassesInternal(service_classes);
        }

        @Override
        protected boolean setRegistrationInformation(MspRegistrationParameters reg_parameters) {
            if (reg_parameters != null) {
                if (reg_parameters.equals(MspControlRpc.this.reg_parameters)) {
                    return false;
                }
                MspControlRpc.this.reg_parameters = reg_parameters;
                MspControlRpc.this.registration_state = 0;
                if (MspControlRpc.this.registration_reason != ERegistrationReason.FIRST_CONNECTION) {
                    MspControlRpc.this.registration_reason = ERegistrationReason.PARAMETER_CHANGE;
                }
                return true;
            }
            return false;
        }

        @Override
        public void setEventPollingPeriod(int period_ms) {
            MspControlRpc.this.setPollEventPeriod(period_ms);
        }

        @Override
        public void setConnectionTimeout(int timeout_ms) {
            MspControlRpc.this.msp_connection.setConnectTimeout(timeout_ms);
        }

        @Override
        public void setResponseTimeout(int timeout_ms) {
            MspControlRpc.this.msp_connection.setReadTimeout(timeout_ms);
        }

        @Override
        public Date getTime() throws MspException {
            Long res = (Long)MspControlRpc.this.simpleCall(false, null, "Get synchronized time", "get_time", new Object[0]);
            return new Date(res);
        }
    }

    public static interface IImplicitRegistrationListener {
        public void registrationCallStarting(ERegistrationReason var1);
    }

    public static enum ERegistrationReason {
        FIRST_CONNECTION,
        CONNECTION_LOST,
        PARAMETER_CHANGE;

    }
}

