/*
 * Decompiled with CFR 0.152.
 */
package com.expway.msp.rpc;

import com.expway.msp.rpc.EwHttpClient;
import java.io.IOException;
import java.io.InputStream;

class ChunkedInputStream
extends InputStream {
    private InputStream in;
    private long chunk_size;
    private EwHttpClient client;
    private final char[] line_buffer = new char[32];
    private boolean chunk_started = false;

    ChunkedInputStream(EwHttpClient client, InputStream in) {
        this.client = client;
        this.in = in;
        this.chunk_size = 0L;
    }

    private long getChunkSize() throws IOException {
        try {
            if (this.chunk_size == 0L && this.in != null) {
                String line;
                if (this.chunk_started && (line = this.readLine()).length() > 0) {
                    throw new IOException("Invalid chunk transfer: new line expected");
                }
                line = this.readLine();
                this.chunk_started = true;
                this.chunk_size = Long.parseLong(line, 16);
                if (this.chunk_size < 0L) {
                    throw new IOException("Invalid chunk transfer: invalid chunk size");
                }
                if (this.chunk_size == 0L) {
                    this.in = null;
                    this.client.endOfResponse(true);
                }
            }
            return this.chunk_size;
        }
        catch (IOException ioex) {
            if (this.in != null) {
                this.in.close();
            }
            this.in = null;
            throw ioex;
        }
    }

    private String readLine() throws IOException {
        int i = 0;
        char[] buffer = this.line_buffer;
        while (true) {
            int n;
            if ((n = this.in.read()) < 0) {
                throw new IOException("HTTP response interrupted");
            }
            if (n == 13) {
                n = this.in.read();
                if (n < 0) {
                    throw new IOException("HTTP response interrupted");
                }
                if (n != 10) {
                    throw new IOException("Protocol error: invalid line separator");
                }
                return new String(buffer, 0, i);
            }
            if (n == 10) {
                throw new IOException("Protocol error: invalid line separator");
            }
            if (i >= buffer.length) {
                throw new IOException("Protocol error: line too long");
            }
            buffer[i++] = (char)n;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            long limit;
            block0: while ((limit = this.getChunkSize()) != 0L) {
                while (this.chunk_size > 0L) {
                    long r = this.in.skip(this.chunk_size);
                    if (r > 0L) {
                        this.chunk_size -= r;
                        continue;
                    }
                    this.in.close();
                    continue block0;
                }
            }
        }
    }

    @Override
    public int read() throws IOException {
        long limit = this.getChunkSize();
        if (limit == 0L) {
            return -1;
        }
        int r = this.in.read();
        if (r >= 0) {
            --this.chunk_size;
        } else {
            this.in.close();
            this.in = null;
            throw new IOException("Truncated chunk");
        }
        return r;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        long limit = this.getChunkSize();
        if ((long)len > limit) {
            len = (int)limit;
        }
        if (len == 0) {
            return 0;
        }
        if (this.in == null) {
            return -1;
        }
        int r = this.in.read(b, off, len);
        if (r >= 0) {
            this.chunk_size -= (long)r;
        } else {
            this.in.close();
            this.in = null;
            throw new IOException("Truncated chunk");
        }
        return r;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L || this.in == null) {
            return 0L;
        }
        long limit = this.getChunkSize();
        if (n > limit) {
            n = limit;
        }
        if (n == 0L) {
            return 0L;
        }
        long r = this.in.skip(n);
        if (r >= 0L) {
            this.chunk_size -= r;
        } else {
            this.in.close();
            this.in = null;
            throw new IOException("Truncated chunk");
        }
        return r;
    }
}

