/*
 * Decompiled with CFR 0.152.
 */
package com.expway.msp;

import com.expway.msp.EServiceType;
import com.expway.msp.IContentFile;
import com.expway.msp.Schedule;
import java.net.URI;
import java.util.Map;
import java.util.Set;

public class Service {
    final String identifier;
    final Map<String, String> map_names;
    final String service_class;
    final URI mpd_uri;
    final Schedule[] schedules;
    final IContentFile[] files;
    final int[] sai;
    private EServiceType type;

    public Service(String id, Map<String, String> names, String service_class, URI mpd_uri, Schedule[] schedules, int[] sai, EServiceType type) {
        this(id, names, service_class, mpd_uri, schedules, null, sai, type);
    }

    public Service(String id, Map<String, String> names, String service_class, IContentFile[] files, EServiceType type) {
        this(id, names, service_class, null, null, files, null, type);
    }

    private Service(String id, Map<String, String> names, String service_class, URI mpd_uri, Schedule[] schedules, IContentFile[] files, int[] sai, EServiceType type) {
        this.identifier = id;
        this.map_names = names;
        this.service_class = service_class;
        this.mpd_uri = mpd_uri;
        this.schedules = schedules;
        this.files = files;
        this.sai = sai;
        this.type = type;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getName(String lang_code) {
        return this.map_names.get(lang_code.toLowerCase());
    }

    public String[] getNameLanguageCodes() {
        Set<String> all_keys = this.map_names.keySet();
        return all_keys.toArray(new String[all_keys.size()]);
    }

    public String getServiceClass() {
        return this.service_class;
    }

    public URI getMpdUri() {
        return this.mpd_uri;
    }

    public EServiceType getType() {
        return this.type;
    }

    public Schedule[] getSchedules() {
        return this.schedules;
    }

    public IContentFile[] getFiles() {
        return this.files;
    }

    public int[] getSAI() {
        return this.sai;
    }
}

