/*
* Copyright (C) 2020, University of the Basque Country (UPV/EHU)
* Contact for licensing options: <licensing-mcpttclient(at)mcopenplatform(dot)com>
*
* The original file was part of Open Source Doubango Framework
* Copyright (C) 2010-2011 Mamadou Diop.
* Copyright (C) 2012 Doubango Telecom <http://doubango.org>
*
* This file is part of Open Source Doubango Framework.
*
* DOUBANGO is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* DOUBANGO is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with DOUBANGO.
*
*/

/**@file tsip_header.h
 * @brief List of all supported 3GPP/SIP headers.
 *
 * @author Mamadou Diop <diopmamadou(at)doubango[dot]org>
 *

 */
#ifndef TINYSIP_HEADERS_H
#define TINYSIP_HEADERS_H

#include "tinysip_config.h"

#include "tinysip/headers/tsip_header_Allow.h"
#include "tinysip/headers/tsip_header_Allow_Events.h"
#include "tinysip/headers/tsip_header_Authorization.h"
#include "tinysip/headers/tsip_header_Call_ID.h"
#include "tinysip/headers/tsip_header_Contact.h"
#include "tinysip/headers/tsip_header_CSeq.h"
#include "tinysip/headers/tsip_header_Date.h"
#include "tinysip/headers/tsip_header_Dummy.h"
#include "tinysip/headers/tsip_header_Event.h"
#include "tinysip/headers/tsip_header_Expires.h"
#include "tinysip/headers/tsip_header_From.h"
#include "tinysip/headers/tsip_header_Max_Forwards.h"
#include "tinysip/headers/tsip_header_Min_Expires.h"
#include "tinysip/headers/tsip_header_Min_SE.h"
#include "tinysip/headers/tsip_header_Path.h"
#include "tinysip/headers/tsip_header_P_Access_Network_Info.h" 
#include "tinysip/headers/tsip_header_P_Asserted_Identity.h"
#include "tinysip/headers/tsip_header_P_Associated_URI.h"
#include "tinysip/headers/tsip_header_P_Charging_Function_Addresses.h"
#include "tinysip/headers/tsip_header_P_Preferred_Identity.h"
#include "tinysip/headers/tsip_header_Privacy.h"
#include "tinysip/headers/tsip_header_Proxy_Authenticate.h"
#include "tinysip/headers/tsip_header_Proxy_Authorization.h"
#include "tinysip/headers/tsip_header_Proxy_Require.h"
#include "tinysip/headers/tsip_header_RAck.h"
#include "tinysip/headers/tsip_header_Record_Route.h"
#include "tinysip/headers/tsip_header_Refer_Sub.h"
#include "tinysip/headers/tsip_header_Refer_To.h"
#include "tinysip/headers/tsip_header_Referred_By.h"
#include "tinysip/headers/tsip_header_Require.h"
#include "tinysip/headers/tsip_header_Route.h"
#include "tinysip/headers/tsip_header_RSeq.h"
#include "tinysip/headers/tsip_header_Security_Client.h"
#include "tinysip/headers/tsip_header_Security_Server.h"
#include "tinysip/headers/tsip_header_Security_Verify.h"
#include "tinysip/headers/tsip_header_Server.h"
#include "tinysip/headers/tsip_header_Session_Expires.h"
#include "tinysip/headers/tsip_header_Service_Route.h"
#include "tinysip/headers/tsip_header_SIP_ETag.h"
#include "tinysip/headers/tsip_header_SIP_If_Match.h"
#include "tinysip/headers/tsip_header_Subscription_State.h"
#include "tinysip/headers/tsip_header_Supported.h"
#include "tinysip/headers/tsip_header_To.h"
#include "tinysip/headers/tsip_header_User_Agent.h"
#include "tinysip/headers/tsip_header_Via.h"
#include "tinysip/headers/tsip_header_Warning.h"
#include "tinysip/headers/tsip_header_WWW_Authenticate.h"

TSIP_BEGIN_DECLS

TSIP_END_DECLS


#endif /* TINYSIP_HEADERS_H */

