/*

*  Copyright (C) 2020, University of the Basque Country (UPV/EHU)
*
* Contact for licensing options: <licensing-mcpttclient(at)mcopenplatform(dot)com>
*
* This file is part of MCOP MCPTT Client
*
* This is free software: you can redistribute it and/or modify it under the terms of
* the GNU General Public License as published by the Free Software Foundation, either version 3
* of the License, or (at your option) any later version.
*
* This is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
* without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
* See the GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/


package org.doubango.ngn.datatype.affiliation.pidf;

import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.NamespaceList;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;

import java.util.ArrayList;
import java.util.List;



@NamespaceList({
        @Namespace(reference = "urn:3gpp:ns:mcpttPresInfo:1.0", prefix = "mcpttPI10" ), // Add your reference here!
        @Namespace(reference = "urn:ietf:params:xml:ns:pidf")
})
@Root(strict=false, name="presence")
@Order(elements = {"tuple", "p-id"})
public class Presence {
    @ElementList(name = "tuple", required=false, inline=true)
    protected List<Tuple> tuple;
    @ElementList(name = "note", required=false, inline=true)
    protected List<Note> note;
    @Attribute(name = "entity")
    protected String entity;
    @Element(required = false, name = "p-id")
    @Namespace(reference = "urn:3gpp:ns:mcpttPresInfo:1.0")
    protected String pId;


    public List<Tuple> getTuple() {
        if (tuple == null) {
            tuple = new ArrayList<Tuple>();
        }
        return this.tuple;
    }


    public List<Note> getNote() {
        if (note == null) {
            note = new ArrayList<Note>();
        }
        return this.note;
    }

    public void setNote(List<Note> note) {
        this.note = note;
    }


    public String getEntity() {
        return entity;
    }


    public void setEntity(String value) {
        this.entity = value;
    }


    public String getPId() {
        return pId;
    }

    public void setPId(String pId) {
        this.pId = pId;
    }

    public void setTuple(List<Tuple> tuple) {
        this.tuple = tuple;
    }
}
