/*
 * Decompiled with CFR 0.152.
 */
package com.expway.msp.rpc;

import com.expway.msp.ECacheControlDirective;
import com.expway.msp.IContentFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Date;

class ContentFile
implements IContentFile {
    private final URI uri;
    private final URL url;
    private final long size;
    private final ECacheControlDirective cache_control_directive;
    private final long cache_control_expiration_ms;

    ContentFile(URI uri, URL url, long size, ECacheControlDirective cache_control_directive, long cache_control_expiration) {
        this.uri = uri;
        this.url = url;
        this.size = size;
        this.cache_control_directive = cache_control_directive;
        this.cache_control_expiration_ms = cache_control_expiration;
    }

    @Override
    public URL getLocation() {
        return this.url;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public ECacheControlDirective getCacheControlDirective() {
        return this.cache_control_directive;
    }

    @Override
    public long getCacheControlExpiration() {
        return this.cache_control_expiration_ms;
    }

    @Override
    public Date getCacheControlExpirationDate() {
        return new Date(this.cache_control_expiration_ms);
    }

    @Override
    public InputStream open() throws IOException {
        if (this.url == null) {
            throw new FileNotFoundException(this.uri.toString());
        }
        return this.url.openStream();
    }
}

