/*
 * Decompiled with CFR 0.152.
 */
package com.expway.msp.rpc;

import com.expway.msp.rpc.ERpcCallErrorType;
import com.expway.msp.rpc.EwHttpClient;
import com.expway.msp.rpc.EwHttpResponse;
import com.expway.msp.rpc.IConnectionStatusNotify;
import com.expway.msp.rpc.RpcCallException;
import com.expway.msp.rpc.RpcRemoteException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RpcHttpJson {
    protected volatile URL url;
    protected IConnectionStatusNotify connection_notify = null;
    static int next_rid = 0;
    protected static final String JSON_RPC_VERSION = "2.0";
    protected static final int ID_NOTIFICATION = -1;
    public static final int NO_TIMEOUT = 0;
    protected int read_timeout = 0;
    protected int connect_timeout = 0;
    private boolean connection_closed = true;
    private final EwHttpClient ew_http_client = new EwHttpClient();
    private final EwHttpResponse ew_http_response = new EwHttpResponse();
    private static final String CONTENT_TYPE = "application/json-rpc";
    public static IDebugInternal debug_internal;

    public void setConnectionStatusNotify(IConnectionStatusNotify connection_notify) {
        this.connection_notify = connection_notify;
    }

    protected void closeConnection() {
        this.closeConnection(false);
    }

    private void closeConnection(boolean internal_close) {
        if (this.ew_http_client != null) {
            try {
                this.ew_http_client.close("Disconnect CallBack");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public URL getServerUrl() {
        return this.url;
    }

    public boolean setServer(URL url) {
        if (this.url == null || !this.url.equals(url)) {
            this.closeConnection(true);
            this.url = url;
            return true;
        }
        return false;
    }

    static int createRequestId() {
        return next_rid++;
    }

    protected static Object unmakeJson(Object value) throws RpcCallException, JSONException {
        if (value == null || value instanceof Map || value instanceof Object[] || value instanceof String || value instanceof Boolean || value instanceof Integer || value instanceof Long || value instanceof Double) {
            return value;
        }
        if (value instanceof JSONArray) {
            JSONArray a = (JSONArray)value;
            Object[] array = new Object[a.length()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = RpcHttpJson.unmakeJson(a.opt(i));
            }
            return array;
        }
        if (value instanceof JSONObject) {
            JSONObject o = (JSONObject)value;
            HashMap<String, Object> map = new HashMap<String, Object>();
            Iterator it = o.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                Object v = RpcHttpJson.unmakeJson(o.opt(key));
                map.put(key, v);
            }
            return map;
        }
        throw new RpcCallException(ERpcCallErrorType.PROTOCOL_ERROR, "Invalid reponse result type");
    }

    protected static Object makeJson(Object value) throws RpcCallException, JSONException {
        if (value == null || value instanceof JSONObject || value instanceof JSONArray || value instanceof String || value instanceof Boolean || value instanceof Integer || value instanceof Long || value instanceof Double) {
            return value;
        }
        if (value instanceof Byte) {
            return ((Byte)value).intValue();
        }
        if (value instanceof Character) {
            return ((Character)value).toString();
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            JSONObject o = new JSONObject();
            for (Map.Entry entry : map.entrySet()) {
                o.put(String.valueOf(entry.getKey()), RpcHttpJson.makeJson(entry.getValue()));
            }
            return o;
        }
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            JSONArray a = new JSONArray();
            for (Object o : array) {
                a.put(RpcHttpJson.makeJson(o));
            }
            return a;
        }
        if (value instanceof byte[]) {
            byte[] array = (byte[])value;
            JSONArray a = new JSONArray();
            for (byte o : array) {
                a.put(RpcHttpJson.makeJson(o));
            }
            return a;
        }
        throw new RpcCallException(ERpcCallErrorType.PROTOCOL_ERROR, "Invalid call argument type");
    }

    protected static String getCallRequestData(int id, String name, Object ... arguments) throws RpcCallException {
        try {
            JSONObject o = new JSONObject();
            o.put("jsonrpc", (Object)JSON_RPC_VERSION);
            o.put("method", (Object)name);
            o.put("params", RpcHttpJson.makeJson(arguments));
            if (id != -1) {
                o.put("id", id);
            }
            return o.toString();
        }
        catch (JSONException e) {
            throw new RpcCallException(ERpcCallErrorType.PROTOCOL_ERROR, "Invalid call arguments", (Exception)((Object)e));
        }
    }

    protected static Object getCallResponseData(int expected_id, String response, boolean error_only) throws RpcCallException, RpcRemoteException {
        try {
            JSONObject o = new JSONObject(response);
            String version = o.getString("jsonrpc");
            if (!version.equals(JSON_RPC_VERSION)) {
                throw new RpcCallException(ERpcCallErrorType.PROTOCOL_ERROR, "Invalid JSON version");
            }
            int id = o.getInt("id");
            if (id != expected_id) {
                throw new RpcCallException(ERpcCallErrorType.PROTOCOL_ERROR, "Invalid response identifier");
            }
            if (!o.isNull("error")) {
                JSONObject error = o.getJSONObject("error");
                int code = error.getInt("code");
                String m = error.getString("message");
                throw new RpcRemoteException(code, m);
            }
            if (error_only) {
                throw new RpcCallException(ERpcCallErrorType.PROTOCOL_ERROR, "Error expected");
            }
            if (o.isNull("result")) {
                return null;
            }
            return RpcHttpJson.unmakeJson(o.get("result"));
        }
        catch (JSONException e) {
            throw new RpcCallException(ERpcCallErrorType.PROTOCOL_ERROR, "Invalid server response data format", (Exception)((Object)e));
        }
    }

    public void setReadTimeout(int timeout_ms) {
        this.read_timeout = timeout_ms;
        if (this.ew_http_client != null) {
            this.ew_http_client.setReadTimeout(timeout_ms);
        }
    }

    public void setConnectTimeout(int timeout_ms) {
        this.connect_timeout = timeout_ms;
    }

    public boolean isClosed() {
        return this.ew_http_client == null ? this.connection_closed : !this.ew_http_client.isConnectionOpened();
    }

    protected String getResponseHeaderField(HttpURLConnection connection, String name) {
        String value = connection.getHeaderField(name);
        if (value == null) {
            Map<String, List<String>> mh = connection.getHeaderFields();
            List<String> list = mh.get(name);
            if (list == null) {
                for (Map.Entry<String, List<String>> entry : mh.entrySet()) {
                    String key = entry.getKey();
                    if (key != name && (name == null || !name.equals(key))) continue;
                    list = entry.getValue();
                    break;
                }
            }
            if (list != null) {
                StringBuilder sb = new StringBuilder();
                for (String s : list) {
                    if (s == null) continue;
                    if (sb.length() > 0) {
                        sb.append(' ');
                    }
                    sb.append(s);
                }
                value = sb.toString();
            }
        }
        return value;
    }

    protected HttpResponse sendHttp(boolean notification, String data, String content_type) throws RpcCallException, RpcRemoteException {
        return this.sendHttpClient(notification, data, content_type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponse sendHttpClient(boolean notification, String data, String content_type) throws RpcCallException, RpcRemoteException {
        HttpResponse httpResponse;
        if (this.url == null) {
            throw new RpcCallException(ERpcCallErrorType.CONFIGURATION_ERROR, "No server URL specified");
        }
        HashMap<String, String> request_headers = new HashMap<String, String>();
        request_headers.put("Accept", content_type);
        request_headers.put("Content-Type", content_type);
        byte[] post_data = data.getBytes();
        try {
            this.ew_http_client.open(this.url, post_data, request_headers);
            RpcHttpJson.internalMessage("SOCKET: " + this.ew_http_client.getSocketInfo());
        }
        catch (IOException e) {
            throw new RpcCallException(ERpcCallErrorType.CONNECTION_ERROR, "Communication error with MSP, cannot write data: " + e.getMessage(), e);
        }
        InputStream in = this.ew_http_client.readResponse(this.ew_http_response);
        int status = this.ew_http_response.code;
        if (!this.ew_http_response.isOk()) {
            throw new IOException("" + status + " " + this.ew_http_response.message);
        }
        try {
            int size;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((size = in.read(buffer)) > 0) {
                baos.write(buffer, 0, size);
            }
            data = new String(baos.toByteArray());
            HttpResponse http_response = new HttpResponse();
            int expected_status = notification ? 204 : 200;
            http_response.content = data;
            http_response.as_expected = status == expected_status;
            http_response.http_status = status;
            http_response.http_message = this.ew_http_response.message;
            httpResponse = http_response;
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RpcCallException(ERpcCallErrorType.CONNECTION_ERROR, "Server response error", e);
            }
        }
        in.close();
        return httpResponse;
    }

    static void internalMessage(String message) {
        if (debug_internal != null) {
            debug_internal.internalMessage(message);
        }
    }

    private static void internalJsonSend(String content) {
        if (debug_internal != null) {
            debug_internal.internalJsonSend(content);
        }
    }

    private static void internalJsonReceive(String content) {
        if (debug_internal != null) {
            debug_internal.internalJsonReceive(content);
        }
    }

    private Object call(boolean notification, String name, Object ... arguments) throws RpcCallException, RpcRemoteException {
        int id = notification ? -1 : RpcHttpJson.createRequestId();
        String data = RpcHttpJson.getCallRequestData(id, name, arguments);
        RpcHttpJson.internalJsonSend(data);
        HttpResponse response = this.sendHttp(notification, data, CONTENT_TYPE);
        RpcHttpJson.internalJsonReceive(response.content);
        try {
            return RpcHttpJson.getCallResponseData(id, response.content, !response.as_expected);
        }
        catch (RpcCallException ex) {
            if (ex.getErrorType() == ERpcCallErrorType.PROTOCOL_ERROR && !response.as_expected) {
                throw new RpcCallException(ERpcCallErrorType.CONNECTION_ERROR, "Request failed: " + response.getHttpMessage());
            }
            throw ex;
        }
    }

    public Object call(String name, Object ... arguments) throws RpcCallException, RpcRemoteException {
        return this.call(false, name, arguments);
    }

    public void notify(String name, Object ... arguments) throws RpcCallException, RpcRemoteException {
        this.call(true, name, arguments);
    }

    public static interface IDebugInternal {
        public void internalMessage(String var1);

        public void internalJsonSend(String var1);

        public void internalJsonReceive(String var1);
    }

    static class HttpResponse {
        String content;
        boolean as_expected;
        int http_status;
        String http_message;

        HttpResponse() {
        }

        public String getHttpMessage() {
            return "HTTP " + this.http_status + " " + this.http_message + "\n" + this.content;
        }
    }
}

