/*
 * Decompiled with CFR 0.152.
 */
package com.expway.msp.rpc;

import com.expway.msp.IMspFileCastingManager;
import com.expway.msp.MspException;
import com.expway.msp.event.service.IServiceFileCastingListener;
import com.expway.msp.event.service.ServiceAvailabilityChangeEvent;
import com.expway.msp.event.service.ServiceEvent;
import com.expway.msp.event.service.ServiceFileCastEvent;
import com.expway.msp.event.service.ServiceFileDownloadFailEvent;
import com.expway.msp.event.service.ServiceFileDownloadProgressEvent;
import com.expway.msp.event.service.ServiceFileDownloadStopEvent;
import com.expway.msp.rpc.MspAbstractModule;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;

abstract class MspModuleFileCastingManager
extends MspAbstractModule
implements IMspFileCastingManager {
    private ArrayList<IServiceFileCastingListener> all_service_filecast_listeners = new ArrayList();
    protected HashMap<String, UseCount> hm_services = new HashMap();

    MspModuleFileCastingManager() {
    }

    void fireServiceAvailabilityChangeEvent(ServiceAvailabilityChangeEvent event) {
        if (this.hm_services.containsKey(event.getServiceId())) {
            this.fireFileServiceAvailabilityChangeEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServiceFileCastingListener(IServiceFileCastingListener listener) {
        ArrayList<IServiceFileCastingListener> arrayList = this.all_service_filecast_listeners;
        synchronized (arrayList) {
            this.all_service_filecast_listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServiceFileCastingListener(IServiceFileCastingListener listener) {
        ArrayList<IServiceFileCastingListener> arrayList = this.all_service_filecast_listeners;
        synchronized (arrayList) {
            this.all_service_filecast_listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceUse(ServiceEvent event) {
        String k = event.getServiceId();
        HashMap<String, UseCount> hashMap = this.hm_services;
        synchronized (hashMap) {
            UseCount c = this.hm_services.get(k);
            if (c == null) {
                c = new UseCount();
                this.hm_services.put(k, c);
            }
            ++c.use_count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceUnuse(ServiceEvent event) {
        String k = event.getServiceId();
        HashMap<String, UseCount> hashMap = this.hm_services;
        synchronized (hashMap) {
            UseCount c = this.hm_services.get(k);
            if (c != null) {
                --c.use_count;
                if (c.use_count == 0) {
                    this.hm_services.remove(k);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireFileDownloadStartedEvent(ServiceFileCastEvent event) {
        this.serviceUse(event);
        ArrayList<IServiceFileCastingListener> arrayList = this.all_service_filecast_listeners;
        synchronized (arrayList) {
            for (IServiceFileCastingListener l : this.all_service_filecast_listeners) {
                try {
                    l.fileDownloadStart(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireFileDownloadCancelledEvent(ServiceFileCastEvent event) {
        ArrayList<IServiceFileCastingListener> arrayList = this.all_service_filecast_listeners;
        synchronized (arrayList) {
            for (IServiceFileCastingListener l : this.all_service_filecast_listeners) {
                try {
                    l.fileDownloadCancelled(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireFileDownloadProgressEvent(ServiceFileDownloadProgressEvent event) {
        ArrayList<IServiceFileCastingListener> arrayList = this.all_service_filecast_listeners;
        synchronized (arrayList) {
            for (IServiceFileCastingListener l : this.all_service_filecast_listeners) {
                try {
                    l.fileDownloadProgress(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireFileDownloadFailedEvent(ServiceFileDownloadFailEvent event) {
        ArrayList<IServiceFileCastingListener> arrayList = this.all_service_filecast_listeners;
        synchronized (arrayList) {
            for (IServiceFileCastingListener l : this.all_service_filecast_listeners) {
                try {
                    l.fileDownloadFailed(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireFileDownloadStoppedEvent(ServiceFileDownloadStopEvent event) {
        ArrayList<IServiceFileCastingListener> arrayList = this.all_service_filecast_listeners;
        synchronized (arrayList) {
            for (IServiceFileCastingListener l : this.all_service_filecast_listeners) {
                try {
                    l.fileDownloadStopped(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireFileDownloadCompletedEvent(ServiceFileCastEvent event) {
        this.serviceUnuse(event);
        ArrayList<IServiceFileCastingListener> arrayList = this.all_service_filecast_listeners;
        synchronized (arrayList) {
            for (IServiceFileCastingListener l : this.all_service_filecast_listeners) {
                try {
                    l.fileDownloadCompleted(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireFileFecDecodingStartedEvent(ServiceFileCastEvent event) {
        ArrayList<IServiceFileCastingListener> arrayList = this.all_service_filecast_listeners;
        synchronized (arrayList) {
            for (IServiceFileCastingListener l : this.all_service_filecast_listeners) {
                try {
                    l.fecDecodingStarted(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireFileFecDecodingEndedEvent(ServiceFileCastEvent event) {
        ArrayList<IServiceFileCastingListener> arrayList = this.all_service_filecast_listeners;
        synchronized (arrayList) {
            for (IServiceFileCastingListener l : this.all_service_filecast_listeners) {
                try {
                    l.fecDecodingEnded(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireFileRepairByApplicationEvent(ServiceFileCastEvent event) {
        ArrayList<IServiceFileCastingListener> arrayList = this.all_service_filecast_listeners;
        synchronized (arrayList) {
            for (IServiceFileCastingListener l : this.all_service_filecast_listeners) {
                try {
                    l.fileRepairByApplication(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireFileRepairExpectedEvent(ServiceFileCastEvent event) {
        ArrayList<IServiceFileCastingListener> arrayList = this.all_service_filecast_listeners;
        synchronized (arrayList) {
            for (IServiceFileCastingListener l : this.all_service_filecast_listeners) {
                try {
                    l.fileRepairExpected(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireFileRepairCancelledEvent(ServiceFileCastEvent event) {
        ArrayList<IServiceFileCastingListener> arrayList = this.all_service_filecast_listeners;
        synchronized (arrayList) {
            for (IServiceFileCastingListener l : this.all_service_filecast_listeners) {
                try {
                    l.fileRepairCancelled(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireFileRepairStartedEvent(ServiceFileCastEvent event) {
        ArrayList<IServiceFileCastingListener> arrayList = this.all_service_filecast_listeners;
        synchronized (arrayList) {
            for (IServiceFileCastingListener l : this.all_service_filecast_listeners) {
                try {
                    l.fileRepairStarted(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireFileServiceAvailabilityChangeEvent(ServiceAvailabilityChangeEvent event) {
        ArrayList<IServiceFileCastingListener> arrayList = this.all_service_filecast_listeners;
        synchronized (arrayList) {
            for (IServiceFileCastingListener l : this.all_service_filecast_listeners) {
                try {
                    l.serviceAvailabilityChanged(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    @Override
    public abstract void startDownload(String var1, URI var2) throws MspException;

    @Override
    public abstract void cancelDownload(String var1, URI var2) throws MspException;

    @Override
    public abstract void suspendDownload(String var1, URI var2) throws MspException;

    static class UseCount {
        int use_count = 0;

        UseCount() {
        }
    }
}

