/*
 * Decompiled with CFR 0.152.
 */
package com.expway.msp.rpc;

import com.expway.msp.IMspLiveManager;
import com.expway.msp.MspException;
import com.expway.msp.event.service.IServiceLiveListener;
import com.expway.msp.event.service.ServiceAvailabilityChangeEvent;
import com.expway.msp.event.service.ServiceLiveBadPresentationEvent;
import com.expway.msp.event.service.ServiceLiveCloseEvent;
import com.expway.msp.event.service.ServiceLiveEvent;
import com.expway.msp.event.service.ServiceLiveMpdReadyEvent;
import com.expway.msp.event.service.ServiceLiveServiceQualityIndicationEvent;
import com.expway.msp.event.service.ServiceLiveTransmissionModeEvent;
import com.expway.msp.rpc.MspAbstractModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

abstract class MspModuleLiveManager
extends MspAbstractModule
implements IMspLiveManager {
    private ArrayList<IServiceLiveListener> all_service_live_listeners = new ArrayList();
    private Set<String> hs_services = Collections.synchronizedSet(new HashSet());

    MspModuleLiveManager() {
    }

    void fireServiceAvailabilityChangeEvent(ServiceAvailabilityChangeEvent event) {
        if (this.hs_services.contains(event.getServiceId())) {
            this.fireLiveServiceAvailabilityChangeEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServiceLiveListener(IServiceLiveListener listener) {
        ArrayList<IServiceLiveListener> arrayList = this.all_service_live_listeners;
        synchronized (arrayList) {
            if (!this.all_service_live_listeners.contains(listener)) {
                this.all_service_live_listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServiceLiveListener(IServiceLiveListener listener) {
        ArrayList<IServiceLiveListener> arrayList = this.all_service_live_listeners;
        synchronized (arrayList) {
            this.all_service_live_listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireLiveOpenedEvent(ServiceLiveEvent event) {
        this.hs_services.add(event.getServiceId());
        ArrayList<IServiceLiveListener> arrayList = this.all_service_live_listeners;
        synchronized (arrayList) {
            for (IServiceLiveListener l : this.all_service_live_listeners) {
                try {
                    l.liveOpened(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireLiveClosedEvent(ServiceLiveCloseEvent event) {
        this.hs_services.remove(event.getServiceId());
        ArrayList<IServiceLiveListener> arrayList = this.all_service_live_listeners;
        synchronized (arrayList) {
            for (IServiceLiveListener l : this.all_service_live_listeners) {
                try {
                    l.liveClosed(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireLiveMpdReadyEvent(ServiceLiveMpdReadyEvent event) {
        ArrayList<IServiceLiveListener> arrayList = this.all_service_live_listeners;
        synchronized (arrayList) {
            for (IServiceLiveListener l : this.all_service_live_listeners) {
                try {
                    l.liveMpdReady(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireLiveServiceQualityIndicationEvent(ServiceLiveServiceQualityIndicationEvent event) {
        ArrayList<IServiceLiveListener> arrayList = this.all_service_live_listeners;
        synchronized (arrayList) {
            for (IServiceLiveListener l : this.all_service_live_listeners) {
                try {
                    l.liveServiceQualityIndication(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireLiveServiceBadPresentationEvent(ServiceLiveBadPresentationEvent event) {
        ArrayList<IServiceLiveListener> arrayList = this.all_service_live_listeners;
        synchronized (arrayList) {
            for (IServiceLiveListener l : this.all_service_live_listeners) {
                try {
                    l.liveServiceBadPresentation(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireLiveServiceTransmissionModeEvent(ServiceLiveTransmissionModeEvent event) {
        ArrayList<IServiceLiveListener> arrayList = this.all_service_live_listeners;
        synchronized (arrayList) {
            for (IServiceLiveListener l : this.all_service_live_listeners) {
                try {
                    l.liveTransmissionMode(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireLiveServiceAvailabilityChangeEvent(ServiceAvailabilityChangeEvent event) {
        ArrayList<IServiceLiveListener> arrayList = this.all_service_live_listeners;
        synchronized (arrayList) {
            for (IServiceLiveListener l : this.all_service_live_listeners) {
                try {
                    l.serviceAvailabilityChanged(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    @Override
    public abstract void openLiveService(String var1) throws MspException;

    @Override
    public abstract void closeLiveService(String var1) throws MspException;

    @Override
    public abstract void startBufferingLiveService(String var1) throws MspException;

    @Override
    public abstract void stopBufferingLiveService(String var1) throws MspException;
}

