/*
 * Decompiled with CFR 0.152.
 */
package com.expway.msp;

import com.expway.msp.TimeRange;

public abstract class Schedule {
    private final TimeRange[] time_ranges;
    private final TimeRange global_time_range;

    public Schedule(TimeRange[] times) {
        TimeRange gtr;
        this.time_ranges = times;
        if (times.length == 0) {
            gtr = null;
        } else {
            long time_start = 0L;
            long time_end = -1L;
            for (TimeRange tr : times) {
                if (tr.isEmpty()) continue;
                long t = tr.getTimeStartMs();
                if (time_start == 0L || t < time_start) {
                    time_start = t;
                }
                if ((t = tr.getTimeEndMs()) <= time_end) continue;
                time_end = t;
            }
            gtr = time_end > time_start ? new TimeRange(time_start, time_end) : null;
        }
        this.global_time_range = gtr;
    }

    public int getTimeRangeCount() {
        return this.time_ranges.length;
    }

    public TimeRange getTimeRange(int index) {
        return this.time_ranges[index];
    }

    public TimeRange getGlobalTimeRange() {
        return this.global_time_range;
    }
}

