/*
 * Decompiled with CFR 0.152.
 */
package com.expway.msp.rpc;

import com.expway.msp.IMspEngine;
import com.expway.msp.MspException;
import com.expway.msp.MspRegistrationParameters;
import com.expway.msp.event.connection.ConnectionEvent;
import com.expway.msp.event.connection.DisconnectionEvent;
import com.expway.msp.event.connection.IMspConnectionListener;
import com.expway.msp.event.connection.ProtocolErrorEvent;
import com.expway.msp.event.engine.EngineSoftwareUpdateEvent;
import com.expway.msp.event.engine.IEngineListener;
import com.expway.msp.event.modem.IModemListener;
import com.expway.msp.event.modem.ModemEvent;
import com.expway.msp.event.modem.ModemTypeEvent;
import com.expway.msp.event.registration.IRegistrationListener;
import com.expway.msp.event.registration.RegistrationErrorEvent;
import com.expway.msp.event.registration.RegistrationEvent;
import com.expway.msp.event.signal.CellInfoEvent;
import com.expway.msp.event.signal.ISignalListener;
import com.expway.msp.event.signal.SAIListEvent;
import com.expway.msp.event.signal.SignalCoverageEvent;
import com.expway.msp.event.signal.SignalInformationEvent;
import com.expway.msp.event.signal.SignalStrengthEvent;
import com.expway.msp.rpc.MspAbstractModule;
import java.net.URL;
import java.util.ArrayList;

abstract class MspModuleEngine
extends MspAbstractModule
implements IMspEngine {
    private ArrayList<IMspConnectionListener> all_connection_listeners = new ArrayList();
    private ArrayList<IRegistrationListener> all_registration_listeners = new ArrayList();
    private ArrayList<IEngineListener> all_engine_listeners = new ArrayList();
    private ArrayList<ISignalListener> all_signal_listeners = new ArrayList();
    private ArrayList<IModemListener> all_modem_listeners = new ArrayList();

    MspModuleEngine() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnectionListener(IMspConnectionListener listener) {
        ArrayList<IMspConnectionListener> arrayList = this.all_connection_listeners;
        synchronized (arrayList) {
            this.all_connection_listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnectionListener(IMspConnectionListener listener) {
        ArrayList<IMspConnectionListener> arrayList = this.all_connection_listeners;
        synchronized (arrayList) {
            this.all_connection_listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireMspConnectedEvent(ConnectionEvent event) {
        ArrayList<IMspConnectionListener> arrayList = this.all_connection_listeners;
        synchronized (arrayList) {
            for (IMspConnectionListener l : this.all_connection_listeners) {
                try {
                    l.connected(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireMspDisconnectedEvent(DisconnectionEvent event) {
        ArrayList<IMspConnectionListener> arrayList = this.all_connection_listeners;
        synchronized (arrayList) {
            for (IMspConnectionListener l : this.all_connection_listeners) {
                try {
                    l.disconnected(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireMspProtocolErrorEvent(ProtocolErrorEvent event) {
        ArrayList<IMspConnectionListener> arrayList = this.all_connection_listeners;
        synchronized (arrayList) {
            for (IMspConnectionListener l : this.all_connection_listeners) {
                try {
                    l.protocolError(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    protected boolean setConnectionInformation(URL server, MspRegistrationParameters app_id) throws MspException {
        boolean changed = false;
        if (server != null) {
            changed = this.setServer(server);
        }
        if (this.setRegistrationInformation(app_id)) {
            changed = true;
        }
        return changed;
    }

    protected abstract boolean setServer(URL var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRegistrationListener(IRegistrationListener listener) {
        ArrayList<IRegistrationListener> arrayList = this.all_registration_listeners;
        synchronized (arrayList) {
            this.all_registration_listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRegistrationListener(IRegistrationListener listener) {
        ArrayList<IRegistrationListener> arrayList = this.all_registration_listeners;
        synchronized (arrayList) {
            this.all_registration_listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireRegistrationStartedEvent(RegistrationEvent event) {
        ArrayList<IRegistrationListener> arrayList = this.all_registration_listeners;
        synchronized (arrayList) {
            for (IRegistrationListener l : this.all_registration_listeners) {
                try {
                    l.registrationStarted(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireRegistrationSucceedEvent(RegistrationEvent event) {
        ArrayList<IRegistrationListener> arrayList = this.all_registration_listeners;
        synchronized (arrayList) {
            for (IRegistrationListener l : this.all_registration_listeners) {
                try {
                    l.registrationSucceed(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireRegistrationNotAllowedEvent(RegistrationEvent event) {
        ArrayList<IRegistrationListener> arrayList = this.all_registration_listeners;
        synchronized (arrayList) {
            for (IRegistrationListener l : this.all_registration_listeners) {
                try {
                    l.registrationNotAllowed(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireRegistrationErrorEvent(RegistrationErrorEvent event) {
        ArrayList<IRegistrationListener> arrayList = this.all_registration_listeners;
        synchronized (arrayList) {
            for (IRegistrationListener l : this.all_registration_listeners) {
                try {
                    l.registrationError(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    protected abstract boolean setRegistrationInformation(MspRegistrationParameters var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEngineListener(IEngineListener listener) {
        ArrayList<IEngineListener> arrayList = this.all_engine_listeners;
        synchronized (arrayList) {
            this.all_engine_listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEngineListener(IEngineListener listener) {
        ArrayList<IEngineListener> arrayList = this.all_engine_listeners;
        synchronized (arrayList) {
            this.all_engine_listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireSoftwareUpdateEvent(EngineSoftwareUpdateEvent event) {
        ArrayList<IEngineListener> arrayList = this.all_engine_listeners;
        synchronized (arrayList) {
            for (IEngineListener l : this.all_engine_listeners) {
                try {
                    l.softwareUpdateAvailable(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSignalListener(ISignalListener listener) {
        ArrayList<ISignalListener> arrayList = this.all_signal_listeners;
        synchronized (arrayList) {
            this.all_signal_listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSignalListener(ISignalListener listener) {
        ArrayList<ISignalListener> arrayList = this.all_signal_listeners;
        synchronized (arrayList) {
            this.all_signal_listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireSignalStrengthEvent(SignalStrengthEvent event) {
        ArrayList<ISignalListener> arrayList = this.all_signal_listeners;
        synchronized (arrayList) {
            for (ISignalListener l : this.all_signal_listeners) {
                try {
                    l.notifySignalStrength(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireSignalCoverageEvent(SignalCoverageEvent event) {
        ArrayList<ISignalListener> arrayList = this.all_signal_listeners;
        synchronized (arrayList) {
            for (ISignalListener l : this.all_signal_listeners) {
                try {
                    l.notifySignalCoverage(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireSignalInformationEvent(SignalInformationEvent event) {
        ArrayList<ISignalListener> arrayList = this.all_signal_listeners;
        synchronized (arrayList) {
            for (ISignalListener l : this.all_signal_listeners) {
                try {
                    l.notifySignalInformation(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireSAIListEvent(SAIListEvent event) {
        ArrayList<ISignalListener> arrayList = this.all_signal_listeners;
        synchronized (arrayList) {
            for (ISignalListener l : this.all_signal_listeners) {
                try {
                    l.notifySAIList(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireCellInfoEvent(CellInfoEvent event) {
        ArrayList<ISignalListener> arrayList = this.all_signal_listeners;
        synchronized (arrayList) {
            for (ISignalListener l : this.all_signal_listeners) {
                try {
                    l.notifyCellInfo(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addModemListener(IModemListener listener) {
        ArrayList<IModemListener> arrayList = this.all_modem_listeners;
        synchronized (arrayList) {
            this.all_modem_listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeModemListener(IModemListener listener) {
        ArrayList<IModemListener> arrayList = this.all_modem_listeners;
        synchronized (arrayList) {
            this.all_modem_listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireModemEnabledEvent(ModemEvent event) {
        ArrayList<IModemListener> arrayList = this.all_modem_listeners;
        synchronized (arrayList) {
            for (IModemListener l : this.all_modem_listeners) {
                try {
                    l.modemEnabled(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireModemDisabledEvent(ModemEvent event) {
        ArrayList<IModemListener> arrayList = this.all_modem_listeners;
        synchronized (arrayList) {
            for (IModemListener l : this.all_modem_listeners) {
                try {
                    l.modemDisabled(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireModemNoDeviceEvent(ModemEvent event) {
        ArrayList<IModemListener> arrayList = this.all_modem_listeners;
        synchronized (arrayList) {
            for (IModemListener l : this.all_modem_listeners) {
                try {
                    l.modemNoDevice(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireModemDeviceOffEvent(ModemEvent event) {
        ArrayList<IModemListener> arrayList = this.all_modem_listeners;
        synchronized (arrayList) {
            for (IModemListener l : this.all_modem_listeners) {
                try {
                    l.modemDeviceOff(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireModemMaxUEReachedEvent(ModemEvent event) {
        ArrayList<IModemListener> arrayList = this.all_modem_listeners;
        synchronized (arrayList) {
            for (IModemListener l : this.all_modem_listeners) {
                try {
                    l.modemMaxUEReached(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireModemTypeEvent(ModemTypeEvent event) {
        ArrayList<IModemListener> arrayList = this.all_modem_listeners;
        synchronized (arrayList) {
            for (IModemListener l : this.all_modem_listeners) {
                try {
                    l.modemType(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }
}

