#if HAVE_CRT
#define _CRTDBG_MAP_ALLOC 
#include <stdlib.h> 
#include <crtdbg.h>
#endif //HAVE_CRT

/* #line 1 "./ragel/thttp_parser_header_WWW_Authenticate.rl" */
/*
* Copyright (C) 2017, University of the Basque Country (UPV/EHU)
* Contact for licensing options: <licensing-mcpttclient(at)mcopenplatform(dot)com>
*
* The original file was part of Open Source Doubango Framework
* Copyright (C) 2010-2011 Mamadou Diop.
* Copyright (C) 2012 Doubango Telecom <http://doubango.org>
*
* This file is part of Open Source Doubango Framework.
*
* DOUBANGO is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* DOUBANGO is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with DOUBANGO.
*
*/


/**@file thttp_header_WWW_Authenticate.c
 * @brief HTTP WWW-Authenticate header.
 */
#include "tinyhttp/headers/thttp_header_WWW_Authenticate.h"

#include "tinyhttp/parsers/thttp_parser_url.h"

#include "tsk_debug.h"
#include "tsk_memory.h"
#include "tsk_time.h"

#include <string.h>

// Check if we have ",CRLF" ==> See WWW-Authenticate header
// As :>CRLF is preceded by any+ ==> p will be at least (start + 1)
// p point to CR
#define prev_not_comma(p) !(p && p[-1] == ',')

/***********************************
*	Ragel state machine.
*/

/* #line 131 "./ragel/thttp_parser_header_WWW_Authenticate.rl" */


thttp_header_WWW_Authenticate_t* thttp_header_www_authenticate_create()
{
	return tsk_object_new(thttp_header_WWW_Authenticate_def_t);
}

int thttp_header_WWW_Authenticate_tostring(const thttp_header_t* header, tsk_buffer_t* output)
{
	if(header){
		const thttp_header_WWW_Authenticate_t *WWW_Authenticate = (const thttp_header_WWW_Authenticate_t*)header;
		if(WWW_Authenticate && WWW_Authenticate->scheme){
			return tsk_buffer_append_2(output, "%s realm=\"%s\"%s%s%s%s%s%s%s%s%s%s%s%s,stale=%s%s%s", 
				WWW_Authenticate->scheme,
				WWW_Authenticate->realm ? WWW_Authenticate->realm : "",
				
				WWW_Authenticate->domain ? ",domain=\"" : "",
				WWW_Authenticate->domain ? WWW_Authenticate->domain : "",
				WWW_Authenticate->domain ? "\"" : "",
				
				
				WWW_Authenticate->qop ? ",qop=\"" : "",
				WWW_Authenticate->qop ? WWW_Authenticate->qop : "",
				WWW_Authenticate->qop ? "\"" : "",


				WWW_Authenticate->nonce ? ",nonce=\"" : "",
				WWW_Authenticate->nonce ? WWW_Authenticate->nonce : "",
				WWW_Authenticate->nonce ? "\"" : "",

				WWW_Authenticate->opaque ? ",opaque=\"" : "",
				WWW_Authenticate->opaque ? WWW_Authenticate->opaque : "",
				WWW_Authenticate->opaque ? "\"" : "",

				WWW_Authenticate->stale ? "TRUE" : "FALSE",

				WWW_Authenticate->algorithm ? ",algorithm=" : "",
				WWW_Authenticate->algorithm ? WWW_Authenticate->algorithm : ""
				);
		}
	}
	return -1;
}

/**@ingroup thttp_header_group
*/
thttp_header_WWW_Authenticate_t *thttp_header_WWW_Authenticate_parse(const char *data, tsk_size_t size)
{
	int cs = 0;
	char *p = malloc(size);
	memcpy(p, data, size);
	const char *pe = p + size;
	const char *eof = pe;
	tsk_size_t i = 0;
    tsk_size_t j = 0;
	thttp_header_WWW_Authenticate_t *hdr_WWW_Authenticate = thttp_header_www_authenticate_create();
	
	const char *tag_start = tsk_null;

	TSK_RAGEL_DISABLE_WARNINGS_BEGIN()
	
/* #line 105 "./src/headers/thttp_header_WWW_Authenticate.c" */
static const char _thttp_machine_parser_header_WWW_Authenticate_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 12, 1, 13, 2, 0, 6, 
	2, 0, 7, 2, 0, 8, 2, 0, 
	11, 2, 0, 12, 2, 5, 0, 2, 
	6, 0, 2, 7, 0, 2, 8, 0, 
	2, 12, 0
};

static const short _thttp_machine_parser_header_WWW_Authenticate_key_offsets[] = {
	0, 0, 4, 6, 8, 10, 12, 13, 
	15, 17, 19, 21, 23, 25, 27, 29, 
	31, 33, 35, 37, 40, 47, 48, 50, 
	57, 59, 66, 69, 72, 75, 78, 81, 
	112, 114, 145, 162, 167, 169, 174, 205, 
	207, 238, 257, 259, 278, 297, 299, 318, 
	320, 324, 332, 334, 338, 342, 344, 348, 
	350, 369, 388, 407, 426, 443, 448, 450, 
	455, 474, 476, 495, 497, 501, 509, 511, 
	515, 520, 536, 544, 553, 562, 571, 574, 
	582, 592, 595, 599, 602, 606, 609, 613, 
	617, 619, 623, 625, 629, 631, 641, 651, 
	660, 669, 678, 687, 690, 697, 707, 717, 
	727, 730, 734, 738, 740, 742, 744, 763, 
	782, 801, 820, 839, 856, 861, 863, 868, 
	887, 889, 908, 910, 914, 922, 924, 928, 
	933, 935, 954, 973, 990, 995, 997, 1002, 
	1021, 1023, 1042, 1044, 1048, 1056, 1064, 1066, 
	1069, 1073, 1075, 1079, 1098, 1117, 1136, 1155, 
	1172, 1177, 1179, 1184, 1203, 1205, 1224, 1226, 
	1230, 1238, 1240, 1244, 1249, 1251, 1270, 1289, 
	1308, 1327, 1344, 1349, 1351, 1356, 1379, 1381, 
	1404, 1422, 1440, 1458, 1476, 1480, 1498, 1516, 
	1518, 1521, 1527, 1536, 1538, 1547, 1549, 1558, 
	1594, 1596, 1632, 1654, 1664, 1666, 1676, 1699, 
	1701, 1724, 1726, 1734, 1743, 1752, 1754, 1759, 
	1780, 1795, 1811, 1827, 1843, 1853, 1868, 1885, 
	1895, 1906, 1916, 1927, 1937, 1948, 1959, 1968, 
	1979, 1988, 1999, 2008, 2025, 2042, 2058, 2074, 
	2090, 2106, 2116, 2130, 2147, 2164, 2181, 2191, 
	2202, 2213, 2222, 2231, 2233, 2257, 2281, 2305, 
	2329, 2353, 2377, 2401, 2425, 2447, 2457, 2459, 
	2469, 2492, 2494, 2517, 2538, 2540, 2564, 2588, 
	2612, 2636, 2660, 2682, 2692, 2694, 2704, 2727, 
	2729, 2752, 2754, 2762, 2771, 2779, 2781, 2784, 
	2787, 2793, 2802, 2805, 2814, 2850, 2853, 2889, 
	2911, 2921, 2924, 2934, 2957, 2960, 2983, 2986, 
	2994, 3015, 3018, 3036, 3042, 3045, 3051, 3083, 
	3086, 3118, 3138, 3141, 3161, 3180, 3183, 3202, 
	3205, 3209, 3226, 3231, 3234, 3239, 3242, 3262, 
	3282, 3302, 3322, 3340, 3346, 3349, 3355, 3374, 
	3377, 3396, 3399, 3403, 3412, 3414, 3423, 3425, 
	3434, 3470, 3472, 3508, 3530, 3540, 3542, 3552, 
	3575, 3577, 3600, 3602, 3610, 3619, 3640, 3649, 
	3651, 3666, 3682, 3698, 3714, 3724, 3739, 3756, 
	3766, 3777, 3787, 3798, 3808, 3819, 3830, 3839, 
	3848, 3859, 3868, 3879, 3888, 3905, 3922, 3938, 
	3954, 3970, 3986, 3996, 4010, 4027, 4044, 4061, 
	4071, 4082, 4093, 4102, 4111, 4113, 4137, 4161, 
	4185, 4209, 4233, 4257, 4281, 4305, 4327, 4337, 
	4339, 4349, 4372, 4374, 4397, 4418, 4420, 4444, 
	4468, 4492, 4516, 4540, 4562, 4572, 4574, 4584, 
	4607, 4609, 4632, 4634, 4642, 4651, 4653, 4677, 
	4701, 4725, 4749, 4771, 4781, 4783, 4793, 4816, 
	4818, 4841, 4843, 4851, 4860, 4862, 4886, 4910, 
	4934, 4958, 4982, 5004, 5014, 5016, 5026, 5049, 
	5051, 5074, 5076, 5084, 5093, 5102, 5104, 5113, 
	5149, 5151, 5187, 5209, 5219, 5221, 5231, 5254, 
	5256, 5279, 5281, 5289, 5298, 5319, 5321, 5336, 
	5352, 5368, 5384, 5394, 5409, 5426, 5436, 5447, 
	5457, 5468, 5478, 5489, 5500, 5509, 5518, 5529, 
	5538, 5549, 5558, 5575, 5592, 5608, 5624, 5640, 
	5656, 5666, 5680, 5697, 5714, 5731, 5741, 5752, 
	5763, 5772, 5781, 5783, 5807, 5831, 5855, 5879, 
	5903, 5927, 5951, 5975, 5997, 6007, 6009, 6019, 
	6042, 6044, 6067, 6088, 6090, 6114, 6138, 6162, 
	6186, 6210, 6232, 6242, 6244, 6254, 6277, 6279, 
	6302, 6304, 6312, 6321, 6323, 6347, 6371, 6395, 
	6419, 6441, 6451, 6453, 6463, 6486, 6488, 6511, 
	6513, 6521, 6530, 6532, 6556, 6580, 6604, 6628, 
	6652, 6674, 6684, 6686, 6696, 6719, 6721, 6744, 
	6746, 6754, 6763, 6765, 6789, 6813, 6835, 6845, 
	6847, 6857, 6880, 6882, 6905, 6907, 6915, 6924, 
	6933, 6936, 6945, 6981, 6984, 7020, 7042, 7052, 
	7055, 7065, 7088, 7091, 7114, 7117, 7125, 7146, 
	7149, 7167, 7173, 7176, 7182, 7214, 7217, 7249, 
	7269, 7272, 7292, 7311, 7314, 7333, 7336, 7340, 
	7357, 7362, 7365, 7370, 7373, 7393, 7413, 7433, 
	7453, 7471, 7477, 7480, 7486, 7505, 7508, 7527, 
	7530, 7534, 7543, 7553, 7563, 7573, 7577, 7586, 
	7597, 7601, 7606, 7610, 7615, 7619, 7624, 7629, 
	7632, 7637, 7642, 7645, 7650, 7653, 7664, 7675, 
	7685, 7695, 7705, 7715, 7719, 7727, 7738, 7749, 
	7760, 7764, 7769, 7774, 7777, 7780, 7783, 7803, 
	7823, 7843, 7863, 7883, 7901, 7907, 7910, 7916, 
	7935, 7938, 7957, 7960, 7964, 7973, 7975, 7984, 
	7987, 8007, 8027, 8045, 8051, 8054, 8060, 8079, 
	8082, 8101, 8104, 8124, 8144, 8164, 8184, 8202, 
	8208, 8211, 8217, 8236, 8239, 8258, 8261, 8265, 
	8274, 8276, 8285, 8287, 8296, 8332, 8334, 8370, 
	8392, 8402, 8404, 8414, 8437, 8439, 8462, 8464, 
	8472, 8481, 8502, 8511, 8513, 8528, 8544, 8560, 
	8576, 8586, 8601, 8618, 8628, 8639, 8649, 8660, 
	8670, 8681, 8692, 8701, 8710, 8721, 8730, 8741, 
	8750, 8767, 8784, 8800, 8816, 8832, 8848, 8858, 
	8872, 8889, 8906, 8923, 8933, 8944, 8955, 8964, 
	8973, 8975, 8999, 9023, 9047, 9071, 9095, 9119, 
	9143, 9167, 9189, 9199, 9201, 9211, 9234, 9236, 
	9259, 9280, 9282, 9306, 9330, 9354, 9378, 9402, 
	9424, 9434, 9436, 9446, 9469, 9471, 9494, 9496, 
	9504, 9513, 9515, 9539, 9563, 9587, 9611, 9633, 
	9643, 9645, 9655, 9678, 9680, 9703, 9705, 9713, 
	9722, 9724, 9748, 9772, 9796, 9820, 9844, 9866, 
	9876, 9878, 9888, 9911, 9913, 9936, 9938, 9946, 
	9955, 9957, 9981, 10005, 10027, 10037, 10039, 10049, 
	10072, 10074, 10097, 10099, 10107, 10116, 10118, 10142, 
	10166, 10190, 10214, 10236, 10246, 10248, 10258, 10281, 
	10283, 10306, 10308, 10316, 10325, 10327, 10351, 10375, 
	10399, 10423, 10445, 10455, 10457, 10467, 10494, 10496, 
	10523, 10546, 10569, 10592, 10615, 10624, 10647, 10670, 
	10672, 10675, 10695, 10715, 10735, 10755, 10773, 10779, 
	10782, 10788, 10811, 10814, 10837, 10856, 10875, 10894, 
	10913, 10918, 10937, 10956, 10959, 10979, 10999, 11019, 
	11039, 11057, 11063, 11066, 11072, 11091, 11094, 11113, 
	11116, 11120, 11129, 11138, 11141, 11150, 11170, 11190, 
	11210, 11230, 11250, 11268, 11274, 11277, 11283, 11302, 
	11305, 11324, 11327, 11331, 11340, 11350, 11360, 11370, 
	11374, 11383, 11394, 11398, 11403, 11407, 11412, 11416, 
	11421, 11426, 11429, 11434, 11439, 11442, 11447, 11450, 
	11461, 11472, 11482, 11492, 11502, 11512, 11516, 11524, 
	11535, 11546, 11557, 11561, 11566, 11571, 11574, 11577, 
	11580, 11600, 11620, 11638, 11644, 11647, 11653, 11672, 
	11675, 11694, 11697, 11701, 11710, 11719, 11722, 11731, 
	11734, 11754, 11774, 11794, 11814, 11832, 11838, 11841, 
	11847, 11866, 11869, 11888, 11891, 11895, 11898, 11918, 
	11938, 11958, 11978, 11996, 12002, 12005, 12011, 12034, 
	12037, 12060, 12079, 12098, 12117, 12136, 12141, 12160, 
	12179, 12182, 12185, 12205, 12225, 12245, 12265, 12285, 
	12305, 12325, 12343, 12349, 12352, 12358, 12377, 12380, 
	12399, 12416, 12419, 12434, 12450, 12466, 12482, 12492, 
	12507, 12524, 12534, 12545, 12555, 12566, 12576, 12587, 
	12598, 12607, 12616, 12627, 12636, 12647, 12656, 12673, 
	12690, 12706, 12722, 12738, 12754, 12764, 12778, 12795, 
	12812, 12829, 12839, 12850, 12861, 12870, 12879, 12882, 
	12906, 12930, 12954, 12978, 13002, 13026, 13050, 13074, 
	13096, 13106, 13109, 13119, 13142, 13145, 13168, 13189, 
	13192, 13216, 13240, 13264, 13288, 13312, 13334, 13344, 
	13347, 13357, 13380, 13383, 13406, 13409, 13417, 13420, 
	13444, 13468, 13492, 13516, 13538, 13548, 13551, 13561, 
	13584, 13587, 13610, 13613, 13621, 13624, 13648, 13672, 
	13696, 13720, 13744, 13766, 13776, 13779, 13789, 13812, 
	13815, 13838, 13841, 13849, 13852, 13876, 13900, 13922, 
	13932, 13935, 13945, 13968, 13971, 13994, 13997, 14021, 
	14045, 14069, 14093, 14115, 14125, 14128, 14138, 14161, 
	14164, 14187, 14190, 14198, 14201, 14225, 14249, 14273, 
	14297, 14319, 14329, 14332, 14342, 14369, 14372, 14399, 
	14422, 14445, 14468, 14491, 14500, 14523, 14546, 14549, 
	14551, 14575, 14599, 14623, 14647, 14669, 14679, 14681, 
	14691, 14714, 14716, 14739, 14741, 14749, 14758, 14760, 
	14784, 14808, 14832, 14856, 14878, 14888, 14890, 14900, 
	14927, 14929, 14956, 14979, 15002, 15025, 15048, 15057, 
	15080, 15103, 15105, 15107, 15131, 15155, 15177, 15187, 
	15189, 15199, 15222, 15224, 15247, 15249, 15257, 15266, 
	15268, 15292, 15316, 15340, 15364, 15386, 15396, 15398, 
	15408, 15431, 15433, 15456, 15458, 15466, 15475, 15477, 
	15501, 15525, 15549, 15573, 15595, 15605, 15607, 15617, 
	15644, 15646, 15673, 15696, 15719, 15742, 15765, 15774, 
	15797, 15820, 15822, 15825, 15845, 15865, 15885, 15905, 
	15923, 15929, 15932, 15938, 15957, 15960, 15979, 15982, 
	16002, 16022, 16042, 16062, 16082, 16102, 16122, 16140, 
	16146, 16149, 16155, 16174, 16177, 16196, 16213, 16216, 
	16231, 16247, 16263, 16279, 16289, 16304, 16321, 16331, 
	16342, 16352, 16363, 16373, 16384, 16395, 16404, 16413, 
	16424, 16433, 16444, 16453, 16470, 16487, 16503, 16519, 
	16535, 16551, 16561, 16575, 16592, 16609, 16626, 16636, 
	16647, 16658, 16667, 16676, 16679, 16703, 16727, 16751, 
	16775, 16799, 16823, 16847, 16871, 16893, 16903, 16906, 
	16916, 16939, 16942, 16965, 16986, 16989, 17013, 17037, 
	17061, 17085, 17109, 17131, 17141, 17144, 17154, 17177, 
	17180, 17203, 17206, 17230, 17254, 17278, 17302, 17324, 
	17334, 17337, 17347, 17370, 17373, 17396, 17399, 17407, 
	17410, 17434, 17458, 17482, 17506, 17530, 17552, 17562, 
	17565, 17575, 17598, 17601, 17624, 17627, 17635, 17638, 
	17662, 17686, 17708, 17718, 17721, 17731, 17754, 17757, 
	17780, 17783, 17791, 17794, 17818, 17842, 17866, 17890, 
	17912, 17922, 17925, 17935, 17958, 17961, 17984, 17987, 
	17995, 17998, 18022, 18046, 18070, 18094, 18116, 18126, 
	18129, 18139, 18166, 18169, 18196, 18219, 18242, 18265, 
	18288, 18297, 18320, 18343, 18346, 18348, 18372, 18396, 
	18420, 18444, 18466, 18476, 18478, 18488, 18511, 18513, 
	18536, 18538, 18546, 18548, 18572, 18596, 18620, 18644, 
	18668, 18690, 18700, 18702, 18712, 18735, 18737, 18760, 
	18762, 18770, 18772, 18796, 18820, 18842, 18852, 18854, 
	18864, 18887, 18889, 18912, 18914, 18922, 18931, 18933, 
	18957, 18981, 19005, 19029, 19051, 19061, 19063, 19073, 
	19096, 19098, 19121, 19123, 19131, 19133, 19157, 19181, 
	19205, 19229, 19251, 19261, 19263, 19273, 19300, 19302, 
	19329, 19352, 19375, 19398, 19421, 19430, 19453, 19476, 
	19478, 19480, 19499, 19518, 19537, 19556, 19573, 19578, 
	19580, 19585, 19604, 19606, 19625, 19627, 19631, 19639, 
	19641, 19660, 19679, 19698, 19717, 19736, 19755, 19774, 
	19791, 19796, 19798, 19803, 19822, 19824, 19843, 19859, 
	19861, 19880, 19899, 19918, 19937, 19956, 19973, 19978, 
	19980, 19985, 20004, 20006, 20025, 20027, 20031, 20039, 
	20047, 20050, 20056, 20065, 20067, 20076, 20078, 20087, 
	20123, 20125, 20161, 20183, 20193, 20195, 20205, 20228, 
	20230, 20253, 20274, 20283, 20285, 20300, 20316, 20332, 
	20348, 20358, 20373, 20390, 20400, 20411, 20421, 20432, 
	20442, 20453, 20464, 20473, 20482, 20493, 20502, 20513, 
	20522, 20539, 20556, 20572, 20588, 20604, 20620, 20630, 
	20644, 20661, 20678, 20695, 20705, 20716, 20727, 20736, 
	20745, 20747, 20771, 20795, 20819, 20843, 20867, 20891, 
	20915, 20939, 20961, 20971, 20973, 20983, 21006, 21008, 
	21031, 21052, 21054, 21078, 21102, 21126, 21150, 21174, 
	21196, 21206, 21208, 21218, 21241, 21243, 21266, 21268, 
	21276, 21285, 21287, 21311, 21335, 21359, 21383, 21405, 
	21415, 21417, 21427, 21450, 21452, 21475, 21477, 21501, 
	21525, 21549, 21573, 21597, 21619, 21629, 21631, 21641, 
	21664, 21666, 21689, 21691, 21715, 21739, 21761, 21771, 
	21773, 21783, 21806, 21808, 21831, 21833, 21841, 21850, 
	21852, 21876, 21900, 21924, 21948, 21970, 21980, 21982, 
	21992, 22015, 22017, 22040, 22042, 22066, 22090, 22114, 
	22138, 22160, 22170, 22172, 22182, 22209, 22211, 22238, 
	22261, 22284, 22307, 22330, 22339, 22362, 22385, 22387, 
	22389, 22408, 22427, 22444, 22449, 22451, 22456, 22475, 
	22477, 22496, 22498, 22502, 22510, 22518, 22521, 22527, 
	22529, 22532, 22535, 22538, 22541, 22544, 22547, 22549, 
	22552, 22554, 22556, 22557, 22560, 22563, 22566, 22569, 
	22600, 22603, 22606, 22609, 22612, 22643, 22646, 22649, 
	22652, 22655, 22686, 22689, 22692, 22695, 22698, 22729, 
	22732, 22735, 22738, 22740, 22771, 22774, 22777, 22780, 
	22783, 22814, 22817, 22820, 22851, 22855, 22886, 22917, 
	22920, 22923, 22926, 22929, 22932, 22963, 22966, 22969, 
	23000, 23003, 23006, 23009, 23011, 23015, 23019, 23023, 
	23027, 23031, 23035, 23067, 23071, 23075, 23107, 23111, 
	23115, 23119, 23151, 23155, 23159, 23163, 23194, 23225, 
	23228, 23231, 23234, 23237, 23240, 23271, 23274, 23277, 
	23308, 23311, 23314, 23317, 23348, 23351, 23354, 23357, 
	23388, 23391, 23394, 23397, 23400, 23403, 23406, 23409, 
	23412, 23443, 23474, 23477, 23480, 23511, 23514, 23517, 
	23520, 23551, 23554, 23557, 23560, 23591, 23594, 23597, 
	23600, 23631, 23634, 23637, 23640, 23644, 23648, 23652, 
	23656, 23660, 23692, 23696, 23700, 23732, 23736, 23740, 
	23744, 23776, 23780, 23784, 23788, 23820, 23824, 23828, 
	23832, 23863, 23895, 23899, 23903, 23935, 23939, 23943, 
	23947, 23978, 24009, 24012, 24015, 24018, 24021, 24024, 
	24055, 24058, 24061, 24092, 24095, 24098, 24101, 24132, 
	24135, 24138, 24141, 24172, 24175, 24178, 24181, 24212, 
	24215, 24218, 24221, 24252, 24255, 24258, 24261, 24292, 
	24295, 24298, 24329, 24361, 24365, 24369, 24401, 24405, 
	24409, 24413, 24445, 24449, 24453, 24457, 24489, 24493, 
	24497, 24501, 24533, 24565, 24569, 24573, 24577, 24609, 
	24613, 24617, 24649, 24681, 24685, 24689, 24721, 24753, 
	24757, 24761, 24793, 24797, 24801, 24805, 24837, 24841, 
	24845, 24849, 24881, 24885, 24889, 24893, 24925, 24929, 
	24933, 24965, 24969, 24973, 24977, 25009, 25013, 25017, 
	25049, 25080, 25083, 25086, 25089, 25120, 25123, 25126, 
	25157, 25188, 25191, 25194, 25197, 25228, 25231, 25234, 
	25237, 25268, 25271, 25274, 25305, 25337, 25341, 25345, 
	25377, 25381, 25385, 25417, 25449, 25453, 25457, 25489, 
	25493, 25497, 25529, 25533, 25537, 25541, 25573, 25577, 
	25581, 25585, 25617, 25621, 25625, 25629, 25661, 25665, 
	25669, 25673, 25705, 25709, 25713, 25745, 25776, 25779, 
	25782, 25785, 25816, 25819, 25822, 25825, 25856, 25859, 
	25862, 25865, 25896, 25899, 25902, 25905, 25936, 25939, 
	25942, 25973, 26004, 26007, 26010, 26013, 26044, 26047, 
	26050, 26081, 26084, 26087, 26090, 26094, 26125, 26156, 
	26159, 26162, 26165, 26168, 26199, 26202, 26205, 26236, 
	26239, 26242, 26245, 26276, 26279, 26282, 26313, 26316, 
	26319, 26350, 26353, 26356, 26359, 26390, 26393, 26396, 
	26427, 26430, 26433, 26464, 26495, 26498, 26501, 26504, 
	26508
};

static const char _thttp_machine_parser_header_WWW_Authenticate_trans_keys[] = {
	80, 87, 112, 119, 82, 114, 79, 111, 
	88, 120, 89, 121, 45, 65, 97, 85, 
	117, 84, 116, 72, 104, 69, 101, 78, 
	110, 84, 116, 73, 105, 67, 99, 65, 
	97, 84, 116, 69, 101, 9, 32, 58, 
	9, 13, 32, 66, 68, 98, 100, 13, 
	10, 13, 9, 13, 32, 66, 68, 98, 
	100, 10, 13, 9, 13, 32, 66, 68, 
	98, 100, 13, 65, 97, 13, 83, 115, 
	13, 73, 105, 13, 67, 99, 9, 13, 
	32, 9, 13, 32, 33, 37, 39, 65, 
	68, 78, 79, 81, 82, 83, 97, 100, 
	110, 111, 113, 114, 115, 126, 42, 43, 
	45, 46, 48, 57, 66, 90, 95, 122, 
	10, 13, 9, 13, 32, 33, 37, 39, 
	65, 68, 78, 79, 81, 82, 83, 97, 
	100, 110, 111, 113, 114, 115, 126, 42, 
	43, 45, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 33, 37, 39, 44, 
	61, 126, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 44, 61, 10, 
	13, 9, 13, 32, 44, 61, 9, 13, 
	32, 33, 37, 39, 65, 68, 78, 79, 
	81, 82, 83, 97, 100, 110, 111, 113, 
	114, 115, 126, 42, 43, 45, 46, 48, 
	57, 66, 90, 95, 122, 10, 13, 9, 
	13, 32, 33, 37, 39, 65, 68, 78, 
	79, 81, 82, 83, 97, 100, 110, 111, 
	113, 114, 115, 126, 42, 43, 45, 46, 
	48, 57, 66, 90, 95, 122, 9, 13, 
	32, 33, 37, 39, 44, 61, 76, 108, 
	126, 42, 46, 48, 57, 65, 90, 95, 
	122, 10, 13, 9, 13, 32, 33, 37, 
	39, 44, 61, 79, 111, 126, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 91, 126, 42, 
	43, 45, 46, 48, 57, 65, 90, 95, 
	122, 10, 13, 9, 13, 32, 33, 34, 
	37, 39, 91, 126, 42, 43, 45, 46, 
	48, 57, 65, 90, 95, 122, 10, 13, 
	9, 13, 32, 34, 13, 34, 92, 127, 
	0, 8, 10, 31, 10, 13, 9, 13, 
	32, 44, 9, 13, 32, 44, 10, 13, 
	9, 13, 32, 44, 10, 13, 9, 13, 
	32, 33, 37, 39, 44, 61, 79, 111, 
	126, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 37, 39, 44, 
	61, 78, 110, 126, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	37, 39, 44, 61, 67, 99, 126, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 37, 39, 44, 61, 69, 
	101, 126, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 37, 39, 
	44, 61, 126, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 44, 61, 
	10, 13, 9, 13, 32, 44, 61, 9, 
	13, 32, 33, 34, 37, 39, 91, 126, 
	42, 43, 45, 46, 48, 57, 65, 90, 
	95, 122, 10, 13, 9, 13, 32, 33, 
	34, 37, 39, 91, 126, 42, 43, 45, 
	46, 48, 57, 65, 90, 95, 122, 10, 
	13, 9, 13, 32, 34, 13, 34, 92, 
	127, 0, 8, 10, 31, 10, 13, 9, 
	13, 32, 44, 13, 0, 9, 11, 127, 
	9, 13, 32, 33, 37, 39, 44, 126, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	13, 58, 48, 57, 65, 70, 97, 102, 
	13, 58, 93, 48, 57, 65, 70, 97, 
	102, 13, 58, 93, 48, 57, 65, 70, 
	97, 102, 13, 58, 93, 48, 57, 65, 
	70, 97, 102, 13, 58, 93, 13, 58, 
	48, 57, 65, 70, 97, 102, 13, 46, 
	58, 93, 48, 57, 65, 70, 97, 102, 
	13, 48, 57, 13, 46, 48, 57, 13, 
	48, 57, 13, 46, 48, 57, 13, 48, 
	57, 13, 93, 48, 57, 13, 93, 48, 
	57, 13, 93, 13, 46, 48, 57, 13, 
	46, 13, 46, 48, 57, 13, 46, 13, 
	46, 58, 93, 48, 57, 65, 70, 97, 
	102, 13, 46, 58, 93, 48, 57, 65, 
	70, 97, 102, 13, 58, 93, 48, 57, 
	65, 70, 97, 102, 13, 58, 93, 48, 
	57, 65, 70, 97, 102, 13, 58, 93, 
	48, 57, 65, 70, 97, 102, 13, 58, 
	93, 48, 57, 65, 70, 97, 102, 13, 
	58, 93, 13, 48, 57, 65, 70, 97, 
	102, 13, 46, 58, 93, 48, 57, 65, 
	70, 97, 102, 13, 46, 58, 93, 48, 
	57, 65, 70, 97, 102, 13, 46, 58, 
	93, 48, 57, 65, 70, 97, 102, 13, 
	48, 57, 13, 46, 48, 57, 13, 46, 
	48, 57, 13, 46, 13, 58, 10, 13, 
	9, 13, 32, 33, 37, 39, 44, 61, 
	80, 112, 126, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 37, 
	39, 44, 61, 65, 97, 126, 42, 46, 
	48, 57, 66, 90, 95, 122, 9, 13, 
	32, 33, 37, 39, 44, 61, 81, 113, 
	126, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 37, 39, 44, 
	61, 85, 117, 126, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	37, 39, 44, 61, 69, 101, 126, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 37, 39, 44, 61, 126, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 44, 61, 10, 13, 9, 
	13, 32, 44, 61, 9, 13, 32, 33, 
	34, 37, 39, 91, 126, 42, 43, 45, 
	46, 48, 57, 65, 90, 95, 122, 10, 
	13, 9, 13, 32, 33, 34, 37, 39, 
	91, 126, 42, 43, 45, 46, 48, 57, 
	65, 90, 95, 122, 10, 13, 9, 13, 
	32, 34, 13, 34, 92, 127, 0, 8, 
	10, 31, 10, 13, 9, 13, 32, 44, 
	13, 0, 9, 11, 127, 10, 13, 9, 
	13, 32, 33, 37, 39, 44, 61, 79, 
	111, 126, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 37, 39, 
	44, 61, 80, 112, 126, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 37, 39, 44, 61, 126, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 44, 61, 10, 13, 9, 13, 32, 
	44, 61, 9, 13, 32, 33, 34, 37, 
	39, 91, 126, 42, 43, 45, 46, 48, 
	57, 65, 90, 95, 122, 10, 13, 9, 
	13, 32, 33, 34, 37, 39, 91, 126, 
	42, 43, 45, 46, 48, 57, 65, 90, 
	95, 122, 10, 13, 9, 13, 32, 34, 
	13, 34, 92, 127, 0, 8, 10, 31, 
	13, 34, 92, 127, 0, 8, 10, 31, 
	13, 34, 10, 13, 34, 9, 13, 32, 
	44, 10, 13, 9, 13, 32, 44, 9, 
	13, 32, 33, 37, 39, 44, 61, 69, 
	101, 126, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 37, 39, 
	44, 61, 65, 97, 126, 42, 46, 48, 
	57, 66, 90, 95, 122, 9, 13, 32, 
	33, 37, 39, 44, 61, 76, 108, 126, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 33, 37, 39, 44, 61, 
	77, 109, 126, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 37, 
	39, 44, 61, 126, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 44, 
	61, 10, 13, 9, 13, 32, 44, 61, 
	9, 13, 32, 33, 34, 37, 39, 91, 
	126, 42, 43, 45, 46, 48, 57, 65, 
	90, 95, 122, 10, 13, 9, 13, 32, 
	33, 34, 37, 39, 91, 126, 42, 43, 
	45, 46, 48, 57, 65, 90, 95, 122, 
	10, 13, 9, 13, 32, 34, 13, 34, 
	92, 127, 0, 8, 10, 31, 10, 13, 
	9, 13, 32, 44, 13, 0, 9, 11, 
	127, 10, 13, 9, 13, 32, 33, 37, 
	39, 44, 61, 84, 116, 126, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 37, 39, 44, 61, 65, 97, 
	126, 42, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 33, 37, 39, 44, 
	61, 76, 108, 126, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	37, 39, 44, 61, 69, 101, 126, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 37, 39, 44, 61, 126, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 44, 61, 10, 13, 9, 
	13, 32, 44, 61, 9, 13, 32, 33, 
	34, 37, 39, 70, 84, 91, 102, 116, 
	126, 42, 43, 45, 46, 48, 57, 65, 
	90, 95, 122, 10, 13, 9, 13, 32, 
	33, 34, 37, 39, 70, 84, 91, 102, 
	116, 126, 42, 43, 45, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	37, 39, 44, 65, 97, 126, 42, 46, 
	48, 57, 66, 90, 95, 122, 9, 13, 
	32, 33, 37, 39, 44, 76, 108, 126, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 33, 37, 39, 44, 83, 
	115, 126, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 37, 39, 
	44, 69, 101, 126, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 44, 
	9, 13, 32, 33, 37, 39, 44, 82, 
	114, 126, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 37, 39, 
	44, 85, 117, 126, 42, 46, 48, 57, 
	65, 90, 95, 122, 10, 13, 10, 13, 
	34, 13, 34, 0, 9, 11, 127, 9, 
	13, 32, 34, 44, 92, 127, 0, 31, 
	10, 13, 9, 13, 32, 34, 44, 92, 
	127, 0, 31, 10, 13, 9, 13, 32, 
	34, 44, 92, 127, 0, 31, 9, 13, 
	32, 33, 34, 37, 39, 65, 68, 78, 
	79, 81, 82, 83, 92, 97, 100, 110, 
	111, 113, 114, 115, 126, 127, 0, 31, 
	42, 43, 45, 46, 48, 57, 66, 90, 
	95, 122, 10, 13, 9, 13, 32, 33, 
	34, 37, 39, 65, 68, 78, 79, 81, 
	82, 83, 92, 97, 100, 110, 111, 113, 
	114, 115, 126, 127, 0, 31, 42, 43, 
	45, 46, 48, 57, 66, 90, 95, 122, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	61, 92, 126, 127, 0, 31, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 34, 44, 61, 92, 127, 0, 31, 
	10, 13, 9, 13, 32, 34, 44, 61, 
	92, 127, 0, 31, 9, 13, 32, 33, 
	34, 37, 39, 91, 92, 126, 127, 0, 
	31, 42, 43, 45, 46, 48, 57, 65, 
	90, 95, 122, 10, 13, 9, 13, 32, 
	33, 34, 37, 39, 91, 92, 126, 127, 
	0, 31, 42, 43, 45, 46, 48, 57, 
	65, 90, 95, 122, 10, 13, 9, 13, 
	32, 34, 92, 127, 0, 31, 9, 13, 
	32, 34, 44, 92, 127, 0, 31, 9, 
	13, 32, 34, 44, 92, 127, 0, 31, 
	10, 13, 13, 0, 9, 11, 127, 9, 
	13, 32, 33, 34, 37, 39, 44, 92, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 13, 34, 58, 92, 
	127, 0, 8, 10, 31, 48, 57, 65, 
	70, 97, 102, 13, 34, 58, 92, 93, 
	127, 0, 8, 10, 31, 48, 57, 65, 
	70, 97, 102, 13, 34, 58, 92, 93, 
	127, 0, 8, 10, 31, 48, 57, 65, 
	70, 97, 102, 13, 34, 58, 92, 93, 
	127, 0, 8, 10, 31, 48, 57, 65, 
	70, 97, 102, 13, 34, 58, 92, 93, 
	127, 0, 8, 10, 31, 13, 34, 58, 
	92, 127, 0, 8, 10, 31, 48, 57, 
	65, 70, 97, 102, 13, 34, 46, 58, 
	92, 93, 127, 0, 8, 10, 31, 48, 
	57, 65, 70, 97, 102, 13, 34, 92, 
	127, 0, 8, 10, 31, 48, 57, 13, 
	34, 46, 92, 127, 0, 8, 10, 31, 
	48, 57, 13, 34, 92, 127, 0, 8, 
	10, 31, 48, 57, 13, 34, 46, 92, 
	127, 0, 8, 10, 31, 48, 57, 13, 
	34, 92, 127, 0, 8, 10, 31, 48, 
	57, 13, 34, 92, 93, 127, 0, 8, 
	10, 31, 48, 57, 13, 34, 92, 93, 
	127, 0, 8, 10, 31, 48, 57, 13, 
	34, 92, 93, 127, 0, 8, 10, 31, 
	13, 34, 46, 92, 127, 0, 8, 10, 
	31, 48, 57, 13, 34, 46, 92, 127, 
	0, 8, 10, 31, 13, 34, 46, 92, 
	127, 0, 8, 10, 31, 48, 57, 13, 
	34, 46, 92, 127, 0, 8, 10, 31, 
	13, 34, 46, 58, 92, 93, 127, 0, 
	8, 10, 31, 48, 57, 65, 70, 97, 
	102, 13, 34, 46, 58, 92, 93, 127, 
	0, 8, 10, 31, 48, 57, 65, 70, 
	97, 102, 13, 34, 58, 92, 93, 127, 
	0, 8, 10, 31, 48, 57, 65, 70, 
	97, 102, 13, 34, 58, 92, 93, 127, 
	0, 8, 10, 31, 48, 57, 65, 70, 
	97, 102, 13, 34, 58, 92, 93, 127, 
	0, 8, 10, 31, 48, 57, 65, 70, 
	97, 102, 13, 34, 58, 92, 93, 127, 
	0, 8, 10, 31, 48, 57, 65, 70, 
	97, 102, 13, 34, 58, 92, 93, 127, 
	0, 8, 10, 31, 13, 34, 92, 127, 
	0, 8, 10, 31, 48, 57, 65, 70, 
	97, 102, 13, 34, 46, 58, 92, 93, 
	127, 0, 8, 10, 31, 48, 57, 65, 
	70, 97, 102, 13, 34, 46, 58, 92, 
	93, 127, 0, 8, 10, 31, 48, 57, 
	65, 70, 97, 102, 13, 34, 46, 58, 
	92, 93, 127, 0, 8, 10, 31, 48, 
	57, 65, 70, 97, 102, 13, 34, 92, 
	127, 0, 8, 10, 31, 48, 57, 13, 
	34, 46, 92, 127, 0, 8, 10, 31, 
	48, 57, 13, 34, 46, 92, 127, 0, 
	8, 10, 31, 48, 57, 13, 34, 46, 
	92, 127, 0, 8, 10, 31, 13, 34, 
	58, 92, 127, 0, 8, 10, 31, 10, 
	13, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 76, 92, 108, 126, 127, 0, 
	31, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 71, 92, 103, 126, 127, 0, 
	31, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 79, 92, 111, 126, 127, 0, 
	31, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 82, 92, 114, 126, 127, 0, 
	31, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 73, 92, 105, 126, 127, 0, 
	31, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 84, 92, 116, 126, 127, 0, 
	31, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 72, 92, 104, 126, 127, 0, 
	31, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 77, 92, 109, 126, 127, 0, 
	31, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 92, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 34, 44, 61, 92, 127, 0, 
	31, 10, 13, 9, 13, 32, 34, 44, 
	61, 92, 127, 0, 31, 9, 13, 32, 
	33, 34, 37, 39, 91, 92, 126, 127, 
	0, 31, 42, 43, 45, 46, 48, 57, 
	65, 90, 95, 122, 10, 13, 9, 13, 
	32, 33, 34, 37, 39, 91, 92, 126, 
	127, 0, 31, 42, 43, 45, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 92, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 10, 13, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 79, 92, 111, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 77, 92, 109, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 65, 92, 97, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	66, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 73, 92, 105, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 78, 92, 110, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 92, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 34, 44, 61, 
	92, 127, 0, 31, 10, 13, 9, 13, 
	32, 34, 44, 61, 92, 127, 0, 31, 
	9, 13, 32, 33, 34, 37, 39, 91, 
	92, 126, 127, 0, 31, 42, 43, 45, 
	46, 48, 57, 65, 90, 95, 122, 10, 
	13, 9, 13, 32, 33, 34, 37, 39, 
	91, 92, 126, 127, 0, 31, 42, 43, 
	45, 46, 48, 57, 65, 90, 95, 122, 
	10, 13, 9, 13, 32, 34, 92, 127, 
	0, 31, 9, 13, 32, 34, 44, 92, 
	127, 0, 31, 13, 34, 92, 127, 0, 
	8, 10, 31, 13, 34, 10, 13, 34, 
	10, 13, 34, 13, 34, 0, 9, 11, 
	127, 9, 13, 32, 34, 44, 92, 127, 
	0, 31, 10, 13, 34, 9, 13, 32, 
	34, 44, 92, 127, 0, 31, 9, 13, 
	32, 33, 34, 37, 39, 65, 68, 78, 
	79, 81, 82, 83, 92, 97, 100, 110, 
	111, 113, 114, 115, 126, 127, 0, 31, 
	42, 43, 45, 46, 48, 57, 66, 90, 
	95, 122, 10, 13, 34, 9, 13, 32, 
	33, 34, 37, 39, 65, 68, 78, 79, 
	81, 82, 83, 92, 97, 100, 110, 111, 
	113, 114, 115, 126, 127, 0, 31, 42, 
	43, 45, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 92, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 34, 44, 61, 92, 127, 0, 
	31, 10, 13, 34, 9, 13, 32, 34, 
	44, 61, 92, 127, 0, 31, 9, 13, 
	32, 33, 34, 37, 39, 91, 92, 126, 
	127, 0, 31, 42, 43, 45, 46, 48, 
	57, 65, 90, 95, 122, 10, 13, 34, 
	9, 13, 32, 33, 34, 37, 39, 91, 
	92, 126, 127, 0, 31, 42, 43, 45, 
	46, 48, 57, 65, 90, 95, 122, 10, 
	13, 34, 9, 13, 32, 34, 92, 127, 
	0, 31, 9, 13, 32, 33, 34, 37, 
	39, 44, 92, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 10, 
	13, 34, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 126, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 34, 
	44, 61, 10, 13, 34, 9, 13, 32, 
	34, 44, 61, 9, 13, 32, 33, 34, 
	37, 39, 65, 68, 78, 79, 81, 82, 
	83, 97, 100, 110, 111, 113, 114, 115, 
	126, 42, 43, 45, 46, 48, 57, 66, 
	90, 95, 122, 10, 13, 34, 9, 13, 
	32, 33, 34, 37, 39, 65, 68, 78, 
	79, 81, 82, 83, 97, 100, 110, 111, 
	113, 114, 115, 126, 42, 43, 45, 46, 
	48, 57, 66, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 76, 
	108, 126, 42, 46, 48, 57, 65, 90, 
	95, 122, 10, 13, 34, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 79, 111, 
	126, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	91, 126, 42, 43, 45, 46, 48, 57, 
	65, 90, 95, 122, 10, 13, 34, 9, 
	13, 32, 33, 34, 37, 39, 91, 126, 
	42, 43, 45, 46, 48, 57, 65, 90, 
	95, 122, 10, 13, 34, 9, 13, 32, 
	34, 9, 13, 32, 33, 34, 37, 39, 
	44, 126, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 34, 44, 10, 
	13, 34, 9, 13, 32, 34, 44, 10, 
	13, 34, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 79, 111, 126, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 78, 
	110, 126, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 67, 99, 126, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 69, 
	101, 126, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 126, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 34, 
	44, 61, 10, 13, 34, 9, 13, 32, 
	34, 44, 61, 9, 13, 32, 33, 34, 
	37, 39, 91, 126, 42, 43, 45, 46, 
	48, 57, 65, 90, 95, 122, 10, 13, 
	34, 9, 13, 32, 33, 34, 37, 39, 
	91, 126, 42, 43, 45, 46, 48, 57, 
	65, 90, 95, 122, 10, 13, 34, 9, 
	13, 32, 34, 9, 13, 32, 34, 44, 
	92, 127, 0, 31, 10, 13, 9, 13, 
	32, 34, 44, 92, 127, 0, 31, 10, 
	13, 9, 13, 32, 34, 44, 92, 127, 
	0, 31, 9, 13, 32, 33, 34, 37, 
	39, 65, 68, 78, 79, 81, 82, 83, 
	92, 97, 100, 110, 111, 113, 114, 115, 
	126, 127, 0, 31, 42, 43, 45, 46, 
	48, 57, 66, 90, 95, 122, 10, 13, 
	9, 13, 32, 33, 34, 37, 39, 65, 
	68, 78, 79, 81, 82, 83, 92, 97, 
	100, 110, 111, 113, 114, 115, 126, 127, 
	0, 31, 42, 43, 45, 46, 48, 57, 
	66, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 92, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 34, 44, 61, 
	92, 127, 0, 31, 10, 13, 9, 13, 
	32, 34, 44, 61, 92, 127, 0, 31, 
	9, 13, 32, 33, 34, 37, 39, 91, 
	92, 126, 127, 0, 31, 42, 43, 45, 
	46, 48, 57, 65, 90, 95, 122, 10, 
	13, 9, 13, 32, 33, 34, 37, 39, 
	91, 92, 126, 127, 0, 31, 42, 43, 
	45, 46, 48, 57, 65, 90, 95, 122, 
	10, 13, 9, 13, 32, 34, 92, 127, 
	0, 31, 9, 13, 32, 34, 44, 92, 
	127, 0, 31, 9, 13, 32, 33, 34, 
	37, 39, 44, 92, 126, 127, 0, 31, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 34, 44, 92, 127, 0, 
	31, 10, 13, 13, 34, 58, 92, 127, 
	0, 8, 10, 31, 48, 57, 65, 70, 
	97, 102, 13, 34, 58, 92, 93, 127, 
	0, 8, 10, 31, 48, 57, 65, 70, 
	97, 102, 13, 34, 58, 92, 93, 127, 
	0, 8, 10, 31, 48, 57, 65, 70, 
	97, 102, 13, 34, 58, 92, 93, 127, 
	0, 8, 10, 31, 48, 57, 65, 70, 
	97, 102, 13, 34, 58, 92, 93, 127, 
	0, 8, 10, 31, 13, 34, 58, 92, 
	127, 0, 8, 10, 31, 48, 57, 65, 
	70, 97, 102, 13, 34, 46, 58, 92, 
	93, 127, 0, 8, 10, 31, 48, 57, 
	65, 70, 97, 102, 13, 34, 92, 127, 
	0, 8, 10, 31, 48, 57, 13, 34, 
	46, 92, 127, 0, 8, 10, 31, 48, 
	57, 13, 34, 92, 127, 0, 8, 10, 
	31, 48, 57, 13, 34, 46, 92, 127, 
	0, 8, 10, 31, 48, 57, 13, 34, 
	92, 127, 0, 8, 10, 31, 48, 57, 
	13, 34, 92, 93, 127, 0, 8, 10, 
	31, 48, 57, 13, 34, 92, 93, 127, 
	0, 8, 10, 31, 48, 57, 13, 34, 
	92, 93, 127, 0, 8, 10, 31, 9, 
	13, 32, 34, 44, 92, 127, 0, 31, 
	13, 34, 46, 92, 127, 0, 8, 10, 
	31, 48, 57, 13, 34, 46, 92, 127, 
	0, 8, 10, 31, 13, 34, 46, 92, 
	127, 0, 8, 10, 31, 48, 57, 13, 
	34, 46, 92, 127, 0, 8, 10, 31, 
	13, 34, 46, 58, 92, 93, 127, 0, 
	8, 10, 31, 48, 57, 65, 70, 97, 
	102, 13, 34, 46, 58, 92, 93, 127, 
	0, 8, 10, 31, 48, 57, 65, 70, 
	97, 102, 13, 34, 58, 92, 93, 127, 
	0, 8, 10, 31, 48, 57, 65, 70, 
	97, 102, 13, 34, 58, 92, 93, 127, 
	0, 8, 10, 31, 48, 57, 65, 70, 
	97, 102, 13, 34, 58, 92, 93, 127, 
	0, 8, 10, 31, 48, 57, 65, 70, 
	97, 102, 13, 34, 58, 92, 93, 127, 
	0, 8, 10, 31, 48, 57, 65, 70, 
	97, 102, 13, 34, 58, 92, 93, 127, 
	0, 8, 10, 31, 13, 34, 92, 127, 
	0, 8, 10, 31, 48, 57, 65, 70, 
	97, 102, 13, 34, 46, 58, 92, 93, 
	127, 0, 8, 10, 31, 48, 57, 65, 
	70, 97, 102, 13, 34, 46, 58, 92, 
	93, 127, 0, 8, 10, 31, 48, 57, 
	65, 70, 97, 102, 13, 34, 46, 58, 
	92, 93, 127, 0, 8, 10, 31, 48, 
	57, 65, 70, 97, 102, 13, 34, 92, 
	127, 0, 8, 10, 31, 48, 57, 13, 
	34, 46, 92, 127, 0, 8, 10, 31, 
	48, 57, 13, 34, 46, 92, 127, 0, 
	8, 10, 31, 48, 57, 13, 34, 46, 
	92, 127, 0, 8, 10, 31, 13, 34, 
	58, 92, 127, 0, 8, 10, 31, 10, 
	13, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 76, 92, 108, 126, 127, 0, 
	31, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 71, 92, 103, 126, 127, 0, 
	31, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 79, 92, 111, 126, 127, 0, 
	31, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 82, 92, 114, 126, 127, 0, 
	31, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 73, 92, 105, 126, 127, 0, 
	31, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 84, 92, 116, 126, 127, 0, 
	31, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 72, 92, 104, 126, 127, 0, 
	31, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 77, 92, 109, 126, 127, 0, 
	31, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 92, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 34, 44, 61, 92, 127, 0, 
	31, 10, 13, 9, 13, 32, 34, 44, 
	61, 92, 127, 0, 31, 9, 13, 32, 
	33, 34, 37, 39, 91, 92, 126, 127, 
	0, 31, 42, 43, 45, 46, 48, 57, 
	65, 90, 95, 122, 10, 13, 9, 13, 
	32, 33, 34, 37, 39, 91, 92, 126, 
	127, 0, 31, 42, 43, 45, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 92, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 10, 13, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 79, 92, 111, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 77, 92, 109, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 65, 92, 97, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	66, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 73, 92, 105, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 78, 92, 110, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 92, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 34, 44, 61, 
	92, 127, 0, 31, 10, 13, 9, 13, 
	32, 34, 44, 61, 92, 127, 0, 31, 
	9, 13, 32, 33, 34, 37, 39, 91, 
	92, 126, 127, 0, 31, 42, 43, 45, 
	46, 48, 57, 65, 90, 95, 122, 10, 
	13, 9, 13, 32, 33, 34, 37, 39, 
	91, 92, 126, 127, 0, 31, 42, 43, 
	45, 46, 48, 57, 65, 90, 95, 122, 
	10, 13, 9, 13, 32, 34, 92, 127, 
	0, 31, 9, 13, 32, 34, 44, 92, 
	127, 0, 31, 10, 13, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 79, 92, 
	111, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 78, 92, 
	110, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 67, 92, 
	99, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 69, 92, 
	101, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 92, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 34, 44, 
	61, 92, 127, 0, 31, 10, 13, 9, 
	13, 32, 34, 44, 61, 92, 127, 0, 
	31, 9, 13, 32, 33, 34, 37, 39, 
	91, 92, 126, 127, 0, 31, 42, 43, 
	45, 46, 48, 57, 65, 90, 95, 122, 
	10, 13, 9, 13, 32, 33, 34, 37, 
	39, 91, 92, 126, 127, 0, 31, 42, 
	43, 45, 46, 48, 57, 65, 90, 95, 
	122, 10, 13, 9, 13, 32, 34, 92, 
	127, 0, 31, 9, 13, 32, 34, 44, 
	92, 127, 0, 31, 10, 13, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 80, 
	92, 112, 126, 127, 0, 31, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 65, 
	92, 97, 126, 127, 0, 31, 42, 46, 
	48, 57, 66, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 81, 
	92, 113, 126, 127, 0, 31, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 85, 
	92, 117, 126, 127, 0, 31, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 69, 
	92, 101, 126, 127, 0, 31, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 92, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 34, 
	44, 61, 92, 127, 0, 31, 10, 13, 
	9, 13, 32, 34, 44, 61, 92, 127, 
	0, 31, 9, 13, 32, 33, 34, 37, 
	39, 91, 92, 126, 127, 0, 31, 42, 
	43, 45, 46, 48, 57, 65, 90, 95, 
	122, 10, 13, 9, 13, 32, 33, 34, 
	37, 39, 91, 92, 126, 127, 0, 31, 
	42, 43, 45, 46, 48, 57, 65, 90, 
	95, 122, 10, 13, 9, 13, 32, 34, 
	92, 127, 0, 31, 9, 13, 32, 34, 
	44, 92, 127, 0, 31, 9, 13, 32, 
	34, 44, 92, 127, 0, 31, 10, 13, 
	9, 13, 32, 34, 44, 92, 127, 0, 
	31, 9, 13, 32, 33, 34, 37, 39, 
	65, 68, 78, 79, 81, 82, 83, 92, 
	97, 100, 110, 111, 113, 114, 115, 126, 
	127, 0, 31, 42, 43, 45, 46, 48, 
	57, 66, 90, 95, 122, 10, 13, 9, 
	13, 32, 33, 34, 37, 39, 65, 68, 
	78, 79, 81, 82, 83, 92, 97, 100, 
	110, 111, 113, 114, 115, 126, 127, 0, 
	31, 42, 43, 45, 46, 48, 57, 66, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 92, 126, 127, 0, 
	31, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 34, 44, 61, 92, 
	127, 0, 31, 10, 13, 9, 13, 32, 
	34, 44, 61, 92, 127, 0, 31, 9, 
	13, 32, 33, 34, 37, 39, 91, 92, 
	126, 127, 0, 31, 42, 43, 45, 46, 
	48, 57, 65, 90, 95, 122, 10, 13, 
	9, 13, 32, 33, 34, 37, 39, 91, 
	92, 126, 127, 0, 31, 42, 43, 45, 
	46, 48, 57, 65, 90, 95, 122, 10, 
	13, 9, 13, 32, 34, 92, 127, 0, 
	31, 9, 13, 32, 34, 44, 92, 127, 
	0, 31, 9, 13, 32, 33, 34, 37, 
	39, 44, 92, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 10, 
	13, 13, 34, 58, 92, 127, 0, 8, 
	10, 31, 48, 57, 65, 70, 97, 102, 
	13, 34, 58, 92, 93, 127, 0, 8, 
	10, 31, 48, 57, 65, 70, 97, 102, 
	13, 34, 58, 92, 93, 127, 0, 8, 
	10, 31, 48, 57, 65, 70, 97, 102, 
	13, 34, 58, 92, 93, 127, 0, 8, 
	10, 31, 48, 57, 65, 70, 97, 102, 
	13, 34, 58, 92, 93, 127, 0, 8, 
	10, 31, 13, 34, 58, 92, 127, 0, 
	8, 10, 31, 48, 57, 65, 70, 97, 
	102, 13, 34, 46, 58, 92, 93, 127, 
	0, 8, 10, 31, 48, 57, 65, 70, 
	97, 102, 13, 34, 92, 127, 0, 8, 
	10, 31, 48, 57, 13, 34, 46, 92, 
	127, 0, 8, 10, 31, 48, 57, 13, 
	34, 92, 127, 0, 8, 10, 31, 48, 
	57, 13, 34, 46, 92, 127, 0, 8, 
	10, 31, 48, 57, 13, 34, 92, 127, 
	0, 8, 10, 31, 48, 57, 13, 34, 
	92, 93, 127, 0, 8, 10, 31, 48, 
	57, 13, 34, 92, 93, 127, 0, 8, 
	10, 31, 48, 57, 13, 34, 92, 93, 
	127, 0, 8, 10, 31, 9, 13, 32, 
	34, 44, 92, 127, 0, 31, 13, 34, 
	46, 92, 127, 0, 8, 10, 31, 48, 
	57, 13, 34, 46, 92, 127, 0, 8, 
	10, 31, 13, 34, 46, 92, 127, 0, 
	8, 10, 31, 48, 57, 13, 34, 46, 
	92, 127, 0, 8, 10, 31, 13, 34, 
	46, 58, 92, 93, 127, 0, 8, 10, 
	31, 48, 57, 65, 70, 97, 102, 13, 
	34, 46, 58, 92, 93, 127, 0, 8, 
	10, 31, 48, 57, 65, 70, 97, 102, 
	13, 34, 58, 92, 93, 127, 0, 8, 
	10, 31, 48, 57, 65, 70, 97, 102, 
	13, 34, 58, 92, 93, 127, 0, 8, 
	10, 31, 48, 57, 65, 70, 97, 102, 
	13, 34, 58, 92, 93, 127, 0, 8, 
	10, 31, 48, 57, 65, 70, 97, 102, 
	13, 34, 58, 92, 93, 127, 0, 8, 
	10, 31, 48, 57, 65, 70, 97, 102, 
	13, 34, 58, 92, 93, 127, 0, 8, 
	10, 31, 13, 34, 92, 127, 0, 8, 
	10, 31, 48, 57, 65, 70, 97, 102, 
	13, 34, 46, 58, 92, 93, 127, 0, 
	8, 10, 31, 48, 57, 65, 70, 97, 
	102, 13, 34, 46, 58, 92, 93, 127, 
	0, 8, 10, 31, 48, 57, 65, 70, 
	97, 102, 13, 34, 46, 58, 92, 93, 
	127, 0, 8, 10, 31, 48, 57, 65, 
	70, 97, 102, 13, 34, 92, 127, 0, 
	8, 10, 31, 48, 57, 13, 34, 46, 
	92, 127, 0, 8, 10, 31, 48, 57, 
	13, 34, 46, 92, 127, 0, 8, 10, 
	31, 48, 57, 13, 34, 46, 92, 127, 
	0, 8, 10, 31, 13, 34, 58, 92, 
	127, 0, 8, 10, 31, 10, 13, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	76, 92, 108, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	71, 92, 103, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	79, 92, 111, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	82, 92, 114, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	73, 92, 105, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	84, 92, 116, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	72, 92, 104, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	77, 92, 109, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	92, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	34, 44, 61, 92, 127, 0, 31, 10, 
	13, 9, 13, 32, 34, 44, 61, 92, 
	127, 0, 31, 9, 13, 32, 33, 34, 
	37, 39, 91, 92, 126, 127, 0, 31, 
	42, 43, 45, 46, 48, 57, 65, 90, 
	95, 122, 10, 13, 9, 13, 32, 33, 
	34, 37, 39, 91, 92, 126, 127, 0, 
	31, 42, 43, 45, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 92, 126, 127, 0, 31, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	10, 13, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 79, 92, 111, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 77, 92, 109, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 65, 92, 97, 126, 127, 
	0, 31, 42, 46, 48, 57, 66, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 73, 92, 105, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 78, 92, 110, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 92, 126, 127, 0, 31, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 34, 44, 61, 92, 127, 
	0, 31, 10, 13, 9, 13, 32, 34, 
	44, 61, 92, 127, 0, 31, 9, 13, 
	32, 33, 34, 37, 39, 91, 92, 126, 
	127, 0, 31, 42, 43, 45, 46, 48, 
	57, 65, 90, 95, 122, 10, 13, 9, 
	13, 32, 33, 34, 37, 39, 91, 92, 
	126, 127, 0, 31, 42, 43, 45, 46, 
	48, 57, 65, 90, 95, 122, 10, 13, 
	9, 13, 32, 34, 92, 127, 0, 31, 
	9, 13, 32, 34, 44, 92, 127, 0, 
	31, 10, 13, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 79, 92, 111, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 78, 92, 110, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 67, 92, 99, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 69, 92, 101, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 92, 126, 127, 0, 
	31, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 34, 44, 61, 92, 
	127, 0, 31, 10, 13, 9, 13, 32, 
	34, 44, 61, 92, 127, 0, 31, 9, 
	13, 32, 33, 34, 37, 39, 91, 92, 
	126, 127, 0, 31, 42, 43, 45, 46, 
	48, 57, 65, 90, 95, 122, 10, 13, 
	9, 13, 32, 33, 34, 37, 39, 91, 
	92, 126, 127, 0, 31, 42, 43, 45, 
	46, 48, 57, 65, 90, 95, 122, 10, 
	13, 9, 13, 32, 34, 92, 127, 0, 
	31, 9, 13, 32, 34, 44, 92, 127, 
	0, 31, 10, 13, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 80, 92, 112, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 65, 92, 97, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	66, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 81, 92, 113, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 85, 92, 117, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 69, 92, 101, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 92, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 34, 44, 61, 
	92, 127, 0, 31, 10, 13, 9, 13, 
	32, 34, 44, 61, 92, 127, 0, 31, 
	9, 13, 32, 33, 34, 37, 39, 91, 
	92, 126, 127, 0, 31, 42, 43, 45, 
	46, 48, 57, 65, 90, 95, 122, 10, 
	13, 9, 13, 32, 33, 34, 37, 39, 
	91, 92, 126, 127, 0, 31, 42, 43, 
	45, 46, 48, 57, 65, 90, 95, 122, 
	10, 13, 9, 13, 32, 34, 92, 127, 
	0, 31, 9, 13, 32, 34, 44, 92, 
	127, 0, 31, 10, 13, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 79, 92, 
	111, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 80, 92, 
	112, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 92, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 34, 44, 
	61, 92, 127, 0, 31, 10, 13, 9, 
	13, 32, 34, 44, 61, 92, 127, 0, 
	31, 9, 13, 32, 33, 34, 37, 39, 
	91, 92, 126, 127, 0, 31, 42, 43, 
	45, 46, 48, 57, 65, 90, 95, 122, 
	10, 13, 9, 13, 32, 33, 34, 37, 
	39, 91, 92, 126, 127, 0, 31, 42, 
	43, 45, 46, 48, 57, 65, 90, 95, 
	122, 10, 13, 9, 13, 32, 34, 92, 
	127, 0, 31, 9, 13, 32, 34, 44, 
	92, 127, 0, 31, 9, 13, 32, 34, 
	44, 92, 127, 0, 31, 10, 13, 34, 
	9, 13, 32, 34, 44, 92, 127, 0, 
	31, 9, 13, 32, 33, 34, 37, 39, 
	65, 68, 78, 79, 81, 82, 83, 92, 
	97, 100, 110, 111, 113, 114, 115, 126, 
	127, 0, 31, 42, 43, 45, 46, 48, 
	57, 66, 90, 95, 122, 10, 13, 34, 
	9, 13, 32, 33, 34, 37, 39, 65, 
	68, 78, 79, 81, 82, 83, 92, 97, 
	100, 110, 111, 113, 114, 115, 126, 127, 
	0, 31, 42, 43, 45, 46, 48, 57, 
	66, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 92, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 34, 44, 61, 
	92, 127, 0, 31, 10, 13, 34, 9, 
	13, 32, 34, 44, 61, 92, 127, 0, 
	31, 9, 13, 32, 33, 34, 37, 39, 
	91, 92, 126, 127, 0, 31, 42, 43, 
	45, 46, 48, 57, 65, 90, 95, 122, 
	10, 13, 34, 9, 13, 32, 33, 34, 
	37, 39, 91, 92, 126, 127, 0, 31, 
	42, 43, 45, 46, 48, 57, 65, 90, 
	95, 122, 10, 13, 34, 9, 13, 32, 
	34, 92, 127, 0, 31, 9, 13, 32, 
	33, 34, 37, 39, 44, 92, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 10, 13, 34, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 126, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 34, 44, 61, 10, 13, 34, 
	9, 13, 32, 34, 44, 61, 9, 13, 
	32, 33, 34, 37, 39, 65, 68, 78, 
	79, 81, 82, 83, 97, 100, 110, 111, 
	113, 114, 115, 126, 42, 43, 45, 46, 
	48, 57, 66, 90, 95, 122, 10, 13, 
	34, 9, 13, 32, 33, 34, 37, 39, 
	65, 68, 78, 79, 81, 82, 83, 97, 
	100, 110, 111, 113, 114, 115, 126, 42, 
	43, 45, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 76, 108, 126, 42, 46, 48, 
	57, 65, 90, 95, 122, 10, 13, 34, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	61, 79, 111, 126, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 91, 126, 42, 43, 45, 
	46, 48, 57, 65, 90, 95, 122, 10, 
	13, 34, 9, 13, 32, 33, 34, 37, 
	39, 91, 126, 42, 43, 45, 46, 48, 
	57, 65, 90, 95, 122, 10, 13, 34, 
	9, 13, 32, 34, 9, 13, 32, 33, 
	34, 37, 39, 44, 126, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	34, 44, 10, 13, 34, 9, 13, 32, 
	34, 44, 10, 13, 34, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 79, 111, 
	126, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 78, 110, 126, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 67, 99, 
	126, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 69, 101, 126, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 126, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 34, 44, 61, 10, 13, 34, 
	9, 13, 32, 34, 44, 61, 9, 13, 
	32, 33, 34, 37, 39, 91, 126, 42, 
	43, 45, 46, 48, 57, 65, 90, 95, 
	122, 10, 13, 34, 9, 13, 32, 33, 
	34, 37, 39, 91, 126, 42, 43, 45, 
	46, 48, 57, 65, 90, 95, 122, 10, 
	13, 34, 9, 13, 32, 34, 13, 34, 
	58, 48, 57, 65, 70, 97, 102, 13, 
	34, 58, 93, 48, 57, 65, 70, 97, 
	102, 13, 34, 58, 93, 48, 57, 65, 
	70, 97, 102, 13, 34, 58, 93, 48, 
	57, 65, 70, 97, 102, 13, 34, 58, 
	93, 13, 34, 58, 48, 57, 65, 70, 
	97, 102, 13, 34, 46, 58, 93, 48, 
	57, 65, 70, 97, 102, 13, 34, 48, 
	57, 13, 34, 46, 48, 57, 13, 34, 
	48, 57, 13, 34, 46, 48, 57, 13, 
	34, 48, 57, 13, 34, 93, 48, 57, 
	13, 34, 93, 48, 57, 13, 34, 93, 
	9, 13, 32, 34, 44, 13, 34, 46, 
	48, 57, 13, 34, 46, 13, 34, 46, 
	48, 57, 13, 34, 46, 13, 34, 46, 
	58, 93, 48, 57, 65, 70, 97, 102, 
	13, 34, 46, 58, 93, 48, 57, 65, 
	70, 97, 102, 13, 34, 58, 93, 48, 
	57, 65, 70, 97, 102, 13, 34, 58, 
	93, 48, 57, 65, 70, 97, 102, 13, 
	34, 58, 93, 48, 57, 65, 70, 97, 
	102, 13, 34, 58, 93, 48, 57, 65, 
	70, 97, 102, 13, 34, 58, 93, 13, 
	34, 48, 57, 65, 70, 97, 102, 13, 
	34, 46, 58, 93, 48, 57, 65, 70, 
	97, 102, 13, 34, 46, 58, 93, 48, 
	57, 65, 70, 97, 102, 13, 34, 46, 
	58, 93, 48, 57, 65, 70, 97, 102, 
	13, 34, 48, 57, 13, 34, 46, 48, 
	57, 13, 34, 46, 48, 57, 13, 34, 
	46, 13, 34, 58, 10, 13, 34, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	80, 112, 126, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 65, 97, 126, 42, 
	46, 48, 57, 66, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	81, 113, 126, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 85, 117, 126, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	69, 101, 126, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 126, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	34, 44, 61, 10, 13, 34, 9, 13, 
	32, 34, 44, 61, 9, 13, 32, 33, 
	34, 37, 39, 91, 126, 42, 43, 45, 
	46, 48, 57, 65, 90, 95, 122, 10, 
	13, 34, 9, 13, 32, 33, 34, 37, 
	39, 91, 126, 42, 43, 45, 46, 48, 
	57, 65, 90, 95, 122, 10, 13, 34, 
	9, 13, 32, 34, 9, 13, 32, 34, 
	44, 92, 127, 0, 31, 10, 13, 9, 
	13, 32, 34, 44, 92, 127, 0, 31, 
	10, 13, 34, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 79, 111, 126, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	80, 112, 126, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 126, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	34, 44, 61, 10, 13, 34, 9, 13, 
	32, 34, 44, 61, 9, 13, 32, 33, 
	34, 37, 39, 91, 126, 42, 43, 45, 
	46, 48, 57, 65, 90, 95, 122, 10, 
	13, 34, 9, 13, 32, 33, 34, 37, 
	39, 91, 126, 42, 43, 45, 46, 48, 
	57, 65, 90, 95, 122, 10, 13, 34, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	61, 69, 101, 126, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 65, 97, 126, 
	42, 46, 48, 57, 66, 90, 95, 122, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	61, 76, 108, 126, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 77, 109, 126, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	61, 126, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 34, 44, 61, 
	10, 13, 34, 9, 13, 32, 34, 44, 
	61, 9, 13, 32, 33, 34, 37, 39, 
	91, 126, 42, 43, 45, 46, 48, 57, 
	65, 90, 95, 122, 10, 13, 34, 9, 
	13, 32, 33, 34, 37, 39, 91, 126, 
	42, 43, 45, 46, 48, 57, 65, 90, 
	95, 122, 10, 13, 34, 9, 13, 32, 
	34, 9, 13, 32, 34, 44, 92, 127, 
	0, 31, 10, 13, 9, 13, 32, 34, 
	44, 92, 127, 0, 31, 10, 13, 9, 
	13, 32, 34, 44, 92, 127, 0, 31, 
	9, 13, 32, 33, 34, 37, 39, 65, 
	68, 78, 79, 81, 82, 83, 92, 97, 
	100, 110, 111, 113, 114, 115, 126, 127, 
	0, 31, 42, 43, 45, 46, 48, 57, 
	66, 90, 95, 122, 10, 13, 9, 13, 
	32, 33, 34, 37, 39, 65, 68, 78, 
	79, 81, 82, 83, 92, 97, 100, 110, 
	111, 113, 114, 115, 126, 127, 0, 31, 
	42, 43, 45, 46, 48, 57, 66, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 92, 126, 127, 0, 31, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 34, 44, 61, 92, 127, 
	0, 31, 10, 13, 9, 13, 32, 34, 
	44, 61, 92, 127, 0, 31, 9, 13, 
	32, 33, 34, 37, 39, 91, 92, 126, 
	127, 0, 31, 42, 43, 45, 46, 48, 
	57, 65, 90, 95, 122, 10, 13, 9, 
	13, 32, 33, 34, 37, 39, 91, 92, 
	126, 127, 0, 31, 42, 43, 45, 46, 
	48, 57, 65, 90, 95, 122, 10, 13, 
	9, 13, 32, 34, 92, 127, 0, 31, 
	9, 13, 32, 34, 44, 92, 127, 0, 
	31, 9, 13, 32, 33, 34, 37, 39, 
	44, 92, 126, 127, 0, 31, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 34, 44, 92, 127, 0, 31, 10, 
	13, 13, 34, 58, 92, 127, 0, 8, 
	10, 31, 48, 57, 65, 70, 97, 102, 
	13, 34, 58, 92, 93, 127, 0, 8, 
	10, 31, 48, 57, 65, 70, 97, 102, 
	13, 34, 58, 92, 93, 127, 0, 8, 
	10, 31, 48, 57, 65, 70, 97, 102, 
	13, 34, 58, 92, 93, 127, 0, 8, 
	10, 31, 48, 57, 65, 70, 97, 102, 
	13, 34, 58, 92, 93, 127, 0, 8, 
	10, 31, 13, 34, 58, 92, 127, 0, 
	8, 10, 31, 48, 57, 65, 70, 97, 
	102, 13, 34, 46, 58, 92, 93, 127, 
	0, 8, 10, 31, 48, 57, 65, 70, 
	97, 102, 13, 34, 92, 127, 0, 8, 
	10, 31, 48, 57, 13, 34, 46, 92, 
	127, 0, 8, 10, 31, 48, 57, 13, 
	34, 92, 127, 0, 8, 10, 31, 48, 
	57, 13, 34, 46, 92, 127, 0, 8, 
	10, 31, 48, 57, 13, 34, 92, 127, 
	0, 8, 10, 31, 48, 57, 13, 34, 
	92, 93, 127, 0, 8, 10, 31, 48, 
	57, 13, 34, 92, 93, 127, 0, 8, 
	10, 31, 48, 57, 13, 34, 92, 93, 
	127, 0, 8, 10, 31, 9, 13, 32, 
	34, 44, 92, 127, 0, 31, 13, 34, 
	46, 92, 127, 0, 8, 10, 31, 48, 
	57, 13, 34, 46, 92, 127, 0, 8, 
	10, 31, 13, 34, 46, 92, 127, 0, 
	8, 10, 31, 48, 57, 13, 34, 46, 
	92, 127, 0, 8, 10, 31, 13, 34, 
	46, 58, 92, 93, 127, 0, 8, 10, 
	31, 48, 57, 65, 70, 97, 102, 13, 
	34, 46, 58, 92, 93, 127, 0, 8, 
	10, 31, 48, 57, 65, 70, 97, 102, 
	13, 34, 58, 92, 93, 127, 0, 8, 
	10, 31, 48, 57, 65, 70, 97, 102, 
	13, 34, 58, 92, 93, 127, 0, 8, 
	10, 31, 48, 57, 65, 70, 97, 102, 
	13, 34, 58, 92, 93, 127, 0, 8, 
	10, 31, 48, 57, 65, 70, 97, 102, 
	13, 34, 58, 92, 93, 127, 0, 8, 
	10, 31, 48, 57, 65, 70, 97, 102, 
	13, 34, 58, 92, 93, 127, 0, 8, 
	10, 31, 13, 34, 92, 127, 0, 8, 
	10, 31, 48, 57, 65, 70, 97, 102, 
	13, 34, 46, 58, 92, 93, 127, 0, 
	8, 10, 31, 48, 57, 65, 70, 97, 
	102, 13, 34, 46, 58, 92, 93, 127, 
	0, 8, 10, 31, 48, 57, 65, 70, 
	97, 102, 13, 34, 46, 58, 92, 93, 
	127, 0, 8, 10, 31, 48, 57, 65, 
	70, 97, 102, 13, 34, 92, 127, 0, 
	8, 10, 31, 48, 57, 13, 34, 46, 
	92, 127, 0, 8, 10, 31, 48, 57, 
	13, 34, 46, 92, 127, 0, 8, 10, 
	31, 48, 57, 13, 34, 46, 92, 127, 
	0, 8, 10, 31, 13, 34, 58, 92, 
	127, 0, 8, 10, 31, 10, 13, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	76, 92, 108, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	71, 92, 103, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	79, 92, 111, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	82, 92, 114, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	73, 92, 105, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	84, 92, 116, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	72, 92, 104, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	77, 92, 109, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	92, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	34, 44, 61, 92, 127, 0, 31, 10, 
	13, 9, 13, 32, 34, 44, 61, 92, 
	127, 0, 31, 9, 13, 32, 33, 34, 
	37, 39, 91, 92, 126, 127, 0, 31, 
	42, 43, 45, 46, 48, 57, 65, 90, 
	95, 122, 10, 13, 9, 13, 32, 33, 
	34, 37, 39, 91, 92, 126, 127, 0, 
	31, 42, 43, 45, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 92, 126, 127, 0, 31, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	10, 13, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 79, 92, 111, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 77, 92, 109, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 65, 92, 97, 126, 127, 
	0, 31, 42, 46, 48, 57, 66, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 73, 92, 105, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 78, 92, 110, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 92, 126, 127, 0, 31, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 34, 44, 61, 92, 127, 
	0, 31, 10, 13, 9, 13, 32, 34, 
	44, 61, 92, 127, 0, 31, 9, 13, 
	32, 33, 34, 37, 39, 91, 92, 126, 
	127, 0, 31, 42, 43, 45, 46, 48, 
	57, 65, 90, 95, 122, 10, 13, 9, 
	13, 32, 33, 34, 37, 39, 91, 92, 
	126, 127, 0, 31, 42, 43, 45, 46, 
	48, 57, 65, 90, 95, 122, 10, 13, 
	9, 13, 32, 34, 92, 127, 0, 31, 
	9, 13, 32, 34, 44, 92, 127, 0, 
	31, 10, 13, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 79, 92, 111, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 78, 92, 110, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 67, 92, 99, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 69, 92, 101, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 92, 126, 127, 0, 
	31, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 34, 44, 61, 92, 
	127, 0, 31, 10, 13, 9, 13, 32, 
	34, 44, 61, 92, 127, 0, 31, 9, 
	13, 32, 33, 34, 37, 39, 91, 92, 
	126, 127, 0, 31, 42, 43, 45, 46, 
	48, 57, 65, 90, 95, 122, 10, 13, 
	9, 13, 32, 33, 34, 37, 39, 91, 
	92, 126, 127, 0, 31, 42, 43, 45, 
	46, 48, 57, 65, 90, 95, 122, 10, 
	13, 9, 13, 32, 34, 92, 127, 0, 
	31, 9, 13, 32, 34, 44, 92, 127, 
	0, 31, 10, 13, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 80, 92, 112, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 65, 92, 97, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	66, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 81, 92, 113, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 85, 92, 117, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 69, 92, 101, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 92, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 34, 44, 61, 
	92, 127, 0, 31, 10, 13, 9, 13, 
	32, 34, 44, 61, 92, 127, 0, 31, 
	9, 13, 32, 33, 34, 37, 39, 91, 
	92, 126, 127, 0, 31, 42, 43, 45, 
	46, 48, 57, 65, 90, 95, 122, 10, 
	13, 9, 13, 32, 33, 34, 37, 39, 
	91, 92, 126, 127, 0, 31, 42, 43, 
	45, 46, 48, 57, 65, 90, 95, 122, 
	10, 13, 9, 13, 32, 34, 92, 127, 
	0, 31, 9, 13, 32, 34, 44, 92, 
	127, 0, 31, 10, 13, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 79, 92, 
	111, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 80, 92, 
	112, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 92, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 34, 44, 
	61, 92, 127, 0, 31, 10, 13, 9, 
	13, 32, 34, 44, 61, 92, 127, 0, 
	31, 9, 13, 32, 33, 34, 37, 39, 
	91, 92, 126, 127, 0, 31, 42, 43, 
	45, 46, 48, 57, 65, 90, 95, 122, 
	10, 13, 9, 13, 32, 33, 34, 37, 
	39, 91, 92, 126, 127, 0, 31, 42, 
	43, 45, 46, 48, 57, 65, 90, 95, 
	122, 10, 13, 9, 13, 32, 34, 92, 
	127, 0, 31, 9, 13, 32, 34, 44, 
	92, 127, 0, 31, 10, 13, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 69, 
	92, 101, 126, 127, 0, 31, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 65, 
	92, 97, 126, 127, 0, 31, 42, 46, 
	48, 57, 66, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 76, 
	92, 108, 126, 127, 0, 31, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 77, 
	92, 109, 126, 127, 0, 31, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 92, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 34, 
	44, 61, 92, 127, 0, 31, 10, 13, 
	9, 13, 32, 34, 44, 61, 92, 127, 
	0, 31, 9, 13, 32, 33, 34, 37, 
	39, 91, 92, 126, 127, 0, 31, 42, 
	43, 45, 46, 48, 57, 65, 90, 95, 
	122, 10, 13, 9, 13, 32, 33, 34, 
	37, 39, 91, 92, 126, 127, 0, 31, 
	42, 43, 45, 46, 48, 57, 65, 90, 
	95, 122, 10, 13, 9, 13, 32, 34, 
	92, 127, 0, 31, 9, 13, 32, 34, 
	44, 92, 127, 0, 31, 10, 13, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	84, 92, 116, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	65, 92, 97, 126, 127, 0, 31, 42, 
	46, 48, 57, 66, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	76, 92, 108, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	69, 92, 101, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	92, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	34, 44, 61, 92, 127, 0, 31, 10, 
	13, 9, 13, 32, 34, 44, 61, 92, 
	127, 0, 31, 9, 13, 32, 33, 34, 
	37, 39, 70, 84, 91, 92, 102, 116, 
	126, 127, 0, 31, 42, 43, 45, 46, 
	48, 57, 65, 90, 95, 122, 10, 13, 
	9, 13, 32, 33, 34, 37, 39, 70, 
	84, 91, 92, 102, 116, 126, 127, 0, 
	31, 42, 43, 45, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 65, 92, 97, 126, 127, 
	0, 31, 42, 46, 48, 57, 66, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 76, 92, 108, 126, 127, 0, 
	31, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 83, 92, 115, 126, 127, 0, 31, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	69, 92, 101, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 34, 44, 92, 127, 0, 31, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	82, 92, 114, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 85, 
	92, 117, 126, 127, 0, 31, 42, 46, 
	48, 57, 65, 90, 95, 122, 10, 13, 
	10, 13, 34, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 84, 116, 126, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	65, 97, 126, 42, 46, 48, 57, 66, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 76, 108, 126, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	69, 101, 126, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 126, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	34, 44, 61, 10, 13, 34, 9, 13, 
	32, 34, 44, 61, 9, 13, 32, 33, 
	34, 37, 39, 70, 84, 91, 102, 116, 
	126, 42, 43, 45, 46, 48, 57, 65, 
	90, 95, 122, 10, 13, 34, 9, 13, 
	32, 33, 34, 37, 39, 70, 84, 91, 
	102, 116, 126, 42, 43, 45, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 65, 97, 126, 
	42, 46, 48, 57, 66, 90, 95, 122, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	76, 108, 126, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 83, 115, 126, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 69, 101, 
	126, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 34, 44, 9, 13, 
	32, 33, 34, 37, 39, 44, 82, 114, 
	126, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 85, 117, 126, 42, 46, 48, 57, 
	65, 90, 95, 122, 10, 13, 34, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	77, 109, 126, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 65, 97, 126, 42, 
	46, 48, 57, 66, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	73, 105, 126, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 78, 110, 126, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	126, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 34, 44, 61, 10, 
	13, 34, 9, 13, 32, 34, 44, 61, 
	9, 13, 32, 33, 34, 37, 39, 91, 
	126, 42, 43, 45, 46, 48, 57, 65, 
	90, 95, 122, 10, 13, 34, 9, 13, 
	32, 33, 34, 37, 39, 91, 126, 42, 
	43, 45, 46, 48, 57, 65, 90, 95, 
	122, 10, 13, 34, 9, 13, 32, 34, 
	9, 13, 32, 34, 44, 92, 127, 0, 
	31, 9, 13, 32, 34, 44, 92, 127, 
	0, 31, 10, 13, 34, 9, 13, 32, 
	34, 44, 92, 127, 0, 31, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 80, 
	112, 126, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 65, 97, 126, 42, 46, 
	48, 57, 66, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 81, 
	113, 126, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 85, 117, 126, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 69, 
	101, 126, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 126, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 34, 
	44, 61, 10, 13, 34, 9, 13, 32, 
	34, 44, 61, 9, 13, 32, 33, 34, 
	37, 39, 91, 126, 42, 43, 45, 46, 
	48, 57, 65, 90, 95, 122, 10, 13, 
	34, 9, 13, 32, 33, 34, 37, 39, 
	91, 126, 42, 43, 45, 46, 48, 57, 
	65, 90, 95, 122, 10, 13, 34, 9, 
	13, 32, 34, 13, 34, 58, 48, 57, 
	65, 70, 97, 102, 13, 34, 58, 93, 
	48, 57, 65, 70, 97, 102, 13, 34, 
	58, 93, 48, 57, 65, 70, 97, 102, 
	13, 34, 58, 93, 48, 57, 65, 70, 
	97, 102, 13, 34, 58, 93, 13, 34, 
	58, 48, 57, 65, 70, 97, 102, 13, 
	34, 46, 58, 93, 48, 57, 65, 70, 
	97, 102, 13, 34, 48, 57, 13, 34, 
	46, 48, 57, 13, 34, 48, 57, 13, 
	34, 46, 48, 57, 13, 34, 48, 57, 
	13, 34, 93, 48, 57, 13, 34, 93, 
	48, 57, 13, 34, 93, 9, 13, 32, 
	34, 44, 13, 34, 46, 48, 57, 13, 
	34, 46, 13, 34, 46, 48, 57, 13, 
	34, 46, 13, 34, 46, 58, 93, 48, 
	57, 65, 70, 97, 102, 13, 34, 46, 
	58, 93, 48, 57, 65, 70, 97, 102, 
	13, 34, 58, 93, 48, 57, 65, 70, 
	97, 102, 13, 34, 58, 93, 48, 57, 
	65, 70, 97, 102, 13, 34, 58, 93, 
	48, 57, 65, 70, 97, 102, 13, 34, 
	58, 93, 48, 57, 65, 70, 97, 102, 
	13, 34, 58, 93, 13, 34, 48, 57, 
	65, 70, 97, 102, 13, 34, 46, 58, 
	93, 48, 57, 65, 70, 97, 102, 13, 
	34, 46, 58, 93, 48, 57, 65, 70, 
	97, 102, 13, 34, 46, 58, 93, 48, 
	57, 65, 70, 97, 102, 13, 34, 48, 
	57, 13, 34, 46, 48, 57, 13, 34, 
	46, 48, 57, 13, 34, 46, 13, 34, 
	58, 10, 13, 34, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 79, 111, 126, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	61, 80, 112, 126, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 126, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 34, 44, 61, 10, 13, 34, 9, 
	13, 32, 34, 44, 61, 9, 13, 32, 
	33, 34, 37, 39, 91, 126, 42, 43, 
	45, 46, 48, 57, 65, 90, 95, 122, 
	10, 13, 34, 9, 13, 32, 33, 34, 
	37, 39, 91, 126, 42, 43, 45, 46, 
	48, 57, 65, 90, 95, 122, 10, 13, 
	34, 9, 13, 32, 34, 9, 13, 32, 
	34, 44, 92, 127, 0, 31, 9, 13, 
	32, 34, 44, 92, 127, 0, 31, 10, 
	13, 34, 9, 13, 32, 34, 44, 92, 
	127, 0, 31, 10, 13, 34, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 69, 
	101, 126, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 65, 97, 126, 42, 46, 
	48, 57, 66, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 76, 
	108, 126, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 77, 109, 126, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 126, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 34, 44, 61, 10, 13, 
	34, 9, 13, 32, 34, 44, 61, 9, 
	13, 32, 33, 34, 37, 39, 91, 126, 
	42, 43, 45, 46, 48, 57, 65, 90, 
	95, 122, 10, 13, 34, 9, 13, 32, 
	33, 34, 37, 39, 91, 126, 42, 43, 
	45, 46, 48, 57, 65, 90, 95, 122, 
	10, 13, 34, 9, 13, 32, 34, 10, 
	13, 34, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 84, 116, 126, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 65, 
	97, 126, 42, 46, 48, 57, 66, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 76, 108, 126, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 69, 
	101, 126, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 126, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 34, 
	44, 61, 10, 13, 34, 9, 13, 32, 
	34, 44, 61, 9, 13, 32, 33, 34, 
	37, 39, 70, 84, 91, 102, 116, 126, 
	42, 43, 45, 46, 48, 57, 65, 90, 
	95, 122, 10, 13, 34, 9, 13, 32, 
	33, 34, 37, 39, 70, 84, 91, 102, 
	116, 126, 42, 43, 45, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 65, 97, 126, 42, 
	46, 48, 57, 66, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 76, 
	108, 126, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 83, 115, 126, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 69, 101, 126, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 34, 44, 9, 13, 32, 
	33, 34, 37, 39, 44, 82, 114, 126, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	85, 117, 126, 42, 46, 48, 57, 65, 
	90, 95, 122, 10, 13, 34, 10, 13, 
	34, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 71, 103, 126, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 79, 111, 
	126, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 82, 114, 126, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 73, 105, 
	126, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 84, 116, 126, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 72, 104, 
	126, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 77, 109, 126, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 126, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 34, 44, 61, 10, 13, 34, 
	9, 13, 32, 34, 44, 61, 9, 13, 
	32, 33, 34, 37, 39, 91, 126, 42, 
	43, 45, 46, 48, 57, 65, 90, 95, 
	122, 10, 13, 34, 9, 13, 32, 33, 
	34, 37, 39, 91, 126, 42, 43, 45, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 126, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	10, 13, 34, 13, 34, 58, 92, 127, 
	0, 8, 10, 31, 48, 57, 65, 70, 
	97, 102, 13, 34, 58, 92, 93, 127, 
	0, 8, 10, 31, 48, 57, 65, 70, 
	97, 102, 13, 34, 58, 92, 93, 127, 
	0, 8, 10, 31, 48, 57, 65, 70, 
	97, 102, 13, 34, 58, 92, 93, 127, 
	0, 8, 10, 31, 48, 57, 65, 70, 
	97, 102, 13, 34, 58, 92, 93, 127, 
	0, 8, 10, 31, 13, 34, 58, 92, 
	127, 0, 8, 10, 31, 48, 57, 65, 
	70, 97, 102, 13, 34, 46, 58, 92, 
	93, 127, 0, 8, 10, 31, 48, 57, 
	65, 70, 97, 102, 13, 34, 92, 127, 
	0, 8, 10, 31, 48, 57, 13, 34, 
	46, 92, 127, 0, 8, 10, 31, 48, 
	57, 13, 34, 92, 127, 0, 8, 10, 
	31, 48, 57, 13, 34, 46, 92, 127, 
	0, 8, 10, 31, 48, 57, 13, 34, 
	92, 127, 0, 8, 10, 31, 48, 57, 
	13, 34, 92, 93, 127, 0, 8, 10, 
	31, 48, 57, 13, 34, 92, 93, 127, 
	0, 8, 10, 31, 48, 57, 13, 34, 
	92, 93, 127, 0, 8, 10, 31, 9, 
	13, 32, 34, 44, 92, 127, 0, 31, 
	13, 34, 46, 92, 127, 0, 8, 10, 
	31, 48, 57, 13, 34, 46, 92, 127, 
	0, 8, 10, 31, 13, 34, 46, 92, 
	127, 0, 8, 10, 31, 48, 57, 13, 
	34, 46, 92, 127, 0, 8, 10, 31, 
	13, 34, 46, 58, 92, 93, 127, 0, 
	8, 10, 31, 48, 57, 65, 70, 97, 
	102, 13, 34, 46, 58, 92, 93, 127, 
	0, 8, 10, 31, 48, 57, 65, 70, 
	97, 102, 13, 34, 58, 92, 93, 127, 
	0, 8, 10, 31, 48, 57, 65, 70, 
	97, 102, 13, 34, 58, 92, 93, 127, 
	0, 8, 10, 31, 48, 57, 65, 70, 
	97, 102, 13, 34, 58, 92, 93, 127, 
	0, 8, 10, 31, 48, 57, 65, 70, 
	97, 102, 13, 34, 58, 92, 93, 127, 
	0, 8, 10, 31, 48, 57, 65, 70, 
	97, 102, 13, 34, 58, 92, 93, 127, 
	0, 8, 10, 31, 13, 34, 92, 127, 
	0, 8, 10, 31, 48, 57, 65, 70, 
	97, 102, 13, 34, 46, 58, 92, 93, 
	127, 0, 8, 10, 31, 48, 57, 65, 
	70, 97, 102, 13, 34, 46, 58, 92, 
	93, 127, 0, 8, 10, 31, 48, 57, 
	65, 70, 97, 102, 13, 34, 46, 58, 
	92, 93, 127, 0, 8, 10, 31, 48, 
	57, 65, 70, 97, 102, 13, 34, 92, 
	127, 0, 8, 10, 31, 48, 57, 13, 
	34, 46, 92, 127, 0, 8, 10, 31, 
	48, 57, 13, 34, 46, 92, 127, 0, 
	8, 10, 31, 48, 57, 13, 34, 46, 
	92, 127, 0, 8, 10, 31, 13, 34, 
	58, 92, 127, 0, 8, 10, 31, 10, 
	13, 34, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 76, 92, 108, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 71, 92, 103, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 79, 92, 111, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 82, 92, 114, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 73, 92, 105, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 84, 92, 116, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 72, 92, 104, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 77, 92, 109, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 92, 126, 127, 0, 31, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 34, 44, 61, 92, 127, 
	0, 31, 10, 13, 34, 9, 13, 32, 
	34, 44, 61, 92, 127, 0, 31, 9, 
	13, 32, 33, 34, 37, 39, 91, 92, 
	126, 127, 0, 31, 42, 43, 45, 46, 
	48, 57, 65, 90, 95, 122, 10, 13, 
	34, 9, 13, 32, 33, 34, 37, 39, 
	91, 92, 126, 127, 0, 31, 42, 43, 
	45, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	92, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 10, 13, 34, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	61, 79, 92, 111, 126, 127, 0, 31, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	61, 77, 92, 109, 126, 127, 0, 31, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	61, 65, 92, 97, 126, 127, 0, 31, 
	42, 46, 48, 57, 66, 90, 95, 122, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	61, 73, 92, 105, 126, 127, 0, 31, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	61, 78, 92, 110, 126, 127, 0, 31, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	61, 92, 126, 127, 0, 31, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 34, 44, 61, 92, 127, 0, 31, 
	10, 13, 34, 9, 13, 32, 34, 44, 
	61, 92, 127, 0, 31, 9, 13, 32, 
	33, 34, 37, 39, 91, 92, 126, 127, 
	0, 31, 42, 43, 45, 46, 48, 57, 
	65, 90, 95, 122, 10, 13, 34, 9, 
	13, 32, 33, 34, 37, 39, 91, 92, 
	126, 127, 0, 31, 42, 43, 45, 46, 
	48, 57, 65, 90, 95, 122, 10, 13, 
	34, 9, 13, 32, 34, 92, 127, 0, 
	31, 10, 13, 34, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 79, 92, 111, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 78, 92, 110, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 67, 92, 99, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 69, 92, 101, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 92, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 34, 44, 61, 
	92, 127, 0, 31, 10, 13, 34, 9, 
	13, 32, 34, 44, 61, 92, 127, 0, 
	31, 9, 13, 32, 33, 34, 37, 39, 
	91, 92, 126, 127, 0, 31, 42, 43, 
	45, 46, 48, 57, 65, 90, 95, 122, 
	10, 13, 34, 9, 13, 32, 33, 34, 
	37, 39, 91, 92, 126, 127, 0, 31, 
	42, 43, 45, 46, 48, 57, 65, 90, 
	95, 122, 10, 13, 34, 9, 13, 32, 
	34, 92, 127, 0, 31, 10, 13, 34, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	61, 80, 92, 112, 126, 127, 0, 31, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	61, 65, 92, 97, 126, 127, 0, 31, 
	42, 46, 48, 57, 66, 90, 95, 122, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	61, 81, 92, 113, 126, 127, 0, 31, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	61, 85, 92, 117, 126, 127, 0, 31, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	61, 69, 92, 101, 126, 127, 0, 31, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	61, 92, 126, 127, 0, 31, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 34, 44, 61, 92, 127, 0, 31, 
	10, 13, 34, 9, 13, 32, 34, 44, 
	61, 92, 127, 0, 31, 9, 13, 32, 
	33, 34, 37, 39, 91, 92, 126, 127, 
	0, 31, 42, 43, 45, 46, 48, 57, 
	65, 90, 95, 122, 10, 13, 34, 9, 
	13, 32, 33, 34, 37, 39, 91, 92, 
	126, 127, 0, 31, 42, 43, 45, 46, 
	48, 57, 65, 90, 95, 122, 10, 13, 
	34, 9, 13, 32, 34, 92, 127, 0, 
	31, 10, 13, 34, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 79, 92, 111, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 80, 92, 112, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 92, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 34, 44, 61, 
	92, 127, 0, 31, 10, 13, 34, 9, 
	13, 32, 34, 44, 61, 92, 127, 0, 
	31, 9, 13, 32, 33, 34, 37, 39, 
	91, 92, 126, 127, 0, 31, 42, 43, 
	45, 46, 48, 57, 65, 90, 95, 122, 
	10, 13, 34, 9, 13, 32, 33, 34, 
	37, 39, 91, 92, 126, 127, 0, 31, 
	42, 43, 45, 46, 48, 57, 65, 90, 
	95, 122, 10, 13, 34, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 69, 92, 
	101, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 65, 92, 
	97, 126, 127, 0, 31, 42, 46, 48, 
	57, 66, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 76, 92, 
	108, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 77, 92, 
	109, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 92, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 34, 44, 
	61, 92, 127, 0, 31, 10, 13, 34, 
	9, 13, 32, 34, 44, 61, 92, 127, 
	0, 31, 9, 13, 32, 33, 34, 37, 
	39, 91, 92, 126, 127, 0, 31, 42, 
	43, 45, 46, 48, 57, 65, 90, 95, 
	122, 10, 13, 34, 9, 13, 32, 33, 
	34, 37, 39, 91, 92, 126, 127, 0, 
	31, 42, 43, 45, 46, 48, 57, 65, 
	90, 95, 122, 10, 13, 34, 9, 13, 
	32, 34, 92, 127, 0, 31, 10, 13, 
	34, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 84, 92, 116, 126, 127, 0, 
	31, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 65, 92, 97, 126, 127, 0, 
	31, 42, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 76, 92, 108, 126, 127, 0, 
	31, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 69, 92, 101, 126, 127, 0, 
	31, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 92, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 34, 44, 61, 92, 127, 0, 
	31, 10, 13, 34, 9, 13, 32, 34, 
	44, 61, 92, 127, 0, 31, 9, 13, 
	32, 33, 34, 37, 39, 70, 84, 91, 
	92, 102, 116, 126, 127, 0, 31, 42, 
	43, 45, 46, 48, 57, 65, 90, 95, 
	122, 10, 13, 34, 9, 13, 32, 33, 
	34, 37, 39, 70, 84, 91, 92, 102, 
	116, 126, 127, 0, 31, 42, 43, 45, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 65, 
	92, 97, 126, 127, 0, 31, 42, 46, 
	48, 57, 66, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 76, 92, 
	108, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 83, 92, 115, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 69, 92, 101, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 34, 44, 
	92, 127, 0, 31, 9, 13, 32, 33, 
	34, 37, 39, 44, 82, 92, 114, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 85, 92, 117, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 10, 13, 34, 10, 13, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	69, 92, 101, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	65, 92, 97, 126, 127, 0, 31, 42, 
	46, 48, 57, 66, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	76, 92, 108, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	77, 92, 109, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	92, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	34, 44, 61, 92, 127, 0, 31, 10, 
	13, 9, 13, 32, 34, 44, 61, 92, 
	127, 0, 31, 9, 13, 32, 33, 34, 
	37, 39, 91, 92, 126, 127, 0, 31, 
	42, 43, 45, 46, 48, 57, 65, 90, 
	95, 122, 10, 13, 9, 13, 32, 33, 
	34, 37, 39, 91, 92, 126, 127, 0, 
	31, 42, 43, 45, 46, 48, 57, 65, 
	90, 95, 122, 10, 13, 9, 13, 32, 
	34, 92, 127, 0, 31, 9, 13, 32, 
	34, 44, 92, 127, 0, 31, 10, 13, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	61, 84, 92, 116, 126, 127, 0, 31, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	61, 65, 92, 97, 126, 127, 0, 31, 
	42, 46, 48, 57, 66, 90, 95, 122, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	61, 76, 92, 108, 126, 127, 0, 31, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	61, 69, 92, 101, 126, 127, 0, 31, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	61, 92, 126, 127, 0, 31, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 34, 44, 61, 92, 127, 0, 31, 
	10, 13, 9, 13, 32, 34, 44, 61, 
	92, 127, 0, 31, 9, 13, 32, 33, 
	34, 37, 39, 70, 84, 91, 92, 102, 
	116, 126, 127, 0, 31, 42, 43, 45, 
	46, 48, 57, 65, 90, 95, 122, 10, 
	13, 9, 13, 32, 33, 34, 37, 39, 
	70, 84, 91, 92, 102, 116, 126, 127, 
	0, 31, 42, 43, 45, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 65, 92, 97, 126, 
	127, 0, 31, 42, 46, 48, 57, 66, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 76, 92, 108, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 83, 92, 115, 126, 127, 0, 
	31, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 69, 92, 101, 126, 127, 0, 31, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 34, 44, 92, 127, 0, 
	31, 9, 13, 32, 33, 34, 37, 39, 
	44, 82, 92, 114, 126, 127, 0, 31, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	85, 92, 117, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 10, 
	13, 10, 13, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 79, 92, 111, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 80, 92, 112, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 92, 126, 127, 0, 
	31, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 34, 44, 61, 92, 
	127, 0, 31, 10, 13, 9, 13, 32, 
	34, 44, 61, 92, 127, 0, 31, 9, 
	13, 32, 33, 34, 37, 39, 91, 92, 
	126, 127, 0, 31, 42, 43, 45, 46, 
	48, 57, 65, 90, 95, 122, 10, 13, 
	9, 13, 32, 33, 34, 37, 39, 91, 
	92, 126, 127, 0, 31, 42, 43, 45, 
	46, 48, 57, 65, 90, 95, 122, 10, 
	13, 9, 13, 32, 34, 92, 127, 0, 
	31, 9, 13, 32, 34, 44, 92, 127, 
	0, 31, 10, 13, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 69, 92, 101, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 65, 92, 97, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	66, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 76, 92, 108, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 77, 92, 109, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 92, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 34, 44, 61, 
	92, 127, 0, 31, 10, 13, 9, 13, 
	32, 34, 44, 61, 92, 127, 0, 31, 
	9, 13, 32, 33, 34, 37, 39, 91, 
	92, 126, 127, 0, 31, 42, 43, 45, 
	46, 48, 57, 65, 90, 95, 122, 10, 
	13, 9, 13, 32, 33, 34, 37, 39, 
	91, 92, 126, 127, 0, 31, 42, 43, 
	45, 46, 48, 57, 65, 90, 95, 122, 
	10, 13, 9, 13, 32, 34, 92, 127, 
	0, 31, 9, 13, 32, 34, 44, 92, 
	127, 0, 31, 10, 13, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 84, 92, 
	116, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 65, 92, 
	97, 126, 127, 0, 31, 42, 46, 48, 
	57, 66, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 76, 92, 
	108, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 69, 92, 
	101, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 92, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 34, 44, 
	61, 92, 127, 0, 31, 10, 13, 9, 
	13, 32, 34, 44, 61, 92, 127, 0, 
	31, 9, 13, 32, 33, 34, 37, 39, 
	70, 84, 91, 92, 102, 116, 126, 127, 
	0, 31, 42, 43, 45, 46, 48, 57, 
	65, 90, 95, 122, 10, 13, 9, 13, 
	32, 33, 34, 37, 39, 70, 84, 91, 
	92, 102, 116, 126, 127, 0, 31, 42, 
	43, 45, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 65, 92, 97, 126, 127, 0, 31, 
	42, 46, 48, 57, 66, 90, 95, 122, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	76, 92, 108, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 83, 
	92, 115, 126, 127, 0, 31, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 69, 92, 
	101, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	34, 44, 92, 127, 0, 31, 9, 13, 
	32, 33, 34, 37, 39, 44, 82, 92, 
	114, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 85, 92, 117, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 10, 13, 10, 13, 
	34, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 77, 109, 126, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 65, 97, 
	126, 42, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 73, 105, 126, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 78, 110, 
	126, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 126, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 34, 44, 
	61, 10, 13, 34, 9, 13, 32, 34, 
	44, 61, 9, 13, 32, 33, 34, 37, 
	39, 91, 126, 42, 43, 45, 46, 48, 
	57, 65, 90, 95, 122, 10, 13, 34, 
	9, 13, 32, 33, 34, 37, 39, 91, 
	126, 42, 43, 45, 46, 48, 57, 65, 
	90, 95, 122, 10, 13, 34, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 71, 
	103, 126, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 79, 111, 126, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 82, 
	114, 126, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 73, 105, 126, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 84, 
	116, 126, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 72, 104, 126, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 77, 
	109, 126, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 126, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 34, 
	44, 61, 10, 13, 34, 9, 13, 32, 
	34, 44, 61, 9, 13, 32, 33, 34, 
	37, 39, 91, 126, 42, 43, 45, 46, 
	48, 57, 65, 90, 95, 122, 10, 13, 
	34, 9, 13, 32, 33, 34, 37, 39, 
	91, 126, 42, 43, 45, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 126, 42, 46, 48, 
	57, 65, 90, 95, 122, 10, 13, 34, 
	13, 34, 58, 92, 127, 0, 8, 10, 
	31, 48, 57, 65, 70, 97, 102, 13, 
	34, 58, 92, 93, 127, 0, 8, 10, 
	31, 48, 57, 65, 70, 97, 102, 13, 
	34, 58, 92, 93, 127, 0, 8, 10, 
	31, 48, 57, 65, 70, 97, 102, 13, 
	34, 58, 92, 93, 127, 0, 8, 10, 
	31, 48, 57, 65, 70, 97, 102, 13, 
	34, 58, 92, 93, 127, 0, 8, 10, 
	31, 13, 34, 58, 92, 127, 0, 8, 
	10, 31, 48, 57, 65, 70, 97, 102, 
	13, 34, 46, 58, 92, 93, 127, 0, 
	8, 10, 31, 48, 57, 65, 70, 97, 
	102, 13, 34, 92, 127, 0, 8, 10, 
	31, 48, 57, 13, 34, 46, 92, 127, 
	0, 8, 10, 31, 48, 57, 13, 34, 
	92, 127, 0, 8, 10, 31, 48, 57, 
	13, 34, 46, 92, 127, 0, 8, 10, 
	31, 48, 57, 13, 34, 92, 127, 0, 
	8, 10, 31, 48, 57, 13, 34, 92, 
	93, 127, 0, 8, 10, 31, 48, 57, 
	13, 34, 92, 93, 127, 0, 8, 10, 
	31, 48, 57, 13, 34, 92, 93, 127, 
	0, 8, 10, 31, 9, 13, 32, 34, 
	44, 92, 127, 0, 31, 13, 34, 46, 
	92, 127, 0, 8, 10, 31, 48, 57, 
	13, 34, 46, 92, 127, 0, 8, 10, 
	31, 13, 34, 46, 92, 127, 0, 8, 
	10, 31, 48, 57, 13, 34, 46, 92, 
	127, 0, 8, 10, 31, 13, 34, 46, 
	58, 92, 93, 127, 0, 8, 10, 31, 
	48, 57, 65, 70, 97, 102, 13, 34, 
	46, 58, 92, 93, 127, 0, 8, 10, 
	31, 48, 57, 65, 70, 97, 102, 13, 
	34, 58, 92, 93, 127, 0, 8, 10, 
	31, 48, 57, 65, 70, 97, 102, 13, 
	34, 58, 92, 93, 127, 0, 8, 10, 
	31, 48, 57, 65, 70, 97, 102, 13, 
	34, 58, 92, 93, 127, 0, 8, 10, 
	31, 48, 57, 65, 70, 97, 102, 13, 
	34, 58, 92, 93, 127, 0, 8, 10, 
	31, 48, 57, 65, 70, 97, 102, 13, 
	34, 58, 92, 93, 127, 0, 8, 10, 
	31, 13, 34, 92, 127, 0, 8, 10, 
	31, 48, 57, 65, 70, 97, 102, 13, 
	34, 46, 58, 92, 93, 127, 0, 8, 
	10, 31, 48, 57, 65, 70, 97, 102, 
	13, 34, 46, 58, 92, 93, 127, 0, 
	8, 10, 31, 48, 57, 65, 70, 97, 
	102, 13, 34, 46, 58, 92, 93, 127, 
	0, 8, 10, 31, 48, 57, 65, 70, 
	97, 102, 13, 34, 92, 127, 0, 8, 
	10, 31, 48, 57, 13, 34, 46, 92, 
	127, 0, 8, 10, 31, 48, 57, 13, 
	34, 46, 92, 127, 0, 8, 10, 31, 
	48, 57, 13, 34, 46, 92, 127, 0, 
	8, 10, 31, 13, 34, 58, 92, 127, 
	0, 8, 10, 31, 10, 13, 34, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	76, 92, 108, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	71, 92, 103, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	79, 92, 111, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	82, 92, 114, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	73, 92, 105, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	84, 92, 116, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	72, 92, 104, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	77, 92, 109, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	92, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	34, 44, 61, 92, 127, 0, 31, 10, 
	13, 34, 9, 13, 32, 34, 44, 61, 
	92, 127, 0, 31, 9, 13, 32, 33, 
	34, 37, 39, 91, 92, 126, 127, 0, 
	31, 42, 43, 45, 46, 48, 57, 65, 
	90, 95, 122, 10, 13, 34, 9, 13, 
	32, 33, 34, 37, 39, 91, 92, 126, 
	127, 0, 31, 42, 43, 45, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 92, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 10, 13, 34, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 79, 92, 
	111, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 77, 92, 
	109, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 65, 92, 
	97, 126, 127, 0, 31, 42, 46, 48, 
	57, 66, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 73, 92, 
	105, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 78, 92, 
	110, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 92, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 34, 44, 
	61, 92, 127, 0, 31, 10, 13, 34, 
	9, 13, 32, 34, 44, 61, 92, 127, 
	0, 31, 9, 13, 32, 33, 34, 37, 
	39, 91, 92, 126, 127, 0, 31, 42, 
	43, 45, 46, 48, 57, 65, 90, 95, 
	122, 10, 13, 34, 9, 13, 32, 33, 
	34, 37, 39, 91, 92, 126, 127, 0, 
	31, 42, 43, 45, 46, 48, 57, 65, 
	90, 95, 122, 10, 13, 34, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 79, 
	92, 111, 126, 127, 0, 31, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 78, 
	92, 110, 126, 127, 0, 31, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 67, 
	92, 99, 126, 127, 0, 31, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 69, 
	92, 101, 126, 127, 0, 31, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 92, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 34, 
	44, 61, 92, 127, 0, 31, 10, 13, 
	34, 9, 13, 32, 34, 44, 61, 92, 
	127, 0, 31, 9, 13, 32, 33, 34, 
	37, 39, 91, 92, 126, 127, 0, 31, 
	42, 43, 45, 46, 48, 57, 65, 90, 
	95, 122, 10, 13, 34, 9, 13, 32, 
	33, 34, 37, 39, 91, 92, 126, 127, 
	0, 31, 42, 43, 45, 46, 48, 57, 
	65, 90, 95, 122, 10, 13, 34, 9, 
	13, 32, 34, 92, 127, 0, 31, 10, 
	13, 34, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 80, 92, 112, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 65, 92, 97, 126, 127, 
	0, 31, 42, 46, 48, 57, 66, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 81, 92, 113, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 85, 92, 117, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 69, 92, 101, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 92, 126, 127, 0, 31, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 34, 44, 61, 92, 127, 
	0, 31, 10, 13, 34, 9, 13, 32, 
	34, 44, 61, 92, 127, 0, 31, 9, 
	13, 32, 33, 34, 37, 39, 91, 92, 
	126, 127, 0, 31, 42, 43, 45, 46, 
	48, 57, 65, 90, 95, 122, 10, 13, 
	34, 9, 13, 32, 33, 34, 37, 39, 
	91, 92, 126, 127, 0, 31, 42, 43, 
	45, 46, 48, 57, 65, 90, 95, 122, 
	10, 13, 34, 9, 13, 32, 34, 92, 
	127, 0, 31, 10, 13, 34, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 79, 
	92, 111, 126, 127, 0, 31, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 80, 
	92, 112, 126, 127, 0, 31, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 92, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 34, 
	44, 61, 92, 127, 0, 31, 10, 13, 
	34, 9, 13, 32, 34, 44, 61, 92, 
	127, 0, 31, 9, 13, 32, 33, 34, 
	37, 39, 91, 92, 126, 127, 0, 31, 
	42, 43, 45, 46, 48, 57, 65, 90, 
	95, 122, 10, 13, 34, 9, 13, 32, 
	33, 34, 37, 39, 91, 92, 126, 127, 
	0, 31, 42, 43, 45, 46, 48, 57, 
	65, 90, 95, 122, 10, 13, 34, 9, 
	13, 32, 34, 92, 127, 0, 31, 10, 
	13, 34, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 69, 92, 101, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 65, 92, 97, 126, 127, 
	0, 31, 42, 46, 48, 57, 66, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 76, 92, 108, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 77, 92, 109, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 92, 126, 127, 0, 31, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 34, 44, 61, 92, 127, 
	0, 31, 10, 13, 34, 9, 13, 32, 
	34, 44, 61, 92, 127, 0, 31, 9, 
	13, 32, 33, 34, 37, 39, 91, 92, 
	126, 127, 0, 31, 42, 43, 45, 46, 
	48, 57, 65, 90, 95, 122, 10, 13, 
	34, 9, 13, 32, 33, 34, 37, 39, 
	91, 92, 126, 127, 0, 31, 42, 43, 
	45, 46, 48, 57, 65, 90, 95, 122, 
	10, 13, 34, 9, 13, 32, 34, 92, 
	127, 0, 31, 10, 13, 34, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 84, 
	92, 116, 126, 127, 0, 31, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 65, 
	92, 97, 126, 127, 0, 31, 42, 46, 
	48, 57, 66, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 76, 
	92, 108, 126, 127, 0, 31, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 69, 
	92, 101, 126, 127, 0, 31, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 92, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 34, 
	44, 61, 92, 127, 0, 31, 10, 13, 
	34, 9, 13, 32, 34, 44, 61, 92, 
	127, 0, 31, 9, 13, 32, 33, 34, 
	37, 39, 70, 84, 91, 92, 102, 116, 
	126, 127, 0, 31, 42, 43, 45, 46, 
	48, 57, 65, 90, 95, 122, 10, 13, 
	34, 9, 13, 32, 33, 34, 37, 39, 
	70, 84, 91, 92, 102, 116, 126, 127, 
	0, 31, 42, 43, 45, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 65, 92, 97, 126, 
	127, 0, 31, 42, 46, 48, 57, 66, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 76, 92, 108, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 83, 92, 115, 126, 127, 0, 
	31, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 69, 92, 101, 126, 127, 0, 31, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 34, 44, 92, 127, 0, 
	31, 9, 13, 32, 33, 34, 37, 39, 
	44, 82, 92, 114, 126, 127, 0, 31, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	85, 92, 117, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 10, 
	13, 34, 10, 13, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 79, 92, 111, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 78, 92, 110, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 67, 92, 99, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 69, 92, 101, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 92, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 34, 44, 61, 
	92, 127, 0, 31, 10, 13, 9, 13, 
	32, 34, 44, 61, 92, 127, 0, 31, 
	9, 13, 32, 33, 34, 37, 39, 91, 
	92, 126, 127, 0, 31, 42, 43, 45, 
	46, 48, 57, 65, 90, 95, 122, 10, 
	13, 9, 13, 32, 33, 34, 37, 39, 
	91, 92, 126, 127, 0, 31, 42, 43, 
	45, 46, 48, 57, 65, 90, 95, 122, 
	10, 13, 9, 13, 32, 34, 92, 127, 
	0, 31, 10, 13, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 80, 92, 112, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 65, 92, 97, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	66, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 81, 92, 113, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 85, 92, 117, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 69, 92, 101, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 92, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 34, 44, 61, 
	92, 127, 0, 31, 10, 13, 9, 13, 
	32, 34, 44, 61, 92, 127, 0, 31, 
	9, 13, 32, 33, 34, 37, 39, 91, 
	92, 126, 127, 0, 31, 42, 43, 45, 
	46, 48, 57, 65, 90, 95, 122, 10, 
	13, 9, 13, 32, 33, 34, 37, 39, 
	91, 92, 126, 127, 0, 31, 42, 43, 
	45, 46, 48, 57, 65, 90, 95, 122, 
	10, 13, 9, 13, 32, 34, 92, 127, 
	0, 31, 10, 13, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 79, 92, 111, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 80, 92, 112, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 92, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 34, 44, 61, 
	92, 127, 0, 31, 10, 13, 9, 13, 
	32, 34, 44, 61, 92, 127, 0, 31, 
	9, 13, 32, 33, 34, 37, 39, 91, 
	92, 126, 127, 0, 31, 42, 43, 45, 
	46, 48, 57, 65, 90, 95, 122, 10, 
	13, 9, 13, 32, 33, 34, 37, 39, 
	91, 92, 126, 127, 0, 31, 42, 43, 
	45, 46, 48, 57, 65, 90, 95, 122, 
	10, 13, 9, 13, 32, 34, 92, 127, 
	0, 31, 9, 13, 32, 34, 44, 92, 
	127, 0, 31, 10, 13, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 69, 92, 
	101, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 65, 92, 
	97, 126, 127, 0, 31, 42, 46, 48, 
	57, 66, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 76, 92, 
	108, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 77, 92, 
	109, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 92, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 34, 44, 
	61, 92, 127, 0, 31, 10, 13, 9, 
	13, 32, 34, 44, 61, 92, 127, 0, 
	31, 9, 13, 32, 33, 34, 37, 39, 
	91, 92, 126, 127, 0, 31, 42, 43, 
	45, 46, 48, 57, 65, 90, 95, 122, 
	10, 13, 9, 13, 32, 33, 34, 37, 
	39, 91, 92, 126, 127, 0, 31, 42, 
	43, 45, 46, 48, 57, 65, 90, 95, 
	122, 10, 13, 9, 13, 32, 34, 92, 
	127, 0, 31, 10, 13, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 84, 92, 
	116, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 65, 92, 
	97, 126, 127, 0, 31, 42, 46, 48, 
	57, 66, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 76, 92, 
	108, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 69, 92, 
	101, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 92, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 34, 44, 
	61, 92, 127, 0, 31, 10, 13, 9, 
	13, 32, 34, 44, 61, 92, 127, 0, 
	31, 9, 13, 32, 33, 34, 37, 39, 
	70, 84, 91, 92, 102, 116, 126, 127, 
	0, 31, 42, 43, 45, 46, 48, 57, 
	65, 90, 95, 122, 10, 13, 9, 13, 
	32, 33, 34, 37, 39, 70, 84, 91, 
	92, 102, 116, 126, 127, 0, 31, 42, 
	43, 45, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 65, 92, 97, 126, 127, 0, 31, 
	42, 46, 48, 57, 66, 90, 95, 122, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	76, 92, 108, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 83, 
	92, 115, 126, 127, 0, 31, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 69, 92, 
	101, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	34, 44, 92, 127, 0, 31, 9, 13, 
	32, 33, 34, 37, 39, 44, 82, 92, 
	114, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 85, 92, 117, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 10, 13, 10, 13, 
	9, 13, 32, 33, 37, 39, 44, 61, 
	77, 109, 126, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 37, 
	39, 44, 61, 65, 97, 126, 42, 46, 
	48, 57, 66, 90, 95, 122, 9, 13, 
	32, 33, 37, 39, 44, 61, 73, 105, 
	126, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 37, 39, 44, 
	61, 78, 110, 126, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	37, 39, 44, 61, 126, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	44, 61, 10, 13, 9, 13, 32, 44, 
	61, 9, 13, 32, 33, 34, 37, 39, 
	91, 126, 42, 43, 45, 46, 48, 57, 
	65, 90, 95, 122, 10, 13, 9, 13, 
	32, 33, 34, 37, 39, 91, 126, 42, 
	43, 45, 46, 48, 57, 65, 90, 95, 
	122, 10, 13, 9, 13, 32, 34, 13, 
	34, 92, 127, 0, 8, 10, 31, 10, 
	13, 9, 13, 32, 33, 37, 39, 44, 
	61, 71, 103, 126, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	37, 39, 44, 61, 79, 111, 126, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 37, 39, 44, 61, 82, 
	114, 126, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 37, 39, 
	44, 61, 73, 105, 126, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 37, 39, 44, 61, 84, 116, 126, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 33, 37, 39, 44, 61, 
	72, 104, 126, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 37, 
	39, 44, 61, 77, 109, 126, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 37, 39, 44, 61, 126, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 44, 61, 10, 13, 9, 13, 
	32, 44, 61, 9, 13, 32, 33, 34, 
	37, 39, 91, 126, 42, 43, 45, 46, 
	48, 57, 65, 90, 95, 122, 10, 13, 
	9, 13, 32, 33, 34, 37, 39, 91, 
	126, 42, 43, 45, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 37, 
	39, 44, 126, 42, 46, 48, 57, 65, 
	90, 95, 122, 10, 13, 9, 13, 32, 
	33, 37, 39, 44, 61, 79, 111, 126, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 33, 37, 39, 44, 61, 
	77, 109, 126, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 37, 
	39, 44, 61, 65, 97, 126, 42, 46, 
	48, 57, 66, 90, 95, 122, 9, 13, 
	32, 33, 37, 39, 44, 61, 73, 105, 
	126, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 37, 39, 44, 
	61, 78, 110, 126, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	37, 39, 44, 61, 126, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	44, 61, 10, 13, 9, 13, 32, 44, 
	61, 9, 13, 32, 33, 34, 37, 39, 
	91, 126, 42, 43, 45, 46, 48, 57, 
	65, 90, 95, 122, 10, 13, 9, 13, 
	32, 33, 34, 37, 39, 91, 126, 42, 
	43, 45, 46, 48, 57, 65, 90, 95, 
	122, 10, 13, 9, 13, 32, 34, 13, 
	34, 92, 127, 0, 8, 10, 31, 13, 
	34, 92, 127, 0, 8, 10, 31, 10, 
	13, 34, 13, 34, 0, 9, 11, 127, 
	9, 13, 32, 34, 44, 92, 127, 0, 
	31, 10, 13, 9, 13, 32, 34, 44, 
	92, 127, 0, 31, 10, 13, 9, 13, 
	32, 34, 44, 92, 127, 0, 31, 9, 
	13, 32, 33, 34, 37, 39, 65, 68, 
	78, 79, 81, 82, 83, 92, 97, 100, 
	110, 111, 113, 114, 115, 126, 127, 0, 
	31, 42, 43, 45, 46, 48, 57, 66, 
	90, 95, 122, 10, 13, 9, 13, 32, 
	33, 34, 37, 39, 65, 68, 78, 79, 
	81, 82, 83, 92, 97, 100, 110, 111, 
	113, 114, 115, 126, 127, 0, 31, 42, 
	43, 45, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 61, 92, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 34, 44, 61, 92, 127, 0, 
	31, 10, 13, 9, 13, 32, 34, 44, 
	61, 92, 127, 0, 31, 9, 13, 32, 
	33, 34, 37, 39, 91, 92, 126, 127, 
	0, 31, 42, 43, 45, 46, 48, 57, 
	65, 90, 95, 122, 10, 13, 9, 13, 
	32, 33, 34, 37, 39, 91, 92, 126, 
	127, 0, 31, 42, 43, 45, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 92, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 34, 44, 92, 
	127, 0, 31, 10, 13, 13, 34, 58, 
	92, 127, 0, 8, 10, 31, 48, 57, 
	65, 70, 97, 102, 13, 34, 58, 92, 
	93, 127, 0, 8, 10, 31, 48, 57, 
	65, 70, 97, 102, 13, 34, 58, 92, 
	93, 127, 0, 8, 10, 31, 48, 57, 
	65, 70, 97, 102, 13, 34, 58, 92, 
	93, 127, 0, 8, 10, 31, 48, 57, 
	65, 70, 97, 102, 13, 34, 58, 92, 
	93, 127, 0, 8, 10, 31, 13, 34, 
	58, 92, 127, 0, 8, 10, 31, 48, 
	57, 65, 70, 97, 102, 13, 34, 46, 
	58, 92, 93, 127, 0, 8, 10, 31, 
	48, 57, 65, 70, 97, 102, 13, 34, 
	92, 127, 0, 8, 10, 31, 48, 57, 
	13, 34, 46, 92, 127, 0, 8, 10, 
	31, 48, 57, 13, 34, 92, 127, 0, 
	8, 10, 31, 48, 57, 13, 34, 46, 
	92, 127, 0, 8, 10, 31, 48, 57, 
	13, 34, 92, 127, 0, 8, 10, 31, 
	48, 57, 13, 34, 92, 93, 127, 0, 
	8, 10, 31, 48, 57, 13, 34, 92, 
	93, 127, 0, 8, 10, 31, 48, 57, 
	13, 34, 92, 93, 127, 0, 8, 10, 
	31, 9, 13, 32, 34, 44, 92, 127, 
	0, 31, 13, 34, 46, 92, 127, 0, 
	8, 10, 31, 48, 57, 13, 34, 46, 
	92, 127, 0, 8, 10, 31, 13, 34, 
	46, 92, 127, 0, 8, 10, 31, 48, 
	57, 13, 34, 46, 92, 127, 0, 8, 
	10, 31, 13, 34, 46, 58, 92, 93, 
	127, 0, 8, 10, 31, 48, 57, 65, 
	70, 97, 102, 13, 34, 46, 58, 92, 
	93, 127, 0, 8, 10, 31, 48, 57, 
	65, 70, 97, 102, 13, 34, 58, 92, 
	93, 127, 0, 8, 10, 31, 48, 57, 
	65, 70, 97, 102, 13, 34, 58, 92, 
	93, 127, 0, 8, 10, 31, 48, 57, 
	65, 70, 97, 102, 13, 34, 58, 92, 
	93, 127, 0, 8, 10, 31, 48, 57, 
	65, 70, 97, 102, 13, 34, 58, 92, 
	93, 127, 0, 8, 10, 31, 48, 57, 
	65, 70, 97, 102, 13, 34, 58, 92, 
	93, 127, 0, 8, 10, 31, 13, 34, 
	92, 127, 0, 8, 10, 31, 48, 57, 
	65, 70, 97, 102, 13, 34, 46, 58, 
	92, 93, 127, 0, 8, 10, 31, 48, 
	57, 65, 70, 97, 102, 13, 34, 46, 
	58, 92, 93, 127, 0, 8, 10, 31, 
	48, 57, 65, 70, 97, 102, 13, 34, 
	46, 58, 92, 93, 127, 0, 8, 10, 
	31, 48, 57, 65, 70, 97, 102, 13, 
	34, 92, 127, 0, 8, 10, 31, 48, 
	57, 13, 34, 46, 92, 127, 0, 8, 
	10, 31, 48, 57, 13, 34, 46, 92, 
	127, 0, 8, 10, 31, 48, 57, 13, 
	34, 46, 92, 127, 0, 8, 10, 31, 
	13, 34, 58, 92, 127, 0, 8, 10, 
	31, 10, 13, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 76, 92, 108, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 71, 92, 103, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 79, 92, 111, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 82, 92, 114, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 73, 92, 105, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 84, 92, 116, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 72, 92, 104, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 77, 92, 109, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 92, 126, 127, 0, 
	31, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 34, 44, 61, 92, 
	127, 0, 31, 10, 13, 9, 13, 32, 
	34, 44, 61, 92, 127, 0, 31, 9, 
	13, 32, 33, 34, 37, 39, 91, 92, 
	126, 127, 0, 31, 42, 43, 45, 46, 
	48, 57, 65, 90, 95, 122, 10, 13, 
	9, 13, 32, 33, 34, 37, 39, 91, 
	92, 126, 127, 0, 31, 42, 43, 45, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 92, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 10, 13, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 79, 
	92, 111, 126, 127, 0, 31, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 77, 
	92, 109, 126, 127, 0, 31, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 65, 
	92, 97, 126, 127, 0, 31, 42, 46, 
	48, 57, 66, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 73, 
	92, 105, 126, 127, 0, 31, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 78, 
	92, 110, 126, 127, 0, 31, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 61, 92, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 34, 
	44, 61, 92, 127, 0, 31, 10, 13, 
	9, 13, 32, 34, 44, 61, 92, 127, 
	0, 31, 9, 13, 32, 33, 34, 37, 
	39, 91, 92, 126, 127, 0, 31, 42, 
	43, 45, 46, 48, 57, 65, 90, 95, 
	122, 10, 13, 9, 13, 32, 33, 34, 
	37, 39, 91, 92, 126, 127, 0, 31, 
	42, 43, 45, 46, 48, 57, 65, 90, 
	95, 122, 10, 13, 9, 13, 32, 34, 
	92, 127, 0, 31, 9, 13, 32, 34, 
	44, 92, 127, 0, 31, 10, 13, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	79, 92, 111, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	78, 92, 110, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	67, 92, 99, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	69, 92, 101, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 61, 
	92, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	34, 44, 61, 92, 127, 0, 31, 10, 
	13, 9, 13, 32, 34, 44, 61, 92, 
	127, 0, 31, 9, 13, 32, 33, 34, 
	37, 39, 91, 92, 126, 127, 0, 31, 
	42, 43, 45, 46, 48, 57, 65, 90, 
	95, 122, 10, 13, 9, 13, 32, 33, 
	34, 37, 39, 91, 92, 126, 127, 0, 
	31, 42, 43, 45, 46, 48, 57, 65, 
	90, 95, 122, 10, 13, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 80, 92, 
	112, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 65, 92, 
	97, 126, 127, 0, 31, 42, 46, 48, 
	57, 66, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 81, 92, 
	113, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 85, 92, 
	117, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 69, 92, 
	101, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 61, 92, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 34, 44, 
	61, 92, 127, 0, 31, 10, 13, 9, 
	13, 32, 34, 44, 61, 92, 127, 0, 
	31, 9, 13, 32, 33, 34, 37, 39, 
	91, 92, 126, 127, 0, 31, 42, 43, 
	45, 46, 48, 57, 65, 90, 95, 122, 
	10, 13, 9, 13, 32, 33, 34, 37, 
	39, 91, 92, 126, 127, 0, 31, 42, 
	43, 45, 46, 48, 57, 65, 90, 95, 
	122, 10, 13, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 79, 92, 111, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 80, 92, 112, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 61, 92, 126, 127, 0, 
	31, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 34, 44, 61, 92, 
	127, 0, 31, 10, 13, 9, 13, 32, 
	34, 44, 61, 92, 127, 0, 31, 9, 
	13, 32, 33, 34, 37, 39, 91, 92, 
	126, 127, 0, 31, 42, 43, 45, 46, 
	48, 57, 65, 90, 95, 122, 10, 13, 
	9, 13, 32, 33, 34, 37, 39, 91, 
	92, 126, 127, 0, 31, 42, 43, 45, 
	46, 48, 57, 65, 90, 95, 122, 10, 
	13, 9, 13, 32, 34, 92, 127, 0, 
	31, 9, 13, 32, 34, 44, 92, 127, 
	0, 31, 10, 13, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 69, 92, 101, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 65, 92, 97, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	66, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 76, 92, 108, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 77, 92, 109, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 61, 92, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 34, 44, 61, 
	92, 127, 0, 31, 10, 13, 9, 13, 
	32, 34, 44, 61, 92, 127, 0, 31, 
	9, 13, 32, 33, 34, 37, 39, 91, 
	92, 126, 127, 0, 31, 42, 43, 45, 
	46, 48, 57, 65, 90, 95, 122, 10, 
	13, 9, 13, 32, 33, 34, 37, 39, 
	91, 92, 126, 127, 0, 31, 42, 43, 
	45, 46, 48, 57, 65, 90, 95, 122, 
	10, 13, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 84, 92, 116, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 65, 92, 97, 126, 127, 
	0, 31, 42, 46, 48, 57, 66, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 76, 92, 108, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 69, 92, 101, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 61, 92, 126, 127, 0, 31, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 34, 44, 61, 92, 127, 
	0, 31, 10, 13, 9, 13, 32, 34, 
	44, 61, 92, 127, 0, 31, 9, 13, 
	32, 33, 34, 37, 39, 70, 84, 91, 
	92, 102, 116, 126, 127, 0, 31, 42, 
	43, 45, 46, 48, 57, 65, 90, 95, 
	122, 10, 13, 9, 13, 32, 33, 34, 
	37, 39, 70, 84, 91, 92, 102, 116, 
	126, 127, 0, 31, 42, 43, 45, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 65, 92, 
	97, 126, 127, 0, 31, 42, 46, 48, 
	57, 66, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 76, 92, 108, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 83, 92, 115, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 69, 92, 101, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 34, 44, 92, 
	127, 0, 31, 9, 13, 32, 33, 34, 
	37, 39, 44, 82, 92, 114, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 85, 92, 117, 126, 127, 0, 
	31, 42, 46, 48, 57, 65, 90, 95, 
	122, 10, 13, 10, 13, 9, 13, 32, 
	33, 37, 39, 44, 61, 79, 111, 126, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 33, 37, 39, 44, 61, 
	80, 112, 126, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 37, 
	39, 44, 61, 126, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 44, 
	61, 10, 13, 9, 13, 32, 44, 61, 
	9, 13, 32, 33, 34, 37, 39, 91, 
	126, 42, 43, 45, 46, 48, 57, 65, 
	90, 95, 122, 10, 13, 9, 13, 32, 
	33, 34, 37, 39, 91, 126, 42, 43, 
	45, 46, 48, 57, 65, 90, 95, 122, 
	10, 13, 9, 13, 32, 34, 13, 34, 
	92, 127, 0, 8, 10, 31, 13, 34, 
	92, 127, 0, 8, 10, 31, 10, 13, 
	34, 13, 34, 0, 9, 11, 127, 10, 
	13, 13, 73, 105, 13, 71, 103, 13, 
	69, 101, 13, 83, 115, 13, 84, 116, 
	9, 13, 32, 10, 13, 9, 13, 32, 
	87, 119, 87, 119, 13, 9, 13, 32, 
	9, 13, 32, 9, 13, 32, 9, 13, 
	32, 9, 13, 32, 33, 37, 39, 65, 
	68, 78, 79, 81, 82, 83, 97, 100, 
	110, 111, 113, 114, 115, 126, 42, 43, 
	45, 46, 48, 57, 66, 90, 95, 122, 
	9, 13, 32, 9, 13, 32, 9, 13, 
	32, 9, 13, 32, 9, 13, 32, 33, 
	37, 39, 65, 68, 78, 79, 81, 82, 
	83, 97, 100, 110, 111, 113, 114, 115, 
	126, 42, 43, 45, 46, 48, 57, 66, 
	90, 95, 122, 9, 13, 32, 9, 13, 
	32, 9, 13, 32, 9, 13, 32, 9, 
	13, 32, 33, 37, 39, 65, 68, 78, 
	79, 81, 82, 83, 97, 100, 110, 111, 
	113, 114, 115, 126, 42, 43, 45, 46, 
	48, 57, 66, 90, 95, 122, 9, 13, 
	32, 9, 13, 32, 9, 13, 32, 9, 
	13, 32, 9, 13, 32, 33, 37, 39, 
	65, 68, 78, 79, 81, 82, 83, 97, 
	100, 110, 111, 113, 114, 115, 126, 42, 
	43, 45, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 9, 13, 32, 9, 
	13, 32, 13, 34, 9, 13, 32, 33, 
	37, 39, 65, 68, 78, 79, 81, 82, 
	83, 97, 100, 110, 111, 113, 114, 115, 
	126, 42, 43, 45, 46, 48, 57, 66, 
	90, 95, 122, 9, 13, 32, 9, 13, 
	32, 9, 13, 32, 9, 13, 32, 9, 
	13, 32, 33, 37, 39, 65, 68, 78, 
	79, 81, 82, 83, 97, 100, 110, 111, 
	113, 114, 115, 126, 42, 43, 45, 46, 
	48, 57, 66, 90, 95, 122, 9, 13, 
	32, 9, 13, 32, 9, 13, 32, 33, 
	37, 39, 65, 68, 78, 79, 81, 82, 
	83, 97, 100, 110, 111, 113, 114, 115, 
	126, 42, 43, 45, 46, 48, 57, 66, 
	90, 95, 122, 9, 13, 32, 34, 9, 
	13, 32, 33, 37, 39, 65, 68, 78, 
	79, 81, 82, 83, 97, 100, 110, 111, 
	113, 114, 115, 126, 42, 43, 45, 46, 
	48, 57, 66, 90, 95, 122, 9, 13, 
	32, 33, 37, 39, 65, 68, 78, 79, 
	81, 82, 83, 97, 100, 110, 111, 113, 
	114, 115, 126, 42, 43, 45, 46, 48, 
	57, 66, 90, 95, 122, 9, 13, 32, 
	9, 13, 32, 9, 13, 32, 9, 13, 
	32, 9, 13, 32, 9, 13, 32, 33, 
	37, 39, 65, 68, 78, 79, 81, 82, 
	83, 97, 100, 110, 111, 113, 114, 115, 
	126, 42, 43, 45, 46, 48, 57, 66, 
	90, 95, 122, 9, 13, 32, 9, 13, 
	32, 9, 13, 32, 33, 37, 39, 65, 
	68, 78, 79, 81, 82, 83, 97, 100, 
	110, 111, 113, 114, 115, 126, 42, 43, 
	45, 46, 48, 57, 66, 90, 95, 122, 
	9, 13, 32, 9, 13, 32, 9, 13, 
	32, 13, 34, 9, 13, 32, 34, 9, 
	13, 32, 34, 9, 13, 32, 34, 9, 
	13, 32, 34, 9, 13, 32, 34, 9, 
	13, 32, 34, 9, 13, 32, 33, 34, 
	37, 39, 65, 68, 78, 79, 81, 82, 
	83, 97, 100, 110, 111, 113, 114, 115, 
	126, 42, 43, 45, 46, 48, 57, 66, 
	90, 95, 122, 9, 13, 32, 34, 9, 
	13, 32, 34, 9, 13, 32, 33, 34, 
	37, 39, 65, 68, 78, 79, 81, 82, 
	83, 97, 100, 110, 111, 113, 114, 115, 
	126, 42, 43, 45, 46, 48, 57, 66, 
	90, 95, 122, 9, 13, 32, 34, 9, 
	13, 32, 34, 9, 13, 32, 34, 9, 
	13, 32, 33, 34, 37, 39, 65, 68, 
	78, 79, 81, 82, 83, 97, 100, 110, 
	111, 113, 114, 115, 126, 42, 43, 45, 
	46, 48, 57, 66, 90, 95, 122, 9, 
	13, 32, 34, 9, 13, 32, 34, 9, 
	13, 32, 34, 9, 13, 32, 33, 37, 
	39, 65, 68, 78, 79, 81, 82, 83, 
	97, 100, 110, 111, 113, 114, 115, 126, 
	42, 43, 45, 46, 48, 57, 66, 90, 
	95, 122, 9, 13, 32, 33, 37, 39, 
	65, 68, 78, 79, 81, 82, 83, 97, 
	100, 110, 111, 113, 114, 115, 126, 42, 
	43, 45, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 9, 13, 32, 9, 
	13, 32, 9, 13, 32, 9, 13, 32, 
	9, 13, 32, 33, 37, 39, 65, 68, 
	78, 79, 81, 82, 83, 97, 100, 110, 
	111, 113, 114, 115, 126, 42, 43, 45, 
	46, 48, 57, 66, 90, 95, 122, 9, 
	13, 32, 9, 13, 32, 9, 13, 32, 
	33, 37, 39, 65, 68, 78, 79, 81, 
	82, 83, 97, 100, 110, 111, 113, 114, 
	115, 126, 42, 43, 45, 46, 48, 57, 
	66, 90, 95, 122, 9, 13, 32, 9, 
	13, 32, 9, 13, 32, 9, 13, 32, 
	33, 37, 39, 65, 68, 78, 79, 81, 
	82, 83, 97, 100, 110, 111, 113, 114, 
	115, 126, 42, 43, 45, 46, 48, 57, 
	66, 90, 95, 122, 9, 13, 32, 9, 
	13, 32, 9, 13, 32, 9, 13, 32, 
	33, 37, 39, 65, 68, 78, 79, 81, 
	82, 83, 97, 100, 110, 111, 113, 114, 
	115, 126, 42, 43, 45, 46, 48, 57, 
	66, 90, 95, 122, 9, 13, 32, 9, 
	13, 32, 9, 13, 32, 9, 13, 32, 
	9, 13, 32, 9, 13, 32, 9, 13, 
	32, 9, 13, 32, 9, 13, 32, 33, 
	37, 39, 65, 68, 78, 79, 81, 82, 
	83, 97, 100, 110, 111, 113, 114, 115, 
	126, 42, 43, 45, 46, 48, 57, 66, 
	90, 95, 122, 9, 13, 32, 33, 37, 
	39, 65, 68, 78, 79, 81, 82, 83, 
	97, 100, 110, 111, 113, 114, 115, 126, 
	42, 43, 45, 46, 48, 57, 66, 90, 
	95, 122, 9, 13, 32, 9, 13, 32, 
	9, 13, 32, 33, 37, 39, 65, 68, 
	78, 79, 81, 82, 83, 97, 100, 110, 
	111, 113, 114, 115, 126, 42, 43, 45, 
	46, 48, 57, 66, 90, 95, 122, 9, 
	13, 32, 9, 13, 32, 9, 13, 32, 
	9, 13, 32, 33, 37, 39, 65, 68, 
	78, 79, 81, 82, 83, 97, 100, 110, 
	111, 113, 114, 115, 126, 42, 43, 45, 
	46, 48, 57, 66, 90, 95, 122, 9, 
	13, 32, 9, 13, 32, 9, 13, 32, 
	9, 13, 32, 33, 37, 39, 65, 68, 
	78, 79, 81, 82, 83, 97, 100, 110, 
	111, 113, 114, 115, 126, 42, 43, 45, 
	46, 48, 57, 66, 90, 95, 122, 9, 
	13, 32, 9, 13, 32, 9, 13, 32, 
	9, 13, 32, 33, 37, 39, 65, 68, 
	78, 79, 81, 82, 83, 97, 100, 110, 
	111, 113, 114, 115, 126, 42, 43, 45, 
	46, 48, 57, 66, 90, 95, 122, 9, 
	13, 32, 9, 13, 32, 9, 13, 32, 
	9, 13, 32, 34, 9, 13, 32, 34, 
	9, 13, 32, 34, 9, 13, 32, 34, 
	9, 13, 32, 34, 9, 13, 32, 33, 
	34, 37, 39, 65, 68, 78, 79, 81, 
	82, 83, 97, 100, 110, 111, 113, 114, 
	115, 126, 42, 43, 45, 46, 48, 57, 
	66, 90, 95, 122, 9, 13, 32, 34, 
	9, 13, 32, 34, 9, 13, 32, 33, 
	34, 37, 39, 65, 68, 78, 79, 81, 
	82, 83, 97, 100, 110, 111, 113, 114, 
	115, 126, 42, 43, 45, 46, 48, 57, 
	66, 90, 95, 122, 9, 13, 32, 34, 
	9, 13, 32, 34, 9, 13, 32, 34, 
	9, 13, 32, 33, 34, 37, 39, 65, 
	68, 78, 79, 81, 82, 83, 97, 100, 
	110, 111, 113, 114, 115, 126, 42, 43, 
	45, 46, 48, 57, 66, 90, 95, 122, 
	9, 13, 32, 34, 9, 13, 32, 34, 
	9, 13, 32, 34, 9, 13, 32, 33, 
	34, 37, 39, 65, 68, 78, 79, 81, 
	82, 83, 97, 100, 110, 111, 113, 114, 
	115, 126, 42, 43, 45, 46, 48, 57, 
	66, 90, 95, 122, 9, 13, 32, 34, 
	9, 13, 32, 34, 9, 13, 32, 34, 
	9, 13, 32, 33, 37, 39, 65, 68, 
	78, 79, 81, 82, 83, 97, 100, 110, 
	111, 113, 114, 115, 126, 42, 43, 45, 
	46, 48, 57, 66, 90, 95, 122, 9, 
	13, 32, 33, 34, 37, 39, 65, 68, 
	78, 79, 81, 82, 83, 97, 100, 110, 
	111, 113, 114, 115, 126, 42, 43, 45, 
	46, 48, 57, 66, 90, 95, 122, 9, 
	13, 32, 34, 9, 13, 32, 34, 9, 
	13, 32, 33, 34, 37, 39, 65, 68, 
	78, 79, 81, 82, 83, 97, 100, 110, 
	111, 113, 114, 115, 126, 42, 43, 45, 
	46, 48, 57, 66, 90, 95, 122, 9, 
	13, 32, 34, 9, 13, 32, 34, 9, 
	13, 32, 34, 9, 13, 32, 33, 37, 
	39, 65, 68, 78, 79, 81, 82, 83, 
	97, 100, 110, 111, 113, 114, 115, 126, 
	42, 43, 45, 46, 48, 57, 66, 90, 
	95, 122, 9, 13, 32, 33, 37, 39, 
	65, 68, 78, 79, 81, 82, 83, 97, 
	100, 110, 111, 113, 114, 115, 126, 42, 
	43, 45, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 9, 13, 32, 9, 
	13, 32, 9, 13, 32, 9, 13, 32, 
	9, 13, 32, 33, 37, 39, 65, 68, 
	78, 79, 81, 82, 83, 97, 100, 110, 
	111, 113, 114, 115, 126, 42, 43, 45, 
	46, 48, 57, 66, 90, 95, 122, 9, 
	13, 32, 9, 13, 32, 9, 13, 32, 
	33, 37, 39, 65, 68, 78, 79, 81, 
	82, 83, 97, 100, 110, 111, 113, 114, 
	115, 126, 42, 43, 45, 46, 48, 57, 
	66, 90, 95, 122, 9, 13, 32, 9, 
	13, 32, 9, 13, 32, 9, 13, 32, 
	33, 37, 39, 65, 68, 78, 79, 81, 
	82, 83, 97, 100, 110, 111, 113, 114, 
	115, 126, 42, 43, 45, 46, 48, 57, 
	66, 90, 95, 122, 9, 13, 32, 9, 
	13, 32, 9, 13, 32, 9, 13, 32, 
	33, 37, 39, 65, 68, 78, 79, 81, 
	82, 83, 97, 100, 110, 111, 113, 114, 
	115, 126, 42, 43, 45, 46, 48, 57, 
	66, 90, 95, 122, 9, 13, 32, 9, 
	13, 32, 9, 13, 32, 9, 13, 32, 
	33, 37, 39, 65, 68, 78, 79, 81, 
	82, 83, 97, 100, 110, 111, 113, 114, 
	115, 126, 42, 43, 45, 46, 48, 57, 
	66, 90, 95, 122, 9, 13, 32, 9, 
	13, 32, 9, 13, 32, 9, 13, 32, 
	33, 37, 39, 65, 68, 78, 79, 81, 
	82, 83, 97, 100, 110, 111, 113, 114, 
	115, 126, 42, 43, 45, 46, 48, 57, 
	66, 90, 95, 122, 9, 13, 32, 9, 
	13, 32, 9, 13, 32, 9, 13, 32, 
	33, 37, 39, 65, 68, 78, 79, 81, 
	82, 83, 97, 100, 110, 111, 113, 114, 
	115, 126, 42, 43, 45, 46, 48, 57, 
	66, 90, 95, 122, 9, 13, 32, 9, 
	13, 32, 9, 13, 32, 33, 37, 39, 
	65, 68, 78, 79, 81, 82, 83, 97, 
	100, 110, 111, 113, 114, 115, 126, 42, 
	43, 45, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	65, 68, 78, 79, 81, 82, 83, 97, 
	100, 110, 111, 113, 114, 115, 126, 42, 
	43, 45, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 34, 9, 13, 32, 
	34, 9, 13, 32, 33, 34, 37, 39, 
	65, 68, 78, 79, 81, 82, 83, 97, 
	100, 110, 111, 113, 114, 115, 126, 42, 
	43, 45, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 34, 9, 13, 32, 
	34, 9, 13, 32, 34, 9, 13, 32, 
	33, 34, 37, 39, 65, 68, 78, 79, 
	81, 82, 83, 97, 100, 110, 111, 113, 
	114, 115, 126, 42, 43, 45, 46, 48, 
	57, 66, 90, 95, 122, 9, 13, 32, 
	34, 9, 13, 32, 34, 9, 13, 32, 
	34, 9, 13, 32, 33, 34, 37, 39, 
	65, 68, 78, 79, 81, 82, 83, 97, 
	100, 110, 111, 113, 114, 115, 126, 42, 
	43, 45, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 34, 9, 13, 32, 
	34, 9, 13, 32, 34, 9, 13, 32, 
	33, 34, 37, 39, 65, 68, 78, 79, 
	81, 82, 83, 97, 100, 110, 111, 113, 
	114, 115, 126, 42, 43, 45, 46, 48, 
	57, 66, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 65, 68, 78, 79, 
	81, 82, 83, 97, 100, 110, 111, 113, 
	114, 115, 126, 42, 43, 45, 46, 48, 
	57, 66, 90, 95, 122, 9, 13, 32, 
	34, 9, 13, 32, 34, 9, 13, 32, 
	34, 9, 13, 32, 33, 34, 37, 39, 
	65, 68, 78, 79, 81, 82, 83, 97, 
	100, 110, 111, 113, 114, 115, 126, 42, 
	43, 45, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 34, 9, 13, 32, 
	34, 9, 13, 32, 33, 34, 37, 39, 
	65, 68, 78, 79, 81, 82, 83, 97, 
	100, 110, 111, 113, 114, 115, 126, 42, 
	43, 45, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	65, 68, 78, 79, 81, 82, 83, 97, 
	100, 110, 111, 113, 114, 115, 126, 42, 
	43, 45, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 34, 9, 13, 32, 
	34, 9, 13, 32, 33, 34, 37, 39, 
	65, 68, 78, 79, 81, 82, 83, 97, 
	100, 110, 111, 113, 114, 115, 126, 42, 
	43, 45, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	65, 68, 78, 79, 81, 82, 83, 97, 
	100, 110, 111, 113, 114, 115, 126, 42, 
	43, 45, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 34, 9, 13, 32, 
	34, 9, 13, 32, 33, 34, 37, 39, 
	65, 68, 78, 79, 81, 82, 83, 97, 
	100, 110, 111, 113, 114, 115, 126, 42, 
	43, 45, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 34, 9, 13, 32, 
	34, 9, 13, 32, 34, 9, 13, 32, 
	33, 34, 37, 39, 65, 68, 78, 79, 
	81, 82, 83, 97, 100, 110, 111, 113, 
	114, 115, 126, 42, 43, 45, 46, 48, 
	57, 66, 90, 95, 122, 9, 13, 32, 
	34, 9, 13, 32, 34, 9, 13, 32, 
	34, 9, 13, 32, 33, 34, 37, 39, 
	65, 68, 78, 79, 81, 82, 83, 97, 
	100, 110, 111, 113, 114, 115, 126, 42, 
	43, 45, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 34, 9, 13, 32, 
	34, 9, 13, 32, 34, 9, 13, 32, 
	33, 34, 37, 39, 65, 68, 78, 79, 
	81, 82, 83, 97, 100, 110, 111, 113, 
	114, 115, 126, 42, 43, 45, 46, 48, 
	57, 66, 90, 95, 122, 9, 13, 32, 
	34, 9, 13, 32, 34, 9, 13, 32, 
	33, 34, 37, 39, 65, 68, 78, 79, 
	81, 82, 83, 97, 100, 110, 111, 113, 
	114, 115, 126, 42, 43, 45, 46, 48, 
	57, 66, 90, 95, 122, 9, 13, 32, 
	34, 9, 13, 32, 34, 9, 13, 32, 
	34, 9, 13, 32, 33, 34, 37, 39, 
	65, 68, 78, 79, 81, 82, 83, 97, 
	100, 110, 111, 113, 114, 115, 126, 42, 
	43, 45, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 34, 9, 13, 32, 
	34, 9, 13, 32, 33, 34, 37, 39, 
	65, 68, 78, 79, 81, 82, 83, 97, 
	100, 110, 111, 113, 114, 115, 126, 42, 
	43, 45, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 33, 37, 39, 65, 
	68, 78, 79, 81, 82, 83, 97, 100, 
	110, 111, 113, 114, 115, 126, 42, 43, 
	45, 46, 48, 57, 66, 90, 95, 122, 
	9, 13, 32, 9, 13, 32, 9, 13, 
	32, 9, 13, 32, 33, 37, 39, 65, 
	68, 78, 79, 81, 82, 83, 97, 100, 
	110, 111, 113, 114, 115, 126, 42, 43, 
	45, 46, 48, 57, 66, 90, 95, 122, 
	9, 13, 32, 9, 13, 32, 9, 13, 
	32, 33, 37, 39, 65, 68, 78, 79, 
	81, 82, 83, 97, 100, 110, 111, 113, 
	114, 115, 126, 42, 43, 45, 46, 48, 
	57, 66, 90, 95, 122, 9, 13, 32, 
	33, 37, 39, 65, 68, 78, 79, 81, 
	82, 83, 97, 100, 110, 111, 113, 114, 
	115, 126, 42, 43, 45, 46, 48, 57, 
	66, 90, 95, 122, 9, 13, 32, 9, 
	13, 32, 9, 13, 32, 9, 13, 32, 
	33, 37, 39, 65, 68, 78, 79, 81, 
	82, 83, 97, 100, 110, 111, 113, 114, 
	115, 126, 42, 43, 45, 46, 48, 57, 
	66, 90, 95, 122, 9, 13, 32, 9, 
	13, 32, 9, 13, 32, 9, 13, 32, 
	33, 37, 39, 65, 68, 78, 79, 81, 
	82, 83, 97, 100, 110, 111, 113, 114, 
	115, 126, 42, 43, 45, 46, 48, 57, 
	66, 90, 95, 122, 9, 13, 32, 9, 
	13, 32, 9, 13, 32, 33, 37, 39, 
	65, 68, 78, 79, 81, 82, 83, 97, 
	100, 110, 111, 113, 114, 115, 126, 42, 
	43, 45, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	65, 68, 78, 79, 81, 82, 83, 97, 
	100, 110, 111, 113, 114, 115, 126, 42, 
	43, 45, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 34, 9, 13, 32, 
	34, 9, 13, 32, 33, 34, 37, 39, 
	65, 68, 78, 79, 81, 82, 83, 97, 
	100, 110, 111, 113, 114, 115, 126, 42, 
	43, 45, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 34, 9, 13, 32, 
	34, 9, 13, 32, 33, 34, 37, 39, 
	65, 68, 78, 79, 81, 82, 83, 97, 
	100, 110, 111, 113, 114, 115, 126, 42, 
	43, 45, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	65, 68, 78, 79, 81, 82, 83, 97, 
	100, 110, 111, 113, 114, 115, 126, 42, 
	43, 45, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 34, 9, 13, 32, 
	34, 9, 13, 32, 33, 34, 37, 39, 
	65, 68, 78, 79, 81, 82, 83, 97, 
	100, 110, 111, 113, 114, 115, 126, 42, 
	43, 45, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 34, 9, 13, 32, 
	34, 9, 13, 32, 33, 34, 37, 39, 
	65, 68, 78, 79, 81, 82, 83, 97, 
	100, 110, 111, 113, 114, 115, 126, 42, 
	43, 45, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 34, 9, 13, 32, 
	34, 9, 13, 32, 34, 9, 13, 32, 
	33, 34, 37, 39, 65, 68, 78, 79, 
	81, 82, 83, 97, 100, 110, 111, 113, 
	114, 115, 126, 42, 43, 45, 46, 48, 
	57, 66, 90, 95, 122, 9, 13, 32, 
	34, 9, 13, 32, 34, 9, 13, 32, 
	34, 9, 13, 32, 33, 34, 37, 39, 
	65, 68, 78, 79, 81, 82, 83, 97, 
	100, 110, 111, 113, 114, 115, 126, 42, 
	43, 45, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 34, 9, 13, 32, 
	34, 9, 13, 32, 34, 9, 13, 32, 
	33, 34, 37, 39, 65, 68, 78, 79, 
	81, 82, 83, 97, 100, 110, 111, 113, 
	114, 115, 126, 42, 43, 45, 46, 48, 
	57, 66, 90, 95, 122, 9, 13, 32, 
	34, 9, 13, 32, 34, 9, 13, 32, 
	34, 9, 13, 32, 33, 34, 37, 39, 
	65, 68, 78, 79, 81, 82, 83, 97, 
	100, 110, 111, 113, 114, 115, 126, 42, 
	43, 45, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 34, 9, 13, 32, 
	34, 9, 13, 32, 33, 34, 37, 39, 
	65, 68, 78, 79, 81, 82, 83, 97, 
	100, 110, 111, 113, 114, 115, 126, 42, 
	43, 45, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 33, 37, 39, 65, 
	68, 78, 79, 81, 82, 83, 97, 100, 
	110, 111, 113, 114, 115, 126, 42, 43, 
	45, 46, 48, 57, 66, 90, 95, 122, 
	9, 13, 32, 9, 13, 32, 9, 13, 
	32, 9, 13, 32, 33, 37, 39, 65, 
	68, 78, 79, 81, 82, 83, 97, 100, 
	110, 111, 113, 114, 115, 126, 42, 43, 
	45, 46, 48, 57, 66, 90, 95, 122, 
	9, 13, 32, 9, 13, 32, 9, 13, 
	32, 9, 13, 32, 33, 37, 39, 65, 
	68, 78, 79, 81, 82, 83, 97, 100, 
	110, 111, 113, 114, 115, 126, 42, 43, 
	45, 46, 48, 57, 66, 90, 95, 122, 
	9, 13, 32, 9, 13, 32, 9, 13, 
	32, 9, 13, 32, 33, 37, 39, 65, 
	68, 78, 79, 81, 82, 83, 97, 100, 
	110, 111, 113, 114, 115, 126, 42, 43, 
	45, 46, 48, 57, 66, 90, 95, 122, 
	9, 13, 32, 9, 13, 32, 9, 13, 
	32, 9, 13, 32, 33, 37, 39, 65, 
	68, 78, 79, 81, 82, 83, 97, 100, 
	110, 111, 113, 114, 115, 126, 42, 43, 
	45, 46, 48, 57, 66, 90, 95, 122, 
	9, 13, 32, 9, 13, 32, 9, 13, 
	32, 33, 37, 39, 65, 68, 78, 79, 
	81, 82, 83, 97, 100, 110, 111, 113, 
	114, 115, 126, 42, 43, 45, 46, 48, 
	57, 66, 90, 95, 122, 9, 13, 32, 
	33, 37, 39, 65, 68, 78, 79, 81, 
	82, 83, 97, 100, 110, 111, 113, 114, 
	115, 126, 42, 43, 45, 46, 48, 57, 
	66, 90, 95, 122, 9, 13, 32, 9, 
	13, 32, 9, 13, 32, 9, 13, 32, 
	33, 37, 39, 65, 68, 78, 79, 81, 
	82, 83, 97, 100, 110, 111, 113, 114, 
	115, 126, 42, 43, 45, 46, 48, 57, 
	66, 90, 95, 122, 9, 13, 32, 9, 
	13, 32, 9, 13, 32, 33, 37, 39, 
	65, 68, 78, 79, 81, 82, 83, 97, 
	100, 110, 111, 113, 114, 115, 126, 42, 
	43, 45, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 9, 13, 32, 9, 
	13, 32, 9, 13, 32, 34, 9, 13, 
	32, 33, 37, 39, 65, 68, 78, 79, 
	81, 82, 83, 97, 100, 110, 111, 113, 
	114, 115, 126, 42, 43, 45, 46, 48, 
	57, 66, 90, 95, 122, 9, 13, 32, 
	33, 37, 39, 65, 68, 78, 79, 81, 
	82, 83, 97, 100, 110, 111, 113, 114, 
	115, 126, 42, 43, 45, 46, 48, 57, 
	66, 90, 95, 122, 9, 13, 32, 9, 
	13, 32, 9, 13, 32, 9, 13, 32, 
	9, 13, 32, 33, 37, 39, 65, 68, 
	78, 79, 81, 82, 83, 97, 100, 110, 
	111, 113, 114, 115, 126, 42, 43, 45, 
	46, 48, 57, 66, 90, 95, 122, 9, 
	13, 32, 9, 13, 32, 9, 13, 32, 
	33, 37, 39, 65, 68, 78, 79, 81, 
	82, 83, 97, 100, 110, 111, 113, 114, 
	115, 126, 42, 43, 45, 46, 48, 57, 
	66, 90, 95, 122, 9, 13, 32, 9, 
	13, 32, 9, 13, 32, 9, 13, 32, 
	33, 37, 39, 65, 68, 78, 79, 81, 
	82, 83, 97, 100, 110, 111, 113, 114, 
	115, 126, 42, 43, 45, 46, 48, 57, 
	66, 90, 95, 122, 9, 13, 32, 9, 
	13, 32, 9, 13, 32, 33, 37, 39, 
	65, 68, 78, 79, 81, 82, 83, 97, 
	100, 110, 111, 113, 114, 115, 126, 42, 
	43, 45, 46, 48, 57, 66, 90, 95, 
	122, 9, 13, 32, 9, 13, 32, 9, 
	13, 32, 33, 37, 39, 65, 68, 78, 
	79, 81, 82, 83, 97, 100, 110, 111, 
	113, 114, 115, 126, 42, 43, 45, 46, 
	48, 57, 66, 90, 95, 122, 9, 13, 
	32, 9, 13, 32, 9, 13, 32, 9, 
	13, 32, 33, 37, 39, 65, 68, 78, 
	79, 81, 82, 83, 97, 100, 110, 111, 
	113, 114, 115, 126, 42, 43, 45, 46, 
	48, 57, 66, 90, 95, 122, 9, 13, 
	32, 9, 13, 32, 9, 13, 32, 33, 
	37, 39, 65, 68, 78, 79, 81, 82, 
	83, 97, 100, 110, 111, 113, 114, 115, 
	126, 42, 43, 45, 46, 48, 57, 66, 
	90, 95, 122, 9, 13, 32, 9, 13, 
	32, 9, 13, 32, 33, 37, 39, 65, 
	68, 78, 79, 81, 82, 83, 97, 100, 
	110, 111, 113, 114, 115, 126, 42, 43, 
	45, 46, 48, 57, 66, 90, 95, 122, 
	9, 13, 32, 33, 37, 39, 65, 68, 
	78, 79, 81, 82, 83, 97, 100, 110, 
	111, 113, 114, 115, 126, 42, 43, 45, 
	46, 48, 57, 66, 90, 95, 122, 9, 
	13, 32, 9, 13, 32, 9, 13, 32, 
	9, 13, 32, 34, 9, 13, 32, 33, 
	37, 39, 65, 68, 78, 79, 81, 82, 
	83, 97, 100, 110, 111, 113, 114, 115, 
	126, 42, 43, 45, 46, 48, 57, 66, 
	90, 95, 122, 0
};

static const char _thttp_machine_parser_header_WWW_Authenticate_single_lengths[] = {
	0, 4, 2, 2, 2, 2, 1, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 7, 1, 2, 7, 
	2, 7, 3, 3, 3, 3, 3, 21, 
	2, 21, 9, 5, 2, 5, 21, 2, 
	21, 11, 2, 11, 9, 2, 9, 2, 
	4, 4, 2, 4, 4, 2, 4, 2, 
	11, 11, 11, 11, 9, 5, 2, 5, 
	9, 2, 9, 2, 4, 4, 2, 4, 
	1, 8, 2, 3, 3, 3, 3, 2, 
	4, 1, 2, 1, 2, 1, 2, 2, 
	2, 2, 2, 2, 2, 4, 4, 3, 
	3, 3, 3, 3, 1, 4, 4, 4, 
	1, 2, 2, 2, 2, 2, 11, 11, 
	11, 11, 11, 9, 5, 2, 5, 9, 
	2, 9, 2, 4, 4, 2, 4, 1, 
	2, 11, 11, 9, 5, 2, 5, 9, 
	2, 9, 2, 4, 4, 4, 2, 3, 
	4, 2, 4, 11, 11, 11, 11, 9, 
	5, 2, 5, 9, 2, 9, 2, 4, 
	4, 2, 4, 1, 2, 11, 11, 11, 
	11, 9, 5, 2, 5, 13, 2, 13, 
	10, 10, 10, 10, 4, 10, 10, 2, 
	3, 2, 7, 2, 7, 2, 7, 24, 
	2, 24, 12, 8, 2, 8, 11, 2, 
	11, 2, 6, 7, 7, 2, 1, 11, 
	5, 6, 6, 6, 6, 5, 7, 4, 
	5, 4, 5, 4, 5, 5, 5, 5, 
	5, 5, 5, 7, 7, 6, 6, 6, 
	6, 6, 4, 7, 7, 7, 4, 5, 
	5, 5, 5, 2, 14, 14, 14, 14, 
	14, 14, 14, 14, 12, 8, 2, 8, 
	11, 2, 11, 11, 2, 14, 14, 14, 
	14, 14, 12, 8, 2, 8, 11, 2, 
	11, 2, 6, 7, 4, 2, 3, 3, 
	2, 7, 3, 7, 24, 3, 24, 12, 
	8, 3, 8, 11, 3, 11, 3, 6, 
	11, 3, 10, 6, 3, 6, 22, 3, 
	22, 12, 3, 12, 9, 3, 9, 3, 
	4, 9, 5, 3, 5, 3, 12, 12, 
	12, 12, 10, 6, 3, 6, 9, 3, 
	9, 3, 4, 7, 2, 7, 2, 7, 
	24, 2, 24, 12, 8, 2, 8, 11, 
	2, 11, 2, 6, 7, 11, 7, 2, 
	5, 6, 6, 6, 6, 5, 7, 4, 
	5, 4, 5, 4, 5, 5, 5, 7, 
	5, 5, 5, 5, 7, 7, 6, 6, 
	6, 6, 6, 4, 7, 7, 7, 4, 
	5, 5, 5, 5, 2, 14, 14, 14, 
	14, 14, 14, 14, 14, 12, 8, 2, 
	8, 11, 2, 11, 11, 2, 14, 14, 
	14, 14, 14, 12, 8, 2, 8, 11, 
	2, 11, 2, 6, 7, 2, 14, 14, 
	14, 14, 12, 8, 2, 8, 11, 2, 
	11, 2, 6, 7, 2, 14, 14, 14, 
	14, 14, 12, 8, 2, 8, 11, 2, 
	11, 2, 6, 7, 7, 2, 7, 24, 
	2, 24, 12, 8, 2, 8, 11, 2, 
	11, 2, 6, 7, 11, 2, 5, 6, 
	6, 6, 6, 5, 7, 4, 5, 4, 
	5, 4, 5, 5, 5, 7, 5, 5, 
	5, 5, 7, 7, 6, 6, 6, 6, 
	6, 4, 7, 7, 7, 4, 5, 5, 
	5, 5, 2, 14, 14, 14, 14, 14, 
	14, 14, 14, 12, 8, 2, 8, 11, 
	2, 11, 11, 2, 14, 14, 14, 14, 
	14, 12, 8, 2, 8, 11, 2, 11, 
	2, 6, 7, 2, 14, 14, 14, 14, 
	12, 8, 2, 8, 11, 2, 11, 2, 
	6, 7, 2, 14, 14, 14, 14, 14, 
	12, 8, 2, 8, 11, 2, 11, 2, 
	6, 7, 2, 14, 14, 12, 8, 2, 
	8, 11, 2, 11, 2, 6, 7, 7, 
	3, 7, 24, 3, 24, 12, 8, 3, 
	8, 11, 3, 11, 3, 6, 11, 3, 
	10, 6, 3, 6, 22, 3, 22, 12, 
	3, 12, 9, 3, 9, 3, 4, 9, 
	5, 3, 5, 3, 12, 12, 12, 12, 
	10, 6, 3, 6, 9, 3, 9, 3, 
	4, 3, 4, 4, 4, 4, 3, 5, 
	2, 3, 2, 3, 2, 3, 3, 3, 
	5, 3, 3, 3, 3, 5, 5, 4, 
	4, 4, 4, 4, 2, 5, 5, 5, 
	2, 3, 3, 3, 3, 3, 12, 12, 
	12, 12, 12, 10, 6, 3, 6, 9, 
	3, 9, 3, 4, 7, 2, 7, 3, 
	12, 12, 10, 6, 3, 6, 9, 3, 
	9, 3, 12, 12, 12, 12, 10, 6, 
	3, 6, 9, 3, 9, 3, 4, 7, 
	2, 7, 2, 7, 24, 2, 24, 12, 
	8, 2, 8, 11, 2, 11, 2, 6, 
	7, 11, 7, 2, 5, 6, 6, 6, 
	6, 5, 7, 4, 5, 4, 5, 4, 
	5, 5, 5, 7, 5, 5, 5, 5, 
	7, 7, 6, 6, 6, 6, 6, 4, 
	7, 7, 7, 4, 5, 5, 5, 5, 
	2, 14, 14, 14, 14, 14, 14, 14, 
	14, 12, 8, 2, 8, 11, 2, 11, 
	11, 2, 14, 14, 14, 14, 14, 12, 
	8, 2, 8, 11, 2, 11, 2, 6, 
	7, 2, 14, 14, 14, 14, 12, 8, 
	2, 8, 11, 2, 11, 2, 6, 7, 
	2, 14, 14, 14, 14, 14, 12, 8, 
	2, 8, 11, 2, 11, 2, 6, 7, 
	2, 14, 14, 12, 8, 2, 8, 11, 
	2, 11, 2, 6, 7, 2, 14, 14, 
	14, 14, 12, 8, 2, 8, 11, 2, 
	11, 2, 6, 7, 2, 14, 14, 14, 
	14, 12, 8, 2, 8, 15, 2, 15, 
	13, 13, 13, 13, 7, 13, 13, 2, 
	3, 12, 12, 12, 12, 10, 6, 3, 
	6, 13, 3, 13, 11, 11, 11, 11, 
	5, 11, 11, 3, 12, 12, 12, 12, 
	10, 6, 3, 6, 9, 3, 9, 3, 
	4, 7, 7, 3, 7, 12, 12, 12, 
	12, 12, 10, 6, 3, 6, 9, 3, 
	9, 3, 4, 3, 4, 4, 4, 4, 
	3, 5, 2, 3, 2, 3, 2, 3, 
	3, 3, 5, 3, 3, 3, 3, 5, 
	5, 4, 4, 4, 4, 4, 2, 5, 
	5, 5, 2, 3, 3, 3, 3, 3, 
	12, 12, 10, 6, 3, 6, 9, 3, 
	9, 3, 4, 7, 7, 3, 7, 3, 
	12, 12, 12, 12, 10, 6, 3, 6, 
	9, 3, 9, 3, 4, 3, 12, 12, 
	12, 12, 10, 6, 3, 6, 13, 3, 
	13, 11, 11, 11, 11, 5, 11, 11, 
	3, 3, 12, 12, 12, 12, 12, 12, 
	12, 10, 6, 3, 6, 9, 3, 9, 
	9, 3, 5, 6, 6, 6, 6, 5, 
	7, 4, 5, 4, 5, 4, 5, 5, 
	5, 7, 5, 5, 5, 5, 7, 7, 
	6, 6, 6, 6, 6, 4, 7, 7, 
	7, 4, 5, 5, 5, 5, 3, 14, 
	14, 14, 14, 14, 14, 14, 14, 12, 
	8, 3, 8, 11, 3, 11, 11, 3, 
	14, 14, 14, 14, 14, 12, 8, 3, 
	8, 11, 3, 11, 3, 6, 3, 14, 
	14, 14, 14, 12, 8, 3, 8, 11, 
	3, 11, 3, 6, 3, 14, 14, 14, 
	14, 14, 12, 8, 3, 8, 11, 3, 
	11, 3, 6, 3, 14, 14, 12, 8, 
	3, 8, 11, 3, 11, 3, 14, 14, 
	14, 14, 12, 8, 3, 8, 11, 3, 
	11, 3, 6, 3, 14, 14, 14, 14, 
	12, 8, 3, 8, 15, 3, 15, 13, 
	13, 13, 13, 7, 13, 13, 3, 2, 
	14, 14, 14, 14, 12, 8, 2, 8, 
	11, 2, 11, 2, 6, 7, 2, 14, 
	14, 14, 14, 12, 8, 2, 8, 15, 
	2, 15, 13, 13, 13, 13, 7, 13, 
	13, 2, 2, 14, 14, 12, 8, 2, 
	8, 11, 2, 11, 2, 6, 7, 2, 
	14, 14, 14, 14, 12, 8, 2, 8, 
	11, 2, 11, 2, 6, 7, 2, 14, 
	14, 14, 14, 12, 8, 2, 8, 15, 
	2, 15, 13, 13, 13, 13, 7, 13, 
	13, 2, 3, 12, 12, 12, 12, 10, 
	6, 3, 6, 9, 3, 9, 3, 12, 
	12, 12, 12, 12, 12, 12, 10, 6, 
	3, 6, 9, 3, 9, 9, 3, 5, 
	6, 6, 6, 6, 5, 7, 4, 5, 
	4, 5, 4, 5, 5, 5, 7, 5, 
	5, 5, 5, 7, 7, 6, 6, 6, 
	6, 6, 4, 7, 7, 7, 4, 5, 
	5, 5, 5, 3, 14, 14, 14, 14, 
	14, 14, 14, 14, 12, 8, 3, 8, 
	11, 3, 11, 11, 3, 14, 14, 14, 
	14, 14, 12, 8, 3, 8, 11, 3, 
	11, 3, 14, 14, 14, 14, 12, 8, 
	3, 8, 11, 3, 11, 3, 6, 3, 
	14, 14, 14, 14, 14, 12, 8, 3, 
	8, 11, 3, 11, 3, 6, 3, 14, 
	14, 12, 8, 3, 8, 11, 3, 11, 
	3, 6, 3, 14, 14, 14, 14, 12, 
	8, 3, 8, 11, 3, 11, 3, 6, 
	3, 14, 14, 14, 14, 12, 8, 3, 
	8, 15, 3, 15, 13, 13, 13, 13, 
	7, 13, 13, 3, 2, 14, 14, 14, 
	14, 12, 8, 2, 8, 11, 2, 11, 
	2, 6, 2, 14, 14, 14, 14, 14, 
	12, 8, 2, 8, 11, 2, 11, 2, 
	6, 2, 14, 14, 12, 8, 2, 8, 
	11, 2, 11, 2, 6, 7, 2, 14, 
	14, 14, 14, 12, 8, 2, 8, 11, 
	2, 11, 2, 6, 2, 14, 14, 14, 
	14, 12, 8, 2, 8, 15, 2, 15, 
	13, 13, 13, 13, 7, 13, 13, 2, 
	2, 11, 11, 11, 11, 9, 5, 2, 
	5, 9, 2, 9, 2, 4, 4, 2, 
	11, 11, 11, 11, 11, 11, 11, 9, 
	5, 2, 5, 9, 2, 9, 8, 2, 
	11, 11, 11, 11, 11, 9, 5, 2, 
	5, 9, 2, 9, 2, 4, 4, 4, 
	3, 2, 7, 2, 7, 2, 7, 24, 
	2, 24, 12, 8, 2, 8, 11, 2, 
	11, 11, 7, 2, 5, 6, 6, 6, 
	6, 5, 7, 4, 5, 4, 5, 4, 
	5, 5, 5, 7, 5, 5, 5, 5, 
	7, 7, 6, 6, 6, 6, 6, 4, 
	7, 7, 7, 4, 5, 5, 5, 5, 
	2, 14, 14, 14, 14, 14, 14, 14, 
	14, 12, 8, 2, 8, 11, 2, 11, 
	11, 2, 14, 14, 14, 14, 14, 12, 
	8, 2, 8, 11, 2, 11, 2, 6, 
	7, 2, 14, 14, 14, 14, 12, 8, 
	2, 8, 11, 2, 11, 2, 14, 14, 
	14, 14, 14, 12, 8, 2, 8, 11, 
	2, 11, 2, 14, 14, 12, 8, 2, 
	8, 11, 2, 11, 2, 6, 7, 2, 
	14, 14, 14, 14, 12, 8, 2, 8, 
	11, 2, 11, 2, 14, 14, 14, 14, 
	12, 8, 2, 8, 15, 2, 15, 13, 
	13, 13, 13, 7, 13, 13, 2, 2, 
	11, 11, 9, 5, 2, 5, 9, 2, 
	9, 2, 4, 4, 4, 3, 2, 2, 
	3, 3, 3, 3, 3, 3, 2, 3, 
	2, 2, 1, 3, 3, 3, 3, 21, 
	3, 3, 3, 3, 21, 3, 3, 3, 
	3, 21, 3, 3, 3, 3, 21, 3, 
	3, 3, 2, 21, 3, 3, 3, 3, 
	21, 3, 3, 21, 4, 21, 21, 3, 
	3, 3, 3, 3, 21, 3, 3, 21, 
	3, 3, 3, 2, 4, 4, 4, 4, 
	4, 4, 22, 4, 4, 22, 4, 4, 
	4, 22, 4, 4, 4, 21, 21, 3, 
	3, 3, 3, 3, 21, 3, 3, 21, 
	3, 3, 3, 21, 3, 3, 3, 21, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	21, 21, 3, 3, 21, 3, 3, 3, 
	21, 3, 3, 3, 21, 3, 3, 3, 
	21, 3, 3, 3, 4, 4, 4, 4, 
	4, 22, 4, 4, 22, 4, 4, 4, 
	22, 4, 4, 4, 22, 4, 4, 4, 
	21, 22, 4, 4, 22, 4, 4, 4, 
	21, 21, 3, 3, 3, 3, 3, 21, 
	3, 3, 21, 3, 3, 3, 21, 3, 
	3, 3, 21, 3, 3, 3, 21, 3, 
	3, 3, 21, 3, 3, 3, 21, 3, 
	3, 21, 22, 4, 4, 22, 4, 4, 
	4, 22, 4, 4, 4, 22, 4, 4, 
	4, 22, 22, 4, 4, 4, 22, 4, 
	4, 22, 22, 4, 4, 22, 22, 4, 
	4, 22, 4, 4, 4, 22, 4, 4, 
	4, 22, 4, 4, 4, 22, 4, 4, 
	22, 4, 4, 4, 22, 4, 4, 22, 
	21, 3, 3, 3, 21, 3, 3, 21, 
	21, 3, 3, 3, 21, 3, 3, 3, 
	21, 3, 3, 21, 22, 4, 4, 22, 
	4, 4, 22, 22, 4, 4, 22, 4, 
	4, 22, 4, 4, 4, 22, 4, 4, 
	4, 22, 4, 4, 4, 22, 4, 4, 
	4, 22, 4, 4, 22, 21, 3, 3, 
	3, 21, 3, 3, 3, 21, 3, 3, 
	3, 21, 3, 3, 3, 21, 3, 3, 
	21, 21, 3, 3, 3, 21, 3, 3, 
	21, 3, 3, 3, 4, 21, 21, 3, 
	3, 3, 3, 21, 3, 3, 21, 3, 
	3, 3, 21, 3, 3, 21, 3, 3, 
	21, 3, 3, 3, 21, 3, 3, 21, 
	3, 3, 21, 21, 3, 3, 3, 4, 
	21
};

static const char _thttp_machine_parser_header_WWW_Authenticate_range_lengths[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 5, 
	0, 5, 4, 0, 0, 0, 5, 0, 
	5, 4, 0, 4, 5, 0, 5, 0, 
	0, 2, 0, 0, 0, 0, 0, 0, 
	4, 4, 4, 4, 4, 0, 0, 0, 
	5, 0, 5, 0, 0, 2, 0, 0, 
	2, 4, 3, 3, 3, 3, 0, 3, 
	3, 1, 1, 1, 1, 1, 1, 1, 
	0, 1, 0, 1, 0, 3, 3, 3, 
	3, 3, 3, 0, 3, 3, 3, 3, 
	1, 1, 1, 0, 0, 0, 4, 4, 
	4, 4, 4, 4, 0, 0, 0, 5, 
	0, 5, 0, 0, 2, 0, 0, 2, 
	0, 4, 4, 4, 0, 0, 0, 5, 
	0, 5, 0, 0, 2, 2, 0, 0, 
	0, 0, 0, 4, 4, 4, 4, 4, 
	0, 0, 0, 5, 0, 5, 0, 0, 
	2, 0, 0, 2, 0, 4, 4, 4, 
	4, 4, 0, 0, 0, 5, 0, 5, 
	4, 4, 4, 4, 0, 4, 4, 0, 
	0, 2, 1, 0, 1, 0, 1, 6, 
	0, 6, 5, 1, 0, 1, 6, 0, 
	6, 0, 1, 1, 1, 0, 2, 5, 
	5, 5, 5, 5, 2, 5, 5, 3, 
	3, 3, 3, 3, 3, 3, 2, 3, 
	2, 3, 2, 5, 5, 5, 5, 5, 
	5, 2, 5, 5, 5, 5, 3, 3, 
	3, 2, 2, 0, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 1, 0, 1, 
	6, 0, 6, 5, 0, 5, 5, 5, 
	5, 5, 5, 1, 0, 1, 6, 0, 
	6, 0, 1, 1, 2, 0, 0, 0, 
	2, 1, 0, 1, 6, 0, 6, 5, 
	1, 0, 1, 6, 0, 6, 0, 1, 
	5, 0, 4, 0, 0, 0, 5, 0, 
	5, 4, 0, 4, 5, 0, 5, 0, 
	0, 4, 0, 0, 0, 0, 4, 4, 
	4, 4, 4, 0, 0, 0, 5, 0, 
	5, 0, 0, 1, 0, 1, 0, 1, 
	6, 0, 6, 5, 1, 0, 1, 6, 
	0, 6, 0, 1, 1, 5, 1, 0, 
	5, 5, 5, 5, 2, 5, 5, 3, 
	3, 3, 3, 3, 3, 3, 2, 1, 
	3, 2, 3, 2, 5, 5, 5, 5, 
	5, 5, 2, 5, 5, 5, 5, 3, 
	3, 3, 2, 2, 0, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 1, 0, 
	1, 6, 0, 6, 5, 0, 5, 5, 
	5, 5, 5, 5, 1, 0, 1, 6, 
	0, 6, 0, 1, 1, 0, 5, 5, 
	5, 5, 5, 1, 0, 1, 6, 0, 
	6, 0, 1, 1, 0, 5, 5, 5, 
	5, 5, 5, 1, 0, 1, 6, 0, 
	6, 0, 1, 1, 1, 0, 1, 6, 
	0, 6, 5, 1, 0, 1, 6, 0, 
	6, 0, 1, 1, 5, 0, 5, 5, 
	5, 5, 2, 5, 5, 3, 3, 3, 
	3, 3, 3, 3, 2, 1, 3, 2, 
	3, 2, 5, 5, 5, 5, 5, 5, 
	2, 5, 5, 5, 5, 3, 3, 3, 
	2, 2, 0, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 1, 0, 1, 6, 
	0, 6, 5, 0, 5, 5, 5, 5, 
	5, 5, 1, 0, 1, 6, 0, 6, 
	0, 1, 1, 0, 5, 5, 5, 5, 
	5, 1, 0, 1, 6, 0, 6, 0, 
	1, 1, 0, 5, 5, 5, 5, 5, 
	5, 1, 0, 1, 6, 0, 6, 0, 
	1, 1, 0, 5, 5, 5, 1, 0, 
	1, 6, 0, 6, 0, 1, 1, 1, 
	0, 1, 6, 0, 6, 5, 1, 0, 
	1, 6, 0, 6, 0, 1, 5, 0, 
	4, 0, 0, 0, 5, 0, 5, 4, 
	0, 4, 5, 0, 5, 0, 0, 4, 
	0, 0, 0, 0, 4, 4, 4, 4, 
	4, 0, 0, 0, 5, 0, 5, 0, 
	0, 3, 3, 3, 3, 0, 3, 3, 
	1, 1, 1, 1, 1, 1, 1, 0, 
	0, 1, 0, 1, 0, 3, 3, 3, 
	3, 3, 3, 0, 3, 3, 3, 3, 
	1, 1, 1, 0, 0, 0, 4, 4, 
	4, 4, 4, 4, 0, 0, 0, 5, 
	0, 5, 0, 0, 1, 0, 1, 0, 
	4, 4, 4, 0, 0, 0, 5, 0, 
	5, 0, 4, 4, 4, 4, 4, 0, 
	0, 0, 5, 0, 5, 0, 0, 1, 
	0, 1, 0, 1, 6, 0, 6, 5, 
	1, 0, 1, 6, 0, 6, 0, 1, 
	1, 5, 1, 0, 5, 5, 5, 5, 
	2, 5, 5, 3, 3, 3, 3, 3, 
	3, 3, 2, 1, 3, 2, 3, 2, 
	5, 5, 5, 5, 5, 5, 2, 5, 
	5, 5, 5, 3, 3, 3, 2, 2, 
	0, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 1, 0, 1, 6, 0, 6, 
	5, 0, 5, 5, 5, 5, 5, 5, 
	1, 0, 1, 6, 0, 6, 0, 1, 
	1, 0, 5, 5, 5, 5, 5, 1, 
	0, 1, 6, 0, 6, 0, 1, 1, 
	0, 5, 5, 5, 5, 5, 5, 1, 
	0, 1, 6, 0, 6, 0, 1, 1, 
	0, 5, 5, 5, 1, 0, 1, 6, 
	0, 6, 0, 1, 1, 0, 5, 5, 
	5, 5, 5, 1, 0, 1, 6, 0, 
	6, 0, 1, 1, 0, 5, 5, 5, 
	5, 5, 1, 0, 1, 6, 0, 6, 
	5, 5, 5, 5, 1, 5, 5, 0, 
	0, 4, 4, 4, 4, 4, 0, 0, 
	0, 5, 0, 5, 4, 4, 4, 4, 
	0, 4, 4, 0, 4, 4, 4, 4, 
	4, 0, 0, 0, 5, 0, 5, 0, 
	0, 1, 1, 0, 1, 4, 4, 4, 
	4, 4, 4, 0, 0, 0, 5, 0, 
	5, 0, 0, 3, 3, 3, 3, 0, 
	3, 3, 1, 1, 1, 1, 1, 1, 
	1, 0, 0, 1, 0, 1, 0, 3, 
	3, 3, 3, 3, 3, 0, 3, 3, 
	3, 3, 1, 1, 1, 0, 0, 0, 
	4, 4, 4, 0, 0, 0, 5, 0, 
	5, 0, 0, 1, 1, 0, 1, 0, 
	4, 4, 4, 4, 4, 0, 0, 0, 
	5, 0, 5, 0, 0, 0, 4, 4, 
	4, 4, 4, 0, 0, 0, 5, 0, 
	5, 4, 4, 4, 4, 0, 4, 4, 
	0, 0, 4, 4, 4, 4, 4, 4, 
	4, 4, 0, 0, 0, 5, 0, 5, 
	4, 0, 5, 5, 5, 5, 2, 5, 
	5, 3, 3, 3, 3, 3, 3, 3, 
	2, 1, 3, 2, 3, 2, 5, 5, 
	5, 5, 5, 5, 2, 5, 5, 5, 
	5, 3, 3, 3, 2, 2, 0, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	1, 0, 1, 6, 0, 6, 5, 0, 
	5, 5, 5, 5, 5, 5, 1, 0, 
	1, 6, 0, 6, 0, 1, 0, 5, 
	5, 5, 5, 5, 1, 0, 1, 6, 
	0, 6, 0, 1, 0, 5, 5, 5, 
	5, 5, 5, 1, 0, 1, 6, 0, 
	6, 0, 1, 0, 5, 5, 5, 1, 
	0, 1, 6, 0, 6, 0, 5, 5, 
	5, 5, 5, 1, 0, 1, 6, 0, 
	6, 0, 1, 0, 5, 5, 5, 5, 
	5, 1, 0, 1, 6, 0, 6, 5, 
	5, 5, 5, 1, 5, 5, 0, 0, 
	5, 5, 5, 5, 5, 1, 0, 1, 
	6, 0, 6, 0, 1, 1, 0, 5, 
	5, 5, 5, 5, 1, 0, 1, 6, 
	0, 6, 5, 5, 5, 5, 1, 5, 
	5, 0, 0, 5, 5, 5, 1, 0, 
	1, 6, 0, 6, 0, 1, 1, 0, 
	5, 5, 5, 5, 5, 1, 0, 1, 
	6, 0, 6, 0, 1, 1, 0, 5, 
	5, 5, 5, 5, 1, 0, 1, 6, 
	0, 6, 5, 5, 5, 5, 1, 5, 
	5, 0, 0, 4, 4, 4, 4, 4, 
	0, 0, 0, 5, 0, 5, 0, 4, 
	4, 4, 4, 4, 4, 4, 4, 0, 
	0, 0, 5, 0, 5, 4, 0, 5, 
	5, 5, 5, 2, 5, 5, 3, 3, 
	3, 3, 3, 3, 3, 2, 1, 3, 
	2, 3, 2, 5, 5, 5, 5, 5, 
	5, 2, 5, 5, 5, 5, 3, 3, 
	3, 2, 2, 0, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 1, 0, 1, 
	6, 0, 6, 5, 0, 5, 5, 5, 
	5, 5, 5, 1, 0, 1, 6, 0, 
	6, 0, 5, 5, 5, 5, 5, 1, 
	0, 1, 6, 0, 6, 0, 1, 0, 
	5, 5, 5, 5, 5, 5, 1, 0, 
	1, 6, 0, 6, 0, 1, 0, 5, 
	5, 5, 1, 0, 1, 6, 0, 6, 
	0, 1, 0, 5, 5, 5, 5, 5, 
	1, 0, 1, 6, 0, 6, 0, 1, 
	0, 5, 5, 5, 5, 5, 1, 0, 
	1, 6, 0, 6, 5, 5, 5, 5, 
	1, 5, 5, 0, 0, 5, 5, 5, 
	5, 5, 1, 0, 1, 6, 0, 6, 
	0, 1, 0, 5, 5, 5, 5, 5, 
	5, 1, 0, 1, 6, 0, 6, 0, 
	1, 0, 5, 5, 5, 1, 0, 1, 
	6, 0, 6, 0, 1, 1, 0, 5, 
	5, 5, 5, 5, 1, 0, 1, 6, 
	0, 6, 0, 1, 0, 5, 5, 5, 
	5, 5, 1, 0, 1, 6, 0, 6, 
	5, 5, 5, 5, 1, 5, 5, 0, 
	0, 4, 4, 4, 4, 4, 0, 0, 
	0, 5, 0, 5, 0, 0, 2, 0, 
	4, 4, 4, 4, 4, 4, 4, 4, 
	0, 0, 0, 5, 0, 5, 4, 0, 
	4, 4, 4, 4, 4, 4, 0, 0, 
	0, 5, 0, 5, 0, 0, 2, 2, 
	0, 2, 1, 0, 1, 0, 1, 6, 
	0, 6, 5, 1, 0, 1, 6, 0, 
	6, 5, 1, 0, 5, 5, 5, 5, 
	2, 5, 5, 3, 3, 3, 3, 3, 
	3, 3, 2, 1, 3, 2, 3, 2, 
	5, 5, 5, 5, 5, 5, 2, 5, 
	5, 5, 5, 3, 3, 3, 2, 2, 
	0, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 1, 0, 1, 6, 0, 6, 
	5, 0, 5, 5, 5, 5, 5, 5, 
	1, 0, 1, 6, 0, 6, 0, 1, 
	1, 0, 5, 5, 5, 5, 5, 1, 
	0, 1, 6, 0, 6, 0, 5, 5, 
	5, 5, 5, 5, 1, 0, 1, 6, 
	0, 6, 0, 5, 5, 5, 1, 0, 
	1, 6, 0, 6, 0, 1, 1, 0, 
	5, 5, 5, 5, 5, 1, 0, 1, 
	6, 0, 6, 0, 5, 5, 5, 5, 
	5, 1, 0, 1, 6, 0, 6, 5, 
	5, 5, 5, 1, 5, 5, 0, 0, 
	4, 4, 4, 0, 0, 0, 5, 0, 
	5, 0, 0, 2, 2, 0, 2, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 5, 
	0, 0, 0, 0, 5, 0, 0, 0, 
	0, 5, 0, 0, 0, 0, 5, 0, 
	0, 0, 0, 5, 0, 0, 0, 0, 
	5, 0, 0, 5, 0, 5, 5, 0, 
	0, 0, 0, 0, 5, 0, 0, 5, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 5, 0, 0, 5, 0, 0, 
	0, 5, 0, 0, 0, 5, 5, 0, 
	0, 0, 0, 0, 5, 0, 0, 5, 
	0, 0, 0, 5, 0, 0, 0, 5, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	5, 5, 0, 0, 5, 0, 0, 0, 
	5, 0, 0, 0, 5, 0, 0, 0, 
	5, 0, 0, 0, 0, 0, 0, 0, 
	0, 5, 0, 0, 5, 0, 0, 0, 
	5, 0, 0, 0, 5, 0, 0, 0, 
	5, 5, 0, 0, 5, 0, 0, 0, 
	5, 5, 0, 0, 0, 0, 0, 5, 
	0, 0, 5, 0, 0, 0, 5, 0, 
	0, 0, 5, 0, 0, 0, 5, 0, 
	0, 0, 5, 0, 0, 0, 5, 0, 
	0, 5, 5, 0, 0, 5, 0, 0, 
	0, 5, 0, 0, 0, 5, 0, 0, 
	0, 5, 5, 0, 0, 0, 5, 0, 
	0, 5, 5, 0, 0, 5, 5, 0, 
	0, 5, 0, 0, 0, 5, 0, 0, 
	0, 5, 0, 0, 0, 5, 0, 0, 
	5, 0, 0, 0, 5, 0, 0, 5, 
	5, 0, 0, 0, 5, 0, 0, 5, 
	5, 0, 0, 0, 5, 0, 0, 0, 
	5, 0, 0, 5, 5, 0, 0, 5, 
	0, 0, 5, 5, 0, 0, 5, 0, 
	0, 5, 0, 0, 0, 5, 0, 0, 
	0, 5, 0, 0, 0, 5, 0, 0, 
	0, 5, 0, 0, 5, 5, 0, 0, 
	0, 5, 0, 0, 0, 5, 0, 0, 
	0, 5, 0, 0, 0, 5, 0, 0, 
	5, 5, 0, 0, 0, 5, 0, 0, 
	5, 0, 0, 0, 0, 5, 5, 0, 
	0, 0, 0, 5, 0, 0, 5, 0, 
	0, 0, 5, 0, 0, 5, 0, 0, 
	5, 0, 0, 0, 5, 0, 0, 5, 
	0, 0, 5, 5, 0, 0, 0, 0, 
	5
};

static const short _thttp_machine_parser_header_WWW_Authenticate_index_offsets[] = {
	0, 0, 5, 8, 11, 14, 17, 19, 
	22, 25, 28, 31, 34, 37, 40, 43, 
	46, 49, 52, 55, 59, 67, 69, 72, 
	80, 83, 91, 95, 99, 103, 107, 111, 
	138, 141, 168, 182, 188, 191, 197, 224, 
	227, 254, 270, 273, 289, 304, 307, 322, 
	325, 330, 337, 340, 345, 350, 353, 358, 
	361, 377, 393, 409, 425, 439, 445, 448, 
	454, 469, 472, 487, 490, 495, 502, 505, 
	510, 514, 527, 533, 540, 547, 554, 558, 
	564, 572, 575, 579, 582, 586, 589, 593, 
	597, 600, 604, 607, 611, 614, 622, 630, 
	637, 644, 651, 658, 662, 667, 675, 683, 
	691, 694, 698, 702, 705, 708, 711, 727, 
	743, 759, 775, 791, 805, 811, 814, 820, 
	835, 838, 853, 856, 861, 868, 871, 876, 
	880, 883, 899, 915, 929, 935, 938, 944, 
	959, 962, 977, 980, 985, 992, 999, 1002, 
	1006, 1011, 1014, 1019, 1035, 1051, 1067, 1083, 
	1097, 1103, 1106, 1112, 1127, 1130, 1145, 1148, 
	1153, 1160, 1163, 1168, 1172, 1175, 1191, 1207, 
	1223, 1239, 1253, 1259, 1262, 1268, 1287, 1290, 
	1309, 1324, 1339, 1354, 1369, 1374, 1389, 1404, 
	1407, 1411, 1416, 1425, 1428, 1437, 1440, 1449, 
	1480, 1483, 1514, 1532, 1542, 1545, 1555, 1573, 
	1576, 1594, 1597, 1605, 1614, 1623, 1626, 1630, 
	1647, 1658, 1670, 1682, 1694, 1703, 1714, 1727, 
	1735, 1744, 1752, 1761, 1769, 1778, 1787, 1795, 
	1804, 1812, 1821, 1829, 1842, 1855, 1867, 1879, 
	1891, 1903, 1912, 1922, 1935, 1948, 1961, 1969, 
	1978, 1987, 1995, 2003, 2006, 2026, 2046, 2066, 
	2086, 2106, 2126, 2146, 2166, 2184, 2194, 2197, 
	2207, 2225, 2228, 2246, 2263, 2266, 2286, 2306, 
	2326, 2346, 2366, 2384, 2394, 2397, 2407, 2425, 
	2428, 2446, 2449, 2457, 2466, 2473, 2476, 2480, 
	2484, 2489, 2498, 2502, 2511, 2542, 2546, 2577, 
	2595, 2605, 2609, 2619, 2637, 2641, 2659, 2663, 
	2671, 2688, 2692, 2707, 2714, 2718, 2725, 2753, 
	2757, 2785, 2802, 2806, 2823, 2838, 2842, 2857, 
	2861, 2866, 2880, 2886, 2890, 2896, 2900, 2917, 
	2934, 2951, 2968, 2983, 2990, 2994, 3001, 3016, 
	3020, 3035, 3039, 3044, 3053, 3056, 3065, 3068, 
	3077, 3108, 3111, 3142, 3160, 3170, 3173, 3183, 
	3201, 3204, 3222, 3225, 3233, 3242, 3259, 3268, 
	3271, 3282, 3294, 3306, 3318, 3327, 3338, 3351, 
	3359, 3368, 3376, 3385, 3393, 3402, 3411, 3419, 
	3428, 3437, 3445, 3454, 3462, 3475, 3488, 3500, 
	3512, 3524, 3536, 3545, 3555, 3568, 3581, 3594, 
	3602, 3611, 3620, 3628, 3636, 3639, 3659, 3679, 
	3699, 3719, 3739, 3759, 3779, 3799, 3817, 3827, 
	3830, 3840, 3858, 3861, 3879, 3896, 3899, 3919, 
	3939, 3959, 3979, 3999, 4017, 4027, 4030, 4040, 
	4058, 4061, 4079, 4082, 4090, 4099, 4102, 4122, 
	4142, 4162, 4182, 4200, 4210, 4213, 4223, 4241, 
	4244, 4262, 4265, 4273, 4282, 4285, 4305, 4325, 
	4345, 4365, 4385, 4403, 4413, 4416, 4426, 4444, 
	4447, 4465, 4468, 4476, 4485, 4494, 4497, 4506, 
	4537, 4540, 4571, 4589, 4599, 4602, 4612, 4630, 
	4633, 4651, 4654, 4662, 4671, 4688, 4691, 4702, 
	4714, 4726, 4738, 4747, 4758, 4771, 4779, 4788, 
	4796, 4805, 4813, 4822, 4831, 4839, 4848, 4857, 
	4865, 4874, 4882, 4895, 4908, 4920, 4932, 4944, 
	4956, 4965, 4975, 4988, 5001, 5014, 5022, 5031, 
	5040, 5048, 5056, 5059, 5079, 5099, 5119, 5139, 
	5159, 5179, 5199, 5219, 5237, 5247, 5250, 5260, 
	5278, 5281, 5299, 5316, 5319, 5339, 5359, 5379, 
	5399, 5419, 5437, 5447, 5450, 5460, 5478, 5481, 
	5499, 5502, 5510, 5519, 5522, 5542, 5562, 5582, 
	5602, 5620, 5630, 5633, 5643, 5661, 5664, 5682, 
	5685, 5693, 5702, 5705, 5725, 5745, 5765, 5785, 
	5805, 5823, 5833, 5836, 5846, 5864, 5867, 5885, 
	5888, 5896, 5905, 5908, 5928, 5948, 5966, 5976, 
	5979, 5989, 6007, 6010, 6028, 6031, 6039, 6048, 
	6057, 6061, 6070, 6101, 6105, 6136, 6154, 6164, 
	6168, 6178, 6196, 6200, 6218, 6222, 6230, 6247, 
	6251, 6266, 6273, 6277, 6284, 6312, 6316, 6344, 
	6361, 6365, 6382, 6397, 6401, 6416, 6420, 6425, 
	6439, 6445, 6449, 6455, 6459, 6476, 6493, 6510, 
	6527, 6542, 6549, 6553, 6560, 6575, 6579, 6594, 
	6598, 6603, 6610, 6618, 6626, 6634, 6639, 6646, 
	6655, 6659, 6664, 6668, 6673, 6677, 6682, 6687, 
	6691, 6697, 6702, 6706, 6711, 6715, 6724, 6733, 
	6741, 6749, 6757, 6765, 6770, 6776, 6785, 6794, 
	6803, 6807, 6812, 6817, 6821, 6825, 6829, 6846, 
	6863, 6880, 6897, 6914, 6929, 6936, 6940, 6947, 
	6962, 6966, 6981, 6985, 6990, 6999, 7002, 7011, 
	7015, 7032, 7049, 7064, 7071, 7075, 7082, 7097, 
	7101, 7116, 7120, 7137, 7154, 7171, 7188, 7203, 
	7210, 7214, 7221, 7236, 7240, 7255, 7259, 7264, 
	7273, 7276, 7285, 7288, 7297, 7328, 7331, 7362, 
	7380, 7390, 7393, 7403, 7421, 7424, 7442, 7445, 
	7453, 7462, 7479, 7488, 7491, 7502, 7514, 7526, 
	7538, 7547, 7558, 7571, 7579, 7588, 7596, 7605, 
	7613, 7622, 7631, 7639, 7648, 7657, 7665, 7674, 
	7682, 7695, 7708, 7720, 7732, 7744, 7756, 7765, 
	7775, 7788, 7801, 7814, 7822, 7831, 7840, 7848, 
	7856, 7859, 7879, 7899, 7919, 7939, 7959, 7979, 
	7999, 8019, 8037, 8047, 8050, 8060, 8078, 8081, 
	8099, 8116, 8119, 8139, 8159, 8179, 8199, 8219, 
	8237, 8247, 8250, 8260, 8278, 8281, 8299, 8302, 
	8310, 8319, 8322, 8342, 8362, 8382, 8402, 8420, 
	8430, 8433, 8443, 8461, 8464, 8482, 8485, 8493, 
	8502, 8505, 8525, 8545, 8565, 8585, 8605, 8623, 
	8633, 8636, 8646, 8664, 8667, 8685, 8688, 8696, 
	8705, 8708, 8728, 8748, 8766, 8776, 8779, 8789, 
	8807, 8810, 8828, 8831, 8839, 8848, 8851, 8871, 
	8891, 8911, 8931, 8949, 8959, 8962, 8972, 8990, 
	8993, 9011, 9014, 9022, 9031, 9034, 9054, 9074, 
	9094, 9114, 9132, 9142, 9145, 9155, 9177, 9180, 
	9202, 9221, 9240, 9259, 9278, 9287, 9306, 9325, 
	9328, 9332, 9349, 9366, 9383, 9400, 9415, 9422, 
	9426, 9433, 9452, 9456, 9475, 9491, 9507, 9523, 
	9539, 9545, 9561, 9577, 9581, 9598, 9615, 9632, 
	9649, 9664, 9671, 9675, 9682, 9697, 9701, 9716, 
	9720, 9725, 9734, 9743, 9747, 9756, 9773, 9790, 
	9807, 9824, 9841, 9856, 9863, 9867, 9874, 9889, 
	9893, 9908, 9912, 9917, 9924, 9932, 9940, 9948, 
	9953, 9960, 9969, 9973, 9978, 9982, 9987, 9991, 
	9996, 10001, 10005, 10011, 10016, 10020, 10025, 10029, 
	10038, 10047, 10055, 10063, 10071, 10079, 10084, 10090, 
	10099, 10108, 10117, 10121, 10126, 10131, 10135, 10139, 
	10143, 10160, 10177, 10192, 10199, 10203, 10210, 10225, 
	10229, 10244, 10248, 10253, 10262, 10271, 10275, 10284, 
	10288, 10305, 10322, 10339, 10356, 10371, 10378, 10382, 
	10389, 10404, 10408, 10423, 10427, 10432, 10436, 10453, 
	10470, 10487, 10504, 10519, 10526, 10530, 10537, 10556, 
	10560, 10579, 10595, 10611, 10627, 10643, 10649, 10665, 
	10681, 10685, 10689, 10706, 10723, 10740, 10757, 10774, 
	10791, 10808, 10823, 10830, 10834, 10841, 10856, 10860, 
	10875, 10889, 10893, 10904, 10916, 10928, 10940, 10949, 
	10960, 10973, 10981, 10990, 10998, 11007, 11015, 11024, 
	11033, 11041, 11050, 11059, 11067, 11076, 11084, 11097, 
	11110, 11122, 11134, 11146, 11158, 11167, 11177, 11190, 
	11203, 11216, 11224, 11233, 11242, 11250, 11258, 11262, 
	11282, 11302, 11322, 11342, 11362, 11382, 11402, 11422, 
	11440, 11450, 11454, 11464, 11482, 11486, 11504, 11521, 
	11525, 11545, 11565, 11585, 11605, 11625, 11643, 11653, 
	11657, 11667, 11685, 11689, 11707, 11711, 11719, 11723, 
	11743, 11763, 11783, 11803, 11821, 11831, 11835, 11845, 
	11863, 11867, 11885, 11889, 11897, 11901, 11921, 11941, 
	11961, 11981, 12001, 12019, 12029, 12033, 12043, 12061, 
	12065, 12083, 12087, 12095, 12099, 12119, 12139, 12157, 
	12167, 12171, 12181, 12199, 12203, 12221, 12225, 12245, 
	12265, 12285, 12305, 12323, 12333, 12337, 12347, 12365, 
	12369, 12387, 12391, 12399, 12403, 12423, 12443, 12463, 
	12483, 12501, 12511, 12515, 12525, 12547, 12551, 12573, 
	12592, 12611, 12630, 12649, 12658, 12677, 12696, 12700, 
	12703, 12723, 12743, 12763, 12783, 12801, 12811, 12814, 
	12824, 12842, 12845, 12863, 12866, 12874, 12883, 12886, 
	12906, 12926, 12946, 12966, 12984, 12994, 12997, 13007, 
	13029, 13032, 13054, 13073, 13092, 13111, 13130, 13139, 
	13158, 13177, 13180, 13183, 13203, 13223, 13241, 13251, 
	13254, 13264, 13282, 13285, 13303, 13306, 13314, 13323, 
	13326, 13346, 13366, 13386, 13406, 13424, 13434, 13437, 
	13447, 13465, 13468, 13486, 13489, 13497, 13506, 13509, 
	13529, 13549, 13569, 13589, 13607, 13617, 13620, 13630, 
	13652, 13655, 13677, 13696, 13715, 13734, 13753, 13762, 
	13781, 13800, 13803, 13807, 13824, 13841, 13858, 13875, 
	13890, 13897, 13901, 13908, 13923, 13927, 13942, 13946, 
	13963, 13980, 13997, 14014, 14031, 14048, 14065, 14080, 
	14087, 14091, 14098, 14113, 14117, 14132, 14146, 14150, 
	14161, 14173, 14185, 14197, 14206, 14217, 14230, 14238, 
	14247, 14255, 14264, 14272, 14281, 14290, 14298, 14307, 
	14316, 14324, 14333, 14341, 14354, 14367, 14379, 14391, 
	14403, 14415, 14424, 14434, 14447, 14460, 14473, 14481, 
	14490, 14499, 14507, 14515, 14519, 14539, 14559, 14579, 
	14599, 14619, 14639, 14659, 14679, 14697, 14707, 14711, 
	14721, 14739, 14743, 14761, 14778, 14782, 14802, 14822, 
	14842, 14862, 14882, 14900, 14910, 14914, 14924, 14942, 
	14946, 14964, 14968, 14988, 15008, 15028, 15048, 15066, 
	15076, 15080, 15090, 15108, 15112, 15130, 15134, 15142, 
	15146, 15166, 15186, 15206, 15226, 15246, 15264, 15274, 
	15278, 15288, 15306, 15310, 15328, 15332, 15340, 15344, 
	15364, 15384, 15402, 15412, 15416, 15426, 15444, 15448, 
	15466, 15470, 15478, 15482, 15502, 15522, 15542, 15562, 
	15580, 15590, 15594, 15604, 15622, 15626, 15644, 15648, 
	15656, 15660, 15680, 15700, 15720, 15740, 15758, 15768, 
	15772, 15782, 15804, 15808, 15830, 15849, 15868, 15887, 
	15906, 15915, 15934, 15953, 15957, 15960, 15980, 16000, 
	16020, 16040, 16058, 16068, 16071, 16081, 16099, 16102, 
	16120, 16123, 16131, 16134, 16154, 16174, 16194, 16214, 
	16234, 16252, 16262, 16265, 16275, 16293, 16296, 16314, 
	16317, 16325, 16328, 16348, 16368, 16386, 16396, 16399, 
	16409, 16427, 16430, 16448, 16451, 16459, 16468, 16471, 
	16491, 16511, 16531, 16551, 16569, 16579, 16582, 16592, 
	16610, 16613, 16631, 16634, 16642, 16645, 16665, 16685, 
	16705, 16725, 16743, 16753, 16756, 16766, 16788, 16791, 
	16813, 16832, 16851, 16870, 16889, 16898, 16917, 16936, 
	16939, 16942, 16958, 16974, 16990, 17006, 17020, 17026, 
	17029, 17035, 17050, 17053, 17068, 17071, 17076, 17083, 
	17086, 17102, 17118, 17134, 17150, 17166, 17182, 17198, 
	17212, 17218, 17221, 17227, 17242, 17245, 17260, 17273, 
	17276, 17292, 17308, 17324, 17340, 17356, 17370, 17376, 
	17379, 17385, 17400, 17403, 17418, 17421, 17426, 17433, 
	17440, 17444, 17449, 17458, 17461, 17470, 17473, 17482, 
	17513, 17516, 17547, 17565, 17575, 17578, 17588, 17606, 
	17609, 17627, 17644, 17653, 17656, 17667, 17679, 17691, 
	17703, 17712, 17723, 17736, 17744, 17753, 17761, 17770, 
	17778, 17787, 17796, 17804, 17813, 17822, 17830, 17839, 
	17847, 17860, 17873, 17885, 17897, 17909, 17921, 17930, 
	17940, 17953, 17966, 17979, 17987, 17996, 18005, 18013, 
	18021, 18024, 18044, 18064, 18084, 18104, 18124, 18144, 
	18164, 18184, 18202, 18212, 18215, 18225, 18243, 18246, 
	18264, 18281, 18284, 18304, 18324, 18344, 18364, 18384, 
	18402, 18412, 18415, 18425, 18443, 18446, 18464, 18467, 
	18475, 18484, 18487, 18507, 18527, 18547, 18567, 18585, 
	18595, 18598, 18608, 18626, 18629, 18647, 18650, 18670, 
	18690, 18710, 18730, 18750, 18768, 18778, 18781, 18791, 
	18809, 18812, 18830, 18833, 18853, 18873, 18891, 18901, 
	18904, 18914, 18932, 18935, 18953, 18956, 18964, 18973, 
	18976, 18996, 19016, 19036, 19056, 19074, 19084, 19087, 
	19097, 19115, 19118, 19136, 19139, 19159, 19179, 19199, 
	19219, 19237, 19247, 19250, 19260, 19282, 19285, 19307, 
	19326, 19345, 19364, 19383, 19392, 19411, 19430, 19433, 
	19436, 19452, 19468, 19482, 19488, 19491, 19497, 19512, 
	19515, 19530, 19533, 19538, 19545, 19552, 19556, 19561, 
	19564, 19568, 19572, 19576, 19580, 19584, 19588, 19591, 
	19595, 19598, 19601, 19603, 19607, 19611, 19615, 19619, 
	19646, 19650, 19654, 19658, 19662, 19689, 19693, 19697, 
	19701, 19705, 19732, 19736, 19740, 19744, 19748, 19775, 
	19779, 19783, 19787, 19790, 19817, 19821, 19825, 19829, 
	19833, 19860, 19864, 19868, 19895, 19900, 19927, 19954, 
	19958, 19962, 19966, 19970, 19974, 20001, 20005, 20009, 
	20036, 20040, 20044, 20048, 20051, 20056, 20061, 20066, 
	20071, 20076, 20081, 20109, 20114, 20119, 20147, 20152, 
	20157, 20162, 20190, 20195, 20200, 20205, 20232, 20259, 
	20263, 20267, 20271, 20275, 20279, 20306, 20310, 20314, 
	20341, 20345, 20349, 20353, 20380, 20384, 20388, 20392, 
	20419, 20423, 20427, 20431, 20435, 20439, 20443, 20447, 
	20451, 20478, 20505, 20509, 20513, 20540, 20544, 20548, 
	20552, 20579, 20583, 20587, 20591, 20618, 20622, 20626, 
	20630, 20657, 20661, 20665, 20669, 20674, 20679, 20684, 
	20689, 20694, 20722, 20727, 20732, 20760, 20765, 20770, 
	20775, 20803, 20808, 20813, 20818, 20846, 20851, 20856, 
	20861, 20888, 20916, 20921, 20926, 20954, 20959, 20964, 
	20969, 20996, 21023, 21027, 21031, 21035, 21039, 21043, 
	21070, 21074, 21078, 21105, 21109, 21113, 21117, 21144, 
	21148, 21152, 21156, 21183, 21187, 21191, 21195, 21222, 
	21226, 21230, 21234, 21261, 21265, 21269, 21273, 21300, 
	21304, 21308, 21335, 21363, 21368, 21373, 21401, 21406, 
	21411, 21416, 21444, 21449, 21454, 21459, 21487, 21492, 
	21497, 21502, 21530, 21558, 21563, 21568, 21573, 21601, 
	21606, 21611, 21639, 21667, 21672, 21677, 21705, 21733, 
	21738, 21743, 21771, 21776, 21781, 21786, 21814, 21819, 
	21824, 21829, 21857, 21862, 21867, 21872, 21900, 21905, 
	21910, 21938, 21943, 21948, 21953, 21981, 21986, 21991, 
	22019, 22046, 22050, 22054, 22058, 22085, 22089, 22093, 
	22120, 22147, 22151, 22155, 22159, 22186, 22190, 22194, 
	22198, 22225, 22229, 22233, 22260, 22288, 22293, 22298, 
	22326, 22331, 22336, 22364, 22392, 22397, 22402, 22430, 
	22435, 22440, 22468, 22473, 22478, 22483, 22511, 22516, 
	22521, 22526, 22554, 22559, 22564, 22569, 22597, 22602, 
	22607, 22612, 22640, 22645, 22650, 22678, 22705, 22709, 
	22713, 22717, 22744, 22748, 22752, 22756, 22783, 22787, 
	22791, 22795, 22822, 22826, 22830, 22834, 22861, 22865, 
	22869, 22896, 22923, 22927, 22931, 22935, 22962, 22966, 
	22970, 22997, 23001, 23005, 23009, 23014, 23041, 23068, 
	23072, 23076, 23080, 23084, 23111, 23115, 23119, 23146, 
	23150, 23154, 23158, 23185, 23189, 23193, 23220, 23224, 
	23228, 23255, 23259, 23263, 23267, 23294, 23298, 23302, 
	23329, 23333, 23337, 23364, 23391, 23395, 23399, 23403, 
	23408
};

static const short _thttp_machine_parser_header_WWW_Authenticate_indicies[] = {
	0, 2, 0, 2, 1, 3, 3, 1, 
	4, 4, 1, 5, 5, 1, 6, 6, 
	1, 7, 1, 8, 8, 1, 9, 9, 
	1, 10, 10, 1, 11, 11, 1, 12, 
	12, 1, 13, 13, 1, 14, 14, 1, 
	15, 15, 1, 16, 16, 1, 17, 17, 
	1, 18, 18, 1, 19, 19, 1, 19, 
	19, 20, 1, 22, 23, 22, 24, 25, 
	24, 25, 21, 26, 21, 27, 26, 21, 
	22, 28, 22, 24, 25, 24, 25, 21, 
	29, 26, 21, 30, 26, 30, 24, 25, 
	24, 25, 21, 26, 31, 31, 21, 26, 
	32, 32, 21, 26, 33, 33, 21, 26, 
	34, 34, 21, 35, 36, 35, 21, 37, 
	38, 37, 39, 39, 39, 40, 41, 42, 
	43, 44, 45, 46, 40, 41, 42, 43, 
	44, 45, 46, 39, 39, 39, 39, 39, 
	39, 21, 47, 26, 21, 48, 26, 48, 
	39, 39, 39, 40, 41, 42, 43, 44, 
	45, 46, 40, 41, 42, 43, 44, 45, 
	46, 39, 39, 39, 39, 39, 39, 21, 
	49, 50, 49, 51, 51, 51, 52, 53, 
	51, 51, 51, 51, 51, 21, 54, 55, 
	54, 56, 53, 21, 57, 26, 21, 58, 
	26, 58, 56, 53, 21, 56, 59, 56, 
	39, 39, 39, 40, 60, 42, 43, 61, 
	45, 46, 40, 60, 42, 43, 61, 45, 
	46, 39, 39, 39, 39, 39, 39, 21, 
	62, 26, 21, 63, 26, 63, 39, 39, 
	39, 40, 60, 42, 43, 61, 45, 46, 
	40, 60, 42, 43, 61, 45, 46, 39, 
	39, 39, 39, 39, 39, 21, 49, 50, 
	49, 51, 51, 51, 52, 53, 64, 64, 
	51, 51, 51, 51, 51, 21, 65, 26, 
	21, 49, 50, 49, 51, 51, 51, 52, 
	53, 66, 66, 51, 51, 51, 51, 51, 
	21, 53, 67, 53, 68, 69, 68, 68, 
	70, 68, 68, 68, 68, 68, 68, 21, 
	71, 26, 21, 72, 73, 72, 68, 69, 
	68, 68, 70, 68, 68, 68, 68, 68, 
	68, 21, 74, 26, 21, 75, 26, 75, 
	69, 21, 76, 77, 78, 21, 21, 21, 
	69, 79, 26, 21, 80, 81, 80, 52, 
	21, 82, 83, 82, 56, 21, 84, 26, 
	21, 85, 26, 85, 56, 21, 86, 26, 
	21, 49, 50, 49, 51, 51, 51, 52, 
	53, 87, 87, 51, 51, 51, 51, 51, 
	21, 49, 50, 49, 51, 51, 51, 52, 
	53, 88, 88, 51, 51, 51, 51, 51, 
	21, 49, 50, 49, 51, 51, 51, 52, 
	53, 89, 89, 51, 51, 51, 51, 51, 
	21, 49, 50, 49, 51, 51, 51, 52, 
	53, 90, 90, 51, 51, 51, 51, 51, 
	21, 91, 92, 91, 51, 51, 51, 52, 
	93, 51, 51, 51, 51, 51, 21, 94, 
	95, 94, 56, 93, 21, 96, 26, 21, 
	97, 26, 97, 56, 93, 21, 98, 99, 
	98, 68, 100, 68, 68, 70, 68, 68, 
	68, 68, 68, 68, 21, 101, 26, 21, 
	102, 103, 102, 68, 100, 68, 68, 70, 
	68, 68, 68, 68, 68, 68, 21, 104, 
	26, 21, 105, 26, 105, 106, 21, 107, 
	108, 109, 21, 21, 21, 106, 110, 26, 
	21, 111, 112, 111, 113, 21, 26, 106, 
	106, 21, 80, 81, 80, 68, 68, 68, 
	52, 68, 68, 68, 68, 68, 21, 26, 
	115, 114, 114, 114, 21, 26, 117, 77, 
	116, 116, 116, 21, 26, 117, 77, 118, 
	118, 118, 21, 26, 117, 77, 119, 119, 
	119, 21, 26, 117, 77, 21, 26, 121, 
	120, 114, 114, 21, 26, 122, 117, 77, 
	123, 116, 116, 21, 26, 124, 21, 26, 
	125, 126, 21, 26, 127, 21, 26, 128, 
	129, 21, 26, 130, 21, 26, 77, 131, 
	21, 26, 77, 132, 21, 26, 77, 21, 
	26, 128, 133, 21, 26, 128, 21, 26, 
	125, 134, 21, 26, 125, 21, 26, 122, 
	117, 77, 135, 118, 118, 21, 26, 122, 
	117, 77, 119, 119, 119, 21, 26, 137, 
	77, 136, 136, 136, 21, 26, 139, 77, 
	138, 138, 138, 21, 26, 139, 77, 140, 
	140, 140, 21, 26, 139, 77, 141, 141, 
	141, 21, 26, 139, 77, 21, 26, 142, 
	136, 136, 21, 26, 122, 139, 77, 143, 
	138, 138, 21, 26, 122, 139, 77, 144, 
	140, 140, 21, 26, 122, 139, 77, 141, 
	141, 141, 21, 26, 145, 21, 26, 122, 
	146, 21, 26, 122, 147, 21, 26, 122, 
	21, 26, 121, 21, 148, 26, 21, 49, 
	50, 49, 51, 51, 51, 52, 53, 149, 
	149, 51, 51, 51, 51, 51, 21, 49, 
	50, 49, 51, 51, 51, 52, 53, 150, 
	150, 51, 51, 51, 51, 51, 21, 49, 
	50, 49, 51, 51, 51, 52, 53, 151, 
	151, 51, 51, 51, 51, 51, 21, 49, 
	50, 49, 51, 51, 51, 52, 53, 152, 
	152, 51, 51, 51, 51, 51, 21, 49, 
	50, 49, 51, 51, 51, 52, 53, 153, 
	153, 51, 51, 51, 51, 51, 21, 154, 
	155, 154, 51, 51, 51, 52, 156, 51, 
	51, 51, 51, 51, 21, 157, 158, 157, 
	56, 156, 21, 159, 26, 21, 160, 26, 
	160, 56, 156, 21, 161, 162, 161, 68, 
	163, 68, 68, 70, 68, 68, 68, 68, 
	68, 68, 21, 164, 26, 21, 165, 166, 
	165, 68, 163, 68, 68, 70, 68, 68, 
	68, 68, 68, 68, 21, 167, 26, 21, 
	168, 26, 168, 169, 21, 170, 171, 172, 
	21, 21, 21, 169, 173, 26, 21, 174, 
	175, 174, 176, 21, 26, 169, 169, 21, 
	177, 26, 21, 49, 50, 49, 51, 51, 
	51, 52, 53, 178, 178, 51, 51, 51, 
	51, 51, 21, 49, 50, 49, 51, 51, 
	51, 52, 53, 179, 179, 51, 51, 51, 
	51, 51, 21, 180, 181, 180, 51, 51, 
	51, 52, 182, 51, 51, 51, 51, 51, 
	21, 183, 184, 183, 56, 182, 21, 185, 
	26, 21, 186, 26, 186, 56, 182, 21, 
	182, 187, 182, 68, 188, 68, 68, 70, 
	68, 68, 68, 68, 68, 68, 21, 189, 
	26, 21, 190, 191, 190, 68, 188, 68, 
	68, 70, 68, 68, 68, 68, 68, 68, 
	21, 192, 26, 21, 193, 26, 193, 188, 
	21, 196, 197, 198, 195, 195, 195, 194, 
	201, 202, 203, 200, 200, 200, 199, 204, 
	202, 200, 205, 204, 202, 200, 206, 207, 
	206, 56, 21, 208, 26, 21, 209, 210, 
	209, 56, 21, 49, 50, 49, 51, 51, 
	51, 52, 53, 211, 211, 51, 51, 51, 
	51, 51, 21, 49, 50, 49, 51, 51, 
	51, 52, 53, 212, 212, 51, 51, 51, 
	51, 51, 21, 49, 50, 49, 51, 51, 
	51, 52, 53, 213, 213, 51, 51, 51, 
	51, 51, 21, 49, 50, 49, 51, 51, 
	51, 52, 53, 214, 214, 51, 51, 51, 
	51, 51, 21, 215, 216, 215, 51, 51, 
	51, 52, 217, 51, 51, 51, 51, 51, 
	21, 218, 219, 218, 56, 217, 21, 220, 
	26, 21, 221, 26, 221, 56, 217, 21, 
	222, 223, 222, 68, 224, 68, 68, 70, 
	68, 68, 68, 68, 68, 68, 21, 225, 
	26, 21, 226, 227, 226, 68, 224, 68, 
	68, 70, 68, 68, 68, 68, 68, 68, 
	21, 228, 26, 21, 229, 26, 229, 230, 
	21, 231, 232, 233, 21, 21, 21, 230, 
	234, 26, 21, 235, 236, 235, 237, 21, 
	26, 230, 230, 21, 238, 26, 21, 49, 
	50, 49, 51, 51, 51, 52, 53, 239, 
	239, 51, 51, 51, 51, 51, 21, 49, 
	50, 49, 51, 51, 51, 52, 53, 240, 
	240, 51, 51, 51, 51, 51, 21, 49, 
	50, 49, 51, 51, 51, 52, 53, 241, 
	241, 51, 51, 51, 51, 51, 21, 49, 
	50, 49, 51, 51, 51, 52, 53, 242, 
	242, 51, 51, 51, 51, 51, 21, 243, 
	244, 243, 51, 51, 51, 52, 245, 51, 
	51, 51, 51, 51, 21, 246, 247, 246, 
	56, 245, 21, 248, 26, 21, 249, 26, 
	249, 56, 245, 21, 245, 250, 245, 68, 
	69, 68, 68, 251, 252, 70, 251, 252, 
	68, 68, 68, 68, 68, 68, 21, 253, 
	26, 21, 254, 73, 254, 68, 69, 68, 
	68, 251, 252, 70, 251, 252, 68, 68, 
	68, 68, 68, 68, 21, 80, 81, 80, 
	68, 68, 68, 52, 255, 255, 68, 68, 
	68, 68, 68, 21, 80, 81, 80, 68, 
	68, 68, 52, 256, 256, 68, 68, 68, 
	68, 68, 21, 80, 81, 80, 68, 68, 
	68, 52, 257, 257, 68, 68, 68, 68, 
	68, 21, 80, 81, 80, 68, 68, 68, 
	52, 258, 258, 68, 68, 68, 68, 68, 
	21, 259, 260, 259, 261, 21, 80, 81, 
	80, 68, 68, 68, 52, 262, 262, 68, 
	68, 68, 68, 68, 21, 80, 81, 80, 
	68, 68, 68, 52, 257, 257, 68, 68, 
	68, 68, 68, 21, 263, 26, 21, 264, 
	204, 202, 200, 204, 265, 199, 199, 200, 
	266, 267, 266, 77, 268, 78, 21, 21, 
	69, 269, 26, 21, 270, 271, 270, 77, 
	268, 78, 21, 21, 69, 272, 26, 21, 
	273, 76, 273, 77, 268, 78, 21, 21, 
	69, 268, 274, 268, 275, 77, 275, 275, 
	276, 277, 278, 279, 280, 281, 282, 78, 
	276, 277, 278, 279, 280, 281, 282, 275, 
	21, 21, 275, 275, 275, 275, 275, 69, 
	283, 26, 21, 284, 76, 284, 275, 77, 
	275, 275, 276, 277, 278, 279, 280, 281, 
	282, 78, 276, 277, 278, 279, 280, 281, 
	282, 275, 21, 21, 275, 275, 275, 275, 
	275, 69, 285, 286, 285, 287, 77, 287, 
	287, 288, 289, 78, 287, 21, 21, 287, 
	287, 287, 287, 69, 290, 291, 290, 77, 
	268, 289, 78, 21, 21, 69, 292, 26, 
	21, 293, 76, 293, 77, 268, 289, 78, 
	21, 21, 69, 289, 294, 289, 295, 296, 
	295, 295, 297, 78, 295, 21, 21, 295, 
	295, 295, 295, 295, 69, 298, 26, 21, 
	299, 300, 299, 295, 296, 295, 295, 297, 
	78, 295, 21, 21, 295, 295, 295, 295, 
	295, 69, 301, 26, 21, 302, 76, 302, 
	296, 78, 21, 21, 69, 303, 304, 303, 
	77, 288, 78, 21, 21, 69, 305, 306, 
	305, 77, 268, 78, 21, 21, 69, 307, 
	26, 21, 26, 69, 69, 21, 303, 304, 
	303, 295, 77, 295, 295, 288, 78, 295, 
	21, 21, 295, 295, 295, 295, 69, 76, 
	77, 309, 78, 21, 21, 21, 308, 308, 
	308, 69, 76, 77, 311, 78, 296, 21, 
	21, 21, 310, 310, 310, 69, 76, 77, 
	311, 78, 296, 21, 21, 21, 312, 312, 
	312, 69, 76, 77, 311, 78, 296, 21, 
	21, 21, 313, 313, 313, 69, 76, 77, 
	311, 78, 296, 21, 21, 21, 69, 76, 
	77, 315, 78, 21, 21, 21, 314, 308, 
	308, 69, 76, 77, 316, 311, 78, 296, 
	21, 21, 21, 317, 310, 310, 69, 76, 
	77, 78, 21, 21, 21, 318, 69, 76, 
	77, 319, 78, 21, 21, 21, 320, 69, 
	76, 77, 78, 21, 21, 21, 321, 69, 
	76, 77, 322, 78, 21, 21, 21, 323, 
	69, 76, 77, 78, 21, 21, 21, 324, 
	69, 76, 77, 78, 296, 21, 21, 21, 
	325, 69, 76, 77, 78, 296, 21, 21, 
	21, 326, 69, 76, 77, 78, 296, 21, 
	21, 21, 69, 76, 77, 322, 78, 21, 
	21, 21, 327, 69, 76, 77, 322, 78, 
	21, 21, 21, 69, 76, 77, 319, 78, 
	21, 21, 21, 328, 69, 76, 77, 319, 
	78, 21, 21, 21, 69, 76, 77, 316, 
	311, 78, 296, 21, 21, 21, 329, 312, 
	312, 69, 76, 77, 316, 311, 78, 296, 
	21, 21, 21, 313, 313, 313, 69, 76, 
	77, 331, 78, 296, 21, 21, 21, 330, 
	330, 330, 69, 76, 77, 333, 78, 296, 
	21, 21, 21, 332, 332, 332, 69, 76, 
	77, 333, 78, 296, 21, 21, 21, 334, 
	334, 334, 69, 76, 77, 333, 78, 296, 
	21, 21, 21, 335, 335, 335, 69, 76, 
	77, 333, 78, 296, 21, 21, 21, 69, 
	76, 77, 78, 21, 21, 21, 336, 330, 
	330, 69, 76, 77, 316, 333, 78, 296, 
	21, 21, 21, 337, 332, 332, 69, 76, 
	77, 316, 333, 78, 296, 21, 21, 21, 
	338, 334, 334, 69, 76, 77, 316, 333, 
	78, 296, 21, 21, 21, 335, 335, 335, 
	69, 76, 77, 78, 21, 21, 21, 339, 
	69, 76, 77, 316, 78, 21, 21, 21, 
	340, 69, 76, 77, 316, 78, 21, 21, 
	21, 341, 69, 76, 77, 316, 78, 21, 
	21, 21, 69, 76, 77, 315, 78, 21, 
	21, 21, 69, 342, 26, 21, 285, 286, 
	285, 287, 77, 287, 287, 288, 289, 343, 
	78, 343, 287, 21, 21, 287, 287, 287, 
	287, 69, 285, 286, 285, 287, 77, 287, 
	287, 288, 289, 344, 78, 344, 287, 21, 
	21, 287, 287, 287, 287, 69, 285, 286, 
	285, 287, 77, 287, 287, 288, 289, 345, 
	78, 345, 287, 21, 21, 287, 287, 287, 
	287, 69, 285, 286, 285, 287, 77, 287, 
	287, 288, 289, 346, 78, 346, 287, 21, 
	21, 287, 287, 287, 287, 69, 285, 286, 
	285, 287, 77, 287, 287, 288, 289, 347, 
	78, 347, 287, 21, 21, 287, 287, 287, 
	287, 69, 285, 286, 285, 287, 77, 287, 
	287, 288, 289, 348, 78, 348, 287, 21, 
	21, 287, 287, 287, 287, 69, 285, 286, 
	285, 287, 77, 287, 287, 288, 289, 349, 
	78, 349, 287, 21, 21, 287, 287, 287, 
	287, 69, 285, 286, 285, 287, 77, 287, 
	287, 288, 289, 350, 78, 350, 287, 21, 
	21, 287, 287, 287, 287, 69, 351, 352, 
	351, 287, 77, 287, 287, 288, 353, 78, 
	287, 21, 21, 287, 287, 287, 287, 69, 
	354, 355, 354, 77, 268, 353, 78, 21, 
	21, 69, 356, 26, 21, 357, 76, 357, 
	77, 268, 353, 78, 21, 21, 69, 353, 
	358, 353, 359, 296, 359, 359, 297, 78, 
	359, 21, 21, 359, 359, 359, 359, 359, 
	69, 360, 26, 21, 361, 300, 361, 359, 
	296, 359, 359, 297, 78, 359, 21, 21, 
	359, 359, 359, 359, 359, 69, 362, 363, 
	362, 364, 77, 364, 364, 365, 78, 364, 
	21, 21, 364, 364, 364, 364, 69, 366, 
	26, 21, 285, 286, 285, 287, 77, 287, 
	287, 288, 289, 367, 78, 367, 287, 21, 
	21, 287, 287, 287, 287, 69, 285, 286, 
	285, 287, 77, 287, 287, 288, 289, 368, 
	78, 368, 287, 21, 21, 287, 287, 287, 
	287, 69, 285, 286, 285, 287, 77, 287, 
	287, 288, 289, 369, 78, 369, 287, 21, 
	21, 287, 287, 287, 287, 69, 285, 286, 
	285, 287, 77, 287, 287, 288, 289, 370, 
	78, 370, 287, 21, 21, 287, 287, 287, 
	287, 69, 285, 286, 285, 287, 77, 287, 
	287, 288, 289, 371, 78, 371, 287, 21, 
	21, 287, 287, 287, 287, 69, 372, 373, 
	372, 287, 77, 287, 287, 288, 374, 78, 
	287, 21, 21, 287, 287, 287, 287, 69, 
	375, 376, 375, 77, 268, 374, 78, 21, 
	21, 69, 377, 26, 21, 378, 76, 378, 
	77, 268, 374, 78, 21, 21, 69, 374, 
	379, 374, 295, 380, 295, 295, 297, 78, 
	295, 21, 21, 295, 295, 295, 295, 295, 
	69, 381, 26, 21, 382, 383, 382, 295, 
	380, 295, 295, 297, 78, 295, 21, 21, 
	295, 295, 295, 295, 295, 69, 384, 26, 
	21, 385, 76, 385, 380, 78, 21, 21, 
	69, 388, 389, 388, 390, 391, 392, 387, 
	387, 386, 395, 396, 397, 394, 394, 394, 
	393, 398, 396, 394, 399, 398, 396, 394, 
	400, 398, 396, 394, 398, 401, 393, 393, 
	394, 402, 403, 402, 396, 404, 397, 394, 
	394, 393, 405, 398, 396, 394, 406, 395, 
	406, 396, 404, 397, 394, 394, 393, 404, 
	407, 404, 408, 396, 408, 408, 409, 410, 
	411, 412, 413, 414, 415, 397, 409, 410, 
	411, 412, 413, 414, 415, 408, 394, 394, 
	408, 408, 408, 408, 408, 393, 416, 398, 
	396, 394, 417, 395, 417, 408, 396, 408, 
	408, 409, 410, 411, 412, 413, 414, 415, 
	397, 409, 410, 411, 412, 413, 414, 415, 
	408, 394, 394, 408, 408, 408, 408, 408, 
	393, 418, 419, 418, 420, 396, 420, 420, 
	421, 422, 397, 420, 394, 394, 420, 420, 
	420, 420, 393, 423, 424, 423, 396, 404, 
	422, 397, 394, 394, 393, 425, 398, 396, 
	394, 426, 395, 426, 396, 404, 422, 397, 
	394, 394, 393, 422, 427, 422, 428, 401, 
	428, 428, 429, 397, 428, 394, 394, 428, 
	428, 428, 428, 428, 393, 430, 398, 396, 
	394, 431, 432, 431, 428, 401, 428, 428, 
	429, 397, 428, 394, 394, 428, 428, 428, 
	428, 428, 393, 433, 398, 396, 394, 434, 
	395, 434, 401, 397, 394, 394, 393, 435, 
	436, 435, 428, 396, 428, 428, 421, 397, 
	428, 394, 394, 428, 428, 428, 428, 393, 
	437, 398, 396, 394, 438, 439, 438, 440, 
	396, 440, 440, 441, 442, 440, 440, 440, 
	440, 440, 394, 443, 444, 443, 396, 445, 
	442, 394, 446, 398, 396, 394, 447, 398, 
	447, 396, 445, 442, 394, 445, 448, 445, 
	449, 396, 449, 449, 450, 451, 452, 453, 
	454, 455, 456, 450, 451, 452, 453, 454, 
	455, 456, 449, 449, 449, 449, 449, 449, 
	394, 457, 398, 396, 394, 458, 398, 458, 
	449, 396, 449, 449, 450, 451, 452, 453, 
	454, 455, 456, 450, 451, 452, 453, 454, 
	455, 456, 449, 449, 449, 449, 449, 449, 
	394, 438, 439, 438, 440, 396, 440, 440, 
	441, 442, 459, 459, 440, 440, 440, 440, 
	440, 394, 460, 398, 396, 394, 438, 439, 
	438, 440, 396, 440, 440, 441, 442, 461, 
	461, 440, 440, 440, 440, 440, 394, 442, 
	462, 442, 463, 401, 463, 463, 464, 463, 
	463, 463, 463, 463, 463, 394, 465, 398, 
	396, 394, 466, 467, 466, 463, 401, 463, 
	463, 464, 463, 463, 463, 463, 463, 463, 
	394, 468, 398, 396, 394, 469, 398, 469, 
	401, 394, 470, 471, 470, 463, 396, 463, 
	463, 441, 463, 463, 463, 463, 463, 394, 
	472, 473, 472, 396, 445, 394, 474, 398, 
	396, 394, 475, 398, 475, 396, 445, 394, 
	476, 398, 396, 394, 438, 439, 438, 440, 
	396, 440, 440, 441, 442, 477, 477, 440, 
	440, 440, 440, 440, 394, 438, 439, 438, 
	440, 396, 440, 440, 441, 442, 478, 478, 
	440, 440, 440, 440, 440, 394, 438, 439, 
	438, 440, 396, 440, 440, 441, 442, 479, 
	479, 440, 440, 440, 440, 440, 394, 438, 
	439, 438, 440, 396, 440, 440, 441, 442, 
	480, 480, 440, 440, 440, 440, 440, 394, 
	481, 482, 481, 440, 396, 440, 440, 441, 
	483, 440, 440, 440, 440, 440, 394, 484, 
	485, 484, 396, 445, 483, 394, 486, 398, 
	396, 394, 487, 398, 487, 396, 445, 483, 
	394, 488, 489, 488, 463, 490, 463, 463, 
	464, 463, 463, 463, 463, 463, 463, 394, 
	491, 398, 396, 394, 492, 493, 492, 463, 
	490, 463, 463, 464, 463, 463, 463, 463, 
	463, 463, 394, 494, 398, 396, 394, 495, 
	398, 495, 496, 394, 497, 498, 497, 108, 
	499, 109, 21, 21, 106, 500, 26, 21, 
	501, 502, 501, 108, 499, 109, 21, 21, 
	106, 503, 26, 21, 504, 107, 504, 108, 
	499, 109, 21, 21, 106, 499, 505, 499, 
	506, 108, 506, 506, 507, 508, 509, 510, 
	511, 512, 513, 109, 507, 508, 509, 510, 
	511, 512, 513, 506, 21, 21, 506, 506, 
	506, 506, 506, 106, 514, 26, 21, 515, 
	107, 515, 506, 108, 506, 506, 507, 508, 
	509, 510, 511, 512, 513, 109, 507, 508, 
	509, 510, 511, 512, 513, 506, 21, 21, 
	506, 506, 506, 506, 506, 106, 516, 517, 
	516, 518, 108, 518, 518, 519, 520, 109, 
	518, 21, 21, 518, 518, 518, 518, 106, 
	521, 522, 521, 108, 499, 520, 109, 21, 
	21, 106, 523, 26, 21, 524, 107, 524, 
	108, 499, 520, 109, 21, 21, 106, 520, 
	525, 520, 526, 527, 526, 526, 528, 109, 
	526, 21, 21, 526, 526, 526, 526, 526, 
	106, 529, 26, 21, 530, 531, 530, 526, 
	527, 526, 526, 528, 109, 526, 21, 21, 
	526, 526, 526, 526, 526, 106, 532, 26, 
	21, 533, 107, 533, 527, 109, 21, 21, 
	106, 534, 535, 534, 77, 536, 78, 21, 
	21, 69, 537, 538, 537, 526, 108, 526, 
	526, 519, 109, 526, 21, 21, 526, 526, 
	526, 526, 106, 539, 540, 539, 108, 499, 
	109, 21, 21, 106, 541, 26, 21, 107, 
	108, 543, 109, 21, 21, 21, 542, 542, 
	542, 106, 107, 108, 545, 109, 546, 21, 
	21, 21, 544, 544, 544, 106, 107, 108, 
	545, 109, 546, 21, 21, 21, 547, 547, 
	547, 106, 107, 108, 545, 109, 546, 21, 
	21, 21, 548, 548, 548, 106, 107, 108, 
	545, 109, 546, 21, 21, 21, 106, 107, 
	108, 550, 109, 21, 21, 21, 549, 542, 
	542, 106, 107, 108, 551, 545, 109, 546, 
	21, 21, 21, 552, 544, 544, 106, 107, 
	108, 109, 21, 21, 21, 553, 106, 107, 
	108, 554, 109, 21, 21, 21, 555, 106, 
	107, 108, 109, 21, 21, 21, 556, 106, 
	107, 108, 557, 109, 21, 21, 21, 558, 
	106, 107, 108, 109, 21, 21, 21, 559, 
	106, 107, 108, 109, 546, 21, 21, 21, 
	560, 106, 107, 108, 109, 546, 21, 21, 
	21, 561, 106, 107, 108, 109, 546, 21, 
	21, 21, 106, 537, 538, 537, 108, 519, 
	109, 21, 21, 106, 107, 108, 557, 109, 
	21, 21, 21, 562, 106, 107, 108, 557, 
	109, 21, 21, 21, 106, 107, 108, 554, 
	109, 21, 21, 21, 563, 106, 107, 108, 
	554, 109, 21, 21, 21, 106, 107, 108, 
	551, 545, 109, 546, 21, 21, 21, 564, 
	547, 547, 106, 107, 108, 551, 545, 109, 
	546, 21, 21, 21, 548, 548, 548, 106, 
	107, 108, 566, 109, 546, 21, 21, 21, 
	565, 565, 565, 106, 107, 108, 568, 109, 
	546, 21, 21, 21, 567, 567, 567, 106, 
	107, 108, 568, 109, 546, 21, 21, 21, 
	569, 569, 569, 106, 107, 108, 568, 109, 
	546, 21, 21, 21, 570, 570, 570, 106, 
	107, 108, 568, 109, 546, 21, 21, 21, 
	106, 107, 108, 109, 21, 21, 21, 571, 
	565, 565, 106, 107, 108, 551, 568, 109, 
	546, 21, 21, 21, 572, 567, 567, 106, 
	107, 108, 551, 568, 109, 546, 21, 21, 
	21, 573, 569, 569, 106, 107, 108, 551, 
	568, 109, 546, 21, 21, 21, 570, 570, 
	570, 106, 107, 108, 109, 21, 21, 21, 
	574, 106, 107, 108, 551, 109, 21, 21, 
	21, 575, 106, 107, 108, 551, 109, 21, 
	21, 21, 576, 106, 107, 108, 551, 109, 
	21, 21, 21, 106, 107, 108, 550, 109, 
	21, 21, 21, 106, 577, 26, 21, 516, 
	517, 516, 518, 108, 518, 518, 519, 520, 
	578, 109, 578, 518, 21, 21, 518, 518, 
	518, 518, 106, 516, 517, 516, 518, 108, 
	518, 518, 519, 520, 579, 109, 579, 518, 
	21, 21, 518, 518, 518, 518, 106, 516, 
	517, 516, 518, 108, 518, 518, 519, 520, 
	580, 109, 580, 518, 21, 21, 518, 518, 
	518, 518, 106, 516, 517, 516, 518, 108, 
	518, 518, 519, 520, 581, 109, 581, 518, 
	21, 21, 518, 518, 518, 518, 106, 516, 
	517, 516, 518, 108, 518, 518, 519, 520, 
	582, 109, 582, 518, 21, 21, 518, 518, 
	518, 518, 106, 516, 517, 516, 518, 108, 
	518, 518, 519, 520, 583, 109, 583, 518, 
	21, 21, 518, 518, 518, 518, 106, 516, 
	517, 516, 518, 108, 518, 518, 519, 520, 
	584, 109, 584, 518, 21, 21, 518, 518, 
	518, 518, 106, 516, 517, 516, 518, 108, 
	518, 518, 519, 520, 585, 109, 585, 518, 
	21, 21, 518, 518, 518, 518, 106, 586, 
	587, 586, 518, 108, 518, 518, 519, 588, 
	109, 518, 21, 21, 518, 518, 518, 518, 
	106, 589, 590, 589, 108, 499, 588, 109, 
	21, 21, 106, 591, 26, 21, 592, 107, 
	592, 108, 499, 588, 109, 21, 21, 106, 
	588, 593, 588, 594, 527, 594, 594, 528, 
	109, 594, 21, 21, 594, 594, 594, 594, 
	594, 106, 595, 26, 21, 596, 531, 596, 
	594, 527, 594, 594, 528, 109, 594, 21, 
	21, 594, 594, 594, 594, 594, 106, 597, 
	598, 597, 599, 108, 599, 599, 600, 109, 
	599, 21, 21, 599, 599, 599, 599, 106, 
	601, 26, 21, 516, 517, 516, 518, 108, 
	518, 518, 519, 520, 602, 109, 602, 518, 
	21, 21, 518, 518, 518, 518, 106, 516, 
	517, 516, 518, 108, 518, 518, 519, 520, 
	603, 109, 603, 518, 21, 21, 518, 518, 
	518, 518, 106, 516, 517, 516, 518, 108, 
	518, 518, 519, 520, 604, 109, 604, 518, 
	21, 21, 518, 518, 518, 518, 106, 516, 
	517, 516, 518, 108, 518, 518, 519, 520, 
	605, 109, 605, 518, 21, 21, 518, 518, 
	518, 518, 106, 516, 517, 516, 518, 108, 
	518, 518, 519, 520, 606, 109, 606, 518, 
	21, 21, 518, 518, 518, 518, 106, 607, 
	608, 607, 518, 108, 518, 518, 519, 609, 
	109, 518, 21, 21, 518, 518, 518, 518, 
	106, 610, 611, 610, 108, 499, 609, 109, 
	21, 21, 106, 612, 26, 21, 613, 107, 
	613, 108, 499, 609, 109, 21, 21, 106, 
	609, 614, 609, 526, 615, 526, 526, 528, 
	109, 526, 21, 21, 526, 526, 526, 526, 
	526, 106, 616, 26, 21, 617, 618, 617, 
	526, 615, 526, 526, 528, 109, 526, 21, 
	21, 526, 526, 526, 526, 526, 106, 619, 
	26, 21, 620, 107, 620, 615, 109, 21, 
	21, 106, 621, 622, 621, 390, 623, 392, 
	387, 387, 386, 624, 26, 21, 516, 517, 
	516, 518, 108, 518, 518, 519, 520, 625, 
	109, 625, 518, 21, 21, 518, 518, 518, 
	518, 106, 516, 517, 516, 518, 108, 518, 
	518, 519, 520, 626, 109, 626, 518, 21, 
	21, 518, 518, 518, 518, 106, 516, 517, 
	516, 518, 108, 518, 518, 519, 520, 627, 
	109, 627, 518, 21, 21, 518, 518, 518, 
	518, 106, 516, 517, 516, 518, 108, 518, 
	518, 519, 520, 628, 109, 628, 518, 21, 
	21, 518, 518, 518, 518, 106, 629, 630, 
	629, 518, 108, 518, 518, 519, 631, 109, 
	518, 21, 21, 518, 518, 518, 518, 106, 
	632, 633, 632, 108, 499, 631, 109, 21, 
	21, 106, 634, 26, 21, 635, 107, 635, 
	108, 499, 631, 109, 21, 21, 106, 636, 
	637, 636, 526, 638, 526, 526, 528, 109, 
	526, 21, 21, 526, 526, 526, 526, 526, 
	106, 639, 26, 21, 640, 641, 640, 526, 
	638, 526, 526, 528, 109, 526, 21, 21, 
	526, 526, 526, 526, 526, 106, 642, 26, 
	21, 643, 107, 643, 644, 109, 21, 21, 
	106, 645, 646, 645, 108, 647, 109, 21, 
	21, 106, 648, 26, 21, 516, 517, 516, 
	518, 108, 518, 518, 519, 520, 649, 109, 
	649, 518, 21, 21, 518, 518, 518, 518, 
	106, 516, 517, 516, 518, 108, 518, 518, 
	519, 520, 650, 109, 650, 518, 21, 21, 
	518, 518, 518, 518, 106, 516, 517, 516, 
	518, 108, 518, 518, 519, 520, 651, 109, 
	651, 518, 21, 21, 518, 518, 518, 518, 
	106, 516, 517, 516, 518, 108, 518, 518, 
	519, 520, 652, 109, 652, 518, 21, 21, 
	518, 518, 518, 518, 106, 516, 517, 516, 
	518, 108, 518, 518, 519, 520, 653, 109, 
	653, 518, 21, 21, 518, 518, 518, 518, 
	106, 654, 655, 654, 518, 108, 518, 518, 
	519, 656, 109, 518, 21, 21, 518, 518, 
	518, 518, 106, 657, 658, 657, 108, 499, 
	656, 109, 21, 21, 106, 659, 26, 21, 
	660, 107, 660, 108, 499, 656, 109, 21, 
	21, 106, 661, 662, 661, 526, 663, 526, 
	526, 528, 109, 526, 21, 21, 526, 526, 
	526, 526, 526, 106, 664, 26, 21, 665, 
	666, 665, 526, 663, 526, 526, 528, 109, 
	526, 21, 21, 526, 526, 526, 526, 526, 
	106, 667, 26, 21, 668, 107, 668, 669, 
	109, 21, 21, 106, 670, 671, 670, 171, 
	672, 172, 21, 21, 169, 673, 674, 673, 
	171, 675, 172, 21, 21, 169, 676, 26, 
	21, 677, 170, 677, 171, 675, 172, 21, 
	21, 169, 675, 678, 675, 679, 171, 679, 
	679, 680, 681, 682, 683, 684, 685, 686, 
	172, 680, 681, 682, 683, 684, 685, 686, 
	679, 21, 21, 679, 679, 679, 679, 679, 
	169, 687, 26, 21, 688, 170, 688, 679, 
	171, 679, 679, 680, 681, 682, 683, 684, 
	685, 686, 172, 680, 681, 682, 683, 684, 
	685, 686, 679, 21, 21, 679, 679, 679, 
	679, 679, 169, 689, 690, 689, 691, 171, 
	691, 691, 692, 693, 172, 691, 21, 21, 
	691, 691, 691, 691, 169, 694, 695, 694, 
	171, 675, 693, 172, 21, 21, 169, 696, 
	26, 21, 697, 170, 697, 171, 675, 693, 
	172, 21, 21, 169, 693, 698, 693, 699, 
	700, 699, 699, 701, 172, 699, 21, 21, 
	699, 699, 699, 699, 699, 169, 702, 26, 
	21, 703, 704, 703, 699, 700, 699, 699, 
	701, 172, 699, 21, 21, 699, 699, 699, 
	699, 699, 169, 705, 26, 21, 706, 170, 
	706, 700, 172, 21, 21, 169, 707, 708, 
	707, 77, 709, 78, 21, 21, 69, 710, 
	711, 710, 699, 171, 699, 699, 692, 172, 
	699, 21, 21, 699, 699, 699, 699, 169, 
	712, 26, 21, 170, 171, 714, 172, 21, 
	21, 21, 713, 713, 713, 169, 170, 171, 
	716, 172, 717, 21, 21, 21, 715, 715, 
	715, 169, 170, 171, 716, 172, 717, 21, 
	21, 21, 718, 718, 718, 169, 170, 171, 
	716, 172, 717, 21, 21, 21, 719, 719, 
	719, 169, 170, 171, 716, 172, 717, 21, 
	21, 21, 169, 170, 171, 721, 172, 21, 
	21, 21, 720, 713, 713, 169, 170, 171, 
	722, 716, 172, 717, 21, 21, 21, 723, 
	715, 715, 169, 170, 171, 172, 21, 21, 
	21, 724, 169, 170, 171, 725, 172, 21, 
	21, 21, 726, 169, 170, 171, 172, 21, 
	21, 21, 727, 169, 170, 171, 728, 172, 
	21, 21, 21, 729, 169, 170, 171, 172, 
	21, 21, 21, 730, 169, 170, 171, 172, 
	717, 21, 21, 21, 731, 169, 170, 171, 
	172, 717, 21, 21, 21, 732, 169, 170, 
	171, 172, 717, 21, 21, 21, 169, 710, 
	711, 710, 171, 692, 172, 21, 21, 169, 
	170, 171, 728, 172, 21, 21, 21, 733, 
	169, 170, 171, 728, 172, 21, 21, 21, 
	169, 170, 171, 725, 172, 21, 21, 21, 
	734, 169, 170, 171, 725, 172, 21, 21, 
	21, 169, 170, 171, 722, 716, 172, 717, 
	21, 21, 21, 735, 718, 718, 169, 170, 
	171, 722, 716, 172, 717, 21, 21, 21, 
	719, 719, 719, 169, 170, 171, 737, 172, 
	717, 21, 21, 21, 736, 736, 736, 169, 
	170, 171, 739, 172, 717, 21, 21, 21, 
	738, 738, 738, 169, 170, 171, 739, 172, 
	717, 21, 21, 21, 740, 740, 740, 169, 
	170, 171, 739, 172, 717, 21, 21, 21, 
	741, 741, 741, 169, 170, 171, 739, 172, 
	717, 21, 21, 21, 169, 170, 171, 172, 
	21, 21, 21, 742, 736, 736, 169, 170, 
	171, 722, 739, 172, 717, 21, 21, 21, 
	743, 738, 738, 169, 170, 171, 722, 739, 
	172, 717, 21, 21, 21, 744, 740, 740, 
	169, 170, 171, 722, 739, 172, 717, 21, 
	21, 21, 741, 741, 741, 169, 170, 171, 
	172, 21, 21, 21, 745, 169, 170, 171, 
	722, 172, 21, 21, 21, 746, 169, 170, 
	171, 722, 172, 21, 21, 21, 747, 169, 
	170, 171, 722, 172, 21, 21, 21, 169, 
	170, 171, 721, 172, 21, 21, 21, 169, 
	748, 26, 21, 689, 690, 689, 691, 171, 
	691, 691, 692, 693, 749, 172, 749, 691, 
	21, 21, 691, 691, 691, 691, 169, 689, 
	690, 689, 691, 171, 691, 691, 692, 693, 
	750, 172, 750, 691, 21, 21, 691, 691, 
	691, 691, 169, 689, 690, 689, 691, 171, 
	691, 691, 692, 693, 751, 172, 751, 691, 
	21, 21, 691, 691, 691, 691, 169, 689, 
	690, 689, 691, 171, 691, 691, 692, 693, 
	752, 172, 752, 691, 21, 21, 691, 691, 
	691, 691, 169, 689, 690, 689, 691, 171, 
	691, 691, 692, 693, 753, 172, 753, 691, 
	21, 21, 691, 691, 691, 691, 169, 689, 
	690, 689, 691, 171, 691, 691, 692, 693, 
	754, 172, 754, 691, 21, 21, 691, 691, 
	691, 691, 169, 689, 690, 689, 691, 171, 
	691, 691, 692, 693, 755, 172, 755, 691, 
	21, 21, 691, 691, 691, 691, 169, 689, 
	690, 689, 691, 171, 691, 691, 692, 693, 
	756, 172, 756, 691, 21, 21, 691, 691, 
	691, 691, 169, 757, 758, 757, 691, 171, 
	691, 691, 692, 759, 172, 691, 21, 21, 
	691, 691, 691, 691, 169, 760, 761, 760, 
	171, 675, 759, 172, 21, 21, 169, 762, 
	26, 21, 763, 170, 763, 171, 675, 759, 
	172, 21, 21, 169, 759, 764, 759, 765, 
	700, 765, 765, 701, 172, 765, 21, 21, 
	765, 765, 765, 765, 765, 169, 766, 26, 
	21, 767, 704, 767, 765, 700, 765, 765, 
	701, 172, 765, 21, 21, 765, 765, 765, 
	765, 765, 169, 768, 769, 768, 770, 171, 
	770, 770, 771, 172, 770, 21, 21, 770, 
	770, 770, 770, 169, 772, 26, 21, 689, 
	690, 689, 691, 171, 691, 691, 692, 693, 
	773, 172, 773, 691, 21, 21, 691, 691, 
	691, 691, 169, 689, 690, 689, 691, 171, 
	691, 691, 692, 693, 774, 172, 774, 691, 
	21, 21, 691, 691, 691, 691, 169, 689, 
	690, 689, 691, 171, 691, 691, 692, 693, 
	775, 172, 775, 691, 21, 21, 691, 691, 
	691, 691, 169, 689, 690, 689, 691, 171, 
	691, 691, 692, 693, 776, 172, 776, 691, 
	21, 21, 691, 691, 691, 691, 169, 689, 
	690, 689, 691, 171, 691, 691, 692, 693, 
	777, 172, 777, 691, 21, 21, 691, 691, 
	691, 691, 169, 778, 779, 778, 691, 171, 
	691, 691, 692, 780, 172, 691, 21, 21, 
	691, 691, 691, 691, 169, 781, 782, 781, 
	171, 675, 780, 172, 21, 21, 169, 783, 
	26, 21, 784, 170, 784, 171, 675, 780, 
	172, 21, 21, 169, 780, 785, 780, 699, 
	786, 699, 699, 701, 172, 699, 21, 21, 
	699, 699, 699, 699, 699, 169, 787, 26, 
	21, 788, 789, 788, 699, 786, 699, 699, 
	701, 172, 699, 21, 21, 699, 699, 699, 
	699, 699, 169, 790, 26, 21, 791, 170, 
	791, 786, 172, 21, 21, 169, 792, 793, 
	792, 390, 794, 392, 387, 387, 386, 795, 
	26, 21, 689, 690, 689, 691, 171, 691, 
	691, 692, 693, 796, 172, 796, 691, 21, 
	21, 691, 691, 691, 691, 169, 689, 690, 
	689, 691, 171, 691, 691, 692, 693, 797, 
	172, 797, 691, 21, 21, 691, 691, 691, 
	691, 169, 689, 690, 689, 691, 171, 691, 
	691, 692, 693, 798, 172, 798, 691, 21, 
	21, 691, 691, 691, 691, 169, 689, 690, 
	689, 691, 171, 691, 691, 692, 693, 799, 
	172, 799, 691, 21, 21, 691, 691, 691, 
	691, 169, 800, 801, 800, 691, 171, 691, 
	691, 692, 802, 172, 691, 21, 21, 691, 
	691, 691, 691, 169, 803, 804, 803, 171, 
	675, 802, 172, 21, 21, 169, 805, 26, 
	21, 806, 170, 806, 171, 675, 802, 172, 
	21, 21, 169, 807, 808, 807, 699, 809, 
	699, 699, 701, 172, 699, 21, 21, 699, 
	699, 699, 699, 699, 169, 810, 26, 21, 
	811, 812, 811, 699, 809, 699, 699, 701, 
	172, 699, 21, 21, 699, 699, 699, 699, 
	699, 169, 813, 26, 21, 814, 170, 814, 
	815, 172, 21, 21, 169, 816, 817, 816, 
	108, 818, 109, 21, 21, 106, 819, 26, 
	21, 689, 690, 689, 691, 171, 691, 691, 
	692, 693, 820, 172, 820, 691, 21, 21, 
	691, 691, 691, 691, 169, 689, 690, 689, 
	691, 171, 691, 691, 692, 693, 821, 172, 
	821, 691, 21, 21, 691, 691, 691, 691, 
	169, 689, 690, 689, 691, 171, 691, 691, 
	692, 693, 822, 172, 822, 691, 21, 21, 
	691, 691, 691, 691, 169, 689, 690, 689, 
	691, 171, 691, 691, 692, 693, 823, 172, 
	823, 691, 21, 21, 691, 691, 691, 691, 
	169, 689, 690, 689, 691, 171, 691, 691, 
	692, 693, 824, 172, 824, 691, 21, 21, 
	691, 691, 691, 691, 169, 825, 826, 825, 
	691, 171, 691, 691, 692, 827, 172, 691, 
	21, 21, 691, 691, 691, 691, 169, 828, 
	829, 828, 171, 675, 827, 172, 21, 21, 
	169, 830, 26, 21, 831, 170, 831, 171, 
	675, 827, 172, 21, 21, 169, 832, 833, 
	832, 699, 834, 699, 699, 701, 172, 699, 
	21, 21, 699, 699, 699, 699, 699, 169, 
	835, 26, 21, 836, 837, 836, 699, 834, 
	699, 699, 701, 172, 699, 21, 21, 699, 
	699, 699, 699, 699, 169, 838, 26, 21, 
	839, 170, 839, 840, 172, 21, 21, 169, 
	841, 842, 841, 171, 843, 172, 21, 21, 
	169, 844, 26, 21, 689, 690, 689, 691, 
	171, 691, 691, 692, 693, 845, 172, 845, 
	691, 21, 21, 691, 691, 691, 691, 169, 
	689, 690, 689, 691, 171, 691, 691, 692, 
	693, 846, 172, 846, 691, 21, 21, 691, 
	691, 691, 691, 169, 847, 848, 847, 691, 
	171, 691, 691, 692, 849, 172, 691, 21, 
	21, 691, 691, 691, 691, 169, 850, 851, 
	850, 171, 675, 849, 172, 21, 21, 169, 
	852, 26, 21, 853, 170, 853, 171, 675, 
	849, 172, 21, 21, 169, 849, 854, 849, 
	699, 855, 699, 699, 701, 172, 699, 21, 
	21, 699, 699, 699, 699, 699, 169, 856, 
	26, 21, 857, 858, 857, 699, 855, 699, 
	699, 701, 172, 699, 21, 21, 699, 699, 
	699, 699, 699, 169, 859, 26, 21, 860, 
	170, 860, 855, 172, 21, 21, 169, 861, 
	862, 861, 197, 863, 198, 195, 195, 194, 
	864, 865, 864, 202, 866, 203, 200, 200, 
	199, 867, 204, 202, 200, 868, 201, 868, 
	202, 866, 203, 200, 200, 199, 866, 869, 
	866, 870, 202, 870, 870, 871, 872, 873, 
	874, 875, 876, 877, 203, 871, 872, 873, 
	874, 875, 876, 877, 870, 200, 200, 870, 
	870, 870, 870, 870, 199, 878, 204, 202, 
	200, 879, 201, 879, 870, 202, 870, 870, 
	871, 872, 873, 874, 875, 876, 877, 203, 
	871, 872, 873, 874, 875, 876, 877, 870, 
	200, 200, 870, 870, 870, 870, 870, 199, 
	880, 881, 880, 882, 202, 882, 882, 883, 
	884, 203, 882, 200, 200, 882, 882, 882, 
	882, 199, 885, 886, 885, 202, 866, 884, 
	203, 200, 200, 199, 887, 204, 202, 200, 
	888, 201, 888, 202, 866, 884, 203, 200, 
	200, 199, 884, 889, 884, 890, 265, 890, 
	890, 891, 203, 890, 200, 200, 890, 890, 
	890, 890, 890, 199, 892, 204, 202, 200, 
	893, 894, 893, 890, 265, 890, 890, 891, 
	203, 890, 200, 200, 890, 890, 890, 890, 
	890, 199, 895, 204, 202, 200, 896, 201, 
	896, 265, 203, 200, 200, 199, 897, 898, 
	897, 890, 202, 890, 890, 883, 203, 890, 
	200, 200, 890, 890, 890, 890, 199, 899, 
	204, 202, 200, 900, 901, 900, 902, 202, 
	902, 902, 903, 904, 902, 902, 902, 902, 
	902, 200, 905, 906, 905, 202, 907, 904, 
	200, 908, 204, 202, 200, 909, 204, 909, 
	202, 907, 904, 200, 907, 910, 907, 911, 
	202, 911, 911, 912, 913, 914, 915, 916, 
	917, 918, 912, 913, 914, 915, 916, 917, 
	918, 911, 911, 911, 911, 911, 911, 200, 
	919, 204, 202, 200, 920, 204, 920, 911, 
	202, 911, 911, 912, 913, 914, 915, 916, 
	917, 918, 912, 913, 914, 915, 916, 917, 
	918, 911, 911, 911, 911, 911, 911, 200, 
	900, 901, 900, 902, 202, 902, 902, 903, 
	904, 921, 921, 902, 902, 902, 902, 902, 
	200, 922, 204, 202, 200, 900, 901, 900, 
	902, 202, 902, 902, 903, 904, 923, 923, 
	902, 902, 902, 902, 902, 200, 904, 924, 
	904, 925, 265, 925, 925, 926, 925, 925, 
	925, 925, 925, 925, 200, 927, 204, 202, 
	200, 928, 929, 928, 925, 265, 925, 925, 
	926, 925, 925, 925, 925, 925, 925, 200, 
	930, 204, 202, 200, 931, 204, 931, 265, 
	200, 932, 933, 932, 925, 202, 925, 925, 
	903, 925, 925, 925, 925, 925, 200, 934, 
	935, 934, 202, 907, 200, 936, 204, 202, 
	200, 937, 204, 937, 202, 907, 200, 938, 
	204, 202, 200, 900, 901, 900, 902, 202, 
	902, 902, 903, 904, 939, 939, 902, 902, 
	902, 902, 902, 200, 900, 901, 900, 902, 
	202, 902, 902, 903, 904, 940, 940, 902, 
	902, 902, 902, 902, 200, 900, 901, 900, 
	902, 202, 902, 902, 903, 904, 941, 941, 
	902, 902, 902, 902, 902, 200, 900, 901, 
	900, 902, 202, 902, 902, 903, 904, 942, 
	942, 902, 902, 902, 902, 902, 200, 943, 
	944, 943, 902, 202, 902, 902, 903, 945, 
	902, 902, 902, 902, 902, 200, 946, 947, 
	946, 202, 907, 945, 200, 948, 204, 202, 
	200, 949, 204, 949, 202, 907, 945, 200, 
	950, 951, 950, 925, 952, 925, 925, 926, 
	925, 925, 925, 925, 925, 925, 200, 953, 
	204, 202, 200, 954, 955, 954, 925, 952, 
	925, 925, 926, 925, 925, 925, 925, 925, 
	925, 200, 956, 204, 202, 200, 957, 204, 
	957, 958, 200, 204, 202, 960, 959, 959, 
	959, 200, 204, 202, 962, 963, 961, 961, 
	961, 200, 204, 202, 962, 963, 964, 964, 
	964, 200, 204, 202, 962, 963, 965, 965, 
	965, 200, 204, 202, 962, 963, 200, 204, 
	202, 967, 966, 959, 959, 200, 204, 202, 
	968, 962, 963, 969, 961, 961, 200, 204, 
	202, 970, 200, 204, 202, 971, 972, 200, 
	204, 202, 973, 200, 204, 202, 974, 975, 
	200, 204, 202, 976, 200, 204, 202, 963, 
	977, 200, 204, 202, 963, 978, 200, 204, 
	202, 963, 200, 932, 933, 932, 202, 903, 
	200, 204, 202, 974, 979, 200, 204, 202, 
	974, 200, 204, 202, 971, 980, 200, 204, 
	202, 971, 200, 204, 202, 968, 962, 963, 
	981, 964, 964, 200, 204, 202, 968, 962, 
	963, 965, 965, 965, 200, 204, 202, 983, 
	963, 982, 982, 982, 200, 204, 202, 985, 
	963, 984, 984, 984, 200, 204, 202, 985, 
	963, 986, 986, 986, 200, 204, 202, 985, 
	963, 987, 987, 987, 200, 204, 202, 985, 
	963, 200, 204, 202, 988, 982, 982, 200, 
	204, 202, 968, 985, 963, 989, 984, 984, 
	200, 204, 202, 968, 985, 963, 990, 986, 
	986, 200, 204, 202, 968, 985, 963, 987, 
	987, 987, 200, 204, 202, 991, 200, 204, 
	202, 968, 992, 200, 204, 202, 968, 993, 
	200, 204, 202, 968, 200, 204, 202, 967, 
	200, 994, 204, 202, 200, 900, 901, 900, 
	902, 202, 902, 902, 903, 904, 995, 995, 
	902, 902, 902, 902, 902, 200, 900, 901, 
	900, 902, 202, 902, 902, 903, 904, 996, 
	996, 902, 902, 902, 902, 902, 200, 900, 
	901, 900, 902, 202, 902, 902, 903, 904, 
	997, 997, 902, 902, 902, 902, 902, 200, 
	900, 901, 900, 902, 202, 902, 902, 903, 
	904, 998, 998, 902, 902, 902, 902, 902, 
	200, 900, 901, 900, 902, 202, 902, 902, 
	903, 904, 999, 999, 902, 902, 902, 902, 
	902, 200, 1000, 1001, 1000, 902, 202, 902, 
	902, 903, 1002, 902, 902, 902, 902, 902, 
	200, 1003, 1004, 1003, 202, 907, 1002, 200, 
	1005, 204, 202, 200, 1006, 204, 1006, 202, 
	907, 1002, 200, 1007, 1008, 1007, 925, 1009, 
	925, 925, 926, 925, 925, 925, 925, 925, 
	925, 200, 1010, 204, 202, 200, 1011, 1012, 
	1011, 925, 1009, 925, 925, 926, 925, 925, 
	925, 925, 925, 925, 200, 1013, 204, 202, 
	200, 1014, 204, 1014, 1015, 200, 1016, 1017, 
	1016, 171, 675, 172, 21, 21, 169, 1018, 
	26, 21, 1019, 1020, 1019, 171, 675, 172, 
	21, 21, 169, 1021, 204, 202, 200, 900, 
	901, 900, 902, 202, 902, 902, 903, 904, 
	1022, 1022, 902, 902, 902, 902, 902, 200, 
	900, 901, 900, 902, 202, 902, 902, 903, 
	904, 1023, 1023, 902, 902, 902, 902, 902, 
	200, 1024, 1025, 1024, 902, 202, 902, 902, 
	903, 1026, 902, 902, 902, 902, 902, 200, 
	1027, 1028, 1027, 202, 907, 1026, 200, 1029, 
	204, 202, 200, 1030, 204, 1030, 202, 907, 
	1026, 200, 1026, 1031, 1026, 925, 202, 925, 
	925, 926, 925, 925, 925, 925, 925, 925, 
	200, 1032, 204, 202, 200, 1033, 204, 1033, 
	925, 202, 925, 925, 926, 925, 925, 925, 
	925, 925, 925, 200, 1034, 204, 202, 200, 
	900, 901, 900, 902, 202, 902, 902, 903, 
	904, 1035, 1035, 902, 902, 902, 902, 902, 
	200, 900, 901, 900, 902, 202, 902, 902, 
	903, 904, 1036, 1036, 902, 902, 902, 902, 
	902, 200, 900, 901, 900, 902, 202, 902, 
	902, 903, 904, 1037, 1037, 902, 902, 902, 
	902, 902, 200, 900, 901, 900, 902, 202, 
	902, 902, 903, 904, 1038, 1038, 902, 902, 
	902, 902, 902, 200, 1039, 1040, 1039, 902, 
	202, 902, 902, 903, 1041, 902, 902, 902, 
	902, 902, 200, 1042, 1043, 1042, 202, 907, 
	1041, 200, 1044, 204, 202, 200, 1045, 204, 
	1045, 202, 907, 1041, 200, 1046, 1047, 1046, 
	925, 1048, 925, 925, 926, 925, 925, 925, 
	925, 925, 925, 200, 1049, 204, 202, 200, 
	1050, 1051, 1050, 925, 1048, 925, 925, 926, 
	925, 925, 925, 925, 925, 925, 200, 1052, 
	204, 202, 200, 1053, 204, 1053, 1054, 200, 
	1055, 1056, 1055, 232, 1057, 233, 21, 21, 
	230, 1058, 26, 21, 1059, 1060, 1059, 232, 
	1057, 233, 21, 21, 230, 1061, 26, 21, 
	1062, 231, 1062, 232, 1057, 233, 21, 21, 
	230, 1057, 1063, 1057, 1064, 232, 1064, 1064, 
	1065, 1066, 1067, 1068, 1069, 1070, 1071, 233, 
	1065, 1066, 1067, 1068, 1069, 1070, 1071, 1064, 
	21, 21, 1064, 1064, 1064, 1064, 1064, 230, 
	1072, 26, 21, 1073, 231, 1073, 1064, 232, 
	1064, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 
	1071, 233, 1065, 1066, 1067, 1068, 1069, 1070, 
	1071, 1064, 21, 21, 1064, 1064, 1064, 1064, 
	1064, 230, 1074, 1075, 1074, 1076, 232, 1076, 
	1076, 1077, 1078, 233, 1076, 21, 21, 1076, 
	1076, 1076, 1076, 230, 1079, 1080, 1079, 232, 
	1057, 1078, 233, 21, 21, 230, 1081, 26, 
	21, 1082, 231, 1082, 232, 1057, 1078, 233, 
	21, 21, 230, 1078, 1083, 1078, 1084, 1085, 
	1084, 1084, 1086, 233, 1084, 21, 21, 1084, 
	1084, 1084, 1084, 1084, 230, 1087, 26, 21, 
	1088, 1089, 1088, 1084, 1085, 1084, 1084, 1086, 
	233, 1084, 21, 21, 1084, 1084, 1084, 1084, 
	1084, 230, 1090, 26, 21, 1091, 231, 1091, 
	1085, 233, 21, 21, 230, 1092, 1093, 1092, 
	77, 1094, 78, 21, 21, 69, 1095, 1096, 
	1095, 1084, 232, 1084, 1084, 1077, 233, 1084, 
	21, 21, 1084, 1084, 1084, 1084, 230, 1097, 
	1098, 1097, 232, 1057, 233, 21, 21, 230, 
	1099, 26, 21, 231, 232, 1101, 233, 21, 
	21, 21, 1100, 1100, 1100, 230, 231, 232, 
	1103, 233, 1104, 21, 21, 21, 1102, 1102, 
	1102, 230, 231, 232, 1103, 233, 1104, 21, 
	21, 21, 1105, 1105, 1105, 230, 231, 232, 
	1103, 233, 1104, 21, 21, 21, 1106, 1106, 
	1106, 230, 231, 232, 1103, 233, 1104, 21, 
	21, 21, 230, 231, 232, 1108, 233, 21, 
	21, 21, 1107, 1100, 1100, 230, 231, 232, 
	1109, 1103, 233, 1104, 21, 21, 21, 1110, 
	1102, 1102, 230, 231, 232, 233, 21, 21, 
	21, 1111, 230, 231, 232, 1112, 233, 21, 
	21, 21, 1113, 230, 231, 232, 233, 21, 
	21, 21, 1114, 230, 231, 232, 1115, 233, 
	21, 21, 21, 1116, 230, 231, 232, 233, 
	21, 21, 21, 1117, 230, 231, 232, 233, 
	1104, 21, 21, 21, 1118, 230, 231, 232, 
	233, 1104, 21, 21, 21, 1119, 230, 231, 
	232, 233, 1104, 21, 21, 21, 230, 1095, 
	1096, 1095, 232, 1077, 233, 21, 21, 230, 
	231, 232, 1115, 233, 21, 21, 21, 1120, 
	230, 231, 232, 1115, 233, 21, 21, 21, 
	230, 231, 232, 1112, 233, 21, 21, 21, 
	1121, 230, 231, 232, 1112, 233, 21, 21, 
	21, 230, 231, 232, 1109, 1103, 233, 1104, 
	21, 21, 21, 1122, 1105, 1105, 230, 231, 
	232, 1109, 1103, 233, 1104, 21, 21, 21, 
	1106, 1106, 1106, 230, 231, 232, 1124, 233, 
	1104, 21, 21, 21, 1123, 1123, 1123, 230, 
	231, 232, 1126, 233, 1104, 21, 21, 21, 
	1125, 1125, 1125, 230, 231, 232, 1126, 233, 
	1104, 21, 21, 21, 1127, 1127, 1127, 230, 
	231, 232, 1126, 233, 1104, 21, 21, 21, 
	1128, 1128, 1128, 230, 231, 232, 1126, 233, 
	1104, 21, 21, 21, 230, 231, 232, 233, 
	21, 21, 21, 1129, 1123, 1123, 230, 231, 
	232, 1109, 1126, 233, 1104, 21, 21, 21, 
	1130, 1125, 1125, 230, 231, 232, 1109, 1126, 
	233, 1104, 21, 21, 21, 1131, 1127, 1127, 
	230, 231, 232, 1109, 1126, 233, 1104, 21, 
	21, 21, 1128, 1128, 1128, 230, 231, 232, 
	233, 21, 21, 21, 1132, 230, 231, 232, 
	1109, 233, 21, 21, 21, 1133, 230, 231, 
	232, 1109, 233, 21, 21, 21, 1134, 230, 
	231, 232, 1109, 233, 21, 21, 21, 230, 
	231, 232, 1108, 233, 21, 21, 21, 230, 
	1135, 26, 21, 1074, 1075, 1074, 1076, 232, 
	1076, 1076, 1077, 1078, 1136, 233, 1136, 1076, 
	21, 21, 1076, 1076, 1076, 1076, 230, 1074, 
	1075, 1074, 1076, 232, 1076, 1076, 1077, 1078, 
	1137, 233, 1137, 1076, 21, 21, 1076, 1076, 
	1076, 1076, 230, 1074, 1075, 1074, 1076, 232, 
	1076, 1076, 1077, 1078, 1138, 233, 1138, 1076, 
	21, 21, 1076, 1076, 1076, 1076, 230, 1074, 
	1075, 1074, 1076, 232, 1076, 1076, 1077, 1078, 
	1139, 233, 1139, 1076, 21, 21, 1076, 1076, 
	1076, 1076, 230, 1074, 1075, 1074, 1076, 232, 
	1076, 1076, 1077, 1078, 1140, 233, 1140, 1076, 
	21, 21, 1076, 1076, 1076, 1076, 230, 1074, 
	1075, 1074, 1076, 232, 1076, 1076, 1077, 1078, 
	1141, 233, 1141, 1076, 21, 21, 1076, 1076, 
	1076, 1076, 230, 1074, 1075, 1074, 1076, 232, 
	1076, 1076, 1077, 1078, 1142, 233, 1142, 1076, 
	21, 21, 1076, 1076, 1076, 1076, 230, 1074, 
	1075, 1074, 1076, 232, 1076, 1076, 1077, 1078, 
	1143, 233, 1143, 1076, 21, 21, 1076, 1076, 
	1076, 1076, 230, 1144, 1145, 1144, 1076, 232, 
	1076, 1076, 1077, 1146, 233, 1076, 21, 21, 
	1076, 1076, 1076, 1076, 230, 1147, 1148, 1147, 
	232, 1057, 1146, 233, 21, 21, 230, 1149, 
	26, 21, 1150, 231, 1150, 232, 1057, 1146, 
	233, 21, 21, 230, 1146, 1151, 1146, 1152, 
	1085, 1152, 1152, 1086, 233, 1152, 21, 21, 
	1152, 1152, 1152, 1152, 1152, 230, 1153, 26, 
	21, 1154, 1089, 1154, 1152, 1085, 1152, 1152, 
	1086, 233, 1152, 21, 21, 1152, 1152, 1152, 
	1152, 1152, 230, 1155, 1156, 1155, 1157, 232, 
	1157, 1157, 1158, 233, 1157, 21, 21, 1157, 
	1157, 1157, 1157, 230, 1159, 26, 21, 1074, 
	1075, 1074, 1076, 232, 1076, 1076, 1077, 1078, 
	1160, 233, 1160, 1076, 21, 21, 1076, 1076, 
	1076, 1076, 230, 1074, 1075, 1074, 1076, 232, 
	1076, 1076, 1077, 1078, 1161, 233, 1161, 1076, 
	21, 21, 1076, 1076, 1076, 1076, 230, 1074, 
	1075, 1074, 1076, 232, 1076, 1076, 1077, 1078, 
	1162, 233, 1162, 1076, 21, 21, 1076, 1076, 
	1076, 1076, 230, 1074, 1075, 1074, 1076, 232, 
	1076, 1076, 1077, 1078, 1163, 233, 1163, 1076, 
	21, 21, 1076, 1076, 1076, 1076, 230, 1074, 
	1075, 1074, 1076, 232, 1076, 1076, 1077, 1078, 
	1164, 233, 1164, 1076, 21, 21, 1076, 1076, 
	1076, 1076, 230, 1165, 1166, 1165, 1076, 232, 
	1076, 1076, 1077, 1167, 233, 1076, 21, 21, 
	1076, 1076, 1076, 1076, 230, 1168, 1169, 1168, 
	232, 1057, 1167, 233, 21, 21, 230, 1170, 
	26, 21, 1171, 231, 1171, 232, 1057, 1167, 
	233, 21, 21, 230, 1167, 1172, 1167, 1084, 
	1173, 1084, 1084, 1086, 233, 1084, 21, 21, 
	1084, 1084, 1084, 1084, 1084, 230, 1174, 26, 
	21, 1175, 1176, 1175, 1084, 1173, 1084, 1084, 
	1086, 233, 1084, 21, 21, 1084, 1084, 1084, 
	1084, 1084, 230, 1177, 26, 21, 1178, 231, 
	1178, 1173, 233, 21, 21, 230, 1179, 1180, 
	1179, 390, 1181, 392, 387, 387, 386, 1182, 
	26, 21, 1074, 1075, 1074, 1076, 232, 1076, 
	1076, 1077, 1078, 1183, 233, 1183, 1076, 21, 
	21, 1076, 1076, 1076, 1076, 230, 1074, 1075, 
	1074, 1076, 232, 1076, 1076, 1077, 1078, 1184, 
	233, 1184, 1076, 21, 21, 1076, 1076, 1076, 
	1076, 230, 1074, 1075, 1074, 1076, 232, 1076, 
	1076, 1077, 1078, 1185, 233, 1185, 1076, 21, 
	21, 1076, 1076, 1076, 1076, 230, 1074, 1075, 
	1074, 1076, 232, 1076, 1076, 1077, 1078, 1186, 
	233, 1186, 1076, 21, 21, 1076, 1076, 1076, 
	1076, 230, 1187, 1188, 1187, 1076, 232, 1076, 
	1076, 1077, 1189, 233, 1076, 21, 21, 1076, 
	1076, 1076, 1076, 230, 1190, 1191, 1190, 232, 
	1057, 1189, 233, 21, 21, 230, 1192, 26, 
	21, 1193, 231, 1193, 232, 1057, 1189, 233, 
	21, 21, 230, 1194, 1195, 1194, 1084, 1196, 
	1084, 1084, 1086, 233, 1084, 21, 21, 1084, 
	1084, 1084, 1084, 1084, 230, 1197, 26, 21, 
	1198, 1199, 1198, 1084, 1196, 1084, 1084, 1086, 
	233, 1084, 21, 21, 1084, 1084, 1084, 1084, 
	1084, 230, 1200, 26, 21, 1201, 231, 1201, 
	1202, 233, 21, 21, 230, 1203, 1204, 1203, 
	108, 1205, 109, 21, 21, 106, 1206, 26, 
	21, 1074, 1075, 1074, 1076, 232, 1076, 1076, 
	1077, 1078, 1207, 233, 1207, 1076, 21, 21, 
	1076, 1076, 1076, 1076, 230, 1074, 1075, 1074, 
	1076, 232, 1076, 1076, 1077, 1078, 1208, 233, 
	1208, 1076, 21, 21, 1076, 1076, 1076, 1076, 
	230, 1074, 1075, 1074, 1076, 232, 1076, 1076, 
	1077, 1078, 1209, 233, 1209, 1076, 21, 21, 
	1076, 1076, 1076, 1076, 230, 1074, 1075, 1074, 
	1076, 232, 1076, 1076, 1077, 1078, 1210, 233, 
	1210, 1076, 21, 21, 1076, 1076, 1076, 1076, 
	230, 1074, 1075, 1074, 1076, 232, 1076, 1076, 
	1077, 1078, 1211, 233, 1211, 1076, 21, 21, 
	1076, 1076, 1076, 1076, 230, 1212, 1213, 1212, 
	1076, 232, 1076, 1076, 1077, 1214, 233, 1076, 
	21, 21, 1076, 1076, 1076, 1076, 230, 1215, 
	1216, 1215, 232, 1057, 1214, 233, 21, 21, 
	230, 1217, 26, 21, 1218, 231, 1218, 232, 
	1057, 1214, 233, 21, 21, 230, 1219, 1220, 
	1219, 1084, 1221, 1084, 1084, 1086, 233, 1084, 
	21, 21, 1084, 1084, 1084, 1084, 1084, 230, 
	1222, 26, 21, 1223, 1224, 1223, 1084, 1221, 
	1084, 1084, 1086, 233, 1084, 21, 21, 1084, 
	1084, 1084, 1084, 1084, 230, 1225, 26, 21, 
	1226, 231, 1226, 1227, 233, 21, 21, 230, 
	1228, 1229, 1228, 171, 1230, 172, 21, 21, 
	169, 1231, 26, 21, 1074, 1075, 1074, 1076, 
	232, 1076, 1076, 1077, 1078, 1232, 233, 1232, 
	1076, 21, 21, 1076, 1076, 1076, 1076, 230, 
	1074, 1075, 1074, 1076, 232, 1076, 1076, 1077, 
	1078, 1233, 233, 1233, 1076, 21, 21, 1076, 
	1076, 1076, 1076, 230, 1234, 1235, 1234, 1076, 
	232, 1076, 1076, 1077, 1236, 233, 1076, 21, 
	21, 1076, 1076, 1076, 1076, 230, 1237, 1238, 
	1237, 232, 1057, 1236, 233, 21, 21, 230, 
	1239, 26, 21, 1240, 231, 1240, 232, 1057, 
	1236, 233, 21, 21, 230, 1236, 1241, 1236, 
	1084, 1242, 1084, 1084, 1086, 233, 1084, 21, 
	21, 1084, 1084, 1084, 1084, 1084, 230, 1243, 
	26, 21, 1244, 1245, 1244, 1084, 1242, 1084, 
	1084, 1086, 233, 1084, 21, 21, 1084, 1084, 
	1084, 1084, 1084, 230, 1246, 26, 21, 1247, 
	231, 1247, 1242, 233, 21, 21, 230, 1248, 
	1249, 1248, 197, 1250, 198, 195, 195, 194, 
	1251, 26, 21, 1074, 1075, 1074, 1076, 232, 
	1076, 1076, 1077, 1078, 1252, 233, 1252, 1076, 
	21, 21, 1076, 1076, 1076, 1076, 230, 1074, 
	1075, 1074, 1076, 232, 1076, 1076, 1077, 1078, 
	1253, 233, 1253, 1076, 21, 21, 1076, 1076, 
	1076, 1076, 230, 1074, 1075, 1074, 1076, 232, 
	1076, 1076, 1077, 1078, 1254, 233, 1254, 1076, 
	21, 21, 1076, 1076, 1076, 1076, 230, 1074, 
	1075, 1074, 1076, 232, 1076, 1076, 1077, 1078, 
	1255, 233, 1255, 1076, 21, 21, 1076, 1076, 
	1076, 1076, 230, 1256, 1257, 1256, 1076, 232, 
	1076, 1076, 1077, 1258, 233, 1076, 21, 21, 
	1076, 1076, 1076, 1076, 230, 1259, 1260, 1259, 
	232, 1057, 1258, 233, 21, 21, 230, 1261, 
	26, 21, 1262, 231, 1262, 232, 1057, 1258, 
	233, 21, 21, 230, 1263, 1264, 1263, 1084, 
	1265, 1084, 1084, 1086, 233, 1084, 21, 21, 
	1084, 1084, 1084, 1084, 1084, 230, 1266, 26, 
	21, 1267, 1268, 1267, 1084, 1265, 1084, 1084, 
	1086, 233, 1084, 21, 21, 1084, 1084, 1084, 
	1084, 1084, 230, 1269, 26, 21, 1270, 231, 
	1270, 1271, 233, 21, 21, 230, 1272, 1273, 
	1272, 232, 1274, 233, 21, 21, 230, 1275, 
	26, 21, 1074, 1075, 1074, 1076, 232, 1076, 
	1076, 1077, 1078, 1276, 233, 1276, 1076, 21, 
	21, 1076, 1076, 1076, 1076, 230, 1074, 1075, 
	1074, 1076, 232, 1076, 1076, 1077, 1078, 1277, 
	233, 1277, 1076, 21, 21, 1076, 1076, 1076, 
	1076, 230, 1074, 1075, 1074, 1076, 232, 1076, 
	1076, 1077, 1078, 1278, 233, 1278, 1076, 21, 
	21, 1076, 1076, 1076, 1076, 230, 1074, 1075, 
	1074, 1076, 232, 1076, 1076, 1077, 1078, 1279, 
	233, 1279, 1076, 21, 21, 1076, 1076, 1076, 
	1076, 230, 1280, 1281, 1280, 1076, 232, 1076, 
	1076, 1077, 1282, 233, 1076, 21, 21, 1076, 
	1076, 1076, 1076, 230, 1283, 1284, 1283, 232, 
	1057, 1282, 233, 21, 21, 230, 1285, 26, 
	21, 1286, 231, 1286, 232, 1057, 1282, 233, 
	21, 21, 230, 1282, 1287, 1282, 1084, 1085, 
	1084, 1084, 1288, 1289, 1086, 233, 1288, 1289, 
	1084, 21, 21, 1084, 1084, 1084, 1084, 1084, 
	230, 1290, 26, 21, 1291, 1089, 1291, 1084, 
	1085, 1084, 1084, 1288, 1289, 1086, 233, 1288, 
	1289, 1084, 21, 21, 1084, 1084, 1084, 1084, 
	1084, 230, 1095, 1096, 1095, 1084, 232, 1084, 
	1084, 1077, 1292, 233, 1292, 1084, 21, 21, 
	1084, 1084, 1084, 1084, 230, 1095, 1096, 1095, 
	1084, 232, 1084, 1084, 1077, 1293, 233, 1293, 
	1084, 21, 21, 1084, 1084, 1084, 1084, 230, 
	1095, 1096, 1095, 1084, 232, 1084, 1084, 1077, 
	1294, 233, 1294, 1084, 21, 21, 1084, 1084, 
	1084, 1084, 230, 1095, 1096, 1095, 1084, 232, 
	1084, 1084, 1077, 1295, 233, 1295, 1084, 21, 
	21, 1084, 1084, 1084, 1084, 230, 1296, 1297, 
	1296, 232, 1298, 233, 21, 21, 230, 1095, 
	1096, 1095, 1084, 232, 1084, 1084, 1077, 1299, 
	233, 1299, 1084, 21, 21, 1084, 1084, 1084, 
	1084, 230, 1095, 1096, 1095, 1084, 232, 1084, 
	1084, 1077, 1294, 233, 1294, 1084, 21, 21, 
	1084, 1084, 1084, 1084, 230, 1300, 26, 21, 
	1301, 204, 202, 200, 900, 901, 900, 902, 
	202, 902, 902, 903, 904, 1302, 1302, 902, 
	902, 902, 902, 902, 200, 900, 901, 900, 
	902, 202, 902, 902, 903, 904, 1303, 1303, 
	902, 902, 902, 902, 902, 200, 900, 901, 
	900, 902, 202, 902, 902, 903, 904, 1304, 
	1304, 902, 902, 902, 902, 902, 200, 900, 
	901, 900, 902, 202, 902, 902, 903, 904, 
	1305, 1305, 902, 902, 902, 902, 902, 200, 
	1306, 1307, 1306, 902, 202, 902, 902, 903, 
	1308, 902, 902, 902, 902, 902, 200, 1309, 
	1310, 1309, 202, 907, 1308, 200, 1311, 204, 
	202, 200, 1312, 204, 1312, 202, 907, 1308, 
	200, 1308, 1313, 1308, 925, 265, 925, 925, 
	1314, 1315, 926, 1314, 1315, 925, 925, 925, 
	925, 925, 925, 200, 1316, 204, 202, 200, 
	1317, 929, 1317, 925, 265, 925, 925, 1314, 
	1315, 926, 1314, 1315, 925, 925, 925, 925, 
	925, 925, 200, 932, 933, 932, 925, 202, 
	925, 925, 903, 1318, 1318, 925, 925, 925, 
	925, 925, 200, 932, 933, 932, 925, 202, 
	925, 925, 903, 1319, 1319, 925, 925, 925, 
	925, 925, 200, 932, 933, 932, 925, 202, 
	925, 925, 903, 1320, 1320, 925, 925, 925, 
	925, 925, 200, 932, 933, 932, 925, 202, 
	925, 925, 903, 1321, 1321, 925, 925, 925, 
	925, 925, 200, 1322, 1323, 1322, 202, 1324, 
	200, 932, 933, 932, 925, 202, 925, 925, 
	903, 1325, 1325, 925, 925, 925, 925, 925, 
	200, 932, 933, 932, 925, 202, 925, 925, 
	903, 1320, 1320, 925, 925, 925, 925, 925, 
	200, 1326, 204, 202, 200, 900, 901, 900, 
	902, 202, 902, 902, 903, 904, 1327, 1327, 
	902, 902, 902, 902, 902, 200, 900, 901, 
	900, 902, 202, 902, 902, 903, 904, 1328, 
	1328, 902, 902, 902, 902, 902, 200, 900, 
	901, 900, 902, 202, 902, 902, 903, 904, 
	1329, 1329, 902, 902, 902, 902, 902, 200, 
	900, 901, 900, 902, 202, 902, 902, 903, 
	904, 1330, 1330, 902, 902, 902, 902, 902, 
	200, 1331, 1332, 1331, 902, 202, 902, 902, 
	903, 1333, 902, 902, 902, 902, 902, 200, 
	1334, 1335, 1334, 202, 907, 1333, 200, 1336, 
	204, 202, 200, 1337, 204, 1337, 202, 907, 
	1333, 200, 1333, 1338, 1333, 925, 1339, 925, 
	925, 926, 925, 925, 925, 925, 925, 925, 
	200, 1340, 204, 202, 200, 1341, 1342, 1341, 
	925, 1339, 925, 925, 926, 925, 925, 925, 
	925, 925, 925, 200, 1343, 204, 202, 200, 
	1344, 204, 1344, 1339, 200, 1345, 1346, 1345, 
	390, 1347, 392, 387, 387, 386, 1348, 1349, 
	1348, 396, 404, 397, 394, 394, 393, 1350, 
	398, 396, 394, 1351, 1352, 1351, 396, 404, 
	397, 394, 394, 393, 438, 439, 438, 440, 
	396, 440, 440, 441, 442, 1353, 1353, 440, 
	440, 440, 440, 440, 394, 438, 439, 438, 
	440, 396, 440, 440, 441, 442, 1354, 1354, 
	440, 440, 440, 440, 440, 394, 438, 439, 
	438, 440, 396, 440, 440, 441, 442, 1355, 
	1355, 440, 440, 440, 440, 440, 394, 438, 
	439, 438, 440, 396, 440, 440, 441, 442, 
	1356, 1356, 440, 440, 440, 440, 440, 394, 
	438, 439, 438, 440, 396, 440, 440, 441, 
	442, 1357, 1357, 440, 440, 440, 440, 440, 
	394, 1358, 1359, 1358, 440, 396, 440, 440, 
	441, 1360, 440, 440, 440, 440, 440, 394, 
	1361, 1362, 1361, 396, 445, 1360, 394, 1363, 
	398, 396, 394, 1364, 398, 1364, 396, 445, 
	1360, 394, 1365, 1366, 1365, 463, 1367, 463, 
	463, 464, 463, 463, 463, 463, 463, 463, 
	394, 1368, 398, 396, 394, 1369, 1370, 1369, 
	463, 1367, 463, 463, 464, 463, 463, 463, 
	463, 463, 463, 394, 1371, 398, 396, 394, 
	1372, 398, 1372, 1373, 394, 398, 396, 1375, 
	1374, 1374, 1374, 394, 398, 396, 1377, 1378, 
	1376, 1376, 1376, 394, 398, 396, 1377, 1378, 
	1379, 1379, 1379, 394, 398, 396, 1377, 1378, 
	1380, 1380, 1380, 394, 398, 396, 1377, 1378, 
	394, 398, 396, 1382, 1381, 1374, 1374, 394, 
	398, 396, 1383, 1377, 1378, 1384, 1376, 1376, 
	394, 398, 396, 1385, 394, 398, 396, 1386, 
	1387, 394, 398, 396, 1388, 394, 398, 396, 
	1389, 1390, 394, 398, 396, 1391, 394, 398, 
	396, 1378, 1392, 394, 398, 396, 1378, 1393, 
	394, 398, 396, 1378, 394, 470, 471, 470, 
	396, 441, 394, 398, 396, 1389, 1394, 394, 
	398, 396, 1389, 394, 398, 396, 1386, 1395, 
	394, 398, 396, 1386, 394, 398, 396, 1383, 
	1377, 1378, 1396, 1379, 1379, 394, 398, 396, 
	1383, 1377, 1378, 1380, 1380, 1380, 394, 398, 
	396, 1398, 1378, 1397, 1397, 1397, 394, 398, 
	396, 1400, 1378, 1399, 1399, 1399, 394, 398, 
	396, 1400, 1378, 1401, 1401, 1401, 394, 398, 
	396, 1400, 1378, 1402, 1402, 1402, 394, 398, 
	396, 1400, 1378, 394, 398, 396, 1403, 1397, 
	1397, 394, 398, 396, 1383, 1400, 1378, 1404, 
	1399, 1399, 394, 398, 396, 1383, 1400, 1378, 
	1405, 1401, 1401, 394, 398, 396, 1383, 1400, 
	1378, 1402, 1402, 1402, 394, 398, 396, 1406, 
	394, 398, 396, 1383, 1407, 394, 398, 396, 
	1383, 1408, 394, 398, 396, 1383, 394, 398, 
	396, 1382, 394, 1409, 398, 396, 394, 438, 
	439, 438, 440, 396, 440, 440, 441, 442, 
	1410, 1410, 440, 440, 440, 440, 440, 394, 
	438, 439, 438, 440, 396, 440, 440, 441, 
	442, 1411, 1411, 440, 440, 440, 440, 440, 
	394, 1412, 1413, 1412, 440, 396, 440, 440, 
	441, 1414, 440, 440, 440, 440, 440, 394, 
	1415, 1416, 1415, 396, 445, 1414, 394, 1417, 
	398, 396, 394, 1418, 398, 1418, 396, 445, 
	1414, 394, 1414, 1419, 1414, 463, 1420, 463, 
	463, 464, 463, 463, 463, 463, 463, 463, 
	394, 1421, 398, 396, 394, 1422, 1423, 1422, 
	463, 1420, 463, 463, 464, 463, 463, 463, 
	463, 463, 463, 394, 1424, 398, 396, 394, 
	1425, 398, 1425, 1420, 394, 1426, 1427, 1426, 
	197, 1428, 198, 195, 195, 194, 1429, 1430, 
	1429, 202, 866, 203, 200, 200, 199, 1431, 
	204, 202, 200, 1432, 1433, 1432, 202, 866, 
	203, 200, 200, 199, 1434, 398, 396, 394, 
	438, 439, 438, 440, 396, 440, 440, 441, 
	442, 1435, 1435, 440, 440, 440, 440, 440, 
	394, 438, 439, 438, 440, 396, 440, 440, 
	441, 442, 1436, 1436, 440, 440, 440, 440, 
	440, 394, 438, 439, 438, 440, 396, 440, 
	440, 441, 442, 1437, 1437, 440, 440, 440, 
	440, 440, 394, 438, 439, 438, 440, 396, 
	440, 440, 441, 442, 1438, 1438, 440, 440, 
	440, 440, 440, 394, 1439, 1440, 1439, 440, 
	396, 440, 440, 441, 1441, 440, 440, 440, 
	440, 440, 394, 1442, 1443, 1442, 396, 445, 
	1441, 394, 1444, 398, 396, 394, 1445, 398, 
	1445, 396, 445, 1441, 394, 1446, 1447, 1446, 
	463, 1448, 463, 463, 464, 463, 463, 463, 
	463, 463, 463, 394, 1449, 398, 396, 394, 
	1450, 1451, 1450, 463, 1448, 463, 463, 464, 
	463, 463, 463, 463, 463, 463, 394, 1452, 
	398, 396, 394, 1453, 398, 1453, 1454, 394, 
	1455, 398, 396, 394, 438, 439, 438, 440, 
	396, 440, 440, 441, 442, 1456, 1456, 440, 
	440, 440, 440, 440, 394, 438, 439, 438, 
	440, 396, 440, 440, 441, 442, 1457, 1457, 
	440, 440, 440, 440, 440, 394, 438, 439, 
	438, 440, 396, 440, 440, 441, 442, 1458, 
	1458, 440, 440, 440, 440, 440, 394, 438, 
	439, 438, 440, 396, 440, 440, 441, 442, 
	1459, 1459, 440, 440, 440, 440, 440, 394, 
	1460, 1461, 1460, 440, 396, 440, 440, 441, 
	1462, 440, 440, 440, 440, 440, 394, 1463, 
	1464, 1463, 396, 445, 1462, 394, 1465, 398, 
	396, 394, 1466, 398, 1466, 396, 445, 1462, 
	394, 1462, 1467, 1462, 463, 401, 463, 463, 
	1468, 1469, 464, 1468, 1469, 463, 463, 463, 
	463, 463, 463, 394, 1470, 398, 396, 394, 
	1471, 467, 1471, 463, 401, 463, 463, 1468, 
	1469, 464, 1468, 1469, 463, 463, 463, 463, 
	463, 463, 394, 470, 471, 470, 463, 396, 
	463, 463, 441, 1472, 1472, 463, 463, 463, 
	463, 463, 394, 470, 471, 470, 463, 396, 
	463, 463, 441, 1473, 1473, 463, 463, 463, 
	463, 463, 394, 470, 471, 470, 463, 396, 
	463, 463, 441, 1474, 1474, 463, 463, 463, 
	463, 463, 394, 470, 471, 470, 463, 396, 
	463, 463, 441, 1475, 1475, 463, 463, 463, 
	463, 463, 394, 1476, 1477, 1476, 396, 1478, 
	394, 470, 471, 470, 463, 396, 463, 463, 
	441, 1479, 1479, 463, 463, 463, 463, 463, 
	394, 470, 471, 470, 463, 396, 463, 463, 
	441, 1474, 1474, 463, 463, 463, 463, 463, 
	394, 1480, 398, 396, 394, 1481, 204, 202, 
	200, 900, 901, 900, 902, 202, 902, 902, 
	903, 904, 1482, 1482, 902, 902, 902, 902, 
	902, 200, 900, 901, 900, 902, 202, 902, 
	902, 903, 904, 1483, 1483, 902, 902, 902, 
	902, 902, 200, 900, 901, 900, 902, 202, 
	902, 902, 903, 904, 1484, 1484, 902, 902, 
	902, 902, 902, 200, 900, 901, 900, 902, 
	202, 902, 902, 903, 904, 1485, 1485, 902, 
	902, 902, 902, 902, 200, 900, 901, 900, 
	902, 202, 902, 902, 903, 904, 1486, 1486, 
	902, 902, 902, 902, 902, 200, 900, 901, 
	900, 902, 202, 902, 902, 903, 904, 1487, 
	1487, 902, 902, 902, 902, 902, 200, 900, 
	901, 900, 902, 202, 902, 902, 903, 904, 
	1488, 1488, 902, 902, 902, 902, 902, 200, 
	1489, 1490, 1489, 902, 202, 902, 902, 903, 
	1491, 902, 902, 902, 902, 902, 200, 1492, 
	1493, 1492, 202, 907, 1491, 200, 1494, 204, 
	202, 200, 1495, 204, 1495, 202, 907, 1491, 
	200, 1491, 1496, 1491, 1497, 265, 1497, 1497, 
	926, 1497, 1497, 1497, 1497, 1497, 1497, 200, 
	1498, 204, 202, 200, 1499, 929, 1499, 1497, 
	265, 1497, 1497, 926, 1497, 1497, 1497, 1497, 
	1497, 1497, 200, 1500, 1501, 1500, 1502, 202, 
	1502, 1502, 1503, 1502, 1502, 1502, 1502, 1502, 
	200, 1504, 204, 202, 200, 201, 202, 1506, 
	203, 200, 200, 200, 1505, 1505, 1505, 199, 
	201, 202, 1508, 203, 1509, 200, 200, 200, 
	1507, 1507, 1507, 199, 201, 202, 1508, 203, 
	1509, 200, 200, 200, 1510, 1510, 1510, 199, 
	201, 202, 1508, 203, 1509, 200, 200, 200, 
	1511, 1511, 1511, 199, 201, 202, 1508, 203, 
	1509, 200, 200, 200, 199, 201, 202, 1513, 
	203, 200, 200, 200, 1512, 1505, 1505, 199, 
	201, 202, 1514, 1508, 203, 1509, 200, 200, 
	200, 1515, 1507, 1507, 199, 201, 202, 203, 
	200, 200, 200, 1516, 199, 201, 202, 1517, 
	203, 200, 200, 200, 1518, 199, 201, 202, 
	203, 200, 200, 200, 1519, 199, 201, 202, 
	1520, 203, 200, 200, 200, 1521, 199, 201, 
	202, 203, 200, 200, 200, 1522, 199, 201, 
	202, 203, 1509, 200, 200, 200, 1523, 199, 
	201, 202, 203, 1509, 200, 200, 200, 1524, 
	199, 201, 202, 203, 1509, 200, 200, 200, 
	199, 897, 898, 897, 202, 883, 203, 200, 
	200, 199, 201, 202, 1520, 203, 200, 200, 
	200, 1525, 199, 201, 202, 1520, 203, 200, 
	200, 200, 199, 201, 202, 1517, 203, 200, 
	200, 200, 1526, 199, 201, 202, 1517, 203, 
	200, 200, 200, 199, 201, 202, 1514, 1508, 
	203, 1509, 200, 200, 200, 1527, 1510, 1510, 
	199, 201, 202, 1514, 1508, 203, 1509, 200, 
	200, 200, 1511, 1511, 1511, 199, 201, 202, 
	1529, 203, 1509, 200, 200, 200, 1528, 1528, 
	1528, 199, 201, 202, 1531, 203, 1509, 200, 
	200, 200, 1530, 1530, 1530, 199, 201, 202, 
	1531, 203, 1509, 200, 200, 200, 1532, 1532, 
	1532, 199, 201, 202, 1531, 203, 1509, 200, 
	200, 200, 1533, 1533, 1533, 199, 201, 202, 
	1531, 203, 1509, 200, 200, 200, 199, 201, 
	202, 203, 200, 200, 200, 1534, 1528, 1528, 
	199, 201, 202, 1514, 1531, 203, 1509, 200, 
	200, 200, 1535, 1530, 1530, 199, 201, 202, 
	1514, 1531, 203, 1509, 200, 200, 200, 1536, 
	1532, 1532, 199, 201, 202, 1514, 1531, 203, 
	1509, 200, 200, 200, 1533, 1533, 1533, 199, 
	201, 202, 203, 200, 200, 200, 1537, 199, 
	201, 202, 1514, 203, 200, 200, 200, 1538, 
	199, 201, 202, 1514, 203, 200, 200, 200, 
	1539, 199, 201, 202, 1514, 203, 200, 200, 
	200, 199, 201, 202, 1513, 203, 200, 200, 
	200, 199, 1540, 204, 202, 200, 880, 881, 
	880, 882, 202, 882, 882, 883, 884, 1541, 
	203, 1541, 882, 200, 200, 882, 882, 882, 
	882, 199, 880, 881, 880, 882, 202, 882, 
	882, 883, 884, 1542, 203, 1542, 882, 200, 
	200, 882, 882, 882, 882, 199, 880, 881, 
	880, 882, 202, 882, 882, 883, 884, 1543, 
	203, 1543, 882, 200, 200, 882, 882, 882, 
	882, 199, 880, 881, 880, 882, 202, 882, 
	882, 883, 884, 1544, 203, 1544, 882, 200, 
	200, 882, 882, 882, 882, 199, 880, 881, 
	880, 882, 202, 882, 882, 883, 884, 1545, 
	203, 1545, 882, 200, 200, 882, 882, 882, 
	882, 199, 880, 881, 880, 882, 202, 882, 
	882, 883, 884, 1546, 203, 1546, 882, 200, 
	200, 882, 882, 882, 882, 199, 880, 881, 
	880, 882, 202, 882, 882, 883, 884, 1547, 
	203, 1547, 882, 200, 200, 882, 882, 882, 
	882, 199, 880, 881, 880, 882, 202, 882, 
	882, 883, 884, 1548, 203, 1548, 882, 200, 
	200, 882, 882, 882, 882, 199, 1549, 1550, 
	1549, 882, 202, 882, 882, 883, 1551, 203, 
	882, 200, 200, 882, 882, 882, 882, 199, 
	1552, 1553, 1552, 202, 866, 1551, 203, 200, 
	200, 199, 1554, 204, 202, 200, 1555, 201, 
	1555, 202, 866, 1551, 203, 200, 200, 199, 
	1551, 1556, 1551, 1557, 265, 1557, 1557, 891, 
	203, 1557, 200, 200, 1557, 1557, 1557, 1557, 
	1557, 199, 1558, 204, 202, 200, 1559, 894, 
	1559, 1557, 265, 1557, 1557, 891, 203, 1557, 
	200, 200, 1557, 1557, 1557, 1557, 1557, 199, 
	1560, 1561, 1560, 1562, 202, 1562, 1562, 1563, 
	203, 1562, 200, 200, 1562, 1562, 1562, 1562, 
	199, 1564, 204, 202, 200, 880, 881, 880, 
	882, 202, 882, 882, 883, 884, 1565, 203, 
	1565, 882, 200, 200, 882, 882, 882, 882, 
	199, 880, 881, 880, 882, 202, 882, 882, 
	883, 884, 1566, 203, 1566, 882, 200, 200, 
	882, 882, 882, 882, 199, 880, 881, 880, 
	882, 202, 882, 882, 883, 884, 1567, 203, 
	1567, 882, 200, 200, 882, 882, 882, 882, 
	199, 880, 881, 880, 882, 202, 882, 882, 
	883, 884, 1568, 203, 1568, 882, 200, 200, 
	882, 882, 882, 882, 199, 880, 881, 880, 
	882, 202, 882, 882, 883, 884, 1569, 203, 
	1569, 882, 200, 200, 882, 882, 882, 882, 
	199, 1570, 1571, 1570, 882, 202, 882, 882, 
	883, 1572, 203, 882, 200, 200, 882, 882, 
	882, 882, 199, 1573, 1574, 1573, 202, 866, 
	1572, 203, 200, 200, 199, 1575, 204, 202, 
	200, 1576, 201, 1576, 202, 866, 1572, 203, 
	200, 200, 199, 1572, 1577, 1572, 890, 1339, 
	890, 890, 891, 203, 890, 200, 200, 890, 
	890, 890, 890, 890, 199, 1578, 204, 202, 
	200, 1579, 1580, 1579, 890, 1339, 890, 890, 
	891, 203, 890, 200, 200, 890, 890, 890, 
	890, 890, 199, 1581, 204, 202, 200, 1582, 
	201, 1582, 1339, 203, 200, 200, 199, 1583, 
	204, 202, 200, 880, 881, 880, 882, 202, 
	882, 882, 883, 884, 1584, 203, 1584, 882, 
	200, 200, 882, 882, 882, 882, 199, 880, 
	881, 880, 882, 202, 882, 882, 883, 884, 
	1585, 203, 1585, 882, 200, 200, 882, 882, 
	882, 882, 199, 880, 881, 880, 882, 202, 
	882, 882, 883, 884, 1586, 203, 1586, 882, 
	200, 200, 882, 882, 882, 882, 199, 880, 
	881, 880, 882, 202, 882, 882, 883, 884, 
	1587, 203, 1587, 882, 200, 200, 882, 882, 
	882, 882, 199, 1588, 1589, 1588, 882, 202, 
	882, 882, 883, 1590, 203, 882, 200, 200, 
	882, 882, 882, 882, 199, 1591, 1592, 1591, 
	202, 866, 1590, 203, 200, 200, 199, 1593, 
	204, 202, 200, 1594, 201, 1594, 202, 866, 
	1590, 203, 200, 200, 199, 1595, 1596, 1595, 
	890, 952, 890, 890, 891, 203, 890, 200, 
	200, 890, 890, 890, 890, 890, 199, 1597, 
	204, 202, 200, 1598, 1599, 1598, 890, 952, 
	890, 890, 891, 203, 890, 200, 200, 890, 
	890, 890, 890, 890, 199, 1600, 204, 202, 
	200, 1601, 201, 1601, 958, 203, 200, 200, 
	199, 1602, 204, 202, 200, 880, 881, 880, 
	882, 202, 882, 882, 883, 884, 1603, 203, 
	1603, 882, 200, 200, 882, 882, 882, 882, 
	199, 880, 881, 880, 882, 202, 882, 882, 
	883, 884, 1604, 203, 1604, 882, 200, 200, 
	882, 882, 882, 882, 199, 880, 881, 880, 
	882, 202, 882, 882, 883, 884, 1605, 203, 
	1605, 882, 200, 200, 882, 882, 882, 882, 
	199, 880, 881, 880, 882, 202, 882, 882, 
	883, 884, 1606, 203, 1606, 882, 200, 200, 
	882, 882, 882, 882, 199, 880, 881, 880, 
	882, 202, 882, 882, 883, 884, 1607, 203, 
	1607, 882, 200, 200, 882, 882, 882, 882, 
	199, 1608, 1609, 1608, 882, 202, 882, 882, 
	883, 1610, 203, 882, 200, 200, 882, 882, 
	882, 882, 199, 1611, 1612, 1611, 202, 866, 
	1610, 203, 200, 200, 199, 1613, 204, 202, 
	200, 1614, 201, 1614, 202, 866, 1610, 203, 
	200, 200, 199, 1615, 1616, 1615, 890, 1009, 
	890, 890, 891, 203, 890, 200, 200, 890, 
	890, 890, 890, 890, 199, 1617, 204, 202, 
	200, 1618, 1619, 1618, 890, 1009, 890, 890, 
	891, 203, 890, 200, 200, 890, 890, 890, 
	890, 890, 199, 1620, 204, 202, 200, 1621, 
	201, 1621, 1015, 203, 200, 200, 199, 1622, 
	204, 202, 200, 880, 881, 880, 882, 202, 
	882, 882, 883, 884, 1623, 203, 1623, 882, 
	200, 200, 882, 882, 882, 882, 199, 880, 
	881, 880, 882, 202, 882, 882, 883, 884, 
	1624, 203, 1624, 882, 200, 200, 882, 882, 
	882, 882, 199, 1625, 1626, 1625, 882, 202, 
	882, 882, 883, 1627, 203, 882, 200, 200, 
	882, 882, 882, 882, 199, 1628, 1629, 1628, 
	202, 866, 1627, 203, 200, 200, 199, 1630, 
	204, 202, 200, 1631, 201, 1631, 202, 866, 
	1627, 203, 200, 200, 199, 1627, 1632, 1627, 
	890, 202, 890, 890, 891, 203, 890, 200, 
	200, 890, 890, 890, 890, 890, 199, 1633, 
	204, 202, 200, 1634, 201, 1634, 890, 202, 
	890, 890, 891, 203, 890, 200, 200, 890, 
	890, 890, 890, 890, 199, 1635, 204, 202, 
	200, 880, 881, 880, 882, 202, 882, 882, 
	883, 884, 1636, 203, 1636, 882, 200, 200, 
	882, 882, 882, 882, 199, 880, 881, 880, 
	882, 202, 882, 882, 883, 884, 1637, 203, 
	1637, 882, 200, 200, 882, 882, 882, 882, 
	199, 880, 881, 880, 882, 202, 882, 882, 
	883, 884, 1638, 203, 1638, 882, 200, 200, 
	882, 882, 882, 882, 199, 880, 881, 880, 
	882, 202, 882, 882, 883, 884, 1639, 203, 
	1639, 882, 200, 200, 882, 882, 882, 882, 
	199, 1640, 1641, 1640, 882, 202, 882, 882, 
	883, 1642, 203, 882, 200, 200, 882, 882, 
	882, 882, 199, 1643, 1644, 1643, 202, 866, 
	1642, 203, 200, 200, 199, 1645, 204, 202, 
	200, 1646, 201, 1646, 202, 866, 1642, 203, 
	200, 200, 199, 1647, 1648, 1647, 890, 1048, 
	890, 890, 891, 203, 890, 200, 200, 890, 
	890, 890, 890, 890, 199, 1649, 204, 202, 
	200, 1650, 1651, 1650, 890, 1048, 890, 890, 
	891, 203, 890, 200, 200, 890, 890, 890, 
	890, 890, 199, 1652, 204, 202, 200, 1653, 
	201, 1653, 1054, 203, 200, 200, 199, 1654, 
	204, 202, 200, 880, 881, 880, 882, 202, 
	882, 882, 883, 884, 1655, 203, 1655, 882, 
	200, 200, 882, 882, 882, 882, 199, 880, 
	881, 880, 882, 202, 882, 882, 883, 884, 
	1656, 203, 1656, 882, 200, 200, 882, 882, 
	882, 882, 199, 880, 881, 880, 882, 202, 
	882, 882, 883, 884, 1657, 203, 1657, 882, 
	200, 200, 882, 882, 882, 882, 199, 880, 
	881, 880, 882, 202, 882, 882, 883, 884, 
	1658, 203, 1658, 882, 200, 200, 882, 882, 
	882, 882, 199, 1659, 1660, 1659, 882, 202, 
	882, 882, 883, 1661, 203, 882, 200, 200, 
	882, 882, 882, 882, 199, 1662, 1663, 1662, 
	202, 866, 1661, 203, 200, 200, 199, 1664, 
	204, 202, 200, 1665, 201, 1665, 202, 866, 
	1661, 203, 200, 200, 199, 1661, 1666, 1661, 
	890, 265, 890, 890, 1667, 1668, 891, 203, 
	1667, 1668, 890, 200, 200, 890, 890, 890, 
	890, 890, 199, 1669, 204, 202, 200, 1670, 
	894, 1670, 890, 265, 890, 890, 1667, 1668, 
	891, 203, 1667, 1668, 890, 200, 200, 890, 
	890, 890, 890, 890, 199, 897, 898, 897, 
	890, 202, 890, 890, 883, 1671, 203, 1671, 
	890, 200, 200, 890, 890, 890, 890, 199, 
	897, 898, 897, 890, 202, 890, 890, 883, 
	1672, 203, 1672, 890, 200, 200, 890, 890, 
	890, 890, 199, 897, 898, 897, 890, 202, 
	890, 890, 883, 1673, 203, 1673, 890, 200, 
	200, 890, 890, 890, 890, 199, 897, 898, 
	897, 890, 202, 890, 890, 883, 1674, 203, 
	1674, 890, 200, 200, 890, 890, 890, 890, 
	199, 1675, 1676, 1675, 202, 1677, 203, 200, 
	200, 199, 897, 898, 897, 890, 202, 890, 
	890, 883, 1678, 203, 1678, 890, 200, 200, 
	890, 890, 890, 890, 199, 897, 898, 897, 
	890, 202, 890, 890, 883, 1673, 203, 1673, 
	890, 200, 200, 890, 890, 890, 890, 199, 
	1679, 204, 202, 200, 1680, 26, 21, 689, 
	690, 689, 691, 171, 691, 691, 692, 693, 
	1681, 172, 1681, 691, 21, 21, 691, 691, 
	691, 691, 169, 689, 690, 689, 691, 171, 
	691, 691, 692, 693, 1682, 172, 1682, 691, 
	21, 21, 691, 691, 691, 691, 169, 689, 
	690, 689, 691, 171, 691, 691, 692, 693, 
	1683, 172, 1683, 691, 21, 21, 691, 691, 
	691, 691, 169, 689, 690, 689, 691, 171, 
	691, 691, 692, 693, 1684, 172, 1684, 691, 
	21, 21, 691, 691, 691, 691, 169, 1685, 
	1686, 1685, 691, 171, 691, 691, 692, 1687, 
	172, 691, 21, 21, 691, 691, 691, 691, 
	169, 1688, 1689, 1688, 171, 675, 1687, 172, 
	21, 21, 169, 1690, 26, 21, 1691, 170, 
	1691, 171, 675, 1687, 172, 21, 21, 169, 
	1692, 1693, 1692, 699, 1694, 699, 699, 701, 
	172, 699, 21, 21, 699, 699, 699, 699, 
	699, 169, 1695, 26, 21, 1696, 1697, 1696, 
	699, 1694, 699, 699, 701, 172, 699, 21, 
	21, 699, 699, 699, 699, 699, 169, 1698, 
	26, 21, 1699, 170, 1699, 1700, 172, 21, 
	21, 169, 1701, 1702, 1701, 232, 1703, 233, 
	21, 21, 230, 1704, 26, 21, 689, 690, 
	689, 691, 171, 691, 691, 692, 693, 1705, 
	172, 1705, 691, 21, 21, 691, 691, 691, 
	691, 169, 689, 690, 689, 691, 171, 691, 
	691, 692, 693, 1706, 172, 1706, 691, 21, 
	21, 691, 691, 691, 691, 169, 689, 690, 
	689, 691, 171, 691, 691, 692, 693, 1707, 
	172, 1707, 691, 21, 21, 691, 691, 691, 
	691, 169, 689, 690, 689, 691, 171, 691, 
	691, 692, 693, 1708, 172, 1708, 691, 21, 
	21, 691, 691, 691, 691, 169, 1709, 1710, 
	1709, 691, 171, 691, 691, 692, 1711, 172, 
	691, 21, 21, 691, 691, 691, 691, 169, 
	1712, 1713, 1712, 171, 675, 1711, 172, 21, 
	21, 169, 1714, 26, 21, 1715, 170, 1715, 
	171, 675, 1711, 172, 21, 21, 169, 1711, 
	1716, 1711, 699, 700, 699, 699, 1717, 1718, 
	701, 172, 1717, 1718, 699, 21, 21, 699, 
	699, 699, 699, 699, 169, 1719, 26, 21, 
	1720, 704, 1720, 699, 700, 699, 699, 1717, 
	1718, 701, 172, 1717, 1718, 699, 21, 21, 
	699, 699, 699, 699, 699, 169, 710, 711, 
	710, 699, 171, 699, 699, 692, 1721, 172, 
	1721, 699, 21, 21, 699, 699, 699, 699, 
	169, 710, 711, 710, 699, 171, 699, 699, 
	692, 1722, 172, 1722, 699, 21, 21, 699, 
	699, 699, 699, 169, 710, 711, 710, 699, 
	171, 699, 699, 692, 1723, 172, 1723, 699, 
	21, 21, 699, 699, 699, 699, 169, 710, 
	711, 710, 699, 171, 699, 699, 692, 1724, 
	172, 1724, 699, 21, 21, 699, 699, 699, 
	699, 169, 1725, 1726, 1725, 171, 1727, 172, 
	21, 21, 169, 710, 711, 710, 699, 171, 
	699, 699, 692, 1728, 172, 1728, 699, 21, 
	21, 699, 699, 699, 699, 169, 710, 711, 
	710, 699, 171, 699, 699, 692, 1723, 172, 
	1723, 699, 21, 21, 699, 699, 699, 699, 
	169, 1729, 26, 21, 1730, 26, 21, 516, 
	517, 516, 518, 108, 518, 518, 519, 520, 
	1731, 109, 1731, 518, 21, 21, 518, 518, 
	518, 518, 106, 516, 517, 516, 518, 108, 
	518, 518, 519, 520, 1732, 109, 1732, 518, 
	21, 21, 518, 518, 518, 518, 106, 1733, 
	1734, 1733, 518, 108, 518, 518, 519, 1735, 
	109, 518, 21, 21, 518, 518, 518, 518, 
	106, 1736, 1737, 1736, 108, 499, 1735, 109, 
	21, 21, 106, 1738, 26, 21, 1739, 107, 
	1739, 108, 499, 1735, 109, 21, 21, 106, 
	1735, 1740, 1735, 526, 1741, 526, 526, 528, 
	109, 526, 21, 21, 526, 526, 526, 526, 
	526, 106, 1742, 26, 21, 1743, 1744, 1743, 
	526, 1741, 526, 526, 528, 109, 526, 21, 
	21, 526, 526, 526, 526, 526, 106, 1745, 
	26, 21, 1746, 107, 1746, 1741, 109, 21, 
	21, 106, 1747, 1748, 1747, 197, 1749, 198, 
	195, 195, 194, 1750, 26, 21, 516, 517, 
	516, 518, 108, 518, 518, 519, 520, 1751, 
	109, 1751, 518, 21, 21, 518, 518, 518, 
	518, 106, 516, 517, 516, 518, 108, 518, 
	518, 519, 520, 1752, 109, 1752, 518, 21, 
	21, 518, 518, 518, 518, 106, 516, 517, 
	516, 518, 108, 518, 518, 519, 520, 1753, 
	109, 1753, 518, 21, 21, 518, 518, 518, 
	518, 106, 516, 517, 516, 518, 108, 518, 
	518, 519, 520, 1754, 109, 1754, 518, 21, 
	21, 518, 518, 518, 518, 106, 1755, 1756, 
	1755, 518, 108, 518, 518, 519, 1757, 109, 
	518, 21, 21, 518, 518, 518, 518, 106, 
	1758, 1759, 1758, 108, 499, 1757, 109, 21, 
	21, 106, 1760, 26, 21, 1761, 107, 1761, 
	108, 499, 1757, 109, 21, 21, 106, 1762, 
	1763, 1762, 526, 1764, 526, 526, 528, 109, 
	526, 21, 21, 526, 526, 526, 526, 526, 
	106, 1765, 26, 21, 1766, 1767, 1766, 526, 
	1764, 526, 526, 528, 109, 526, 21, 21, 
	526, 526, 526, 526, 526, 106, 1768, 26, 
	21, 1769, 107, 1769, 1770, 109, 21, 21, 
	106, 1771, 1772, 1771, 232, 1773, 233, 21, 
	21, 230, 1774, 26, 21, 516, 517, 516, 
	518, 108, 518, 518, 519, 520, 1775, 109, 
	1775, 518, 21, 21, 518, 518, 518, 518, 
	106, 516, 517, 516, 518, 108, 518, 518, 
	519, 520, 1776, 109, 1776, 518, 21, 21, 
	518, 518, 518, 518, 106, 516, 517, 516, 
	518, 108, 518, 518, 519, 520, 1777, 109, 
	1777, 518, 21, 21, 518, 518, 518, 518, 
	106, 516, 517, 516, 518, 108, 518, 518, 
	519, 520, 1778, 109, 1778, 518, 21, 21, 
	518, 518, 518, 518, 106, 1779, 1780, 1779, 
	518, 108, 518, 518, 519, 1781, 109, 518, 
	21, 21, 518, 518, 518, 518, 106, 1782, 
	1783, 1782, 108, 499, 1781, 109, 21, 21, 
	106, 1784, 26, 21, 1785, 107, 1785, 108, 
	499, 1781, 109, 21, 21, 106, 1781, 1786, 
	1781, 526, 527, 526, 526, 1787, 1788, 528, 
	109, 1787, 1788, 526, 21, 21, 526, 526, 
	526, 526, 526, 106, 1789, 26, 21, 1790, 
	531, 1790, 526, 527, 526, 526, 1787, 1788, 
	528, 109, 1787, 1788, 526, 21, 21, 526, 
	526, 526, 526, 526, 106, 537, 538, 537, 
	526, 108, 526, 526, 519, 1791, 109, 1791, 
	526, 21, 21, 526, 526, 526, 526, 106, 
	537, 538, 537, 526, 108, 526, 526, 519, 
	1792, 109, 1792, 526, 21, 21, 526, 526, 
	526, 526, 106, 537, 538, 537, 526, 108, 
	526, 526, 519, 1793, 109, 1793, 526, 21, 
	21, 526, 526, 526, 526, 106, 537, 538, 
	537, 526, 108, 526, 526, 519, 1794, 109, 
	1794, 526, 21, 21, 526, 526, 526, 526, 
	106, 1795, 1796, 1795, 108, 1797, 109, 21, 
	21, 106, 537, 538, 537, 526, 108, 526, 
	526, 519, 1798, 109, 1798, 526, 21, 21, 
	526, 526, 526, 526, 106, 537, 538, 537, 
	526, 108, 526, 526, 519, 1793, 109, 1793, 
	526, 21, 21, 526, 526, 526, 526, 106, 
	1799, 26, 21, 1800, 398, 396, 394, 438, 
	439, 438, 440, 396, 440, 440, 441, 442, 
	1801, 1801, 440, 440, 440, 440, 440, 394, 
	438, 439, 438, 440, 396, 440, 440, 441, 
	442, 1802, 1802, 440, 440, 440, 440, 440, 
	394, 438, 439, 438, 440, 396, 440, 440, 
	441, 442, 1803, 1803, 440, 440, 440, 440, 
	440, 394, 438, 439, 438, 440, 396, 440, 
	440, 441, 442, 1804, 1804, 440, 440, 440, 
	440, 440, 394, 1805, 1806, 1805, 440, 396, 
	440, 440, 441, 1807, 440, 440, 440, 440, 
	440, 394, 1808, 1809, 1808, 396, 445, 1807, 
	394, 1810, 398, 396, 394, 1811, 398, 1811, 
	396, 445, 1807, 394, 1807, 1812, 1807, 463, 
	396, 463, 463, 464, 463, 463, 463, 463, 
	463, 463, 394, 1813, 398, 396, 394, 1814, 
	398, 1814, 463, 396, 463, 463, 464, 463, 
	463, 463, 463, 463, 463, 394, 1815, 398, 
	396, 394, 438, 439, 438, 440, 396, 440, 
	440, 441, 442, 1816, 1816, 440, 440, 440, 
	440, 440, 394, 438, 439, 438, 440, 396, 
	440, 440, 441, 442, 1817, 1817, 440, 440, 
	440, 440, 440, 394, 438, 439, 438, 440, 
	396, 440, 440, 441, 442, 1818, 1818, 440, 
	440, 440, 440, 440, 394, 438, 439, 438, 
	440, 396, 440, 440, 441, 442, 1819, 1819, 
	440, 440, 440, 440, 440, 394, 438, 439, 
	438, 440, 396, 440, 440, 441, 442, 1820, 
	1820, 440, 440, 440, 440, 440, 394, 438, 
	439, 438, 440, 396, 440, 440, 441, 442, 
	1821, 1821, 440, 440, 440, 440, 440, 394, 
	438, 439, 438, 440, 396, 440, 440, 441, 
	442, 1822, 1822, 440, 440, 440, 440, 440, 
	394, 1823, 1824, 1823, 440, 396, 440, 440, 
	441, 1825, 440, 440, 440, 440, 440, 394, 
	1826, 1827, 1826, 396, 445, 1825, 394, 1828, 
	398, 396, 394, 1829, 398, 1829, 396, 445, 
	1825, 394, 1825, 1830, 1825, 1831, 401, 1831, 
	1831, 464, 1831, 1831, 1831, 1831, 1831, 1831, 
	394, 1832, 398, 396, 394, 1833, 467, 1833, 
	1831, 401, 1831, 1831, 464, 1831, 1831, 1831, 
	1831, 1831, 1831, 394, 1834, 1835, 1834, 1836, 
	396, 1836, 1836, 1837, 1836, 1836, 1836, 1836, 
	1836, 394, 1838, 398, 396, 394, 395, 396, 
	1840, 397, 394, 394, 394, 1839, 1839, 1839, 
	393, 395, 396, 1842, 397, 1843, 394, 394, 
	394, 1841, 1841, 1841, 393, 395, 396, 1842, 
	397, 1843, 394, 394, 394, 1844, 1844, 1844, 
	393, 395, 396, 1842, 397, 1843, 394, 394, 
	394, 1845, 1845, 1845, 393, 395, 396, 1842, 
	397, 1843, 394, 394, 394, 393, 395, 396, 
	1847, 397, 394, 394, 394, 1846, 1839, 1839, 
	393, 395, 396, 1848, 1842, 397, 1843, 394, 
	394, 394, 1849, 1841, 1841, 393, 395, 396, 
	397, 394, 394, 394, 1850, 393, 395, 396, 
	1851, 397, 394, 394, 394, 1852, 393, 395, 
	396, 397, 394, 394, 394, 1853, 393, 395, 
	396, 1854, 397, 394, 394, 394, 1855, 393, 
	395, 396, 397, 394, 394, 394, 1856, 393, 
	395, 396, 397, 1843, 394, 394, 394, 1857, 
	393, 395, 396, 397, 1843, 394, 394, 394, 
	1858, 393, 395, 396, 397, 1843, 394, 394, 
	394, 393, 435, 436, 435, 396, 421, 397, 
	394, 394, 393, 395, 396, 1854, 397, 394, 
	394, 394, 1859, 393, 395, 396, 1854, 397, 
	394, 394, 394, 393, 395, 396, 1851, 397, 
	394, 394, 394, 1860, 393, 395, 396, 1851, 
	397, 394, 394, 394, 393, 395, 396, 1848, 
	1842, 397, 1843, 394, 394, 394, 1861, 1844, 
	1844, 393, 395, 396, 1848, 1842, 397, 1843, 
	394, 394, 394, 1845, 1845, 1845, 393, 395, 
	396, 1863, 397, 1843, 394, 394, 394, 1862, 
	1862, 1862, 393, 395, 396, 1865, 397, 1843, 
	394, 394, 394, 1864, 1864, 1864, 393, 395, 
	396, 1865, 397, 1843, 394, 394, 394, 1866, 
	1866, 1866, 393, 395, 396, 1865, 397, 1843, 
	394, 394, 394, 1867, 1867, 1867, 393, 395, 
	396, 1865, 397, 1843, 394, 394, 394, 393, 
	395, 396, 397, 394, 394, 394, 1868, 1862, 
	1862, 393, 395, 396, 1848, 1865, 397, 1843, 
	394, 394, 394, 1869, 1864, 1864, 393, 395, 
	396, 1848, 1865, 397, 1843, 394, 394, 394, 
	1870, 1866, 1866, 393, 395, 396, 1848, 1865, 
	397, 1843, 394, 394, 394, 1867, 1867, 1867, 
	393, 395, 396, 397, 394, 394, 394, 1871, 
	393, 395, 396, 1848, 397, 394, 394, 394, 
	1872, 393, 395, 396, 1848, 397, 394, 394, 
	394, 1873, 393, 395, 396, 1848, 397, 394, 
	394, 394, 393, 395, 396, 1847, 397, 394, 
	394, 394, 393, 1874, 398, 396, 394, 418, 
	419, 418, 420, 396, 420, 420, 421, 422, 
	1875, 397, 1875, 420, 394, 394, 420, 420, 
	420, 420, 393, 418, 419, 418, 420, 396, 
	420, 420, 421, 422, 1876, 397, 1876, 420, 
	394, 394, 420, 420, 420, 420, 393, 418, 
	419, 418, 420, 396, 420, 420, 421, 422, 
	1877, 397, 1877, 420, 394, 394, 420, 420, 
	420, 420, 393, 418, 419, 418, 420, 396, 
	420, 420, 421, 422, 1878, 397, 1878, 420, 
	394, 394, 420, 420, 420, 420, 393, 418, 
	419, 418, 420, 396, 420, 420, 421, 422, 
	1879, 397, 1879, 420, 394, 394, 420, 420, 
	420, 420, 393, 418, 419, 418, 420, 396, 
	420, 420, 421, 422, 1880, 397, 1880, 420, 
	394, 394, 420, 420, 420, 420, 393, 418, 
	419, 418, 420, 396, 420, 420, 421, 422, 
	1881, 397, 1881, 420, 394, 394, 420, 420, 
	420, 420, 393, 418, 419, 418, 420, 396, 
	420, 420, 421, 422, 1882, 397, 1882, 420, 
	394, 394, 420, 420, 420, 420, 393, 1883, 
	1884, 1883, 420, 396, 420, 420, 421, 1885, 
	397, 420, 394, 394, 420, 420, 420, 420, 
	393, 1886, 1887, 1886, 396, 404, 1885, 397, 
	394, 394, 393, 1888, 398, 396, 394, 1889, 
	395, 1889, 396, 404, 1885, 397, 394, 394, 
	393, 1885, 1890, 1885, 1891, 401, 1891, 1891, 
	429, 397, 1891, 394, 394, 1891, 1891, 1891, 
	1891, 1891, 393, 1892, 398, 396, 394, 1893, 
	432, 1893, 1891, 401, 1891, 1891, 429, 397, 
	1891, 394, 394, 1891, 1891, 1891, 1891, 1891, 
	393, 1894, 1895, 1894, 1896, 396, 1896, 1896, 
	1897, 397, 1896, 394, 394, 1896, 1896, 1896, 
	1896, 393, 1898, 398, 396, 394, 418, 419, 
	418, 420, 396, 420, 420, 421, 422, 1899, 
	397, 1899, 420, 394, 394, 420, 420, 420, 
	420, 393, 418, 419, 418, 420, 396, 420, 
	420, 421, 422, 1900, 397, 1900, 420, 394, 
	394, 420, 420, 420, 420, 393, 418, 419, 
	418, 420, 396, 420, 420, 421, 422, 1901, 
	397, 1901, 420, 394, 394, 420, 420, 420, 
	420, 393, 418, 419, 418, 420, 396, 420, 
	420, 421, 422, 1902, 397, 1902, 420, 394, 
	394, 420, 420, 420, 420, 393, 418, 419, 
	418, 420, 396, 420, 420, 421, 422, 1903, 
	397, 1903, 420, 394, 394, 420, 420, 420, 
	420, 393, 1904, 1905, 1904, 420, 396, 420, 
	420, 421, 1906, 397, 420, 394, 394, 420, 
	420, 420, 420, 393, 1907, 1908, 1907, 396, 
	404, 1906, 397, 394, 394, 393, 1909, 398, 
	396, 394, 1910, 395, 1910, 396, 404, 1906, 
	397, 394, 394, 393, 1906, 1911, 1906, 428, 
	396, 428, 428, 429, 397, 428, 394, 394, 
	428, 428, 428, 428, 428, 393, 1912, 398, 
	396, 394, 1913, 395, 1913, 428, 396, 428, 
	428, 429, 397, 428, 394, 394, 428, 428, 
	428, 428, 428, 393, 1914, 398, 396, 394, 
	418, 419, 418, 420, 396, 420, 420, 421, 
	422, 1915, 397, 1915, 420, 394, 394, 420, 
	420, 420, 420, 393, 418, 419, 418, 420, 
	396, 420, 420, 421, 422, 1916, 397, 1916, 
	420, 394, 394, 420, 420, 420, 420, 393, 
	418, 419, 418, 420, 396, 420, 420, 421, 
	422, 1917, 397, 1917, 420, 394, 394, 420, 
	420, 420, 420, 393, 418, 419, 418, 420, 
	396, 420, 420, 421, 422, 1918, 397, 1918, 
	420, 394, 394, 420, 420, 420, 420, 393, 
	1919, 1920, 1919, 420, 396, 420, 420, 421, 
	1921, 397, 420, 394, 394, 420, 420, 420, 
	420, 393, 1922, 1923, 1922, 396, 404, 1921, 
	397, 394, 394, 393, 1924, 398, 396, 394, 
	1925, 395, 1925, 396, 404, 1921, 397, 394, 
	394, 393, 1926, 1927, 1926, 428, 490, 428, 
	428, 429, 397, 428, 394, 394, 428, 428, 
	428, 428, 428, 393, 1928, 398, 396, 394, 
	1929, 1930, 1929, 428, 490, 428, 428, 429, 
	397, 428, 394, 394, 428, 428, 428, 428, 
	428, 393, 1931, 398, 396, 394, 1932, 395, 
	1932, 496, 397, 394, 394, 393, 1933, 398, 
	396, 394, 418, 419, 418, 420, 396, 420, 
	420, 421, 422, 1934, 397, 1934, 420, 394, 
	394, 420, 420, 420, 420, 393, 418, 419, 
	418, 420, 396, 420, 420, 421, 422, 1935, 
	397, 1935, 420, 394, 394, 420, 420, 420, 
	420, 393, 418, 419, 418, 420, 396, 420, 
	420, 421, 422, 1936, 397, 1936, 420, 394, 
	394, 420, 420, 420, 420, 393, 418, 419, 
	418, 420, 396, 420, 420, 421, 422, 1937, 
	397, 1937, 420, 394, 394, 420, 420, 420, 
	420, 393, 418, 419, 418, 420, 396, 420, 
	420, 421, 422, 1938, 397, 1938, 420, 394, 
	394, 420, 420, 420, 420, 393, 1939, 1940, 
	1939, 420, 396, 420, 420, 421, 1941, 397, 
	420, 394, 394, 420, 420, 420, 420, 393, 
	1942, 1943, 1942, 396, 404, 1941, 397, 394, 
	394, 393, 1944, 398, 396, 394, 1945, 395, 
	1945, 396, 404, 1941, 397, 394, 394, 393, 
	1946, 1947, 1946, 428, 1367, 428, 428, 429, 
	397, 428, 394, 394, 428, 428, 428, 428, 
	428, 393, 1948, 398, 396, 394, 1949, 1950, 
	1949, 428, 1367, 428, 428, 429, 397, 428, 
	394, 394, 428, 428, 428, 428, 428, 393, 
	1951, 398, 396, 394, 1952, 395, 1952, 1373, 
	397, 394, 394, 393, 1953, 398, 396, 394, 
	418, 419, 418, 420, 396, 420, 420, 421, 
	422, 1954, 397, 1954, 420, 394, 394, 420, 
	420, 420, 420, 393, 418, 419, 418, 420, 
	396, 420, 420, 421, 422, 1955, 397, 1955, 
	420, 394, 394, 420, 420, 420, 420, 393, 
	1956, 1957, 1956, 420, 396, 420, 420, 421, 
	1958, 397, 420, 394, 394, 420, 420, 420, 
	420, 393, 1959, 1960, 1959, 396, 404, 1958, 
	397, 394, 394, 393, 1961, 398, 396, 394, 
	1962, 395, 1962, 396, 404, 1958, 397, 394, 
	394, 393, 1958, 1963, 1958, 428, 1420, 428, 
	428, 429, 397, 428, 394, 394, 428, 428, 
	428, 428, 428, 393, 1964, 398, 396, 394, 
	1965, 1966, 1965, 428, 1420, 428, 428, 429, 
	397, 428, 394, 394, 428, 428, 428, 428, 
	428, 393, 1967, 398, 396, 394, 1968, 395, 
	1968, 1420, 397, 394, 394, 393, 1969, 398, 
	396, 394, 418, 419, 418, 420, 396, 420, 
	420, 421, 422, 1970, 397, 1970, 420, 394, 
	394, 420, 420, 420, 420, 393, 418, 419, 
	418, 420, 396, 420, 420, 421, 422, 1971, 
	397, 1971, 420, 394, 394, 420, 420, 420, 
	420, 393, 418, 419, 418, 420, 396, 420, 
	420, 421, 422, 1972, 397, 1972, 420, 394, 
	394, 420, 420, 420, 420, 393, 418, 419, 
	418, 420, 396, 420, 420, 421, 422, 1973, 
	397, 1973, 420, 394, 394, 420, 420, 420, 
	420, 393, 1974, 1975, 1974, 420, 396, 420, 
	420, 421, 1976, 397, 420, 394, 394, 420, 
	420, 420, 420, 393, 1977, 1978, 1977, 396, 
	404, 1976, 397, 394, 394, 393, 1979, 398, 
	396, 394, 1980, 395, 1980, 396, 404, 1976, 
	397, 394, 394, 393, 1981, 1982, 1981, 428, 
	1448, 428, 428, 429, 397, 428, 394, 394, 
	428, 428, 428, 428, 428, 393, 1983, 398, 
	396, 394, 1984, 1985, 1984, 428, 1448, 428, 
	428, 429, 397, 428, 394, 394, 428, 428, 
	428, 428, 428, 393, 1986, 398, 396, 394, 
	1987, 395, 1987, 1454, 397, 394, 394, 393, 
	1988, 398, 396, 394, 418, 419, 418, 420, 
	396, 420, 420, 421, 422, 1989, 397, 1989, 
	420, 394, 394, 420, 420, 420, 420, 393, 
	418, 419, 418, 420, 396, 420, 420, 421, 
	422, 1990, 397, 1990, 420, 394, 394, 420, 
	420, 420, 420, 393, 418, 419, 418, 420, 
	396, 420, 420, 421, 422, 1991, 397, 1991, 
	420, 394, 394, 420, 420, 420, 420, 393, 
	418, 419, 418, 420, 396, 420, 420, 421, 
	422, 1992, 397, 1992, 420, 394, 394, 420, 
	420, 420, 420, 393, 1993, 1994, 1993, 420, 
	396, 420, 420, 421, 1995, 397, 420, 394, 
	394, 420, 420, 420, 420, 393, 1996, 1997, 
	1996, 396, 404, 1995, 397, 394, 394, 393, 
	1998, 398, 396, 394, 1999, 395, 1999, 396, 
	404, 1995, 397, 394, 394, 393, 1995, 2000, 
	1995, 428, 401, 428, 428, 2001, 2002, 429, 
	397, 2001, 2002, 428, 394, 394, 428, 428, 
	428, 428, 428, 393, 2003, 398, 396, 394, 
	2004, 432, 2004, 428, 401, 428, 428, 2001, 
	2002, 429, 397, 2001, 2002, 428, 394, 394, 
	428, 428, 428, 428, 428, 393, 435, 436, 
	435, 428, 396, 428, 428, 421, 2005, 397, 
	2005, 428, 394, 394, 428, 428, 428, 428, 
	393, 435, 436, 435, 428, 396, 428, 428, 
	421, 2006, 397, 2006, 428, 394, 394, 428, 
	428, 428, 428, 393, 435, 436, 435, 428, 
	396, 428, 428, 421, 2007, 397, 2007, 428, 
	394, 394, 428, 428, 428, 428, 393, 435, 
	436, 435, 428, 396, 428, 428, 421, 2008, 
	397, 2008, 428, 394, 394, 428, 428, 428, 
	428, 393, 2009, 2010, 2009, 396, 2011, 397, 
	394, 394, 393, 435, 436, 435, 428, 396, 
	428, 428, 421, 2012, 397, 2012, 428, 394, 
	394, 428, 428, 428, 428, 393, 435, 436, 
	435, 428, 396, 428, 428, 421, 2007, 397, 
	2007, 428, 394, 394, 428, 428, 428, 428, 
	393, 2013, 398, 396, 394, 2014, 26, 21, 
	285, 286, 285, 287, 77, 287, 287, 288, 
	289, 2015, 78, 2015, 287, 21, 21, 287, 
	287, 287, 287, 69, 285, 286, 285, 287, 
	77, 287, 287, 288, 289, 2016, 78, 2016, 
	287, 21, 21, 287, 287, 287, 287, 69, 
	285, 286, 285, 287, 77, 287, 287, 288, 
	289, 2017, 78, 2017, 287, 21, 21, 287, 
	287, 287, 287, 69, 285, 286, 285, 287, 
	77, 287, 287, 288, 289, 2018, 78, 2018, 
	287, 21, 21, 287, 287, 287, 287, 69, 
	2019, 2020, 2019, 287, 77, 287, 287, 288, 
	2021, 78, 287, 21, 21, 287, 287, 287, 
	287, 69, 2022, 2023, 2022, 77, 268, 2021, 
	78, 21, 21, 69, 2024, 26, 21, 2025, 
	76, 2025, 77, 268, 2021, 78, 21, 21, 
	69, 2026, 2027, 2026, 295, 2028, 295, 295, 
	297, 78, 295, 21, 21, 295, 295, 295, 
	295, 295, 69, 2029, 26, 21, 2030, 2031, 
	2030, 295, 2028, 295, 295, 297, 78, 295, 
	21, 21, 295, 295, 295, 295, 295, 69, 
	2032, 26, 21, 2033, 76, 2033, 546, 78, 
	21, 21, 69, 2034, 26, 21, 285, 286, 
	285, 287, 77, 287, 287, 288, 289, 2035, 
	78, 2035, 287, 21, 21, 287, 287, 287, 
	287, 69, 285, 286, 285, 287, 77, 287, 
	287, 288, 289, 2036, 78, 2036, 287, 21, 
	21, 287, 287, 287, 287, 69, 285, 286, 
	285, 287, 77, 287, 287, 288, 289, 2037, 
	78, 2037, 287, 21, 21, 287, 287, 287, 
	287, 69, 285, 286, 285, 287, 77, 287, 
	287, 288, 289, 2038, 78, 2038, 287, 21, 
	21, 287, 287, 287, 287, 69, 285, 286, 
	285, 287, 77, 287, 287, 288, 289, 2039, 
	78, 2039, 287, 21, 21, 287, 287, 287, 
	287, 69, 2040, 2041, 2040, 287, 77, 287, 
	287, 288, 2042, 78, 287, 21, 21, 287, 
	287, 287, 287, 69, 2043, 2044, 2043, 77, 
	268, 2042, 78, 21, 21, 69, 2045, 26, 
	21, 2046, 76, 2046, 77, 268, 2042, 78, 
	21, 21, 69, 2047, 2048, 2047, 295, 2049, 
	295, 295, 297, 78, 295, 21, 21, 295, 
	295, 295, 295, 295, 69, 2050, 26, 21, 
	2051, 2052, 2051, 295, 2049, 295, 295, 297, 
	78, 295, 21, 21, 295, 295, 295, 295, 
	295, 69, 2053, 26, 21, 2054, 76, 2054, 
	717, 78, 21, 21, 69, 2055, 26, 21, 
	285, 286, 285, 287, 77, 287, 287, 288, 
	289, 2056, 78, 2056, 287, 21, 21, 287, 
	287, 287, 287, 69, 285, 286, 285, 287, 
	77, 287, 287, 288, 289, 2057, 78, 2057, 
	287, 21, 21, 287, 287, 287, 287, 69, 
	2058, 2059, 2058, 287, 77, 287, 287, 288, 
	2060, 78, 287, 21, 21, 287, 287, 287, 
	287, 69, 2061, 2062, 2061, 77, 268, 2060, 
	78, 21, 21, 69, 2063, 26, 21, 2064, 
	76, 2064, 77, 268, 2060, 78, 21, 21, 
	69, 2060, 2065, 2060, 295, 2066, 295, 295, 
	297, 78, 295, 21, 21, 295, 295, 295, 
	295, 295, 69, 2067, 26, 21, 2068, 2069, 
	2068, 295, 2066, 295, 295, 297, 78, 295, 
	21, 21, 295, 295, 295, 295, 295, 69, 
	2070, 26, 21, 2071, 76, 2071, 2066, 78, 
	21, 21, 69, 2072, 2073, 2072, 197, 2074, 
	198, 195, 195, 194, 2075, 26, 21, 285, 
	286, 285, 287, 77, 287, 287, 288, 289, 
	2076, 78, 2076, 287, 21, 21, 287, 287, 
	287, 287, 69, 285, 286, 285, 287, 77, 
	287, 287, 288, 289, 2077, 78, 2077, 287, 
	21, 21, 287, 287, 287, 287, 69, 285, 
	286, 285, 287, 77, 287, 287, 288, 289, 
	2078, 78, 2078, 287, 21, 21, 287, 287, 
	287, 287, 69, 285, 286, 285, 287, 77, 
	287, 287, 288, 289, 2079, 78, 2079, 287, 
	21, 21, 287, 287, 287, 287, 69, 2080, 
	2081, 2080, 287, 77, 287, 287, 288, 2082, 
	78, 287, 21, 21, 287, 287, 287, 287, 
	69, 2083, 2084, 2083, 77, 268, 2082, 78, 
	21, 21, 69, 2085, 26, 21, 2086, 76, 
	2086, 77, 268, 2082, 78, 21, 21, 69, 
	2087, 2088, 2087, 295, 2089, 295, 295, 297, 
	78, 295, 21, 21, 295, 295, 295, 295, 
	295, 69, 2090, 26, 21, 2091, 2092, 2091, 
	295, 2089, 295, 295, 297, 78, 295, 21, 
	21, 295, 295, 295, 295, 295, 69, 2093, 
	26, 21, 2094, 76, 2094, 1104, 78, 21, 
	21, 69, 2095, 26, 21, 285, 286, 285, 
	287, 77, 287, 287, 288, 289, 2096, 78, 
	2096, 287, 21, 21, 287, 287, 287, 287, 
	69, 285, 286, 285, 287, 77, 287, 287, 
	288, 289, 2097, 78, 2097, 287, 21, 21, 
	287, 287, 287, 287, 69, 285, 286, 285, 
	287, 77, 287, 287, 288, 289, 2098, 78, 
	2098, 287, 21, 21, 287, 287, 287, 287, 
	69, 285, 286, 285, 287, 77, 287, 287, 
	288, 289, 2099, 78, 2099, 287, 21, 21, 
	287, 287, 287, 287, 69, 2100, 2101, 2100, 
	287, 77, 287, 287, 288, 2102, 78, 287, 
	21, 21, 287, 287, 287, 287, 69, 2103, 
	2104, 2103, 77, 268, 2102, 78, 21, 21, 
	69, 2105, 26, 21, 2106, 76, 2106, 77, 
	268, 2102, 78, 21, 21, 69, 2102, 2107, 
	2102, 295, 296, 295, 295, 2108, 2109, 297, 
	78, 2108, 2109, 295, 21, 21, 295, 295, 
	295, 295, 295, 69, 2110, 26, 21, 2111, 
	300, 2111, 295, 296, 295, 295, 2108, 2109, 
	297, 78, 2108, 2109, 295, 21, 21, 295, 
	295, 295, 295, 295, 69, 303, 304, 303, 
	295, 77, 295, 295, 288, 2112, 78, 2112, 
	295, 21, 21, 295, 295, 295, 295, 69, 
	303, 304, 303, 295, 77, 295, 295, 288, 
	2113, 78, 2113, 295, 21, 21, 295, 295, 
	295, 295, 69, 303, 304, 303, 295, 77, 
	295, 295, 288, 2114, 78, 2114, 295, 21, 
	21, 295, 295, 295, 295, 69, 303, 304, 
	303, 295, 77, 295, 295, 288, 2115, 78, 
	2115, 295, 21, 21, 295, 295, 295, 295, 
	69, 2116, 2117, 2116, 77, 2118, 78, 21, 
	21, 69, 303, 304, 303, 295, 77, 295, 
	295, 288, 2119, 78, 2119, 295, 21, 21, 
	295, 295, 295, 295, 69, 303, 304, 303, 
	295, 77, 295, 295, 288, 2114, 78, 2114, 
	295, 21, 21, 295, 295, 295, 295, 69, 
	2120, 26, 21, 2121, 26, 21, 49, 50, 
	49, 51, 51, 51, 52, 53, 2122, 2122, 
	51, 51, 51, 51, 51, 21, 49, 50, 
	49, 51, 51, 51, 52, 53, 2123, 2123, 
	51, 51, 51, 51, 51, 21, 49, 50, 
	49, 51, 51, 51, 52, 53, 2124, 2124, 
	51, 51, 51, 51, 51, 21, 49, 50, 
	49, 51, 51, 51, 52, 53, 2125, 2125, 
	51, 51, 51, 51, 51, 21, 2126, 2127, 
	2126, 51, 51, 51, 52, 2128, 51, 51, 
	51, 51, 51, 21, 2129, 2130, 2129, 56, 
	2128, 21, 2131, 26, 21, 2132, 26, 2132, 
	56, 2128, 21, 2128, 2133, 2128, 68, 2134, 
	68, 68, 70, 68, 68, 68, 68, 68, 
	68, 21, 2135, 26, 21, 2136, 2137, 2136, 
	68, 2134, 68, 68, 70, 68, 68, 68, 
	68, 68, 68, 21, 2138, 26, 21, 2139, 
	26, 2139, 2134, 21, 2140, 390, 392, 387, 
	387, 387, 386, 2141, 26, 21, 49, 50, 
	49, 51, 51, 51, 52, 53, 2142, 2142, 
	51, 51, 51, 51, 51, 21, 49, 50, 
	49, 51, 51, 51, 52, 53, 2143, 2143, 
	51, 51, 51, 51, 51, 21, 49, 50, 
	49, 51, 51, 51, 52, 53, 2144, 2144, 
	51, 51, 51, 51, 51, 21, 49, 50, 
	49, 51, 51, 51, 52, 53, 2145, 2145, 
	51, 51, 51, 51, 51, 21, 49, 50, 
	49, 51, 51, 51, 52, 53, 2146, 2146, 
	51, 51, 51, 51, 51, 21, 49, 50, 
	49, 51, 51, 51, 52, 53, 2147, 2147, 
	51, 51, 51, 51, 51, 21, 49, 50, 
	49, 51, 51, 51, 52, 53, 2148, 2148, 
	51, 51, 51, 51, 51, 21, 2149, 2150, 
	2149, 51, 51, 51, 52, 2151, 51, 51, 
	51, 51, 51, 21, 2152, 2153, 2152, 56, 
	2151, 21, 2154, 26, 21, 2155, 26, 2155, 
	56, 2151, 21, 2151, 2156, 2151, 2157, 69, 
	2157, 2157, 70, 2157, 2157, 2157, 2157, 2157, 
	2157, 21, 2158, 26, 21, 2159, 73, 2159, 
	2157, 69, 2157, 2157, 70, 2157, 2157, 2157, 
	2157, 2157, 2157, 21, 2160, 2161, 2160, 2162, 
	2162, 2162, 2163, 2162, 2162, 2162, 2162, 2162, 
	21, 2164, 26, 21, 49, 50, 49, 51, 
	51, 51, 52, 53, 2165, 2165, 51, 51, 
	51, 51, 51, 21, 49, 50, 49, 51, 
	51, 51, 52, 53, 2166, 2166, 51, 51, 
	51, 51, 51, 21, 49, 50, 49, 51, 
	51, 51, 52, 53, 2167, 2167, 51, 51, 
	51, 51, 51, 21, 49, 50, 49, 51, 
	51, 51, 52, 53, 2168, 2168, 51, 51, 
	51, 51, 51, 21, 49, 50, 49, 51, 
	51, 51, 52, 53, 2169, 2169, 51, 51, 
	51, 51, 51, 21, 2170, 2171, 2170, 51, 
	51, 51, 52, 2172, 51, 51, 51, 51, 
	51, 21, 2173, 2174, 2173, 56, 2172, 21, 
	2175, 26, 21, 2176, 26, 2176, 56, 2172, 
	21, 2172, 2177, 2172, 68, 2178, 68, 68, 
	70, 68, 68, 68, 68, 68, 68, 21, 
	2179, 26, 21, 2180, 2181, 2180, 68, 2178, 
	68, 68, 70, 68, 68, 68, 68, 68, 
	68, 21, 2182, 26, 21, 2183, 26, 2183, 
	2178, 21, 2185, 390, 2186, 387, 387, 387, 
	2184, 2188, 396, 2189, 394, 394, 394, 2187, 
	2190, 398, 396, 394, 398, 2191, 2187, 2187, 
	394, 2192, 2193, 2192, 77, 2194, 78, 21, 
	21, 69, 2195, 26, 21, 2196, 2197, 2196, 
	77, 2194, 78, 21, 21, 69, 2198, 26, 
	21, 2199, 76, 2199, 77, 2194, 78, 21, 
	21, 69, 2194, 2200, 2194, 2201, 77, 2201, 
	2201, 2202, 2203, 2204, 2205, 2206, 2207, 2208, 
	78, 2202, 2203, 2204, 2205, 2206, 2207, 2208, 
	2201, 21, 21, 2201, 2201, 2201, 2201, 2201, 
	69, 2209, 26, 21, 2210, 76, 2210, 2201, 
	77, 2201, 2201, 2202, 2203, 2204, 2205, 2206, 
	2207, 2208, 78, 2202, 2203, 2204, 2205, 2206, 
	2207, 2208, 2201, 21, 21, 2201, 2201, 2201, 
	2201, 2201, 69, 2211, 2212, 2211, 2213, 77, 
	2213, 2213, 2214, 2215, 78, 2213, 21, 21, 
	2213, 2213, 2213, 2213, 69, 2216, 2217, 2216, 
	77, 2194, 2215, 78, 21, 21, 69, 2218, 
	26, 21, 2219, 76, 2219, 77, 2194, 2215, 
	78, 21, 21, 69, 2215, 2220, 2215, 2221, 
	296, 2221, 2221, 2222, 78, 2221, 21, 21, 
	2221, 2221, 2221, 2221, 2221, 69, 2223, 26, 
	21, 2224, 300, 2224, 2221, 296, 2221, 2221, 
	2222, 78, 2221, 21, 21, 2221, 2221, 2221, 
	2221, 2221, 69, 2225, 2226, 2225, 2221, 77, 
	2221, 2221, 2214, 78, 2221, 21, 21, 2221, 
	2221, 2221, 2221, 69, 2227, 2228, 2227, 77, 
	2194, 78, 21, 21, 69, 2229, 26, 21, 
	76, 77, 2231, 78, 21, 21, 21, 2230, 
	2230, 2230, 69, 76, 77, 2233, 78, 2234, 
	21, 21, 21, 2232, 2232, 2232, 69, 76, 
	77, 2233, 78, 2234, 21, 21, 21, 2235, 
	2235, 2235, 69, 76, 77, 2233, 78, 2234, 
	21, 21, 21, 2236, 2236, 2236, 69, 76, 
	77, 2233, 78, 2234, 21, 21, 21, 69, 
	76, 77, 2238, 78, 21, 21, 21, 2237, 
	2230, 2230, 69, 76, 77, 2239, 2233, 78, 
	2234, 21, 21, 21, 2240, 2232, 2232, 69, 
	76, 77, 78, 21, 21, 21, 2241, 69, 
	76, 77, 2242, 78, 21, 21, 21, 2243, 
	69, 76, 77, 78, 21, 21, 21, 2244, 
	69, 76, 77, 2245, 78, 21, 21, 21, 
	2246, 69, 76, 77, 78, 21, 21, 21, 
	2247, 69, 76, 77, 78, 2234, 21, 21, 
	21, 2248, 69, 76, 77, 78, 2234, 21, 
	21, 21, 2249, 69, 76, 77, 78, 2234, 
	21, 21, 21, 69, 2225, 2226, 2225, 77, 
	2214, 78, 21, 21, 69, 76, 77, 2245, 
	78, 21, 21, 21, 2250, 69, 76, 77, 
	2245, 78, 21, 21, 21, 69, 76, 77, 
	2242, 78, 21, 21, 21, 2251, 69, 76, 
	77, 2242, 78, 21, 21, 21, 69, 76, 
	77, 2239, 2233, 78, 2234, 21, 21, 21, 
	2252, 2235, 2235, 69, 76, 77, 2239, 2233, 
	78, 2234, 21, 21, 21, 2236, 2236, 2236, 
	69, 76, 77, 2254, 78, 2234, 21, 21, 
	21, 2253, 2253, 2253, 69, 76, 77, 2256, 
	78, 2234, 21, 21, 21, 2255, 2255, 2255, 
	69, 76, 77, 2256, 78, 2234, 21, 21, 
	21, 2257, 2257, 2257, 69, 76, 77, 2256, 
	78, 2234, 21, 21, 21, 2258, 2258, 2258, 
	69, 76, 77, 2256, 78, 2234, 21, 21, 
	21, 69, 76, 77, 78, 21, 21, 21, 
	2259, 2253, 2253, 69, 76, 77, 2239, 2256, 
	78, 2234, 21, 21, 21, 2260, 2255, 2255, 
	69, 76, 77, 2239, 2256, 78, 2234, 21, 
	21, 21, 2261, 2257, 2257, 69, 76, 77, 
	2239, 2256, 78, 2234, 21, 21, 21, 2258, 
	2258, 2258, 69, 76, 77, 78, 21, 21, 
	21, 2262, 69, 76, 77, 2239, 78, 21, 
	21, 21, 2263, 69, 76, 77, 2239, 78, 
	21, 21, 21, 2264, 69, 76, 77, 2239, 
	78, 21, 21, 21, 69, 76, 77, 2238, 
	78, 21, 21, 21, 69, 2265, 26, 21, 
	2211, 2212, 2211, 2213, 77, 2213, 2213, 2214, 
	2215, 2266, 78, 2266, 2213, 21, 21, 2213, 
	2213, 2213, 2213, 69, 2211, 2212, 2211, 2213, 
	77, 2213, 2213, 2214, 2215, 2267, 78, 2267, 
	2213, 21, 21, 2213, 2213, 2213, 2213, 69, 
	2211, 2212, 2211, 2213, 77, 2213, 2213, 2214, 
	2215, 2268, 78, 2268, 2213, 21, 21, 2213, 
	2213, 2213, 2213, 69, 2211, 2212, 2211, 2213, 
	77, 2213, 2213, 2214, 2215, 2269, 78, 2269, 
	2213, 21, 21, 2213, 2213, 2213, 2213, 69, 
	2211, 2212, 2211, 2213, 77, 2213, 2213, 2214, 
	2215, 2270, 78, 2270, 2213, 21, 21, 2213, 
	2213, 2213, 2213, 69, 2211, 2212, 2211, 2213, 
	77, 2213, 2213, 2214, 2215, 2271, 78, 2271, 
	2213, 21, 21, 2213, 2213, 2213, 2213, 69, 
	2211, 2212, 2211, 2213, 77, 2213, 2213, 2214, 
	2215, 2272, 78, 2272, 2213, 21, 21, 2213, 
	2213, 2213, 2213, 69, 2211, 2212, 2211, 2213, 
	77, 2213, 2213, 2214, 2215, 2273, 78, 2273, 
	2213, 21, 21, 2213, 2213, 2213, 2213, 69, 
	2274, 2275, 2274, 2213, 77, 2213, 2213, 2214, 
	2276, 78, 2213, 21, 21, 2213, 2213, 2213, 
	2213, 69, 2277, 2278, 2277, 77, 2194, 2276, 
	78, 21, 21, 69, 2279, 26, 21, 2280, 
	76, 2280, 77, 2194, 2276, 78, 21, 21, 
	69, 2276, 2281, 2276, 2282, 296, 2282, 2282, 
	2222, 78, 2282, 21, 21, 2282, 2282, 2282, 
	2282, 2282, 69, 2283, 26, 21, 2284, 300, 
	2284, 2282, 296, 2282, 2282, 2222, 78, 2282, 
	21, 21, 2282, 2282, 2282, 2282, 2282, 69, 
	2285, 2286, 2285, 2287, 77, 2287, 2287, 2288, 
	78, 2287, 21, 21, 2287, 2287, 2287, 2287, 
	69, 2289, 26, 21, 2211, 2212, 2211, 2213, 
	77, 2213, 2213, 2214, 2215, 2290, 78, 2290, 
	2213, 21, 21, 2213, 2213, 2213, 2213, 69, 
	2211, 2212, 2211, 2213, 77, 2213, 2213, 2214, 
	2215, 2291, 78, 2291, 2213, 21, 21, 2213, 
	2213, 2213, 2213, 69, 2211, 2212, 2211, 2213, 
	77, 2213, 2213, 2214, 2215, 2292, 78, 2292, 
	2213, 21, 21, 2213, 2213, 2213, 2213, 69, 
	2211, 2212, 2211, 2213, 77, 2213, 2213, 2214, 
	2215, 2293, 78, 2293, 2213, 21, 21, 2213, 
	2213, 2213, 2213, 69, 2211, 2212, 2211, 2213, 
	77, 2213, 2213, 2214, 2215, 2294, 78, 2294, 
	2213, 21, 21, 2213, 2213, 2213, 2213, 69, 
	2295, 2296, 2295, 2213, 77, 2213, 2213, 2214, 
	2297, 78, 2213, 21, 21, 2213, 2213, 2213, 
	2213, 69, 2298, 2299, 2298, 77, 2194, 2297, 
	78, 21, 21, 69, 2300, 26, 21, 2301, 
	76, 2301, 77, 2194, 2297, 78, 21, 21, 
	69, 2297, 2302, 2297, 2221, 2303, 2221, 2221, 
	2222, 78, 2221, 21, 21, 2221, 2221, 2221, 
	2221, 2221, 69, 2304, 26, 21, 2305, 2306, 
	2305, 2221, 2303, 2221, 2221, 2222, 78, 2221, 
	21, 21, 2221, 2221, 2221, 2221, 2221, 69, 
	2307, 26, 21, 2308, 76, 2308, 2303, 78, 
	21, 21, 69, 2309, 2310, 2309, 390, 2311, 
	392, 387, 387, 386, 2312, 26, 21, 2211, 
	2212, 2211, 2213, 77, 2213, 2213, 2214, 2215, 
	2313, 78, 2313, 2213, 21, 21, 2213, 2213, 
	2213, 2213, 69, 2211, 2212, 2211, 2213, 77, 
	2213, 2213, 2214, 2215, 2314, 78, 2314, 2213, 
	21, 21, 2213, 2213, 2213, 2213, 69, 2211, 
	2212, 2211, 2213, 77, 2213, 2213, 2214, 2215, 
	2315, 78, 2315, 2213, 21, 21, 2213, 2213, 
	2213, 2213, 69, 2211, 2212, 2211, 2213, 77, 
	2213, 2213, 2214, 2215, 2316, 78, 2316, 2213, 
	21, 21, 2213, 2213, 2213, 2213, 69, 2317, 
	2318, 2317, 2213, 77, 2213, 2213, 2214, 2319, 
	78, 2213, 21, 21, 2213, 2213, 2213, 2213, 
	69, 2320, 2321, 2320, 77, 2194, 2319, 78, 
	21, 21, 69, 2322, 26, 21, 2323, 76, 
	2323, 77, 2194, 2319, 78, 21, 21, 69, 
	2324, 2325, 2324, 2221, 2028, 2221, 2221, 2222, 
	78, 2221, 21, 21, 2221, 2221, 2221, 2221, 
	2221, 69, 2326, 26, 21, 2327, 2031, 2327, 
	2221, 2028, 2221, 2221, 2222, 78, 2221, 21, 
	21, 2221, 2221, 2221, 2221, 2221, 69, 2328, 
	26, 21, 2211, 2212, 2211, 2213, 77, 2213, 
	2213, 2214, 2215, 2329, 78, 2329, 2213, 21, 
	21, 2213, 2213, 2213, 2213, 69, 2211, 2212, 
	2211, 2213, 77, 2213, 2213, 2214, 2215, 2330, 
	78, 2330, 2213, 21, 21, 2213, 2213, 2213, 
	2213, 69, 2211, 2212, 2211, 2213, 77, 2213, 
	2213, 2214, 2215, 2331, 78, 2331, 2213, 21, 
	21, 2213, 2213, 2213, 2213, 69, 2211, 2212, 
	2211, 2213, 77, 2213, 2213, 2214, 2215, 2332, 
	78, 2332, 2213, 21, 21, 2213, 2213, 2213, 
	2213, 69, 2211, 2212, 2211, 2213, 77, 2213, 
	2213, 2214, 2215, 2333, 78, 2333, 2213, 21, 
	21, 2213, 2213, 2213, 2213, 69, 2334, 2335, 
	2334, 2213, 77, 2213, 2213, 2214, 2336, 78, 
	2213, 21, 21, 2213, 2213, 2213, 2213, 69, 
	2337, 2338, 2337, 77, 2194, 2336, 78, 21, 
	21, 69, 2339, 26, 21, 2340, 76, 2340, 
	77, 2194, 2336, 78, 21, 21, 69, 2341, 
	2342, 2341, 2221, 2049, 2221, 2221, 2222, 78, 
	2221, 21, 21, 2221, 2221, 2221, 2221, 2221, 
	69, 2343, 26, 21, 2344, 2052, 2344, 2221, 
	2049, 2221, 2221, 2222, 78, 2221, 21, 21, 
	2221, 2221, 2221, 2221, 2221, 69, 2345, 26, 
	21, 2211, 2212, 2211, 2213, 77, 2213, 2213, 
	2214, 2215, 2346, 78, 2346, 2213, 21, 21, 
	2213, 2213, 2213, 2213, 69, 2211, 2212, 2211, 
	2213, 77, 2213, 2213, 2214, 2215, 2347, 78, 
	2347, 2213, 21, 21, 2213, 2213, 2213, 2213, 
	69, 2348, 2349, 2348, 2213, 77, 2213, 2213, 
	2214, 2350, 78, 2213, 21, 21, 2213, 2213, 
	2213, 2213, 69, 2351, 2352, 2351, 77, 2194, 
	2350, 78, 21, 21, 69, 2353, 26, 21, 
	2354, 76, 2354, 77, 2194, 2350, 78, 21, 
	21, 69, 2350, 2355, 2350, 2221, 2356, 2221, 
	2221, 2222, 78, 2221, 21, 21, 2221, 2221, 
	2221, 2221, 2221, 69, 2357, 26, 21, 2358, 
	2359, 2358, 2221, 2356, 2221, 2221, 2222, 78, 
	2221, 21, 21, 2221, 2221, 2221, 2221, 2221, 
	69, 2360, 26, 21, 2361, 76, 2361, 2356, 
	78, 21, 21, 69, 2362, 2363, 2362, 197, 
	2364, 198, 195, 195, 194, 2365, 26, 21, 
	2211, 2212, 2211, 2213, 77, 2213, 2213, 2214, 
	2215, 2366, 78, 2366, 2213, 21, 21, 2213, 
	2213, 2213, 2213, 69, 2211, 2212, 2211, 2213, 
	77, 2213, 2213, 2214, 2215, 2367, 78, 2367, 
	2213, 21, 21, 2213, 2213, 2213, 2213, 69, 
	2211, 2212, 2211, 2213, 77, 2213, 2213, 2214, 
	2215, 2368, 78, 2368, 2213, 21, 21, 2213, 
	2213, 2213, 2213, 69, 2211, 2212, 2211, 2213, 
	77, 2213, 2213, 2214, 2215, 2369, 78, 2369, 
	2213, 21, 21, 2213, 2213, 2213, 2213, 69, 
	2370, 2371, 2370, 2213, 77, 2213, 2213, 2214, 
	2372, 78, 2213, 21, 21, 2213, 2213, 2213, 
	2213, 69, 2373, 2374, 2373, 77, 2194, 2372, 
	78, 21, 21, 69, 2375, 26, 21, 2376, 
	76, 2376, 77, 2194, 2372, 78, 21, 21, 
	69, 2377, 2378, 2377, 2221, 2089, 2221, 2221, 
	2222, 78, 2221, 21, 21, 2221, 2221, 2221, 
	2221, 2221, 69, 2379, 26, 21, 2380, 2092, 
	2380, 2221, 2089, 2221, 2221, 2222, 78, 2221, 
	21, 21, 2221, 2221, 2221, 2221, 2221, 69, 
	2381, 26, 21, 2211, 2212, 2211, 2213, 77, 
	2213, 2213, 2214, 2215, 2382, 78, 2382, 2213, 
	21, 21, 2213, 2213, 2213, 2213, 69, 2211, 
	2212, 2211, 2213, 77, 2213, 2213, 2214, 2215, 
	2383, 78, 2383, 2213, 21, 21, 2213, 2213, 
	2213, 2213, 69, 2211, 2212, 2211, 2213, 77, 
	2213, 2213, 2214, 2215, 2384, 78, 2384, 2213, 
	21, 21, 2213, 2213, 2213, 2213, 69, 2211, 
	2212, 2211, 2213, 77, 2213, 2213, 2214, 2215, 
	2385, 78, 2385, 2213, 21, 21, 2213, 2213, 
	2213, 2213, 69, 2386, 2387, 2386, 2213, 77, 
	2213, 2213, 2214, 2388, 78, 2213, 21, 21, 
	2213, 2213, 2213, 2213, 69, 2389, 2390, 2389, 
	77, 2194, 2388, 78, 21, 21, 69, 2391, 
	26, 21, 2392, 76, 2392, 77, 2194, 2388, 
	78, 21, 21, 69, 2388, 2393, 2388, 2221, 
	296, 2221, 2221, 2394, 2395, 2222, 78, 2394, 
	2395, 2221, 21, 21, 2221, 2221, 2221, 2221, 
	2221, 69, 2396, 26, 21, 2397, 300, 2397, 
	2221, 296, 2221, 2221, 2394, 2395, 2222, 78, 
	2394, 2395, 2221, 21, 21, 2221, 2221, 2221, 
	2221, 2221, 69, 2225, 2226, 2225, 2221, 77, 
	2221, 2221, 2214, 2398, 78, 2398, 2221, 21, 
	21, 2221, 2221, 2221, 2221, 69, 2225, 2226, 
	2225, 2221, 77, 2221, 2221, 2214, 2399, 78, 
	2399, 2221, 21, 21, 2221, 2221, 2221, 2221, 
	69, 2225, 2226, 2225, 2221, 77, 2221, 2221, 
	2214, 2400, 78, 2400, 2221, 21, 21, 2221, 
	2221, 2221, 2221, 69, 2225, 2226, 2225, 2221, 
	77, 2221, 2221, 2214, 2401, 78, 2401, 2221, 
	21, 21, 2221, 2221, 2221, 2221, 69, 2402, 
	2403, 2402, 77, 2404, 78, 21, 21, 69, 
	2225, 2226, 2225, 2221, 77, 2221, 2221, 2214, 
	2405, 78, 2405, 2221, 21, 21, 2221, 2221, 
	2221, 2221, 69, 2225, 2226, 2225, 2221, 77, 
	2221, 2221, 2214, 2400, 78, 2400, 2221, 21, 
	21, 2221, 2221, 2221, 2221, 69, 2406, 26, 
	21, 2407, 26, 21, 49, 50, 49, 51, 
	51, 51, 52, 53, 2408, 2408, 51, 51, 
	51, 51, 51, 21, 49, 50, 49, 51, 
	51, 51, 52, 53, 2409, 2409, 51, 51, 
	51, 51, 51, 21, 2410, 2411, 2410, 51, 
	51, 51, 52, 2412, 51, 51, 51, 51, 
	51, 21, 2413, 2414, 2413, 56, 2412, 21, 
	2415, 26, 21, 2416, 26, 2416, 56, 2412, 
	21, 2412, 2417, 2412, 68, 2418, 68, 68, 
	70, 68, 68, 68, 68, 68, 68, 21, 
	2419, 26, 21, 2420, 2421, 2420, 68, 2418, 
	68, 68, 70, 68, 68, 68, 68, 68, 
	68, 21, 2422, 26, 21, 2423, 26, 2423, 
	2418, 21, 2425, 197, 2426, 195, 195, 195, 
	2424, 2428, 202, 2429, 200, 200, 200, 2427, 
	2430, 204, 202, 200, 204, 2431, 2427, 2427, 
	200, 2432, 26, 21, 26, 2433, 2433, 21, 
	26, 2434, 2434, 21, 26, 2435, 2435, 21, 
	26, 2436, 2436, 21, 26, 2437, 2437, 21, 
	2438, 2439, 2438, 21, 2440, 26, 21, 30, 
	26, 30, 21, 2441, 2441, 1, 6, 6, 
	1, 26, 21, 30, 26, 30, 21, 48, 
	26, 48, 21, 58, 26, 58, 21, 63, 
	26, 63, 21, 58, 26, 58, 39, 39, 
	39, 40, 60, 42, 43, 61, 45, 46, 
	40, 60, 42, 43, 61, 45, 46, 39, 
	39, 39, 39, 39, 39, 21, 72, 26, 
	72, 21, 75, 26, 75, 21, 69, 26, 
	69, 21, 85, 26, 85, 21, 85, 26, 
	85, 39, 39, 39, 40, 60, 42, 43, 
	61, 45, 46, 40, 60, 42, 43, 61, 
	45, 46, 39, 39, 39, 39, 39, 39, 
	21, 97, 26, 97, 21, 2442, 26, 2442, 
	21, 105, 26, 105, 21, 106, 26, 106, 
	21, 97, 26, 97, 39, 39, 39, 40, 
	60, 42, 43, 61, 45, 46, 40, 60, 
	42, 43, 61, 45, 46, 39, 39, 39, 
	39, 39, 39, 21, 160, 26, 160, 21, 
	2443, 26, 2443, 21, 168, 26, 168, 21, 
	169, 26, 169, 21, 160, 26, 160, 39, 
	39, 39, 40, 60, 42, 43, 61, 45, 
	46, 40, 60, 42, 43, 61, 45, 46, 
	39, 39, 39, 39, 39, 39, 21, 186, 
	26, 186, 21, 190, 26, 190, 21, 193, 
	26, 193, 21, 204, 202, 200, 209, 26, 
	209, 39, 39, 39, 40, 60, 42, 43, 
	61, 45, 46, 40, 60, 42, 43, 61, 
	45, 46, 39, 39, 39, 39, 39, 39, 
	21, 221, 26, 221, 21, 2444, 26, 2444, 
	21, 229, 26, 229, 21, 230, 26, 230, 
	21, 221, 26, 221, 39, 39, 39, 40, 
	60, 42, 43, 61, 45, 46, 40, 60, 
	42, 43, 61, 45, 46, 39, 39, 39, 
	39, 39, 39, 21, 249, 26, 249, 21, 
	254, 26, 254, 21, 249, 26, 249, 39, 
	39, 39, 40, 60, 42, 43, 61, 45, 
	46, 40, 60, 42, 43, 61, 45, 46, 
	39, 39, 39, 39, 39, 39, 21, 199, 
	204, 199, 202, 200, 270, 26, 270, 39, 
	39, 39, 40, 60, 42, 43, 61, 45, 
	46, 40, 60, 42, 43, 61, 45, 46, 
	39, 39, 39, 39, 39, 39, 21, 273, 
	26, 273, 39, 39, 39, 40, 60, 42, 
	43, 61, 45, 46, 40, 60, 42, 43, 
	61, 45, 46, 39, 39, 39, 39, 39, 
	39, 21, 284, 26, 284, 21, 293, 26, 
	293, 21, 299, 26, 299, 21, 302, 26, 
	302, 21, 273, 26, 273, 21, 293, 26, 
	293, 39, 39, 39, 40, 60, 42, 43, 
	61, 45, 46, 40, 60, 42, 43, 61, 
	45, 46, 39, 39, 39, 39, 39, 39, 
	21, 357, 26, 357, 21, 361, 26, 361, 
	21, 357, 26, 357, 39, 39, 39, 40, 
	60, 42, 43, 61, 45, 46, 40, 60, 
	42, 43, 61, 45, 46, 39, 39, 39, 
	39, 39, 39, 21, 378, 26, 378, 21, 
	382, 26, 382, 21, 385, 26, 385, 21, 
	398, 396, 394, 393, 398, 393, 396, 394, 
	406, 398, 406, 396, 394, 417, 398, 417, 
	396, 394, 426, 398, 426, 396, 394, 431, 
	398, 431, 396, 394, 434, 398, 434, 396, 
	394, 406, 398, 406, 449, 396, 449, 449, 
	450, 451, 452, 453, 454, 455, 456, 450, 
	451, 452, 453, 454, 455, 456, 449, 449, 
	449, 449, 449, 449, 394, 447, 398, 447, 
	396, 394, 458, 398, 458, 396, 394, 447, 
	398, 447, 449, 396, 449, 449, 450, 451, 
	452, 453, 454, 455, 456, 450, 451, 452, 
	453, 454, 455, 456, 449, 449, 449, 449, 
	449, 449, 394, 466, 398, 466, 396, 394, 
	469, 398, 469, 396, 394, 475, 398, 475, 
	396, 394, 475, 398, 475, 449, 396, 449, 
	449, 450, 451, 452, 453, 454, 455, 456, 
	450, 451, 452, 453, 454, 455, 456, 449, 
	449, 449, 449, 449, 449, 394, 487, 398, 
	487, 396, 394, 2445, 398, 2445, 396, 394, 
	495, 398, 495, 396, 394, 501, 26, 501, 
	39, 39, 39, 40, 60, 42, 43, 61, 
	45, 46, 40, 60, 42, 43, 61, 45, 
	46, 39, 39, 39, 39, 39, 39, 21, 
	504, 26, 504, 39, 39, 39, 40, 60, 
	42, 43, 61, 45, 46, 40, 60, 42, 
	43, 61, 45, 46, 39, 39, 39, 39, 
	39, 39, 21, 515, 26, 515, 21, 524, 
	26, 524, 21, 530, 26, 530, 21, 533, 
	26, 533, 21, 504, 26, 504, 21, 524, 
	26, 524, 39, 39, 39, 40, 60, 42, 
	43, 61, 45, 46, 40, 60, 42, 43, 
	61, 45, 46, 39, 39, 39, 39, 39, 
	39, 21, 592, 26, 592, 21, 596, 26, 
	596, 21, 592, 26, 592, 39, 39, 39, 
	40, 60, 42, 43, 61, 45, 46, 40, 
	60, 42, 43, 61, 45, 46, 39, 39, 
	39, 39, 39, 39, 21, 613, 26, 613, 
	21, 617, 26, 617, 21, 620, 26, 620, 
	21, 613, 26, 613, 39, 39, 39, 40, 
	60, 42, 43, 61, 45, 46, 40, 60, 
	42, 43, 61, 45, 46, 39, 39, 39, 
	39, 39, 39, 21, 635, 26, 635, 21, 
	2446, 26, 2446, 21, 643, 26, 643, 21, 
	635, 26, 635, 39, 39, 39, 40, 60, 
	42, 43, 61, 45, 46, 40, 60, 42, 
	43, 61, 45, 46, 39, 39, 39, 39, 
	39, 39, 21, 660, 26, 660, 21, 2447, 
	26, 2447, 21, 668, 26, 668, 21, 677, 
	26, 677, 21, 688, 26, 688, 21, 697, 
	26, 697, 21, 703, 26, 703, 21, 706, 
	26, 706, 21, 677, 26, 677, 39, 39, 
	39, 40, 60, 42, 43, 61, 45, 46, 
	40, 60, 42, 43, 61, 45, 46, 39, 
	39, 39, 39, 39, 39, 21, 697, 26, 
	697, 39, 39, 39, 40, 60, 42, 43, 
	61, 45, 46, 40, 60, 42, 43, 61, 
	45, 46, 39, 39, 39, 39, 39, 39, 
	21, 763, 26, 763, 21, 767, 26, 767, 
	21, 763, 26, 763, 39, 39, 39, 40, 
	60, 42, 43, 61, 45, 46, 40, 60, 
	42, 43, 61, 45, 46, 39, 39, 39, 
	39, 39, 39, 21, 784, 26, 784, 21, 
	788, 26, 788, 21, 791, 26, 791, 21, 
	784, 26, 784, 39, 39, 39, 40, 60, 
	42, 43, 61, 45, 46, 40, 60, 42, 
	43, 61, 45, 46, 39, 39, 39, 39, 
	39, 39, 21, 806, 26, 806, 21, 2448, 
	26, 2448, 21, 814, 26, 814, 21, 806, 
	26, 806, 39, 39, 39, 40, 60, 42, 
	43, 61, 45, 46, 40, 60, 42, 43, 
	61, 45, 46, 39, 39, 39, 39, 39, 
	39, 21, 831, 26, 831, 21, 2449, 26, 
	2449, 21, 839, 26, 839, 21, 831, 26, 
	831, 39, 39, 39, 40, 60, 42, 43, 
	61, 45, 46, 40, 60, 42, 43, 61, 
	45, 46, 39, 39, 39, 39, 39, 39, 
	21, 853, 26, 853, 21, 857, 26, 857, 
	21, 860, 26, 860, 21, 868, 204, 868, 
	202, 200, 879, 204, 879, 202, 200, 888, 
	204, 888, 202, 200, 893, 204, 893, 202, 
	200, 896, 204, 896, 202, 200, 868, 204, 
	868, 911, 202, 911, 911, 912, 913, 914, 
	915, 916, 917, 918, 912, 913, 914, 915, 
	916, 917, 918, 911, 911, 911, 911, 911, 
	911, 200, 909, 204, 909, 202, 200, 920, 
	204, 920, 202, 200, 909, 204, 909, 911, 
	202, 911, 911, 912, 913, 914, 915, 916, 
	917, 918, 912, 913, 914, 915, 916, 917, 
	918, 911, 911, 911, 911, 911, 911, 200, 
	928, 204, 928, 202, 200, 931, 204, 931, 
	202, 200, 937, 204, 937, 202, 200, 937, 
	204, 937, 911, 202, 911, 911, 912, 913, 
	914, 915, 916, 917, 918, 912, 913, 914, 
	915, 916, 917, 918, 911, 911, 911, 911, 
	911, 911, 200, 949, 204, 949, 202, 200, 
	2450, 204, 2450, 202, 200, 957, 204, 957, 
	202, 200, 949, 204, 949, 911, 202, 911, 
	911, 912, 913, 914, 915, 916, 917, 918, 
	912, 913, 914, 915, 916, 917, 918, 911, 
	911, 911, 911, 911, 911, 200, 1006, 204, 
	1006, 202, 200, 2451, 204, 2451, 202, 200, 
	1014, 204, 1014, 202, 200, 1019, 26, 1019, 
	39, 39, 39, 40, 60, 42, 43, 61, 
	45, 46, 40, 60, 42, 43, 61, 45, 
	46, 39, 39, 39, 39, 39, 39, 21, 
	1006, 204, 1006, 911, 202, 911, 911, 912, 
	913, 914, 915, 916, 917, 918, 912, 913, 
	914, 915, 916, 917, 918, 911, 911, 911, 
	911, 911, 911, 200, 1030, 204, 1030, 202, 
	200, 1033, 204, 1033, 202, 200, 1030, 204, 
	1030, 911, 202, 911, 911, 912, 913, 914, 
	915, 916, 917, 918, 912, 913, 914, 915, 
	916, 917, 918, 911, 911, 911, 911, 911, 
	911, 200, 1045, 204, 1045, 202, 200, 2452, 
	204, 2452, 202, 200, 1053, 204, 1053, 202, 
	200, 1059, 26, 1059, 39, 39, 39, 40, 
	60, 42, 43, 61, 45, 46, 40, 60, 
	42, 43, 61, 45, 46, 39, 39, 39, 
	39, 39, 39, 21, 1062, 26, 1062, 39, 
	39, 39, 40, 60, 42, 43, 61, 45, 
	46, 40, 60, 42, 43, 61, 45, 46, 
	39, 39, 39, 39, 39, 39, 21, 1073, 
	26, 1073, 21, 1082, 26, 1082, 21, 1088, 
	26, 1088, 21, 1091, 26, 1091, 21, 1062, 
	26, 1062, 21, 1082, 26, 1082, 39, 39, 
	39, 40, 60, 42, 43, 61, 45, 46, 
	40, 60, 42, 43, 61, 45, 46, 39, 
	39, 39, 39, 39, 39, 21, 1150, 26, 
	1150, 21, 1154, 26, 1154, 21, 1150, 26, 
	1150, 39, 39, 39, 40, 60, 42, 43, 
	61, 45, 46, 40, 60, 42, 43, 61, 
	45, 46, 39, 39, 39, 39, 39, 39, 
	21, 1171, 26, 1171, 21, 1175, 26, 1175, 
	21, 1178, 26, 1178, 21, 1171, 26, 1171, 
	39, 39, 39, 40, 60, 42, 43, 61, 
	45, 46, 40, 60, 42, 43, 61, 45, 
	46, 39, 39, 39, 39, 39, 39, 21, 
	1193, 26, 1193, 21, 2453, 26, 2453, 21, 
	1201, 26, 1201, 21, 1193, 26, 1193, 39, 
	39, 39, 40, 60, 42, 43, 61, 45, 
	46, 40, 60, 42, 43, 61, 45, 46, 
	39, 39, 39, 39, 39, 39, 21, 1218, 
	26, 1218, 21, 2454, 26, 2454, 21, 1226, 
	26, 1226, 21, 1218, 26, 1218, 39, 39, 
	39, 40, 60, 42, 43, 61, 45, 46, 
	40, 60, 42, 43, 61, 45, 46, 39, 
	39, 39, 39, 39, 39, 21, 1240, 26, 
	1240, 21, 1244, 26, 1244, 21, 1247, 26, 
	1247, 21, 1240, 26, 1240, 39, 39, 39, 
	40, 60, 42, 43, 61, 45, 46, 40, 
	60, 42, 43, 61, 45, 46, 39, 39, 
	39, 39, 39, 39, 21, 1262, 26, 1262, 
	21, 2455, 26, 2455, 21, 1270, 26, 1270, 
	21, 1262, 26, 1262, 39, 39, 39, 40, 
	60, 42, 43, 61, 45, 46, 40, 60, 
	42, 43, 61, 45, 46, 39, 39, 39, 
	39, 39, 39, 21, 1286, 26, 1286, 21, 
	1291, 26, 1291, 21, 1286, 26, 1286, 39, 
	39, 39, 40, 60, 42, 43, 61, 45, 
	46, 40, 60, 42, 43, 61, 45, 46, 
	39, 39, 39, 39, 39, 39, 21, 1045, 
	204, 1045, 911, 202, 911, 911, 912, 913, 
	914, 915, 916, 917, 918, 912, 913, 914, 
	915, 916, 917, 918, 911, 911, 911, 911, 
	911, 911, 200, 1312, 204, 1312, 202, 200, 
	1317, 204, 1317, 202, 200, 1312, 204, 1312, 
	911, 202, 911, 911, 912, 913, 914, 915, 
	916, 917, 918, 912, 913, 914, 915, 916, 
	917, 918, 911, 911, 911, 911, 911, 911, 
	200, 1337, 204, 1337, 202, 200, 1341, 204, 
	1341, 202, 200, 1344, 204, 1344, 202, 200, 
	1351, 398, 1351, 449, 396, 449, 449, 450, 
	451, 452, 453, 454, 455, 456, 450, 451, 
	452, 453, 454, 455, 456, 449, 449, 449, 
	449, 449, 449, 394, 1364, 398, 1364, 396, 
	394, 2456, 398, 2456, 396, 394, 1372, 398, 
	1372, 396, 394, 1364, 398, 1364, 449, 396, 
	449, 449, 450, 451, 452, 453, 454, 455, 
	456, 450, 451, 452, 453, 454, 455, 456, 
	449, 449, 449, 449, 449, 449, 394, 1418, 
	398, 1418, 396, 394, 1422, 398, 1422, 396, 
	394, 1425, 398, 1425, 396, 394, 1432, 204, 
	1432, 911, 202, 911, 911, 912, 913, 914, 
	915, 916, 917, 918, 912, 913, 914, 915, 
	916, 917, 918, 911, 911, 911, 911, 911, 
	911, 200, 1418, 398, 1418, 449, 396, 449, 
	449, 450, 451, 452, 453, 454, 455, 456, 
	450, 451, 452, 453, 454, 455, 456, 449, 
	449, 449, 449, 449, 449, 394, 1445, 398, 
	1445, 396, 394, 2457, 398, 2457, 396, 394, 
	1453, 398, 1453, 396, 394, 1445, 398, 1445, 
	449, 396, 449, 449, 450, 451, 452, 453, 
	454, 455, 456, 450, 451, 452, 453, 454, 
	455, 456, 449, 449, 449, 449, 449, 449, 
	394, 1466, 398, 1466, 396, 394, 1471, 398, 
	1471, 396, 394, 1466, 398, 1466, 449, 396, 
	449, 449, 450, 451, 452, 453, 454, 455, 
	456, 450, 451, 452, 453, 454, 455, 456, 
	449, 449, 449, 449, 449, 449, 394, 1337, 
	204, 1337, 911, 202, 911, 911, 912, 913, 
	914, 915, 916, 917, 918, 912, 913, 914, 
	915, 916, 917, 918, 911, 911, 911, 911, 
	911, 911, 200, 1495, 204, 1495, 202, 200, 
	1499, 204, 1499, 202, 200, 1495, 204, 1495, 
	911, 202, 911, 911, 912, 913, 914, 915, 
	916, 917, 918, 912, 913, 914, 915, 916, 
	917, 918, 911, 911, 911, 911, 911, 911, 
	200, 888, 204, 888, 911, 202, 911, 911, 
	912, 913, 914, 915, 916, 917, 918, 912, 
	913, 914, 915, 916, 917, 918, 911, 911, 
	911, 911, 911, 911, 200, 1555, 204, 1555, 
	202, 200, 1559, 204, 1559, 202, 200, 1555, 
	204, 1555, 911, 202, 911, 911, 912, 913, 
	914, 915, 916, 917, 918, 912, 913, 914, 
	915, 916, 917, 918, 911, 911, 911, 911, 
	911, 911, 200, 1576, 204, 1576, 202, 200, 
	1579, 204, 1579, 202, 200, 1582, 204, 1582, 
	202, 200, 1576, 204, 1576, 911, 202, 911, 
	911, 912, 913, 914, 915, 916, 917, 918, 
	912, 913, 914, 915, 916, 917, 918, 911, 
	911, 911, 911, 911, 911, 200, 1594, 204, 
	1594, 202, 200, 2458, 204, 2458, 202, 200, 
	1601, 204, 1601, 202, 200, 1594, 204, 1594, 
	911, 202, 911, 911, 912, 913, 914, 915, 
	916, 917, 918, 912, 913, 914, 915, 916, 
	917, 918, 911, 911, 911, 911, 911, 911, 
	200, 1614, 204, 1614, 202, 200, 2459, 204, 
	2459, 202, 200, 1621, 204, 1621, 202, 200, 
	1614, 204, 1614, 911, 202, 911, 911, 912, 
	913, 914, 915, 916, 917, 918, 912, 913, 
	914, 915, 916, 917, 918, 911, 911, 911, 
	911, 911, 911, 200, 1631, 204, 1631, 202, 
	200, 1634, 204, 1634, 202, 200, 1631, 204, 
	1631, 911, 202, 911, 911, 912, 913, 914, 
	915, 916, 917, 918, 912, 913, 914, 915, 
	916, 917, 918, 911, 911, 911, 911, 911, 
	911, 200, 1646, 204, 1646, 202, 200, 2460, 
	204, 2460, 202, 200, 1653, 204, 1653, 202, 
	200, 1646, 204, 1646, 911, 202, 911, 911, 
	912, 913, 914, 915, 916, 917, 918, 912, 
	913, 914, 915, 916, 917, 918, 911, 911, 
	911, 911, 911, 911, 200, 1665, 204, 1665, 
	202, 200, 1670, 204, 1670, 202, 200, 1665, 
	204, 1665, 911, 202, 911, 911, 912, 913, 
	914, 915, 916, 917, 918, 912, 913, 914, 
	915, 916, 917, 918, 911, 911, 911, 911, 
	911, 911, 200, 853, 26, 853, 39, 39, 
	39, 40, 60, 42, 43, 61, 45, 46, 
	40, 60, 42, 43, 61, 45, 46, 39, 
	39, 39, 39, 39, 39, 21, 1691, 26, 
	1691, 21, 2461, 26, 2461, 21, 1699, 26, 
	1699, 21, 1691, 26, 1691, 39, 39, 39, 
	40, 60, 42, 43, 61, 45, 46, 40, 
	60, 42, 43, 61, 45, 46, 39, 39, 
	39, 39, 39, 39, 21, 1715, 26, 1715, 
	21, 1720, 26, 1720, 21, 1715, 26, 1715, 
	39, 39, 39, 40, 60, 42, 43, 61, 
	45, 46, 40, 60, 42, 43, 61, 45, 
	46, 39, 39, 39, 39, 39, 39, 21, 
	660, 26, 660, 39, 39, 39, 40, 60, 
	42, 43, 61, 45, 46, 40, 60, 42, 
	43, 61, 45, 46, 39, 39, 39, 39, 
	39, 39, 21, 1739, 26, 1739, 21, 1743, 
	26, 1743, 21, 1746, 26, 1746, 21, 1739, 
	26, 1739, 39, 39, 39, 40, 60, 42, 
	43, 61, 45, 46, 40, 60, 42, 43, 
	61, 45, 46, 39, 39, 39, 39, 39, 
	39, 21, 1761, 26, 1761, 21, 2462, 26, 
	2462, 21, 1769, 26, 1769, 21, 1761, 26, 
	1761, 39, 39, 39, 40, 60, 42, 43, 
	61, 45, 46, 40, 60, 42, 43, 61, 
	45, 46, 39, 39, 39, 39, 39, 39, 
	21, 1785, 26, 1785, 21, 1790, 26, 1790, 
	21, 1785, 26, 1785, 39, 39, 39, 40, 
	60, 42, 43, 61, 45, 46, 40, 60, 
	42, 43, 61, 45, 46, 39, 39, 39, 
	39, 39, 39, 21, 487, 398, 487, 449, 
	396, 449, 449, 450, 451, 452, 453, 454, 
	455, 456, 450, 451, 452, 453, 454, 455, 
	456, 449, 449, 449, 449, 449, 449, 394, 
	1811, 398, 1811, 396, 394, 1814, 398, 1814, 
	396, 394, 1811, 398, 1811, 449, 396, 449, 
	449, 450, 451, 452, 453, 454, 455, 456, 
	450, 451, 452, 453, 454, 455, 456, 449, 
	449, 449, 449, 449, 449, 394, 1829, 398, 
	1829, 396, 394, 1833, 398, 1833, 396, 394, 
	1829, 398, 1829, 449, 396, 449, 449, 450, 
	451, 452, 453, 454, 455, 456, 450, 451, 
	452, 453, 454, 455, 456, 449, 449, 449, 
	449, 449, 449, 394, 426, 398, 426, 449, 
	396, 449, 449, 450, 451, 452, 453, 454, 
	455, 456, 450, 451, 452, 453, 454, 455, 
	456, 449, 449, 449, 449, 449, 449, 394, 
	1889, 398, 1889, 396, 394, 1893, 398, 1893, 
	396, 394, 1889, 398, 1889, 449, 396, 449, 
	449, 450, 451, 452, 453, 454, 455, 456, 
	450, 451, 452, 453, 454, 455, 456, 449, 
	449, 449, 449, 449, 449, 394, 1910, 398, 
	1910, 396, 394, 1913, 398, 1913, 396, 394, 
	1910, 398, 1910, 449, 396, 449, 449, 450, 
	451, 452, 453, 454, 455, 456, 450, 451, 
	452, 453, 454, 455, 456, 449, 449, 449, 
	449, 449, 449, 394, 1925, 398, 1925, 396, 
	394, 2463, 398, 2463, 396, 394, 1932, 398, 
	1932, 396, 394, 1925, 398, 1925, 449, 396, 
	449, 449, 450, 451, 452, 453, 454, 455, 
	456, 450, 451, 452, 453, 454, 455, 456, 
	449, 449, 449, 449, 449, 449, 394, 1945, 
	398, 1945, 396, 394, 2464, 398, 2464, 396, 
	394, 1952, 398, 1952, 396, 394, 1945, 398, 
	1945, 449, 396, 449, 449, 450, 451, 452, 
	453, 454, 455, 456, 450, 451, 452, 453, 
	454, 455, 456, 449, 449, 449, 449, 449, 
	449, 394, 1962, 398, 1962, 396, 394, 1965, 
	398, 1965, 396, 394, 1968, 398, 1968, 396, 
	394, 1962, 398, 1962, 449, 396, 449, 449, 
	450, 451, 452, 453, 454, 455, 456, 450, 
	451, 452, 453, 454, 455, 456, 449, 449, 
	449, 449, 449, 449, 394, 1980, 398, 1980, 
	396, 394, 2465, 398, 2465, 396, 394, 1987, 
	398, 1987, 396, 394, 1980, 398, 1980, 449, 
	396, 449, 449, 450, 451, 452, 453, 454, 
	455, 456, 450, 451, 452, 453, 454, 455, 
	456, 449, 449, 449, 449, 449, 449, 394, 
	1999, 398, 1999, 396, 394, 2004, 398, 2004, 
	396, 394, 1999, 398, 1999, 449, 396, 449, 
	449, 450, 451, 452, 453, 454, 455, 456, 
	450, 451, 452, 453, 454, 455, 456, 449, 
	449, 449, 449, 449, 449, 394, 378, 26, 
	378, 39, 39, 39, 40, 60, 42, 43, 
	61, 45, 46, 40, 60, 42, 43, 61, 
	45, 46, 39, 39, 39, 39, 39, 39, 
	21, 2025, 26, 2025, 21, 2466, 26, 2466, 
	21, 2033, 26, 2033, 21, 2025, 26, 2025, 
	39, 39, 39, 40, 60, 42, 43, 61, 
	45, 46, 40, 60, 42, 43, 61, 45, 
	46, 39, 39, 39, 39, 39, 39, 21, 
	2046, 26, 2046, 21, 2467, 26, 2467, 21, 
	2054, 26, 2054, 21, 2046, 26, 2046, 39, 
	39, 39, 40, 60, 42, 43, 61, 45, 
	46, 40, 60, 42, 43, 61, 45, 46, 
	39, 39, 39, 39, 39, 39, 21, 2064, 
	26, 2064, 21, 2068, 26, 2068, 21, 2071, 
	26, 2071, 21, 2064, 26, 2064, 39, 39, 
	39, 40, 60, 42, 43, 61, 45, 46, 
	40, 60, 42, 43, 61, 45, 46, 39, 
	39, 39, 39, 39, 39, 21, 2086, 26, 
	2086, 21, 2468, 26, 2468, 21, 2094, 26, 
	2094, 21, 2086, 26, 2086, 39, 39, 39, 
	40, 60, 42, 43, 61, 45, 46, 40, 
	60, 42, 43, 61, 45, 46, 39, 39, 
	39, 39, 39, 39, 21, 2106, 26, 2106, 
	21, 2111, 26, 2111, 21, 2106, 26, 2106, 
	39, 39, 39, 40, 60, 42, 43, 61, 
	45, 46, 40, 60, 42, 43, 61, 45, 
	46, 39, 39, 39, 39, 39, 39, 21, 
	186, 26, 186, 39, 39, 39, 40, 60, 
	42, 43, 61, 45, 46, 40, 60, 42, 
	43, 61, 45, 46, 39, 39, 39, 39, 
	39, 39, 21, 2132, 26, 2132, 21, 2136, 
	26, 2136, 21, 2139, 26, 2139, 21, 2132, 
	26, 2132, 39, 39, 39, 40, 60, 42, 
	43, 61, 45, 46, 40, 60, 42, 43, 
	61, 45, 46, 39, 39, 39, 39, 39, 
	39, 21, 2155, 26, 2155, 21, 2159, 26, 
	2159, 21, 2155, 26, 2155, 39, 39, 39, 
	40, 60, 42, 43, 61, 45, 46, 40, 
	60, 42, 43, 61, 45, 46, 39, 39, 
	39, 39, 39, 39, 21, 2176, 26, 2176, 
	21, 2180, 26, 2180, 21, 2183, 26, 2183, 
	21, 2187, 398, 2187, 396, 394, 2196, 26, 
	2196, 39, 39, 39, 40, 60, 42, 43, 
	61, 45, 46, 40, 60, 42, 43, 61, 
	45, 46, 39, 39, 39, 39, 39, 39, 
	21, 2199, 26, 2199, 39, 39, 39, 40, 
	60, 42, 43, 61, 45, 46, 40, 60, 
	42, 43, 61, 45, 46, 39, 39, 39, 
	39, 39, 39, 21, 2210, 26, 2210, 21, 
	2219, 26, 2219, 21, 2224, 26, 2224, 21, 
	2199, 26, 2199, 21, 2219, 26, 2219, 39, 
	39, 39, 40, 60, 42, 43, 61, 45, 
	46, 40, 60, 42, 43, 61, 45, 46, 
	39, 39, 39, 39, 39, 39, 21, 2280, 
	26, 2280, 21, 2284, 26, 2284, 21, 2280, 
	26, 2280, 39, 39, 39, 40, 60, 42, 
	43, 61, 45, 46, 40, 60, 42, 43, 
	61, 45, 46, 39, 39, 39, 39, 39, 
	39, 21, 2301, 26, 2301, 21, 2305, 26, 
	2305, 21, 2308, 26, 2308, 21, 2301, 26, 
	2301, 39, 39, 39, 40, 60, 42, 43, 
	61, 45, 46, 40, 60, 42, 43, 61, 
	45, 46, 39, 39, 39, 39, 39, 39, 
	21, 2323, 26, 2323, 21, 2469, 26, 2469, 
	21, 2323, 26, 2323, 39, 39, 39, 40, 
	60, 42, 43, 61, 45, 46, 40, 60, 
	42, 43, 61, 45, 46, 39, 39, 39, 
	39, 39, 39, 21, 2340, 26, 2340, 21, 
	2470, 26, 2470, 21, 2340, 26, 2340, 39, 
	39, 39, 40, 60, 42, 43, 61, 45, 
	46, 40, 60, 42, 43, 61, 45, 46, 
	39, 39, 39, 39, 39, 39, 21, 2354, 
	26, 2354, 21, 2358, 26, 2358, 21, 2361, 
	26, 2361, 21, 2354, 26, 2354, 39, 39, 
	39, 40, 60, 42, 43, 61, 45, 46, 
	40, 60, 42, 43, 61, 45, 46, 39, 
	39, 39, 39, 39, 39, 21, 2376, 26, 
	2376, 21, 2471, 26, 2471, 21, 2376, 26, 
	2376, 39, 39, 39, 40, 60, 42, 43, 
	61, 45, 46, 40, 60, 42, 43, 61, 
	45, 46, 39, 39, 39, 39, 39, 39, 
	21, 2392, 26, 2392, 21, 2397, 26, 2397, 
	21, 2392, 26, 2392, 39, 39, 39, 40, 
	60, 42, 43, 61, 45, 46, 40, 60, 
	42, 43, 61, 45, 46, 39, 39, 39, 
	39, 39, 39, 21, 2176, 26, 2176, 39, 
	39, 39, 40, 60, 42, 43, 61, 45, 
	46, 40, 60, 42, 43, 61, 45, 46, 
	39, 39, 39, 39, 39, 39, 21, 2416, 
	26, 2416, 21, 2420, 26, 2420, 21, 2423, 
	26, 2423, 21, 2427, 204, 2427, 202, 200, 
	2416, 26, 2416, 39, 39, 39, 40, 60, 
	42, 43, 61, 45, 46, 40, 60, 42, 
	43, 61, 45, 46, 39, 39, 39, 39, 
	39, 39, 21, 0
};

static const short _thttp_machine_parser_header_WWW_Authenticate_trans_targs[] = {
	2, 0, 1736, 3, 4, 5, 6, 7, 
	8, 9, 10, 11, 12, 13, 14, 15, 
	16, 17, 18, 19, 20, 21, 23, 1734, 
	26, 1728, 22, 1738, 24, 1739, 25, 27, 
	28, 29, 30, 31, 32, 31, 32, 34, 
	41, 1536, 56, 110, 1712, 147, 165, 1740, 
	33, 35, 42, 34, 38, 44, 35, 36, 
	38, 1741, 37, 39, 43, 129, 1742, 40, 
	1520, 1743, 1505, 45, 73, 49, 74, 1744, 
	46, 47, 1745, 48, 50, 51, 206, 1746, 
	52, 55, 52, 53, 1747, 54, 1748, 57, 
	58, 59, 60, 61, 109, 64, 61, 62, 
	1749, 63, 64, 65, 69, 1750, 66, 67, 
	1751, 68, 69, 70, 71, 72, 1752, 52, 
	55, 38, 75, 108, 76, 79, 77, 78, 
	80, 95, 81, 93, 82, 83, 91, 84, 
	85, 89, 86, 87, 88, 90, 92, 94, 
	96, 104, 97, 100, 98, 99, 101, 102, 
	103, 105, 106, 107, 1753, 111, 112, 113, 
	114, 115, 116, 128, 119, 116, 117, 1754, 
	118, 119, 120, 124, 1755, 121, 122, 1756, 
	123, 124, 125, 126, 127, 1757, 52, 55, 
	38, 1758, 130, 131, 132, 1504, 135, 132, 
	133, 1759, 134, 136, 140, 1760, 137, 138, 
	1761, 139, 141, 142, 184, 144, 185, 141, 
	142, 184, 144, 185, 143, 1762, 144, 145, 
	1763, 146, 55, 148, 149, 150, 151, 152, 
	164, 155, 152, 153, 1764, 154, 155, 156, 
	160, 1765, 157, 158, 1766, 159, 160, 161, 
	162, 163, 1767, 52, 55, 38, 1768, 166, 
	167, 168, 169, 170, 183, 173, 170, 171, 
	1769, 172, 174, 176, 181, 1770, 175, 177, 
	178, 179, 180, 52, 55, 38, 182, 1771, 
	1772, 186, 186, 187, 191, 1773, 188, 189, 
	1774, 190, 192, 194, 244, 261, 1429, 1443, 
	1458, 1471, 1485, 1775, 193, 195, 243, 194, 
	191, 198, 195, 196, 1776, 197, 199, 207, 
	203, 208, 1777, 200, 201, 1778, 202, 204, 
	189, 204, 205, 1779, 209, 242, 210, 213, 
	211, 212, 214, 229, 215, 227, 216, 217, 
	225, 218, 219, 223, 220, 221, 222, 224, 
	226, 228, 230, 238, 231, 234, 232, 233, 
	235, 236, 237, 239, 240, 241, 1780, 245, 
	246, 247, 248, 249, 250, 251, 252, 253, 
	260, 256, 253, 254, 1781, 255, 257, 259, 
	1782, 258, 204, 189, 259, 191, 1783, 262, 
	263, 264, 265, 266, 267, 1428, 270, 267, 
	268, 1784, 269, 271, 275, 1785, 272, 273, 
	1786, 274, 276, 277, 281, 297, 144, 284, 
	280, 276, 277, 279, 144, 280, 278, 1787, 
	1788, 186, 281, 282, 284, 1789, 283, 285, 
	287, 1324, 1341, 1354, 1368, 1383, 1395, 1409, 
	1790, 286, 288, 1323, 287, 284, 291, 288, 
	289, 1791, 290, 292, 296, 1287, 1792, 293, 
	294, 1793, 295, 281, 297, 1794, 299, 306, 
	298, 302, 308, 299, 300, 302, 1795, 301, 
	303, 298, 305, 307, 318, 917, 968, 984, 
	998, 1796, 304, 1271, 1797, 1259, 309, 313, 
	931, 1798, 310, 311, 1799, 312, 314, 317, 
	314, 315, 1800, 316, 1801, 319, 320, 321, 
	322, 323, 1258, 326, 323, 324, 1802, 325, 
	326, 327, 331, 1803, 328, 329, 1804, 330, 
	331, 331, 332, 336, 1805, 333, 334, 1806, 
	335, 337, 339, 389, 406, 422, 437, 1211, 
	1224, 1239, 1807, 338, 340, 388, 339, 336, 
	343, 340, 341, 1808, 342, 344, 349, 348, 
	352, 1809, 345, 346, 1810, 347, 204, 189, 
	191, 350, 334, 350, 351, 1811, 353, 387, 
	354, 357, 367, 355, 356, 358, 374, 359, 
	372, 360, 361, 370, 362, 363, 368, 364, 
	365, 366, 369, 371, 373, 375, 383, 376, 
	379, 377, 378, 380, 381, 382, 384, 385, 
	386, 1812, 390, 391, 392, 393, 394, 395, 
	396, 397, 398, 405, 401, 398, 399, 1813, 
	400, 402, 404, 1814, 403, 350, 334, 404, 
	336, 1815, 407, 408, 409, 410, 411, 412, 
	421, 415, 412, 413, 1816, 414, 416, 420, 
	1817, 417, 418, 1818, 419, 281, 297, 284, 
	1819, 423, 424, 425, 426, 427, 436, 430, 
	427, 428, 1820, 429, 430, 431, 435, 1821, 
	432, 433, 1822, 434, 435, 350, 334, 336, 
	1823, 438, 439, 440, 441, 442, 443, 1210, 
	446, 443, 444, 1824, 445, 446, 447, 451, 
	1825, 448, 449, 1826, 450, 451, 452, 469, 
	455, 452, 453, 455, 1827, 454, 456, 458, 
	507, 524, 540, 555, 571, 1176, 1191, 1828, 
	457, 459, 506, 458, 455, 462, 459, 460, 
	1829, 461, 463, 468, 467, 470, 1830, 464, 
	465, 1831, 466, 204, 189, 191, 452, 469, 
	1832, 471, 505, 472, 475, 485, 473, 474, 
	476, 492, 477, 490, 478, 479, 488, 480, 
	481, 486, 482, 483, 484, 487, 489, 491, 
	493, 501, 494, 497, 495, 496, 498, 499, 
	500, 502, 503, 504, 1833, 508, 509, 510, 
	511, 512, 513, 514, 515, 516, 523, 519, 
	516, 517, 1834, 518, 520, 522, 1835, 521, 
	452, 469, 522, 455, 1836, 525, 526, 527, 
	528, 529, 530, 539, 533, 530, 531, 1837, 
	532, 534, 538, 1838, 535, 536, 1839, 537, 
	281, 297, 284, 1840, 541, 542, 543, 544, 
	545, 554, 548, 545, 546, 1841, 547, 548, 
	549, 553, 1842, 550, 551, 1843, 552, 553, 
	350, 334, 336, 1844, 556, 557, 558, 559, 
	560, 561, 570, 564, 561, 562, 1845, 563, 
	564, 565, 569, 1846, 566, 567, 1847, 568, 
	569, 452, 469, 455, 1848, 572, 573, 574, 
	1175, 577, 574, 575, 1849, 576, 578, 582, 
	1850, 579, 580, 1851, 581, 583, 599, 586, 
	583, 584, 586, 1852, 585, 587, 589, 1071, 
	1088, 1103, 1117, 1132, 1142, 1156, 1853, 588, 
	590, 1070, 589, 586, 593, 590, 591, 1854, 
	592, 594, 598, 1034, 1855, 595, 596, 1856, 
	597, 583, 599, 1857, 601, 608, 600, 604, 
	610, 601, 602, 604, 1858, 603, 605, 600, 
	607, 609, 620, 670, 688, 698, 881, 1859, 
	606, 1018, 1860, 900, 611, 615, 633, 1861, 
	612, 613, 1862, 614, 616, 619, 616, 617, 
	1863, 618, 1864, 621, 622, 623, 624, 625, 
	669, 628, 625, 626, 1865, 627, 628, 629, 
	331, 1866, 630, 631, 1867, 632, 331, 634, 
	668, 635, 638, 648, 636, 637, 639, 655, 
	640, 653, 641, 642, 651, 643, 644, 649, 
	645, 646, 647, 650, 652, 654, 656, 664, 
	657, 660, 658, 659, 661, 662, 663, 665, 
	666, 667, 1868, 671, 672, 673, 674, 675, 
	676, 687, 679, 676, 677, 1869, 678, 679, 
	680, 684, 1870, 681, 682, 1871, 683, 684, 
	684, 685, 1872, 686, 469, 1873, 689, 690, 
	691, 697, 694, 691, 692, 1874, 693, 695, 
	1875, 696, 1876, 699, 700, 701, 702, 703, 
	880, 706, 703, 704, 1877, 705, 706, 707, 
	711, 1878, 708, 709, 1879, 710, 711, 711, 
	712, 716, 1880, 713, 714, 1881, 715, 717, 
	719, 769, 786, 802, 817, 833, 846, 861, 
	1882, 718, 720, 768, 719, 716, 723, 720, 
	721, 1883, 722, 724, 729, 728, 732, 1884, 
	725, 726, 1885, 727, 204, 189, 191, 730, 
	714, 730, 731, 1886, 733, 767, 734, 737, 
	747, 735, 736, 738, 754, 739, 752, 740, 
	741, 750, 742, 743, 748, 744, 745, 746, 
	749, 751, 753, 755, 763, 756, 759, 757, 
	758, 760, 761, 762, 764, 765, 766, 1887, 
	770, 771, 772, 773, 774, 775, 776, 777, 
	778, 785, 781, 778, 779, 1888, 780, 782, 
	784, 1889, 783, 730, 714, 784, 716, 1890, 
	787, 788, 789, 790, 791, 792, 801, 795, 
	792, 793, 1891, 794, 796, 800, 1892, 797, 
	798, 1893, 799, 281, 297, 284, 1894, 803, 
	804, 805, 806, 807, 816, 810, 807, 808, 
	1895, 809, 810, 811, 815, 1896, 812, 813, 
	1897, 814, 815, 350, 334, 336, 1898, 818, 
	819, 820, 821, 822, 823, 832, 826, 823, 
	824, 1899, 825, 826, 827, 831, 1900, 828, 
	829, 1901, 830, 831, 452, 469, 455, 1902, 
	834, 835, 836, 845, 839, 836, 837, 1903, 
	838, 840, 844, 1904, 841, 842, 1905, 843, 
	583, 599, 586, 1906, 847, 848, 849, 850, 
	851, 860, 854, 851, 852, 1907, 853, 854, 
	855, 859, 1908, 856, 857, 1909, 858, 859, 
	730, 714, 716, 1910, 862, 863, 864, 865, 
	866, 879, 869, 866, 867, 1911, 868, 870, 
	872, 877, 1912, 871, 873, 874, 875, 876, 
	730, 714, 716, 878, 1913, 1914, 882, 883, 
	884, 885, 886, 899, 889, 886, 887, 1915, 
	888, 890, 892, 897, 1916, 891, 893, 894, 
	895, 896, 616, 619, 604, 898, 1917, 901, 
	902, 903, 904, 905, 1017, 908, 905, 906, 
	1918, 907, 909, 913, 1919, 910, 911, 1920, 
	912, 914, 915, 284, 914, 915, 1921, 916, 
	297, 918, 919, 920, 921, 922, 923, 967, 
	926, 923, 924, 1922, 925, 926, 927, 684, 
	1923, 928, 929, 1924, 930, 684, 932, 966, 
	933, 936, 946, 934, 935, 937, 953, 938, 
	951, 939, 940, 949, 941, 942, 947, 943, 
	944, 945, 948, 950, 952, 954, 962, 955, 
	958, 956, 957, 959, 960, 961, 963, 964, 
	965, 1925, 969, 970, 971, 983, 974, 971, 
	972, 1926, 973, 975, 979, 1927, 976, 977, 
	1928, 978, 980, 981, 586, 980, 981, 1929, 
	982, 599, 1930, 985, 986, 987, 988, 989, 
	997, 992, 989, 990, 1931, 991, 992, 993, 
	711, 1932, 994, 995, 1933, 996, 711, 1934, 
	999, 1000, 1001, 1002, 1003, 1016, 1006, 1003, 
	1004, 1935, 1005, 1007, 1009, 1014, 1936, 1008, 
	1010, 1011, 1012, 1013, 314, 317, 302, 1015, 
	1937, 1938, 1019, 1020, 1021, 1022, 1023, 1024, 
	1025, 1026, 1033, 1029, 1026, 1027, 1939, 1028, 
	1030, 1032, 1940, 1031, 616, 619, 1032, 604, 
	1941, 1035, 1069, 1036, 1039, 1049, 1037, 1038, 
	1040, 1056, 1041, 1054, 1042, 1043, 1052, 1044, 
	1045, 1050, 1046, 1047, 1048, 1051, 1053, 1055, 
	1057, 1065, 1058, 1061, 1059, 1060, 1062, 1063, 
	1064, 1066, 1067, 1068, 1942, 1072, 1073, 1074, 
	1075, 1076, 1077, 1078, 1079, 1080, 1087, 1083, 
	1080, 1081, 1943, 1082, 1084, 1086, 1944, 1085, 
	583, 599, 1086, 586, 1945, 1089, 1090, 1091, 
	1092, 1093, 1094, 1102, 1097, 1094, 1095, 1946, 
	1096, 1098, 1947, 1099, 1100, 1948, 1101, 1949, 
	1104, 1105, 1106, 1107, 1108, 1116, 1111, 1108, 
	1109, 1950, 1110, 1111, 1112, 1951, 1113, 1114, 
	1952, 1115, 1953, 1118, 1119, 1120, 1121, 1122, 
	1123, 1131, 1126, 1123, 1124, 1954, 1125, 1126, 
	1127, 1955, 1128, 1129, 1956, 1130, 1957, 1133, 
	1134, 1135, 1141, 1138, 1135, 1136, 1958, 1137, 
	1139, 1959, 1140, 1960, 1143, 1144, 1145, 1146, 
	1147, 1155, 1150, 1147, 1148, 1961, 1149, 1150, 
	1151, 1962, 1152, 1153, 1963, 1154, 1964, 1157, 
	1158, 1159, 1160, 1161, 1174, 1164, 1161, 1162, 
	1965, 1163, 1165, 1167, 1172, 1966, 1166, 1168, 
	1169, 1170, 1171, 583, 599, 586, 1173, 1967, 
	1968, 1177, 1178, 1179, 1180, 1181, 1190, 1184, 
	1181, 1182, 1969, 1183, 1184, 1185, 1189, 1970, 
	1186, 1187, 1971, 1188, 1189, 730, 714, 716, 
	1972, 1192, 1193, 1194, 1195, 1196, 1209, 1199, 
	1196, 1197, 1973, 1198, 1200, 1202, 1207, 1974, 
	1201, 1203, 1204, 1205, 1206, 452, 469, 455, 
	1208, 1975, 1976, 1212, 1213, 1214, 1223, 1217, 
	1214, 1215, 1977, 1216, 1218, 1222, 1978, 1219, 
	1220, 1979, 1221, 583, 599, 586, 1980, 1225, 
	1226, 1227, 1228, 1229, 1238, 1232, 1229, 1230, 
	1981, 1231, 1232, 1233, 1237, 1982, 1234, 1235, 
	1983, 1236, 1237, 730, 714, 716, 1984, 1240, 
	1241, 1242, 1243, 1244, 1257, 1247, 1244, 1245, 
	1985, 1246, 1248, 1250, 1255, 1986, 1249, 1251, 
	1252, 1253, 1254, 350, 334, 336, 1256, 1987, 
	1988, 1260, 1261, 1262, 1263, 1264, 1270, 1267, 
	1264, 1265, 1989, 1266, 1268, 1990, 1269, 1991, 
	1272, 1273, 1274, 1275, 1276, 1277, 1278, 1279, 
	1286, 1282, 1279, 1280, 1992, 1281, 1283, 1285, 
	1993, 1284, 314, 317, 1285, 302, 1994, 1288, 
	1322, 1289, 1292, 1302, 1290, 1291, 1293, 1309, 
	1294, 1307, 1295, 1296, 1305, 1297, 1298, 1303, 
	1299, 1300, 1301, 1304, 1306, 1308, 1310, 1318, 
	1311, 1314, 1312, 1313, 1315, 1316, 1317, 1319, 
	1320, 1321, 1995, 1325, 1326, 1327, 1328, 1329, 
	1330, 1331, 1332, 1333, 1340, 1336, 1333, 1334, 
	1996, 1335, 1337, 1339, 1997, 1338, 281, 297, 
	1339, 284, 1998, 1342, 1343, 1344, 1345, 1346, 
	1347, 1353, 1350, 1347, 1348, 1999, 1349, 1351, 
	2000, 1352, 2001, 1355, 1356, 1357, 1358, 1359, 
	1367, 1362, 1359, 1360, 2002, 1361, 1362, 1363, 
	2003, 1364, 1365, 2004, 1366, 2005, 1369, 1370, 
	1371, 1372, 1373, 1374, 1382, 1377, 1374, 1375, 
	2006, 1376, 1377, 1378, 2007, 1379, 1380, 2008, 
	1381, 2009, 1384, 1385, 1386, 1394, 1389, 1386, 
	1387, 2010, 1388, 1390, 2011, 1391, 1392, 2012, 
	1393, 2013, 1396, 1397, 1398, 1399, 1400, 1408, 
	1403, 1400, 1401, 2014, 1402, 1403, 1404, 2015, 
	1405, 1406, 2016, 1407, 2017, 1410, 1411, 1412, 
	1413, 1414, 1427, 1417, 1414, 1415, 2018, 1416, 
	1418, 1420, 1425, 2019, 1419, 1421, 1422, 1423, 
	1424, 281, 297, 284, 1426, 2020, 2021, 1430, 
	1431, 1432, 1433, 1434, 1442, 1437, 1434, 1435, 
	2022, 1436, 1437, 1438, 367, 2023, 1439, 1440, 
	2024, 1441, 2025, 1444, 1445, 1446, 1447, 1448, 
	1449, 1457, 1452, 1449, 1450, 2026, 1451, 1452, 
	1453, 485, 2027, 1454, 1455, 2028, 1456, 2029, 
	1459, 1460, 1461, 1470, 1464, 1461, 1462, 2030, 
	1463, 1465, 1469, 2031, 1466, 1467, 2032, 1468, 
	583, 599, 586, 2033, 1472, 1473, 1474, 1475, 
	1476, 1484, 1479, 1476, 1477, 2034, 1478, 1479, 
	1480, 747, 2035, 1481, 1482, 2036, 1483, 2037, 
	1486, 1487, 1488, 1489, 1490, 1503, 1493, 1490, 
	1491, 2038, 1492, 1494, 1496, 1501, 2039, 1495, 
	1497, 1498, 1499, 1500, 204, 189, 191, 1502, 
	2040, 2041, 1506, 1507, 1508, 1509, 1510, 1519, 
	1513, 1510, 1511, 2042, 1512, 1514, 1518, 2043, 
	1515, 1516, 2044, 1517, 279, 2045, 1521, 1522, 
	1523, 1524, 1525, 1526, 1527, 1528, 1535, 1531, 
	1528, 1529, 2046, 1530, 1532, 1534, 2047, 1533, 
	52, 55, 1534, 38, 2048, 1537, 1538, 1539, 
	1540, 1541, 1542, 1711, 1545, 1542, 1543, 2049, 
	1544, 1546, 1550, 2050, 1547, 1548, 2051, 1549, 
	1551, 1552, 1553, 1551, 1552, 1553, 2052, 1554, 
	1554, 1555, 1559, 2053, 1556, 1557, 2054, 1558, 
	1560, 1562, 1609, 1626, 1642, 1654, 1667, 1680, 
	1692, 2055, 1561, 1563, 1608, 1562, 1559, 1566, 
	1563, 1564, 2056, 1565, 1567, 1569, 1572, 2057, 
	1568, 1570, 1557, 1570, 1571, 2058, 1573, 1607, 
	1574, 1577, 1587, 1575, 1576, 1578, 1594, 1579, 
	1592, 1580, 1581, 1590, 1582, 1583, 1588, 1584, 
	1585, 1586, 1589, 1591, 1593, 1595, 1603, 1596, 
	1599, 1597, 1598, 1600, 1601, 1602, 1604, 1605, 
	1606, 2059, 1610, 1611, 1612, 1613, 1614, 1615, 
	1616, 1617, 1618, 1625, 1621, 1618, 1619, 2060, 
	1620, 1622, 1624, 2061, 1623, 1570, 1557, 1624, 
	1559, 2062, 1627, 1628, 1629, 1630, 1631, 1632, 
	1641, 1635, 1632, 1633, 2063, 1634, 1636, 1640, 
	2064, 1637, 1638, 2065, 1639, 281, 297, 284, 
	2066, 1643, 1644, 1645, 1646, 1647, 1653, 1650, 
	1647, 1648, 2067, 1649, 1650, 1651, 2068, 1652, 
	2069, 1655, 1656, 1657, 1658, 1659, 1660, 1666, 
	1663, 1660, 1661, 2070, 1662, 1663, 1664, 2071, 
	1665, 2072, 1668, 1669, 1670, 1679, 1673, 1670, 
	1671, 2073, 1672, 1674, 1678, 2074, 1675, 1676, 
	2075, 1677, 583, 599, 586, 2076, 1681, 1682, 
	1683, 1684, 1685, 1691, 1688, 1685, 1686, 2077, 
	1687, 1688, 1689, 2078, 1690, 2079, 1693, 1694, 
	1695, 1696, 1697, 1710, 1700, 1697, 1698, 2080, 
	1699, 1701, 1703, 1708, 2081, 1702, 1704, 1705, 
	1706, 1707, 1570, 1557, 1559, 1709, 2082, 2083, 
	1713, 1714, 1715, 1727, 1718, 1715, 1716, 2084, 
	1717, 1719, 1723, 2085, 1720, 1721, 2086, 1722, 
	1724, 1725, 1726, 1724, 1725, 1726, 2087, 1554, 
	2088, 1729, 1730, 1731, 1732, 1733, 31, 32, 
	1735, 1737, 66, 121, 157, 328, 432, 448, 
	550, 566, 630, 681, 708, 812, 828, 856, 
	928, 994, 1113, 1128, 1152, 1186, 1234, 1364, 
	1379, 1405, 1439, 1454, 1481, 1652, 1665, 1690
};

static const char _thttp_machine_parser_header_WWW_Authenticate_trans_actions[] = {
	9, 0, 7, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 27, 0, 27, 0, 0, 
	0, 0, 0, 5, 5, 0, 0, 1, 
	1, 1, 1, 1, 1, 1, 1, 27, 
	0, 25, 25, 0, 25, 0, 0, 0, 
	0, 27, 0, 0, 1, 1, 27, 0, 
	0, 27, 0, 0, 0, 0, 0, 27, 
	0, 0, 27, 0, 0, 0, 0, 27, 
	25, 25, 0, 0, 27, 0, 27, 0, 
	0, 0, 0, 25, 25, 0, 0, 0, 
	27, 0, 1, 1, 1, 27, 1, 1, 
	27, 0, 0, 0, 0, 0, 27, 15, 
	15, 15, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 27, 0, 0, 0, 
	0, 0, 25, 25, 0, 0, 0, 27, 
	0, 1, 1, 1, 27, 1, 1, 27, 
	0, 0, 0, 0, 0, 27, 17, 17, 
	17, 27, 0, 0, 25, 25, 0, 0, 
	0, 27, 0, 0, 0, 27, 0, 0, 
	27, 0, 1, 1, 1, 38, 1, 0, 
	0, 0, 23, 0, 0, 27, 0, 0, 
	27, 0, 0, 0, 0, 0, 0, 25, 
	25, 0, 0, 0, 27, 0, 1, 1, 
	1, 27, 1, 1, 27, 0, 0, 0, 
	0, 0, 27, 11, 11, 11, 27, 0, 
	0, 0, 0, 25, 25, 0, 0, 0, 
	27, 0, 0, 1, 1, 27, 0, 0, 
	0, 0, 0, 19, 19, 19, 0, 27, 
	27, 23, 0, 0, 0, 27, 0, 0, 
	27, 0, 0, 1, 1, 1, 1, 1, 
	1, 1, 1, 27, 0, 25, 25, 0, 
	25, 0, 0, 0, 27, 0, 0, 0, 
	0, 0, 27, 0, 0, 27, 0, 25, 
	25, 0, 0, 27, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 27, 0, 
	0, 0, 0, 0, 0, 0, 0, 25, 
	25, 0, 0, 0, 27, 0, 0, 1, 
	27, 0, 21, 21, 0, 21, 27, 0, 
	0, 0, 0, 0, 25, 25, 0, 0, 
	0, 27, 0, 0, 0, 27, 0, 0, 
	27, 0, 1, 1, 41, 41, 29, 41, 
	1, 0, 0, 0, 13, 0, 0, 27, 
	27, 13, 0, 0, 0, 27, 0, 0, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	27, 0, 25, 25, 0, 25, 0, 0, 
	0, 27, 0, 0, 0, 0, 27, 0, 
	0, 27, 0, 25, 25, 27, 25, 25, 
	0, 25, 0, 0, 0, 0, 27, 0, 
	0, 1, 1, 1, 1, 1, 1, 1, 
	1, 27, 0, 0, 27, 0, 0, 0, 
	0, 27, 0, 0, 27, 0, 25, 25, 
	0, 0, 27, 0, 27, 0, 0, 0, 
	0, 25, 25, 0, 0, 0, 27, 0, 
	1, 1, 47, 27, 1, 1, 27, 0, 
	13, 0, 0, 0, 27, 0, 0, 27, 
	0, 0, 1, 1, 1, 1, 1, 1, 
	1, 1, 27, 0, 25, 25, 0, 25, 
	0, 0, 0, 27, 0, 0, 0, 0, 
	0, 27, 0, 0, 27, 0, 15, 15, 
	15, 25, 25, 0, 0, 27, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 27, 0, 0, 0, 0, 0, 0, 
	0, 0, 25, 25, 0, 0, 0, 27, 
	0, 0, 1, 27, 0, 21, 21, 0, 
	21, 27, 0, 0, 0, 0, 0, 25, 
	25, 0, 0, 0, 27, 0, 0, 0, 
	27, 0, 0, 27, 0, 32, 32, 32, 
	27, 0, 0, 0, 0, 25, 25, 0, 
	0, 0, 27, 0, 1, 1, 1, 27, 
	1, 1, 27, 0, 0, 15, 15, 15, 
	27, 0, 0, 0, 0, 0, 25, 25, 
	0, 0, 0, 27, 0, 1, 1, 1, 
	27, 1, 1, 27, 0, 0, 15, 15, 
	15, 0, 0, 0, 27, 0, 0, 1, 
	1, 1, 1, 1, 1, 1, 1, 27, 
	0, 25, 25, 0, 25, 0, 0, 0, 
	27, 0, 0, 0, 0, 0, 27, 0, 
	0, 27, 0, 17, 17, 17, 25, 25, 
	27, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 27, 0, 0, 0, 
	0, 0, 0, 0, 0, 25, 25, 0, 
	0, 0, 27, 0, 0, 1, 27, 0, 
	21, 21, 0, 21, 27, 0, 0, 0, 
	0, 0, 25, 25, 0, 0, 0, 27, 
	0, 0, 0, 27, 0, 0, 27, 0, 
	35, 35, 35, 27, 0, 0, 0, 0, 
	25, 25, 0, 0, 0, 27, 0, 1, 
	1, 1, 27, 1, 1, 27, 0, 0, 
	17, 17, 17, 27, 0, 0, 0, 0, 
	0, 25, 25, 0, 0, 0, 27, 0, 
	1, 1, 1, 27, 1, 1, 27, 0, 
	0, 17, 17, 17, 27, 0, 0, 25, 
	25, 0, 0, 0, 27, 0, 0, 0, 
	27, 0, 0, 27, 0, 53, 53, 53, 
	0, 0, 0, 27, 0, 0, 1, 1, 
	1, 1, 1, 1, 1, 1, 27, 0, 
	25, 25, 0, 25, 0, 0, 0, 27, 
	0, 0, 0, 0, 27, 0, 0, 27, 
	0, 25, 25, 27, 25, 25, 0, 25, 
	0, 0, 0, 0, 27, 0, 0, 1, 
	1, 1, 1, 1, 1, 1, 1, 27, 
	0, 0, 27, 0, 0, 0, 0, 27, 
	0, 0, 27, 0, 25, 25, 0, 0, 
	27, 0, 27, 0, 0, 0, 0, 25, 
	25, 0, 0, 0, 27, 0, 1, 1, 
	38, 27, 1, 1, 27, 0, 23, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 27, 0, 0, 0, 0, 0, 
	25, 25, 0, 0, 0, 27, 0, 1, 
	1, 38, 27, 1, 1, 27, 0, 23, 
	0, 0, 27, 0, 0, 27, 0, 0, 
	25, 25, 0, 0, 0, 27, 0, 0, 
	27, 0, 27, 0, 0, 0, 0, 25, 
	25, 0, 0, 0, 27, 0, 1, 1, 
	38, 27, 1, 1, 27, 0, 23, 0, 
	0, 0, 27, 0, 0, 27, 0, 0, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	27, 0, 25, 25, 0, 25, 0, 0, 
	0, 27, 0, 0, 0, 0, 0, 27, 
	0, 0, 27, 0, 11, 11, 11, 25, 
	25, 0, 0, 27, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 27, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	25, 25, 0, 0, 0, 27, 0, 0, 
	1, 27, 0, 21, 21, 0, 21, 27, 
	0, 0, 0, 0, 0, 25, 25, 0, 
	0, 0, 27, 0, 0, 0, 27, 0, 
	0, 27, 0, 44, 44, 44, 27, 0, 
	0, 0, 0, 25, 25, 0, 0, 0, 
	27, 0, 1, 1, 1, 27, 1, 1, 
	27, 0, 0, 11, 11, 11, 27, 0, 
	0, 0, 0, 0, 25, 25, 0, 0, 
	0, 27, 0, 1, 1, 1, 27, 1, 
	1, 27, 0, 0, 11, 11, 11, 27, 
	0, 0, 25, 25, 0, 0, 0, 27, 
	0, 0, 0, 27, 0, 0, 27, 0, 
	44, 44, 44, 27, 0, 0, 0, 0, 
	25, 25, 0, 0, 0, 27, 0, 1, 
	1, 1, 27, 1, 1, 27, 0, 0, 
	11, 11, 11, 27, 0, 0, 0, 0, 
	25, 25, 0, 0, 0, 27, 0, 0, 
	1, 1, 27, 0, 0, 0, 0, 0, 
	19, 19, 19, 0, 27, 27, 0, 0, 
	0, 0, 25, 25, 0, 0, 0, 27, 
	0, 0, 1, 1, 27, 0, 0, 0, 
	0, 0, 19, 19, 19, 0, 27, 0, 
	0, 0, 0, 25, 25, 0, 0, 0, 
	27, 0, 0, 23, 27, 0, 0, 27, 
	0, 1, 1, 1, 0, 0, 27, 0, 
	0, 0, 0, 0, 0, 0, 25, 25, 
	0, 0, 0, 27, 0, 1, 1, 47, 
	27, 1, 1, 27, 0, 13, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 27, 0, 0, 25, 25, 0, 0, 
	0, 27, 0, 0, 13, 27, 0, 0, 
	27, 0, 1, 1, 1, 0, 0, 27, 
	0, 0, 27, 0, 0, 0, 0, 25, 
	25, 0, 0, 0, 27, 0, 1, 1, 
	29, 27, 1, 1, 27, 0, 13, 27, 
	0, 0, 0, 0, 25, 25, 0, 0, 
	0, 27, 0, 0, 1, 1, 27, 0, 
	0, 0, 0, 0, 19, 19, 19, 0, 
	27, 27, 0, 0, 0, 0, 0, 0, 
	0, 25, 25, 0, 0, 0, 27, 0, 
	0, 1, 27, 0, 21, 21, 0, 21, 
	27, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 27, 0, 0, 0, 
	0, 0, 0, 0, 0, 25, 25, 0, 
	0, 0, 27, 0, 0, 1, 27, 0, 
	21, 21, 0, 21, 27, 0, 0, 0, 
	0, 0, 25, 25, 0, 0, 0, 27, 
	0, 0, 27, 0, 0, 27, 0, 27, 
	0, 0, 0, 0, 25, 25, 0, 0, 
	0, 27, 0, 1, 1, 27, 1, 1, 
	27, 0, 27, 0, 0, 0, 0, 0, 
	25, 25, 0, 0, 0, 27, 0, 1, 
	1, 27, 1, 1, 27, 0, 27, 0, 
	0, 25, 25, 0, 0, 0, 27, 0, 
	0, 27, 0, 27, 0, 0, 0, 0, 
	25, 25, 0, 0, 0, 27, 0, 1, 
	1, 27, 1, 1, 27, 0, 27, 0, 
	0, 0, 0, 25, 25, 0, 0, 0, 
	27, 0, 0, 1, 1, 27, 0, 0, 
	0, 0, 0, 19, 19, 19, 0, 27, 
	27, 0, 0, 0, 0, 25, 25, 0, 
	0, 0, 27, 0, 1, 1, 1, 27, 
	1, 1, 27, 0, 0, 17, 17, 17, 
	27, 0, 0, 0, 0, 25, 25, 0, 
	0, 0, 27, 0, 0, 1, 1, 27, 
	0, 0, 0, 0, 0, 19, 19, 19, 
	0, 27, 27, 0, 0, 25, 25, 0, 
	0, 0, 27, 0, 0, 0, 27, 0, 
	0, 27, 0, 50, 50, 50, 27, 0, 
	0, 0, 0, 25, 25, 0, 0, 0, 
	27, 0, 1, 1, 1, 27, 1, 1, 
	27, 0, 0, 15, 15, 15, 27, 0, 
	0, 0, 0, 25, 25, 0, 0, 0, 
	27, 0, 0, 1, 1, 27, 0, 0, 
	0, 0, 0, 19, 19, 19, 0, 27, 
	27, 0, 0, 0, 0, 25, 25, 0, 
	0, 0, 27, 0, 0, 27, 0, 27, 
	0, 0, 0, 0, 0, 0, 0, 25, 
	25, 0, 0, 0, 27, 0, 0, 1, 
	27, 0, 21, 21, 0, 21, 27, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 27, 0, 0, 0, 0, 0, 
	0, 0, 0, 25, 25, 0, 0, 0, 
	27, 0, 0, 1, 27, 0, 21, 21, 
	0, 21, 27, 0, 0, 0, 0, 0, 
	25, 25, 0, 0, 0, 27, 0, 0, 
	27, 0, 27, 0, 0, 0, 0, 25, 
	25, 0, 0, 0, 27, 0, 1, 1, 
	27, 1, 1, 27, 0, 27, 0, 0, 
	0, 0, 0, 25, 25, 0, 0, 0, 
	27, 0, 1, 1, 27, 1, 1, 27, 
	0, 27, 0, 0, 25, 25, 0, 0, 
	0, 27, 0, 0, 27, 0, 0, 27, 
	0, 27, 0, 0, 0, 0, 25, 25, 
	0, 0, 0, 27, 0, 1, 1, 27, 
	1, 1, 27, 0, 27, 0, 0, 0, 
	0, 25, 25, 0, 0, 0, 27, 0, 
	0, 1, 1, 27, 0, 0, 0, 0, 
	0, 19, 19, 19, 0, 27, 27, 0, 
	0, 0, 0, 25, 25, 0, 0, 0, 
	27, 0, 1, 1, 1, 27, 1, 1, 
	27, 0, 27, 0, 0, 0, 0, 0, 
	25, 25, 0, 0, 0, 27, 0, 1, 
	1, 1, 27, 1, 1, 27, 0, 27, 
	0, 0, 25, 25, 0, 0, 0, 27, 
	0, 0, 0, 27, 0, 0, 27, 0, 
	41, 41, 41, 27, 0, 0, 0, 0, 
	25, 25, 0, 0, 0, 27, 0, 1, 
	1, 1, 27, 1, 1, 27, 0, 27, 
	0, 0, 0, 0, 25, 25, 0, 0, 
	0, 27, 0, 0, 1, 1, 27, 0, 
	0, 0, 0, 0, 19, 19, 19, 0, 
	27, 27, 0, 0, 0, 0, 25, 25, 
	0, 0, 0, 27, 0, 0, 0, 27, 
	0, 0, 27, 0, 1, 27, 0, 0, 
	0, 0, 0, 0, 0, 25, 25, 0, 
	0, 0, 27, 0, 0, 1, 27, 0, 
	21, 21, 0, 21, 27, 0, 0, 0, 
	0, 0, 25, 25, 0, 0, 0, 27, 
	0, 0, 0, 27, 0, 0, 27, 0, 
	1, 1, 1, 0, 0, 0, 27, 13, 
	0, 0, 0, 27, 0, 0, 27, 0, 
	0, 1, 1, 1, 1, 1, 1, 1, 
	1, 27, 0, 25, 25, 0, 25, 0, 
	0, 0, 27, 0, 0, 0, 0, 27, 
	0, 25, 25, 0, 0, 27, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 27, 0, 0, 0, 0, 0, 0, 
	0, 0, 25, 25, 0, 0, 0, 27, 
	0, 0, 1, 27, 0, 21, 21, 0, 
	21, 27, 0, 0, 0, 0, 0, 25, 
	25, 0, 0, 0, 27, 0, 0, 0, 
	27, 0, 0, 27, 0, 56, 56, 56, 
	27, 0, 0, 0, 0, 25, 25, 0, 
	0, 0, 27, 0, 1, 1, 27, 1, 
	27, 0, 0, 0, 0, 0, 25, 25, 
	0, 0, 0, 27, 0, 1, 1, 27, 
	1, 27, 0, 0, 25, 25, 0, 0, 
	0, 27, 0, 0, 0, 27, 0, 0, 
	27, 0, 56, 56, 56, 27, 0, 0, 
	0, 0, 25, 25, 0, 0, 0, 27, 
	0, 1, 1, 27, 1, 27, 0, 0, 
	0, 0, 25, 25, 0, 0, 0, 27, 
	0, 0, 1, 1, 27, 0, 0, 0, 
	0, 0, 19, 19, 19, 0, 27, 27, 
	0, 0, 25, 25, 0, 0, 0, 27, 
	0, 0, 0, 27, 0, 0, 27, 0, 
	1, 1, 1, 0, 0, 0, 27, 23, 
	27, 0, 0, 0, 0, 0, 3, 3, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0
};

static const int thttp_machine_parser_header_WWW_Authenticate_start = 1;
static const int thttp_machine_parser_header_WWW_Authenticate_first_final = 1738;
static const int thttp_machine_parser_header_WWW_Authenticate_error = 0;

static const int thttp_machine_parser_header_WWW_Authenticate_en_main = 1;


/***** MCPTT Client. A1 integration *************/

//size = tsk_strlen("Digest \r\n\trealm=\r\n\r\n") - 2;
  for (i = 0; i < size - 2; i++) { //Final \r\n are accepted
		if (p[i] == '\n' || p[i] == '\r' || p[i] == '\t') {
			for (j = i; j < size; j++) {
				if (j == size - 1)
					p[j] = '\0';
				else
					p[j] = p[j+1];
			}
			i -= 1;
			size -= 1; 
		}
	}

  pe = p + size;
  eof = pe;

/***********************************************/

/* #line 189 "./ragel/thttp_parser_header_WWW_Authenticate.rl" */
	(void)(eof);
	(void)(thttp_machine_parser_header_WWW_Authenticate_first_final);
	(void)(thttp_machine_parser_header_WWW_Authenticate_error);
	(void)(thttp_machine_parser_header_WWW_Authenticate_en_main);
	
/* #line 8068 "./src/headers/thttp_header_WWW_Authenticate.c" */
	{
	cs = thttp_machine_parser_header_WWW_Authenticate_start;
	}

/* #line 194 "./ragel/thttp_parser_header_WWW_Authenticate.rl" */
	
/* #line 8075 "./src/headers/thttp_header_WWW_Authenticate.c" */
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _thttp_machine_parser_header_WWW_Authenticate_trans_keys + _thttp_machine_parser_header_WWW_Authenticate_key_offsets[cs];
	_trans = _thttp_machine_parser_header_WWW_Authenticate_index_offsets[cs];

	_klen = _thttp_machine_parser_header_WWW_Authenticate_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _thttp_machine_parser_header_WWW_Authenticate_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += ((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	_trans = _thttp_machine_parser_header_WWW_Authenticate_indicies[_trans];
	cs = _thttp_machine_parser_header_WWW_Authenticate_trans_targs[_trans];

	if ( _thttp_machine_parser_header_WWW_Authenticate_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _thttp_machine_parser_header_WWW_Authenticate_actions + _thttp_machine_parser_header_WWW_Authenticate_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
/* #line 48 "./ragel/thttp_parser_header_WWW_Authenticate.rl" */
	{
		tag_start = p;
	}
	break;
	case 1:
/* #line 52 "./ragel/thttp_parser_header_WWW_Authenticate.rl" */
	{
		hdr_WWW_Authenticate->scheme = tsk_strdup("Digest");
	}
	break;
	case 2:
/* #line 56 "./ragel/thttp_parser_header_WWW_Authenticate.rl" */
	{
		hdr_WWW_Authenticate->scheme = tsk_strdup("Basic");
	}
	break;
	case 3:
/* #line 60 "./ragel/thttp_parser_header_WWW_Authenticate.rl" */
	{
		THTTP_HEADER(hdr_WWW_Authenticate)->type = thttp_htype_WWW_Authenticate;
	}
	break;
	case 4:
/* #line 64 "./ragel/thttp_parser_header_WWW_Authenticate.rl" */
	{
		THTTP_HEADER(hdr_WWW_Authenticate)->type = thttp_htype_Proxy_Authenticate;
	}
	break;
	case 5:
/* #line 68 "./ragel/thttp_parser_header_WWW_Authenticate.rl" */
	{
		TSK_PARSER_SET_STRING(hdr_WWW_Authenticate->realm);
		tsk_strunquote(&hdr_WWW_Authenticate->realm);
	}
	break;
	case 6:
/* #line 73 "./ragel/thttp_parser_header_WWW_Authenticate.rl" */
	{
		TSK_PARSER_SET_STRING(hdr_WWW_Authenticate->domain);
		//tsk_strunquote(&hdr_WWW_Authenticate->domain);
	}
	break;
	case 7:
/* #line 78 "./ragel/thttp_parser_header_WWW_Authenticate.rl" */
	{
		TSK_PARSER_SET_STRING(hdr_WWW_Authenticate->nonce);
		tsk_strunquote(&hdr_WWW_Authenticate->nonce);
	}
	break;
	case 8:
/* #line 83 "./ragel/thttp_parser_header_WWW_Authenticate.rl" */
	{
		TSK_PARSER_SET_STRING(hdr_WWW_Authenticate->opaque);
		tsk_strunquote(&hdr_WWW_Authenticate->opaque);
	}
	break;
	case 9:
/* #line 88 "./ragel/thttp_parser_header_WWW_Authenticate.rl" */
	{
		hdr_WWW_Authenticate->stale = tsk_strniequals(tag_start, "true", 4);
	}
	break;
	case 10:
/* #line 92 "./ragel/thttp_parser_header_WWW_Authenticate.rl" */
	{
		TSK_PARSER_SET_STRING(hdr_WWW_Authenticate->algorithm);
	}
	break;
	case 11:
/* #line 96 "./ragel/thttp_parser_header_WWW_Authenticate.rl" */
	{
		TSK_PARSER_SET_STRING(hdr_WWW_Authenticate->qop);
		//tsk_strunquote(&hdr_WWW_Authenticate->qop);
	}
	break;
	case 12:
/* #line 101 "./ragel/thttp_parser_header_WWW_Authenticate.rl" */
	{
		TSK_PARSER_ADD_PARAM(THTTP_HEADER_PARAMS(hdr_WWW_Authenticate));
	}
	break;
	case 13:
/* #line 109 "./ragel/thttp_parser_header_WWW_Authenticate.rl" */
	{
	}
	break;
/* #line 8237 "./src/headers/thttp_header_WWW_Authenticate.c" */
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	_out: {}
	}

/* #line 195 "./ragel/thttp_parser_header_WWW_Authenticate.rl" */
	TSK_RAGEL_DISABLE_WARNINGS_END()
	
	if( cs < 
/* #line 8254 "./src/headers/thttp_header_WWW_Authenticate.c" */
1738
/* #line 197 "./ragel/thttp_parser_header_WWW_Authenticate.rl" */
 ){
		TSK_DEBUG_ERROR("Failed to parse WWW-Authenticate header.");
		TSK_OBJECT_SAFE_FREE(hdr_WWW_Authenticate);
	}
	
	return hdr_WWW_Authenticate;
}

thttp_header_Proxy_Authenticate_t *thttp_header_Proxy_Authenticate_parse(const char *data, tsk_size_t size)
{
	return thttp_header_WWW_Authenticate_parse(data, size);
}





//========================================================
//	WWW_Authenticate header object definition
//

static tsk_object_t* thttp_header_WWW_Authenticate_ctor(tsk_object_t *self, va_list * app)
{
	thttp_header_WWW_Authenticate_t *WWW_Authenticate = self;
	if(WWW_Authenticate){
		THTTP_HEADER(WWW_Authenticate)->type = thttp_htype_WWW_Authenticate;
		THTTP_HEADER(WWW_Authenticate)->tostring = thttp_header_WWW_Authenticate_tostring;
	}
	else{
		TSK_DEBUG_ERROR("Failed to create new WWW_Authenticate header.");
	}
	return self;
}

static tsk_object_t* thttp_header_WWW_Authenticate_dtor(tsk_object_t *self)
{
	thttp_header_WWW_Authenticate_t *WWW_Authenticate = self;
	if(WWW_Authenticate){
		TSK_FREE(WWW_Authenticate->scheme);
		TSK_FREE(WWW_Authenticate->realm);
		TSK_FREE(WWW_Authenticate->domain);
		TSK_FREE(WWW_Authenticate->nonce);
		TSK_FREE(WWW_Authenticate->opaque);
		TSK_FREE(WWW_Authenticate->algorithm);
		TSK_FREE(WWW_Authenticate->qop);

		TSK_OBJECT_SAFE_FREE(THTTP_HEADER_PARAMS(WWW_Authenticate));
	}
	else{
		TSK_DEBUG_ERROR("Null WWW_Authenticate header.");
	}

	return self;
}

static const tsk_object_def_t thttp_header_WWW_Authenticate_def_s = 
{
	sizeof(thttp_header_WWW_Authenticate_t),
	thttp_header_WWW_Authenticate_ctor,
	thttp_header_WWW_Authenticate_dtor,
	tsk_null
};
const tsk_object_def_t *thttp_header_WWW_Authenticate_def_t = &thttp_header_WWW_Authenticate_def_s;
