/*
 *

 *   Copyright (C) 2017, University of the Basque Country (UPV/EHU)
 *
 *  Contact for licensing options: <licensing-mcpttclient(at)mcopenplatform(dot)com>
 *
 *  This file is part of MCOP MCPTT Client
 *
 *  This is free software: you can redistribute it and/or modify it under the terms of
 *  the GNU General Public License as published by the Free Software Foundation, either version 3
 *  of the License, or (at your option) any later version.
 *
 *  This is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 *  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package org.doubango.ngn.services.preference;

import android.content.Context;

import org.doubango.utils.Utils;


public interface IPreferencesManager {
 static String TAG = Utils.getTAG(IPreferencesManager.class.getCanonicalName());

 public static final String  STRING_DEFAULT=TAG+".STRING_DEFAULT";


 boolean putString(Context context,String key,String data);

     String getString(Context context,String key);

     String getString(Context context,String key,String defaultString);

     boolean putInt(Context context,String key,Integer data);

     int getInt(Context context,String key);

     boolean putLong(Context context,String key,Long data);
     long getLong(Context context,String key);


     boolean putFloat(Context context,String key,Float data);

     float getFloat(Context context,String key);

}
