/*
* Copyright (C) 2017, University of the Basque Country (UPV/EHU)
* Contact for licensing options: <licensing-mcpttclient(at)mcopenplatform(dot)com>
*
* The original file was part of Open Source Doubango Framework
* Copyright (C) 2010-2011 Mamadou Diop.
* Copyright (C) 2012 Doubango Telecom <http://doubango.org>
*
* This file is part of Open Source Doubango Framework.
*
* DOUBANGO is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* DOUBANGO is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with DOUBANGO.
*
*/

/**@file tsip_header_Expires.h
 * @brief SIP header 'Expires'.
 *
 * @author Mamadou Diop <diopmamadou(at)doubango[dot]org>
 *

 */
#ifndef _TSIP_HEADER_EXPIRES_H_
#define _TSIP_HEADER_EXPIRES_H_

#include "tinysip_config.h"
#include "tinysip/headers/tsip_header.h"

TSIP_BEGIN_DECLS

#define TSIP_HEADER_EXPIRES_VA_ARGS(delta_seconds)		tsip_header_Expires_def_t, (int64_t)delta_seconds

#define TSIP_HEADER_EXPIRES_NONE						-1
#define TSIP_HEADER_EXPIRES_DEFAULT						600000

////////////////////////////////////////////////////////////////////////////////////////////////////
///
/// @brief	SIP header 'Expires'.
///
/// @par ABNF: Expires	= 	"Expires" HCOLON delta-seconds
/// 	
////////////////////////////////////////////////////////////////////////////////////////////////////
typedef struct tsip_header_Expires_s
{	
	TSIP_DECLARE_HEADER;

	int64_t delta_seconds;
}
tsip_header_Expires_t;

TINYSIP_API tsip_header_Expires_t* tsip_header_Expires_create(int64_t delta_seconds);

TINYSIP_API tsip_header_Expires_t *tsip_header_Expires_parse(const char *data, tsk_size_t size);

TINYSIP_GEXTERN const tsk_object_def_t *tsip_header_Expires_def_t;

TSIP_END_DECLS

#endif /* _TSIP_HEADER_EXPIRES_H_ */

