#if HAVE_CRT
#define _CRTDBG_MAP_ALLOC 
#include <stdlib.h> 
#include <crtdbg.h>
#endif //HAVE_CRT

/* #line 1 "./ragel/tsip_parser_header_P_Asserted_Identity.rl" */
/*
* Copyright (C) 2017, University of the Basque Country (UPV/EHU)
* Contact for licensing options: <licensing-mcpttclient(at)mcopenplatform(dot)com>
*
* The original file was part of Open Source Doubango Framework
* Copyright (C) 2010-2011 Mamadou Diop.
* Copyright (C) 2012 Doubango Telecom <http://doubango.org>
*
* This file is part of Open Source Doubango Framework.
*
* DOUBANGO is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* DOUBANGO is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with DOUBANGO.
*
*/


/**@file tsip_header_P_Asserted_Identity.c
 * @brief SIP P-Asserted-Identity header as per RFC 3325.
 *
 * @author Mamadou Diop <diopmamadou(at)doubango[dot]org>
 *

 */
#include "tinysip/headers/tsip_header_P_Asserted_Identity.h"

#include "tinysip/parsers/tsip_parser_uri.h"

#include "tsk_debug.h"
#include "tsk_memory.h"
#include "tsk_time.h"

#include <string.h>



/***********************************
*	Ragel state machine.
*/

/* #line 100 "./ragel/tsip_parser_header_P_Asserted_Identity.rl" */


tsip_header_P_Asserted_Identity_t* tsip_header_P_Asserted_Identity_create()
{
	return tsk_object_new(tsip_header_P_Asserted_Identity_def_t);
}

int tsip_header_P_Asserted_Identity_serialize(const tsip_header_t* header, tsk_buffer_t* output)
{
	if(header){
		const tsip_header_P_Asserted_Identity_t *P_Asserted_Identity = (const tsip_header_P_Asserted_Identity_t *)header;
		int ret = 0;
		
		/* Uri with hacked display-name*/
		if((ret = tsip_uri_serialize(P_Asserted_Identity->uri, tsk_true, tsk_true, output))){
			return ret;
		}
		
		return ret;
	}

	return -1;
}

tsip_header_P_Asserted_Identities_L_t *tsip_header_P_Asserted_Identity_parse(const char *data, tsk_size_t size)
{
	int cs = 0;
	const char *p = data;
	const char *pe = p + size;
	const char *eof = pe;
	tsip_header_P_Asserted_Identities_L_t *hdr_p_asserted_identities = tsk_list_create();
	
	const char *tag_start = tsk_null;
	tsip_header_P_Asserted_Identity_t *curr_p_asserted_identity = 0;

	
/* #line 86 "./src/headers/tsip_header_P_Asserted_Identity.c" */
static const char _tsip_machine_parser_header_P_Asserted_Identity_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 2, 1, 0, 
	2, 3, 4, 3, 1, 3, 4, 3, 
	2, 3, 4, 3, 3, 4, 1, 3, 
	3, 4, 2
};

static const short _tsip_machine_parser_header_P_Asserted_Identity_key_offsets[] = {
	0, 0, 2, 3, 5, 7, 9, 11, 
	13, 15, 17, 19, 20, 22, 24, 26, 
	28, 30, 32, 34, 36, 39, 60, 61, 
	63, 84, 85, 87, 90, 94, 106, 109, 
	109, 110, 114, 115, 136, 137, 139, 160, 
	177, 195, 199, 200, 202, 210, 211, 213, 
	217, 223, 243, 262, 267, 267, 271, 289, 
	305, 322, 327, 335, 348, 353, 357, 362, 
	381, 398, 416, 422, 431, 441, 447, 472, 
	494, 517, 526, 537, 562, 585, 594, 599, 
	623, 644, 666, 674, 684, 708, 730, 750, 
	769, 774, 774, 778, 798, 814, 831, 836, 
	844, 857, 862, 866, 871, 892, 909, 927, 
	933, 942, 952, 958, 983, 1005, 1028, 1037, 
	1048, 1074, 1098, 1108, 1118, 1143, 1165, 1188, 
	1197, 1223, 1247, 1253, 1257, 1275, 1284, 1308, 
	1329, 1351, 1359, 1383, 1405, 1413, 1426, 1431, 
	1435, 1440, 1459, 1476, 1494, 1500, 1509, 1513, 
	1533, 1549, 1566, 1571, 1580, 1585, 1609, 1630, 
	1652, 1660, 1670, 1694, 1716, 1736, 1754, 1764, 
	1770, 1795, 1817, 1840, 1849, 1860, 1885, 1908, 
	1914, 1916, 1919, 1923, 1928, 1929, 1934, 1953, 
	1970, 1988, 1994, 2003, 2017, 2023, 2028, 2038, 
	2044, 2069, 2091, 2114, 2123, 2134, 2159, 2182, 
	2192, 2217, 2238, 2259, 2278, 2285, 2290, 2301, 
	2326, 2352, 2376, 2385, 2390, 2414, 2435, 2457, 
	2465, 2475, 2500, 2523, 2532, 2541, 2565, 2586, 
	2608, 2616, 2641, 2664, 2673, 2697, 2717, 2737, 
	2755, 2761, 2765, 2775, 2799, 2824, 2847
};

static const char _tsip_machine_parser_header_P_Asserted_Identity_trans_keys[] = {
	80, 112, 45, 65, 97, 83, 115, 83, 
	115, 69, 101, 82, 114, 84, 116, 69, 
	101, 68, 100, 45, 73, 105, 68, 100, 
	69, 101, 78, 110, 84, 116, 73, 105, 
	84, 116, 89, 121, 9, 32, 58, 9, 
	13, 32, 33, 34, 37, 39, 60, 126, 
	42, 43, 45, 46, 48, 57, 65, 90, 
	95, 96, 97, 122, 10, 9, 32, 9, 
	13, 32, 33, 34, 37, 39, 60, 126, 
	42, 43, 45, 46, 48, 57, 65, 90, 
	95, 96, 97, 122, 10, 9, 32, 9, 
	32, 60, 65, 90, 97, 122, 9, 32, 
	43, 58, 45, 46, 48, 57, 65, 90, 
	97, 122, 9, 32, 58, 62, 9, 13, 
	32, 44, 10, 9, 13, 32, 33, 34, 
	37, 39, 60, 126, 42, 43, 45, 46, 
	48, 57, 65, 90, 95, 96, 97, 122, 
	10, 9, 32, 9, 13, 32, 33, 34, 
	37, 39, 60, 126, 42, 43, 45, 46, 
	48, 57, 65, 90, 95, 96, 97, 122, 
	9, 13, 32, 33, 37, 39, 126, 42, 
	43, 45, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 37, 39, 60, 
	126, 42, 43, 45, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 60, 10, 
	9, 32, 13, 34, 92, 127, 0, 8, 
	10, 31, 10, 9, 32, 9, 13, 32, 
	60, 0, 9, 11, 12, 14, 127, 9, 
	13, 32, 33, 37, 39, 42, 43, 58, 
	126, 45, 46, 48, 57, 65, 90, 95, 
	96, 97, 122, 9, 13, 32, 33, 37, 
	39, 58, 60, 126, 42, 43, 45, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 58, 60, 9, 13, 32, 44, 9, 
	13, 32, 33, 34, 37, 39, 44, 60, 
	126, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 37, 39, 44, 
	126, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 37, 39, 44, 
	60, 126, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 44, 60, 9, 
	13, 32, 44, 65, 90, 97, 122, 9, 
	13, 32, 44, 58, 43, 46, 48, 57, 
	65, 90, 97, 122, 9, 13, 32, 44, 
	58, 9, 13, 32, 44, 9, 13, 32, 
	44, 62, 9, 13, 32, 33, 34, 37, 
	39, 44, 60, 62, 126, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 37, 39, 44, 62, 126, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 37, 39, 44, 60, 62, 126, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 44, 60, 62, 9, 13, 
	32, 44, 62, 65, 90, 97, 122, 9, 
	13, 32, 34, 44, 62, 92, 127, 0, 
	31, 9, 13, 32, 44, 60, 62, 9, 
	13, 32, 33, 34, 37, 39, 44, 60, 
	62, 92, 126, 127, 0, 31, 42, 46, 
	48, 57, 65, 90, 95, 96, 97, 122, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	62, 92, 126, 127, 0, 31, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 60, 62, 
	92, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	44, 62, 0, 8, 11, 127, 9, 13, 
	32, 34, 44, 60, 62, 92, 127, 0, 
	31, 9, 13, 32, 33, 34, 37, 39, 
	42, 44, 62, 92, 126, 127, 0, 31, 
	43, 46, 48, 57, 65, 90, 95, 96, 
	97, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 60, 62, 92, 126, 127, 0, 
	31, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 34, 44, 92, 127, 
	0, 31, 9, 13, 32, 44, 60, 9, 
	13, 32, 33, 34, 37, 39, 44, 60, 
	92, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 96, 97, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 92, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 60, 92, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 44, 0, 8, 
	11, 127, 9, 13, 32, 34, 44, 60, 
	92, 127, 0, 31, 9, 13, 32, 33, 
	34, 37, 39, 42, 44, 92, 126, 127, 
	0, 31, 43, 46, 48, 57, 65, 90, 
	95, 96, 97, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 60, 92, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 37, 39, 
	42, 43, 58, 126, 45, 46, 48, 57, 
	65, 90, 95, 96, 97, 122, 9, 13, 
	32, 33, 37, 39, 58, 60, 126, 42, 
	43, 45, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 58, 60, 9, 13, 
	32, 44, 9, 13, 32, 33, 34, 37, 
	39, 44, 60, 126, 42, 46, 48, 57, 
	65, 90, 95, 96, 97, 122, 9, 13, 
	32, 33, 37, 39, 44, 126, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 37, 39, 44, 60, 126, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 44, 60, 9, 13, 32, 44, 
	65, 90, 97, 122, 9, 13, 32, 44, 
	58, 43, 46, 48, 57, 65, 90, 97, 
	122, 9, 13, 32, 44, 58, 9, 13, 
	32, 44, 9, 13, 32, 44, 62, 9, 
	13, 32, 33, 34, 37, 39, 44, 60, 
	62, 126, 42, 46, 48, 57, 65, 90, 
	95, 96, 97, 122, 9, 13, 32, 33, 
	37, 39, 44, 62, 126, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 37, 39, 44, 60, 62, 126, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 44, 60, 62, 9, 13, 32, 
	44, 62, 65, 90, 97, 122, 9, 13, 
	32, 34, 44, 62, 92, 127, 0, 31, 
	9, 13, 32, 44, 60, 62, 9, 13, 
	32, 33, 34, 37, 39, 44, 60, 62, 
	92, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 96, 97, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 62, 
	92, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 60, 62, 92, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 44, 
	62, 0, 8, 11, 127, 9, 13, 32, 
	34, 44, 60, 62, 92, 127, 0, 31, 
	9, 13, 32, 33, 34, 37, 39, 42, 
	44, 58, 62, 92, 126, 127, 0, 31, 
	43, 46, 48, 57, 65, 90, 95, 96, 
	97, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 58, 60, 62, 92, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 34, 44, 62, 
	92, 127, 0, 31, 9, 13, 32, 34, 
	44, 62, 92, 127, 0, 31, 9, 13, 
	32, 33, 34, 37, 39, 44, 60, 62, 
	92, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 96, 97, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 62, 
	92, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 60, 62, 92, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 44, 
	62, 0, 8, 11, 127, 9, 13, 32, 
	33, 34, 37, 39, 42, 44, 58, 62, 
	92, 126, 127, 0, 31, 43, 46, 48, 
	57, 65, 90, 95, 96, 97, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 58, 
	60, 62, 92, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 44, 58, 60, 9, 13, 32, 
	44, 9, 13, 32, 33, 34, 37, 39, 
	44, 60, 126, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 34, 44, 
	92, 127, 0, 31, 9, 13, 32, 33, 
	34, 37, 39, 44, 60, 92, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 96, 97, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 92, 126, 127, 0, 
	31, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 60, 92, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 9, 
	13, 32, 44, 0, 8, 11, 127, 9, 
	13, 32, 33, 34, 37, 39, 42, 44, 
	92, 126, 127, 0, 31, 43, 46, 48, 
	57, 65, 90, 95, 96, 97, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 60, 
	92, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	44, 65, 90, 97, 122, 9, 13, 32, 
	44, 58, 43, 46, 48, 57, 65, 90, 
	97, 122, 9, 13, 32, 44, 58, 9, 
	13, 32, 44, 9, 13, 32, 44, 62, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	60, 62, 126, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 37, 
	39, 44, 62, 126, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	37, 39, 44, 60, 62, 126, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 44, 60, 62, 9, 13, 32, 44, 
	62, 65, 90, 97, 122, 9, 13, 32, 
	44, 9, 13, 32, 33, 34, 37, 39, 
	44, 60, 126, 42, 46, 48, 57, 65, 
	90, 95, 96, 97, 122, 9, 13, 32, 
	33, 37, 39, 44, 126, 42, 46, 48, 
	57, 65, 90, 95, 122, 9, 13, 32, 
	33, 37, 39, 44, 60, 126, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 44, 60, 9, 13, 32, 34, 44, 
	92, 127, 0, 31, 9, 13, 32, 44, 
	60, 9, 13, 32, 33, 34, 37, 39, 
	44, 60, 92, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 96, 97, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 92, 126, 127, 0, 31, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 60, 92, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 44, 
	0, 8, 11, 127, 9, 13, 32, 34, 
	44, 60, 92, 127, 0, 31, 9, 13, 
	32, 33, 34, 37, 39, 42, 44, 92, 
	126, 127, 0, 31, 43, 46, 48, 57, 
	65, 90, 95, 96, 97, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 60, 92, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 33, 
	37, 39, 42, 44, 58, 126, 43, 46, 
	48, 57, 65, 90, 95, 96, 97, 122, 
	9, 13, 32, 33, 37, 39, 44, 58, 
	60, 126, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 34, 44, 62, 
	92, 127, 0, 31, 9, 13, 32, 44, 
	60, 62, 9, 13, 32, 33, 34, 37, 
	39, 44, 60, 62, 92, 126, 127, 0, 
	31, 42, 46, 48, 57, 65, 90, 95, 
	96, 97, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 62, 92, 126, 127, 0, 
	31, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 60, 62, 92, 126, 127, 0, 31, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 44, 62, 0, 8, 11, 
	127, 9, 13, 32, 34, 44, 60, 62, 
	92, 127, 0, 31, 9, 13, 32, 33, 
	34, 37, 39, 42, 44, 62, 92, 126, 
	127, 0, 31, 43, 46, 48, 57, 65, 
	90, 95, 96, 97, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 60, 62, 92, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 58, 
	60, 62, 10, 62, 9, 32, 62, 9, 
	32, 60, 62, 62, 65, 90, 97, 122, 
	62, 9, 13, 32, 44, 62, 9, 13, 
	32, 33, 34, 37, 39, 44, 60, 62, 
	126, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 33, 37, 39, 44, 
	62, 126, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 37, 39, 
	44, 60, 62, 126, 42, 46, 48, 57, 
	65, 90, 95, 122, 9, 13, 32, 44, 
	60, 62, 9, 13, 32, 44, 62, 65, 
	90, 97, 122, 9, 13, 32, 44, 58, 
	62, 43, 46, 48, 57, 65, 90, 97, 
	122, 9, 13, 32, 44, 58, 62, 9, 
	13, 32, 44, 62, 9, 13, 32, 34, 
	44, 62, 92, 127, 0, 31, 9, 13, 
	32, 44, 60, 62, 9, 13, 32, 33, 
	34, 37, 39, 44, 60, 62, 92, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 96, 97, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 62, 92, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 60, 62, 92, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 44, 62, 0, 
	8, 11, 127, 9, 13, 32, 34, 44, 
	60, 62, 92, 127, 0, 31, 9, 13, 
	32, 33, 34, 37, 39, 42, 44, 62, 
	92, 126, 127, 0, 31, 43, 46, 48, 
	57, 65, 90, 95, 96, 97, 122, 9, 
	13, 32, 33, 34, 37, 39, 44, 60, 
	62, 92, 126, 127, 0, 31, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 34, 44, 62, 92, 127, 0, 31, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	60, 62, 92, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 96, 97, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 60, 62, 126, 42, 46, 48, 57, 
	65, 90, 95, 96, 97, 122, 9, 13, 
	32, 33, 37, 39, 42, 44, 58, 62, 
	126, 43, 46, 48, 57, 65, 90, 95, 
	96, 97, 122, 9, 13, 32, 33, 37, 
	39, 44, 58, 60, 62, 126, 42, 46, 
	48, 57, 65, 90, 95, 122, 9, 13, 
	32, 44, 58, 60, 62, 9, 13, 32, 
	44, 62, 9, 13, 32, 34, 44, 60, 
	62, 92, 127, 0, 31, 9, 13, 32, 
	33, 34, 37, 39, 44, 60, 62, 92, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 96, 97, 122, 9, 13, 
	32, 33, 34, 37, 39, 42, 44, 58, 
	62, 92, 126, 127, 0, 31, 43, 46, 
	48, 57, 65, 90, 95, 96, 97, 122, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	58, 60, 62, 92, 126, 127, 0, 31, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 34, 44, 92, 127, 0, 
	31, 9, 13, 32, 44, 60, 9, 13, 
	32, 33, 34, 37, 39, 44, 60, 92, 
	126, 127, 0, 31, 42, 46, 48, 57, 
	65, 90, 95, 96, 97, 122, 9, 13, 
	32, 33, 34, 37, 39, 44, 92, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 33, 34, 
	37, 39, 44, 60, 92, 126, 127, 0, 
	31, 42, 46, 48, 57, 65, 90, 95, 
	122, 9, 13, 32, 44, 0, 8, 11, 
	127, 9, 13, 32, 34, 44, 60, 92, 
	127, 0, 31, 9, 13, 32, 33, 34, 
	37, 39, 42, 44, 58, 92, 126, 127, 
	0, 31, 43, 46, 48, 57, 65, 90, 
	95, 96, 97, 122, 9, 13, 32, 33, 
	34, 37, 39, 44, 58, 60, 92, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 34, 44, 
	92, 127, 0, 31, 9, 13, 32, 34, 
	44, 92, 127, 0, 31, 9, 13, 32, 
	33, 34, 37, 39, 44, 60, 92, 126, 
	127, 0, 31, 42, 46, 48, 57, 65, 
	90, 95, 96, 97, 122, 9, 13, 32, 
	33, 34, 37, 39, 44, 92, 126, 127, 
	0, 31, 42, 46, 48, 57, 65, 90, 
	95, 122, 9, 13, 32, 33, 34, 37, 
	39, 44, 60, 92, 126, 127, 0, 31, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 44, 0, 8, 11, 127, 
	9, 13, 32, 33, 34, 37, 39, 42, 
	44, 58, 92, 126, 127, 0, 31, 43, 
	46, 48, 57, 65, 90, 95, 96, 97, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 58, 60, 92, 126, 127, 0, 31, 
	42, 46, 48, 57, 65, 90, 95, 122, 
	9, 13, 32, 34, 44, 92, 127, 0, 
	31, 9, 13, 32, 33, 34, 37, 39, 
	44, 60, 92, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 96, 97, 
	122, 9, 13, 32, 33, 34, 37, 39, 
	44, 60, 126, 42, 46, 48, 57, 65, 
	90, 95, 96, 97, 122, 9, 13, 32, 
	33, 37, 39, 42, 44, 58, 126, 43, 
	46, 48, 57, 65, 90, 95, 96, 97, 
	122, 9, 13, 32, 33, 37, 39, 44, 
	58, 60, 126, 42, 46, 48, 57, 65, 
	90, 95, 122, 9, 13, 32, 44, 58, 
	60, 9, 13, 32, 44, 9, 13, 32, 
	34, 44, 60, 92, 127, 0, 31, 9, 
	13, 32, 33, 34, 37, 39, 44, 60, 
	92, 126, 127, 0, 31, 42, 46, 48, 
	57, 65, 90, 95, 96, 97, 122, 9, 
	13, 32, 33, 34, 37, 39, 42, 44, 
	58, 92, 126, 127, 0, 31, 43, 46, 
	48, 57, 65, 90, 95, 96, 97, 122, 
	9, 13, 32, 33, 34, 37, 39, 44, 
	58, 60, 92, 126, 127, 0, 31, 42, 
	46, 48, 57, 65, 90, 95, 122, 0
};

static const char _tsip_machine_parser_header_P_Asserted_Identity_single_lengths[] = {
	0, 2, 1, 2, 2, 2, 2, 2, 
	2, 2, 2, 1, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 9, 1, 2, 
	9, 1, 2, 3, 0, 4, 3, 0, 
	1, 4, 1, 9, 1, 2, 9, 7, 
	8, 4, 1, 2, 4, 1, 2, 4, 
	0, 10, 9, 5, 0, 4, 10, 8, 
	9, 5, 4, 5, 5, 4, 5, 11, 
	9, 10, 6, 5, 8, 6, 13, 12, 
	13, 5, 9, 13, 13, 7, 5, 12, 
	11, 12, 4, 8, 12, 12, 10, 9, 
	5, 0, 4, 10, 8, 9, 5, 4, 
	5, 5, 4, 5, 11, 9, 10, 6, 
	5, 8, 6, 13, 12, 13, 5, 9, 
	14, 14, 8, 8, 13, 12, 13, 5, 
	14, 14, 6, 4, 10, 7, 12, 11, 
	12, 4, 12, 12, 4, 5, 5, 4, 
	5, 11, 9, 10, 6, 5, 4, 10, 
	8, 9, 5, 7, 5, 12, 11, 12, 
	4, 8, 12, 12, 10, 10, 8, 6, 
	13, 12, 13, 5, 9, 13, 13, 6, 
	2, 3, 4, 1, 1, 5, 11, 9, 
	10, 6, 5, 6, 6, 5, 8, 6, 
	13, 12, 13, 5, 9, 13, 13, 8, 
	13, 11, 11, 11, 7, 5, 9, 13, 
	14, 14, 7, 5, 12, 11, 12, 4, 
	8, 13, 13, 7, 7, 12, 11, 12, 
	4, 13, 13, 7, 12, 10, 10, 10, 
	6, 4, 8, 12, 13, 13, 0
};

static const char _tsip_machine_parser_header_P_Asserted_Identity_range_lengths[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 6, 0, 0, 
	6, 0, 0, 0, 2, 4, 0, 0, 
	0, 0, 0, 6, 0, 0, 6, 5, 
	5, 0, 0, 0, 2, 0, 0, 0, 
	3, 5, 5, 0, 0, 0, 4, 4, 
	4, 0, 2, 4, 0, 0, 0, 4, 
	4, 4, 0, 2, 1, 0, 6, 5, 
	5, 2, 1, 6, 5, 1, 0, 6, 
	5, 5, 2, 1, 6, 5, 5, 5, 
	0, 0, 0, 5, 4, 4, 0, 2, 
	4, 0, 0, 0, 5, 4, 4, 0, 
	2, 1, 0, 6, 5, 5, 2, 1, 
	6, 5, 1, 1, 6, 5, 5, 2, 
	6, 5, 0, 0, 4, 1, 6, 5, 
	5, 2, 6, 5, 2, 4, 0, 0, 
	0, 4, 4, 4, 0, 2, 0, 5, 
	4, 4, 0, 1, 0, 6, 5, 5, 
	2, 1, 6, 5, 5, 4, 1, 0, 
	6, 5, 5, 2, 1, 6, 5, 0, 
	0, 0, 0, 2, 0, 0, 4, 4, 
	4, 0, 2, 4, 0, 0, 1, 0, 
	6, 5, 5, 2, 1, 6, 5, 1, 
	6, 5, 5, 4, 0, 0, 1, 6, 
	6, 5, 1, 0, 6, 5, 5, 2, 
	1, 6, 5, 1, 1, 6, 5, 5, 
	2, 6, 5, 1, 6, 5, 5, 4, 
	0, 0, 1, 6, 6, 5, 0
};

static const short _tsip_machine_parser_header_P_Asserted_Identity_index_offsets[] = {
	0, 0, 3, 5, 8, 11, 14, 17, 
	20, 23, 26, 29, 31, 34, 37, 40, 
	43, 46, 49, 52, 55, 59, 75, 77, 
	80, 96, 98, 101, 105, 108, 117, 121, 
	122, 124, 129, 131, 147, 149, 152, 168, 
	181, 195, 200, 202, 205, 212, 214, 217, 
	222, 226, 242, 257, 263, 264, 269, 284, 
	297, 311, 317, 324, 334, 340, 345, 351, 
	367, 381, 396, 403, 411, 421, 428, 448, 
	466, 485, 493, 504, 524, 543, 552, 558, 
	577, 594, 612, 619, 629, 648, 666, 682, 
	697, 703, 704, 709, 725, 738, 752, 758, 
	765, 775, 781, 786, 792, 809, 823, 838, 
	845, 853, 863, 870, 890, 908, 927, 935, 
	946, 967, 987, 997, 1007, 1027, 1045, 1064, 
	1072, 1093, 1113, 1120, 1125, 1140, 1149, 1168, 
	1185, 1203, 1210, 1229, 1247, 1254, 1264, 1270, 
	1275, 1281, 1297, 1311, 1326, 1333, 1341, 1346, 
	1362, 1375, 1389, 1395, 1404, 1410, 1429, 1446, 
	1464, 1471, 1481, 1500, 1518, 1534, 1549, 1559, 
	1566, 1586, 1604, 1623, 1631, 1642, 1662, 1681, 
	1688, 1691, 1695, 1700, 1704, 1706, 1712, 1728, 
	1742, 1757, 1764, 1772, 1783, 1790, 1796, 1806, 
	1813, 1833, 1851, 1870, 1878, 1889, 1909, 1928, 
	1938, 1958, 1975, 1992, 2008, 2016, 2022, 2033, 
	2053, 2074, 2094, 2103, 2109, 2128, 2145, 2163, 
	2170, 2180, 2200, 2219, 2228, 2237, 2256, 2273, 
	2291, 2298, 2318, 2337, 2346, 2365, 2381, 2397, 
	2412, 2419, 2424, 2434, 2453, 2473, 2492
};

static const unsigned char _tsip_machine_parser_header_P_Asserted_Identity_trans_targs[] = {
	2, 2, 0, 3, 0, 4, 4, 0, 
	5, 5, 0, 6, 6, 0, 7, 7, 
	0, 8, 8, 0, 9, 9, 0, 10, 
	10, 0, 11, 11, 0, 12, 0, 13, 
	13, 0, 14, 14, 0, 15, 15, 0, 
	16, 16, 0, 17, 17, 0, 18, 18, 
	0, 19, 19, 0, 20, 20, 0, 20, 
	20, 21, 0, 21, 22, 21, 39, 44, 
	39, 39, 28, 39, 39, 39, 39, 86, 
	39, 86, 0, 23, 0, 24, 24, 0, 
	24, 25, 24, 39, 44, 39, 39, 28, 
	39, 39, 39, 39, 86, 39, 86, 0, 
	26, 0, 27, 27, 0, 27, 27, 28, 
	0, 29, 29, 0, 30, 30, 29, 31, 
	29, 29, 29, 29, 0, 30, 30, 31, 
	0, 32, 33, 32, 33, 34, 33, 35, 
	0, 230, 0, 35, 36, 35, 39, 44, 
	39, 39, 28, 39, 39, 39, 39, 49, 
	39, 49, 0, 37, 0, 38, 38, 0, 
	38, 25, 38, 39, 44, 39, 39, 28, 
	39, 39, 39, 39, 49, 39, 49, 0, 
	40, 42, 40, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 0, 41, 25, 41, 
	39, 39, 39, 28, 39, 39, 39, 39, 
	39, 39, 0, 41, 25, 41, 28, 0, 
	43, 0, 40, 40, 0, 45, 47, 48, 
	0, 0, 0, 44, 46, 0, 44, 44, 
	0, 41, 25, 41, 28, 0, 44, 44, 
	44, 0, 50, 42, 50, 39, 39, 39, 
	39, 49, 52, 39, 49, 49, 49, 39, 
	49, 0, 51, 25, 51, 39, 39, 39, 
	52, 28, 39, 39, 39, 39, 39, 39, 
	0, 51, 25, 51, 52, 28, 0, 53, 
	53, 34, 53, 54, 53, 54, 34, 54, 
	55, 77, 55, 55, 54, 58, 55, 55, 
	55, 55, 55, 53, 56, 34, 56, 55, 
	55, 55, 54, 55, 55, 55, 55, 55, 
	53, 57, 34, 57, 55, 55, 55, 54, 
	58, 55, 55, 55, 55, 55, 53, 57, 
	34, 57, 54, 58, 53, 53, 34, 53, 
	54, 59, 59, 53, 60, 34, 60, 54, 
	61, 59, 59, 59, 59, 53, 60, 34, 
	60, 54, 61, 53, 62, 34, 62, 63, 
	62, 62, 34, 62, 63, 53, 62, 63, 
	34, 63, 64, 68, 64, 64, 63, 67, 
	53, 64, 64, 64, 64, 64, 62, 65, 
	34, 65, 64, 64, 64, 63, 53, 64, 
	64, 64, 64, 64, 62, 66, 34, 66, 
	64, 64, 64, 63, 67, 53, 64, 64, 
	64, 64, 64, 62, 66, 34, 66, 63, 
	67, 53, 62, 62, 34, 62, 63, 53, 
	62, 62, 62, 68, 34, 68, 69, 70, 
	53, 73, 62, 62, 68, 66, 34, 66, 
	63, 67, 53, 62, 63, 34, 63, 71, 
	74, 71, 71, 70, 67, 53, 73, 71, 
	62, 62, 71, 71, 75, 71, 75, 68, 
	72, 34, 72, 71, 69, 71, 71, 70, 
	53, 73, 71, 62, 62, 71, 71, 71, 
	71, 68, 66, 34, 66, 71, 69, 71, 
	71, 70, 67, 53, 73, 71, 62, 62, 
	71, 71, 71, 71, 68, 68, 34, 68, 
	70, 53, 68, 68, 62, 66, 34, 66, 
	69, 70, 67, 53, 73, 62, 62, 68, 
	76, 34, 76, 71, 69, 71, 71, 71, 
	70, 53, 73, 71, 62, 62, 75, 75, 
	75, 71, 75, 68, 51, 34, 51, 71, 
	69, 71, 71, 70, 28, 53, 73, 71, 
	62, 62, 71, 71, 71, 71, 68, 77, 
	34, 77, 78, 79, 82, 53, 53, 77, 
	57, 34, 57, 54, 58, 53, 54, 34, 
	54, 80, 83, 80, 80, 79, 58, 82, 
	80, 53, 53, 80, 80, 84, 80, 84, 
	77, 81, 34, 81, 80, 78, 80, 80, 
	79, 82, 80, 53, 53, 80, 80, 80, 
	80, 77, 57, 34, 57, 80, 78, 80, 
	80, 79, 58, 82, 80, 53, 53, 80, 
	80, 80, 80, 77, 77, 34, 77, 79, 
	77, 77, 53, 57, 34, 57, 78, 79, 
	58, 82, 53, 53, 77, 85, 34, 85, 
	80, 78, 80, 80, 80, 79, 82, 80, 
	53, 53, 84, 84, 84, 80, 84, 77, 
	51, 34, 51, 80, 78, 80, 80, 79, 
	28, 82, 80, 53, 53, 80, 80, 80, 
	80, 77, 87, 42, 87, 39, 39, 39, 
	39, 86, 89, 39, 86, 86, 86, 39, 
	86, 0, 88, 25, 88, 39, 39, 39, 
	89, 28, 39, 39, 39, 39, 39, 39, 
	0, 88, 25, 88, 89, 28, 0, 90, 
	90, 34, 90, 91, 90, 91, 34, 91, 
	92, 202, 92, 92, 91, 95, 92, 92, 
	92, 222, 92, 222, 90, 93, 34, 93, 
	92, 92, 92, 91, 92, 92, 92, 92, 
	92, 90, 94, 34, 94, 92, 92, 92, 
	91, 95, 92, 92, 92, 92, 92, 90, 
	94, 34, 94, 91, 95, 90, 90, 34, 
	90, 91, 96, 96, 90, 97, 34, 97, 
	91, 98, 96, 96, 96, 96, 90, 97, 
	34, 97, 91, 98, 90, 99, 34, 99, 
	100, 99, 99, 34, 99, 100, 90, 99, 
	100, 34, 100, 101, 105, 101, 101, 100, 
	104, 90, 101, 101, 101, 194, 101, 194, 
	99, 102, 34, 102, 101, 101, 101, 100, 
	90, 101, 101, 101, 101, 101, 99, 103, 
	34, 103, 101, 101, 101, 100, 104, 90, 
	101, 101, 101, 101, 101, 99, 103, 34, 
	103, 100, 104, 90, 99, 99, 34, 99, 
	100, 90, 99, 99, 99, 105, 34, 105, 
	106, 107, 90, 110, 99, 99, 105, 103, 
	34, 103, 100, 104, 90, 99, 100, 34, 
	100, 108, 111, 108, 108, 107, 104, 90, 
	110, 108, 99, 99, 108, 108, 112, 108, 
	112, 105, 109, 34, 109, 108, 106, 108, 
	108, 107, 90, 110, 108, 99, 99, 108, 
	108, 108, 108, 105, 103, 34, 103, 108, 
	106, 108, 108, 107, 104, 90, 110, 108, 
	99, 99, 108, 108, 108, 108, 105, 105, 
	34, 105, 107, 90, 105, 105, 99, 103, 
	34, 103, 106, 107, 104, 90, 110, 99, 
	99, 105, 113, 34, 113, 108, 106, 108, 
	108, 108, 107, 114, 90, 110, 108, 99, 
	99, 112, 112, 112, 108, 112, 105, 51, 
	34, 51, 108, 106, 108, 108, 107, 114, 
	28, 90, 110, 108, 99, 99, 108, 108, 
	108, 108, 105, 115, 34, 115, 106, 199, 
	90, 119, 99, 99, 115, 115, 34, 115, 
	106, 116, 90, 119, 99, 99, 115, 100, 
	34, 100, 117, 111, 117, 117, 116, 104, 
	90, 119, 117, 99, 99, 117, 117, 120, 
	117, 120, 115, 118, 34, 118, 117, 106, 
	117, 117, 116, 90, 119, 117, 99, 99, 
	117, 117, 117, 117, 115, 103, 34, 103, 
	117, 106, 117, 117, 116, 104, 90, 119, 
	117, 99, 99, 117, 117, 117, 117, 115, 
	115, 34, 115, 116, 90, 115, 115, 99, 
	121, 34, 121, 117, 106, 117, 117, 117, 
	116, 191, 90, 119, 117, 99, 99, 120, 
	120, 120, 117, 120, 115, 122, 34, 122, 
	117, 106, 117, 117, 116, 191, 132, 90, 
	119, 117, 99, 99, 117, 117, 117, 117, 
	115, 122, 34, 122, 54, 123, 132, 53, 
	53, 34, 53, 124, 53, 124, 34, 124, 
	55, 125, 55, 55, 54, 58, 55, 55, 
	55, 55, 55, 53, 125, 34, 125, 78, 
	126, 129, 53, 53, 125, 54, 34, 54, 
	127, 83, 127, 127, 126, 58, 129, 127, 
	53, 53, 127, 127, 130, 127, 130, 125, 
	128, 34, 128, 127, 78, 127, 127, 126, 
	129, 127, 53, 53, 127, 127, 127, 127, 
	125, 57, 34, 57, 127, 78, 127, 127, 
	126, 58, 129, 127, 53, 53, 127, 127, 
	127, 127, 125, 125, 34, 125, 126, 125, 
	125, 53, 131, 34, 131, 127, 78, 127, 
	127, 127, 126, 129, 127, 53, 53, 130, 
	130, 130, 127, 130, 125, 122, 34, 122, 
	127, 78, 127, 127, 126, 132, 129, 127, 
	53, 53, 127, 127, 127, 127, 125, 53, 
	34, 53, 54, 133, 133, 53, 134, 34, 
	134, 54, 135, 133, 133, 133, 133, 53, 
	134, 34, 134, 54, 135, 53, 136, 34, 
	136, 137, 136, 136, 34, 136, 137, 142, 
	136, 137, 34, 137, 138, 158, 138, 138, 
	137, 141, 142, 138, 138, 138, 138, 138, 
	136, 139, 34, 139, 138, 138, 138, 137, 
	142, 138, 138, 138, 138, 138, 136, 140, 
	34, 140, 138, 138, 138, 137, 141, 142, 
	138, 138, 138, 138, 138, 136, 140, 34, 
	140, 137, 141, 142, 136, 136, 34, 136, 
	137, 142, 136, 136, 136, 142, 34, 142, 
	143, 53, 143, 34, 143, 144, 147, 144, 
	144, 54, 132, 144, 144, 144, 156, 144, 
	156, 53, 145, 34, 145, 144, 144, 144, 
	54, 144, 144, 144, 144, 144, 53, 146, 
	34, 146, 144, 144, 144, 54, 132, 144, 
	144, 144, 144, 144, 53, 146, 34, 146, 
	54, 132, 53, 147, 34, 147, 148, 149, 
	152, 53, 53, 147, 146, 34, 146, 54, 
	132, 53, 54, 34, 54, 150, 153, 150, 
	150, 149, 58, 152, 150, 53, 53, 150, 
	150, 154, 150, 154, 147, 151, 34, 151, 
	150, 148, 150, 150, 149, 152, 150, 53, 
	53, 150, 150, 150, 150, 147, 57, 34, 
	57, 150, 148, 150, 150, 149, 58, 152, 
	150, 53, 53, 150, 150, 150, 150, 147, 
	147, 34, 147, 149, 147, 147, 53, 146, 
	34, 146, 78, 79, 132, 82, 53, 53, 
	77, 155, 34, 155, 150, 148, 150, 150, 
	150, 149, 152, 150, 53, 53, 154, 154, 
	154, 150, 154, 147, 51, 34, 51, 150, 
	148, 150, 150, 149, 28, 152, 150, 53, 
	53, 150, 150, 150, 150, 147, 157, 34, 
	157, 144, 144, 144, 144, 54, 123, 144, 
	156, 156, 156, 144, 156, 53, 122, 34, 
	122, 144, 144, 144, 54, 123, 132, 144, 
	144, 144, 144, 144, 53, 158, 34, 158, 
	159, 160, 142, 163, 136, 136, 158, 140, 
	34, 140, 137, 141, 142, 136, 137, 34, 
	137, 161, 164, 161, 161, 160, 141, 142, 
	163, 161, 136, 136, 161, 161, 165, 161, 
	165, 158, 162, 34, 162, 161, 159, 161, 
	161, 160, 142, 163, 161, 136, 136, 161, 
	161, 161, 161, 158, 140, 34, 140, 161, 
	159, 161, 161, 160, 141, 142, 163, 161, 
	136, 136, 161, 161, 161, 161, 158, 158, 
	34, 158, 160, 142, 158, 158, 136, 140, 
	34, 140, 159, 160, 141, 142, 163, 136, 
	136, 158, 166, 34, 166, 161, 159, 161, 
	161, 161, 160, 142, 163, 161, 136, 136, 
	165, 165, 165, 161, 165, 158, 167, 34, 
	167, 161, 159, 161, 161, 160, 171, 142, 
	163, 161, 136, 136, 161, 161, 161, 161, 
	158, 167, 168, 167, 172, 171, 33, 32, 
	169, 33, 32, 170, 170, 33, 32, 170, 
	170, 171, 33, 32, 33, 32, 32, 32, 
	142, 173, 173, 34, 173, 174, 142, 173, 
	174, 34, 174, 175, 182, 175, 175, 174, 
	178, 142, 175, 175, 175, 175, 175, 173, 
	176, 34, 176, 175, 175, 175, 174, 142, 
	175, 175, 175, 175, 175, 173, 177, 34, 
	177, 175, 175, 175, 174, 178, 142, 175, 
	175, 175, 175, 175, 173, 177, 34, 177, 
	174, 178, 142, 173, 173, 34, 173, 174, 
	142, 179, 179, 173, 180, 34, 180, 174, 
	181, 142, 179, 179, 179, 179, 173, 180, 
	34, 180, 174, 181, 142, 173, 136, 34, 
	136, 137, 33, 136, 182, 34, 182, 183, 
	184, 33, 187, 173, 173, 182, 177, 34, 
	177, 174, 178, 142, 173, 174, 34, 174, 
	185, 188, 185, 185, 184, 178, 33, 187, 
	185, 173, 173, 185, 185, 189, 185, 189, 
	182, 186, 34, 186, 185, 183, 185, 185, 
	184, 33, 187, 185, 173, 173, 185, 185, 
	185, 185, 182, 177, 34, 177, 185, 183, 
	185, 185, 184, 178, 33, 187, 185, 173, 
	173, 185, 185, 185, 185, 182, 182, 34, 
	182, 184, 33, 182, 182, 173, 177, 34, 
	177, 183, 184, 178, 33, 187, 173, 173, 
	182, 190, 34, 190, 185, 183, 185, 185, 
	185, 184, 33, 187, 185, 173, 173, 189, 
	189, 189, 185, 189, 182, 167, 34, 167, 
	185, 183, 185, 185, 184, 171, 33, 187, 
	185, 173, 173, 185, 185, 185, 185, 182, 
	115, 34, 115, 106, 192, 90, 119, 99, 
	99, 115, 193, 34, 193, 117, 198, 117, 
	117, 116, 104, 90, 119, 117, 99, 99, 
	117, 117, 120, 117, 120, 115, 193, 34, 
	193, 101, 115, 101, 101, 100, 104, 90, 
	101, 101, 101, 194, 101, 194, 99, 195, 
	34, 195, 101, 101, 101, 101, 100, 197, 
	90, 101, 194, 194, 194, 101, 194, 99, 
	196, 34, 196, 101, 101, 101, 100, 197, 
	104, 90, 101, 101, 101, 101, 101, 99, 
	196, 34, 196, 100, 197, 104, 90, 99, 
	99, 34, 99, 193, 90, 99, 103, 34, 
	103, 106, 116, 104, 90, 119, 99, 99, 
	115, 193, 34, 193, 117, 198, 117, 117, 
	116, 104, 90, 119, 117, 99, 99, 117, 
	117, 200, 117, 200, 115, 201, 34, 201, 
	117, 106, 117, 117, 117, 116, 191, 90, 
	119, 117, 99, 99, 200, 200, 200, 117, 
	200, 115, 51, 34, 51, 117, 106, 117, 
	117, 116, 191, 28, 90, 119, 117, 99, 
	99, 117, 117, 117, 117, 115, 202, 34, 
	202, 203, 204, 207, 90, 90, 202, 94, 
	34, 94, 91, 95, 90, 91, 34, 91, 
	205, 208, 205, 205, 204, 95, 207, 205, 
	90, 90, 205, 205, 209, 205, 209, 202, 
	206, 34, 206, 205, 203, 205, 205, 204, 
	207, 205, 90, 90, 205, 205, 205, 205, 
	202, 94, 34, 94, 205, 203, 205, 205, 
	204, 95, 207, 205, 90, 90, 205, 205, 
	205, 205, 202, 202, 34, 202, 204, 202, 
	202, 90, 94, 34, 94, 203, 204, 95, 
	207, 90, 90, 202, 210, 34, 210, 205, 
	203, 205, 205, 205, 204, 211, 207, 205, 
	90, 90, 209, 209, 209, 205, 209, 202, 
	51, 34, 51, 205, 203, 205, 205, 204, 
	211, 28, 207, 205, 90, 90, 205, 205, 
	205, 205, 202, 212, 34, 212, 203, 227, 
	216, 90, 90, 212, 212, 34, 212, 203, 
	213, 216, 90, 90, 212, 91, 34, 91, 
	214, 208, 214, 214, 213, 95, 216, 214, 
	90, 90, 214, 214, 217, 214, 217, 212, 
	215, 34, 215, 214, 203, 214, 214, 213, 
	216, 214, 90, 90, 214, 214, 214, 214, 
	212, 94, 34, 94, 214, 203, 214, 214, 
	213, 95, 216, 214, 90, 90, 214, 214, 
	214, 214, 212, 212, 34, 212, 213, 212, 
	212, 90, 218, 34, 218, 214, 203, 214, 
	214, 214, 213, 219, 216, 214, 90, 90, 
	217, 217, 217, 214, 217, 212, 122, 34, 
	122, 214, 203, 214, 214, 213, 219, 132, 
	216, 214, 90, 90, 214, 214, 214, 214, 
	212, 212, 34, 212, 203, 220, 216, 90, 
	90, 212, 221, 34, 221, 214, 226, 214, 
	214, 213, 95, 216, 214, 90, 90, 214, 
	214, 217, 214, 217, 212, 221, 34, 221, 
	92, 212, 92, 92, 91, 95, 92, 92, 
	92, 222, 92, 222, 90, 223, 34, 223, 
	92, 92, 92, 92, 91, 225, 92, 222, 
	222, 222, 92, 222, 90, 224, 34, 224, 
	92, 92, 92, 91, 225, 95, 92, 92, 
	92, 92, 92, 90, 224, 34, 224, 91, 
	225, 95, 90, 90, 34, 90, 221, 90, 
	94, 34, 94, 203, 213, 95, 216, 90, 
	90, 212, 221, 34, 221, 214, 226, 214, 
	214, 213, 95, 216, 214, 90, 90, 214, 
	214, 228, 214, 228, 212, 229, 34, 229, 
	214, 203, 214, 214, 214, 213, 219, 216, 
	214, 90, 90, 228, 228, 228, 214, 228, 
	212, 51, 34, 51, 214, 203, 214, 214, 
	213, 219, 28, 216, 214, 90, 90, 214, 
	214, 214, 214, 212, 0, 0
};

static const char _tsip_machine_parser_header_P_Asserted_Identity_trans_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 3, 3, 3, 13, 13, 
	13, 13, 3, 13, 13, 13, 13, 13, 
	13, 13, 0, 0, 0, 0, 0, 0, 
	3, 3, 3, 13, 13, 13, 13, 3, 
	13, 13, 13, 13, 13, 13, 13, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 7, 0, 9, 9, 9, 9, 
	0, 11, 0, 3, 3, 3, 13, 13, 
	13, 13, 3, 13, 13, 13, 13, 13, 
	13, 13, 0, 0, 0, 0, 0, 0, 
	3, 3, 3, 13, 13, 13, 13, 3, 
	13, 13, 13, 13, 13, 13, 13, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 5, 5, 5, 
	0, 0, 0, 5, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 5, 5, 5, 5, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 5, 5, 5, 0, 0, 0, 
	0, 5, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	16, 16, 16, 16, 0, 19, 16, 19, 
	13, 13, 13, 13, 16, 3, 13, 13, 
	13, 13, 13, 0, 16, 16, 16, 0, 
	0, 0, 16, 0, 0, 0, 0, 0, 
	0, 23, 16, 23, 0, 0, 0, 16, 
	5, 0, 0, 0, 0, 0, 0, 16, 
	16, 16, 16, 0, 0, 16, 16, 16, 
	16, 1, 1, 0, 16, 16, 16, 16, 
	0, 0, 0, 0, 0, 0, 16, 16, 
	16, 16, 0, 0, 16, 16, 16, 16, 
	0, 16, 16, 16, 16, 7, 0, 19, 
	16, 19, 13, 13, 13, 13, 16, 3, 
	7, 13, 13, 13, 13, 13, 0, 16, 
	16, 16, 0, 0, 0, 16, 7, 0, 
	0, 0, 0, 0, 0, 23, 16, 23, 
	0, 0, 0, 16, 5, 7, 0, 0, 
	0, 0, 0, 0, 16, 16, 16, 16, 
	0, 7, 0, 16, 16, 16, 16, 7, 
	1, 1, 0, 16, 16, 16, 0, 16, 
	7, 0, 0, 0, 0, 23, 16, 23, 
	16, 5, 7, 0, 19, 16, 19, 13, 
	13, 13, 13, 16, 3, 7, 0, 13, 
	0, 0, 13, 13, 13, 13, 13, 0, 
	16, 16, 16, 0, 0, 0, 0, 16, 
	7, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 23, 16, 23, 0, 0, 0, 
	0, 16, 5, 7, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 16, 16, 16, 
	16, 7, 0, 0, 0, 23, 16, 23, 
	0, 16, 5, 7, 0, 0, 0, 0, 
	16, 16, 16, 0, 0, 0, 0, 0, 
	16, 7, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 5, 16, 5, 0, 
	0, 0, 0, 16, 5, 7, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 16, 
	16, 16, 0, 16, 0, 0, 0, 0, 
	23, 16, 23, 16, 5, 0, 19, 16, 
	19, 13, 13, 13, 13, 16, 3, 0, 
	13, 0, 0, 13, 13, 13, 13, 13, 
	0, 16, 16, 16, 0, 0, 0, 0, 
	16, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 23, 16, 23, 0, 0, 0, 
	0, 16, 5, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 16, 16, 16, 16, 
	0, 0, 0, 23, 16, 23, 0, 16, 
	5, 0, 0, 0, 0, 16, 16, 16, 
	0, 0, 0, 0, 0, 16, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	5, 16, 5, 0, 0, 0, 0, 16, 
	5, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 5, 5, 5, 0, 0, 0, 
	0, 5, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	16, 16, 16, 16, 0, 27, 16, 27, 
	13, 13, 13, 13, 16, 3, 13, 13, 
	13, 13, 13, 13, 0, 16, 16, 16, 
	0, 0, 0, 16, 0, 0, 0, 0, 
	0, 0, 31, 16, 31, 0, 0, 0, 
	16, 5, 0, 0, 0, 0, 0, 0, 
	16, 16, 16, 16, 0, 0, 16, 16, 
	16, 16, 1, 1, 0, 16, 16, 16, 
	16, 0, 0, 0, 0, 0, 0, 16, 
	16, 16, 16, 0, 0, 16, 16, 16, 
	16, 0, 16, 16, 16, 16, 7, 0, 
	27, 16, 27, 13, 13, 13, 13, 16, 
	3, 7, 13, 13, 13, 13, 13, 13, 
	0, 16, 16, 16, 0, 0, 0, 16, 
	7, 0, 0, 0, 0, 0, 0, 31, 
	16, 31, 0, 0, 0, 16, 5, 7, 
	0, 0, 0, 0, 0, 0, 16, 16, 
	16, 16, 0, 7, 0, 16, 16, 16, 
	16, 7, 1, 1, 0, 16, 16, 16, 
	0, 16, 7, 0, 0, 0, 0, 31, 
	16, 31, 16, 5, 7, 0, 27, 16, 
	27, 13, 13, 13, 13, 16, 3, 7, 
	0, 13, 0, 0, 13, 13, 13, 13, 
	13, 0, 16, 16, 16, 0, 0, 0, 
	0, 16, 7, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 31, 16, 31, 0, 
	0, 0, 0, 16, 5, 7, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 16, 
	16, 16, 16, 7, 0, 0, 0, 31, 
	16, 31, 0, 16, 5, 7, 0, 0, 
	0, 0, 16, 16, 16, 0, 0, 0, 
	0, 0, 16, 0, 7, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 5, 
	16, 5, 0, 0, 0, 0, 16, 0, 
	5, 7, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 16, 16, 16, 0, 16, 
	7, 0, 0, 0, 0, 16, 16, 16, 
	0, 16, 7, 0, 0, 0, 0, 27, 
	16, 27, 13, 13, 13, 13, 16, 3, 
	7, 0, 13, 0, 0, 13, 13, 13, 
	13, 13, 0, 16, 16, 16, 0, 0, 
	0, 0, 16, 7, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 31, 16, 31, 
	0, 0, 0, 0, 16, 5, 7, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	16, 16, 16, 16, 7, 0, 0, 0, 
	16, 16, 16, 0, 0, 0, 0, 0, 
	16, 0, 7, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 23, 16, 23, 
	0, 0, 0, 0, 16, 0, 5, 7, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 16, 16, 16, 16, 0, 0, 0, 
	16, 16, 16, 16, 0, 19, 16, 19, 
	13, 13, 13, 13, 16, 3, 13, 13, 
	13, 13, 13, 0, 16, 16, 16, 0, 
	16, 0, 0, 0, 0, 19, 16, 19, 
	13, 13, 13, 13, 16, 3, 0, 13, 
	0, 0, 13, 13, 13, 13, 13, 0, 
	16, 16, 16, 0, 0, 0, 0, 16, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 23, 16, 23, 0, 0, 0, 0, 
	16, 5, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 16, 16, 16, 16, 0, 
	0, 0, 16, 16, 16, 0, 0, 0, 
	0, 0, 16, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 23, 16, 23, 
	0, 0, 0, 0, 16, 5, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 16, 
	16, 16, 16, 1, 1, 0, 16, 16, 
	16, 16, 0, 0, 0, 0, 0, 0, 
	16, 16, 16, 16, 0, 0, 16, 16, 
	16, 16, 0, 16, 16, 16, 16, 7, 
	0, 19, 16, 19, 13, 13, 13, 13, 
	16, 3, 7, 13, 13, 13, 13, 13, 
	0, 16, 16, 16, 0, 0, 0, 16, 
	7, 0, 0, 0, 0, 0, 0, 23, 
	16, 23, 0, 0, 0, 16, 5, 7, 
	0, 0, 0, 0, 0, 0, 16, 16, 
	16, 16, 0, 7, 0, 16, 16, 16, 
	16, 7, 1, 1, 0, 16, 16, 16, 
	16, 0, 19, 16, 19, 13, 13, 13, 
	13, 16, 3, 13, 13, 13, 13, 13, 
	13, 0, 16, 16, 16, 0, 0, 0, 
	16, 0, 0, 0, 0, 0, 0, 23, 
	16, 23, 0, 0, 0, 16, 5, 0, 
	0, 0, 0, 0, 0, 16, 16, 16, 
	16, 0, 0, 16, 16, 16, 0, 16, 
	0, 0, 0, 0, 23, 16, 23, 16, 
	5, 0, 19, 16, 19, 13, 13, 13, 
	13, 16, 3, 0, 13, 0, 0, 13, 
	13, 13, 13, 13, 0, 16, 16, 16, 
	0, 0, 0, 0, 16, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 23, 16, 
	23, 0, 0, 0, 0, 16, 5, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	16, 16, 16, 16, 0, 0, 0, 23, 
	16, 23, 0, 16, 5, 0, 0, 0, 
	0, 16, 16, 16, 0, 0, 0, 0, 
	0, 16, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 5, 16, 5, 0, 
	0, 0, 0, 16, 5, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 16, 16, 
	16, 0, 0, 0, 0, 16, 0, 0, 
	0, 0, 0, 0, 0, 0, 23, 16, 
	23, 0, 0, 0, 16, 0, 5, 0, 
	0, 0, 0, 0, 0, 16, 16, 16, 
	0, 16, 7, 0, 0, 0, 0, 23, 
	16, 23, 16, 5, 7, 0, 19, 16, 
	19, 13, 13, 13, 13, 16, 3, 7, 
	0, 13, 0, 0, 13, 13, 13, 13, 
	13, 0, 16, 16, 16, 0, 0, 0, 
	0, 16, 7, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 23, 16, 23, 0, 
	0, 0, 0, 16, 5, 7, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 16, 
	16, 16, 16, 7, 0, 0, 0, 23, 
	16, 23, 0, 16, 5, 7, 0, 0, 
	0, 0, 16, 16, 16, 0, 0, 0, 
	0, 0, 16, 7, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 5, 16, 
	5, 0, 0, 0, 0, 16, 5, 7, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 7, 0, 
	0, 7, 0, 0, 0, 7, 0, 0, 
	0, 0, 7, 0, 7, 1, 1, 0, 
	7, 0, 16, 16, 16, 16, 7, 0, 
	19, 16, 19, 13, 13, 13, 13, 16, 
	3, 7, 13, 13, 13, 13, 13, 0, 
	16, 16, 16, 0, 0, 0, 16, 7, 
	0, 0, 0, 0, 0, 0, 23, 16, 
	23, 0, 0, 0, 16, 5, 7, 0, 
	0, 0, 0, 0, 0, 16, 16, 16, 
	16, 0, 7, 0, 16, 16, 16, 16, 
	7, 1, 1, 0, 16, 16, 16, 16, 
	0, 7, 0, 0, 0, 0, 0, 16, 
	16, 16, 16, 0, 7, 0, 16, 16, 
	16, 16, 7, 0, 16, 16, 16, 0, 
	16, 7, 0, 0, 0, 0, 23, 16, 
	23, 16, 5, 7, 0, 19, 16, 19, 
	13, 13, 13, 13, 16, 3, 7, 0, 
	13, 0, 0, 13, 13, 13, 13, 13, 
	0, 16, 16, 16, 0, 0, 0, 0, 
	16, 7, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 23, 16, 23, 0, 0, 
	0, 0, 16, 5, 7, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 16, 16, 
	16, 16, 7, 0, 0, 0, 23, 16, 
	23, 0, 16, 5, 7, 0, 0, 0, 
	0, 16, 16, 16, 0, 0, 0, 0, 
	0, 16, 7, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 5, 16, 5, 
	0, 0, 0, 0, 16, 5, 7, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	16, 16, 16, 0, 16, 7, 0, 0, 
	0, 0, 27, 16, 27, 13, 13, 13, 
	13, 16, 3, 7, 0, 13, 0, 0, 
	13, 13, 13, 13, 13, 0, 27, 16, 
	27, 13, 13, 13, 13, 16, 3, 7, 
	13, 13, 13, 13, 13, 13, 0, 16, 
	16, 16, 0, 0, 0, 0, 16, 0, 
	7, 0, 0, 0, 0, 0, 0, 0, 
	31, 16, 31, 0, 0, 0, 16, 0, 
	5, 7, 0, 0, 0, 0, 0, 0, 
	16, 16, 16, 16, 0, 0, 7, 0, 
	16, 16, 16, 16, 7, 0, 31, 16, 
	31, 0, 16, 5, 7, 0, 0, 0, 
	0, 27, 16, 27, 13, 13, 13, 13, 
	16, 3, 7, 0, 13, 0, 0, 13, 
	13, 13, 13, 13, 0, 16, 16, 16, 
	0, 0, 0, 0, 0, 16, 0, 7, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 5, 16, 5, 0, 0, 0, 
	0, 16, 0, 5, 7, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 16, 16, 
	16, 0, 16, 0, 0, 0, 0, 31, 
	16, 31, 16, 5, 0, 27, 16, 27, 
	13, 13, 13, 13, 16, 3, 0, 13, 
	0, 0, 13, 13, 13, 13, 13, 0, 
	16, 16, 16, 0, 0, 0, 0, 16, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 31, 16, 31, 0, 0, 0, 0, 
	16, 5, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 16, 16, 16, 16, 0, 
	0, 0, 31, 16, 31, 0, 16, 5, 
	0, 0, 0, 0, 16, 16, 16, 0, 
	0, 0, 0, 0, 16, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	5, 16, 5, 0, 0, 0, 0, 16, 
	0, 5, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 16, 16, 16, 0, 16, 
	0, 0, 0, 0, 16, 16, 16, 0, 
	16, 0, 0, 0, 0, 27, 16, 27, 
	13, 13, 13, 13, 16, 3, 0, 13, 
	0, 0, 13, 13, 13, 13, 13, 0, 
	16, 16, 16, 0, 0, 0, 0, 16, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 31, 16, 31, 0, 0, 0, 0, 
	16, 5, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 16, 16, 16, 16, 0, 
	0, 0, 16, 16, 16, 0, 0, 0, 
	0, 0, 16, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 23, 16, 
	23, 0, 0, 0, 0, 16, 0, 5, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 16, 16, 16, 0, 16, 0, 0, 
	0, 0, 27, 16, 27, 13, 13, 13, 
	13, 16, 3, 0, 13, 0, 0, 13, 
	13, 13, 13, 13, 0, 27, 16, 27, 
	13, 13, 13, 13, 16, 3, 13, 13, 
	13, 13, 13, 13, 0, 16, 16, 16, 
	0, 0, 0, 0, 16, 0, 0, 0, 
	0, 0, 0, 0, 0, 31, 16, 31, 
	0, 0, 0, 16, 0, 5, 0, 0, 
	0, 0, 0, 0, 16, 16, 16, 16, 
	0, 0, 0, 16, 16, 16, 16, 0, 
	31, 16, 31, 0, 16, 5, 0, 0, 
	0, 0, 27, 16, 27, 13, 13, 13, 
	13, 16, 3, 0, 13, 0, 0, 13, 
	13, 13, 13, 13, 0, 16, 16, 16, 
	0, 0, 0, 0, 0, 16, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 5, 16, 5, 0, 0, 0, 0, 
	16, 0, 5, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0
};

static const int tsip_machine_parser_header_P_Asserted_Identity_start = 1;
static const int tsip_machine_parser_header_P_Asserted_Identity_first_final = 230;
static const int tsip_machine_parser_header_P_Asserted_Identity_error = 0;

static const int tsip_machine_parser_header_P_Asserted_Identity_en_main = 1;


/* #line 136 "./ragel/tsip_parser_header_P_Asserted_Identity.rl" */
	(void)(eof);
	(void)(tsip_machine_parser_header_P_Asserted_Identity_first_final);
	(void)(tsip_machine_parser_header_P_Asserted_Identity_error);
	(void)(tsip_machine_parser_header_P_Asserted_Identity_en_main);
	
/* #line 1225 "./src/headers/tsip_header_P_Asserted_Identity.c" */
	{
	cs = tsip_machine_parser_header_P_Asserted_Identity_start;
	}

/* #line 141 "./ragel/tsip_parser_header_P_Asserted_Identity.rl" */
	
/* #line 1232 "./src/headers/tsip_header_P_Asserted_Identity.c" */
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _tsip_machine_parser_header_P_Asserted_Identity_trans_keys + _tsip_machine_parser_header_P_Asserted_Identity_key_offsets[cs];
	_trans = _tsip_machine_parser_header_P_Asserted_Identity_index_offsets[cs];

	_klen = _tsip_machine_parser_header_P_Asserted_Identity_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _tsip_machine_parser_header_P_Asserted_Identity_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += ((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _tsip_machine_parser_header_P_Asserted_Identity_trans_targs[_trans];

	if ( _tsip_machine_parser_header_P_Asserted_Identity_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _tsip_machine_parser_header_P_Asserted_Identity_actions + _tsip_machine_parser_header_P_Asserted_Identity_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
/* #line 51 "./ragel/tsip_parser_header_P_Asserted_Identity.rl" */
	{
		tag_start = p;
	}
	break;
	case 1:
/* #line 55 "./ragel/tsip_parser_header_P_Asserted_Identity.rl" */
	{
		if(!curr_p_asserted_identity){
			curr_p_asserted_identity = tsip_header_P_Asserted_Identity_create();
		}
	}
	break;
	case 2:
/* #line 61 "./ragel/tsip_parser_header_P_Asserted_Identity.rl" */
	{
		if(curr_p_asserted_identity){
			TSK_PARSER_SET_STRING(curr_p_asserted_identity->display_name);
			tsk_strunquote(&curr_p_asserted_identity->display_name);
		}
	}
	break;
	case 3:
/* #line 68 "./ragel/tsip_parser_header_P_Asserted_Identity.rl" */
	{
		if(curr_p_asserted_identity && !curr_p_asserted_identity->uri){
			int len = (int)(p  - tag_start);
			if(curr_p_asserted_identity && !curr_p_asserted_identity->uri){
				if((curr_p_asserted_identity->uri = tsip_uri_parse(tag_start, (tsk_size_t)len)) && curr_p_asserted_identity->display_name){
					curr_p_asserted_identity->uri->display_name = tsk_strdup(curr_p_asserted_identity->display_name);
				}
			}
		}
	}
	break;
	case 4:
/* #line 79 "./ragel/tsip_parser_header_P_Asserted_Identity.rl" */
	{
		if(curr_p_asserted_identity){
			tsk_list_push_back_data(hdr_p_asserted_identities, ((void**) &curr_p_asserted_identity));
		}
	}
	break;
	case 5:
/* #line 85 "./ragel/tsip_parser_header_P_Asserted_Identity.rl" */
	{
	}
	break;
/* #line 1354 "./src/headers/tsip_header_P_Asserted_Identity.c" */
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	_out: {}
	}

/* #line 142 "./ragel/tsip_parser_header_P_Asserted_Identity.rl" */
	
	if( cs < 
/* #line 1370 "./src/headers/tsip_header_P_Asserted_Identity.c" */
230
/* #line 143 "./ragel/tsip_parser_header_P_Asserted_Identity.rl" */
 ){
		TSK_DEBUG_ERROR("Failed to parse 'P-Asserted-Identity' header.");
		TSK_OBJECT_SAFE_FREE(curr_p_asserted_identity);
		TSK_OBJECT_SAFE_FREE(hdr_p_asserted_identities);
	}
	
	return hdr_p_asserted_identities;
}





//========================================================
//	P_Asserted_Identity header object definition
//

/**@ingroup tsip_header_P_Asserted_Identity_group
*/
static tsk_object_t* tsip_header_P_Asserted_Identity_ctor(tsk_object_t *self, va_list * app)
{
	tsip_header_P_Asserted_Identity_t *P_Asserted_Identity = self;
	if(P_Asserted_Identity){
		TSIP_HEADER(P_Asserted_Identity)->type = tsip_htype_P_Asserted_Identity;
		TSIP_HEADER(P_Asserted_Identity)->serialize = tsip_header_P_Asserted_Identity_serialize;
	}
	else{
		TSK_DEBUG_ERROR("Failed to create new P_Asserted_Identity header.");
	}
	return self;
}

/**@ingroup tsip_header_P_Asserted_Identity_group
*/
static tsk_object_t* tsip_header_P_Asserted_Identity_dtor(tsk_object_t *self)
{
	tsip_header_P_Asserted_Identity_t *P_Asserted_Identity = self;
	if(P_Asserted_Identity){
		TSK_FREE(P_Asserted_Identity->display_name);
		TSK_OBJECT_SAFE_FREE(P_Asserted_Identity->uri);

		TSK_OBJECT_SAFE_FREE(TSIP_HEADER_PARAMS(P_Asserted_Identity));
	}
	else{
		TSK_DEBUG_ERROR("Null P_Asserted_Identity header.");
	}

	return self;
}

static const tsk_object_def_t tsip_header_P_Asserted_Identity_def_s = 
{
	sizeof(tsip_header_P_Asserted_Identity_t),
	tsip_header_P_Asserted_Identity_ctor,
	tsip_header_P_Asserted_Identity_dtor,
	tsk_null
};
const tsk_object_def_t *tsip_header_P_Asserted_Identity_def_t = &tsip_header_P_Asserted_Identity_def_s;
