/*
* Copyright (C) 2017, University of the Basque Country (UPV/EHU)
* Contact for licensing options: <licensing-mcpttclient(at)mcopenplatform(dot)com>
*
* The original file was part of Open Source Doubango Framework
* Copyright (C) 2010-2011 Mamadou Diop.
* Copyright (C) 2012 Doubango Telecom <http://doubango.org>
*
* This file is part of Open Source Doubango Framework.
*
* DOUBANGO is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* DOUBANGO is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with DOUBANGO.
*
*/

/**@file tsip_api_register.h
 * @brief Public registration (REGISTER) functions.
 *
 * @author Mamadou Diop <diopmamadou(at)doubango[dot]org>
 *

 */
#ifndef TINYSIP_TSIP_REGISTER_H
#define TINYSIP_TSIP_REGISTER_H

#include "tinysip_config.h"

#include "tinysip/tsip_event.h"

TSIP_BEGIN_DECLS

#define TSIP_REGISTER_EVENT(self)		((tsip_register_event_t*)(self))



#define TSIP_REGISTER_AUTHENTICATION_EVENT(self)		((tsip_register_authentication_event_t*)(self))

typedef enum tsip_register_authentication_event_type_e
{

	tsip_i_register_authentication,// authentication

}
tsip_register_authentication_event_type_t;

typedef struct tsip_register_authentication_event_e
{
	TSIP_DECLARE_EVENT;

	tsip_register_authentication_event_type_t type;
}
tsip_register_authentication_event_t;

//@tinyWRAP
typedef enum tsip_register_event_type_e
{
	tsip_i_newreg,

	tsip_i_register, // refresh
	tsip_ao_register,

	tsip_i_unregister,
	tsip_ao_unregister,
}
tsip_register_event_type_t;



typedef struct tsip_register_event_e
{
	TSIP_DECLARE_EVENT;

	tsip_register_event_type_t type;
}
tsip_register_event_t;

int tsip_register_event_signal(tsip_register_event_type_t type, tsip_ssession_t* ss, short status_code, const char *phrase, const struct tsip_message_s* sipmessage);
int tsip_register_authentication_event_signal(tsip_register_authentication_event_type_t type, tsip_ssession_t* ss, short status_code, const char *phrase, const struct tsip_message_s* sipmessage);


TINYSIP_API int tsip_api_register_send_register(const tsip_ssession_handle_t *ss, ...);
TINYSIP_API int tsip_api_register_send_unregister(const tsip_ssession_handle_t *ss, ...);

TINYSIP_GEXTERN const tsk_object_def_t *tsip_register_event_def_t;

TINYSIP_GEXTERN const tsk_object_def_t *tsip_register_authentication_event_def_t;

#if 1 // Backward Compatibility
#	define tsip_action_REGISTER	tsip_api_register_send_register
#	define tsip_action_UNREGISTER	tsip_api_register_send_unregister
#endif

TSIP_END_DECLS

#endif /* TINYSIP_TSIP_REGISTER_H */
