/*
 * Decompiled with CFR 0.152.
 */
package com.expway.msp.rpc;

import com.expway.msp.IMspAcquisition;
import com.expway.msp.MspException;
import com.expway.msp.event.acquisition.AcquisitionCompletedEvent;
import com.expway.msp.event.acquisition.AcquisitionErrorEvent;
import com.expway.msp.event.acquisition.AcquisitionEvent;
import com.expway.msp.event.acquisition.AcquisitionProgressEvent;
import com.expway.msp.event.acquisition.IAcquisitionListener;
import com.expway.msp.event.acquisition.IMetadataListener;
import com.expway.msp.event.acquisition.MetadataEvent;
import com.expway.msp.event.bootstrap.BootstrapEvent;
import com.expway.msp.event.bootstrap.BootstrapFailureEvent;
import com.expway.msp.event.bootstrap.IBootstrapListener;
import com.expway.msp.rpc.MspAbstractModule;
import java.util.ArrayList;

abstract class MspModuleAcquisition
extends MspAbstractModule
implements IMspAcquisition {
    private ArrayList<IAcquisitionListener> all_acquisition_listeners = new ArrayList();
    private ArrayList<IMetadataListener> all_metadata_listeners = new ArrayList();
    private ArrayList<IBootstrapListener> all_bootstrap_listeners = new ArrayList();

    MspModuleAcquisition() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAcquisitionListener(IAcquisitionListener listener) {
        ArrayList<IAcquisitionListener> arrayList = this.all_acquisition_listeners;
        synchronized (arrayList) {
            this.all_acquisition_listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAcquisitionListener(IAcquisitionListener listener) {
        ArrayList<IAcquisitionListener> arrayList = this.all_acquisition_listeners;
        synchronized (arrayList) {
            this.all_acquisition_listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireAcquisitionStartedEvent(AcquisitionEvent event) {
        ArrayList<IAcquisitionListener> arrayList = this.all_acquisition_listeners;
        synchronized (arrayList) {
            for (IAcquisitionListener l : this.all_acquisition_listeners) {
                try {
                    l.acquisitionStarted(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireAcquisitionEndedEvent(AcquisitionEvent event) {
        ArrayList<IAcquisitionListener> arrayList = this.all_acquisition_listeners;
        synchronized (arrayList) {
            for (IAcquisitionListener l : this.all_acquisition_listeners) {
                try {
                    l.acquisitionEnded(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireAcquisitionProgressEvent(AcquisitionProgressEvent event) {
        ArrayList<IAcquisitionListener> arrayList = this.all_acquisition_listeners;
        synchronized (arrayList) {
            for (IAcquisitionListener l : this.all_acquisition_listeners) {
                try {
                    l.acquisitionProgress(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireAcquisitionCompletedEvent(AcquisitionCompletedEvent event) {
        ArrayList<IAcquisitionListener> arrayList = this.all_acquisition_listeners;
        synchronized (arrayList) {
            for (IAcquisitionListener l : this.all_acquisition_listeners) {
                try {
                    l.acquisitionSessionCompleted(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireAcquisitionErrorEvent(AcquisitionErrorEvent event) {
        ArrayList<IAcquisitionListener> arrayList = this.all_acquisition_listeners;
        synchronized (arrayList) {
            for (IAcquisitionListener l : this.all_acquisition_listeners) {
                try {
                    l.acquisitionError(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    @Override
    public abstract void acquisitionStart() throws MspException;

    @Override
    public abstract void acquisitionStop() throws MspException;

    @Override
    public abstract void acquisitionLoadBootstrap() throws MspException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMetadataListener(IMetadataListener listener) {
        ArrayList<IMetadataListener> arrayList = this.all_metadata_listeners;
        synchronized (arrayList) {
            this.all_metadata_listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMetadataListener(IMetadataListener listener) {
        ArrayList<IMetadataListener> arrayList = this.all_metadata_listeners;
        synchronized (arrayList) {
            this.all_metadata_listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireMetadataChangedEvent(MetadataEvent event) {
        ArrayList<IMetadataListener> arrayList = this.all_metadata_listeners;
        synchronized (arrayList) {
            for (IMetadataListener l : this.all_metadata_listeners) {
                try {
                    l.metadataChanged(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBootstrapListener(IBootstrapListener listener) {
        ArrayList<IBootstrapListener> arrayList = this.all_bootstrap_listeners;
        synchronized (arrayList) {
            this.all_bootstrap_listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBootstrapListener(IBootstrapListener listener) {
        ArrayList<IBootstrapListener> arrayList = this.all_bootstrap_listeners;
        synchronized (arrayList) {
            this.all_bootstrap_listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireBootstrapLoadStartedEvent(BootstrapEvent event) {
        ArrayList<IBootstrapListener> arrayList = this.all_bootstrap_listeners;
        synchronized (arrayList) {
            for (IBootstrapListener l : this.all_bootstrap_listeners) {
                try {
                    l.loadStarted(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireBootstrapLoadSuccessEvent(BootstrapEvent event) {
        ArrayList<IBootstrapListener> arrayList = this.all_bootstrap_listeners;
        synchronized (arrayList) {
            for (IBootstrapListener l : this.all_bootstrap_listeners) {
                try {
                    l.loadSuccess(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireBootstrapLoadFailedEvent(BootstrapFailureEvent event) {
        ArrayList<IBootstrapListener> arrayList = this.all_bootstrap_listeners;
        synchronized (arrayList) {
            for (IBootstrapListener l : this.all_bootstrap_listeners) {
                try {
                    l.loadFailed(event);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }
}

