/*
 * Decompiled with CFR 0.152.
 */
package com.expway.msp;

import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class MspRegistrationParameters {
    protected static final String SIGNATURE_HASH_ALGORITHM = "SHA1";
    private final String user_id;
    private final URL asp_server_url;
    private final String[] service_class_types;
    private final byte[] signature;
    private final byte[] signature_hash;
    private final String package_name;

    MspRegistrationParameters unregister(String ... service_classes) {
        ArrayList<String> new_service_classes = new ArrayList<String>();
        block0: for (String service_class : this.service_class_types) {
            for (String service_class_unreg : service_classes) {
                if (service_class_unreg.equals(service_class)) continue block0;
            }
            new_service_classes.add(service_class);
        }
        if (new_service_classes.size() == this.service_class_types.length) {
            return this;
        }
        String[] sct = new_service_classes.toArray(new String[new_service_classes.size()]);
        return new MspRegistrationParameters(this.user_id, this.package_name, this.asp_server_url, this.signature, sct);
    }

    public MspRegistrationParameters(String user_id, String app_package_name, String ... service_class_types) {
        this(user_id, app_package_name, (URL)null, (byte[])null, service_class_types);
    }

    public MspRegistrationParameters(String user_id, String app_package_name, URL asp_server_url, byte[] app_signature, String ... service_class_types) {
        byte[] hash;
        this.user_id = user_id;
        this.asp_server_url = asp_server_url;
        this.package_name = app_package_name;
        this.signature = app_signature;
        this.service_class_types = service_class_types;
        if (this.signature == null) {
            hash = null;
        } else {
            try {
                MessageDigest digest = MessageDigest.getInstance(SIGNATURE_HASH_ALGORITHM);
                hash = digest.digest(this.signature);
            }
            catch (NoSuchAlgorithmException e) {
                Object hash2 = null;
                throw new RuntimeException("JVM cannot be used. Algorithm not found: SHA1", e);
            }
        }
        this.signature_hash = hash;
    }

    public String getUserIdentifier() {
        return this.user_id;
    }

    public URL getAspServerUrl() {
        return this.asp_server_url;
    }

    public String[] getServiceClassTypes() {
        return this.service_class_types;
    }

    public String getPackageName() {
        return this.package_name;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public byte[] getSignatureHash() {
        return this.signature_hash;
    }

    public static String getHex(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(Integer.toHexString(2048 + b).substring(1));
        }
        return sb.toString();
    }

    public String getSignatureHex() {
        return MspRegistrationParameters.getHex(this.signature);
    }

    public boolean equals(Object o) {
        return o instanceof MspRegistrationParameters && this.equals((MspRegistrationParameters)o);
    }

    private static boolean sameContent(String[] a, String[] b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        HashSet<String> hsa = new HashSet<String>();
        HashSet<String> hsb = new HashSet<String>();
        for (String s : a) {
            hsa.add(s);
        }
        for (String s : b) {
            if (!hsa.contains(s)) {
                return false;
            }
            hsb.add(s);
        }
        for (String s : a) {
            if (hsb.contains(s)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(MspRegistrationParameters o) {
        return o != null && o.user_id.equals(this.user_id) && (o.asp_server_url == null ? this.asp_server_url == null : o.asp_server_url.equals(this.asp_server_url)) && (o.package_name == null ? this.package_name == null : o.package_name.equals(this.package_name)) && (o.signature == null ? this.signature == null : Arrays.equals(o.signature, this.signature)) && MspRegistrationParameters.sameContent(o.service_class_types, this.service_class_types);
    }

    public String toString() {
        return "user=" + this.user_id + " asp url=" + this.asp_server_url + " PKG=" + this.package_name + " SIGN=" + this.getSignatureHex() + " SCT=" + Arrays.toString(this.service_class_types);
    }
}

