/*
* Copyright (C) 2020, University of the Basque Country (UPV/EHU)
* Contact for licensing options: <licensing-mcpttclient(at)mcopenplatform(dot)com>
*
* The original file was part of Open Source Doubango Framework
* Copyright (C) 2010-2011 Mamadou Diop.
* Copyright (C) 2012 Doubango Telecom <http://doubango.org>
*
* This file is part of Open Source Doubango Framework.
*
* DOUBANGO is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* DOUBANGO is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with DOUBANGO.
*
*/

/**@file tinynet.h
 * @brief API functions.
 *
 * @author Mamadou Diop <diopmamadou(at)doubango[dot]org>
 *

 */
#ifndef TNET_TINYNET_H
#define TNET_TINYNET_H

/* === tinySAK === */
#include "tsk.h"

/* === tinyNET === */

#include "tnet.h"
#include "tnet_endianness.h"
#include "tnet_nat.h"
#include "tnet_socket.h"
#include "tnet_transport.h"

#include "stun/tnet_stun.h"

#include "ice/tnet_ice_event.h"
#include "ice/tnet_ice_candidate.h"
#include "ice/tnet_ice_ctx.h"

#include "dns/tnet_dns.h"
#include "dns/tnet_dns_naptr.h"
#include "dns/tnet_dns_regexp.h"
#include "dns/tnet_dns_resolvconf.h"

#include "dhcp/tnet_dhcp.h"
#include "dhcp/tnet_dhcp_option_sip.h"

#include "dhcp6/tnet_dhcp6.h"
#include "dhcp6/tnet_dhcp6_option.h"


#endif /* TNET_TINYNET_H */

