/*
 * Decompiled with CFR 0.152.
 */
package com.expway.msp.rpc;

import com.expway.msp.rpc.ChunkedInputStream;
import com.expway.msp.rpc.EwHttpResponse;
import com.expway.msp.rpc.LimitedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;

class EwHttpClient {
    private static final int DEFAULT_MAX_REQUESTS = -1;
    private InetAddress server_address;
    private String server_host;
    private String server_fullhost;
    private int server_port;
    private boolean ssl = false;
    private boolean will_close = false;
    private int remaining_request_count;
    private Socket socket;
    private InputStream in;
    private OutputStream out;
    private String path;
    private int read_timeout = 0;
    private int max_request_per_socket = -1;
    private long inter_request_timeout_s = -1L;
    private static InetAddress[] local_interfaces;
    public static final String DEFAULT_USER_AGENT = "Expway-HTTP-Java-client/1.0";
    public static final String HEADER_ACCEPT = "Accept";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_CONTENT_LENGTH = "Content-Length";
    public static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String HEADER_USER_AGENT = "User-Agent";
    private static final String HEADER_TRANSFER_ENCODING = "Transfer-Encoding";
    private static final String HEADER_CONNECTION = "Connection";
    private static final String HEADER_KEEP_ALIVE = "Keep-Alive";
    private static final String HEADER_HOST = "Host";
    private static final String[] RESERVED_HEADERS;
    private static final String[] RESERVED_HEADER_PREFIXES;
    private static final String[][] FIRST_HEADERS;
    private static final byte[] HTTP_GET;
    private static final byte[] HTTP_POST;
    private static final byte[] HTTP_VERSION;
    private static final byte[] CHUNK_END;
    private static final byte[] NEW_LINE;
    private static final byte[] HEADER_SEP;
    boolean request_sent = false;
    int response_code;
    String response_message;
    InputStream response_in;
    Map<String, String> response_headers;
    private final char[] line_buffer = new char[4096];
    private boolean response_parsed = false;

    EwHttpClient() {
    }

    public boolean isConnectionOpened() {
        return this.socket != null && !this.will_close;
    }

    public void setReadTimeout(int timeout_ms) {
        if (this.read_timeout != timeout_ms) {
            this.read_timeout = timeout_ms;
        }
    }

    public void setKeepAliveMax(int max) {
        this.max_request_per_socket = (long)max <= 0L ? -1 : max;
    }

    public void setKeepAliveTimeout(long timeout_ms) {
        this.inter_request_timeout_s = timeout_ms < 1000L ? -1L : timeout_ms / 1000L;
    }

    private static boolean isLocalInterface(InetAddress address) throws SocketException {
        if (address.isLoopbackAddress()) {
            return true;
        }
        if (local_interfaces == null) {
            ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
            Enumeration<NetworkInterface> netifs = NetworkInterface.getNetworkInterfaces();
            while (netifs.hasMoreElements()) {
                NetworkInterface ni = netifs.nextElement();
                Enumeration<InetAddress> addrs = ni.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    addresses.add(addr);
                }
            }
            local_interfaces = addresses.toArray(new InetAddress[addresses.size()]);
        }
        for (InetAddress addr : local_interfaces) {
            if (!addr.equals(address)) continue;
            return true;
        }
        return false;
    }

    public String getSocketInfo() {
        Socket soc = this.socket;
        return soc == null ? "--" : soc.getLocalAddress() + ":" + soc.getLocalPort() + ">>" + soc.getInetAddress() + ":" + soc.getPort();
    }

    private void openSocket() throws IOException {
        if (this.socket == null) {
            InetAddress local_netif;
            InetAddress inetAddress = local_netif = EwHttpClient.isLocalInterface(this.server_address) ? this.server_address : null;
            if (local_netif == null) {
                System.out.println("WARNING: Opening socket using the system routing table...");
                this.socket = this.ssl ? SSLSocketFactory.getDefault().createSocket(this.server_address, this.server_port) : new Socket(this.server_address, this.server_port);
            } else {
                this.socket = this.ssl ? SSLSocketFactory.getDefault().createSocket(this.server_address, this.server_port, local_netif, 0) : new Socket(this.server_address, this.server_port, local_netif, 0);
                if (!local_netif.equals(this.socket.getLocalAddress())) {
                    System.out.println("WARNING: The opened socket is not bound to the requested network interface. Connection may be unreliable.");
                }
            }
            if (this.read_timeout > 0) {
                this.socket.setSoTimeout(this.read_timeout);
            }
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
            this.remaining_request_count = this.max_request_per_socket;
            this.will_close = false;
            this.resetRequestState();
        }
    }

    private void closeSocket(String reason) throws IOException {
        try {
            if (this.socket != null) {
                this.socket.close();
                this.in = null;
                this.out = null;
                this.socket = null;
                this.flushResponse();
            }
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
            throw ioex;
        }
    }

    public void setServerHost(String server) throws IOException {
        this.setServerHost(server, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setServerHost(String server, boolean https) throws IOException {
        int port;
        int j;
        String hname;
        int i;
        if (server.startsWith("[") && (i = server.lastIndexOf(93)) >= 0) {
            hname = server.substring(1, i);
            if (i == server.length() - 1) {
                j = -1;
            } else {
                if (server.charAt(i + 1) != ':') throw new IllegalArgumentException("Invalid hostname and port syntax: " + server);
                j = i + 1;
            }
        } else {
            j = server.lastIndexOf(58);
            hname = j < 0 ? server : server.substring(0, j);
        }
        InetAddress address = InetAddress.getByName(hname);
        if (j < 0) {
            port = https ? 443 : 80;
        } else {
            String hport = server.substring(j + 1);
            try {
                port = Integer.parseInt(hport);
                if (port < 1 || port > 65535) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException nfx) {
                throw new IllegalArgumentException("Invalid port number: " + hport);
            }
        }
        if (address.equals(this.server_address) && hname.equals(this.server_host) && port == this.server_port && https == this.ssl) return;
        this.server_fullhost = server;
        this.server_address = address;
        this.server_host = hname;
        this.server_port = port;
        this.ssl = https;
        this.closeSocket("Server URL modified.");
    }

    private static void assertNoNewLine(String s) {
        if (s.indexOf(13) >= 0 || s.indexOf(10) >= 0) {
            throw new IllegalArgumentException("Special characters need to be escaped");
        }
    }

    private static String getHeader(Map<String, String> headers, String name, String default_value) {
        if (headers == null) {
            return default_value;
        }
        String v = headers.get(name);
        if (v != null) {
            headers.remove(name);
        }
        return v == null ? default_value : v;
    }

    private void resetRequestState() {
        this.response_headers = null;
        this.request_sent = false;
        this.response_parsed = false;
    }

    private void writeHeader(String name, String value) throws IOException {
        this.out.write(name.getBytes());
        this.out.write(HEADER_SEP);
        this.out.write(value.getBytes());
        this.out.write(NEW_LINE);
    }

    private void writeChunk(byte[] b) throws IOException {
        this.writeChunk(b, 0, b.length);
    }

    private void writeChunk(byte[] b, int ofs, int len) throws IOException {
        if (len > 0) {
            this.out.write(Integer.toHexString(len).getBytes());
            this.out.write(NEW_LINE);
            this.out.write(b, ofs, len);
            this.out.write(NEW_LINE);
        }
    }

    private void writeHeader(Map<String, String> headers, String name, String default_value) throws IOException {
        String v = EwHttpClient.getHeader(headers, name, default_value);
        if (v != null) {
            this.writeHeader(name, v);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void openRequest(Object send_entity, Map<String, String> headers) throws IOException {
        if (this.remaining_request_count == 0) {
            this.closeSocket(this.socket == null ? "Not connected" : "Keep-Alive limit reached.");
        } else if (this.request_sent) {
            this.flushResponse();
        }
        if (headers != null) {
            String[][] to_remove = new HashSet();
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                String name = entry.getKey();
                EwHttpClient.assertNoNewLine(name);
                EwHttpClient.assertNoNewLine(entry.getValue());
                for (String reserved_prefix : RESERVED_HEADER_PREFIXES) {
                    if (!name.startsWith(reserved_prefix)) continue;
                    to_remove.add(name);
                }
            }
            headers = new HashMap<String, String>(headers);
            for (String reserved_header : RESERVED_HEADERS) {
                headers.remove(reserved_header);
            }
            Iterator iterator = to_remove.iterator();
            while (iterator.hasNext()) {
                String reserved_header = (String)iterator.next();
                headers.remove(reserved_header);
            }
        }
        this.openSocket();
        if (this.remaining_request_count > 0) {
            --this.remaining_request_count;
        }
        this.request_sent = false;
        this.response_parsed = false;
        try {
            void var4_13;
            this.out.write(send_entity == null ? HTTP_GET : HTTP_POST);
            this.out.write(this.path.getBytes());
            this.out.write(HTTP_VERSION);
            this.writeHeader(HEADER_HOST, this.server_fullhost);
            for (String[] first_header : FIRST_HEADERS) {
                this.writeHeader(headers, first_header[0], first_header[1]);
            }
            boolean bl = this.will_close = (long)this.remaining_request_count == 0L;
            if (this.will_close) {
                this.writeHeader(HEADER_CONNECTION, "close");
            } else {
                this.writeHeader(HEADER_CONNECTION, HEADER_KEEP_ALIVE);
                if (this.inter_request_timeout_s > 0L) {
                    if (this.remaining_request_count > 0) {
                        this.writeHeader(HEADER_KEEP_ALIVE, "max=" + this.remaining_request_count + ",timeout=" + this.inter_request_timeout_s);
                    } else {
                        this.writeHeader(HEADER_KEEP_ALIVE, "timeout=" + this.inter_request_timeout_s);
                    }
                } else if (this.remaining_request_count > 0) {
                    this.writeHeader(HEADER_KEEP_ALIVE, "max=" + this.remaining_request_count);
                }
            }
            for (Map.Entry entry : headers.entrySet()) {
                this.writeHeader((String)entry.getKey(), (String)entry.getValue());
            }
            byte[] entity_buffer = null;
            Object var4_10 = null;
            int buffer_size = -1;
            if (send_entity != null) {
                if (send_entity instanceof byte[]) {
                    entity_buffer = (byte[])send_entity;
                } else if (send_entity instanceof InputStream) {
                    int len;
                    InputStream inputStream = (InputStream)send_entity;
                    entity_buffer = new byte[8192];
                    for (int total = 0; total < entity_buffer.length; total += len) {
                        len = inputStream.read(entity_buffer, total, entity_buffer.length - total);
                        if (len >= 0) continue;
                        buffer_size = total;
                        Object var4_12 = null;
                        break;
                    }
                }
                if (var4_13 == null) {
                    this.writeHeader(HEADER_CONTENT_LENGTH, "" + (buffer_size < 0 ? entity_buffer.length : buffer_size));
                } else {
                    this.writeHeader(HEADER_TRANSFER_ENCODING, "chunked");
                }
            }
            this.out.write(NEW_LINE);
            if (var4_13 == null) {
                if (entity_buffer != null) {
                    this.out.write(entity_buffer);
                }
            } else {
                int len;
                if (entity_buffer != null) {
                    this.writeChunk(entity_buffer);
                }
                while ((len = var4_13.read(entity_buffer)) >= 0) {
                    this.writeChunk(entity_buffer, 0, len);
                }
                this.out.write(CHUNK_END);
            }
            this.request_sent = true;
        }
        catch (IOException ioex) {
            this.closeSocket("Request I/O error: " + ioex.getMessage());
            throw ioex;
        }
    }

    public void open(URL url) throws IOException {
        this.openInternal(url.toString(), null, null);
    }

    public void open(URL url, String s, Map<String, String> headers) throws IOException {
        this.openInternal(url.toString(), s == null ? null : s.getBytes(), headers);
    }

    public void open(URL url, byte[] b, Map<String, String> headers) throws IOException {
        this.openInternal(url.toString(), b, headers);
    }

    public void open(URL url, InputStream in, Map<String, String> headers) throws IOException {
        this.openInternal(url.toString(), in, headers);
    }

    public void open(String url) throws IOException {
        this.openInternal(url, null, null);
    }

    public void open(String url, String s, Map<String, String> headers) throws IOException {
        this.openInternal(url, s == null ? null : s.getBytes(), headers);
    }

    public void open(String url, byte[] b, Map<String, String> headers) throws IOException {
        this.openInternal(url, b, headers);
    }

    public void open(String url, InputStream in, Map<String, String> headers) throws IOException {
        this.openInternal(url, in, headers);
    }

    public void close(String reason) throws IOException {
        this.will_close = true;
        this.closeSocket(reason);
    }

    private void openInternal(String url, Object send_entity, Map<String, String> headers) throws IOException {
        EwHttpClient.assertNoNewLine(url);
        int i = url.indexOf("://");
        int j = url.indexOf(47);
        boolean https = this.ssl;
        if (i >= 0 && i < j) {
            String protocol = url.substring(0, i);
            if (protocol.equalsIgnoreCase("http")) {
                https = false;
            } else if (protocol.equalsIgnoreCase("https")) {
                https = true;
            } else {
                throw new IllegalArgumentException("Unsupported protocol: " + protocol);
            }
            url = url.substring(i + 1);
        }
        if (url.startsWith("//")) {
            i = url.indexOf(47, 2);
            String server = i < 0 ? url.substring(2) : url.substring(2, i);
            this.setServerHost(server, https);
            url = i < 0 ? "" : url.substring(i);
        } else if (this.server_address == null || this.server_port < 1) {
            throw new IllegalStateException("No previous HTTP server address to reuse for this relative URL: " + url);
        }
        this.path = url.length() == 0 ? "/" : url;
        this.openRequest(send_entity, headers);
    }

    public void reopen() throws IOException {
        this.reopenInternal(null, null);
    }

    public void reopen(String s, Map<String, String> headers) throws IOException {
        this.reopenInternal(s == null ? null : s.getBytes(), headers);
    }

    public void reopen(byte[] b, Map<String, String> headers) throws IOException {
        this.reopenInternal(b, headers);
    }

    public void reopen(InputStream in, Map<String, String> headers) throws IOException {
        this.reopenInternal(in, headers);
    }

    private void reopenInternal(Object send_entity, Map<String, String> headers) throws IOException {
        if (this.server_address == null || this.path == null) {
            throw new IllegalStateException("No previous HTTP request to reopen");
        }
        this.openRequest(send_entity, headers);
    }

    private void flushResponse() {
        if (this.request_sent) {
            if (!this.response_parsed) {
                try {
                    this.parseResponse();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.response_in != null) {
                try {
                    this.response_in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.response_in = null;
            }
        }
        this.resetRequestState();
    }

    private String readLine() throws IOException {
        int i = 0;
        char[] buffer = this.line_buffer;
        while (true) {
            int n;
            if ((n = this.in.read()) < 0) {
                throw new IOException("HTTP response interrupted");
            }
            if (n == 13) {
                n = this.in.read();
                if (n < 0) {
                    throw new IOException("HTTP response interrupted");
                }
                if (n != 10) {
                    throw new IOException("Protocol error: invalid line separator");
                }
                return new String(buffer, 0, i);
            }
            if (n == 10) {
                throw new IOException("Protocol error: invalid line separator");
            }
            if (i >= buffer.length) {
                throw new IOException("Protocol error: line too long");
            }
            buffer[i++] = (char)n;
        }
    }

    private void addResponseHeader(StringBuilder sb) throws IOException {
        String line = sb.toString();
        sb.setLength(0);
        int i = line.indexOf(58);
        if (i < 0) {
            throw new IOException("Protocol error: Header separator not found");
        }
        String name = line.substring(0, i).trim();
        String value = line.substring(i + 1).trim();
        String previous = this.response_headers.get(name);
        this.response_headers.put(name, previous == null ? value : previous + ";" + value);
        if (name.equalsIgnoreCase(HEADER_CONNECTION) && value.equalsIgnoreCase("close")) {
            this.will_close = true;
        }
    }

    private void parseResponseHeaders() throws IOException {
        StringBuilder sb = new StringBuilder();
        while (true) {
            String line;
            if ((line = this.readLine()).length() == 0) {
                if (sb.length() <= 0) break;
                this.addResponseHeader(sb);
                break;
            }
            if (" \t".indexOf(line.charAt(0)) >= 0) {
                if (sb.length() == 0) {
                    throw new IOException("Protocol error: continued header line without previous line");
                }
                sb.append(' ');
                sb.append(line.trim());
                continue;
            }
            if (sb.length() > 0) {
                this.addResponseHeader(sb);
            }
            sb.append(line.trim());
        }
    }

    void endOfResponse(boolean final_headers) throws IOException {
        if (final_headers) {
            this.parseResponseHeaders();
        }
        if (this.remaining_request_count == 0) {
            this.closeSocket("Keep-Alive limit exceeded.");
        }
    }

    private void parseResponse() throws IOException {
        try {
            int code;
            this.out.flush();
            this.response_headers = new HashMap<String, String>();
            String line = this.readLine();
            int i = line.indexOf(32);
            if (i < 0) {
                throw new IOException("Protocol error: invalid response line: " + line);
            }
            String http_version = line.substring(0, i);
            if (!http_version.equalsIgnoreCase("HTTP/1.1")) {
                throw new IOException("Protocol error: invalid HTTP protocol version");
            }
            if ((i = (line = line.substring(i + 1).trim()).indexOf(32)) < 0) {
                throw new IOException("Protocol error: invalid response line");
            }
            try {
                code = Integer.parseInt(line.substring(0, i));
                if (code < 100 || code > 599) {
                    throw new NumberFormatException();
                }
                if (code >= 400) {
                    this.will_close = true;
                }
            }
            catch (NumberFormatException nfx) {
                throw new IOException("Protocol error: invalid response code: " + line.substring(0, i));
            }
            this.response_code = code;
            this.response_message = line.substring(i + 1).trim();
            this.parseResponseHeaders();
            EntityInputStream ein = new EntityInputStream();
            String v = this.response_headers.get(HEADER_CONTENT_LENGTH);
            if (v != null) {
                try {
                    long size = Long.parseLong(v.trim());
                    if (size < 0L) {
                        throw new NumberFormatException();
                    }
                    this.response_in = new LimitedInputStream(ein, size);
                }
                catch (NumberFormatException nfx) {
                    throw new IOException("Protocol error: invalid response content length: " + v);
                }
            } else {
                v = this.response_headers.get(HEADER_TRANSFER_ENCODING);
                this.response_in = v != null && v.equalsIgnoreCase("chunked") ? new ChunkedInputStream(this, ein) : new LimitedInputStream(ein, 0L);
            }
            this.response_parsed = true;
        }
        catch (IOException ioex) {
            this.closeSocket("Response I/O error: " + ioex.getMessage());
            throw ioex;
        }
        catch (Exception ex) {
            this.closeSocket("Error: " + ex.getMessage());
        }
    }

    public EwHttpResponse readResponse() throws IOException {
        EwHttpResponse response = new EwHttpResponse();
        this.readResponse(response);
        return response;
    }

    public InputStream readResponse(EwHttpResponse response) throws IOException {
        if (!this.request_sent) {
            throw new IllegalStateException("No request opened");
        }
        if (this.response_in == null) {
            this.parseResponse();
        }
        if (response == null || this.response_headers == null) {
            if (EwHttpResponse.isOk(this.response_code)) {
                return this.response_in;
            }
            throw new IOException("HTTP " + this.response_code + ": " + this.response_message);
        }
        response.headers = new HashMap<String, String>(this.response_headers);
        response.in = this.response_in;
        response.code = this.response_code;
        response.message = this.response_message;
        return response.isOk() ? this.response_in : null;
    }

    static {
        RESERVED_HEADERS = new String[]{HEADER_CONTENT_LENGTH, HEADER_CONNECTION, HEADER_KEEP_ALIVE, HEADER_HOST};
        RESERVED_HEADER_PREFIXES = new String[]{"Accept-"};
        FIRST_HEADERS = new String[][]{{HEADER_USER_AGENT, DEFAULT_USER_AGENT}, {HEADER_ACCEPT, "text/html, text/plain, application/octet-stream"}};
        HTTP_GET = "GET ".getBytes();
        HTTP_POST = "POST ".getBytes();
        HTTP_VERSION = " HTTP/1.1\r\n".getBytes();
        CHUNK_END = "0\r\n\r\n".getBytes();
        NEW_LINE = "\r\n".getBytes();
        HEADER_SEP = ": ".getBytes();
    }

    class EntityInputStream
    extends InputStream {
        InputStream entity_in;

        EntityInputStream() {
            this.entity_in = EwHttpClient.this.in;
        }

        @Override
        public int read() throws IOException {
            return this.entity_in == null ? -1 : this.entity_in.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.entity_in == null ? -1 : this.entity_in.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.entity_in == null ? -1 : this.entity_in.read(b, off, len);
        }

        @Override
        public void close() throws IOException {
            this.entity_in = null;
            EwHttpClient.this.closeSocket("Close entity input caused by I/O error.");
        }
    }
}

