> *Refer to* [*README*](../README.md) *for main instruction file*

# MCOP MCPTT Client

## Installation

### Requirements

* [**MCOP SDK**](https://demo.mcopenplatform.org/gitlist/mcop/MCOP-SDK.git/blob/master/docs/MCOP_SDK_Installation.md) installed on the device.

	* [**Profiles**](Profiles.md) with the network/user configuration.

* [**Mock App**](Mock.md) to bypass the the SIM authentication.

### Download the MCOP MCPTT Demo Client

Clone or download the project:

	$ git clone mcop@demo.mcopenplatform.org:mcop/MCOP-MCPTT-Client.git

Enter the password: Iephieb8

### Install Android Studio

* Android Studio [User Guide](https://developer.android.com/studio/install).

* Download [Android Studio](https://developer.android.com/studio/).

### Install MCOP MCPTT Client

Import the project in Android Studio by selecting **File --> Open:** Select the **MCOP-MCPTT-Client** project folder.

Android **SKD Platform 27** is defined as compilation version. If not installed, a message is shown in Android Studio to *"Install missing platform(s) and sync project"*.

Connect a phone to the computer via USB cable. **USB debugging** mode must be previously activated, on phone *Settings --> Developer Options*. Once connected, click OK on *"Allow USB debugging?"* message.

![Allow USB Debugging](../images/images_allowUSBdebugging.png)

Back on Android Studio, click on run ![Run](../images/images_run.png), select the device to install the app, and click on Install and Continue.

Once installed, allow requested permissions:

![Audio](../images/images_allow1RecordAudio.png) ![Location](../images/images_allow2AccessLocation.png)

![Pictures and Video](../images/images_allow3PicturesVideo.png) ![Phone Calls](../images/images_allow4PhoneCalls.png)

![Device Settings](../images/images_allow5SystemSettings.png)

### Usage

* Everytime the client app is started, a list of user profiles is displayed, in order to select the one to register with. By default some test profiles are loaded.

* **IMPORTANT**: In order to test the MCOP MCPTT Client against our [demo.mcopenplatform.org](https://demo.mcopenplatform.org) testing platform, this profile files need to be configured in the **MCOP SDK** first, and then referenced in the Client. **Full detailed information is available in [Profiles](Profiles.md) documentation**.

* After selecting the the initial configure profile, the client will try to automatically register.

* Once registered, the rest of the button are enabled, and the client is ready to receive and make private or prearranged groups calls.

* The swith button allows to select between private and. prearrange group calls. When pressing (or keeping it pressed) the middle MCOP logo button, a call will be made according to the selected option.

* This middle MCOP logo button also works as push to talk button while on a call, changing the color to show whether the token is taken, granted or idle.

* The spinner button below shows a list of clients or groups to call. The list changes depending on the switch button that activates private or group calls.

* The speaker button allows to enable or dissable the speaker.

* Check [MCOP MCPTT App Development](MCOP_App_developing_steps.md) guide for more info on app development using the MCOP SDK.

### Possible Errors

* If you have SIP related problems, maybe your carrier is SBC/filtering VoIP traffic. Please check the [Troubleshooting - Network Issues](Troubleshooting.md) section for more information.
